#include "nag.h"

#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>	// isatty

#include <cstdlib>

static bool op_verbose = false;
static bool op_debug = false;
static bool op_stdout_isatty = false;

namespace nag {
void init(bool verbose, bool debug)
{
    if (debug) verbose=true;

    op_verbose = verbose;
    op_debug = debug;
    op_stdout_isatty = isatty(1);
}
bool is_verbose() throw() { return op_verbose; }
bool is_debug() throw() { return op_debug; }
}

void fatal_error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    fprintf(stderr, "debtags: ");
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
    fprintf(stderr, "\n");
    exit(1);
}

void error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
}

void warning(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
}

void verbose(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    if (op_verbose)
    {
        va_list ap;
        va_start(ap, fmt);
        vfprintf(stderr, fmt, ap);
        va_end(ap);
    }
}

void debug(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    if (op_debug)
    {
        va_list ap;
        va_start(ap, fmt);
        vfprintf(stderr, fmt, ap);
        va_end(ap);
    }
}

void feedback(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
    if (op_stdout_isatty)
    {
        va_list ap;
        va_start(ap, fmt);
        vfprintf(stdout, fmt, ap);
        va_end(ap);
    }
}

