/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.baq;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.broadinstitute.gatk.engine.iterators.GATKSAMIterator;
import org.broadinstitute.gatk.engine.iterators.ReadTransformer;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class ReadTransformingIterator
implements GATKSAMIterator {
    private final GATKSAMIterator it;
    private final ReadTransformer transformer;

    @Requires(value={"it != null", "transformer != null", "transformer.isInitialized()"})
    public ReadTransformingIterator(GATKSAMIterator it, ReadTransformer transformer) {
        if (!transformer.isInitialized()) {
            throw new IllegalStateException("Creating a read transformer stream for an uninitialized read transformer: " + transformer);
        }
        if (transformer.getApplicationTime() == ReadTransformer.ApplicationTime.FORBIDDEN) {
            throw new IllegalStateException("Creating a read transformer stream for a forbidden transformer " + transformer);
        }
        this.it = it;
        this.transformer = transformer;
    }

    @Requires(value={"hasNext()"})
    @Ensures(value={"result != null"})
    public SAMRecord next() {
        GATKSAMRecord read = (GATKSAMRecord)this.it.next();
        return this.transformer.apply(read);
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void close() {
        this.it.close();
    }

    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

