/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSCONCRETEDEPENDENCYACCESS_H_
#define OPENDRIM_BIOSCONCRETEDEPENDENCYACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_BIOSConcreteDependency.h"
#include "assocOpenDRIM_BIOSConcreteDependency.h"

int BIOS_OpenDRIM_BIOSConcreteDependency_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_unload(string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BIOSConcreteDependency>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteDependency_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BIOSConcreteDependency& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteDependency& newInstance, const OpenDRIM_BIOSConcreteDependency& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteDependency& instance, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteDependency& instance, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteDependency_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteDependency_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteDependency_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_BIOSConcreteDependency>& OpenDRIM_BIOSConcreteDependency_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteDependency_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_BIOSConcreteDependency>& OpenDRIM_BIOSConcreteDependency_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteDependency_populate(OpenDRIM_BIOSConcreteDependency& instance, string& errorMessage);

#endif /*OPENDRIM_BIOSCONCRETEDEPENDENCYACCESS_H_*/
