/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PowerManagementService.h"
#include "OpenDRIM_PowerManagementServiceAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define PowerManagement_OpenDRIM_PowerManagementServiceProviderSetInstance PowerManagement_OpenDRIM_PowerManagementServiceProviderModifyInstance
#endif

int PowerManagement_OpenDRIM_PowerManagementService_init(const CMPIBroker* broker);

int PowerManagement_OpenDRIM_PowerManagementService_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PowerManagementService> instances;
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = PowerManagement_OpenDRIM_PowerManagementService_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_PowerManagementService> instances;
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = PowerManagement_OpenDRIM_PowerManagementService_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PowerManagementService instance;
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = PowerManagement_OpenDRIM_PowerManagementService_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PowerManagementService newInstance, oldInstance;
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, ci, newInstance);
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PowerManagement_OpenDRIM_PowerManagementService_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PowerManagementService instance;
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PowerManagement_OpenDRIM_PowerManagementService_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = PowerManagement_OpenDRIM_PowerManagementService_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PowerManagementService instance;
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = PowerManagement_OpenDRIM_PowerManagementService_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus PowerManagement_OpenDRIM_PowerManagementServiceProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_PowerManagementService instance;
	PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"SystemCreationClassName", "Name", "SystemName", "CreationClassName"};
	int errorCode = PowerManagement_OpenDRIM_PowerManagementService_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_PowerManagementService_RequestStateChange_In inArgs;
		PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, in, inArgs);
		OpenDRIM_PowerManagementService_RequestStateChange_Out outArgs;
		
		errorCode = PowerManagement_OpenDRIM_PowerManagementService_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		PowerManagement_OpenDRIM_PowerManagementService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StartService") {
		unsigned int returnValue;
		
		errorCode = PowerManagement_OpenDRIM_PowerManagementService_StartService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="StopService") {
		unsigned int returnValue;
		
		errorCode = PowerManagement_OpenDRIM_PowerManagementService_StopService(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="SetPowerState") {
		unsigned int returnValue;
		OpenDRIM_PowerManagementService_SetPowerState_In inArgs;
		PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, in, inArgs);
		
		errorCode = PowerManagement_OpenDRIM_PowerManagementService_SetPowerState(_broker, ctx, instance, returnValue, inArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="RequestPowerStateChange") {
		unsigned int returnValue;
		OpenDRIM_PowerManagementService_RequestPowerStateChange_In inArgs;
		PowerManagement_OpenDRIM_PowerManagementService_toCPP(_broker, in, inArgs);
		OpenDRIM_PowerManagementService_RequestPowerStateChange_Out outArgs;
		
		errorCode = PowerManagement_OpenDRIM_PowerManagementService_RequestPowerStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		PowerManagement_OpenDRIM_PowerManagementService_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int PowerManagement_OpenDRIM_PowerManagementService_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = PowerManagement_OpenDRIM_PowerManagementService_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "PowerManagement_OpenDRIM_PowerManagementService_init FAILED: " + (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementService_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = PowerManagement_OpenDRIM_PowerManagementService_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "PowerManagement_OpenDRIM_PowerManagementService_unload FAILED: " + (string) OpenDRIM_PowerManagementService_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define PowerManagement_OpenDRIM_PowerManagementService_INIT if (PowerManagement_OpenDRIM_PowerManagementService_init(_broker) < 0) return NULL

CMInstanceMIStub(PowerManagement_OpenDRIM_PowerManagementServiceProvider, PowerManagement_OpenDRIM_PowerManagementServiceProvider, _broker, PowerManagement_OpenDRIM_PowerManagementService_INIT);
CMMethodMIStub(PowerManagement_OpenDRIM_PowerManagementServiceProvider, PowerManagement_OpenDRIM_PowerManagementServiceProvider, _broker, PowerManagement_OpenDRIM_PowerManagementService_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
