/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  All currently known fields in V4.0/V4.1 GFFs.
 */

#ifndef AURORA_GFF4FIELDS_H
#define AURORA_GFF4FIELDS_H

namespace Aurora {

namespace GFF4FieldNamesEnum {

enum GFF4FieldNames {
	kGFF4Tag                                             =      1,
	kGFF4Name                                            =      2,
	kGFF4TemplateResRef                                  =      3,
	kGFF4Position                                        =      4,
	kGFF4Orientation                                     =      5,
	kGFF4Uint8List                                       =      6,
	kGFF4Int8List                                        =      7,
	kGFF4Uint16List                                      =      8,
	kGFF4Int16List                                       =      9,
	kGFF4Uint32List                                      =     10,
	kGFF4Int32List                                       =     11,
	kGFF4Uint64List                                      =     12,
	kGFF4Int64List                                       =     13,
	kGFF4Float32List                                     =     14,
	kGFF4Float64List                                     =     15,
	kGFF4Vector3fList                                    =     16,
	kGFF4Vector4fList                                    =     17,
	kGFF4QuaternionfList                                 =     18,
	kGFF4EcstringList                                    =     19,
	kGFF4Color4fList                                     =     20,
	kGFF4NameHash                                        =     21,
	kGFF4Text                                            =     22,
	kGFF4ObjectID                                        =     23,

	kGFF4TsProperty                                      =    900,
	kGFF4TsPropertyName                                  =    901,
	kGFF4TsPropertyAtom                                  =    902,
	kGFF4TsPropertyValue                                 =    903,
	kGFF4TsPropertyChildren                              =    904,
	kGFF4TsPropertyVartype                               =    905,

	kGFF4ItemBaseID                                      =   1000,
	kGFF4ItemCost                                        =   1001,
	kGFF4ItemStackSize                                   =   1002,
	kGFF4ItemStolen                                      =   1003,
	kGFF4ItemPlot                                        =   1004,
	kGFF4ItemIDentified                                  =   1005,
	kGFF4ItemCharges                                     =   1006,
	kGFF4ItemModelVariation                              =   1007,
	kGFF4ItemDescription                                 =   1008,
	kGFF4ItemPropertyList                                =   1009,
	kGFF4ItemMaterial                                    =   1010,
	kGFF4ItemAbilityID                                   =   1011,
	kGFF4ItemAbilityPwr                                  =   1012,
	kGFF4ItemProperties                                  =   1013,
	kGFF4ItemPropertyPowers                              =   1014,
	kGFF4ItemPropertyEffectID                            =   1015,
	kGFF4ItemPropertyVFXID                               =   1018,
	kGFF4ItemSubitemsResRefs                             =   1019,
	kGFF4ItemCraftingRecipeID                            =   1020,
	kGFF4ItemBaseCost                                    =   1021,

	kGFF4ItemPropParam1                                  =   2000,
	kGFF4ItemPropPropertyName                            =   2001,
	kGFF4ItemPropSubType                                 =   2002,
	kGFF4ItemPropCostTable                               =   2003,
	kGFF4ItemPropCostValue                               =   2004,
	kGFF4ItemPropParam1Value                             =   2005,
	kGFF4ItemPropChanceAppear                            =   2006,

	kGFF4EnvWorld                                        =   3000,
	kGFF4EnvWorldName                                    =   3001,
	kGFF4EnvWorldAreaList                                =   3002,
	kGFF4LvlChildList                                    =   3003,
	kGFF4LvlFileObjectVersion                            =   3004,
	kGFF4LvlChangeTime                                   =   3005,

	kGFF4EnvArea                                         =   3010,
	kGFF4EnvAreaID                                       =   3011,
	kGFF4EnvAreaName                                     =   3012,
	kGFF4EnvAreaFile                                     =   3013,
	kGFF4EnvAreaEnvironmentSettings                      =   3014,
	kGFF4EnvAreaNavigationInfoFile                       =   3015,
	kGFF4EnvAreaRoomList                                 =   3016,
	kGFF4EnvAreaRoomListElement                          =   3017,
	kGFF4EnvAreaPosition                                 =   3018,
	kGFF4EnvAreaRotation                                 =   3019,
	kGFF4EnvAreaPathfindExport                           =   3020,
	kGFF4EnvAreaPathfindVisInfo                          =   3021,
	kGFF4EnvAreaPathfindVisinfoCount                     =   3022,
	kGFF4EnvAreaFrameBufEffect                           =   3023,
	kGFF4EnvAreaCenter                                   =   3024,
	kGFF4EnvAreaSkydomeModel                             =   3025,
	kGFF4EnvAreaFrameBufEffectList                       =   3026,
	kGFF4EnvAreaGlobalwindResRef                         =   3027,
	kGFF4EnvAreaLocalwindList                            =   3028,
	kGFF4EnvAreaPathfindCosts                            =   3029,

	kGFF4EnvRoom                                         =   3030,
	kGFF4EnvRoomID                                       =   3031,
	kGFF4EnvRoomName                                     =   3032,
	kGFF4EnvRoomFile                                     =   3033,
	kGFF4EnvRoomEnvironmentSettings                      =   3034,
	kGFF4EnvRoomPosition                                 =   3035,
	kGFF4EnvRoomRotation                                 =   3036,
	kGFF4EnvRoomPathfindGridSep                          =   3037,
	kGFF4EnvRoomPathfindCharHeight                       =   3038,
	kGFF4EnvRoomPathfindClearance                        =   3039,
	kGFF4EnvRoomPathfindExport                           =   3040,
	kGFF4EnvRoomPathfindVisInfo                          =   3041,
	kGFF4EnvRoomPathfindVisInfoCount                     =   3042,
	kGFF4EnvRoomPathGridFile                             =   3043,
	kGFF4EnvRoomPathConnectionList                       =   3044,
	kGFF4EnvRoomPathConnection                           =   3045,
	kGFF4EnvRoomPathConnectionID                         =   3046,
	kGFF4EnvRoomVisibilityList                           =   3047,
	kGFF4EnvRoomVisibility                               =   3048,
	kGFF4EnvRoomVisibilityID                             =   3049,
	kGFF4EnvRoomModelList                                =   3050,
	kGFF4EnvRoomLightList                                =   3051,
	kGFF4EnvRoomModelListElement                         =   3052,
	kGFF4EnvRoomLightListElement                         =   3053,
	kGFF4EnvRoomDynShadowDirection                       =   3054,
	kGFF4EnvRoomDynShadowEnabled                         =   3055,

	kGFF4EnvModelPathfindOverlapped                      =   3056,
	kGFF4EnvModelShowHighLod                             =   3057,
	kGFF4EnvModelSnapToTerrain                           =   3058,
	kGFF4EnvModelScale                                   =   3059,

	kGFF4EnvModel                                        =   3060,
	kGFF4EnvModelID                                      =   3061,
	kGFF4EnvModelName                                    =   3062,
	kGFF4EnvModelFile                                    =   3063,
	kGFF4EnvModelPosition                                =   3064,
	kGFF4EnvModelRotation                                =   3065,
	kGFF4EnvModelPathfindNormal                          =   3066,

	kGFF4EnvLight                                        =   3067,
	kGFF4EnvLightID                                      =   3068,
	kGFF4EnvLightName                                    =   3069,
	kGFF4EnvLightPosition                                =   3070,
	kGFF4EnvLightRotation                                =   3071,
	kGFF4LightColor                                      =   3072,
	kGFF4LightIsDynamic                                  =   3073,
	kGFF4LightType                                       =   3074,
	kGFF4LightPointRadius                                =   3075,
	kGFF4LightColorMultiplier                            =   3076,
	kGFF4LightBaked                                      =   3077,
	kGFF4LightEffect                                     =   3078,
	kGFF4LightAffectDomain                               =   3079,

	kGFF4AreaGridNavInfo                                 =   3080,
	kGFF4AreaGridRoomName                                =   3081,
	kGFF4AreaGridGridNavInfo                             =   3082,
	kGFF4AreaGridModelGrid                               =   3083,
	kGFF4AreaGridGridID                                  =   3084,
	kGFF4AreaGridModelID                                 =   3085,
	kGFF4AreaGridNbColumns                               =   3086,
	kGFF4AreaGridNbRows                                  =   3087,
	kGFF4AreaGridCellSize                                =   3088,
	kGFF4AreaGridClearance                               =   3089,
	kGFF4AreaGridBasePos                                 =   3090,
	kGFF4AreaGridNormal                                  =   3091,
	kGFF4AreaGridData                                    =   3092,
	kGFF4AreaGridHeight                                  =   3093,
	kGFF4AreaGridAbstractSectorSize                      =   3094,
	kGFF4AreaGridAbstractSectors                         =   3095,
	kGFF4AreaGridAbstractMemory                          =   3096,
	kGFF4AreaGridID                                      =   3097,
	kGFF4AreaGridCellID                                  =   3098,

	kGFF4EnvRoomConnectivityList                         =   3099,

	kGFF4LightSpotInnerAngle                             =   3100,
	kGFF4LightSpotOuterAngle                             =   3101,
	kGFF4LightSpotDistance                               =   3102,

	kGFF4EnvLightProbe                                   =   3103,
	kGFF4EnvLightProbeEnvMap                             =   3104,

	kGFF4EnvLightNumSamples                              =   3105,
	kGFF4EnvLightSize                                    =   3106,
	kGFF4DynamicShadowVectorGame                         =   3107,

	kGFF4EnvLightProbeID                                 =   3108,

	kGFF4EnvModelCutAwayOverride                         =   3109,

	kGFF4AreaGridArea                                    =   3110,

	kGFF4AreaGridSoundData                               =   3114,
	kGFF4AreaGridAbstractionSNumReg                      =   3115,
	kGFF4AreaGridAbstractionSaddr                        =   3116,

	kGFF4AreaGridLightSubsetData8                        =   3117,
	kGFF4AreaGridLightSubsetData16                       =   3118,

	kGFF4LightCanBeOccluded                              =   3119,

	kGFF4AreaGridCellPadding                             =   3120,

	kGFF4AreaGridAreaID                                  =   3111,
	kGFF4AreaGridRooms                                   =   3112,
	kGFF4AreaGridRoom                                    =   3113,
	kGFF4AreaGridRoomID                                  =   3114,
	kGFF4AreaGridRoomNumberOfLinks                       =   3115,
	kGFF4AreaGridLinks                                   =   3116,
	kGFF4AreaGridLink                                    =   3117,
	kGFF4AreaGridLinkID                                  =   3118,
	kGFF4AreaGridLinkCellID                              =   3119,
	kGFF4AreaGridLinkRoomID                              =   3120,
	kGFF4AreaGridLinkNeighborIDs                         =   3121,

	kGFF4EnvAreaChunkIsChunk                             =   3122,
	kGFF4EnvAreaChunkRowCount                            =   3123,
	kGFF4EnvAreaChunkColCount                            =   3124,
	kGFF4EnvAreaChunkWidth                               =   3125,
	kGFF4EnvAreaChunkHeight                              =   3126,
	kGFF4EnvAreaLayoutName                               =   3127,
	kGFF4EnvAreaStartPointName                           =   3128,
	kGFF4EnvAreaCutoffHeight                             =   3129,

	kGFF4LightAnimatedMinFrequency                       =   3130,
	kGFF4LightAnimatedMaxFrequency                       =   3131,
	kGFF4LightAnimatedMinIntensity                       =   3132,
	kGFF4LightAnimatedMaxIntensity                       =   3133,

	kGFF4EnvAreaCutoffSystemEnabled                      =   3134,

	kGFF4EnvMinimapTextureMapCoords                      =   3137,
	kGFF4EnvMinimapLowerLeftPoint                        =   3138,
	kGFF4EnvMinimapUpperRightPoint                       =   3139,

	kGFF4EnvRoomLowerLeftPoint                           =   3140,
	kGFF4EnvRoomUpperRightPoint                          =   3141,
	kGFF4EnvAreaForceCharacterLighting                   =   3142,

	kGFF4EnvAreaSunlightCanBeOccludedChar                =   3148,
	kGFF4EnvAreaSunlightColorChar                        =   3149,
	kGFF4EnvAreaSunlightDirection                        =   3150,
	kGFF4EnvAreaSunlightEnabled                          =   3151,
	kGFF4EnvAreaSunlightColor                            =   3152,
	kGFF4EnvAreaSunlightColorMult                        =   3153,

	kGFF4TerrainChunk                                    =   3154,
	kGFF4TerrainChunkList                                =   3155,
	kGFF4TerrainChunkCellPositionX                       =   3156,
	kGFF4TerrainChunkCellPositionY                       =   3157,
	kGFF4TerrainChunkLength                              =   3158,
	kGFF4TerrainChunkWidth                               =   3159,
	kGFF4TerrainChunkTexelSize                           =   3160,
	kGFF4TerrainChunkBlendpageSize                       =   3161,
	kGFF4TerrainChunkSectorID                            =   3162,
	kGFF4EnvAreaSunlightRotation                         =   3163,

	kGFF4EnvRoomLightVisList                             =   3164,
	kGFF4EnvFogColor                                     =   3165,
	kGFF4EnvFogMaxDistance                               =   3166,
	kGFF4EnvFogMaxIntensity                              =   3167,
	kGFF4EnvFogEnabled                                   =   3168,
	kGFF4EnvFogMinDistance                               =   3169,

	kGFF4EnvModelNameChanged                             =   3170,

	kGFF4EnvVegetation                                   =   3171,
	kGFF4EnvCreature                                     =   3172,

	kGFF4EnvCamera                                       =   3200,
	kGFF4EnvCameraPivotDistance                          =   3201,
	kGFF4EnvStandalone                                   =   3202,
	kGFF4EnvListArea                                     =   3202,
	kGFF4EnvListRoom                                     =   3203,
	kGFF4EnvListModel                                    =   3204,
	kGFF4EnvListLight                                    =   3205,

	kGFF4EnvPfContainerLayoutName                        =   3210,
	kGFF4EnvPfContainerExportData                        =   3211,
	kGFF4EnvPfContainerDataVersion                       =   3212,
	kGFF4EnvPfContainerVisInfo                           =   3213,

	kGFF4RimTreeRootNode                                 =   3290,
	kGFF4RimTreeRimList                                  =   3291,
	kGFF4RimTreeChildList                                =   3292,
	kGFF4RimTreeNodeTag                                  =   3293,
	kGFF4RimTreeNodeResRef                               =   3294,

	kGFF4EnvGroup                                        =   3300,
	kGFF4EnvGroupName                                    =   3301,

	kGFF4EnvSpGroup                                      =   3302,
	kGFF4EnvSpGroupName                                  =   3303,
	kGFF4EnvSp                                           =   3304,
	kGFF4EnvSpFile                                       =   3305,

	kGFF4EnvObjectVisible                                =   3310,
	kGFF4EnvObjectLockSelection                          =   3311,

	kGFF4EnvModelInstanceID                              =   3320,
	kGFF4EnvModelBoundsCenter                            =   3321,
	kGFF4EnvModelBoundsRadius                            =   3322,
	kGFF4EnvModelLightmapAtlas                           =   3323,
	kGFF4EnvModelLightmapOffsetScale                     =   3324,
	kGFF4EnvModelLightmapPartID                          =   3235,
	kGFF4EnvModelLightmapAtlasList                       =   3326,

	kGFF4LvlLightmapSizeMultiplier                       =   3330,

	kGFF4LvlLightmapLastUpdatedList                      =   3331,
	kGFF4LvlLightmapLastUpdated                          =   3332,
	kGFF4LvlLightmapFilespec                             =   3333,
	kGFF4LvlLightingVersion                              =   3334,

	kGFF4LvlAoColorMin                                   =   3340,
	kGFF4LvlAoColorMax                                   =   3341,
	kGFF4LvlAoSamplesMin                                 =   3342,
	kGFF4LvlAoSamplesMax                                 =   3343,
	kGFF4LvlAoAdaptsampleEnabled                         =   3344,
	kGFF4LvlAoAdaptsampleAccuracy                        =   3345,
	kGFF4LvlAoAdaptsampleSmooth                          =   3346,
	kGFF4LvlAoConeAngle                                  =   3347,
	kGFF4LvlAoMaxRayLength                               =   3348,
	kGFF4LvlAoExponent                                   =   3349,

	kGFF4EnvTree                                         =   3350,
	kGFF4EnvTreenodeID                                   =   3351,
	kGFF4EnvTreeName                                     =   3352,
	kGFF4EnvTreeFile                                     =   3353,
	kGFF4EnvRoomTreenodeList                             =   3354,
	kGFF4EnvAreaTreecontrollerList                       =   3355,
	kGFF4EnvTreeScale                                    =   3356,
	kGFF4EnvAreaTreecontrollerID                         =   3357,
	kGFF4EnvTreePaintedList                              =   3358,
	kGFF4EnvTreePaintedPosition                          =   3359,
	kGFF4EnvTreePaintedRotation                          =   3360,
	kGFF4EnvTreePaintedScale                             =   3361,
	kGFF4EnvScatterObjects                               =   3362,
	kGFF4EnvScatterObjectFile                            =   3363,
	kGFF4EnvScatterInstance                              =   3364,
	kGFF4EnvScatterInstanceList                          =   3365,
	kGFF4EnvScatterObjectList                            =   3366,
	kGFF4EnvScatterObjectID                              =   3367,
	kGFF4EnvScatterObjIgnoreMaxDensity                   =   3368,
	kGFF4EnvScatterObjMaxDensity                         =   3369,
	kGFF4EnvScatterObjMinScale                           =   3370,
	kGFF4EnvScatterObjMaxScale                           =   3371,
	kGFF4EnvScatterObjOrient                             =   3372,
	kGFF4EnvScatterObjPrototype                          =   3373,
	kGFF4EnvScatterObjMsiData                            =   3374,
	kGFF4EnvTreeColorTint                                =   3375,
	kGFF4EnvScatterobjSoundType                          =   3376,
	kGFF4EnvTreeColorLevelTint                           =   3377,
	kGFF4EnvTreeColorLevelIntensity                      =   3378,
	kGFF4EnvTreeDrawDistance                             =   3379,

	kGFF4TerrainExportArea                               =   3400,
	kGFF4TerrainExportAreaList                           =   3401,
	kGFF4TerrainAreaCellPositionX                        =   3403,
	kGFF4TerrainAreaCellPositionY                        =   3404,
	kGFF4TerrainAreaCellPositionZ                        =   3405,
	kGFF4TerrainAreaCellSizeX                            =   3406,
	kGFF4TerrainAreaCellSizeY                            =   3407,
	kGFF4TerrainAreaCellSizeZ                            =   3408,
	kGFF4TerrainAreaBorderCellWidth                      =   3409,
	kGFF4TerrainAreaVistaCellWidth                       =   3410,
	kGFF4TerrainAreaLightmapSize                         =   3411,
	kGFF4TerrainAreaLightmapSizeVista                    =   3412,
	kGFF4TerrainAreaSubdivideBy                          =   3413,

	kGFF4EnvModelPartGroup                               =   3500,
	kGFF4EnvModelLightmapOnly                            =   3501,
	kGFF4EnvModelLightmapFlag                            =   3502,
	kGFF4EnvModelExportFlag                              =   3503,
	kGFF4EnvModelDefaultAnimation                        =   3504,
	kGFF4EnvModelBlendTreeName                           =   3505,
	kGFF4EnvModelUserParamList                           =   3506,
	kGFF4EnvModelUserParamName                           =   3507,
	kGFF4EnvModelUserParamValue                          =   3508,

	kGFF4LvlWater                                        =   3600,
	kGFF4LvlWaterSizeX                                   =   3601,
	kGFF4LvlWaterSizeY                                   =   3602,
	kGFF4LvlWaterMaxTessellation                         =   3603,
	kGFF4LvlWaterMeshID                                  =   3604,
	kGFF4LvlWaterNormalMap                               =   3605,
	kGFF4LvlWaterHeightMap                               =   3606,
	kGFF4LvlWaterDeepColor                               =   3607,
	kGFF4LvlWaterShallowColor                            =   3608,
	kGFF4LvlWaterWaveFreq1                               =   3609,
	kGFF4LvlWaterWaveAmpl1                               =   3610,
	kGFF4LvlWaterWaveDirection1                          =   3611,
	kGFF4LvlWaterWaveSpeed1                              =   3618,
	kGFF4LvlWaterWaveFreq2                               =   3612,
	kGFF4LvlWaterWaveAmpl2                               =   3613,
	kGFF4LvlWaterWaveDirection2                          =   3614,
	kGFF4LvlWaterWaveSpeed2                              =   3619,
	kGFF4LvlWaterWaveFreq3                               =   3615,
	kGFF4LvlWaterWaveAmpl3                               =   3616,
	kGFF4LvlWaterWaveDirection3                          =   3617,
	kGFF4LvlWaterWaveSpeed3                              =   3620,
	kGFF4LvlWaterReflectivity                            =   3621,
	kGFF4LvlWaterFoamHeight                              =   3622,
	kGFF4LvlWaterSubdivDepthTolerance                    =   3623,
	kGFF4LvlWaterShallowDepth                            =   3624,
	kGFF4LvlWaterFoamColor                               =   3625,
	kGFF4LvlWaterWalkableDepth                           =   3626,
	kGFF4LvlWaterWallHeight                              =   3627,
	kGFF4LvlWaterOpacityFalloff                          =   3628,
	kGFF4LvlWaterSunlightSpecularPower                   =   3629,
	kGFF4LvlWaterSpecularMultiplier                      =   3630,
	kGFF4LvlWaterSpecularFalloff                         =   3631,
	kGFF4LvlWaterColorizeTransparency                    =   3632,
	kGFF4LvlWaterOverrideReflection                      =   3633,
	kGFF4LvlWaterEnableSpec                              =   3634,

	kGFF4LvlWind                                         =   3700,
	kGFF4LvlWindID                                       =   3701,
	kGFF4LvlWindName                                     =   3702,
	kGFF4LvlWindIsGlobal                                 =   3710,
	kGFF4LvlWindRegionRadius                             =   3711,
	kGFF4LvlWindRegionFalloff                            =   3712,
	kGFF4LvlWindSptStrength                              =   3713,
	kGFF4LvlWindSptGustMinPercent                        =   3714,
	kGFF4LvlWindSptGustMaxPercent                        =   3715,
	kGFF4LvlWindSptGustMinDuration                       =   3716,
	kGFF4LvlWindSptGustMaxDuration                       =   3717,
	kGFF4LvlWindSptBendAngle                             =   3718,
	kGFF4LvlWindClothResponse                            =   3719,
	kGFF4LvlWindClothResponseLmt                         =   3720,
	kGFF4LvlWindClothStrength                            =   3721,
	kGFF4LvlWindClothGustStrengthMin                     =   3722,
	kGFF4LvlWindClothGustStrengthMax                     =   3723,
	kGFF4LvlWindClothGustDurationMin                     =   3724,
	kGFF4LvlWindClothGustDurationMax                     =   3725,
	kGFF4LvlWindClothGustIntervalMin                     =   3726,
	kGFF4LvlWindClothGustIntervalMax                     =   3727,
	kGFF4LvlWindClothGustDirChange                       =   3728,
	kGFF4LvlWindClothGustAxisRatio                       =   3729,
	kGFF4LvlWindSptGustFrequency                         =   3730,

	kGFF4LvlCollisionWallInfo                            =   3730,
	kGFF4LvlCollisionWallVerticies                       =   3731,
	kGFF4LvlCollisionWallVerticiesV2                     =   3732,

	kGFF4LvlMinimapPositionX                             =   3740,
	kGFF4LvlMinimapPositionY                             =   3741,
	kGFF4LvlMinimapSizeX                                 =   3742,
	kGFF4LvlMinimapSizeY                                 =   3743,

	kGFF4EnvStatPhys                                     =   3744,
	kGFF4EnvStatPhysData                                 =   3745,

	kGFF4LvlLightSubsetList                              =   3800,
	kGFF4LvlLightSubsetEntry                             =   3801,
	kGFF4LvlLightSubsetTotalEntries                      =   3802,

	kGFF4AnimationNodeName                               =   4000,
	kGFF4AnimationTarget                                 =   4001,
	kGFF4AnimationSourceType                             =   4002,
	kGFF4AnimationElementsPerEntry                       =   4003,
	kGFF4AnimationNodeData                               =   4004,
	kGFF4AnimationNodeList                               =   4005,
	kGFF4AnimationName                                   =   4006,
	kGFF4AnimationGeneralAnimName                        =   4007,
	kGFF4AnimationHasGobAnim                             =   4008,
	kGFF4AnimationAnimLength                             =   4009,
	kGFF4AnimationCombatRange                            =   4010,
	kGFF4AnimationIsAdditive                             =   4011,
	kGFF4AnimationIsOverride                             =   4012,
	kGFF4AnimationOverridePriority                       =   4013,
	kGFF4AnimationNameHash                               =   4014,
	kGFF4AnimationNodeNameHash                           =   4015,
	kGFF4AnimationEventTime                              =   4016,
	kGFF4AnimationEventID                                =   4017,
	kGFF4AnimationEventTarget                            =   4018,
	kGFF4AnimationEventString                            =   4019,
	kGFF4AnimationEventList                              =   4020,
	kGFF4AnimationTree                                   =   4021,
	kGFF4AnimationTreeName                               =   4022,
	kGFF4AnimationTreeNode                               =   4023,
	kGFF4AnimationTreeNodeName                           =   4024,
	kGFF4AnimationTreeNodeFile                           =   4025,
	kGFF4AnimationTreeNodeWeight                         =   4026,
	kGFF4AnimationTreeNodeFlags                          =   4027,
	kGFF4AnimationTreeNodeFirstChild                     =   4028,
	kGFF4AnimationTreeNodeNumChildren                    =   4029,
	kGFF4AnimationTreeNodeParent                         =   4030,
	kGFF4AnimationBlendcurveAnimFrom                     =   4031,
	kGFF4AnimationBlendcurveAnimTo                       =   4032,
	kGFF4AnimationBlendcurveData                         =   4033,
	kGFF4AnimationBlendcurveList                         =   4034,
	kGFF4AnimationKeyTime                                =   4035,
	kGFF4AnimationKeyData0                               =   4036,
	kGFF4AnimationKeyData1                               =   4037,
	kGFF4AnimationKeyData2                               =   4038,
	kGFF4AnimationKeyData3                               =   4039,
	kGFF4AnimationIgnoreScale                            =   4040,

	kGFF4CutsceneRunTime                                 =   5000,
	kGFF4CutsceneEndScript                               =   5001,
	kGFF4CutsceneLayout                                  =   5002,
	kGFF4CutscenePosition                                =   5003,
	kGFF4CutsceneOrientation                             =   5004,
	kGFF4CutsceneTransitionTime                          =   5005,
	kGFF4CutsceneFov                                     =   5006,
	kGFF4CutsceneBlendtree                               =   5007,
	kGFF4CutsceneAnimatic                                =   5008,
	kGFF4CutsceneShowAreaDynamics                        =   5009,
	kGFF4CutsceneStaged                                  =   5010,
	kGFF4CutsceneLodCurves                               =   5011,
	kGFF4CutsceneAnimSoundEvents                         =   5012,
	kGFF4CutsceneEnableLevelFbes                         =   5013,
	kGFF4CutsceneLodOriginPos                            =   5014,
	kGFF4CutsceneLodOriginOri                            =   5015,
	kGFF4CutsceneFPS                                     =   5016,
	kGFF4CutsceneStageResRef                             =   5017,
	kGFF4CutscenePlayUntilVoCompletes                    =   5018,
	kGFF4CutsceneAreaRequired                            =   5019,
	kGFF4CutsceneShadowRadius                            =   5020,
	kGFF4CutsceneLightOcclusion                          =   5021,

	kGFF4CutsceneHenchmanTag                             =   5050,
	kGFF4CutsceneHenchmanActions                         =   5051,

	kGFF4CutsceneResources                               =   5100,
	kGFF4CutsceneResourceResRef                          =   5101,
	kGFF4CutsceneResourceType                            =   5102,

	kGFF4CutsceneActors                                  =   5200,
	kGFF4CutsceneActorID                                 =   5201,
	kGFF4CutsceneActorModelResRef                        =   5202,
	kGFF4CutsceneActorDeprecated1                        =   5203,
	kGFF4CutsceneActorDeprecated2                        =   5204,
	kGFF4CutsceneActorDeprecated3                        =   5205,
	kGFF4CutsceneActorActionQueue                        =   5206,
	kGFF4CutsceneActorDeprecated4                        =   5207,
	kGFF4CutsceneActorCreatureResRef                     =   5208,
	kGFF4CutsceneActorCameraTarget                       =   5209,
	kGFF4CutsceneActorUsePose                            =   5210,
	kGFF4CutsceneActorPose                               =   5211,
	kGFF4CutsceneActorPoseSpeed                          =   5212,
	kGFF4CutsceneActorPoseHumanoid                       =   5213,
	kGFF4CutsceneActorOriginPos                          =   5214,
	kGFF4CutsceneActorOriginOri                          =   5215,
	kGFF4CutsceneActorMappingTag                         =   5216,
	kGFF4CutsceneActorInventory                          =   5217,
	kGFF4CutsceneActorTransitionDelay                    =   5218,
	kGFF4CutsceneActorPreviousPose                       =   5219,
	kGFF4CutsceneActorMappingRequired                    =   5220,
	kGFF4CutsceneActorFinalPos                           =   5221,
	kGFF4CutsceneActorFinalOri                           =   5222,
	kGFF4CutsceneActorMaster                             =   5223,
	kGFF4CutsceneActorLod                                =   5224,
	kGFF4CutsceneActorAmbientAnim                        =   5225,
	kGFF4CutsceneActorModelScale                         =   5226,

	kGFF4CutsceneActionType                              =   5300,
	kGFF4CutsceneActionStartTime                         =   5301,
	kGFF4CutsceneActionStopTime                          =   5302,
	kGFF4CutsceneActionCurves                            =   5303,
	kGFF4CutsceneActionCategory                          =   5304,

	kGFF4CutsceneActionCurveBaseValue                    =   5350,
	kGFF4CutsceneActionCurveVertices                     =   5351,
	kGFF4CutsceneActionCurveTransitions                  =   5352,
	kGFF4CutsceneActionCurveDeprecated                   =   5353,

	kGFF4CutsceneActionCurveVertexTime                   =   5370,
	kGFF4CutsceneActionCurveVertexValue                  =   5371,

	kGFF4CutsceneActionCurveTransType                    =   5380,
	kGFF4CutsceneActionCurveTransControl1                =   5381,
	kGFF4CutsceneActionCurveTransControl2                =   5382,

	kGFF4CutsceneActionAnimAnimationName                 =   5400,
	kGFF4CutsceneActionAnimBlendtreeName                 =   5401,
	kGFF4CutsceneActionAnimSpeed                         =   5402,
	kGFF4CutsceneActionAnimStartOffset                   =   5403,
	kGFF4CutsceneActionAnimDeprecated1                   =   5404,
	kGFF4CutsceneActionAnimPlayGad                       =   5405,
	kGFF4CutsceneActionAnimPoseAnimation                 =   5406,
	kGFF4CutsceneActionAnimLinkToMovement                =   5407,
	kGFF4CutsceneActionAnimGadKeysPos                    =   5408,
	kGFF4CutsceneActionAnimGadKeysOri                    =   5409,
	kGFF4CutsceneActionAnimBlendGad                      =   5410,
	kGFF4CutsceneActionAnimExtendGad                     =   5411,
	kGFF4CutsceneActionAnimLinkToMoveDist                =   5412,
	kGFF4CutsceneActionAnimApplyFutureGads               =   5413,

	kGFF4CutsceneActionFrameBufEffectFileName            =   5520,
	kGFF4CutsceneActionFrameBufEffectEffectName          =   5521,
	kGFF4CutsceneActionFrameBufEffectParamList           =   5522,
	kGFF4CutsceneActionFrameBufEffectParamName           =   5523,
	kGFF4CutsceneActionFrameBufEffectParamValue          =   5524,
	kGFF4CutsceneActionFrameBufEffectParamCurveIndex     =   5525,
	kGFF4CutsceneActionFrameBufEffectParamVectorIndex    =   5526,

	kGFF4CutsceneActionSpeakLineLipsynchSet              =   5562,
	kGFF4CutsceneActionSpeakLineVobank                   =   5563,
	kGFF4CutsceneActionSpeakLineFaHeadMove               =   5564,
	kGFF4CutsceneActionSpeakLineNoVOIngame               =   5565,

	kGFF4CutsceneActionStageCameraDefault                =   5570,
	kGFF4CutsceneActionStageCameraHenchman               =   5571,

	kGFF4CutsceneActionStagePlaceLookAt                  =   5580,

	kGFF4CutsceneActionShakeType                         =   5600,
	kGFF4CutsceneActionShakeDeprecated1                  =   5601,
	kGFF4CutsceneActionShakeDeprecated2                  =   5602,
	kGFF4CutsceneActionShakeNoiseSeed                    =   5603,
	kGFF4CutsceneActionShakeNoiseFrequency               =   5604,
	kGFF4CutsceneActionShakeNoiseType                    =   5605,
	kGFF4CutsceneActionShakeNoiseCorrelated              =   5606,
	kGFF4CutsceneActionShakeNoiseRoughness               =   5607,
	kGFF4CutsceneActionShakeNoiseRampIn                  =   5608,
	kGFF4CutsceneActionShakeNoiseRampOut                 =   5609,

	kGFF4CutsceneActionActiveCameraActorID               =   5610,

	kGFF4CutsceneActionHeadtrackTargetID                 =   5620,
	kGFF4CutsceneActionHeadtrackSpeed                    =   5621,
	kGFF4CutsceneActionHeadtrackDeprecated1              =   5624,
	kGFF4CutsceneActionHeadtrackDeprecated2              =   5625,
	kGFF4CutsceneActionHeadtrackDeprecated3              =   5626,
	kGFF4CutsceneActionHeadtrackDeprecated4              =   5627,
	kGFF4CutsceneActionHeadtrackRealignStart             =   5628,
	kGFF4CutsceneActionHeadtrackRealignCont              =   5629,

	kGFF4CutsceneActionLinkActorTargetID                 =   5630,
	kGFF4CutsceneActionLinkActorNodeID                   =   5631,
	kGFF4CutsceneActionLinkActorDeprecated1              =   5632,
	kGFF4CutsceneActionLinkActorDeprecated2              =   5633,
	kGFF4CutsceneActionLinkActorDeprecated3              =   5634,
	kGFF4CutsceneActionLinkActorDeprecated4              =   5635,
	kGFF4CutsceneActionLinkActorIsTargetCrust            =   5636,
	kGFF4CutsceneActionLinkActorUseOffset                =   5637,

	kGFF4CutsceneActionApplycrustTargetID                =   5640,

	kGFF4CutsceneActionPoseAnimationPose                 =   5650,
	kGFF4CutsceneActionPoseAnimationAnimation            =   5651,
	kGFF4CutsceneActionPoseAnimationLooping              =   5652,
	kGFF4CutsceneActionPoseAnimationOutro                =   5653,
	kGFF4CutsceneActionPoseAnimationOutroSpeed           =   5654,

	kGFF4CutsceneActionSoundName                         =   5670,
	kGFF4CutsceneActionSoundSplineParamNo1               =   5671,
	kGFF4CutsceneActionSoundSplineParamNo2               =   5672,
	kGFF4CutsceneActionSoundSplineParamNo3               =   5673,
	kGFF4CutsceneActionSoundSplineParamNo4               =   5674,
	kGFF4CutsceneActionSoundSplineParamNo5               =   5675,

	kGFF4CutsceneActionChangeVisibilityVisible           =   5680,

	kGFF4CutsceneActionToggleClothPhysics                =   5700,
	kGFF4CutsceneActionToggleHairPhysics                 =   5701,

	kGFF4CutsceneActionSetLodDeprecated                  =   5720,

	kGFF4CutsceneActionDrawWeaponMain                    =   5730,
	kGFF4CutsceneActionDrawWeaponOff                     =   5731,

	kGFF4CutsceneActionPlayMovie                         =   5740,

	kGFF4CutsceneActionSetGore                           =   5750,

	kGFF4MMHName                                         =   6000,
	kGFF4MMHMaterialObject                               =   6001,
	kGFF4MMHMaterialLibrary                              =   6002,
	kGFF4MMHResName                                      =   6003,
	kGFF4MMHID                                           =   6004,
	kGFF4MMHModelHierarchyModelDataName                  =   6005,
	kGFF4MMHMeshGroupName                                =   6006,
	kGFF4MMHNodePointLightColor                          =   6007,
	kGFF4MMHNodePointLightRadius                         =   6008,
	kGFF4MMHNodePointLightIsStatic                       =   6009,
	kGFF4MMHNodeAmbientLightColor                        =   6010,
	kGFF4MMHNodeEmitBirthRate                            =   6011,
	kGFF4MMHNodeEmitBirthRateRange                       =   6012,
	kGFF4MMHNodeEmitLife                                 =   6013,
	kGFF4MMHNodeEmitLifeRange                            =   6014,
	kGFF4MMHNodeEmitScaleRange                           =   6015,
	kGFF4MMHNodeEmitInitialSpeed                         =   6016,
	kGFF4MMHNodeEmitInitialSpeedRange                    =   6017,
	kGFF4MMHNodeEmitAcceleration                         =   6018,
	kGFF4MMHNodeEmitInitialRotationSpeed                 =   6019,
	kGFF4MMHNodeEmitInitialRotationSpeedRange            =   6020,
	kGFF4MMHNodeEmitRotationalAcceleration               =   6021,
	kGFF4MMHNodeInvEmitterMovementSpreadUpdateDelay      =   6022,
	kGFF4MMHNodeEmitSpawnSpreadX                         =   6023,
	kGFF4MMHNodeEmitSpawnSpreadY                         =   6024,
	kGFF4MMHNodeEmitMovementSpreadX                      =   6025,
	kGFF4MMHNodeEmitMovementSpreadY                      =   6026,
	kGFF4MMHNodeEmitOptionsBitflags                      =   6027,
	kGFF4MMHNodeEmitOptionsBirthrateInParticlesPerMeter  =   6028,
	kGFF4MMHNodeEmitOptionsRandomInitialRotation         =   6029,
	kGFF4MMHNodeEmitOptionsParticlesAffectedByWind       =   6030,
	kGFF4MMHNodeEmitGravityMultiplier                    =   6031,
	kGFF4MMHNodeEmitOptionsParticlesFollowPath           =   6032,
	kGFF4MMHNodeEmitOptionsLinkParticlesTogether         =   6033,
	kGFF4MMHNodeEmitOptionsUpdateOnlyWhenVisible         =   6034,
	kGFF4MMHNodeEmitOptionsEnableParticleCollisions      =   6035,
	kGFF4MMHNodeEmitOptionsInheritVelocityInsteadOfPos   =   6036,
	kGFF4MMHNodeEmitOrientationBehavior                  =   6037,
	kGFF4MMHNodeEmitParticleInheritance                  =   6038,
	kGFF4MMHNodeAgeMapCount                              =   6039,
	kGFF4MMHNodeAgeMapElementPercentLifeElapsed          =   6040,
	kGFF4MMHNodeAgeMapElementScaleX                      =   6041,
	kGFF4MMHNodeAgeMapElementScaleY                      =   6042,
	kGFF4MMHNodeAgeMapElementColor                       =   6043,
	kGFF4MMHNodeSpawnVolumeOptionsBitflags               =   6044,
	kGFF4MMHNodeSpawnVolumeOptionsSpawnWithinVolume      =   6045,
	kGFF4MMHNodeSpawnVolumeOptionsInvertSpawnVolumeNorms =   6046,
	kGFF4MMHTranslation                                  =   6047,
	kGFF4MMHRotation                                     =   6048,
	kGFF4MMHAttributeName                                =   6049,
	kGFF4MMHAttributeSourceName                          =   6050,
	kGFF4MMHExportTagName                                =   6051,
	kGFF4MMHExportExportName                             =   6052,
	kGFF4MMHExportControllerType                         =   6053,
	kGFF4MMHBoundingBoxMin                               =   6054,
	kGFF4MMHBoundingBoxMax                               =   6055,
	kGFF4MMHNodeCollisionObjDensity                      =   6056,
	kGFF4MMHNodeCollisionObjType                         =   6057,
	kGFF4MMHShapeType                                    =   6058,
	kGFF4MMHShapePmatName                                =   6059,
	kGFF4MMHShapeRotation                                =   6060,
	kGFF4MMHShapePosition                                =   6061,
	kGFF4MMHShapeCollisionMaskBitflags                   =   6062,
	kGFF4MMHShapeCollisionMaskAll                        =   6063,
	kGFF4MMHShapeCollisionMaskNone                       =   6064,
	kGFF4MMHShapeCollisionMaskItems                      =   6065,
	kGFF4MMHShapeCollisionMaskCreatures                  =   6066,
	kGFF4MMHShapeCollisionMaskPlaceables                 =   6067,
	kGFF4MMHShapeCollisionMaskTriggers                   =   6068,
	kGFF4MMHShapeCollisionMaskStaticGeometry             =   6069,
	kGFF4MMHShapeCollisionMaskNonwalkable                =   6070,
	kGFF4MMHShapeBoxDim                                  =   6071,
	kGFF4MMHShapeRadius                                  =   6072,
	kGFF4MMHShapeHeight                                  =   6073,
	kGFF4MMHShapeMeshShapeFlags                          =   6074,
	kGFF4MMHShapeMeshHeightFieldAxis                     =   6075,
	kGFF4MMHShapeMeshHeightFieldExtent                   =   6076,
	kGFF4MMHShapeCookedDataStream                        =   6077,
	kGFF4MMHJointTarget                                  =   6078,
	kGFF4MMHJointType                                    =   6079,
	kGFF4MMHJointTypeStruct                              =   6080,
	kGFF4MMHJointLocalNormal1                            =   6081,
	kGFF4MMHJointLocalNormal2                            =   6082,
	kGFF4MMHJointLocalAnchor1                            =   6083,
	kGFF4MMHJointLocalAnchor2                            =   6084,
	kGFF4MMHJointLocalAxis1                              =   6085,
	kGFF4MMHJointLocalAxis2                              =   6086,
	kGFF4MMHJointMaxForce                                =   6087,
	kGFF4MMHJointMaxTorque                               =   6088,
	kGFF4MMHJointCollisionEnabled                        =   6089,
	kGFF4MMHJointSphericalSwingAxis                      =   6090,
	kGFF4MMHJointSphericalProjectionDistance             =   6091,
	kGFF4MMHJointSphericalTwistLimitLow                  =   6092,
	kGFF4MMHJointSphericalTwistLimitHigh                 =   6093,
	kGFF4MMHJointSphericalSwingLimit                     =   6094,
	kGFF4MMHJointSphericalTwistSwing                     =   6095,
	kGFF4MMHJointSphericalSwingSpring                    =   6096,
	kGFF4MMHJointSphericalJointSpring                    =   6097,
	kGFF4MMHJointSphericalProjectionMode                 =   6098,
	kGFF4MMHJointSphericalSphereFlags                    =   6099,
	kGFF4MMHJointRevoluteLimitLow                        =   6100,
	kGFF4MMHJointRevoluteLimitHigh                       =   6101,
	kGFF4MMHJointRevoluteProjectionDistance              =   6102,
	kGFF4MMHJointRevoluteProjectionAngle                 =   6103,
	kGFF4MMHJointRevoluteProjectionMode                  =   6104,
	kGFF4MMHJointRevoluteSpring                          =   6105,
	kGFF4MMHJointRevoluteMotorVelTarget                  =   6106,
	kGFF4MMHJointRevoluteMotorMaxForce                   =   6107,
	kGFF4MMHJointRevoluteMotorFreeSpin                   =   6108,
	kGFF4MMHJointRevoluteRevoluteFlags                   =   6109,
	kGFF4MMHJointDistanceMinDistance                     =   6110,
	kGFF4MMHJointDistanceMaxDistance                     =   6111,
	kGFF4MMHJointDistanceSpring                          =   6112,
	kGFF4MMHJointDistanceDistanceFlags                   =   6113,
	kGFF4MMHJointPulleyPulley1                           =   6114,
	kGFF4MMHJointPulleyPulley2                           =   6115,
	kGFF4MMHJointPulleyDistance                          =   6116,
	kGFF4MMHJointPulleyStiffness                         =   6117,
	kGFF4MMHJointPulleyRatio                             =   6118,
	kGFF4MMHJointPulleyMotorVelTarget                    =   6119,
	kGFF4MMHJointPulleyMotorMaxForce                     =   6120,
	kGFF4MMHJointPulleyMotorFreeSpin                     =   6121,
	kGFF4MMHJointPulleyPulleyFlags                       =   6122,
	kGFF4MMHJoint6dofXMotion                             =   6123,
	kGFF4MMHJoint6dofYMotion                             =   6124,
	kGFF4MMHJoint6dofZMotion                             =   6125,
	kGFF4MMHJoint6dofSwing1Motion                        =   6126,
	kGFF4MMHJoint6dofSwing2Motion                        =   6127,
	kGFF4MMHJoint6dofTwistMotion                         =   6128,
	kGFF4MMHJoint6dofLinearLimit                         =   6129,
	kGFF4MMHJoint6dofSwing1Limit                         =   6130,
	kGFF4MMHJoint6dofSwing2Limit                         =   6131,
	kGFF4MMHJoint6dofTwistLimitLow                       =   6132,
	kGFF4MMHJoint6dofTwistLimitHigh                      =   6133,
	kGFF4MMHJoint6dofDriveOrientation                    =   6134,
	kGFF4MMHJoint6dofDriveXDriveType                     =   6135,
	kGFF4MMHJoint6dofDriveXDriveSpring                   =   6136,
	kGFF4MMHJoint6dofDriveXDriveDamping                  =   6137,
	kGFF4MMHJoint6dofDriveXDriveForceLimit               =   6138,
	kGFF4MMHJoint6dofDriveYDriveType                     =   6139,
	kGFF4MMHJoint6dofDriveYDriveSpring                   =   6140,
	kGFF4MMHJoint6dofDriveYDriveDamping                  =   6141,
	kGFF4MMHJoint6dofDriveYDriveForceLimit               =   6142,
	kGFF4MMHJoint6dofDriveZDriveType                     =   6143,
	kGFF4MMHJoint6dofDriveZDriveSpring                   =   6144,
	kGFF4MMHJoint6dofDriveZDriveDamping                  =   6145,
	kGFF4MMHJoint6dofDriveZDriveForceLimit               =   6146,
	kGFF4MMHJoint6dofDriveSwingDriveType                 =   6147,
	kGFF4MMHJoint6dofDriveSwingDriveSpring               =   6148,
	kGFF4MMHJoint6dofDriveSwingDriveDamping              =   6149,
	kGFF4MMHJoint6dofDriveSwingDriveForceLimit           =   6150,
	kGFF4MMHJoint6dofDriveTwistDriveType                 =   6151,
	kGFF4MMHJoint6dofDriveTwistDriveSpring               =   6152,
	kGFF4MMHJoint6dofDriveTwistDriveDamping              =   6153,
	kGFF4MMHJoint6dofDriveTwistDriveForceLimit           =   6154,
	kGFF4MMHJoint6dofDriveSlerpDriveType                 =   6155,
	kGFF4MMHJoint6dofDriveSlerpDriveSpring               =   6156,
	kGFF4MMHJoint6dofDriveSlerpDriveDamping              =   6157,
	kGFF4MMHJoint6dofDriveSlerpDriveForceLimit           =   6158,
	kGFF4MMHJoint6dofDrivePosition                       =   6159,
	kGFF4MMHJoint6dofDriveLinearVelocity                 =   6160,
	kGFF4MMHJoint6dofDriveAngularVelocity                =   6161,
	kGFF4MMHJoint6dofProjectionDistance                  =   6162,
	kGFF4MMHJoint6dofProjectionAngle                     =   6163,
	kGFF4MMHJoint6dofGearRatio                           =   6164,
	kGFF4MMHJoint6dofProjectionMode                      =   6165,
	kGFF4MMHJoint6dofD6Flags                             =   6166,
	kGFF4MMHDataSemantic                                 =   6167,
	kGFF4MMHDataIsIndexStream                            =   6168,
	kGFF4MMHDataType                                     =   6169,
	kGFF4MMHDataBitflags                                 =   6170,
	kGFF4MMHDataLooping                                  =   6171,
	kGFF4MMHDataInstanced                                =   6172,
	kGFF4MMHDataCount                                    =   6173,
	kGFF4MMHDataPrimitiveType                            =   6174,
	kGFF4MMHDataFrequency                                =   6175,
	kGFF4MMHMeshCastRuntimeShadow                        =   6176,
	kGFF4MMHMeshCastBakedShadow                          =   6177,
	kGFF4MMHShapeCollisionMaskEffects                    =   6178,
	kGFF4MMHShapeCollisionMaskWaypoints                  =   6179,
	kGFF4MMHFlipbookFramesPerSecond                      =   6180,
	kGFF4MMHFlipbookRows                                 =   6181,
	kGFF4MMHFlipbookColumns                              =   6182,
	kGFF4MMHFlipbookRandomStartFrame                     =   6183,
	kGFF4MMHEmitterTargetName                            =   6184,
	kGFF4MMHEmitterTargetAttraction                      =   6185,
	kGFF4MMHEmitterTargetRadius                          =   6186,
	kGFF4MMHEmitterSpawnDirectionTracksTarget            =   6187,
	kGFF4MMHEmitterKillParticleWhenTargetHit             =   6188,
	kGFF4MMHEmitterFlipbookType                          =   6189,
	kGFF4MMHLightprobeIrradianceCoefficientsRed          =   6190,
	kGFF4MMHLightprobeIrradianceCoefficientsGreen        =   6191,
	kGFF4MMHLightprobeIrradianceCoefficientsBlue         =   6192,
	kGFF4MMHMeshCutAway                                  =   6193,
	kGFF4MMHMeshPunchThrough                             =   6194,
	kGFF4MMHClothThickness                               =   6195,
	kGFF4MMHClothDensity                                 =   6196,
	kGFF4MMHClothBendingStiffness                        =   6197,
	kGFF4MMHClothStretchingStiffness                     =   6198,
	kGFF4MMHClothDampingCoefficient                      =   6199,
	kGFF4MMHClothFriction                                =   6200,
	kGFF4MMHClothPressure                                =   6201,
	kGFF4MMHClothTearFactor                              =   6202,
	kGFF4MMHClothCollisionResponseCoefficient            =   6203,
	kGFF4MMHClothAttachmentResponseCoefficient           =   6204,
	kGFF4MMHClothAttachmentTearFactor                    =   6205,
	kGFF4MMHClothSolverIterations                        =   6206,
	kGFF4MMHClothExternalAcceleration                    =   6207,
	kGFF4MMHClothWakeUpCounter                           =   6208,
	kGFF4MMHClothSleepLinearVelocity                     =   6209,
	kGFF4MMHClothFlagBitflags                            =   6210,
	kGFF4MMHClothFlagPressure                            =   6211,
	kGFF4MMHClothFlagStatic                              =   6212,
	kGFF4MMHClothFlagDisableCollision                    =   6213,
	kGFF4MMHClothFlagSelfcollision                       =   6214,
	kGFF4MMHClothFlagVisualization                       =   6215,
	kGFF4MMHClothFlagGravity                             =   6216,
	kGFF4MMHClothFlagBending                             =   6217,
	kGFF4MMHClothFlagBendingOrtho                        =   6218,
	kGFF4MMHClothFlagDamping                             =   6219,
	kGFF4MMHClothFlagCollisionTwoway                     =   6220,
	kGFF4MMHClothFlagTriangleCollision                   =   6221,
	kGFF4MMHClothFlagTearable                            =   6222,
	kGFF4MMHClothFlagHardware                            =   6223,
	kGFF4MMHClothFlagComdamping                          =   6224,
	kGFF4MMHClothAttachmentType                          =   6225,
	kGFF4MMHClothAttachmentFlagBitflags                  =   6226,
	kGFF4MMHClothAttachmentFlagTwoWayAttachment          =   6227,
	kGFF4MMHClothAttachmentFlagTearableAttachment        =   6228,
	kGFF4MMHClothAttachmentShapeName                     =   6229,
	kGFF4MMHClothAttachmentVertexID                      =   6230,
	kGFF4MMHClothAttachmentLocalPos                      =   6231,
	kGFF4MMHClothCookedDataStream                        =   6232,
	kGFF4MMHClothMeshGroupStruct                         =   6233,
	kGFF4MMHNodeEmitType                                 =   6234,
	kGFF4MMHNodeCrustHookID                              =   6235,
	kGFF4MMHCollisionObjectVolume                        =   6236,
	kGFF4MMHObjectVolume                                 =   6237,
	kGFF4MMHExportTagVariableType                        =   6238,
	kGFF4MMHEmitterIsPhysicsEmitter                      =   6239,
	kGFF4MMHShapeVolume                                  =   6240,
	kGFF4MMHShapeName                                    =   6241,
	kGFF4MMHSnapPosition                                 =   6242,
	kGFF4MMHEmitterIsPhysicsObjectSpawnEmitter           =   6243,
	kGFF4MMHShapeAllowEmitterSpawn                       =   6244,
	kGFF4MMHCollisionGroup                               =   6245,
	kGFF4MMHEmitterEmitterAttachmentType                 =   6246,
	kGFF4MMHEmitterEmitterAttachmentName                 =   6247,
	kGFF4MMHFacialAnimationBlueprintName                 =   6248,

	kGFF4MMHNodePointLightIntensityVariation             =   6249,
	kGFF4MMHNodePointLightIntensityPeriod                =   6250,
	kGFF4MMHNodePointLightIntensityPeriodDelta           =   6251,
	kGFF4MMHShapeFadeable                                =   6252,

	kGFF4MMHLightprobeIrradianceRes                      =   6253,

	kGFF4MMHBoneIndex                                    =   6254,
	kGFF4MMHMeshBonesUsed                                =   6255,
	kGFF4MMHTotalBones                                   =   6256,

	kGFF4MMHClothWindEnabled                             =   6257,
	kGFF4MMHClothWindSpace                               =   6258,
	kGFF4MMHClothWindDirection                           =   6259,
	kGFF4MMHClothWindResponse                            =   6260,
	kGFF4MMHClothWindResponseLimit                       =   6261,
	kGFF4MMHClothWindStrength                            =   6262,
	kGFF4MMHClothWindGustMinStrength                     =   6263,
	kGFF4MMHClothWindGustMaxStrength                     =   6264,
	kGFF4MMHClothWindGustMinDuration                     =   6265,
	kGFF4MMHClothWindGustMaxDuration                     =   6266,
	kGFF4MMHClothWindGustMinInterval                     =   6267,
	kGFF4MMHClothWindGustMaxInterval                     =   6268,
	kGFF4MMHClothWindGustDirChange                       =   6269,
	kGFF4MMHClothWindGustAxisRatio                       =   6270,
	kGFF4MMHClothWindSpeedtreeUpdateTime                 =   6271,
	kGFF4MMHClothWindSpeedtreeStrength                   =   6272,
	kGFF4MMHClothWindSpeedtreeDirection                  =   6273,

	kGFF4MMHExportControllerIndex                        =   6274,
	kGFF4MMHTotalExports                                 =   6275,

	kGFF4MMHClothWindSpeedtreeParams                     =   6276,

	kGFF4MMHShapeCollisionMaskWater                      =   6277,

	kGFF4MMHScale                                        =   6278,

	kGFF4MMHNodeEmitAgemapColorMultiplier                =   6279,
	kGFF4MMHNodeEmitAgemapScalexMultiplier               =   6280,
	kGFF4MMHNodeEmitAgemapScaleyMultiplier               =   6281,

	kGFF4MMHNodeEmitOptionsBounciness                    =   6282,
	kGFF4MMHNodeEmitOptionsFriction                      =   6283,
	kGFF4MMHNodeEmitMeshParticleModelName                =   6284,
	kGFF4MMHNodeSpawnVolumeType                          =   6285,
	kGFF4MMHNodeSpawnVolumeRadius                        =   6286,
	kGFF4MMHNodeSpawnVolumeCylinderLength                =   6287,
	kGFF4MMHNodeSpawnVolumeCylinderAxis                  =   6288,
	kGFF4MMHNodeSpawnVolumeBoxMin                        =   6289,
	kGFF4MMHNodeSpawnVolumeBoxMax                        =   6290,
	kGFF4MMHNodeSpawnVolumeOptionsNormalsAsDirection     =   6291,

	kGFF4MMHWeapontrailSegmentLength                     =   6292,
	kGFF4MMHWeapontrailDuration                          =   6293,

	kGFF4MMHNodeEmitWorldAxisAcceleration                =   6294,

	kGFF4MMHShapeCollisionMaskTerrainWall                =   6295,

	kGFF4MMHNodeLightAffectDomain                        =   6296,
	kGFF4MmnNodeEmitVertexFormat                         =   6297,

	kGFF4MMHNodeEmitOptionsObjectSpaceAcceleration       =   6298,
	kGFF4MMHNodeEmitInitialRotation                      =   6299,
	kGFF4MMHNodeEmitInitialRotationRange                 =   6300,

	kGFF4MMHMeshReceiveBakedShadow                       =   6301,

	kGFF4MMHNodeEmitMeshParticleUpAxis                   =   6302,
	kGFF4MMHNodeEmitMeshParticleRollAxis                 =   6303,

	kGFF4MMHMeshReceiveRuntimeShadow                     =   6304,
	kGFF4MMHShapeCollisionMaskWalkable                   =   6305,

	kGFF4MMHModelMeshNameList                            =   6306,
	kGFF4MMHNodeMeshName                                 =   6307,
	kGFF4MMHNodeEmitUvDistributionSize                   =   6308,
	kGFF4MMHNodeEmitIgnoreDistortion                     =   6309,

	kGFF4MMHNodeEmitSplatParamsWidth                     =   6310,
	kGFF4MMHNodeEmitSplatParamsHeight                    =   6311,
	kGFF4MMHNodeEmitSplatParamsNumsamplesWidth           =   6312,
	kGFF4MMHNodeEmitSplatParamsNumsamplesHeight          =   6313,
	kGFF4MMHNodeEmitSplatParamsOrientationRange          =   6314,
	kGFF4MMHNodeEmitSplatParamsLife                      =   6315,
	kGFF4MMHNodeEmitSplatParamsFlipbookType              =   6316,
	kGFF4MMHNodeEmitSplatParamsFlipbookFramesPerSecond   =   6317,
	kGFF4MMHNodeEmitSplatParamsFlipbookRows              =   6318,
	kGFF4MMHNodeEmitSplatParamsFlipbookColumns           =   6319,
	kGFF4MMHNodeEmitSplatParamsFlipbookRandomStartFrame  =   6320,
	kGFF4MMHNodeEmitCanParticlesSplat                    =   6321,
	kGFF4MMHNodeEmitSplatParamsAgeMapElemPercLifeElapsed =   6322,
	kGFF4MMHNodeEmitLod                                  =   6323,
	kGFF4MMHNodeEmitSplatParamsMaterialName              =   6324,

	kGFF4MMHNodeEmitUserParamName                        =   6325,

	kGFF4MMHRemoteMaterialDecalName                      =   6327,
	kGFF4MMHRemoteMaterialFresnelFalloff                 =   6328,
	kGFF4MMHRemoteMaterialInvertFresnel                  =   6329,

	kGFF4MMHNodeSoundMaterial                            =   6330,

	kGFF4MMHRemoteMaterialAlpha                          =   6331,
	kGFF4MMHRemoteMaterialTint                           =   6332,
	kGFF4MMHEmitterPresimulateTime                       =   6333,

	kGFF4MMHMeshIsVFXMesh                                =   6334,
	kGFF4MMHMeshMaterialColor                            =   6335,

	kGFF4MMHLightProbeIrradianceRed                      =   6336,
	kGFF4MMHLightProbeIrradianceGreen                    =   6337,
	kGFF4MMHLightProbeIrradianceBlue                     =   6338,

	kGFF4MMHLightCanBeOccluded                           =   6339,

	kGFF4MMHUseVariationTint                             =   6340,
	kGFF4MMHNodeEmitSplatparamsHoldLastFrame             =   6341,
	kGFF4MMHEmitterEmitterAttachmentSpawnOnSurface       =   6342,
	kGFF4MMHEmitterEmitterAttachmentUseNormalForVelocity =   6343,
	kGFF4MMHNodeEmitSplatparamsAgemapColorMultiplier     =   6344,

	kGFF4MMHNodeLightVersion                             =   6345,

	kGFF4MMHMeshDefaultHidden                            =   6346,

	kGFF4MMHShapeTypeStruct                              =   6998,
	kGFF4MMHChildren                                     =   6999,

	kGFF4TerrainVersion                                  =   7000,
	kGFF4TerrainBaseRows                                 =   7001,
	kGFF4TerrainBaseColumns                              =   7002,
	kGFF4TerrainLengthUnits                              =   7003,
	kGFF4TerrainWidthUnits                               =   7004,
	kGFF4TerrainSectorRows                               =   7005,
	kGFF4TerrainSectorColumns                            =   7006,
	kGFF4TerrainTessellation                             =   7007,
	kGFF4TerrainSectorID                                 =   7008,
	kGFF4TerrainSectorList                               =   7009,
	kGFF4TerrainMeshFaceID                               =   7010,
	kGFF4TerrainMeshFaceList                             =   7011,
	kGFF4TerrainMeshEdgeID                               =   7012,
	kGFF4TerrainMeshEdgeStartVertex                      =   7013,
	kGFF4TerrainMeshEdgeBoundaryFlag                     =   7014,
	kGFF4TerrainMeshEdgeSubedgeList                      =   7015,
	kGFF4TerrainMeshEdgeList                             =   7016,
	kGFF4TerrainSubEdgeID                                =   7017,
	kGFF4TerrainMeshVertexID                             =   7018,
	kGFF4TerrainMeshVertexPosition                       =   7019,
	kGFF4TerrainMeshVertexLevel                          =   7020,
	kGFF4TerrainMeshVertexConstraintList                 =   7021,
	kGFF4TerrainMeshVertexConstraintID                   =   7022,
	kGFF4TerrainMeshVertexList                           =   7023,
	kGFF4TerrainElementIDValue                           =   7024,
	kGFF4TerrainElementIDSector                          =   7025,
	kGFF4TerrainMaterialValue                            =   7026,
	kGFF4TerrainMaterialList                             =   7027,
	kGFF4TerrainAreaInformation                          =   7028,
	kGFF4TerrainVertexU                                  =   7029,
	kGFF4TerrainVertexV                                  =   7030,
	kGFF4TerrainMaskDataWidth                            =   7031,
	kGFF4TerrainMaskDataHeight                           =   7032,
	kGFF4TerrainMaskDataStride                           =   7033,
	kGFF4TerrainMaskDataArray                            =   7034,
	kGFF4TerrainVMaskData                                =   7035,
	kGFF4TerrainAMaskData                                =   7036,
	kGFF4TerrainMapVertexID                              =   7037,
	kGFF4TerrainMapVertexUVW                             =   7038,
	kGFF4TerrainMapVertexList                            =   7039,
	kGFF4TerrainMapEdgeID                                =   7040,
	kGFF4TerrainMapEdgeStartVertex                       =   7041,
	kGFF4TerrainMapEdgeList                              =   7042,
	kGFF4TerrainMapFaceID                                =   7043,
	kGFF4TerrainMapFaceLayer                             =   7044,
	kGFF4TerrainMapFaceList                              =   7045,
	kGFF4TerrainMapFaceBlendPageID                       =   7046,
	kGFF4TerrainBlendWeightMatID                         =   7047,
	kGFF4TerrainBlendWeightWeight                        =   7048,
	kGFF4TerrainBlendTexelWeightList                     =   7049,
	kGFF4TerrainBlendPageID                              =   7050,
	kGFF4TerrainBlendPageWidth                           =   7051,
	kGFF4TerrainBlendPageHeight                          =   7052,
	kGFF4TerrainBlendPageTexelList                       =   7053,
	kGFF4TerrainBlendPageList                            =   7054,
	kGFF4TerrainMesh                                     =   7055,
	kGFF4TerrainPalette                                  =   7056,
	kGFF4TerrainBlendTexelByteWeightList                 =   7057,
	kGFF4TerrainMeshName                                 =   7058,
	kGFF4TerrainPaletteName                              =   7059,
	kGFF4TerrainMaterial                                 =   7060,
	kGFF4TerrainMaterialID                               =   7061,
	kGFF4TerrainMaterialName                             =   7062,
	kGFF4TerrainMaterialScale                            =   7063,
	kGFF4TerrainMaterialDiffuseName                      =   7064,
	kGFF4TerrainMaterialNormalName                       =   7065,
	kGFF4TerrainMaterialSpecualarName                    =   7066,
	kGFF4TerrainMaterialHeightMapName                    =   7067,
	kGFF4TerrainPaletteParallaxGlobal                    =   7068,
	kGFF4TerrainMaterialReliefScale                      =   7069,
	kGFF4TerrainBlendTexel6ByteWeightList                =   7070,
	kGFF4TerrainMeshVertexConstraintA                    =   7071,
	kGFF4TerrainMeshVertexConstraintB                    =   7072,
	kGFF4TerrainMeshEdgeSubEdgeA                         =   7073,
	kGFF4TerrainMeshEdgeSubEdgeB                         =   7074,
	kGFF4TerrainBlendTexelID                             =   7075,
	kGFF4TerrainSoundData                                =   7076,
	kGFF4TerrainMaterialSpecularColor                    =   7077,

	kGFF4WaterInformation                                =   7900,
	kGFF4WaterVersion                                    =   7901,
	kGFF4WaterID                                         =   7902,
	kGFF4WaterVertexList                                 =   7903,
	kGFF4WaterVertexPosition                             =   7904,
	kGFF4WaterVertexNormal                               =   7905,
	kGFF4WaterVertexUVW                                  =   7906,
	kGFF4WaterVertexColor                                =   7907,
	kGFF4WaterVertexIndexList                            =   7908,

	kGFF4MeshChunkVertexSize                             =   8000,
	kGFF4MeshChunkVertexCount                            =   8001,
	kGFF4MeshChunkIndexCount                             =   8002,
	kGFF4MeshChunkPrimitiveType                          =   8003,
	kGFF4MeshChunkIndexFormat                            =   8004,
	kGFF4MeshChunkBaseVertexIndex                        =   8005,
	kGFF4MeshChunkVertexOffset                           =   8006,
	kGFF4MeshChunkMinIndex                               =   8007,
	kGFF4MeshChunkVerticesReferenced                     =   8008,
	kGFF4MeshChunkStartIndex                             =   8009,
	kGFF4MeshChunkHasInstGeom                            =   8010,
	kGFF4MeshChunkAdditionalStreams                      =   8011,
	kGFF4MeshStreamVertexSize                            =   8012,
	kGFF4MeshStreamVertexCount                           =   8013,
	kGFF4MeshStreamFrequency                             =   8014,
	kGFF4MeshStreamLooping                               =   8015,
	kGFF4MeshStreamInstanced                             =   8016,
	kGFF4MeshBoundsBoxMin                                =   8017,
	kGFF4MeshBoundsBoxMax                                =   8018,
	kGFF4MeshBoundsSphere                                =   8019,
	kGFF4MeshChunkBounds                                 =   8020,
	kGFF4MeshChunks                                      =   8021,
	kGFF4MeshVertexData                                  =   8022,
	kGFF4MeshIndexData                                   =   8023,
	kGFF4MeshStreamVertexData                            =   8024,
	kGFF4MeshChunkVertexDeclarator                       =   8025,
	kGFF4MeshVertexDeclaratorStream                      =   8026,
	kGFF4MeshVertexDeclaratorOffset                      =   8027,
	kGFF4MeshVertexDeclaratorDatatype                    =   8028,
	kGFF4MeshVertexDeclaratorUsage                       =   8029,
	kGFF4MeshVertexDeclaratorUsageIndex                  =   8030,
	kGFF4MeshVertexDeclaratorMethod                      =   8031,
	kGFF4MeshIndexFormat                                 =   8032,
	kGFF4MeshInstancedStream                             =   8033,
	kGFF4MeshChunkInstancesCount                         =   8034,

	kGFF4AcNodeName                                      =   9000,
	kGFF4AcEdgeStartID                                   =   9001,
	kGFF4AcEdgeEndID                                     =   9002,
	kGFF4AcCaption                                       =   9003,
	kGFF4AcNodeSocketList                                =   9004,
	kGFF4AcSocketIsOutput                                =   9005,
	kGFF4AcNodeImage                                     =   9006,
	kGFF4AcEdgeList                                      =   9007,
	kGFF4AcNodeList                                      =   9008,
	kGFF4AcNodeColor                                     =   9009,
	kGFF4AcNodeAnimation                                 =   9010,
	kGFF4AcCurveControlPointList                         =   9011,
	kGFF4AcCurveControlPointTime                         =   9012,
	kGFF4AcCurveControlPointValue                        =   9013,
	kGFF4AcModelName                                     =   9014,
	kGFF4AcEventList                                     =   9015,
	kGFF4AcEventTime                                     =   9016,
	kGFF4AcEventID                                       =   9017,
	kGFF4AcNodeLooping                                   =   9018,
	kGFF4AcFlags                                         =   9019,
	kGFF4AcTransAnimName                                 =   9020,
	kGFF4AcTransAnimStart                                =   9021,
	kGFF4AcTransAnimLength                               =   9022,
	kGFF4AcTransTrackList                                =   9023,
	kGFF4AcTransitionList                                =   9024,
	kGFF4AcTransLength                                   =   9025,

	kGFF4AcBlendGroupAnimList                            =   9100,
	kGFF4AcBlendGroupList                                =   9101,
	kGFF4AcBlendGroupName                                =   9102,

	kGFF4G2DAColumnName                                  =  10000,
	kGFF4G2DAColumnHash                                  =  10001,
	kGFF4G2DAColumnList                                  =  10002,
	kGFF4G2DARowList                                     =  10003,
	kGFF4G2DARowData                                     =  10004,

	kGFF4G2DAColumn1                                     =  10005,
	kGFF4G2DAColumn2                                     =  10006,
	kGFF4G2DAColumn3                                     =  10007,
	kGFF4G2DAColumn4                                     =  10008,
	kGFF4G2DAColumn5                                     =  10009,
	kGFF4G2DAColumn6                                     =  10010,
	kGFF4G2DAColumn7                                     =  10011,
	kGFF4G2DAColumn8                                     =  10012,
	kGFF4G2DAColumn9                                     =  10013,
	kGFF4G2DAColumn10                                    =  10014,
	kGFF4G2DAColumn11                                    =  10015,
	kGFF4G2DAColumn12                                    =  10016,
	kGFF4G2DAColumn13                                    =  10017,
	kGFF4G2DAColumn14                                    =  10018,
	kGFF4G2DAColumn15                                    =  10019,
	kGFF4G2DAColumn16                                    =  10020,
	kGFF4G2DAColumn17                                    =  10021,
	kGFF4G2DAColumn18                                    =  10022,
	kGFF4G2DAColumn19                                    =  10023,
	kGFF4G2DAColumn20                                    =  10024,
	kGFF4G2DAColumn21                                    =  10025,
	kGFF4G2DAColumn22                                    =  10026,
	kGFF4G2DAColumn23                                    =  10027,
	kGFF4G2DAColumn24                                    =  10028,
	kGFF4G2DAColumn25                                    =  10029,
	kGFF4G2DAColumn26                                    =  10030,
	kGFF4G2DAColumn27                                    =  10031,
	kGFF4G2DAColumn28                                    =  10032,
	kGFF4G2DAColumn29                                    =  10033,
	kGFF4G2DAColumn30                                    =  10034,
	kGFF4G2DAColumn31                                    =  10035,
	kGFF4G2DAColumn32                                    =  10036,
	kGFF4G2DAColumn33                                    =  10037,
	kGFF4G2DAColumn34                                    =  10038,
	kGFF4G2DAColumn35                                    =  10039,
	kGFF4G2DAColumn36                                    =  10040,
	kGFF4G2DAColumn37                                    =  10041,
	kGFF4G2DAColumn38                                    =  10042,
	kGFF4G2DAColumn39                                    =  10043,
	kGFF4G2DAColumn40                                    =  10044,
	kGFF4G2DAColumn41                                    =  10045,
	kGFF4G2DAColumn42                                    =  10046,
	kGFF4G2DAColumn43                                    =  10047,
	kGFF4G2DAColumn44                                    =  10048,
	kGFF4G2DAColumn45                                    =  10049,
	kGFF4G2DAColumn46                                    =  10050,
	kGFF4G2DAColumn47                                    =  10051,
	kGFF4G2DAColumn48                                    =  10052,
	kGFF4G2DAColumn49                                    =  10053,
	kGFF4G2DAColumn50                                    =  10054,
	kGFF4G2DAColumn51                                    =  10055,
	kGFF4G2DAColumn52                                    =  10056,
	kGFF4G2DAColumn53                                    =  10057,
	kGFF4G2DAColumn54                                    =  10058,
	kGFF4G2DAColumn55                                    =  10059,
	kGFF4G2DAColumn56                                    =  10060,
	kGFF4G2DAColumn57                                    =  10061,
	kGFF4G2DAColumn58                                    =  10062,
	kGFF4G2DAColumn59                                    =  10063,
	kGFF4G2DAColumn60                                    =  10064,
	kGFF4G2DAColumn61                                    =  10065,
	kGFF4G2DAColumn62                                    =  10066,
	kGFF4G2DAColumn63                                    =  10067,
	kGFF4G2DAColumn64                                    =  10068,
	kGFF4G2DAColumn65                                    =  10069,
	kGFF4G2DAColumn66                                    =  10070,
	kGFF4G2DAColumn67                                    =  10071,
	kGFF4G2DAColumn68                                    =  10072,
	kGFF4G2DAColumn69                                    =  10073,
	kGFF4G2DAColumn70                                    =  10074,
	kGFF4G2DAColumn71                                    =  10075,
	kGFF4G2DAColumn72                                    =  10076,
	kGFF4G2DAColumn73                                    =  10077,
	kGFF4G2DAColumn74                                    =  10078,
	kGFF4G2DAColumn75                                    =  10079,
	kGFF4G2DAColumn76                                    =  10080,
	kGFF4G2DAColumn77                                    =  10081,
	kGFF4G2DAColumn78                                    =  10082,
	kGFF4G2DAColumn79                                    =  10083,
	kGFF4G2DAColumn80                                    =  10084,
	kGFF4G2DAColumn81                                    =  10085,
	kGFF4G2DAColumn82                                    =  10086,
	kGFF4G2DAColumn83                                    =  10087,
	kGFF4G2DAColumn84                                    =  10088,
	kGFF4G2DAColumn85                                    =  10089,
	kGFF4G2DAColumn86                                    =  10090,
	kGFF4G2DAColumn87                                    =  10091,
	kGFF4G2DAColumn88                                    =  10092,
	kGFF4G2DAColumn89                                    =  10093,
	kGFF4G2DAColumn90                                    =  10094,
	kGFF4G2DAColumn91                                    =  10095,
	kGFF4G2DAColumn92                                    =  10096,
	kGFF4G2DAColumn93                                    =  10097,
	kGFF4G2DAColumn94                                    =  10098,
	kGFF4G2DAColumn95                                    =  10099,
	kGFF4G2DAColumn96                                    =  10100,
	kGFF4G2DAColumn97                                    =  10101,
	kGFF4G2DAColumn98                                    =  10102,
	kGFF4G2DAColumn99                                    =  10103,

	kGFF4G2DAColumn100                                   =  10104,
	kGFF4G2DAColumn101                                   =  10105,
	kGFF4G2DAColumn102                                   =  10106,
	kGFF4G2DAColumn103                                   =  10107,
	kGFF4G2DAColumn104                                   =  10108,
	kGFF4G2DAColumn105                                   =  10109,
	kGFF4G2DAColumn106                                   =  10110,
	kGFF4G2DAColumn107                                   =  10111,
	kGFF4G2DAColumn108                                   =  10112,
	kGFF4G2DAColumn109                                   =  10113,
	kGFF4G2DAColumn110                                   =  10114,
	kGFF4G2DAColumn111                                   =  10115,
	kGFF4G2DAColumn112                                   =  10116,
	kGFF4G2DAColumn113                                   =  10117,
	kGFF4G2DAColumn114                                   =  10118,
	kGFF4G2DAColumn115                                   =  10119,
	kGFF4G2DAColumn116                                   =  10120,
	kGFF4G2DAColumn117                                   =  10121,
	kGFF4G2DAColumn118                                   =  10122,
	kGFF4G2DAColumn119                                   =  10123,
	kGFF4G2DAColumn120                                   =  10124,
	kGFF4G2DAColumn121                                   =  10125,
	kGFF4G2DAColumn122                                   =  10126,
	kGFF4G2DAColumn123                                   =  10127,
	kGFF4G2DAColumn124                                   =  10128,
	kGFF4G2DAColumn125                                   =  10129,
	kGFF4G2DAColumn126                                   =  10130,
	kGFF4G2DAColumn127                                   =  10131,
	kGFF4G2DAColumn128                                   =  10132,
	kGFF4G2DAColumn129                                   =  10133,
	kGFF4G2DAColumn130                                   =  10134,
	kGFF4G2DAColumn131                                   =  10135,
	kGFF4G2DAColumn132                                   =  10136,
	kGFF4G2DAColumn133                                   =  10137,
	kGFF4G2DAColumn134                                   =  10138,
	kGFF4G2DAColumn135                                   =  10139,
	kGFF4G2DAColumn136                                   =  10140,
	kGFF4G2DAColumn137                                   =  10141,
	kGFF4G2DAColumn138                                   =  10142,
	kGFF4G2DAColumn139                                   =  10143,
	kGFF4G2DAColumn140                                   =  10144,
	kGFF4G2DAColumn141                                   =  10145,
	kGFF4G2DAColumn142                                   =  10146,
	kGFF4G2DAColumn143                                   =  10147,
	kGFF4G2DAColumn144                                   =  10148,
	kGFF4G2DAColumn145                                   =  10149,
	kGFF4G2DAColumn146                                   =  10150,
	kGFF4G2DAColumn147                                   =  10151,
	kGFF4G2DAColumn148                                   =  10152,
	kGFF4G2DAColumn149                                   =  10153,
	kGFF4G2DAColumn150                                   =  10154,
	kGFF4G2DAColumn151                                   =  10155,
	kGFF4G2DAColumn152                                   =  10156,
	kGFF4G2DAColumn153                                   =  10157,
	kGFF4G2DAColumn154                                   =  10158,
	kGFF4G2DAColumn155                                   =  10159,
	kGFF4G2DAColumn156                                   =  10160,
	kGFF4G2DAColumn157                                   =  10161,
	kGFF4G2DAColumn158                                   =  10162,
	kGFF4G2DAColumn159                                   =  10163,
	kGFF4G2DAColumn160                                   =  10164,
	kGFF4G2DAColumn161                                   =  10165,
	kGFF4G2DAColumn162                                   =  10166,
	kGFF4G2DAColumn163                                   =  10167,
	kGFF4G2DAColumn164                                   =  10168,
	kGFF4G2DAColumn165                                   =  10169,
	kGFF4G2DAColumn166                                   =  10170,
	kGFF4G2DAColumn167                                   =  10171,
	kGFF4G2DAColumn168                                   =  10172,
	kGFF4G2DAColumn169                                   =  10173,
	kGFF4G2DAColumn170                                   =  10174,
	kGFF4G2DAColumn171                                   =  10175,
	kGFF4G2DAColumn172                                   =  10176,
	kGFF4G2DAColumn173                                   =  10177,
	kGFF4G2DAColumn174                                   =  10178,
	kGFF4G2DAColumn175                                   =  10179,
	kGFF4G2DAColumn176                                   =  10180,
	kGFF4G2DAColumn177                                   =  10181,
	kGFF4G2DAColumn178                                   =  10182,
	kGFF4G2DAColumn179                                   =  10183,
	kGFF4G2DAColumn180                                   =  10184,
	kGFF4G2DAColumn181                                   =  10185,
	kGFF4G2DAColumn182                                   =  10186,
	kGFF4G2DAColumn183                                   =  10187,
	kGFF4G2DAColumn184                                   =  10188,
	kGFF4G2DAColumn185                                   =  10189,
	kGFF4G2DAColumn186                                   =  10190,
	kGFF4G2DAColumn187                                   =  10191,
	kGFF4G2DAColumn188                                   =  10192,
	kGFF4G2DAColumn189                                   =  10193,
	kGFF4G2DAColumn190                                   =  10194,
	kGFF4G2DAColumn191                                   =  10195,
	kGFF4G2DAColumn192                                   =  10196,
	kGFF4G2DAColumn193                                   =  10197,
	kGFF4G2DAColumn194                                   =  10198,
	kGFF4G2DAColumn195                                   =  10199,
	kGFF4G2DAColumn196                                   =  10200,
	kGFF4G2DAColumn197                                   =  10201,
	kGFF4G2DAColumn198                                   =  10202,
	kGFF4G2DAColumn199                                   =  10203,

	kGFF4G2DAColumn200                                   =  10204,
	kGFF4G2DAColumn201                                   =  10205,
	kGFF4G2DAColumn202                                   =  10206,
	kGFF4G2DAColumn203                                   =  10207,
	kGFF4G2DAColumn204                                   =  10208,
	kGFF4G2DAColumn205                                   =  10209,
	kGFF4G2DAColumn206                                   =  10210,
	kGFF4G2DAColumn207                                   =  10211,
	kGFF4G2DAColumn208                                   =  10212,
	kGFF4G2DAColumn209                                   =  10213,
	kGFF4G2DAColumn210                                   =  10214,
	kGFF4G2DAColumn211                                   =  10215,
	kGFF4G2DAColumn212                                   =  10216,
	kGFF4G2DAColumn213                                   =  10217,
	kGFF4G2DAColumn214                                   =  10218,
	kGFF4G2DAColumn215                                   =  10219,
	kGFF4G2DAColumn216                                   =  10220,
	kGFF4G2DAColumn217                                   =  10221,
	kGFF4G2DAColumn218                                   =  10222,
	kGFF4G2DAColumn219                                   =  10223,
	kGFF4G2DAColumn220                                   =  10224,
	kGFF4G2DAColumn221                                   =  10225,
	kGFF4G2DAColumn222                                   =  10226,
	kGFF4G2DAColumn223                                   =  10227,
	kGFF4G2DAColumn224                                   =  10228,
	kGFF4G2DAColumn225                                   =  10229,
	kGFF4G2DAColumn226                                   =  10230,
	kGFF4G2DAColumn227                                   =  10231,
	kGFF4G2DAColumn228                                   =  10232,
	kGFF4G2DAColumn229                                   =  10233,
	kGFF4G2DAColumn230                                   =  10234,
	kGFF4G2DAColumn231                                   =  10235,
	kGFF4G2DAColumn232                                   =  10236,
	kGFF4G2DAColumn233                                   =  10237,
	kGFF4G2DAColumn234                                   =  10238,
	kGFF4G2DAColumn235                                   =  10239,
	kGFF4G2DAColumn236                                   =  10240,
	kGFF4G2DAColumn237                                   =  10241,
	kGFF4G2DAColumn238                                   =  10242,
	kGFF4G2DAColumn239                                   =  10243,
	kGFF4G2DAColumn240                                   =  10244,
	kGFF4G2DAColumn241                                   =  10245,
	kGFF4G2DAColumn242                                   =  10246,
	kGFF4G2DAColumn243                                   =  10247,
	kGFF4G2DAColumn244                                   =  10248,
	kGFF4G2DAColumn245                                   =  10249,
	kGFF4G2DAColumn246                                   =  10250,
	kGFF4G2DAColumn247                                   =  10251,
	kGFF4G2DAColumn248                                   =  10252,
	kGFF4G2DAColumn249                                   =  10253,
	kGFF4G2DAColumn250                                   =  10254,
	kGFF4G2DAColumn251                                   =  10255,
	kGFF4G2DAColumn252                                   =  10256,
	kGFF4G2DAColumn253                                   =  10257,
	kGFF4G2DAColumn254                                   =  10258,
	kGFF4G2DAColumn255                                   =  10259,
	kGFF4G2DAColumn256                                   =  10260,
	kGFF4G2DAColumn257                                   =  10261,
	kGFF4G2DAColumn258                                   =  10262,
	kGFF4G2DAColumn259                                   =  10263,
	kGFF4G2DAColumn260                                   =  10264,
	kGFF4G2DAColumn261                                   =  10265,
	kGFF4G2DAColumn262                                   =  10266,
	kGFF4G2DAColumn263                                   =  10267,
	kGFF4G2DAColumn264                                   =  10268,
	kGFF4G2DAColumn265                                   =  10269,
	kGFF4G2DAColumn266                                   =  10270,
	kGFF4G2DAColumn267                                   =  10271,
	kGFF4G2DAColumn268                                   =  10272,
	kGFF4G2DAColumn269                                   =  10273,
	kGFF4G2DAColumn270                                   =  10274,
	kGFF4G2DAColumn271                                   =  10275,
	kGFF4G2DAColumn272                                   =  10276,
	kGFF4G2DAColumn273                                   =  10277,
	kGFF4G2DAColumn274                                   =  10278,
	kGFF4G2DAColumn275                                   =  10279,
	kGFF4G2DAColumn276                                   =  10280,
	kGFF4G2DAColumn277                                   =  10281,
	kGFF4G2DAColumn278                                   =  10282,
	kGFF4G2DAColumn279                                   =  10283,
	kGFF4G2DAColumn280                                   =  10284,
	kGFF4G2DAColumn281                                   =  10285,
	kGFF4G2DAColumn282                                   =  10286,
	kGFF4G2DAColumn283                                   =  10287,
	kGFF4G2DAColumn284                                   =  10288,
	kGFF4G2DAColumn285                                   =  10289,
	kGFF4G2DAColumn286                                   =  10290,
	kGFF4G2DAColumn287                                   =  10291,
	kGFF4G2DAColumn288                                   =  10292,
	kGFF4G2DAColumn289                                   =  10293,
	kGFF4G2DAColumn290                                   =  10294,
	kGFF4G2DAColumn291                                   =  10295,
	kGFF4G2DAColumn292                                   =  10296,
	kGFF4G2DAColumn293                                   =  10297,
	kGFF4G2DAColumn294                                   =  10298,
	kGFF4G2DAColumn295                                   =  10299,
	kGFF4G2DAColumn296                                   =  10300,
	kGFF4G2DAColumn297                                   =  10301,
	kGFF4G2DAColumn298                                   =  10302,
	kGFF4G2DAColumn299                                   =  10303,

	kGFF4G2DAColumnType                                  =  10999,

	kGFF4StagePlaceList                                  =  11000,
	kGFF4StageCameraList                                 =  11001,
	kGFF4StagePlacesInShot                               =  11002,
	kGFF4StageCameraFOV                                  =  11003,
	kGFF4StagePlaceDefaultCamera                         =  11004,
	kGFF4StageCameraDeprecated                           =  11005,
	kGFF4StageCameraLookingFrom                          =  11006,
	kGFF4StageCameraLookingAtPrimary                     =  11007,
	kGFF4StageCameraLookingAtSecondary                   =  11008,
	kGFF4StageCameraLookingAtType                        =  11009,

	kGFF4ConversationStartingList                        =  12000,
	kGFF4ConversationStartingIndex                       =  12001,
	kGFF4ConversationLineList                            =  12002,
	kGFF4ConversationEnd                                 =  12003,
	kGFF4ConversationVOBank                              =  12004,

	kGFF4ConversationStageName                           =  12100,
	kGFF4ConversationStageMap                            =  12101,

	kGFF4ConversationKeyTag                              =  12102,
	kGFF4ConversationValueTag                            =  12103,

	kGFF4ConversationStageAtCurrentLocation              =  12104,

	kGFF4ConversationLineText                            =  12201,
	kGFF4ConversationLineSpeaker                         =  12202,
	kGFF4ConversationLineListener                        =  12203,
	kGFF4ConversationLineGameLanguage                    =  12204,
	kGFF4ConversationLineIcon                            =  12205,
	kGFF4ConversationLineVisibility                      =  12206,
	kGFF4ConversationLineAmbient                         =  12207,
	kGFF4ConversationLineCond                            =  12208,
	kGFF4ConversationLineAction                          =  12209,
	kGFF4ConversationLineCutResRef                       =  12210,
	kGFF4ConversationLineCut                             =  12211,
	kGFF4ConversationLineCutMap                          =  12212,
	kGFF4ConversationLineAnimation                       =  12213,
	kGFF4ConversationLineSkip                            =  12214,
	kGFF4ConversationLineFastPath                        =  12215,
	kGFF4ConversationLineNoVOIngame                      =  12216,
	kGFF4ConversationLineRevertAnim                      =  12217,
	kGFF4ConversationLineSlideShowTexture                =  12218,

	kGFF4ConversationPlotGuid                            =  12300,
	kGFF4ConversationPlotFlag                            =  12301,
	kGFF4ConversationPlotTest                            =  12302,
	kGFF4ConversationScript                              =  12303,
	kGFF4ConversationScriptParameter                     =  12304,

	kGFF4ConversationLineChildrenList                    =  12400,

	kGFF4ConversationLineActive                          =  12500,

	kGFF4PlotFlags                                       =  13000,
	kGFF4PlotFlagID                                      =  13001,
	kGFF4PlotFlagName                                    =  13002,
	kGFF4PlotFlagReward                                  =  13003,
	kGFF4PlotFlagJournal                                 =  13004,
	kGFF4PlotFlagEndsPlot                                =  13005,
	kGFF4PlotFlagMultiReward                             =  13006,
	kGFF4PlotGuid                                        =  13007,
	kGFF4PlotName                                        =  13008,
	kGFF4PlotScript                                      =  13009,
	kGFF4PlotPriority                                    =  13010,
	kGFF4PlotFlags1                                      =  13011,
	kGFF4PlotFlags2                                      =  13012,
	kGFF4PlotFlags3                                      =  13013,
	kGFF4PlotFlags4                                      =  13014,
	kGFF4PlotJournalImage                                =  13015,
	kGFF4PlotPlots                                       =  13016,
	kGFF4PlotParentPlot                                  =  13017,
	kGFF4PlotFlagAreaLocationTag                         =  13018,
	kGFF4PlotAssistList                                  =  13019,
	kGFF4PlotAssistTag                                   =  13020,
	kGFF4PlotAssistAdvancesPlot                          =  13021,
	kGFF4PlotEntryType                                   =  13022,
	kGFF4PlotAllowPausing                                =  13023,
	kGFF4PlotFlagOfferID                                 =  13024,
	kGFF4PlotParentPlotGuid                              =  13025,

	kGFF4TintMaskDiffuseR                                =  14000,
	kGFF4TintMaskDiffuseG                                =  14001,
	kGFF4TintMaskDiffuseB                                =  14002,
	kGFF4TintMaskSpecularR                               =  14003,
	kGFF4TintMaskSpecularG                               =  14004,
	kGFF4TintMaskSpecularB                               =  14005,
	kGFF4TintMaskDiffuseA                                =  14006,
	kGFF4TintMaskSpecularA                               =  14007,
	kGFF4TintMaskDiffuseOpacity                          =  14008,
	kGFF4TintMaskSpecularOpacity                         =  14009,

	kGFF4MatFileObjectVersion                            =  15000,
	kGFF4MatChildList                                    =  15001,

	kGFF4MatRoot                                         =  15010,
	kGFF4MatRootName                                     =  15011,
	kGFF4MatModel                                        =  15012,
	kGFF4MatModelName                                    =  15013,
	kGFF4MatPart                                         =  15014,
	kGFF4MatPartName                                     =  15015,
	kGFF4MatPartMMHParent                                =  15016,
	kGFF4MatMatLib                                       =  15017,
	kGFF4MatMatLibName                                   =  15018,
	kGFF4MatMatObj                                       =  15019,
	kGFF4MatMatObjName                                   =  15020,
	kGFF4MatLight                                        =  15021,
	kGFF4MatLightName                                    =  15022,
	kGFF4MatLightRig                                     =  15023,
	kGFF4MatLightRigName                                 =  15024,
	kGFF4MatLightProbe                                   =  15025,
	kGFF4MatLightProbeName                               =  15026,
	kGFF4MatGroup                                        =  15027,
	kGFF4MatGroupName                                    =  15028,
	kGFF4MatPalettelIb                                   =  15029,
	kGFF4MatPalettelIbName                               =  15030,
	kGFF4MatPaletteObj                                   =  15031,
	kGFF4MatPaletteObjName                               =  15032,
	kGFF4MatHeraldryLib                                  =  15033,
	kGFF4MatHeraldryLibName                              =  15034,
	kGFF4MatHeraldryObj                                  =  15035,
	kGFF4MatHeraldryObjName                              =  15036,
	kGFF4MatDuplicate                                    =  15037,
	kGFF4MatDuplicateName                                =  15038,
	kGFF4MatLayoutName                                   =  15039,
	kGFF4MatTintLib                                      =  15040,
	kGFF4MatTintLibName                                  =  15041,
	kGFF4MatTintObj                                      =  15042,
	kGFF4MatTintObjName                                  =  15043,

	kGFF4MatMaterialType                                 =  15050,
	kGFF4MatBasicParams                                  =  15051,
	kGFF4MatShinyTrans                                   =  15052,
	kGFF4MatTwoSide                                      =  15053,
	kGFF4MatHair                                         =  15054,
	kGFF4MatDyncLight                                    =  15055,
	kGFF4MatBlendMode                                    =  15056,
	kGFF4MatName                                         =  15057,
	kGFF4MatMaterialTypeString                           =  15058,
	kGFF4MatMaterialSemantic                             =  15059,
	kGFF4MatMaterialSoundType                            =  15060,

	kGFF4MatDiffuseMapType                               =  15070,
	kGFF4MatDiffuseMapColor                              =  15071,
	kGFF4MatDiffuseMapScale                              =  15072,
	kGFF4MatDiffuseMap                                   =  15073,
	kGFF4MatDiffuseFileName                              =  15074,
	kGFF4MatDiffOpacDimensionX                           =  15075,
	kGFF4MatDiffOpacDimensionY                           =  15076,
	kGFF4MatDiffOpacCompression                          =  15077,
	kGFF4MatDiffOpacCompressionXbox360                   =  15078,

	kGFF4MatSecondaryDiffuseMapEnable                    =  15080,
	kGFF4MatSecondaryDiffuseMap                          =  15081,
	kGFF4MatSecondaryDiffuseFileName                     =  15082,
	kGFF4MatSecondaryDiffuseCompression                  =  15085,
	kGFF4MatSecondaryDiffuseCompressionXbox360           =  15086,

	kGFF4MatOpacitymapenable                             =  15100,
	kGFF4MatOpacitymaptype                               =  15101,
	kGFF4MatOpacitymapcolor                              =  15102,
	kGFF4MatOpacitymapscale                              =  15103,
	kGFF4MatOpacitymap                                   =  15104,

	kGFF4MatSpecularMapEnable                            =  15130,
	kGFF4MatSpecularMapType                              =  15131,
	kGFF4MatSpecularMapColor                             =  15132,
	kGFF4MatSpecularMapScale                             =  15133,
	kGFF4MatSpecularMap                                  =  15134,
	kGFF4MatSpecularGlossType                            =  15135,
	kGFF4MatSpecularGlossColor                           =  15136,
	kGFF4MatSpecularGlossScale                           =  15137,
	kGFF4MatSpecularGloss                                =  15138,
	kGFF4MatSpecularFileName                             =  15139,
	kGFF4MatSpecularDimensionX                           =  15140,
	kGFF4MatSpecularDimensionY                           =  15141,
	kGFF4MatSpecularCompression                          =  15142,
	kGFF4MatSpecularCompressionXbox360                   =  15143,
	kGFF4MatSpecularReflectionMultiplier                 =  15144,

	kGFF4MatNormalMapEnable                              =  15160,
	kGFF4MatNormalMap                                    =  15161,
	kGFF4MatNormalFileName                               =  15162,
	kGFF4MatNormalCompression                            =  15163,
	kGFF4MatNormalCompressionXbox360                     =  15164,

	kGFF4MatTintMapEnable                                =  15190,
	kGFF4MatTintMap                                      =  15191,

	kGFF4MatTintREnable                                  =  15192,
	kGFF4MatTintGEnable                                  =  15193,
	kGFF4MatTintBEnable                                  =  15194,
	kGFF4MatTintFileNamePostfix                          =  15195,

	kGFF4MatTintCompression                              =  15196,
	kGFF4MatTintCompressionXbox360                       =  15197,

	kGFF4MatTintAEnable                                  =  15198,
	kGFF4MatTintRSpecularIntensity                       =  15199,
	kGFF4MatTintGSpecularIntensity                       =  15200,
	kGFF4MatTintBSpecularIntensity                       =  15201,
	kGFF4MatTintASpecularIntensity                       =  15202,
	kGFF4MatTintRDiffuseIntensity                        =  15203,
	kGFF4MatTintGDiffuseIntensity                        =  15204,
	kGFF4MatTintBDiffuseIntensity                        =  15205,
	kGFF4MatTintADiffuseIntensity                        =  15206,
	kGFF4MatTintRSpecularOpacity                         =  15207,
	kGFF4MatTintGSpecularOpacity                         =  15208,
	kGFF4MatTintBSpecularOpacity                         =  15209,
	kGFF4MatTintASpecularOpacity                         =  15210,
	kGFF4MatTintRDiffuseOpacity                          =  15211,
	kGFF4MatTintGDiffuseOpacity                          =  15212,
	kGFF4MatTintBDiffuseOpacity                          =  15213,
	kGFF4MatTintADiffuseOpacity                          =  15214,
	kGFF4MatTintType                                     =  15215,

	kGFF4MatTintMaskTintChannel1                         =  15216,
	kGFF4MatTintMaskTintChannel2                         =  15217,
	kGFF4MatTintMaskTintChannel3                         =  15218,
	kGFF4MatTintMaskTintChannel4                         =  15219,

	kGFF4MatReliefMapEnable                              =  15220,
	kGFF4MatReliefMap                                    =  15221,
	kGFF4MatReliefMapScale                               =  15222,
	kGFF4MatReliefMapSamples                             =  15223,
	kGFF4MatReliefMapShadowOffset                        =  15224,
	kGFF4MatReliefMapInOut                               =  15225,
	kGFF4MatReliefCompression                            =  15226,
	kGFF4MatReliefCompressionXbox360                     =  15227,

	kGFF4MatTintExportable                               =  15228,

	kGFF4MatVFXContactSheetWidth                         =  15250,
	kGFF4MatVFXContactSheetHeight                        =  15251,
	kGFF4MatVFXContactSheetFrames                        =  15252,
	kGFF4MatVFXScrollSpeedU                              =  15253,
	kGFF4MatVFXScrollSpeedV                              =  15254,
	kGFF4MatVFXDepthBiasAlpha                            =  15255,
	kGFF4MatVFXStartAlphaFresnel                         =  15256,
	kGFF4MatVFXEndAlphaFresnel                           =  15257,
	kGFF4MatVFXInvertAlphaFresnel                        =  15258,

	kGFF4MatFresnelMapEnable                             =  15280,
	kGFF4MatFresnelMap                                   =  15281,
	kGFF4MatFresnelFileName                              =  15282,
	kGFF4MatFresnelCompression                           =  15283,
	kGFF4MatFresnelCompressionXbox360                    =  15284,

	kGFF4MatEmissiveMapEnable                            =  15310,
	kGFF4MatEmissiveMap                                  =  15311,
	kGFF4MatEmissiveFileName                             =  15312,
	kGFF4MatEmissiveCompression                          =  15313,
	kGFF4MatEmissiveCompressionXbox360                   =  15314,

	kGFF4MatSectionMaskMapEnable                         =  15340,
	kGFF4MatSectionMaskMap                               =  15341,
	kGFF4MatSectionMaskFileName                          =  15342,
	kGFF4MatSectionMaskCompression                       =  15343,
	kGFF4MatSectionMaskCompressionXbox360                =  15344,

	kGFF4MatSecondaryNormalMapEnable                     =  15360,
	kGFF4MatSecondaryNormalMap                           =  15361,
	kGFF4MatSecondaryNormalFileName                      =  15362,
	kGFF4MatSecondaryNormalCompression                   =  15363,
	kGFF4MatSecondaryNormalCompressionXbox360            =  15364,

	kGFF4MatEyeCorneaSpecularMask                        =  15380,
	kGFF4MatEyeCorneaSpecularPower                       =  15381,
	kGFF4MatEyeScleraSpecularMask                        =  15382,
	kGFF4MatEyeScleraSpecularPower                       =  15383,
	kGFF4MatEyeCorneaReflectionMultiplier                =  15384,

	kGFF4MatSpecularMaskMapEnable                        =  15400,
	kGFF4MatPackedTextureMap                             =  15401,
	kGFF4MatPackedTextureFileName                        =  15402,
	kGFF4MatPackedTextureCompression                     =  15403,
	kGFF4MatPackedTextureCompressionXbox360              =  15404,

	kGFF4MatSpecularShiftMapEnable                       =  15420,
	kGFF4MatTintNoiseMap                                 =  15421,
	kGFF4MatTintNoiseFileName                            =  15422,
	kGFF4MatTintNoiseCompression                         =  15423,
	kGFF4MatTintNoiseCompressionXbox360                  =  15424,

	kGFF4MatHairDiffuseTint                              =  15440,
	kGFF4MatHairPrimarySpecularPower                     =  15441,
	kGFF4MatHairPrimarySpecularMask                      =  15442,
	kGFF4MatHairSecondarySpecularPower                   =  15443,
	kGFF4MatHairSecondarySpecularTint                    =  15444,
	kGFF4MatHairTintNoiseTiling                          =  15445,

	kGFF4MatSun                                          =  15460,
	kGFF4MatSunName                                      =  15461,
	kGFF4MatSunDirection                                 =  15462,
	kGFF4MatSunColor                                     =  15463,
	kGFF4MatSunColormult                                 =  15464,

	kGFF4MatHeraldryMapEnable                            =  15480,
	kGFF4MatHeraldryMap                                  =  15481,
	kGFF4MatHeraldryFileName                             =  15482,
	kGFF4MatHeraldryCompression                          =  15483,
	kGFF4MatHeraldryCompressionXbox360                   =  15484,

	kGFF4MatRimLightWidth                                =  15500,
	kGFF4MatRimLightMultiplier                           =  15501,
	kGFF4MatFalloffWidth                                 =  15502,
	kGFF4MatFalloffMultiplier                            =  15503,

	kGFF4MatAmbientMultiplier                            =  15510,
	kGFF4MatSpecularMultiplier                           =  15511,
	kGFF4MatLipSpecularBoost                             =  15512,
	kGFF4MatRimPower                                     =  15513,

	kGFF4MatDistortionMapEnable                          =  15520,
	kGFF4MatDistortionMap                                =  15521,
	kGFF4MatDistortionFileName                           =  15522,
	kGFF4MatDistortionCompression                        =  15523,
	kGFF4MatDistortionCompressionXbox360                 =  15524,

	kGFF4MatDistortionModifiersMapEnable                 =  15540,
	kGFF4MatDistortionModifiersMap                       =  15541,
	kGFF4MatDistortionModifiersFileName                  =  15542,
	kGFF4MatDistortionModifiersCompression               =  15543,
	kGFF4MatDistortionModifiersCompressionXbox360        =  15544,

	kGFF4MatDistortionMagnitude                          =  15560,
	kGFF4MatDistortionInvert                             =  15561,
	kGFF4MatDistortionFadeDistance                       =  15562,
	kGFF4MatDistortionFadeMultiplier                     =  15563,

	kGFF4MatAlternateDecalMap                            =  15580,
	kGFF4MatAlternateDecalFileName                       =  15581,
	kGFF4MatAlternateDecalCompression                    =  15582,
	kGFF4MatAlternateDecalCompressionXbox360             =  15583,

	kGFF4MatTattooMaskMap                                =  15590,
	kGFF4MatTattooMaskFileName                           =  15591,
	kGFF4MatTattooMaskCompression                        =  15592,
	kGFF4MatTattooMaskCompressionXbox360                 =  15593,
	kGFF4MatTattooMaskMapEnable                          =  15594,

	kGFF4MatTattooMaskTintChannel1                       =  15595,
	kGFF4MatTattooMaskTintChannel2                       =  15596,
	kGFF4MatTattooMaskTintChannel3                       =  15597,
	kGFF4MatTattooMaskTintChannel4                       =  15598,

	kGFF4MatBrowStubbleMap                               =  15600,
	kGFF4MatBrowStubbleFileName                          =  15601,
	kGFF4MatBrowStubbleCompression                       =  15602,
	kGFF4MatBrowStubbleCompressionXbox360                =  15603,

	kGFF4MatBrowStubbleNormalMap                         =  15610,
	kGFF4MatBrowStubbleNormalFileName                    =  15611,
	kGFF4MatBrowStubbleNormalCompression                 =  15612,
	kGFF4MatBrowStubbleNormalCompressionXbox360          =  15613,

	kGFF4MatEmotionsMask0Map                             =  15620,
	kGFF4MatEmotionsMask0FileName                        =  15621,
	kGFF4MatEmotionsMask0Compression                     =  15622,
	kGFF4MatEmotionsMask0CompressionXbox360              =  15623,

	kGFF4MatEmotionsMask1Map                             =  15630,
	kGFF4MatEmotionsMask1FileName                        =  15631,
	kGFF4MatEmotionsMask1Compression                     =  15632,
	kGFF4MatEmotionsMask1CompressionXbox360              =  15633,

	kGFF4MatEmotionsNormalMap                            =  15640,
	kGFF4MatEmotionsNormalFileName                       =  15641,
	kGFF4MatEmotionsNormalCompression                    =  15642,
	kGFF4MatEmotionsNormalCompressionXbox360             =  15643,

	kGFF4MatScrollSpeed1                                 =  15650,
	kGFF4MatScrollSpeed2                                 =  15651,
	kGFF4MatScrollSpeed3                                 =  15652,
	kGFF4MatLavaTintColor                                =  15653,
	kGFF4MatLavaBrightness                               =  15654,
	kGFF4MatLavaContrast                                 =  15655,
	kGFF4MatLavaNoiseMap                                 =  15656,

	kGFF4SavegameCampaign                                =  16000,
	kGFF4SavegameAreaList                                =  16001,
	kGFF4SavegamePlayerchar                              =  16002,
	kGFF4SavegamePartyList                               =  16003,
	kGFF4SavegameVersion                                 =  16004,
	kGFF4SavegameGameState                               =  16005,
	kGFF4SavegameAddinsList                              =  16006,
	kGFF4SavegameCheatUsed                               =  16007,
	kGFF4SavegameStorySoFar                              =  16008,

	kGFF4SavegameAreaPlaceables                          =  16010,
	kGFF4SavegameAreaCreatures                           =  16011,
	kGFF4SavegameAreaTriggers                            =  16012,
	kGFF4SavegameAreaAOEs                                =  16013,
	kGFF4SavegameCampaignResource                        =  16014,
	kGFF4SavegameAreaWaypoints                           =  16015,
	kGFF4SavegameAreaMap                                 =  16016,
	kGFF4SavegameAreaStores                              =  16017,
	kGFF4SavegameAreaRoomsViewed                         =  16018,
	kGFF4SavegameAreaSounds                              =  16019,
	kGFF4SavegameAreaMinCreatureImportance               =  16020,

	kGFF4SavegameAreaPlaceableState                      =  16100,
	kGFF4SavegameAreaTriggerGeometry                     =  16101,
	kGFF4SavegameAreaPlaceableUseable                    =  16102,
	kGFF4SavegameAreaTriggerDetectable                   =  16103,
	kGFF4SavegameAreaTriggerDisarmable                   =  16104,
	kGFF4SavegameAreaTriggerDCDetectCheck                =  16105,
	kGFF4SavegameAreaTriggerDCDisarmCheck                =  16106,
	kGFF4SavegameAreaTriggerLastDisarmed                 =  16107,
	kGFF4SavegameAreaTriggerReverbPreset                 =  16108,
	kGFF4SavegameAreaTriggerPriority                     =  16109,
	kGFF4SavegameAreaTriggerLoadScreen                   =  16110,
	kGFF4SavegameAreaTriggerSounds                       =  16111,
	kGFF4SavegameAreaTriggerType                         =  16112,

	kGFF4SavegameAreaTriggerMusicVolumeEnterState        =  16113,
	kGFF4SavegameAreaTriggerMusicVolumeExitState         =  16114,
	kGFF4SavegameAreaTriggerMusicVolumeEnterStateDelay   =  16115,
	kGFF4SavegameAreaTriggerMusicVolumeExitStateDelay    =  16116,

	kGFF4SavegameStoreMarkDown                           =  16150,
	kGFF4SavegameStoreMarkUp                             =  16151,
	kGFF4SavegameStoreGold                               =  16152,
	kGFF4SavegameStoreMaxBuyPrice                        =  16153,
	kGFF4SavegameStoreWillNotBuy                         =  16154,
	kGFF4SavegameStoreWillOnlyBuy                        =  16155,
	kGFF4SavegameStoreItemList                           =  16156,

	kGFF4SavegamePlayercharArea                          =  16200,
	kGFF4SavegameObjectActive                            =  16201,
	kGFF4SavegameObjectAILevel                           =  16202,

	kGFF4SavegamePartyMembers                            =  16203,
	kGFF4SavegamePartyPoolMembers                        =  16204,
	kGFF4SavegamePartyMemCreature                        =  16205,
	kGFF4SavegamePartyMemTemplate                        =  16206,
	kGFF4SavegamePartyCreatures                          =  16207,
	kGFF4SavegamePlayerCharChar                          =  16208,

	kGFF4SavegameCreatureStats                           =  16209,
	kGFF4SavegameBackpack                                =  16210,
	kGFF4SavegamePlotItems                               =  16211,
	kGFF4SavegameMoney                                   =  16212,
	kGFF4SavegameQuickItems                              =  16213,
	kGFF4SavegameEquipment                               =  16214,
	kGFF4SavegameEquipmentSet                            =  16215,
	kGFF4SavegameEquipmentSetSlot                        =  16216,
	kGFF4SavegameEquipmentSetObject                      =  16217,
	kGFF4SavegameEquipmentActiveSet                      =  16218,
	kGFF4SavegameEquipmentItems                          =  16219,

	kGFF4SavegameObjectImmortal                          =  16220,
	kGFF4SavegameObjectEventScript                       =  16221,
	kGFF4SavegameObjectTag                               =  16222,

	kGFF4SavegameItems                                   =  16223,
	kGFF4SavegameItemDroppable                           =  16224,
	kGFF4SavegameItemDamaged                             =  16225,
	kGFF4SavegameMaxItems                                =  16226,
	kGFF4SavegameCraftingRecipeList                      =  16227,
	kGFF4SavegameItemIrremovable                         =  16228,
	kGFF4SavegameItemIndestructible                      =  16229,
	kGFF4SavegameItemMaterialType                        =  16230,
	kGFF4SavegameItemStealable                           =  16231,
	kGFF4SavegameItemInfinite                            =  16232,
	kGFF4SavegameItemCurrentVFXPropertyID                =  16233,
	kGFF4SavegameItemCurrentVFXPropertyPower             =  16234,

	kGFF4SavegameObjectPlot                              =  16250,
	kGFF4SavegameObjectHealth                            =  16251,
	kGFF4SavegameObjectMaxHealth                         =  16252,
	kGFF4SavegameObjectRank                              =  16253,
	kGFF4SavegameObjectTreasureGroup                     =  16254,
	kGFF4SavegameObjectName                              =  16255,
	kGFF4SavegameObjectLoopingAnimation                  =  16256,
	kGFF4SavegameObjectLootableCreatureAppearanceType    =  16257,
	kGFF4SavegameObjectPickLock                          =  16258,
	kGFF4SavegameObjectTrapDetected                      =  16259,
	kGFF4SavegameObjectDCDetectCheck                     =  16260,
	kGFF4SavegameObjectDCDisarmCheck                     =  16261,
	kGFF4SavegameObjectInteractionRadius                 =  16262,
	kGFF4SavegameObjectImportance                        =  16263,

	kGFF4SavegameSelectedCharacter                       =  16270,
	kGFF4SavegameFollowerLastEnabledArea                 =  16271,
	kGFF4SavegameFollowerLastEnabledPosition             =  16272,
	kGFF4SavegameFollowerLastEnabledOrientation          =  16273,
	kGFF4SavegamePartyPickerGUIStatus                    =  16274,
	kGFF4SavegamePartyApprovalList                       =  16275,
	kGFF4SavegamePartyApprovalID                         =  16276,
	kGFF4SavegamePartyApprovalLevel                      =  16277,
	kGFF4SavegamePartyLeader                             =  16278,
	kGFF4SavegameNonPartyMembers                         =  16279,
	kGFF4SavegamePartyMemberSubstate                     =  16280,
	kGFF4SavegamePartyMemberLocked                       =  16281,
	kGFF4SavegamePartyMemberFollow                       =  16282,
	kGFF4SavegamePartyItemStorageItem                    =  16284,
	kGFF4SavegamePartyItemStorageOwner                   =  16285,
	kGFF4SavegamePartyItemStorageSlot                    =  16286,
	kGFF4SavegamePartyItemStorageWeaponset               =  16287,
	kGFF4SavegamePartyItemStorageList                    =  16288,
	kGFF4SavegamePartyNewItemID                          =  16289,
	kGFF4SavegamePartyNewItemList                        =  16290,
	kGFF4SavegamePartyAutoLevelDefault                   =  16291,
	kGFF4SavegamePartyQuickbarLocked                     =  16292,
	kGFF4SavegamePartyHoldPositions                      =  16293,
	kGFF4SavegamePartyRunInDriveMode                     =  16294,

	kGFF4SavegamePlayerMapZoom                           =  16295,
	kGFF4SavegamePlayerMapLegend                         =  16296,

	kGFF4SavegamePartyApprovalDesc                       =  16297,
	kGFF4SavegamePlayerTimePlayed                        =  16298,
	kGFF4SavegamePartyBackpackSort                       =  16299,

	kGFF4SavegameStatPropertyBase                        =  16300,
	kGFF4SavegameStatPropertyModifier                    =  16301,
	kGFF4SavegameStatPropertyCurrent                     =  16302,
	kGFF4SavegameStatPropertyComRegen                    =  16303,
	kGFF4SavegameStatPropertyRegen                       =  16304,

	kGFF4SavegameSpellList                               =  16305,
	kGFF4SavegameTalentList                              =  16306,
	kGFF4SavegameSkillList                               =  16307,
	kGFF4SavegameQuickslots                              =  16308,
	kGFF4SavegameAbilityList                             =  16309,
	kGFF4SavegameQbarExpansionValue                      =  16310,
	kGFF4SavegameQuickslotAbility                        =  16311,
	kGFF4SavegameQuickslotItemTag                        =  16312,
	kGFF4SavegameQuickslots1                             =  16313,
	kGFF4SavegameQuickslots2                             =  16314,
	kGFF4SavegameQuickslots3                             =  16315,
	kGFF4SavegameQuickslots4                             =  16316,
	kGFF4SavegameCurentQbar                              =  16317,
	kGFF4SavegameLockQbar                                =  16318,
	kGFF4SavegameQuickslotTemplate                       =  16319,

	kGFF4SavegameAppearance                              =  16320,
	kGFF4SavegameAppearanceType                          =  16321,
	kGFF4SavegameAppearanceGender                        =  16322,
	kGFF4SavegameAppearanceGore                          =  16324,
	kGFF4SavegameAppearanceDecapitated                   =  16325,
	kGFF4SavegameAppearanceItemHeraldryVariation         =  16326,
	kGFF4SavegameAppearanceOriginalType                  =  16327,
	kGFF4SavegameAppearanceMorphName                     =  16328,

	kGFF4SavegameAutoLevelUp                             =  16329,
	kGFF4SavegamePromptAutoLevelUp                       =  16330,
	kGFF4SavegameQuickslotNumber                         =  16331,

	kGFF4SavegamePlayerPortraitPitch                     =  16332,
	kGFF4SavegamePlayerPortraitYaw                       =  16333,
	kGFF4SavegamePlayerPortraitTint                      =  16334,
	kGFF4SavegamePlayerPortraitExpression                =  16335,
	kGFF4SavegamePlayerPortraitDistance                  =  16336,
	kGFF4SavegamePlayerPortraitPositionH                 =  16337,
	kGFF4SavegamePlayerPortraitPositionV                 =  16338,

	kGFF4SavegameStatList                                =  16350,
	kGFF4SavegameHeroicStatList                          =  16351,
	kGFF4SavegameHeroicPartyStatList                     =  16352,
	kGFF4SavegameStatPropertyIndex                       =  16353,
	kGFF4SavegameStatPropertyMin                         =  16354,
	kGFF4SavegameStatPropertyMax                         =  16355,

	kGFF4SavegamePlotManager                             =  16400,
	kGFF4SavegamePlotList                                =  16401,
	kGFF4SavegamePlotGuid                                =  16402,
	kGFF4SavegamePlotFlags1                              =  16403,
	kGFF4SavegamePlotFlags2                              =  16404,
	kGFF4SavegamePlotFlags3                              =  16405,
	kGFF4SavegamePlotFlags4                              =  16406,

	kGFF4StructSavegameAddinUID                          =  16420,
	kGFF4StructSavegameAddinENUS                         =  16421,
	kGFF4StructSavegameAddinFRFR                         =  16422,
	kGFF4StructSavegameAddinITIT                         =  16423,
	kGFF4StructSavegameAddinDEDE                         =  16424,
	kGFF4StructSavegameAddinESES                         =  16425,
	kGFF4StructSavegameAddinPLPL                         =  16426,
	kGFF4StructSavegameAddinRURU                         =  16427,
	kGFF4StructSavegameAddinPseudo                       =  16428,
	kGFF4StructSavegameAddinCSCZ                         =  16429,
	kGFF4StructSavegameAddinHUHU                         =  16430,

	kGFF4SavegameGroupList                               =  16450,
	kGFF4SavegameGroupID                                 =  16451,
	kGFF4SavegameGroupHostiles                           =  16452,
	kGFF4SavegameTeamID                                  =  16453,
	kGFF4SavegameCreatureStealth                         =  16454,
	kGFF4SavegameIsPlotGiver                             =  16455,
	kGFF4SavegameCanLevelUp                              =  16456,
	kGFF4SavegameCreatureTrackable                       =  16457,
	kGFF4SavegameCreatureControllable                    =  16458,
	kGFF4SavegameCreatureInteractive                     =  16459,
	kGFF4SavegameCreatureRace                            =  16460,
	kGFF4SavegameCreaturePackage                         =  16461,
	kGFF4SavegameCreaturePackageAI                       =  16462,
	kGFF4SavegameCreatureCanChangeEquipment              =  16463,
	kGFF4SavegameCreatureClassRankList                   =  16464,
	kGFF4SavegameCreatureClassID                         =  16465,
	kGFF4SavegameCreatureClassRank                       =  16466,
	kGFF4SavegameCreatureIsGhost                         =  16467,
	kGFF4SavegameCreatureModalAbilityList                =  16468,
	kGFF4SavegameCreatureShowAsAllyOnMap                 =  16469,
	kGFF4SavegameCreatureIsStatue                        =  16470,
	kGFF4SavegameCreatureMinimizedSkillHeaderList        =  16471,
	kGFF4SavegameCreatureMinimizedTalentHeaderList       =  16472,
	kGFF4SavegameCreatureAbilityHeaderID                 =  16473,
	kGFF4SavegameCreatureItemsScaled                     =  16474,

	kGFF4SavegameCreatureHeartbeatInterval               =  16475,

	kGFF4SavegameCreatureRoamRadius                      =  16476,
	kGFF4SavegameCreatureRoamCenter                      =  16477,

	kGFF4SavegameCreaturePoolName                        =  16478,
	kGFF4SavegameCreaturePoolAvailable                   =  16479,

	kGFF4SavegameCreatureNoPermDeath                     =  16480,
	kGFF4SavegameCreatureTimeSinceDeath                  =  16481,

	kGFF4SavegameCreatureTimeBeforeDecay                 =  16499,

	kGFF4SavegameWorldDatabase                           =  16500,
	kGFF4SavegameWorldDBIDgroup                          =  16501,
	kGFF4SavegameWorldDBLastID                           =  16502,

	kGFF4SavegamePartySeenLines                          =  16503,

	kGFF4SavegameJournal                                 =  16504,
	kGFF4SavegameJournalActiveList                       =  16505,
	kGFF4SavegameJournalCompleteList                     =  16506,
	kGFF4SavegameJournalTitle                            =  16507,
	kGFF4SavegameJournalText                             =  16508,
	kGFF4SavegameJournalParentPlot                       =  16509,
	kGFF4SavegameJournalResRef                           =  16510,
	kGFF4SavegameJournalStoryText                        =  16511,
	kGFF4SavegameJournalAreaTag                          =  16512,
	kGFF4SavegameJournalPlotDestinationList              =  16513,
	kGFF4SavegameJournalPlotDestinationTag               =  16514,
	kGFF4SavegameJournalPlotDestinationGuidList          =  16515,
	kGFF4SavegameJournalConversationList                 =  16516,
	kGFF4SavegameJournalConversationLineList             =  16517,
	kGFF4SavegameJournalConversationLineSpeaker          =  16518,
	kGFF4SavegameJournalConversationLineText             =  16519,
	kGFF4SavegameJournalConversationLineReply            =  16520,
	kGFF4SavegameJournalUnreadCodexList                  =  16521,
	kGFF4SavegameJournalOrphanList                       =  16522,
	kGFF4SavegameJournalQuestCompleted                   =  16523,
	kGFF4SavegameJournalQuestGroup                       =  16524,
	kGFF4SavegameJournalGroupList                        =  16525,
	kGFF4SavegameJournalGroupResRef                      =  16526,
	kGFF4SavegameJournalGroupOpenInCurrent               =  16527,
	kGFF4SavegameJournalGroupOpenInCompleted             =  16528,
	kGFF4SavegameJournalGroupPriority                    =  16529,

	kGFF4SavegameAmbientDialogList                       =  16530,
	kGFF4SavegameAmbientDialogOwner                      =  16531,
	kGFF4SavegameAmbientDialogSpeaker                    =  16532,
	kGFF4SavegameAmbientDialogResRef                     =  16533,
	kGFF4SavegameAmbientDialogLine                       =  16534,

	kGFF4SavegameJournalQuestUpdated                     =  16540,
	kGFF4SavegameJournalOfferID                          =  16541,

	kGFF4SavegameBodybagID                               =  16600,
	kGFF4SavegameIsBodybag                               =  16601,
	kGFF4SavegameLootableObjectID                        =  16602,

	kGFF4SavegameAOEID                                   =  16603,
	kGFF4SavegameAOEShape                                =  16604,
	kGFF4SavegameAOERadius                               =  16605,
	kGFF4SavegameAOEWidth                                =  16606,
	kGFF4SavegameAOELength                               =  16607,
	kGFF4SavegameAOECreator                              =  16608,
	kGFF4SavegameAOEDuration                             =  16609,
	kGFF4SavegameAOEDurationType                         =  16610,
	kGFF4SavegameAOELinked                               =  16611,

	kGFF4SavegameCreatureRank                            =  16612,

	kGFF4SavegameEffectID                                =  16613,
	kGFF4SavegameEffectType                              =  16614,
	kGFF4SavegameEffectDurationType                      =  16615,
	kGFF4SavegameEffectDuration                          =  16616,
	kGFF4SavegameEffectSubType                           =  16617,
	kGFF4SavegameEffectTimeIndex                         =  16618,
	kGFF4SavegameEffectAnimation                         =  16619,
	kGFF4SavegameEffectPriority                          =  16620,
	kGFF4SavegameEffectCreator                           =  16621,
	kGFF4SavegameEffectAbilityID                         =  16622,
	kGFF4SavegameEffectList                              =  16623,
	kGFF4SavegameEffectEngineData                        =  16624,
	kGFF4SavegameEffectResource2                         =  16625,
	kGFF4SavegameEffectStartingID                        =  16626,
	kGFF4SavegameEffectFlags                             =  16627,

	kGFF4SavegameAIMaster                                =  16636,
	kGFF4SavegameEventQueue                              =  16630,
	kGFF4SavegameEventDay                                =  16631,
	kGFF4SavegameEventTime                               =  16632,
	kGFF4SavegameEventCallerID                           =  16633,
	kGFF4SavegameEventTargetID                           =  16634,
	kGFF4SavegameEventID                                 =  16635,

	kGFF4SavegameDataarray                               =  16640,
	kGFF4SavegameDataarrayInt                            =  16641,
	kGFF4SavegameDataarrayFloat                          =  16642,
	kGFF4SavegameDataarrayBool                           =  16643,
	kGFF4SavegameDataarrayOID                            =  16644,
	kGFF4SavegameDataarrayString                         =  16645,
	kGFF4SavegameDataarrayVector                         =  16646,
	kGFF4SavegameDataarrayQuaternion                     =  16647,

	kGFF4SavegameEventScript                             =  16650,
	kGFF4SavegameEventSimpleValue                        =  16651,

	kGFF4SavegameScriptEventType                         =  16670,
	kGFF4SavegameScriptEventCreator                      =  16671,
	kGFF4SavegameScriptEventTarget                       =  16672,
	kGFF4SavegameScriptEventData                         =  16673,
	kGFF4SavegameScriptEventScriptName                   =  16674,
	kGFF4SavegameScriptEventResourceList                 =  16675,

	kGFF4SavegameWorldTimer                              =  16700,
	kGFF4SavegameWorldTimerDay                           =  16701,
	kGFF4SavegameWorldTimerTime                          =  16702,

	kGFF4SavegameWaypointMapNote                         =  16710,
	kGFF4SavegameWaypointMapNoteEnabled                  =  16711,
	kGFF4SavegameWaypointMapNoteText                     =  16712,
	kGFF4SavegameWaypointMapNoteType                     =  16713,
	kGFF4SavegameWaypointMapNoteLocText                  =  16714,

	kGFF4SavegameCurrentCommand                          =  16720,
	kGFF4SavegameCommandList                             =  16721,
	kGFF4SavegameCommandCommandid                        =  16722,
	kGFF4SavegameCommandID                               =  16723,
	kGFF4SavegameCommandStatic                           =  16724,
	kGFF4SavegameCommandData                             =  16725,
	kGFF4SavegameCommandPlayerIssued                     =  16726,

	kGFF4SavegameSubactionList                           =  16730,
	kGFF4SavegameSubactionID                             =  16731,
	kGFF4SavegameSubactionCoreSubaction                  =  16732,
	kGFF4SavegameSubactionCoreInterruptable              =  16733,
	kGFF4SavegameSubactionTimeIndex                      =  16734,
	kGFF4SavegameSubactionLastTimeIndex                  =  16735,
	kGFF4SavegameSubactionLength                         =  16736,
	kGFF4SaveNameSubactionStartTime                      =  16737,
	kGFF4SavegameSubactionData                           =  16738,

	kGFF4SavegameCurrentActionQueue                      =  16740,

	kGFF4SavegameAOEAbilityID                            =  16750,
	kGFF4SavegameAOEFlags                                =  16751,
	kGFF4SavegameAOEStationary                           =  16752,

	kGFF4SavegameBuildNumber                             =  16770,
	kGFF4SavegameSaveVersionInternal                     =  16771,

	kGFF4SavegameWorldmap                                =  16780,
	kGFF4SavegameWorldmapPrimaryMap                      =  16781,
	kGFF4SavegameWorldmapSecondaryMap                    =  16782,
	kGFF4SavegameWorldmapMapList                         =  16783,
	kGFF4SavegameWorldmapMapTag                          =  16784,
	kGFF4SavegameWorldmapMapPlayerLoc                    =  16785,
	kGFF4SavegameWorldmapMapPinList                      =  16786,
	kGFF4SavegameWorldmapMapPinTag                       =  16787,
	kGFF4SavegameWorldmapMapPinState                     =  16788,
	kGFF4SavegameWorldmapMapPinRecentlyActivated         =  16789,
	kGFF4SavegameWorldmapGUIStatus                       =  16790,
	kGFF4SavegameWorldmapLastPinClicked                  =  16791,
	kGFF4SavegameWorldmapMapPinActivatedPreviously       =  16792,
	kGFF4SavegameWorldmapMapPinLastState                 =  16793,
	kGFF4SavegameWorldmapTravelPointPosX                 =  16794,
	kGFF4SavegameWorldmapTravelPointPosY                 =  16795,
	kGFF4SavegameWorldmapMapTravelPathBefore             =  16796,
	kGFF4SavegameWorldmapMapTravelPathAfter              =  16797,
	kGFF4SavegameWorldmapMapPinName                      =  16798,

	kGFF4SavegameMetaAreaName                            =  16800,
	kGFF4SavegameMetaTimePlayed                          =  16801,
	kGFF4SavegameMetaLevel                               =  16802,
	kGFF4SavegameMetaClass                               =  16803,
	kGFF4SavegameMetaGender                              =  16804,
	kGFF4SavegameMetaRace                                =  16805,
	kGFF4SavegameMetaBackground                          =  16806,
	kGFF4SavegameMetaName                                =  16807,
	kGFF4SavegameMetaSaveName                            =  16808,

	kGFF4SavegameTacticEntryTargetObjectID               =  16818,
	kGFF4SavegameTacticEntryConditionObjectID            =  16819,
	kGFF4SavegamePartyTacticsItemAbilities               =  16820,
	kGFF4SavegameTacticsHasTable                         =  16821,
	kGFF4SavegameTacticsTable                            =  16822,
	kGFF4SavegameTacticsEnabled                          =  16823,
	kGFF4SavegameTacticsList                             =  16824,
	kGFF4SavegameTacticEntryEnabled                      =  16825,
	kGFF4SavegameTacticEntryTarget                       =  16826,
	kGFF4SavegameTacticEntryCondition                    =  16827,
	kGFF4SavegameTacticEntryCommand                      =  16828,
	kGFF4SavegameTacticEntryCommandParam                 =  16829,
	kGFF4SavegameTacticEntryTargetTag                    =  16830,
	kGFF4SavegameTacticEntryConditionTag                 =  16831,
	kGFF4SavegameTacticsDirty                            =  16832,
	kGFF4SavegameTacticsPresetType                       =  16833,
	kGFF4SavegameTacticsPresetIndex                      =  16834,
	kGFF4SavegameTacticsPresetList                       =  16835,
	kGFF4SavegameTacticsCustomList                       =  16836,
	kGFF4SavegameTacticEntryCommandItemTag               =  16837,
	kGFF4SavegameTacticEntryCommandItemResRef            =  16838,

	kGFF4SavegamePlotActions                             =  16840,
	kGFF4SavegamePlotActionsEnabled                      =  16841,
	kGFF4SavegamePlotActionsCurrentSet                   =  16842,
	kGFF4SavegamePlotActionsList                         =  16843,
	kGFF4SavegamePlotActionID                            =  16844,
	kGFF4SavegamePlotActionState                         =  16845,
	kGFF4SavegamePlotActionCount                         =  16846,
	kGFF4SavegamePlotActionUpdated                       =  16847,

	kGFF4SavegameSoundTag                                =  16900,
	kGFF4SavegameSoundActive                             =  16901,
	kGFF4SavegameSoundName                               =  16902,
	kGFF4SavegameSoundXPosition                          =  16903,
	kGFF4SavegameSoundYPosition                          =  16904,
	kGFF4SavegameSoundZPosition                          =  16905,
	kGFF4SavegameSoundXOrientation                       =  16906,
	kGFF4SavegameSoundYOrientation                       =  16907,
	kGFF4SavegameSoundZOrientation                       =  16908,
	kGFF4SavegameSoundWOrientation                       =  16909,
	kGFF4SavegameSoundVolume                             =  16910,
	kGFF4SavegameSoundPitch                              =  16911,
	kGFF4SavegameSoundFadeIn                             =  16912,
	kGFF4SavegameSoundFadeOut                            =  16913,
	kGFF4SavegameSoundMaxDistanceMult                    =  16914,
	kGFF4SavegameSoundConeInside                         =  16915,
	kGFF4SavegameSoundConeOutside                        =  16916,
	kGFF4SavegameSoundConeVolume                         =  16917,
	kGFF4SavegameSoundPriority                           =  16918,
	kGFF4SavegameSoundOccludable                         =  16919,

	kGFF4SavegamePlayerMorph                             =  16950,
	kGFF4SavegamePlayerSoundSet                          =  16951,
	kGFF4SavegameDefaultSoundSet                         =  16952,

	kGFF4SavegameAddinName                               =  16960,

	kGFF4SavegameStorySoFarEventList                     =  16970,
	kGFF4SavegameStorySoFarEventID                       =  16971,
	kGFF4SavegameStorySoFarGameTime                      =  16972,
	kGFF4SavegameStorySoFarUTC                           =  16973,
	kGFF4SavegameStorySoFarScreenshot                    =  16974,
	kGFF4SavegameStorySoFarLevelUpList                   =  16975,

	kGFF4SavegameStorySoFarArea                          =  16976,
	kGFF4SavegameStorySoFarLevel                         =  16977,
	kGFF4SavegameStorySoFarMoney                         =  16978,
	kGFF4SavegameStorySoFarCurrentHealth                 =  16979,
	kGFF4SavegameStorySoFarTotalHealth                   =  16980,
	kGFF4SavegameStorySoFarCurrentStamina                =  16981,
	kGFF4SavegameStorySoFarTotalStamina                  =  16982,
	kGFF4SavegameStorySoFarCurrentXP                     =  16983,
	kGFF4SavegameStorySoFarSpellList                     =  16984,
	kGFF4SavegameStorySoFarTalentList                    =  16985,
	kGFF4SavegameStorySoFarSkillList                     =  16986,
	kGFF4SavegameStorySoFarAttributeList                 =  16987,
	kGFF4SavegameStorySoFarAttributeBase                 =  16988,
	kGFF4SavegameStorySoFarAttributeModifier             =  16989,
	kGFF4SavegameStorySoFarEquipmentList                 =  16990,
	kGFF4SavegameStorySoFarEquipmentSlotID               =  16991,
	kGFF4SavegameStorySoFarEquipmentResRef               =  16992,
	kGFF4SavegameStorySoFarEquipmentStackSize            =  16993,
	kGFF4SavegameStorySoFarItemProperty                  =  16994,
	kGFF4SavegameStorySoFarItemPower                     =  16995,
	kGFF4SavegameStorySoFarItemData                      =  16996,

	kGFF4ScriptVarTable                                  =  17000,
	kGFF4ScriptVarTableName                              =  17001,
	kGFF4ScriptVarTableType                              =  17002,
	kGFF4ScriptVarTableValue                             =  17003,

	kGFF4CampaignCIFEntryAreaList                        =  17100,
	kGFF4CampaignCIFEntryArea                            =  17101,
	kGFF4CampaignCIFEntryPosition                        =  17102,
	kGFF4CampaignCIFEntryOrientation                     =  17103,
	kGFF4CampaignCIFEntryScript                          =  17104,
	kGFF4CampaignCIFEntryClientScript                    =  17105,
	kGFF4CampaignCIFDisplayNameENUS                      =  17106,
	kGFF4CampaignCIFDisplayNameFRFR                      =  17107,
	kGFF4CampaignCIFDisplayNameDEDE                      =  17108,
	kGFF4CampaignCIFDisplayNamePLPL                      =  17109,
	kGFF4CampaignCIFDisplayNameRURU                      =  17110,
	kGFF4CampaignCIFDisplayNameITIT                      =  17111,
	kGFF4CampaignCIFDisplayNameESES                      =  17112,
	kGFF4CampaignCIFDisplayNameHUHU                      =  17113,
	kGFF4CampaignCIFDisplayNameCSCZ                      =  17114,
	kGFF4CampaignCIFDescriptionENUS                      =  17115,
	kGFF4CampaignCIFDescriptionFRFR                      =  17116,
	kGFF4CampaignCIFDescriptionDEDE                      =  17117,
	kGFF4CampaignCIFDescriptionPLPL                      =  17118,
	kGFF4CampaignCIFDescriptionRURU                      =  17119,
	kGFF4CampaignCIFDescriptionITIT                      =  17120,
	kGFF4CampaignCIFDescriptionESES                      =  17121,
	kGFF4CampaignCIFDescriptionHUHU                      =  17122,
	kGFF4CampaignCIFDescriptionCSCZ                      =  17123,
	kGFF4CampaignCIFPackagesList                         =  17124,

	kGFF4TalkBucketList                                  =  19000,
	kGFF4TalkStringList                                  =  19001,
	kGFF4TalkStringID                                    =  19002,
	kGFF4TalkString                                      =  19003,

	kGFF4HuffTalkStringID                                =  19004,
	kGFF4HuffTalkStringBitOffset                         =  19005,
	kGFF4HuffTalkStringList                              =  19006,
	kGFF4HuffTalkStringHuffTree                          =  19007,
	kGFF4HuffTalkStringBitStream                         =  19008,

	kGFF4PlaceableStatesList                             =  20000,

	kGFF4VFXChildList                                    =  21000,
	kGFF4VFXObjectID                                     =  21001,
	kGFF4VFXEmitterInitialRotationRange                  =  21002,
	kGFF4VFXOrientation                                  =  21003,
	kGFF4VFXRoot                                         =  21004,
	kGFF4VFXEmitterMeshParticleRollAxis                  =  21005,
	kGFF4VFXType                                         =  21006,
	kGFF4VFXObjectVisible                                =  21007,
	kGFF4VFXEmitterMeshParticleUpAxis                    =  21008,
	kGFF4VFXKeyframe                                     =  21009,
	kGFF4VFXValue                                        =  21010,
	kGFF4VFXEmitterName                                  =  21011,
	kGFF4VFXEmitterType                                  =  21012,
	kGFF4VFXEmitterOrientationBehaviour                  =  21013,
	kGFF4VFXEmitterUpdateOnlyWhenVisible                 =  21014,
	kGFF4VFXEmitterLinkParticlesTogether                 =  21015,
	kGFF4VFXEmitterMaterialLibrary                       =  21016,
	kGFF4VFXEmitterMaterialObject                        =  21017,
	kGFF4VFXEmitterBirthrate                             =  21018,
	kGFF4VFXEmitterBirthrateRange                        =  21019,
	kGFF4VFXEmitterBirthrateInParticlesPerMeter          =  21020,
	kGFF4VFXEmitterInitialSpeed                          =  21021,
	kGFF4VFXEmitterInitialSpeedRange                     =  21022,
	kGFF4VFXEmitterAcceleration                          =  21023,
	kGFF4VFXEmitterGravityMultiplier                     =  21024,
	kGFF4VFXEmitterLife                                  =  21025,
	kGFF4VFXEmitterLifeRange                             =  21026,
	kGFF4VFXEmitterScaleRange                            =  21027,
	kGFF4VFXEmitterSpreadX                               =  21028,
	kGFF4VFXEmitterSpreadY                               =  21029,
	kGFF4VFXEmitterInitialRotationSpeed                  =  21030,
	kGFF4VFXEmitterInitialRotationSpeedRange             =  21031,
	kGFF4VFXEmitterRotationalAcceleration                =  21032,
	kGFF4VFXEmitterRandomInitialRotation                 =  21033,
	kGFF4VFXEmitterParticleInheritance                   =  21034,
	kGFF4VFXEmitterInheritVelocityInsteadOfPosition      =  21035,
	kGFF4VFXEmitterParticlesAffectedByWind               =  21036,
	kGFF4VFXEmitterEnableParticleCollisions              =  21037,
	kGFF4VFXEmitterPhysicsObjectSpawn                    =  21038,
	kGFF4VFXEmitterPhysicsEmitter                        =  21039,
	kGFF4VFXEmitterMovementSpreadX                       =  21040,
	kGFF4VFXEmitterMovementSpreadY                       =  21041,
	kGFF4VFXEmitterMovementSpreadUpdateDelay             =  21042,
	kGFF4VFXEmitterTargetName                            =  21043,
	kGFF4VFXEmitterTargetAttraction                      =  21044,
	kGFF4VFXEmitterTargetRadius                          =  21045,
	kGFF4VFXEmitterSpawnDirectionTracksTarget            =  21046,
	kGFF4VFXEmitterKillParticleWhenTargetHit             =  21047,
	kGFF4VFXEmitterParticlesFollowPath                   =  21048,
	kGFF4VFXEmitterFlipbookType                          =  21049,
	kGFF4VFXEmitterFlipbookFramesPerSecond               =  21050,
	kGFF4VFXEmitterFlipbookRows                          =  21051,
	kGFF4VFXEmitterFlipbookColumns                       =  21052,
	kGFF4VFXEmitterFlipbookRandomStartFrame              =  21053,
	kGFF4VFXEmitterAlphaMultiplier                       =  21054,
	kGFF4VFXEmitterColorMultiplier                       =  21055,
	kGFF4VFXEmitterScaleMultiplier                       =  21056,
	kGFF4VFXEmitterInfiniteLife                          =  21057,
	kGFF4VFXEmitterChunkyModelName                       =  21058,
	kGFF4VFXEmitterInitialRotation                       =  21059,

	kGFF4VFXCrustNodeName                                =  21060,
	kGFF4VFXCrustNodeRealName                            =  21061,
	kGFF4VFXCrustNodeCrustHookID                         =  21062,
	kGFF4VFXGeometryFileName                             =  21063,

	kGFF4VFXEmitterAgent                                 =  21064,
	kGFF4VFXUseVariationTint                             =  21065,

	kGFF4VFXDummyName                                    =  21070,

	kGFF4VFXGeometryName                                 =  21080,
	kGFF4VFXGeometryScale                                =  21081,

	kGFF4VFXTargetName                                   =  21090,
	kGFF4VFXModelName                                    =  21100,
	kGFF4VFXModelResourcetype                            =  21101,
	kGFF4VFXModelAnimationName                           =  21102,
	kGFF4VFXCreatureName                                 =  21110,
	kGFF4VFXCreatureURI                                  =  21111,

	kGFF4VFXRelativePositionX                            =  21120,
	kGFF4VFXRelativePositionY                            =  21121,
	kGFF4VFXRelativePositionZ                            =  21122,
	kGFF4VFXRelativeOrientationX                         =  21123,
	kGFF4VFXRelativeOrientationY                         =  21124,
	kGFF4VFXRelativeOrientationZ                         =  21125,

	kGFF4VFXImpactLength                                 =  21130,
	kGFF4VFXDurationLength                               =  21131,
	kGFF4VFXCessationLength                              =  21132,
	kGFF4VFXCustomLength                                 =  21133,
	kGFF4VFXCustomName                                   =  21134,

	kGFF4VFXAgemapColorR                                 =  21140,
	kGFF4VFXAgemapColorG                                 =  21141,
	kGFF4VFXAgemapColorB                                 =  21142,
	kGFF4VFXAgemapColorA                                 =  21143,
	kGFF4VFXAgemapScaleX                                 =  21144,
	kGFF4VFXAgemapScaleY                                 =  21145,
	kGFF4VFXAgemapRotationalSpeedMultiplier              =  21146,

	kGFF4VFXEvent                                        =  21150,
	kGFF4VFXEventTime                                    =  21151,
	kGFF4VFXEventType                                    =  21152,
	kGFF4VFXEventID                                      =  21153,
	kGFF4VFXEventTargetSystem                            =  21154,

	kGFF4VFXEmitterVolumeSpawnType                       =  21160,
	kGFF4VFXEmitterVolumeSpawnSelectedPartName           =  21161,
	kGFF4VFXEmitterVolumeSpawnArbitraryVolumeName        =  21162,
	kGFF4VFXEmitterCollisionType                         =  21163,
	kGFF4VFXEmitterBounceValue                           =  21164,
	kGFF4VFXEmitterVolumeSpawnWithinVolume               =  21165,
	kGFF4VFXEmitterVolumeSpawnInvertNormals              =  21166,

	kGFF4VFXEmitterColorMultiplierR                      =  21170,
	kGFF4VFXEmitterColorMultiplierG                      =  21171,
	kGFF4VFXEmitterColorMultiplierB                      =  21172,

	kGFF4VFXSplatAgemapColorR                            =  21173,
	kGFF4VFXSplatAgemapColorG                            =  21174,
	kGFF4VFXSplatAgemapColorB                            =  21175,
	kGFF4VFXSplatAgemapColorA                            =  21176,
	kGFF4VFXSplatAgemapScaleX                            =  21177,
	kGFF4VFXSplatAgemapScaleY                            =  21178,

	kGFF4VFXFileObjectVersion                            =  21180,

	kGFF4VFXEmitterSplatAlphaMultiplier                  =  21181,
	kGFF4VFXEmitterSplatColorMultiplierR                 =  21182,
	kGFF4VFXEmitterSplatColorMultiplierG                 =  21183,
	kGFF4VFXEmitterSplatColorMultiplierB                 =  21184,

	kGFF4VFXEmitterVolumeSpawnPrimitiveMeshType          =  21185,
	kGFF4VFXEmitterVolumeSpawnPrimitiveBoxMin            =  21186,
	kGFF4VFXEmitterVolumeSpawnPrimitiveBoxMax            =  21187,
	kGFF4VFXEmitterVolumeSpawnPrimitiveSphereR           =  21188,
	kGFF4VFXEmitterVolumeSpawnPrimitiveCylinderR         =  21189,
	kGFF4VFXEmitterVolumeSpawnPrimitiveCylinderH         =  21190,
	kGFF4VFXEmitterVolumeSpawnPrimitiveCylinderAxis      =  21191,
	kGFF4VFXEmitterVolumeSpawnUseVolumeNormal            =  21192,

	kGFF4VFXEmitterWorldAxisAccelerationX                =  21193,
	kGFF4VFXEmitterWorldAxisAccelerationY                =  21194,
	kGFF4VFXEmitterWorldAxisAccelerationZ                =  21195,

	kGFF4VFXRange                                        =  21196,

	kGFF4VFXEmitterAxisAccelerationSpace                 =  21197,
	kGFF4VFXEmitterUVDistributionsize                    =  21198,

	kGFF4VFXEmitterGroupName                             =  21210,

	kGFF4VFXRemoteMaterialTintR                          =  21220,
	kGFF4VFXRemoteMaterialTintG                          =  21221,
	kGFF4VFXRemoteMaterialTintB                          =  21222,
	kGFF4VFXRemoteMaterialTintA                          =  21223,
	kGFF4VFXRemoteMaterialFresnelFalloff                 =  21224,
	kGFF4VFXRemoteMaterialInvertFresnel                  =  21225,
	kGFF4VFXRemoteMaterialAlpha                          =  21226,
	kGFF4VFXRemoteMaterialDecalName                      =  21227,

	kGFF4WndRoot                                         =  22000,
	kGFF4WndResRef                                       =  22001,
	kGFF4WndRadius                                       =  22002,

	kGFF4WndStrength                                     =  22003,
	kGFF4WndDirection                                    =  22004,
	kGFF4WndRadiusFalloff                                =  22005,

	kGFF4WndGustMinStrength                              =  22010,
	kGFF4WndGustMaxStrength                              =  22011,
	kGFF4WndGustMinDuration                              =  22012,
	kGFF4WndGustMaxDuration                              =  22013,

	kGFF4WndGustFrequency                                =  22014,

	kGFF4WndTreeNumWindMatrices                          =  22020,
	kGFF4WndTreeNumLeafAngles                            =  22021,
	kGFF4WndTreeResponse                                 =  22022,
	kGFF4WndTreeResponseLimit                            =  22023,
	kGFF4WndTreeMaxBendAngle                             =  22024,
	kGFF4WndTreeBranchExponent                           =  22025,
	kGFF4WndTreeLeafExponent                             =  22026,

	kGFF4WndTreeBranchOscillationX                       =  22027,
	kGFF4WndTreeBranchOscillationY                       =  22028,
	kGFF4WndTreeLeafRocking                              =  22029,
	kGFF4WndTreeLeafRustling                             =  22030,

	kGFF4WndClothResponse                                =  22031,
	kGFF4WndClothResponseLmt                             =  22032,
	kGFF4WndClothStrength                                =  22033,
	kGFF4WndClothGustStrengthMin                         =  22034,
	kGFF4WndClothGustStrengthMax                         =  22035,
	kGFF4WndClothGustDurationMin                         =  22036,
	kGFF4WndClothGustDurationMax                         =  22037,
	kGFF4WndClothGustIntervalMin                         =  22038,
	kGFF4WndClothGustIntervalMax                         =  22039,
	kGFF4WndClothGustDirChange                           =  22040,
	kGFF4WndClothGustAxisRatio                           =  22041,

	kGFF4AtmoData                                        =  22500,
	kGFF4AtmoSunColor                                    =  22519,
	kGFF4AtmoSunIntensity                                =  22520,
	kGFF4AtmoTurbidity                                   =  22521,
	kGFF4AtmoEarthReflectance                            =  22522,
	kGFF4AtmoMieMultiplier                               =  22523,
	kGFF4AtmoRayleighMultiplier                          =  22524,
	kGFF4AtmoEarthInScatterPower                         =  22525,
	kGFF4AtmoDistanceMultiplier                          =  22526,
	kGFF4AtmoPhaseEccentricity                           =  22527,
	kGFF4AtmoAlpha                                       =  22528,
	kGFF4AtmoFogColor                                    =  22529,
	kGFF4AtmoFogIntensity                                =  22530,
	kGFF4AtmoFogCap                                      =  22531,
	kGFF4AtmoFogZenith                                   =  22532,
	kGFF4AtmoFogWaterIntensity                           =  22533,
	kGFF4AtmoFogWaterCap                                 =  22534,
	kGFF4AtmoFogTacticalMultiplier                       =  22535,

	kGFF4CloudData                                       =  22600,
	kGFF4CloudDensity                                    =  22620,
	kGFF4CloudSharpness                                  =  22621,
	kGFF4CloudDepth                                      =  22622,
	kGFF4CloudRangeMultiplier1                           =  22623,
	kGFF4CloudRangeMultiplier2                           =  22624,
	kGFF4CloudColor                                      =  22625,

	kGFF4MoonScale                                       =  22700,
	kGFF4MoonAlpha                                       =  22701,
	kGFF4MoonCloudAlpha                                  =  22702,
	kGFF4MoonRotation                                    =  22703,

	kGFF4MorphParts                                      =  23000,
	kGFF4MorphTintFileNames                              =  23001,
	kGFF4MorphNodes                                      =  23002,
	kGFF4MorphTextureName                                =  23003,
	kGFF4MorphTextureParam                               =  23004,
	kGFF4MorphVector4fParam                              =  23005,
	kGFF4MorphFloatParam                                 =  23006,
	kGFF4MorphFloatParamValue                            =  23007,
	kGFF4MorphName                                       =  23008,
	kGFF4MorphMatNodeName                                =  23009,
	kGFF4MorphMatParamName                               =  23010,
	kGFF4MorphMatParamIndex                              =  23011,
	kGFF4MorphMatParamValue                              =  23012,
	kGFF4MorphMatParamVector                             =  23013,
	kGFF4MorphMatParams                                  =  23014,
	kGFF4MorphMatVecParams                               =  23015,
	kGFF4MorphModelName                                  =  23016,
	kGFF4MorphModelValue                                 =  23017,
	kGFF4MorphModelParams                                =  23018,
	kGFF4MorphTexNodeName                                =  23019,
	kGFF4MorphTexParamName                               =  23020,
	kGFF4MorphTexName                                    =  23021,
	kGFF4MorphTextures                                   =  23022,

	kGFF4MapTag                                          =  24000,
	kGFF4MapType                                         =  24001,
	kGFF4MapPinList                                      =  24002,
	kGFF4MapPinState                                     =  24003,
	kGFF4MapPinPosX                                      =  24004,
	kGFF4MapPinPosY                                      =  24005,
	kGFF4MapPinName                                      =  24006,
	kGFF4MapPinTag                                       =  24007,
	kGFF4MapPinAreatag                                   =  24008,
	kGFF4MapPinTerraintype                               =  24009,
	kGFF4MapPinType                                      =  24010,
	kGFF4MapMaps                                         =  24011,
	kGFF4MapMapParentResRef                              =  24012,
	kGFF4MapPinWaypointOverride                          =  24013,
	kGFF4MapTrailList                                    =  24014,
	kGFF4MapTrailPin1Tag                                 =  24015,
	kGFF4MapTrailPin2Tag                                 =  24016,
	kGFF4MapPointList                                    =  24017,
	kGFF4MapPointPosX                                    =  24018,
	kGFF4MapPointPosY                                    =  24019,
	kGFF4MapPinTooltip                                   =  24020,

	kGFF4DepFileList                                     =  25000,
	kGFF4DepResRef                                       =  25001,
	kGFF4DepDependencyList                               =  25002,

	kGFF4SaveprofileBuildNumber                          =  26000,
	kGFF4SaveprofileInitialBuildNumber                   =  26001,
	kGFF4SaveprofileLastUsedProfile                      =  26002,
	kGFF4SaveprofileProfileList                          =  26003,
	kGFF4SaveprofileAccountName                          =  26004,
	kGFF4SaveprofileLocalAchievementData                 =  26005,
	kGFF4SaveprofileAchievementList                      =  26006,
	kGFF4SaveprofileAchievementID                        =  26007,
	kGFF4SaveprofileAchievementNew                       =  26008,
	kGFF4SaveprofileAchievementOnline                    =  26009,
	kGFF4SaveprofileAchievementCount                     =  26010,
	kGFF4SaveprofileAchievementDate                      =  26011,

	kGFF4SaveprofileAddinList                            =  26100,
	kGFF4SaveprofileOfferList                            =  26101,
	kGFF4SaveprofileContentName                          =  26102,
	kGFF4SaveprofileContentShown                         =  26103,
	kGFF4SaveprofileContentEnabled                       =  26104,
	kGFF4SaveprofileContentToken                         =  26105,
	kGFF4SaveprofileContentUser                          =  26106,
	kGFF4SaveprofileFileList                             =  26107,
	kGFF4SaveprofileFileName                             =  26108,
	kGFF4SaveprofileFileData                             =  26109,
	kGFF4SaveprofileFileVersion                          =  26110,
	kGFF4SaveprofileAddinTokenList                       =  26111,

	kGFF4MAOFloatName                                    =  33002,
	kGFF4MAOFloatValue                                   =  33003,
	kGFF4MAOVectorName                                   =  33004,
	kGFF4MAOVectorValue                                  =  33005,
	kGFF4MAOTextureName                                  =  33010,
	kGFF4MAOTextureResource                              =  33011,
	kGFF4MAOMaterial                                     =  33012,
	kGFF4MAODefaultSemantic                              =  33013,
	kGFF4MAOFloats                                       =  33016,
	kGFF4MAOVectors                                      =  33017,
	kGFF4MAOTextures                                     =  33020,

	kGFF4CharMOP                                         = 250100,
	kGFF4CharApp                                         = 250101,
	kGFF4CharGender                                      = 250102,
	kGFF4CharRace                                        = 250103,
	kGFF4CharClass                                       = 250104,
	kGFF4CharBack                                        = 250105,
	kGFF4CharAttributes                                  = 250106,
	kGFF4CharAbilities                                   = 250107,
	kGFF4CharName                                        = 250108,
	kGFF4CharHeadName                                    = 250109,
	kGFF4CharAttributeID                                 = 250110,
	kGFF4CharAttributePoints                             = 250111,
	kGFF4CharPortrait                                    = 250112
};

} // End of namespace GFF4FieldNamesEnum

using namespace GFF4FieldNamesEnum;

} // End of namespace Aurora

#endif // AURORA_GFF4FIELDS_H
