!{\src2tex{textfont=tt}}
!!****f* ABINIT/matcginv
!! NAME
!! matcginv
!!
!! FUNCTION
!! Invert a general matrix of complex elements.
!!
!! COPYRIGHT
!! Copyright (C) 2001-2007 ABINIT group (GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! lda=leading dimension of complex matrix a
!! n=size of complex matrix a
!! a=matrix of complex elements
!! OUTPUT
!! a=inverse of a input matrix
!! SIDE EFFECTS
!! a(lda,n)= array of complex elements, input, inverted at output
!!
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      cbgmdi,cbgmlu,cgeicd,cgetrf,cgetri,leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine matcginv(a,lda,n)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: lda,n
!arrays
 complex,intent(inout) :: a(lda,n)

!Local variables-------------------------------
!scalars
 integer :: ierr,istat,nwork
 character(len=500) :: message
!arrays
 integer :: ipvt(n)
 complex,allocatable :: work(:)
!no_abirules
#if defined HAVE_IBM_ESSL_OLD
 complex :: rcond
 complex :: det(2)
#else
 real(dp) :: det
 complex :: cdet
#endif

! *************************************************************************
#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'CGETRI' :: cgetri
!DEC$ ATTRIBUTES ALIAS:'CGETRF' :: cgetrf
#endif

#if defined HAVE_IBM_ESSL_OLD
 nwork=200*n
#else
 nwork=n
#endif

 allocate(work(nwork))

#if defined HAVE_IBM_ESSL_OLD

 call cgeicd(a,lda,n,0,rcond,det,work,nwork)
 if(abs(rcond)==zero) then
  write(message, '(10a)' ) ch10,&
& ' matcginv : BUG -',ch10,&
& '  The matrix that has been passed in argument of this subroutine',ch10,&
& '  is probably either singular or nearly singular.',ch10,&
& '  The ESSL routine cgeicd failed.',ch10,&
& '  Action : Contact ABINIT group '
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

#elif defined HAVE_NEC_ASL

 call cbgmlu(a,lda,n,ipvt,ierr)
 if(ierr /= 0) then
  write(message, '(10a)' ) ch10,&
& ' matcginv : BUG -',ch10,&
& '  The matrix that has been passed in argument of this subroutine',ch10,&
& '  is probably either singular or nearly singular.',ch10,&
& '  The ASL routine cbgmlu failed.',ch10,&
& '  Action : Contact ABINIT group '
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if
 call cbgmdi(a,lda,n,ipvt,cdet,det,-1,work,ierr)
 if(ierr /= 0) then
  write(message, '(10a)' ) ch10,&
& ' matcginv : BUG -',ch10,&
& '  The matrix that has been passed in argument of this subroutine',ch10,&
& '  is probably either singular or nearly singular.',ch10,&
& '  The ASL routine dbgmdi failed.',ch10,&
& '  Action : Contact ABINIT group '
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

#else

 call cgetrf(n,n,a,lda,ipvt,ierr)
 if(ierr /= 0) then
  write(message, '(10a)' ) ch10,&
& ' matcginv : BUG -',ch10,&
& '  The matrix that has been passed in argument of this subroutine',ch10,&
& '  is probably either singular or nearly singular.',ch10,&
& '  The LAPACK routine cgetrf failed.',ch10,&
& '  Action : Contact ABINIT group '
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if
 call cgetri(n,a,n,ipvt,work,n,ierr)
 if(ierr /= 0) then
  write(message, '(10a)' ) ch10,&
& ' matcginv : BUG -',ch10,&
& '  The matrix that has been passed in argument of this subroutine',ch10,&
& '  is probably either singular or nearly singular.',ch10,&
& '  The LAPACK routine cgetri failed.',ch10,&
& '  Action : Contact ABINIT group '
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

#endif
!DEBUG
!call printcm(a,n,n)
!ENDDEBUG
 deallocate(work)

end subroutine matcginv
!!***
