!!****h* BigDFT/lazy_50
!! NAME
!!   lazy_50
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 50)
!!
!! SOURCE
!!
integer, parameter :: m=52
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     2.03510990661269603e-16_dp,0._dp,-1.03963806080363471e-14_dp,0._dp,&
      2.60602607241444435e-13_dp,0._dp,-4.27267065360972853e-12_dp,0._dp,&
      5.15325765417075794e-11_dp,0._dp,-4.87577454971540944e-10_dp,0._dp,&
      3.76884194923947865e-9_dp,0._dp,-2.44743981275102471e-8_dp,0._dp,&
      1.36277898664545694e-7_dp,0._dp,-6.60874540835592558e-7_dp,0._dp,&
      2.82580838150391301e-6_dp,0._dp,-0.0000107609066649189415_dp,0._dp,&
      0.0000368023007940227798_dp,0._dp,-0.000113853271687194218_dp,0._dp,&
      0.000320647989649649023_dp,0._dp,-0.00082693428909646327_dp,0._dp,&
      0.00196396893660410027_dp,0._dp,-0.00432073166052902059_dp,0._dp,&
      0.008863039303649273_dp,0._dp,-0.0170899753079935742_dp,0._dp,&
      0.0313316213979882195_dp,0._dp,-0.0556296135025505121_dp,0._dp,&
      0.0991218567863627306_dp,0._dp,-0.193934067625492299_dp,0._dp,0.630285719782849972_dp,&
      1._dp,0.630285719782849972_dp,0._dp,-0.193934067625492299_dp,0._dp,&
      0.0991218567863627306_dp,0._dp,-0.0556296135025505121_dp,0._dp,&
      0.0313316213979882195_dp,0._dp,-0.0170899753079935742_dp,0._dp,&
      0.008863039303649273_dp,0._dp,-0.00432073166052902059_dp,0._dp,&
      0.00196396893660410027_dp,0._dp,-0.00082693428909646327_dp,0._dp,&
      0.000320647989649649023_dp,0._dp,-0.000113853271687194218_dp,0._dp,&
      0.0000368023007940227798_dp,0._dp,-0.0000107609066649189415_dp,0._dp,&
      2.82580838150391301e-6_dp,0._dp,-6.60874540835592558e-7_dp,0._dp,&
      1.36277898664545694e-7_dp,0._dp,-2.44743981275102471e-8_dp,0._dp,&
      3.76884194923947865e-9_dp,0._dp,-4.87577454971540944e-10_dp,0._dp,&
      5.15325765417075794e-11_dp,0._dp,-4.27267065360972853e-12_dp,0._dp,&
      2.60602607241444435e-13_dp,0._dp,-1.03963806080363471e-14_dp,0._dp,&
      2.03510990661269603e-16_dp,&
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

