/* playback.h - high-level audio playback interface
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_PLAYBACK_H
#define ABX_PLAYBACK_H

#include "player.h"
#include "soundfile.h"

extern int init_playback(const char *a, const char *b, 
                         PaDeviceIndex outdev);
extern void close_playback(void);

extern void get_metadatas(Metadata *a, Metadata *b);
extern int get_playback_state(Player_state *state);

extern void start_playback(int sample, double begin);
extern void stop_playback(void);
extern int pause_or_resume_playback(void);
extern void seek_playback(double location);

#endif
