# -*- coding: utf-8 -*-
###########################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com>
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
###########################################

import gtk
from APTonCD.core import gui
from APTonCD.core import constants

class ChooseFolderDialog(gtk.FileChooserDialog):
	"""
		A dialog selection for folders.
	"""
	def __init__(self, title, parent, initial_dir = None, action = gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER):
		"""
			Constructor
			parent
			title = '',
			initial_dir = None,
			action = gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER
		"""
		
		super(ChooseFolderDialog, self).__init__(title = title, parent = gui.get_top_parent(parent), action = action,buttons = (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		
		if initial_dir:
			self.set_current_folder(initial_dir)
		self.set_local_only(True)
		self.set_select_multiple(False)

	def run(self):
		resp = super(ChooseFolderDialog, self).run()
		fns = self.get_filenames()
		if resp == gtk.RESPONSE_OK:
			return fns
		else:
			return []

class ChooseFileDialog(ChooseFolderDialog):
	def __init__(self, title, parent, filter_name, pattern, select_multiples = True, initial_dir = None):
		super(ChooseFileDialog, self).__init__(title, parent, initial_dir, gtk.FILE_CHOOSER_ACTION_OPEN)
		
		self.set_select_multiple(select_multiples)
		filter = gtk.FileFilter()
		filter.set_name(filter_name)
		filter.add_pattern(pattern)
		self.add_filter(filter)
		
