/*
 * Copyright (c) 2016 - 2020, Broadcom
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef BRCM_RDB_SD4_EMMC_TOP_H
#define BRCM_RDB_SD4_EMMC_TOP_H

#define SD4_EMMC_TOP_SYSADDR_OFFSET              0x00000000
#define SD4_EMMC_TOP_SYSADDR_DEFAULT             0x00000000
#define SD4_EMMC_TOP_SYSADDR_TYPE                uint32_t
#define SD4_EMMC_TOP_SYSADDR_RESERVED_MASK       0x00000000
#define SD4_EMMC_TOP_SYSADDR_SYSADDR_SHIFT       0
#define SD4_EMMC_TOP_SYSADDR_SYSADDR_MASK        0xFFFFFFFF

#define SD4_EMMC_TOP_BLOCK_OFFSET                0x00000004
#define SD4_EMMC_TOP_BLOCK_DEFAULT               0x00000000
#define SD4_EMMC_TOP_BLOCK_TYPE                  uint32_t
#define SD4_EMMC_TOP_BLOCK_RESERVED_MASK         0x00008000
#define SD4_EMMC_TOP_BLOCK_BCNT_SHIFT            16
#define SD4_EMMC_TOP_BLOCK_BCNT_MASK             0xFFFF0000
#define SD4_EMMC_TOP_BLOCK_HSBS_SHIFT            12
#define SD4_EMMC_TOP_BLOCK_HSBS_MASK             0x00007000
#define SD4_EMMC_TOP_BLOCK_TBS_SHIFT             0
#define SD4_EMMC_TOP_BLOCK_TBS_MASK              0x00000FFF

#define SD4_EMMC_TOP_ARG_OFFSET                  0x00000008
#define SD4_EMMC_TOP_ARG_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_ARG_TYPE                    uint32_t
#define SD4_EMMC_TOP_ARG_RESERVED_MASK           0x00000000
#define SD4_EMMC_TOP_ARG_ARG_SHIFT               0
#define SD4_EMMC_TOP_ARG_ARG_MASK                0xFFFFFFFF

#define SD4_EMMC_TOP_CMD_OFFSET                  0x0000000C
#define SD4_EMMC_TOP_CMD_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_CMD_TYPE                    uint32_t
#define SD4_EMMC_TOP_CMD_RESERVED_MASK           0xC004FFC0
#define SD4_EMMC_TOP_CMD_CIDX_SHIFT              24
#define SD4_EMMC_TOP_CMD_CIDX_MASK               0x3F000000
#define SD4_EMMC_TOP_CMD_CTYP_SHIFT              22
#define SD4_EMMC_TOP_CMD_CTYP_MASK               0x00C00000
#define SD4_EMMC_TOP_CMD_DPS_SHIFT               21
#define SD4_EMMC_TOP_CMD_DPS_MASK                0x00200000
#define SD4_EMMC_TOP_CMD_CCHK_EN_SHIFT           20
#define SD4_EMMC_TOP_CMD_CCHK_EN_MASK            0x00100000
#define SD4_EMMC_TOP_CMD_CRC_EN_SHIFT            19
#define SD4_EMMC_TOP_CMD_CRC_EN_MASK             0x00080000
#define SD4_EMMC_TOP_CMD_RTSEL_SHIFT             16
#define SD4_EMMC_TOP_CMD_RTSEL_MASK              0x00030000
#define SD4_EMMC_TOP_CMD_MSBS_SHIFT              5
#define SD4_EMMC_TOP_CMD_MSBS_MASK               0x00000020
#define SD4_EMMC_TOP_CMD_DTDS_SHIFT              4
#define SD4_EMMC_TOP_CMD_DTDS_MASK               0x00000010
#define SD4_EMMC_TOP_CMD_ACMDEN_SHIFT            2
#define SD4_EMMC_TOP_CMD_ACMDEN_MASK             0x0000000C
#define SD4_EMMC_TOP_CMD_BCEN_SHIFT              1
#define SD4_EMMC_TOP_CMD_BCEN_MASK               0x00000002
#define SD4_EMMC_TOP_CMD_DMA_SHIFT               0
#define SD4_EMMC_TOP_CMD_DMA_MASK                0x00000001

#define SD4_EMMC_TOP_CMD_SD4_OFFSET              0x0000000C
#define SD4_EMMC_TOP_CMD_SD4_DEFAULT             0x00000000
#define SD4_EMMC_TOP_CMD_SD4_TYPE                uint32_t
#define SD4_EMMC_TOP_CMD_SD4_RESERVED_MASK       0xC004FE00
#define SD4_EMMC_TOP_CMD_SD4_CIDX_SHIFT          24
#define SD4_EMMC_TOP_CMD_SD4_CIDX_MASK           0x3F000000
#define SD4_EMMC_TOP_CMD_SD4_CTYP_SHIFT          22
#define SD4_EMMC_TOP_CMD_SD4_CTYP_MASK           0x00C00000
#define SD4_EMMC_TOP_CMD_SD4_DPS_SHIFT           21
#define SD4_EMMC_TOP_CMD_SD4_DPS_MASK            0x00200000
#define SD4_EMMC_TOP_CMD_SD4_CCHK_EN_SHIFT       20
#define SD4_EMMC_TOP_CMD_SD4_CCHK_EN_MASK        0x00100000
#define SD4_EMMC_TOP_CMD_SD4_CRC_EN_SHIFT        19
#define SD4_EMMC_TOP_CMD_SD4_CRC_EN_MASK         0x00080000
#define SD4_EMMC_TOP_CMD_SD4_RTSEL_SHIFT         16
#define SD4_EMMC_TOP_CMD_SD4_RTSEL_MASK          0x00030000
#define SD4_EMMC_TOP_CMD_SD4_RESPIRQDIS_SHIFT    8
#define SD4_EMMC_TOP_CMD_SD4_RESPIRQDIS_MASK     0x00000100
#define SD4_EMMC_TOP_CMD_SD4_RESPERRCHKEN_SHIFT  7
#define SD4_EMMC_TOP_CMD_SD4_RESPERRCHKEN_MASK   0x00000080
#define SD4_EMMC_TOP_CMD_SD4_RESPR1R5_SHIFT      6
#define SD4_EMMC_TOP_CMD_SD4_RESPR1R5_MASK       0x00000040
#define SD4_EMMC_TOP_CMD_SD4_MSBS_SHIFT          5
#define SD4_EMMC_TOP_CMD_SD4_MSBS_MASK           0x00000020
#define SD4_EMMC_TOP_CMD_SD4_DTDS_SHIFT          4
#define SD4_EMMC_TOP_CMD_SD4_DTDS_MASK           0x00000010
#define SD4_EMMC_TOP_CMD_SD4_ACMDEN_SHIFT        2
#define SD4_EMMC_TOP_CMD_SD4_ACMDEN_MASK         0x0000000C
#define SD4_EMMC_TOP_CMD_SD4_BCEN_SHIFT          1
#define SD4_EMMC_TOP_CMD_SD4_BCEN_MASK           0x00000002
#define SD4_EMMC_TOP_CMD_SD4_DMA_SHIFT           0
#define SD4_EMMC_TOP_CMD_SD4_DMA_MASK            0x00000001

#define SD4_EMMC_TOP_RESP0_OFFSET                0x00000010
#define SD4_EMMC_TOP_RESP0_DEFAULT               0x00000000
#define SD4_EMMC_TOP_RESP0_TYPE                  uint32_t
#define SD4_EMMC_TOP_RESP0_RESERVED_MASK         0x00000000
#define SD4_EMMC_TOP_RESP0_RESP0_SHIFT           0
#define SD4_EMMC_TOP_RESP0_RESP0_MASK            0xFFFFFFFF

#define SD4_EMMC_TOP_RESP2_OFFSET                0x00000014
#define SD4_EMMC_TOP_RESP2_DEFAULT               0x00000000
#define SD4_EMMC_TOP_RESP2_TYPE                  uint32_t
#define SD4_EMMC_TOP_RESP2_RESERVED_MASK         0x00000000
#define SD4_EMMC_TOP_RESP2_RESP2_SHIFT           0
#define SD4_EMMC_TOP_RESP2_RESP2_MASK            0xFFFFFFFF

#define SD4_EMMC_TOP_RESP4_OFFSET                0x00000018
#define SD4_EMMC_TOP_RESP4_DEFAULT               0x00000000
#define SD4_EMMC_TOP_RESP4_TYPE                  uint32_t
#define SD4_EMMC_TOP_RESP4_RESERVED_MASK         0x00000000
#define SD4_EMMC_TOP_RESP4_RESP4_SHIFT           0
#define SD4_EMMC_TOP_RESP4_RESP4_MASK            0xFFFFFFFF

#define SD4_EMMC_TOP_RESP6_OFFSET                0x0000001C
#define SD4_EMMC_TOP_RESP6_DEFAULT               0x00000000
#define SD4_EMMC_TOP_RESP6_TYPE                  uint32_t
#define SD4_EMMC_TOP_RESP6_RESERVED_MASK         0x00000000
#define SD4_EMMC_TOP_RESP6_RESP6_SHIFT           0
#define SD4_EMMC_TOP_RESP6_RESP6_MASK            0xFFFFFFFF

#define SD4_EMMC_TOP_BUFDAT_OFFSET               0x00000020
#define SD4_EMMC_TOP_BUFDAT_DEFAULT              0x00000000
#define SD4_EMMC_TOP_BUFDAT_TYPE                 uint32_t
#define SD4_EMMC_TOP_BUFDAT_RESERVED_MASK        0x00000000
#define SD4_EMMC_TOP_BUFDAT_BUFDAT_SHIFT         0
#define SD4_EMMC_TOP_BUFDAT_BUFDAT_MASK          0xFFFFFFFF

#define SD4_EMMC_TOP_PSTATE_OFFSET               0x00000024
#define SD4_EMMC_TOP_PSTATE_DEFAULT              0x1FFC0000
#define SD4_EMMC_TOP_PSTATE_TYPE                 uint32_t
#define SD4_EMMC_TOP_PSTATE_RESERVED_MASK        0xE000F0F0
#define SD4_EMMC_TOP_PSTATE_DLS7_4_SHIFT         25
#define SD4_EMMC_TOP_PSTATE_DLS7_4_MASK          0x1E000000
#define SD4_EMMC_TOP_PSTATE_CLSL_SHIFT           24
#define SD4_EMMC_TOP_PSTATE_CLSL_MASK            0x01000000
#define SD4_EMMC_TOP_PSTATE_DLS3_0_SHIFT         20
#define SD4_EMMC_TOP_PSTATE_DLS3_0_MASK          0x00F00000
#define SD4_EMMC_TOP_PSTATE_WPSL_SHIFT           19
#define SD4_EMMC_TOP_PSTATE_WPSL_MASK            0x00080000
#define SD4_EMMC_TOP_PSTATE_CDPL_SHIFT           18
#define SD4_EMMC_TOP_PSTATE_CDPL_MASK            0x00040000
#define SD4_EMMC_TOP_PSTATE_CSS_SHIFT            17
#define SD4_EMMC_TOP_PSTATE_CSS_MASK             0x00020000
#define SD4_EMMC_TOP_PSTATE_CINS_SHIFT           16
#define SD4_EMMC_TOP_PSTATE_CINS_MASK            0x00010000
#define SD4_EMMC_TOP_PSTATE_BREN_SHIFT           11
#define SD4_EMMC_TOP_PSTATE_BREN_MASK            0x00000800
#define SD4_EMMC_TOP_PSTATE_BWEN_SHIFT           10
#define SD4_EMMC_TOP_PSTATE_BWEN_MASK            0x00000400
#define SD4_EMMC_TOP_PSTATE_RXACT_SHIFT          9
#define SD4_EMMC_TOP_PSTATE_RXACT_MASK           0x00000200
#define SD4_EMMC_TOP_PSTATE_WXACT_SHIFT          8
#define SD4_EMMC_TOP_PSTATE_WXACT_MASK           0x00000100
#define SD4_EMMC_TOP_PSTATE_RETUNE_REQ_SHIFT     3
#define SD4_EMMC_TOP_PSTATE_RETUNE_REQ_MASK      0x00000008
#define SD4_EMMC_TOP_PSTATE_DATACT_SHIFT         2
#define SD4_EMMC_TOP_PSTATE_DATACT_MASK          0x00000004
#define SD4_EMMC_TOP_PSTATE_DATINH_SHIFT         1
#define SD4_EMMC_TOP_PSTATE_DATINH_MASK          0x00000002
#define SD4_EMMC_TOP_PSTATE_CMDINH_SHIFT         0
#define SD4_EMMC_TOP_PSTATE_CMDINH_MASK          0x00000001

#define SD4_EMMC_TOP_PSTATE_SD4_OFFSET               0x00000024
#define SD4_EMMC_TOP_PSTATE_SD4_DEFAULT              0x01FC00F0
#define SD4_EMMC_TOP_PSTATE_SD4_TYPE                 uint32_t
#define SD4_EMMC_TOP_PSTATE_SD4_RESERVED_MASK        0x1E00F000
#define SD4_EMMC_TOP_PSTATE_SD4_STBLDET_SHIFT        31
#define SD4_EMMC_TOP_PSTATE_SD4_STBLDET_MASK         0x80000000
#define SD4_EMMC_TOP_PSTATE_SD4_LANESYNC_SHIFT       30
#define SD4_EMMC_TOP_PSTATE_SD4_LANESYNC_MASK        0x40000000
#define SD4_EMMC_TOP_PSTATE_SD4_INDORMNTSTATE_SHIFT  29
#define SD4_EMMC_TOP_PSTATE_SD4_INDORMNTSTATE_MASK   0x20000000
#define SD4_EMMC_TOP_PSTATE_SD4_CLSL_SHIFT           24
#define SD4_EMMC_TOP_PSTATE_SD4_CLSL_MASK            0x01000000
#define SD4_EMMC_TOP_PSTATE_SD4_DLS3_0_SHIFT         20
#define SD4_EMMC_TOP_PSTATE_SD4_DLS3_0_MASK          0x00F00000
#define SD4_EMMC_TOP_PSTATE_SD4_WPSL_SHIFT       19
#define SD4_EMMC_TOP_PSTATE_SD4_WPSL_MASK        0x00080000
#define SD4_EMMC_TOP_PSTATE_SD4_CDPL_SHIFT       18
#define SD4_EMMC_TOP_PSTATE_SD4_CDPL_MASK        0x00040000
#define SD4_EMMC_TOP_PSTATE_SD4_CSS_SHIFT        17
#define SD4_EMMC_TOP_PSTATE_SD4_CSS_MASK         0x00020000
#define SD4_EMMC_TOP_PSTATE_SD4_CINS_SHIFT       16
#define SD4_EMMC_TOP_PSTATE_SD4_CINS_MASK        0x00010000
#define SD4_EMMC_TOP_PSTATE_SD4_BREN_SHIFT       11
#define SD4_EMMC_TOP_PSTATE_SD4_BREN_MASK        0x00000800
#define SD4_EMMC_TOP_PSTATE_SD4_BWEN_SHIFT       10
#define SD4_EMMC_TOP_PSTATE_SD4_BWEN_MASK        0x00000400
#define SD4_EMMC_TOP_PSTATE_SD4_RXACT_SHIFT      9
#define SD4_EMMC_TOP_PSTATE_SD4_RXACT_MASK       0x00000200
#define SD4_EMMC_TOP_PSTATE_SD4_WXACT_SHIFT      8
#define SD4_EMMC_TOP_PSTATE_SD4_WXACT_MASK       0x00000100
#define SD4_EMMC_TOP_PSTATE_SD4_DLS7_4_SHIFT     4
#define SD4_EMMC_TOP_PSTATE_SD4_DLS7_4_MASK      0x000000F0
#define SD4_EMMC_TOP_PSTATE_SD4_RETUNE_REQ_SHIFT 3
#define SD4_EMMC_TOP_PSTATE_SD4_RETUNE_REQ_MASK  0x00000008
#define SD4_EMMC_TOP_PSTATE_SD4_DATACT_SHIFT     2
#define SD4_EMMC_TOP_PSTATE_SD4_DATACT_MASK      0x00000004
#define SD4_EMMC_TOP_PSTATE_SD4_DATINH_SHIFT     1
#define SD4_EMMC_TOP_PSTATE_SD4_DATINH_MASK      0x00000002
#define SD4_EMMC_TOP_PSTATE_SD4_CMDINH_SHIFT     0
#define SD4_EMMC_TOP_PSTATE_SD4_CMDINH_MASK      0x00000001

#define SD4_EMMC_TOP_CTRL_OFFSET                 0x00000028
#define SD4_EMMC_TOP_CTRL_DEFAULT                0x00000000
#define SD4_EMMC_TOP_CTRL_TYPE                   uint32_t
#define SD4_EMMC_TOP_CTRL_RESERVED_MASK          0xF800E000
#define SD4_EMMC_TOP_CTRL_WAKENRMV_SHIFT         26
#define SD4_EMMC_TOP_CTRL_WAKENRMV_MASK          0x04000000
#define SD4_EMMC_TOP_CTRL_WAKENINS_SHIFT         25
#define SD4_EMMC_TOP_CTRL_WAKENINS_MASK          0x02000000
#define SD4_EMMC_TOP_CTRL_WAKENIRQ_SHIFT         24
#define SD4_EMMC_TOP_CTRL_WAKENIRQ_MASK          0x01000000
#define SD4_EMMC_TOP_CTRL_BOOTACK_SHIFT          23
#define SD4_EMMC_TOP_CTRL_BOOTACK_MASK           0x00800000
#define SD4_EMMC_TOP_CTRL_ATLBOOTEN_SHIFT        22
#define SD4_EMMC_TOP_CTRL_ATLBOOTEN_MASK         0x00400000
#define SD4_EMMC_TOP_CTRL_BOOTEN_SHIFT           21
#define SD4_EMMC_TOP_CTRL_BOOTEN_MASK            0x00200000
#define SD4_EMMC_TOP_CTRL_SPIMODE_SHIFT          20
#define SD4_EMMC_TOP_CTRL_SPIMODE_MASK           0x00100000
#define SD4_EMMC_TOP_CTRL_BLKIRQ_SHIFT           19
#define SD4_EMMC_TOP_CTRL_BLKIRQ_MASK            0x00080000
#define SD4_EMMC_TOP_CTRL_RDWTCRTL_SHIFT         18
#define SD4_EMMC_TOP_CTRL_RDWTCRTL_MASK          0x00040000
#define SD4_EMMC_TOP_CTRL_CONTREQ_SHIFT          17
#define SD4_EMMC_TOP_CTRL_CONTREQ_MASK           0x00020000
#define SD4_EMMC_TOP_CTRL_BLKSTPREQ_SHIFT        16
#define SD4_EMMC_TOP_CTRL_BLKSTPREQ_MASK         0x00010000
#define SD4_EMMC_TOP_CTRL_HRESET_SHIFT           12
#define SD4_EMMC_TOP_CTRL_HRESET_MASK            0x00001000
#define SD4_EMMC_TOP_CTRL_SDVSELVDD1_SHIFT       9
#define SD4_EMMC_TOP_CTRL_SDVSELVDD1_MASK        0x00000E00
#define SD4_EMMC_TOP_CTRL_SDPWR_SHIFT            8
#define SD4_EMMC_TOP_CTRL_SDPWR_MASK             0x00000100
#define SD4_EMMC_TOP_CTRL_CDSD_SHIFT             7
#define SD4_EMMC_TOP_CTRL_CDSD_MASK              0x00000080
#define SD4_EMMC_TOP_CTRL_CDTL_SHIFT             6
#define SD4_EMMC_TOP_CTRL_CDTL_MASK              0x00000040
#define SD4_EMMC_TOP_CTRL_SDB_SHIFT              5
#define SD4_EMMC_TOP_CTRL_SDB_MASK               0x00000020
#define SD4_EMMC_TOP_CTRL_DMASEL_SHIFT           3
#define SD4_EMMC_TOP_CTRL_DMASEL_MASK            0x00000018
#define SD4_EMMC_TOP_CTRL_HSEN_SHIFT             2
#define SD4_EMMC_TOP_CTRL_HSEN_MASK              0x00000004
#define SD4_EMMC_TOP_CTRL_DXTW_SHIFT             1
#define SD4_EMMC_TOP_CTRL_DXTW_MASK              0x00000002
#define SD4_EMMC_TOP_CTRL_LEDCTL_SHIFT           0
#define SD4_EMMC_TOP_CTRL_LEDCTL_MASK            0x00000001

#define SD4_EMMC_TOP_CTRL_SD4_OFFSET             0x00000028
#define SD4_EMMC_TOP_CTRL_SD4_DEFAULT            0x00000000
#define SD4_EMMC_TOP_CTRL_SD4_TYPE               uint32_t
#define SD4_EMMC_TOP_CTRL_SD4_RESERVED_MASK      0xF8F00000
#define SD4_EMMC_TOP_CTRL_SD4_WAKENRMV_SHIFT     26
#define SD4_EMMC_TOP_CTRL_SD4_WAKENRMV_MASK      0x04000000
#define SD4_EMMC_TOP_CTRL_SD4_WAKENINS_SHIFT     25
#define SD4_EMMC_TOP_CTRL_SD4_WAKENINS_MASK      0x02000000
#define SD4_EMMC_TOP_CTRL_SD4_WAKENIRQ_SHIFT     24
#define SD4_EMMC_TOP_CTRL_SD4_WAKENIRQ_MASK      0x01000000
#define SD4_EMMC_TOP_CTRL_SD4_BLKIRQ_SHIFT       19
#define SD4_EMMC_TOP_CTRL_SD4_BLKIRQ_MASK        0x00080000
#define SD4_EMMC_TOP_CTRL_SD4_RDWTCRTL_SHIFT     18
#define SD4_EMMC_TOP_CTRL_SD4_RDWTCRTL_MASK      0x00040000
#define SD4_EMMC_TOP_CTRL_SD4_CONTREQ_SHIFT      17
#define SD4_EMMC_TOP_CTRL_SD4_CONTREQ_MASK       0x00020000
#define SD4_EMMC_TOP_CTRL_SD4_BLKSTPREQ_SHIFT    16
#define SD4_EMMC_TOP_CTRL_SD4_BLKSTPREQ_MASK     0x00010000
#define SD4_EMMC_TOP_CTRL_SD4_SDVSELVDD2_SHIFT   13
#define SD4_EMMC_TOP_CTRL_SD4_SDVSELVDD2_MASK    0x0000E000
#define SD4_EMMC_TOP_CTRL_SD4_SDPWRVDD2_SHIFT    12
#define SD4_EMMC_TOP_CTRL_SD4_SDPWRVDD2_MASK     0x00001000
#define SD4_EMMC_TOP_CTRL_SD4_SDVSELVDD1_SHIFT   9
#define SD4_EMMC_TOP_CTRL_SD4_SDVSELVDD1_MASK    0x00000E00
#define SD4_EMMC_TOP_CTRL_SD4_SDPWR_SHIFT        8
#define SD4_EMMC_TOP_CTRL_SD4_SDPWR_MASK         0x00000100
#define SD4_EMMC_TOP_CTRL_SD4_CDSD_SHIFT         7
#define SD4_EMMC_TOP_CTRL_SD4_CDSD_MASK          0x00000080
#define SD4_EMMC_TOP_CTRL_SD4_CDTL_SHIFT         6
#define SD4_EMMC_TOP_CTRL_SD4_CDTL_MASK          0x00000040
#define SD4_EMMC_TOP_CTRL_SD4_SDB_SHIFT          5
#define SD4_EMMC_TOP_CTRL_SD4_SDB_MASK           0x00000020
#define SD4_EMMC_TOP_CTRL_SD4_DMASEL_SHIFT       3
#define SD4_EMMC_TOP_CTRL_SD4_DMASEL_MASK        0x00000018
#define SD4_EMMC_TOP_CTRL_SD4_HSEN_SHIFT         2
#define SD4_EMMC_TOP_CTRL_SD4_HSEN_MASK          0x00000004
#define SD4_EMMC_TOP_CTRL_SD4_DXTW_SHIFT         1
#define SD4_EMMC_TOP_CTRL_SD4_DXTW_MASK          0x00000002
#define SD4_EMMC_TOP_CTRL_SD4_LEDCTL_SHIFT       0
#define SD4_EMMC_TOP_CTRL_SD4_LEDCTL_MASK        0x00000001

#define SD4_EMMC_TOP_CTRL1_OFFSET                0x0000002C
#define SD4_EMMC_TOP_CTRL1_DEFAULT               0x00000000
#define SD4_EMMC_TOP_CTRL1_TYPE                  uint32_t
#define SD4_EMMC_TOP_CTRL1_RESERVED_MASK         0xF8F00018
#define SD4_EMMC_TOP_CTRL1_DATRST_SHIFT          26
#define SD4_EMMC_TOP_CTRL1_DATRST_MASK           0x04000000
#define SD4_EMMC_TOP_CTRL1_CMDRST_SHIFT          25
#define SD4_EMMC_TOP_CTRL1_CMDRST_MASK           0x02000000
#define SD4_EMMC_TOP_CTRL1_RST_SHIFT             24
#define SD4_EMMC_TOP_CTRL1_RST_MASK              0x01000000
#define SD4_EMMC_TOP_CTRL1_DTCNT_SHIFT           16
#define SD4_EMMC_TOP_CTRL1_DTCNT_MASK            0x000F0000
#define SD4_EMMC_TOP_CTRL1_SDCLKSEL_SHIFT        8
#define SD4_EMMC_TOP_CTRL1_SDCLKSEL_MASK         0x0000FF00
#define SD4_EMMC_TOP_CTRL1_SDCLKSEL_UP_SHIFT     6
#define SD4_EMMC_TOP_CTRL1_SDCLKSEL_UP_MASK      0x000000C0
#define SD4_EMMC_TOP_CTRL1_CLKGENSEL_SHIFT       5
#define SD4_EMMC_TOP_CTRL1_CLKGENSEL_MASK        0x00000020
#define SD4_EMMC_TOP_CTRL1_SDCLKEN_SHIFT         2
#define SD4_EMMC_TOP_CTRL1_SDCLKEN_MASK          0x00000004
#define SD4_EMMC_TOP_CTRL1_ICLKSTB_SHIFT         1
#define SD4_EMMC_TOP_CTRL1_ICLKSTB_MASK          0x00000002
#define SD4_EMMC_TOP_CTRL1_ICLKEN_SHIFT          0
#define SD4_EMMC_TOP_CTRL1_ICLKEN_MASK           0x00000001

#define SD4_EMMC_TOP_INTR_OFFSET                 0x00000030
#define SD4_EMMC_TOP_INTR_DEFAULT                0x00000000
#define SD4_EMMC_TOP_INTR_TYPE                   uint32_t
#define SD4_EMMC_TOP_INTR_RESERVED_MASK          0xEC000000
#define SD4_EMMC_TOP_INTR_TRESPERR_SHIFT         28
#define SD4_EMMC_TOP_INTR_TRESPERR_MASK          0x10000000
#define SD4_EMMC_TOP_INTR_ADMAERR_SHIFT          25
#define SD4_EMMC_TOP_INTR_ADMAERR_MASK           0x02000000
#define SD4_EMMC_TOP_INTR_CMDERROR_SHIFT         24
#define SD4_EMMC_TOP_INTR_CMDERROR_MASK          0x01000000
#define SD4_EMMC_TOP_INTR_IERR_SHIFT             23
#define SD4_EMMC_TOP_INTR_IERR_MASK              0x00800000
#define SD4_EMMC_TOP_INTR_DEBERR_SHIFT           22
#define SD4_EMMC_TOP_INTR_DEBERR_MASK            0x00400000
#define SD4_EMMC_TOP_INTR_DCRCERR_SHIFT          21
#define SD4_EMMC_TOP_INTR_DCRCERR_MASK           0x00200000
#define SD4_EMMC_TOP_INTR_DTOERR_SHIFT           20
#define SD4_EMMC_TOP_INTR_DTOERR_MASK            0x00100000
#define SD4_EMMC_TOP_INTR_CMDIDXERR_SHIFT        19
#define SD4_EMMC_TOP_INTR_CMDIDXERR_MASK         0x00080000
#define SD4_EMMC_TOP_INTR_CEBERR_SHIFT           18
#define SD4_EMMC_TOP_INTR_CEBERR_MASK            0x00040000
#define SD4_EMMC_TOP_INTR_CCRCERR_SHIFT          17
#define SD4_EMMC_TOP_INTR_CCRCERR_MASK           0x00020000
#define SD4_EMMC_TOP_INTR_CTOERR_SHIFT           16
#define SD4_EMMC_TOP_INTR_CTOERR_MASK            0x00010000
#define SD4_EMMC_TOP_INTR_ERRIRQ_SHIFT           15
#define SD4_EMMC_TOP_INTR_ERRIRQ_MASK            0x00008000
#define SD4_EMMC_TOP_INTR_BTIRQ_SHIFT            14
#define SD4_EMMC_TOP_INTR_BTIRQ_MASK             0x00004000
#define SD4_EMMC_TOP_INTR_BTACKRX_SHIFT          13
#define SD4_EMMC_TOP_INTR_BTACKRX_MASK           0x00002000
#define SD4_EMMC_TOP_INTR_RETUNE_EVENT_SHIFT     12
#define SD4_EMMC_TOP_INTR_RETUNE_EVENT_MASK      0x00001000
#define SD4_EMMC_TOP_INTR_INT_C_SHIFT            11
#define SD4_EMMC_TOP_INTR_INT_C_MASK             0x00000800
#define SD4_EMMC_TOP_INTR_INT_B_SHIFT            10
#define SD4_EMMC_TOP_INTR_INT_B_MASK             0x00000400
#define SD4_EMMC_TOP_INTR_INT_A_SHIFT            9
#define SD4_EMMC_TOP_INTR_INT_A_MASK             0x00000200
#define SD4_EMMC_TOP_INTR_CRDIRQ_SHIFT           8
#define SD4_EMMC_TOP_INTR_CRDIRQ_MASK            0x00000100
#define SD4_EMMC_TOP_INTR_CRDRMV_SHIFT           7
#define SD4_EMMC_TOP_INTR_CRDRMV_MASK            0x00000080
#define SD4_EMMC_TOP_INTR_CRDINS_SHIFT           6
#define SD4_EMMC_TOP_INTR_CRDINS_MASK            0x00000040
#define SD4_EMMC_TOP_INTR_BRRDY_SHIFT            5
#define SD4_EMMC_TOP_INTR_BRRDY_MASK             0x00000020
#define SD4_EMMC_TOP_INTR_BWRDY_SHIFT            4
#define SD4_EMMC_TOP_INTR_BWRDY_MASK             0x00000010
#define SD4_EMMC_TOP_INTR_DMAIRQ_SHIFT           3
#define SD4_EMMC_TOP_INTR_DMAIRQ_MASK            0x00000008
#define SD4_EMMC_TOP_INTR_BLKENT_SHIFT           2
#define SD4_EMMC_TOP_INTR_BLKENT_MASK            0x00000004
#define SD4_EMMC_TOP_INTR_TXDONE_SHIFT           1
#define SD4_EMMC_TOP_INTR_TXDONE_MASK            0x00000002
#define SD4_EMMC_TOP_INTR_CMDDONE_SHIFT          0
#define SD4_EMMC_TOP_INTR_CMDDONE_MASK           0x00000001

#define SD4_EMMC_TOP_INTR_SD4_OFFSET             0x00000030
#define SD4_EMMC_TOP_INTR_SD4_DEFAULT            0x00000000
#define SD4_EMMC_TOP_INTR_SD4_TYPE               uint32_t
#define SD4_EMMC_TOP_INTR_SD4_RESERVED_MASK      0xF0006000
#define SD4_EMMC_TOP_INTR_SD4_TRESPERR_SHIFT     27
#define SD4_EMMC_TOP_INTR_SD4_TRESPERR_MASK      0x08000000
#define SD4_EMMC_TOP_INTR_SD4_TUNEERR_SHIFT      26
#define SD4_EMMC_TOP_INTR_SD4_TUNEERR_MASK       0x04000000
#define SD4_EMMC_TOP_INTR_SD4_ADMAERR_SHIFT      25
#define SD4_EMMC_TOP_INTR_SD4_ADMAERR_MASK       0x02000000
#define SD4_EMMC_TOP_INTR_SD4_CMDERROR_SHIFT     24
#define SD4_EMMC_TOP_INTR_SD4_CMDERROR_MASK      0x01000000
#define SD4_EMMC_TOP_INTR_SD4_IERR_SHIFT         23
#define SD4_EMMC_TOP_INTR_SD4_IERR_MASK          0x00800000
#define SD4_EMMC_TOP_INTR_SD4_DEBERR_SHIFT       22
#define SD4_EMMC_TOP_INTR_SD4_DEBERR_MASK        0x00400000
#define SD4_EMMC_TOP_INTR_SD4_DCRCERR_SHIFT      21
#define SD4_EMMC_TOP_INTR_SD4_DCRCERR_MASK       0x00200000
#define SD4_EMMC_TOP_INTR_SD4_DTOERR_SHIFT       20
#define SD4_EMMC_TOP_INTR_SD4_DTOERR_MASK        0x00100000
#define SD4_EMMC_TOP_INTR_SD4_CMDIDXERR_SHIFT    19
#define SD4_EMMC_TOP_INTR_SD4_CMDIDXERR_MASK     0x00080000
#define SD4_EMMC_TOP_INTR_SD4_CEBERR_SHIFT       18
#define SD4_EMMC_TOP_INTR_SD4_CEBERR_MASK        0x00040000
#define SD4_EMMC_TOP_INTR_SD4_CCRCERR_SHIFT      17
#define SD4_EMMC_TOP_INTR_SD4_CCRCERR_MASK       0x00020000
#define SD4_EMMC_TOP_INTR_SD4_CTOERR_SHIFT       16
#define SD4_EMMC_TOP_INTR_SD4_CTOERR_MASK        0x00010000
#define SD4_EMMC_TOP_INTR_SD4_ERRIRQ_SHIFT       15
#define SD4_EMMC_TOP_INTR_SD4_ERRIRQ_MASK        0x00008000
#define SD4_EMMC_TOP_INTR_SD4_RETUNE_EVENT_SHIFT 12
#define SD4_EMMC_TOP_INTR_SD4_RETUNE_EVENT_MASK  0x00001000
#define SD4_EMMC_TOP_INTR_SD4_INT_C_SHIFT        11
#define SD4_EMMC_TOP_INTR_SD4_INT_C_MASK         0x00000800
#define SD4_EMMC_TOP_INTR_SD4_INT_B_SHIFT        10
#define SD4_EMMC_TOP_INTR_SD4_INT_B_MASK         0x00000400
#define SD4_EMMC_TOP_INTR_SD4_INT_A_SHIFT        9
#define SD4_EMMC_TOP_INTR_SD4_INT_A_MASK         0x00000200
#define SD4_EMMC_TOP_INTR_SD4_CRDIRQ_SHIFT       8
#define SD4_EMMC_TOP_INTR_SD4_CRDIRQ_MASK        0x00000100
#define SD4_EMMC_TOP_INTR_SD4_CRDRMV_SHIFT       7
#define SD4_EMMC_TOP_INTR_SD4_CRDRMV_MASK        0x00000080
#define SD4_EMMC_TOP_INTR_SD4_CRDINS_SHIFT       6
#define SD4_EMMC_TOP_INTR_SD4_CRDINS_MASK        0x00000040
#define SD4_EMMC_TOP_INTR_SD4_BRRDY_SHIFT        5
#define SD4_EMMC_TOP_INTR_SD4_BRRDY_MASK         0x00000020
#define SD4_EMMC_TOP_INTR_SD4_BWRDY_SHIFT        4
#define SD4_EMMC_TOP_INTR_SD4_BWRDY_MASK         0x00000010
#define SD4_EMMC_TOP_INTR_SD4_DMAIRQ_SHIFT       3
#define SD4_EMMC_TOP_INTR_SD4_DMAIRQ_MASK        0x00000008
#define SD4_EMMC_TOP_INTR_SD4_BLKENT_SHIFT       2
#define SD4_EMMC_TOP_INTR_SD4_BLKENT_MASK        0x00000004
#define SD4_EMMC_TOP_INTR_SD4_TXDONE_SHIFT       1
#define SD4_EMMC_TOP_INTR_SD4_TXDONE_MASK        0x00000002
#define SD4_EMMC_TOP_INTR_SD4_CMDDONE_SHIFT      0
#define SD4_EMMC_TOP_INTR_SD4_CMDDONE_MASK       0x00000001

#define SD4_EMMC_TOP_INTREN1_OFFSET                0x00000034
#define SD4_EMMC_TOP_INTREN1_DEFAULT               0x00000000
#define SD4_EMMC_TOP_INTREN1_TYPE                  uint32_t
#define SD4_EMMC_TOP_INTREN1_RESERVED_MASK         0xEC000000
#define SD4_EMMC_TOP_INTREN1_TRESPERREN_SHIFT      28
#define SD4_EMMC_TOP_INTREN1_TRESPERREN_MASK       0x10000000
#define SD4_EMMC_TOP_INTREN1_ADMAEREN_SHIFT        25
#define SD4_EMMC_TOP_INTREN1_ADMAEREN_MASK         0x02000000
#define SD4_EMMC_TOP_INTREN1_CMDERREN_SHIFT        24
#define SD4_EMMC_TOP_INTREN1_CMDERREN_MASK         0x01000000
#define SD4_EMMC_TOP_INTREN1_ILIMERREN_SHIFT       23
#define SD4_EMMC_TOP_INTREN1_ILIMERREN_MASK        0x00800000
#define SD4_EMMC_TOP_INTREN1_DEBERREN_SHIFT        22
#define SD4_EMMC_TOP_INTREN1_DEBERREN_MASK         0x00400000
#define SD4_EMMC_TOP_INTREN1_DCRCERREN_SHIFT       21
#define SD4_EMMC_TOP_INTREN1_DCRCERREN_MASK        0x00200000
#define SD4_EMMC_TOP_INTREN1_DTOERREN_SHIFT        20
#define SD4_EMMC_TOP_INTREN1_DTOERREN_MASK         0x00100000
#define SD4_EMMC_TOP_INTREN1_CIDXERREN_SHIFT       19
#define SD4_EMMC_TOP_INTREN1_CIDXERREN_MASK        0x00080000
#define SD4_EMMC_TOP_INTREN1_CEBERREN_SHIFT        18
#define SD4_EMMC_TOP_INTREN1_CEBERREN_MASK         0x00040000
#define SD4_EMMC_TOP_INTREN1_CMDCRCEN_SHIFT        17
#define SD4_EMMC_TOP_INTREN1_CMDCRCEN_MASK         0x00020000
#define SD4_EMMC_TOP_INTREN1_CMDTOEN_SHIFT         16
#define SD4_EMMC_TOP_INTREN1_CMDTOEN_MASK          0x00010000
#define SD4_EMMC_TOP_INTREN1_FIXZ_SHIFT            15
#define SD4_EMMC_TOP_INTREN1_FIXZ_MASK             0x00008000
#define SD4_EMMC_TOP_INTREN1_BTIRQEN_SHIFT         14
#define SD4_EMMC_TOP_INTREN1_BTIRQEN_MASK          0x00004000
#define SD4_EMMC_TOP_INTREN1_BTACKRXEN_SHIFT       13
#define SD4_EMMC_TOP_INTREN1_BTACKRXEN_MASK        0x00002000
#define SD4_EMMC_TOP_INTREN1_RETUNE_EVENTEN_SHIFT  12
#define SD4_EMMC_TOP_INTREN1_RETUNE_EVENTEN_MASK   0x00001000
#define SD4_EMMC_TOP_INTREN1_INT_C_EN_SHIFT        11
#define SD4_EMMC_TOP_INTREN1_INT_C_EN_MASK         0x00000800
#define SD4_EMMC_TOP_INTREN1_INT_B_EN_SHIFT        10
#define SD4_EMMC_TOP_INTREN1_INT_B_EN_MASK         0x00000400
#define SD4_EMMC_TOP_INTREN1_INT_A_EN_SHIFT        9
#define SD4_EMMC_TOP_INTREN1_INT_A_EN_MASK         0x00000200
#define SD4_EMMC_TOP_INTREN1_CIRQEN_SHIFT          8
#define SD4_EMMC_TOP_INTREN1_CIRQEN_MASK           0x00000100
#define SD4_EMMC_TOP_INTREN1_CRDRMVEN_SHIFT        7
#define SD4_EMMC_TOP_INTREN1_CRDRMVEN_MASK         0x00000080
#define SD4_EMMC_TOP_INTREN1_CRDINSEN_SHIFT        6
#define SD4_EMMC_TOP_INTREN1_CRDINSEN_MASK         0x00000040
#define SD4_EMMC_TOP_INTREN1_BUFRREN_SHIFT         5
#define SD4_EMMC_TOP_INTREN1_BUFRREN_MASK          0x00000020
#define SD4_EMMC_TOP_INTREN1_BUFWREN_SHIFT         4
#define SD4_EMMC_TOP_INTREN1_BUFWREN_MASK          0x00000010
#define SD4_EMMC_TOP_INTREN1_DMAIRQEN_SHIFT        3
#define SD4_EMMC_TOP_INTREN1_DMAIRQEN_MASK         0x00000008
#define SD4_EMMC_TOP_INTREN1_BLKEN_SHIFT           2
#define SD4_EMMC_TOP_INTREN1_BLKEN_MASK            0x00000004
#define SD4_EMMC_TOP_INTREN1_TXDONEEN_SHIFT        1
#define SD4_EMMC_TOP_INTREN1_TXDONEEN_MASK         0x00000002
#define SD4_EMMC_TOP_INTREN1_CMDDONEEN_SHIFT       0
#define SD4_EMMC_TOP_INTREN1_CMDDONEEN_MASK        0x00000001

#define SD4_EMMC_TOP_INTREN1_SD4_OFFSET               0x00000034
#define SD4_EMMC_TOP_INTREN1_SD4_DEFAULT              0x00000000
#define SD4_EMMC_TOP_INTREN1_SD4_TYPE                 uint32_t
#define SD4_EMMC_TOP_INTREN1_SD4_RESERVED_MASK        0x00006000
#define SD4_EMMC_TOP_INTREN1_SD4_VNDRERREN_SHIFT      28
#define SD4_EMMC_TOP_INTREN1_SD4_VNDRERREN_MASK       0xF0000000
#define SD4_EMMC_TOP_INTREN1_SD4_TRESPERREN_SHIFT     27
#define SD4_EMMC_TOP_INTREN1_SD4_TRESPERREN_MASK      0x08000000
#define SD4_EMMC_TOP_INTREN1_SD4_TUNEERREN_SHIFT      26
#define SD4_EMMC_TOP_INTREN1_SD4_TUNEERREN_MASK       0x04000000
#define SD4_EMMC_TOP_INTREN1_SD4_ADMAEREN_SHIFT       25
#define SD4_EMMC_TOP_INTREN1_SD4_ADMAEREN_MASK        0x02000000
#define SD4_EMMC_TOP_INTREN1_SD4_CMDERREN_SHIFT       24
#define SD4_EMMC_TOP_INTREN1_SD4_CMDERREN_MASK        0x01000000
#define SD4_EMMC_TOP_INTREN1_SD4_ILIMERREN_SHIFT      23
#define SD4_EMMC_TOP_INTREN1_SD4_ILIMERREN_MASK       0x00800000
#define SD4_EMMC_TOP_INTREN1_SD4_DEBERREN_SHIFT       22
#define SD4_EMMC_TOP_INTREN1_SD4_DEBERREN_MASK        0x00400000
#define SD4_EMMC_TOP_INTREN1_SD4_DCRCERREN_SHIFT      21
#define SD4_EMMC_TOP_INTREN1_SD4_DCRCERREN_MASK       0x00200000
#define SD4_EMMC_TOP_INTREN1_SD4_DTOERREN_SHIFT       20
#define SD4_EMMC_TOP_INTREN1_SD4_DTOERREN_MASK        0x00100000
#define SD4_EMMC_TOP_INTREN1_SD4_CIDXERREN_SHIFT      19
#define SD4_EMMC_TOP_INTREN1_SD4_CIDXERREN_MASK       0x00080000
#define SD4_EMMC_TOP_INTREN1_SD4_CEBERREN_SHIFT       18
#define SD4_EMMC_TOP_INTREN1_SD4_CEBERREN_MASK        0x00040000
#define SD4_EMMC_TOP_INTREN1_SD4_CMDCRCEN_SHIFT       17
#define SD4_EMMC_TOP_INTREN1_SD4_CMDCRCEN_MASK        0x00020000
#define SD4_EMMC_TOP_INTREN1_SD4_CMDTOEN_SHIFT        16
#define SD4_EMMC_TOP_INTREN1_SD4_CMDTOEN_MASK         0x00010000
#define SD4_EMMC_TOP_INTREN1_SD4_FIXZ_SHIFT           15
#define SD4_EMMC_TOP_INTREN1_SD4_FIXZ_MASK            0x00008000
#define SD4_EMMC_TOP_INTREN1_SD4_RETUNE_EVENTEN_SHIFT 12
#define SD4_EMMC_TOP_INTREN1_SD4_RETUNE_EVENTEN_MASK  0x00001000
#define SD4_EMMC_TOP_INTREN1_SD4_INT_C_EN_SHIFT       11
#define SD4_EMMC_TOP_INTREN1_SD4_INT_C_EN_MASK        0x00000800
#define SD4_EMMC_TOP_INTREN1_SD4_INT_B_EN_SHIFT       10
#define SD4_EMMC_TOP_INTREN1_SD4_INT_B_EN_MASK        0x00000400
#define SD4_EMMC_TOP_INTREN1_SD4_INT_A_EN_SHIFT       9
#define SD4_EMMC_TOP_INTREN1_SD4_INT_A_EN_MASK        0x00000200
#define SD4_EMMC_TOP_INTREN1_SD4_CIRQEN_SHIFT         8
#define SD4_EMMC_TOP_INTREN1_SD4_CIRQEN_MASK          0x00000100
#define SD4_EMMC_TOP_INTREN1_SD4_CRDRMVEN_SHIFT       7
#define SD4_EMMC_TOP_INTREN1_SD4_CRDRMVEN_MASK        0x00000080
#define SD4_EMMC_TOP_INTREN1_SD4_CRDINSEN_SHIFT       6
#define SD4_EMMC_TOP_INTREN1_SD4_CRDINSEN_MASK        0x00000040
#define SD4_EMMC_TOP_INTREN1_SD4_BUFRREN_SHIFT        5
#define SD4_EMMC_TOP_INTREN1_SD4_BUFRREN_MASK         0x00000020
#define SD4_EMMC_TOP_INTREN1_SD4_BUFWREN_SHIFT        4
#define SD4_EMMC_TOP_INTREN1_SD4_BUFWREN_MASK         0x00000010
#define SD4_EMMC_TOP_INTREN1_SD4_DMAIRQEN_SHIFT       3
#define SD4_EMMC_TOP_INTREN1_SD4_DMAIRQEN_MASK        0x00000008
#define SD4_EMMC_TOP_INTREN1_SD4_BLKEN_SHIFT          2
#define SD4_EMMC_TOP_INTREN1_SD4_BLKEN_MASK           0x00000004
#define SD4_EMMC_TOP_INTREN1_SD4_TXDONEEN_SHIFT       1
#define SD4_EMMC_TOP_INTREN1_SD4_TXDONEEN_MASK        0x00000002
#define SD4_EMMC_TOP_INTREN1_SD4_CMDDONEEN_SHIFT      0
#define SD4_EMMC_TOP_INTREN1_SD4_CMDDONEEN_MASK       0x00000001

#define SD4_EMMC_TOP_INTREN2_OFFSET                   0x00000038
#define SD4_EMMC_TOP_INTREN2_DEFAULT                  0x00000000
#define SD4_EMMC_TOP_INTREN2_TYPE                     uint32_t
#define SD4_EMMC_TOP_INTREN2_RESERVED_MASK            0xEC000000
#define SD4_EMMC_TOP_INTREN2_TRESPERRSEN_SHIFT        28
#define SD4_EMMC_TOP_INTREN2_TRESPERRSEN_MASK         0x10000000
#define SD4_EMMC_TOP_INTREN2_ADMASIGEN_SHIFT          25
#define SD4_EMMC_TOP_INTREN2_ADMASIGEN_MASK           0x02000000
#define SD4_EMMC_TOP_INTREN2_CMDSIGEN_SHIFT           24
#define SD4_EMMC_TOP_INTREN2_CMDSIGEN_MASK            0x01000000
#define SD4_EMMC_TOP_INTREN2_ILIMSIGEN_SHIFT          23
#define SD4_EMMC_TOP_INTREN2_ILIMSIGEN_MASK           0x00800000
#define SD4_EMMC_TOP_INTREN2_DEBSIGEN_SHIFT           22
#define SD4_EMMC_TOP_INTREN2_DEBSIGEN_MASK            0x00400000
#define SD4_EMMC_TOP_INTREN2_DCRCSIGEN_SHIFT          21
#define SD4_EMMC_TOP_INTREN2_DCRCSIGEN_MASK           0x00200000
#define SD4_EMMC_TOP_INTREN2_DTOSIGEN_SHIFT           20
#define SD4_EMMC_TOP_INTREN2_DTOSIGEN_MASK            0x00100000
#define SD4_EMMC_TOP_INTREN2_CIDXSIGEN_SHIFT          19
#define SD4_EMMC_TOP_INTREN2_CIDXSIGEN_MASK           0x00080000
#define SD4_EMMC_TOP_INTREN2_CEBSIGEN_SHIFT           18
#define SD4_EMMC_TOP_INTREN2_CEBSIGEN_MASK            0x00040000
#define SD4_EMMC_TOP_INTREN2_CMDCRCSIGEN_SHIFT        17
#define SD4_EMMC_TOP_INTREN2_CMDCRCSIGEN_MASK         0x00020000
#define SD4_EMMC_TOP_INTREN2_CMDTOSIGEN_SHIFT         16
#define SD4_EMMC_TOP_INTREN2_CMDTOSIGEN_MASK          0x00010000
#define SD4_EMMC_TOP_INTREN2_FIXZERO_SHIFT            15
#define SD4_EMMC_TOP_INTREN2_FIXZERO_MASK             0x00008000
#define SD4_EMMC_TOP_INTREN2_BTIRQSEN_SHIFT           14
#define SD4_EMMC_TOP_INTREN2_BTIRQSEN_MASK            0x00004000
#define SD4_EMMC_TOP_INTREN2_BTACKRXSEN_SHIFT         13
#define SD4_EMMC_TOP_INTREN2_BTACKRXSEN_MASK          0x00002000
#define SD4_EMMC_TOP_INTREN2_RETUNE_EVENTSIGEN_SHIFT  12
#define SD4_EMMC_TOP_INTREN2_RETUNE_EVENTSIGEN_MASK   0x00001000
#define SD4_EMMC_TOP_INTREN2_INT_C_SIGEN_SHIFT        11
#define SD4_EMMC_TOP_INTREN2_INT_C_SIGEN_MASK         0x00000800
#define SD4_EMMC_TOP_INTREN2_INT_B_SIGEN_SHIFT        10
#define SD4_EMMC_TOP_INTREN2_INT_B_SIGEN_MASK         0x00000400
#define SD4_EMMC_TOP_INTREN2_INT_A_SIGEN_SHIFT        9
#define SD4_EMMC_TOP_INTREN2_INT_A_SIGEN_MASK         0x00000200
#define SD4_EMMC_TOP_INTREN2_CRDIRQEN_SHIFT           8
#define SD4_EMMC_TOP_INTREN2_CRDIRQEN_MASK            0x00000100
#define SD4_EMMC_TOP_INTREN2_CRDRVMEN_SHIFT           7
#define SD4_EMMC_TOP_INTREN2_CRDRVMEN_MASK            0x00000080
#define SD4_EMMC_TOP_INTREN2_CRDINSEN_SHIFT           6
#define SD4_EMMC_TOP_INTREN2_CRDINSEN_MASK            0x00000040
#define SD4_EMMC_TOP_INTREN2_BUFRRDYEN_SHIFT          5
#define SD4_EMMC_TOP_INTREN2_BUFRRDYEN_MASK           0x00000020
#define SD4_EMMC_TOP_INTREN2_BUFWRDYEN_SHIFT          4
#define SD4_EMMC_TOP_INTREN2_BUFWRDYEN_MASK           0x00000010
#define SD4_EMMC_TOP_INTREN2_DMAIRQEN_SHIFT           3
#define SD4_EMMC_TOP_INTREN2_DMAIRQEN_MASK            0x00000008
#define SD4_EMMC_TOP_INTREN2_BLKGAPEN_SHIFT           2
#define SD4_EMMC_TOP_INTREN2_BLKGAPEN_MASK            0x00000004
#define SD4_EMMC_TOP_INTREN2_TXDONE_SHIFT             1
#define SD4_EMMC_TOP_INTREN2_TXDONE_MASK              0x00000002
#define SD4_EMMC_TOP_INTREN2_CMDDONE_SHIFT            0
#define SD4_EMMC_TOP_INTREN2_CMDDONE_MASK             0x00000001

#define SD4_EMMC_TOP_INTREN2_SD4_OFFSET                   0x00000038
#define SD4_EMMC_TOP_INTREN2_SD4_DEFAULT                  0x00000000
#define SD4_EMMC_TOP_INTREN2_SD4_TYPE                     uint32_t
#define SD4_EMMC_TOP_INTREN2_SD4_RESERVED_MASK            0xF0006000
#define SD4_EMMC_TOP_INTREN2_SD4_TRESPERRSEN_SHIFT        27
#define SD4_EMMC_TOP_INTREN2_SD4_TRESPERRSEN_MASK         0x08000000
#define SD4_EMMC_TOP_INTREN2_SD4_TUNERRSIGEN_SHIFT        26
#define SD4_EMMC_TOP_INTREN2_SD4_TUNERRSIGEN_MASK         0x04000000
#define SD4_EMMC_TOP_INTREN2_SD4_ADMASIGEN_SHIFT          25
#define SD4_EMMC_TOP_INTREN2_SD4_ADMASIGEN_MASK           0x02000000
#define SD4_EMMC_TOP_INTREN2_SD4_CMDSIGEN_SHIFT           24
#define SD4_EMMC_TOP_INTREN2_SD4_CMDSIGEN_MASK            0x01000000
#define SD4_EMMC_TOP_INTREN2_SD4_ILIMSIGEN_SHIFT          23
#define SD4_EMMC_TOP_INTREN2_SD4_ILIMSIGEN_MASK           0x00800000
#define SD4_EMMC_TOP_INTREN2_SD4_DEBSIGEN_SHIFT           22
#define SD4_EMMC_TOP_INTREN2_SD4_DEBSIGEN_MASK            0x00400000
#define SD4_EMMC_TOP_INTREN2_SD4_DCRCSIGEN_SHIFT          21
#define SD4_EMMC_TOP_INTREN2_SD4_DCRCSIGEN_MASK           0x00200000
#define SD4_EMMC_TOP_INTREN2_SD4_DTOSIGEN_SHIFT           20
#define SD4_EMMC_TOP_INTREN2_SD4_DTOSIGEN_MASK            0x00100000
#define SD4_EMMC_TOP_INTREN2_SD4_CIDXSIGEN_SHIFT          19
#define SD4_EMMC_TOP_INTREN2_SD4_CIDXSIGEN_MASK           0x00080000
#define SD4_EMMC_TOP_INTREN2_SD4_CEBSIGEN_SHIFT           18
#define SD4_EMMC_TOP_INTREN2_SD4_CEBSIGEN_MASK            0x00040000
#define SD4_EMMC_TOP_INTREN2_SD4_CMDCRCSIGEN_SHIFT        17
#define SD4_EMMC_TOP_INTREN2_SD4_CMDCRCSIGEN_MASK         0x00020000
#define SD4_EMMC_TOP_INTREN2_SD4_CMDTOSIGEN_SHIFT         16
#define SD4_EMMC_TOP_INTREN2_SD4_CMDTOSIGEN_MASK          0x00010000
#define SD4_EMMC_TOP_INTREN2_SD4_FIXZERO_SHIFT            15
#define SD4_EMMC_TOP_INTREN2_SD4_FIXZERO_MASK             0x00008000
#define SD4_EMMC_TOP_INTREN2_SD4_RETUNE_EVENTSIGEN_SHIFT  12
#define SD4_EMMC_TOP_INTREN2_SD4_RETUNE_EVENTSIGEN_MASK   0x00001000
#define SD4_EMMC_TOP_INTREN2_SD4_INT_C_SIGEN_SHIFT        11
#define SD4_EMMC_TOP_INTREN2_SD4_INT_C_SIGEN_MASK         0x00000800
#define SD4_EMMC_TOP_INTREN2_SD4_INT_B_SIGEN_SHIFT        10
#define SD4_EMMC_TOP_INTREN2_SD4_INT_B_SIGEN_MASK         0x00000400
#define SD4_EMMC_TOP_INTREN2_SD4_INT_A_SIGEN_SHIFT        9
#define SD4_EMMC_TOP_INTREN2_SD4_INT_A_SIGEN_MASK         0x00000200
#define SD4_EMMC_TOP_INTREN2_SD4_CRDIRQEN_SHIFT           8
#define SD4_EMMC_TOP_INTREN2_SD4_CRDIRQEN_MASK            0x00000100
#define SD4_EMMC_TOP_INTREN2_SD4_CRDRVMEN_SHIFT           7
#define SD4_EMMC_TOP_INTREN2_SD4_CRDRVMEN_MASK            0x00000080
#define SD4_EMMC_TOP_INTREN2_SD4_CRDINSEN_SHIFT           6
#define SD4_EMMC_TOP_INTREN2_SD4_CRDINSEN_MASK            0x00000040
#define SD4_EMMC_TOP_INTREN2_SD4_BUFRRDYEN_SHIFT          5
#define SD4_EMMC_TOP_INTREN2_SD4_BUFRRDYEN_MASK           0x00000020
#define SD4_EMMC_TOP_INTREN2_SD4_BUFWRDYEN_SHIFT          4
#define SD4_EMMC_TOP_INTREN2_SD4_BUFWRDYEN_MASK           0x00000010
#define SD4_EMMC_TOP_INTREN2_SD4_DMAIRQEN_SHIFT           3
#define SD4_EMMC_TOP_INTREN2_SD4_DMAIRQEN_MASK            0x00000008
#define SD4_EMMC_TOP_INTREN2_SD4_BLKGAPEN_SHIFT           2
#define SD4_EMMC_TOP_INTREN2_SD4_BLKGAPEN_MASK            0x00000004
#define SD4_EMMC_TOP_INTREN2_SD4_TXDONE_SHIFT             1
#define SD4_EMMC_TOP_INTREN2_SD4_TXDONE_MASK              0x00000002
#define SD4_EMMC_TOP_INTREN2_SD4_CMDDONE_SHIFT            0
#define SD4_EMMC_TOP_INTREN2_SD4_CMDDONE_MASK             0x00000001

#define SD4_EMMC_TOP_ERRSTAT_OFFSET                0x0000003C
#define SD4_EMMC_TOP_ERRSTAT_DEFAULT               0x00000000
#define SD4_EMMC_TOP_ERRSTAT_TYPE                  uint32_t
#define SD4_EMMC_TOP_ERRSTAT_RESERVED_MASK         0x3F00FF60
#define SD4_EMMC_TOP_ERRSTAT_PRESETEN_SHIFT        31
#define SD4_EMMC_TOP_ERRSTAT_PRESETEN_MASK         0x80000000
#define SD4_EMMC_TOP_ERRSTAT_ASYNC_INTREN_SHIFT    30
#define SD4_EMMC_TOP_ERRSTAT_ASYNC_INTREN_MASK     0x40000000
#define SD4_EMMC_TOP_ERRSTAT_SAMPLECLOCKSEL_SHIFT  23
#define SD4_EMMC_TOP_ERRSTAT_SAMPLECLOCKSEL_MASK   0x00800000
#define SD4_EMMC_TOP_ERRSTAT_EXECTUNE_SHIFT        22
#define SD4_EMMC_TOP_ERRSTAT_EXECTUNE_MASK         0x00400000
#define SD4_EMMC_TOP_ERRSTAT_DRVSTRESEL_SHIFT      20
#define SD4_EMMC_TOP_ERRSTAT_DRVSTRESEL_MASK       0x00300000
#define SD4_EMMC_TOP_ERRSTAT_EN1P8V_SHIFT          19
#define SD4_EMMC_TOP_ERRSTAT_EN1P8V_MASK           0x00080000
#define SD4_EMMC_TOP_ERRSTAT_UHSMODESEL_SHIFT      16
#define SD4_EMMC_TOP_ERRSTAT_UHSMODESEL_MASK       0x00070000
#define SD4_EMMC_TOP_ERRSTAT_NOCMD_SHIFT           7
#define SD4_EMMC_TOP_ERRSTAT_NOCMD_MASK            0x00000080
#define SD4_EMMC_TOP_ERRSTAT_CMDIDXERR_SHIFT       4
#define SD4_EMMC_TOP_ERRSTAT_CMDIDXERR_MASK        0x00000010
#define SD4_EMMC_TOP_ERRSTAT_CMDENDERR_SHIFT       3
#define SD4_EMMC_TOP_ERRSTAT_CMDENDERR_MASK        0x00000008
#define SD4_EMMC_TOP_ERRSTAT_CMDCRCERR_SHIFT       2
#define SD4_EMMC_TOP_ERRSTAT_CMDCRCERR_MASK        0x00000004
#define SD4_EMMC_TOP_ERRSTAT_CMDTOERR_SHIFT        1
#define SD4_EMMC_TOP_ERRSTAT_CMDTOERR_MASK         0x00000002
#define SD4_EMMC_TOP_ERRSTAT_CMDNOEXEC_SHIFT       0
#define SD4_EMMC_TOP_ERRSTAT_CMDNOEXEC_MASK        0x00000001

#define SD4_EMMC_TOP_ERRSTAT_SD4_OFFSET                0x0000003C
#define SD4_EMMC_TOP_ERRSTAT_SD4_DEFAULT               0x00000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_TYPE                  uint32_t
#define SD4_EMMC_TOP_ERRSTAT_SD4_RESERVED_MASK         0x0E00FF40
#define SD4_EMMC_TOP_ERRSTAT_SD4_PRESETEN_SHIFT        31
#define SD4_EMMC_TOP_ERRSTAT_SD4_PRESETEN_MASK         0x80000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_ASYNC_INTREN_SHIFT    30
#define SD4_EMMC_TOP_ERRSTAT_SD4_ASYNC_INTREN_MASK     0x40000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_ADDR64_SHIFT          29
#define SD4_EMMC_TOP_ERRSTAT_SD4_ADDR64_MASK           0x20000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_HOSTVER4_00_SHIFT     28
#define SD4_EMMC_TOP_ERRSTAT_SD4_HOSTVER4_00_MASK      0x10000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_UHS2INTFEN_SHIFT      24
#define SD4_EMMC_TOP_ERRSTAT_SD4_UHS2INTFEN_MASK       0x01000000
#define SD4_EMMC_TOP_ERRSTAT_SD4_SAMPLECLOCKSEL_SHIFT  23
#define SD4_EMMC_TOP_ERRSTAT_SD4_SAMPLECLOCKSEL_MASK   0x00800000
#define SD4_EMMC_TOP_ERRSTAT_SD4_EXECTUNE_SHIFT        22
#define SD4_EMMC_TOP_ERRSTAT_SD4_EXECTUNE_MASK         0x00400000
#define SD4_EMMC_TOP_ERRSTAT_SD4_DRVSTRESEL_SHIFT      20
#define SD4_EMMC_TOP_ERRSTAT_SD4_DRVSTRESEL_MASK       0x00300000
#define SD4_EMMC_TOP_ERRSTAT_SD4_EN1P8V_SHIFT          19
#define SD4_EMMC_TOP_ERRSTAT_SD4_EN1P8V_MASK           0x00080000
#define SD4_EMMC_TOP_ERRSTAT_SD4_UHSMODESEL_SHIFT      16
#define SD4_EMMC_TOP_ERRSTAT_SD4_UHSMODESEL_MASK       0x00070000
#define SD4_EMMC_TOP_ERRSTAT_SD4_NOCMD_SHIFT           7
#define SD4_EMMC_TOP_ERRSTAT_SD4_NOCMD_MASK            0x00000080
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDRESPERR_SHIFT      5
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDRESPERR_MASK       0x00000020
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDIDXERR_SHIFT       4
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDIDXERR_MASK        0x00000010
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDENDERR_SHIFT       3
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDENDERR_MASK        0x00000008
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDCRCERR_SHIFT       2
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDCRCERR_MASK        0x00000004
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDTOERR_SHIFT        1
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDTOERR_MASK         0x00000002
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDNOEXEC_SHIFT       0
#define SD4_EMMC_TOP_ERRSTAT_SD4_CMDNOEXEC_MASK        0x00000001

#define SD4_EMMC_TOP_CAPABILITIES1_OFFSET           0x00000040
#define SD4_EMMC_TOP_CAPABILITIES1_DEFAULT          0x17EFD0B0
#define SD4_EMMC_TOP_CAPABILITIES1_TYPE             uint32_t
#define SD4_EMMC_TOP_CAPABILITIES1_RESERVED_MASK    0x08100040
#define SD4_EMMC_TOP_CAPABILITIES1_SLOTTYPE_SHIFT   30
#define SD4_EMMC_TOP_CAPABILITIES1_SLOTTYPE_MASK    0xC0000000
#define SD4_EMMC_TOP_CAPABILITIES1_ASYNCHIRQ_SHIFT  29
#define SD4_EMMC_TOP_CAPABILITIES1_ASYNCHIRQ_MASK   0x20000000
#define SD4_EMMC_TOP_CAPABILITIES1_SYSBUS64_SHIFT   28
#define SD4_EMMC_TOP_CAPABILITIES1_SYSBUS64_MASK    0x10000000
#define SD4_EMMC_TOP_CAPABILITIES1_V18_SHIFT        26
#define SD4_EMMC_TOP_CAPABILITIES1_V18_MASK         0x04000000
#define SD4_EMMC_TOP_CAPABILITIES1_V3_SHIFT         25
#define SD4_EMMC_TOP_CAPABILITIES1_V3_MASK          0x02000000
#define SD4_EMMC_TOP_CAPABILITIES1_V33_SHIFT        24
#define SD4_EMMC_TOP_CAPABILITIES1_V33_MASK         0x01000000
#define SD4_EMMC_TOP_CAPABILITIES1_SUPRSM_SHIFT     23
#define SD4_EMMC_TOP_CAPABILITIES1_SUPRSM_MASK      0x00800000
#define SD4_EMMC_TOP_CAPABILITIES1_SDMA_SHIFT       22
#define SD4_EMMC_TOP_CAPABILITIES1_SDMA_MASK        0x00400000
#define SD4_EMMC_TOP_CAPABILITIES1_HSPEED_SHIFT     21
#define SD4_EMMC_TOP_CAPABILITIES1_HSPEED_MASK      0x00200000
#define SD4_EMMC_TOP_CAPABILITIES1_ADMA2_SHIFT      19
#define SD4_EMMC_TOP_CAPABILITIES1_ADMA2_MASK       0x00080000
#define SD4_EMMC_TOP_CAPABILITIES1_EXTBUSMED_SHIFT  18
#define SD4_EMMC_TOP_CAPABILITIES1_EXTBUSMED_MASK   0x00040000
#define SD4_EMMC_TOP_CAPABILITIES1_MAXBLK_SHIFT     16
#define SD4_EMMC_TOP_CAPABILITIES1_MAXBLK_MASK      0x00030000
#define SD4_EMMC_TOP_CAPABILITIES1_BCLK_SHIFT       8
#define SD4_EMMC_TOP_CAPABILITIES1_BCLK_MASK        0x0000FF00
#define SD4_EMMC_TOP_CAPABILITIES1_TOUT_SHIFT       7
#define SD4_EMMC_TOP_CAPABILITIES1_TOUT_MASK        0x00000080
#define SD4_EMMC_TOP_CAPABILITIES1_TOUTFREQ_SHIFT   0
#define SD4_EMMC_TOP_CAPABILITIES1_TOUTFREQ_MASK    0x0000003F

#define SD4_EMMC_TOP_CAPABILITIES1_SD4_OFFSET           0x00000040
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_DEFAULT          0x10E934B4
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_TYPE             uint32_t
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_RESERVED_MASK    0x08100040
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SLOTTYPE_SHIFT   30
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SLOTTYPE_MASK    0xC0000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_ASYNCHIRQ_SHIFT  29
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_ASYNCHIRQ_MASK   0x20000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SYSBUS64_SHIFT   28
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SYSBUS64_MASK    0x10000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V18_SHIFT        26
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V18_MASK         0x04000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V3_SHIFT         25
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V3_MASK          0x02000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V33_SHIFT        24
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_V33_MASK         0x01000000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SUPRSM_SHIFT     23
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SUPRSM_MASK      0x00800000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SDMA_SHIFT       22
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_SDMA_MASK        0x00400000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_HSPEED_SHIFT     21
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_HSPEED_MASK      0x00200000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_ADMA2_SHIFT      19
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_ADMA2_MASK       0x00080000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_EXTBUSMED_SHIFT  18
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_EXTBUSMED_MASK   0x00040000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_MAXBLK_SHIFT     16
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_MAXBLK_MASK      0x00030000
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_BCLK_SHIFT       8
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_BCLK_MASK        0x0000FF00
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_TOUT_SHIFT       7
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_TOUT_MASK        0x00000080
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_TOUTFREQ_SHIFT   0
#define SD4_EMMC_TOP_CAPABILITIES1_SD4_TOUTFREQ_MASK    0x0000003F

#define SD4_EMMC_TOP_CAPABILITIES2_OFFSET               0x00000044
#define SD4_EMMC_TOP_CAPABILITIES2_DEFAULT              0x03002177
#define SD4_EMMC_TOP_CAPABILITIES2_TYPE                 uint32_t
#define SD4_EMMC_TOP_CAPABILITIES2_RESERVED_MASK        0xFC001088
#define SD4_EMMC_TOP_CAPABILITIES2_SPIBLOCKMODE_SHIFT   25
#define SD4_EMMC_TOP_CAPABILITIES2_SPIBLOCKMODE_MASK    0x02000000
#define SD4_EMMC_TOP_CAPABILITIES2_SPIMODE_CAP_SHIFT    24
#define SD4_EMMC_TOP_CAPABILITIES2_SPIMODE_CAP_MASK     0x01000000
#define SD4_EMMC_TOP_CAPABILITIES2_CLOCKMULT_SHIFT      16
#define SD4_EMMC_TOP_CAPABILITIES2_CLOCKMULT_MASK       0x00FF0000
#define SD4_EMMC_TOP_CAPABILITIES2_RETUNE_MODE_SHIFT    14
#define SD4_EMMC_TOP_CAPABILITIES2_RETUNE_MODE_MASK     0x0000C000
#define SD4_EMMC_TOP_CAPABILITIES2_USETUNE_SDR50_SHIFT  13
#define SD4_EMMC_TOP_CAPABILITIES2_USETUNE_SDR50_MASK   0x00002000
#define SD4_EMMC_TOP_CAPABILITIES2_TMRCNT_RETUNE_SHIFT  8
#define SD4_EMMC_TOP_CAPABILITIES2_TMRCNT_RETUNE_MASK   0x00000F00
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPED_SHIFT     6
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPED_MASK      0x00000040
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPEC_SHIFT     5
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPEC_MASK      0x00000020
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPEA_SHIFT     4
#define SD4_EMMC_TOP_CAPABILITIES2_DRVR_TYPEA_MASK      0x00000010
#define SD4_EMMC_TOP_CAPABILITIES2_DDR50_SHIFT          2
#define SD4_EMMC_TOP_CAPABILITIES2_DDR50_MASK           0x00000004
#define SD4_EMMC_TOP_CAPABILITIES2_SDR104_SHIFT         1
#define SD4_EMMC_TOP_CAPABILITIES2_SDR104_MASK          0x00000002
#define SD4_EMMC_TOP_CAPABILITIES2_SDR50_SHIFT          0
#define SD4_EMMC_TOP_CAPABILITIES2_SDR50_MASK           0x00000001

#define SD4_EMMC_TOP_CAPABILITIES2_SD4_OFFSET               0x00000044
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DEFAULT              0x10000064
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_TYPE                 uint32_t
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_RESERVED_MASK        0xE7001080
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_VDD2_18_SHIFT        28
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_VDD2_18_MASK         0x10000000
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_ADMA3_SHIFT          27
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_ADMA3_MASK           0x08000000
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_CLOCKMULT_SHIFT      16
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_CLOCKMULT_MASK       0x00FF0000
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_RETUNE_MODE_SHIFT    14
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_RETUNE_MODE_MASK     0x0000C000
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_USETUNE_SDR50_SHIFT  13
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_USETUNE_SDR50_MASK   0x00002000
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_TMRCNT_RETUNE_SHIFT  8
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_TMRCNT_RETUNE_MASK   0x00000F00
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPED_SHIFT     6
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPED_MASK      0x00000040
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPEC_SHIFT     5
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPEC_MASK      0x00000020
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPEA_SHIFT     4
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DRVR_TYPEA_MASK      0x00000010
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_UHS_II_SHIFT         3
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_UHS_II_MASK          0x00000008
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DDR50_SHIFT          2
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_DDR50_MASK           0x00000004
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_SDR104_SHIFT         1
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_SDR104_MASK          0x00000002
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_SDR50_SHIFT          0
#define SD4_EMMC_TOP_CAPABILITIES2_SD4_SDR50_MASK           0x00000001

#define SD4_EMMC_TOP_MAX_A1_OFFSET                  0x00000048
#define SD4_EMMC_TOP_MAX_A1_DEFAULT                 0x00000001
#define SD4_EMMC_TOP_MAX_A1_TYPE                    uint32_t
#define SD4_EMMC_TOP_MAX_A1_RESERVED_MASK           0xFF000000
#define SD4_EMMC_TOP_MAX_A1_MAXA18_SHIFT            16
#define SD4_EMMC_TOP_MAX_A1_MAXA18_MASK             0x00FF0000
#define SD4_EMMC_TOP_MAX_A1_MAXA30_SHIFT            8
#define SD4_EMMC_TOP_MAX_A1_MAXA30_MASK             0x0000FF00
#define SD4_EMMC_TOP_MAX_A1_MAXA33_SHIFT            0
#define SD4_EMMC_TOP_MAX_A1_MAXA33_MASK             0x000000FF

#define SD4_EMMC_TOP_MAX_A2_OFFSET                  0x0000004C
#define SD4_EMMC_TOP_MAX_A2_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_MAX_A2_TYPE                    uint32_t
#define SD4_EMMC_TOP_MAX_A2_RESERVED_MASK           0xFFFFFFFF

#define SD4_EMMC_TOP_MAX_A2_SD4_OFFSET              0x0000004C
#define SD4_EMMC_TOP_MAX_A2_SD4_DEFAULT             0x00000001
#define SD4_EMMC_TOP_MAX_A2_SD4_TYPE                uint32_t
#define SD4_EMMC_TOP_MAX_A2_SD4_RESERVED_MASK       0xFFFFFF00
#define SD4_EMMC_TOP_MAX_A2_SD4_MAXAVDD2_SHIFT      0
#define SD4_EMMC_TOP_MAX_A2_SD4_MAXAVDD2_MASK       0x000000FF

#define SD4_EMMC_TOP_CMDENTSTAT_OFFSET           0x00000050
#define SD4_EMMC_TOP_CMDENTSTAT_DEFAULT          0x00000000
#define SD4_EMMC_TOP_CMDENTSTAT_TYPE             uint32_t
#define SD4_EMMC_TOP_CMDENTSTAT_RESERVED_MASK    0x2C00FF60
#define SD4_EMMC_TOP_CMDENTSTAT_VSES_SHIFT       30
#define SD4_EMMC_TOP_CMDENTSTAT_VSES_MASK        0xC0000000
#define SD4_EMMC_TOP_CMDENTSTAT_TRERR_SHIFT      28
#define SD4_EMMC_TOP_CMDENTSTAT_TRERR_MASK       0x10000000
#define SD4_EMMC_TOP_CMDENTSTAT_ADMAERR_SHIFT    25
#define SD4_EMMC_TOP_CMDENTSTAT_ADMAERR_MASK     0x02000000
#define SD4_EMMC_TOP_CMDENTSTAT_ACMDERR_SHIFT    24
#define SD4_EMMC_TOP_CMDENTSTAT_ACMDERR_MASK     0x01000000
#define SD4_EMMC_TOP_CMDENTSTAT_ILERR_SHIFT      23
#define SD4_EMMC_TOP_CMDENTSTAT_ILERR_MASK       0x00800000
#define SD4_EMMC_TOP_CMDENTSTAT_DENDERR_SHIFT    22
#define SD4_EMMC_TOP_CMDENTSTAT_DENDERR_MASK     0x00400000
#define SD4_EMMC_TOP_CMDENTSTAT_DCRCERR_SHIFT    21
#define SD4_EMMC_TOP_CMDENTSTAT_DCRCERR_MASK     0x00200000
#define SD4_EMMC_TOP_CMDENTSTAT_DTOUTERR_SHIFT   20
#define SD4_EMMC_TOP_CMDENTSTAT_DTOUTERR_MASK    0x00100000
#define SD4_EMMC_TOP_CMDENTSTAT_CIDXERR_SHIFT    19
#define SD4_EMMC_TOP_CMDENTSTAT_CIDXERR_MASK     0x00080000
#define SD4_EMMC_TOP_CMDENTSTAT_CENDERR_SHIFT    18
#define SD4_EMMC_TOP_CMDENTSTAT_CENDERR_MASK     0x00040000
#define SD4_EMMC_TOP_CMDENTSTAT_CCRCERR_SHIFT    17
#define SD4_EMMC_TOP_CMDENTSTAT_CCRCERR_MASK     0x00020000
#define SD4_EMMC_TOP_CMDENTSTAT_CTOUTERR_SHIFT   16
#define SD4_EMMC_TOP_CMDENTSTAT_CTOUTERR_MASK    0x00010000
#define SD4_EMMC_TOP_CMDENTSTAT_NOFRCENT_SHIFT   7
#define SD4_EMMC_TOP_CMDENTSTAT_NOFRCENT_MASK    0x00000080
#define SD4_EMMC_TOP_CMDENTSTAT_IDXERR_SHIFT     4
#define SD4_EMMC_TOP_CMDENTSTAT_IDXERR_MASK      0x00000010
#define SD4_EMMC_TOP_CMDENTSTAT_EBITERR_SHIFT    3
#define SD4_EMMC_TOP_CMDENTSTAT_EBITERR_MASK     0x00000008
#define SD4_EMMC_TOP_CMDENTSTAT_CRCERR_SHIFT     2
#define SD4_EMMC_TOP_CMDENTSTAT_CRCERR_MASK      0x00000004
#define SD4_EMMC_TOP_CMDENTSTAT_TOUTERR_SHIFT    1
#define SD4_EMMC_TOP_CMDENTSTAT_TOUTERR_MASK     0x00000002
#define SD4_EMMC_TOP_CMDENTSTAT_AUTONOEX_SHIFT   0
#define SD4_EMMC_TOP_CMDENTSTAT_AUTONOEX_MASK    0x00000001

#define SD4_EMMC_TOP_CMDENTSTAT_SD4_OFFSET          0x00000050
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DEFAULT         0x00000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TYPE            uint32_t
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_RESERVED_MASK   0x0000FF40
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_VSES_SHIFT      28
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_VSES_MASK       0xF0000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TRESPERR_SHIFT  27
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TRESPERR_MASK   0x08000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TUNERR_SHIFT    26
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TUNERR_MASK     0x04000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ADMAERR_SHIFT   25
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ADMAERR_MASK    0x02000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ACMDERR_SHIFT   24
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ACMDERR_MASK    0x01000000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ILERR_SHIFT     23
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_ILERR_MASK      0x00800000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DENDERR_SHIFT   22
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DENDERR_MASK    0x00400000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DCRCERR_SHIFT   21
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DCRCERR_MASK    0x00200000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DTOUTERR_SHIFT  20
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_DTOUTERR_MASK   0x00100000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CIDXERR_SHIFT   19
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CIDXERR_MASK    0x00080000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CENDERR_SHIFT   18
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CENDERR_MASK    0x00040000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CCRCERR_SHIFT   17
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CCRCERR_MASK    0x00020000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CTOUTERR_SHIFT  16
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CTOUTERR_MASK   0x00010000
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_NOFRCENT_SHIFT  7
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_NOFRCENT_MASK   0x00000080
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_RESPERR_SHIFT   5
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_RESPERR_MASK    0x00000020
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_IDXERR_SHIFT    4
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_IDXERR_MASK     0x00000010
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_EBITERR_SHIFT   3
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_EBITERR_MASK    0x00000008
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CRCERR_SHIFT    2
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_CRCERR_MASK     0x00000004
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TOUTERR_SHIFT   1
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_TOUTERR_MASK    0x00000002
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_AUTONOEX_SHIFT  0
#define SD4_EMMC_TOP_CMDENTSTAT_SD4_AUTONOEX_MASK   0x00000001

#define SD4_EMMC_TOP_ADMAERR_OFFSET                 0x00000054
#define SD4_EMMC_TOP_ADMAERR_DEFAULT                0x00000000
#define SD4_EMMC_TOP_ADMAERR_TYPE                   uint32_t
#define SD4_EMMC_TOP_ADMAERR_RESERVED_MASK          0xFFFFFFF8
#define SD4_EMMC_TOP_ADMAERR_ADMALERR_SHIFT         2
#define SD4_EMMC_TOP_ADMAERR_ADMALERR_MASK          0x00000004
#define SD4_EMMC_TOP_ADMAERR_ADMAERR_SHIFT          0
#define SD4_EMMC_TOP_ADMAERR_ADMAERR_MASK           0x00000003

#define SD4_EMMC_TOP_ADMAADDR0_OFFSET               0x00000058
#define SD4_EMMC_TOP_ADMAADDR0_DEFAULT              0x00000000
#define SD4_EMMC_TOP_ADMAADDR0_TYPE                 uint32_t
#define SD4_EMMC_TOP_ADMAADDR0_RESERVED_MASK        0x00000000
#define SD4_EMMC_TOP_ADMAADDR0_ADMAADDR0_SHIFT      0
#define SD4_EMMC_TOP_ADMAADDR0_ADMAADDR0_MASK       0xFFFFFFFF

#define SD4_EMMC_TOP_ADMAADDR1_OFFSET                   0x0000005C
#define SD4_EMMC_TOP_ADMAADDR1_DEFAULT                  0x00000000
#define SD4_EMMC_TOP_ADMAADDR1_TYPE                     uint32_t
#define SD4_EMMC_TOP_ADMAADDR1_RESERVED_MASK            0x00000000
#define SD4_EMMC_TOP_ADMAADDR1_ADMAADDR1_SHIFT          0
#define SD4_EMMC_TOP_ADMAADDR1_ADMAADDR1_MASK           0xFFFFFFFF

#define SD4_EMMC_TOP_PRESETVAL1_OFFSET                  0x00000060
#define SD4_EMMC_TOP_PRESETVAL1_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_PRESETVAL1_TYPE                    uint32_t
#define SD4_EMMC_TOP_PRESETVAL1_RESERVED_MASK           0x38003800
#define SD4_EMMC_TOP_PRESETVAL1_DRVS_SEL_DFS_SHIFT      30
#define SD4_EMMC_TOP_PRESETVAL1_DRVS_SEL_DFS_MASK       0xC0000000
#define SD4_EMMC_TOP_PRESETVAL1_CLKGENSEL_DFS_SHIFT     26
#define SD4_EMMC_TOP_PRESETVAL1_CLKGENSEL_DFS_MASK      0x04000000
#define SD4_EMMC_TOP_PRESETVAL1_FREQ_SEL_DFS_SHIFT      16
#define SD4_EMMC_TOP_PRESETVAL1_FREQ_SEL_DFS_MASK       0x03FF0000
#define SD4_EMMC_TOP_PRESETVAL1_DRVS_SEL_INIT_SHIFT     14
#define SD4_EMMC_TOP_PRESETVAL1_DRVS_SEL_INIT_MASK      0x0000C000
#define SD4_EMMC_TOP_PRESETVAL1_CLKGENSEL_INIT_SHIFT    10
#define SD4_EMMC_TOP_PRESETVAL1_CLKGENSEL_INIT_MASK     0x00000400
#define SD4_EMMC_TOP_PRESETVAL1_FREQ_SEL_INIT_SHIFT     0
#define SD4_EMMC_TOP_PRESETVAL1_FREQ_SEL_INIT_MASK      0x000003FF

#define SD4_EMMC_TOP_PRESETVAL2_OFFSET                  0x00000064
#define SD4_EMMC_TOP_PRESETVAL2_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_PRESETVAL2_TYPE                    uint32_t
#define SD4_EMMC_TOP_PRESETVAL2_RESERVED_MASK           0x38003800
#define SD4_EMMC_TOP_PRESETVAL2_DRVS_SEL_SDR12_SHIFT    30
#define SD4_EMMC_TOP_PRESETVAL2_DRVS_SEL_SDR12_MASK     0xC0000000
#define SD4_EMMC_TOP_PRESETVAL2_CLKGENSEL_SDR12_SHIFT   26
#define SD4_EMMC_TOP_PRESETVAL2_CLKGENSEL_SDR12_MASK    0x04000000
#define SD4_EMMC_TOP_PRESETVAL2_FREQ_SEL_SDR12_SHIFT    16
#define SD4_EMMC_TOP_PRESETVAL2_FREQ_SEL_SDR12_MASK     0x03FF0000
#define SD4_EMMC_TOP_PRESETVAL2_DRVS_SEL_HS_SHIFT       14
#define SD4_EMMC_TOP_PRESETVAL2_DRVS_SEL_HS_MASK        0x0000C000
#define SD4_EMMC_TOP_PRESETVAL2_CLKGENSEL_HS_SHIFT      10
#define SD4_EMMC_TOP_PRESETVAL2_CLKGENSEL_HS_MASK       0x00000400
#define SD4_EMMC_TOP_PRESETVAL2_FREQ_SEL_HS_SHIFT       0
#define SD4_EMMC_TOP_PRESETVAL2_FREQ_SEL_HS_MASK        0x000003FF

#define SD4_EMMC_TOP_PRESETVAL3_OFFSET                  0x00000068
#define SD4_EMMC_TOP_PRESETVAL3_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_PRESETVAL3_TYPE                    uint32_t
#define SD4_EMMC_TOP_PRESETVAL3_RESERVED_MASK           0x38003800
#define SD4_EMMC_TOP_PRESETVAL3_DRVS_SEL_SDR50_SHIFT    30
#define SD4_EMMC_TOP_PRESETVAL3_DRVS_SEL_SDR50_MASK     0xC0000000
#define SD4_EMMC_TOP_PRESETVAL3_CLKGENSEL_SDR50_SHIFT   26
#define SD4_EMMC_TOP_PRESETVAL3_CLKGENSEL_SDR50_MASK    0x04000000
#define SD4_EMMC_TOP_PRESETVAL3_FREQ_SEL_SDR50_SHIFT    16
#define SD4_EMMC_TOP_PRESETVAL3_FREQ_SEL_SDR50_MASK     0x03FF0000
#define SD4_EMMC_TOP_PRESETVAL3_DRVS_SEL_SDR25_SHIFT    14
#define SD4_EMMC_TOP_PRESETVAL3_DRVS_SEL_SDR25_MASK     0x0000C000
#define SD4_EMMC_TOP_PRESETVAL3_CLKGENSEL_SDR25_SHIFT   10
#define SD4_EMMC_TOP_PRESETVAL3_CLKGENSEL_SDR25_MASK    0x00000400
#define SD4_EMMC_TOP_PRESETVAL3_FREQ_SEL_SDR25_SHIFT    0
#define SD4_EMMC_TOP_PRESETVAL3_FREQ_SEL_SDR25_MASK     0x000003FF

#define SD4_EMMC_TOP_PRESETVAL4_OFFSET                  0x0000006C
#define SD4_EMMC_TOP_PRESETVAL4_DEFAULT                 0x00000000
#define SD4_EMMC_TOP_PRESETVAL4_TYPE                    uint32_t
#define SD4_EMMC_TOP_PRESETVAL4_RESERVED_MASK           0x38003800
#define SD4_EMMC_TOP_PRESETVAL4_DRVS_SEL_DDR50_SHIFT    30
#define SD4_EMMC_TOP_PRESETVAL4_DRVS_SEL_DDR50_MASK     0xC0000000
#define SD4_EMMC_TOP_PRESETVAL4_CLKGENSEL_DDR50_SHIFT   26
#define SD4_EMMC_TOP_PRESETVAL4_CLKGENSEL_DDR50_MASK    0x04000000
#define SD4_EMMC_TOP_PRESETVAL4_FREQ_SEL_DDR50_SHIFT    16
#define SD4_EMMC_TOP_PRESETVAL4_FREQ_SEL_DDR50_MASK     0x03FF0000
#define SD4_EMMC_TOP_PRESETVAL4_DRVS_SEL_SDR104_SHIFT   14
#define SD4_EMMC_TOP_PRESETVAL4_DRVS_SEL_SDR104_MASK    0x0000C000
#define SD4_EMMC_TOP_PRESETVAL4_CLKGENSEL_SDR104_SHIFT  10
#define SD4_EMMC_TOP_PRESETVAL4_CLKGENSEL_SDR104_MASK   0x00000400
#define SD4_EMMC_TOP_PRESETVAL4_FREQ_SEL_SDR104_SHIFT   0
#define SD4_EMMC_TOP_PRESETVAL4_FREQ_SEL_SDR104_MASK    0x000003FF

#define SD4_EMMC_TOP_BOOTTIMEOUT_OFFSET                        0x00000070
#define SD4_EMMC_TOP_BOOTTIMEOUT_DEFAULT                       0x00000000
#define SD4_EMMC_TOP_BOOTTIMEOUT_TYPE                          uint32_t
#define SD4_EMMC_TOP_BOOTTIMEOUT_RESERVED_MASK                 0x00000000
#define SD4_EMMC_TOP_BOOTTIMEOUT_BOOTDATATIMEOUTCTRVALUE_SHIFT 0
#define SD4_EMMC_TOP_BOOTTIMEOUT_BOOTDATATIMEOUTCTRVALUE_MASK  0xFFFFFFFF

#define SD4_EMMC_TOP_DBGSEL_OFFSET         0x00000074
#define SD4_EMMC_TOP_DBGSEL_DEFAULT        0x00000000
#define SD4_EMMC_TOP_DBGSEL_TYPE           uint32_t
#define SD4_EMMC_TOP_DBGSEL_RESERVED_MASK  0xFFFFFFFE
#define SD4_EMMC_TOP_DBGSEL_DBGSEL_SHIFT   0
#define SD4_EMMC_TOP_DBGSEL_DBGSEL_MASK    0x00000001

#define SD4_EMMC_TOP_UHS2_PRESETVAL_OFFSET                 0x00000074
#define SD4_EMMC_TOP_UHS2_PRESETVAL_DEFAULT                0x00000000
#define SD4_EMMC_TOP_UHS2_PRESETVAL_TYPE                   uint32_t
#define SD4_EMMC_TOP_UHS2_PRESETVAL_RESERVED_MASK          0xFFFF3800
#define SD4_EMMC_TOP_UHS2_PRESETVAL_DRVSTRVAL_SHIFT        14
#define SD4_EMMC_TOP_UHS2_PRESETVAL_DRVSTRVAL_MASK         0x0000C000
#define SD4_EMMC_TOP_UHS2_PRESETVAL_CLKGENSELVAL_SHIFT     10
#define SD4_EMMC_TOP_UHS2_PRESETVAL_CLKGENSELVAL_MASK      0x00000400
#define SD4_EMMC_TOP_UHS2_PRESETVAL_SDCLKFREQSELVAL_SHIFT  0
#define SD4_EMMC_TOP_UHS2_PRESETVAL_SDCLKFREQSELVAL_MASK   0x000003FF

#define SD4_EMMC_TOP_HCVERSIRQ_OFFSET            0x000000FC
#define SD4_EMMC_TOP_HCVERSIRQ_DEFAULT           0x10020000
#define SD4_EMMC_TOP_HCVERSIRQ_TYPE              uint32_t
#define SD4_EMMC_TOP_HCVERSIRQ_RESERVED_MASK     0x0000FF00
#define SD4_EMMC_TOP_HCVERSIRQ_VENDVER_SHIFT     24
#define SD4_EMMC_TOP_HCVERSIRQ_VENDVER_MASK      0xFF000000
#define SD4_EMMC_TOP_HCVERSIRQ_SPECVER_SHIFT     16
#define SD4_EMMC_TOP_HCVERSIRQ_SPECVER_MASK      0x00FF0000
#define SD4_EMMC_TOP_HCVERSIRQ_SIRQ_SHIFT        0
#define SD4_EMMC_TOP_HCVERSIRQ_SIRQ_MASK         0x000000FF

#define SD4_EMMC_TOP_HCVERSIRQ_SD4_OFFSET        0x000000FC
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_DEFAULT       0x01030000
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_TYPE          uint32_t
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_RESERVED_MASK 0x0000FF00
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_VENDVER_SHIFT 24
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_VENDVER_MASK  0xFF000000
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_SPECVER_SHIFT 16
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_SPECVER_MASK  0x00FF0000
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_SIRQ_SHIFT    0
#define SD4_EMMC_TOP_HCVERSIRQ_SD4_SIRQ_MASK     0x000000FF

#endif /* BRCM_RDB_SD4_EMMC_TOP_H */
