/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class Sample {
    public static final String ASPECTJ_TEAM = "The AspectJ Team";
    static Comparator NAME_SOURCE_COMPARER = new Comparator(){

        public int compare(Object lhs, Object rhs) {
            Sample left = (Sample)lhs;
            Sample right = (Sample)rhs;
            if (null == left) {
                return null == right ? 0 : -1;
            }
            if (null == right) {
                return 1;
            }
            int result = left.anchorName.compareTo(right.anchorName);
            if (0 != result) {
                return result;
            }
            result = left.sourcePath.compareTo(right.sourcePath);
            if (0 != result) {
                return result;
            }
            result = right.startLine - left.startLine;
            if (0 != result) {
                return result;
            }
            return right.endLine - left.endLine;
        }
    };
    static Comparator AUTHOR_NAME_SOURCE_COMPARER = new Comparator(){

        public int compare(Object lhs, Object rhs) {
            Sample left = (Sample)lhs;
            Sample right = (Sample)rhs;
            if (null == left) {
                return null == right ? 0 : -1;
            }
            if (null == right) {
                return 1;
            }
            int result = left.author.compareTo(right.author);
            if (0 != result) {
                return result;
            }
            return NAME_SOURCE_COMPARER.compare(lhs, rhs);
        }
    };
    final String anchorName;
    final String anchorTitle;
    final String author;
    final String sampleCode;
    final File sourcePath;
    final int startLine;
    final int endLine;
    final Kind kind;
    final List flags;

    public Sample(String anchorName, String anchorTitle, String author, String sampleCode, File sourcePath, int startLine, int endLine, String[] flags) {
        this.anchorName = anchorName;
        this.anchorTitle = anchorTitle;
        this.author = null != author ? author : ASPECTJ_TEAM;
        this.sampleCode = sampleCode;
        this.sourcePath = sourcePath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.kind = Kind.getKind(sourcePath);
        this.flags = null == flags || 0 == flags.length ? Collections.EMPTY_LIST : Collections.unmodifiableList(Arrays.asList(flags));
    }

    public String toString() {
        return this.sampleCode;
    }

    public static class Kind {
        public static final String[] SOURCE_SUFFIXES = new String[]{".java", ".aj", ".sh", ".ksh", ".txt", ".text", ".html", ".htm", ".xml"};
        static final Kind XML = new Kind();
        static final Kind HTML = new Kind();
        static final Kind PROGRAM = new Kind();
        static final Kind SCRIPT = new Kind();
        static final Kind TEXT = new Kind();
        static final Kind OTHER = new Kind();

        public static Kind getKind(File file) {
            if (null == file) {
                return OTHER;
            }
            String name = file.getName().toLowerCase();
            if (name.endsWith(".java") || name.endsWith(".aj")) {
                return PROGRAM;
            }
            if (name.endsWith(".html") || name.endsWith(".htm")) {
                return HTML;
            }
            if (name.endsWith(".sh") || name.endsWith(".ksh")) {
                return SCRIPT;
            }
            if (name.endsWith(".txt") || name.endsWith(".text")) {
                return TEXT;
            }
            if (name.endsWith(".xml")) {
                return XML;
            }
            return OTHER;
        }

        private Kind() {
        }
    }
}

