#ifndef SESSION_H__
#define SESSION_H__

#include <dcpp/stdinc.h>
#include <dcpp/DCPlusPlus.h>
#include <dcpp/User.h>
#include <dcpp/Client.h>
#include <dcpp/SearchManagerListener.h>
#include <dcpp/TimerManager.h>

#include <ext/hash_map>
#include <ext/hash_set>
#include <vector>

namespace dcqt_backend {

class Session : public ClientListener, public SearchManagerListener, TimerManagerListener
{
public:

  // Constructors
  Session(int aId,Client* aClient,string aUrl);
  ~Session();

  // Getters and setters
  int getId() const {return id;}
  string& getHubName() {return hubName;}
  hash_set<int>* getUsers() {return &userIdSet;}
  Client* getClient() {return client;}
  string& getUrl() {return url;}

  // Actions
  void connect();
  void sendChat(const string& msg);
  void search(int sizeMode, int64_t size, int type, const string& searchString, const string& token);
  void password(const string& p) {client->password(p);}

  // Callbacks
  void on(ClientListener::Connecting, Client *client) throw();
  void on(ClientListener::Connected, Client *client) throw();
  void on(ClientListener::BadPassword, Client *client) throw();
  void on(ClientListener::UserUpdated, Client *client, 
	  const ::User::Ptr&) throw();
  void on(ClientListener::UsersUpdated, 
	  Client *client, const ::User::List &list) throw();
  void on(ClientListener::UserRemoved, 
	  Client *client, const ::User::Ptr &user) throw();
  void on(ClientListener::Redirect, 
	  Client *client, const string &address) throw();
  void on(ClientListener::Failed, 
	  Client *client, const string &reason) throw();
  void on(ClientListener::GetPassword, Client *client) throw();
  void on(ClientListener::HubUpdated, Client *client) throw();
  void on(ClientListener::Message, 
	  Client *client, const string &msg) throw();
  void on(ClientListener::PrivateMessage, 
	  Client *client, const ::User::Ptr &user, const string &msg) throw();
  void on(ClientListener::UserCommand, Client *client, 
	  int, int, const string&, const string&) throw();
  void on(ClientListener::HubFull, Client *client) throw();
  void on(ClientListener::NickTaken, Client *client) throw();
  void on(ClientListener::SearchFlood, Client *client, 
	  const string &msg) throw();
  void on(ClientListener::NmdcSearch, Client *client, const string&, 
	  int, int64_t, int, const string&) throw();

  // Implement SearchManagerListener interface
  void on(SearchManagerListener::SR, SearchResult*) throw();

  void on(TimerManagerListener::Second, u_int32_t) throw();

private:
  void updateUser(const ::User::Ptr&);
  
  int id;
  Client* client;
  string hubName;
  string url;

  //! So that we know which user id's belong to this session.
  hash_set<int> userIdSet;
  //! This one caches updated users before they are sent to the client.
  vector<int> userUpdateCache;

  //! Caches search result before they are sent to the client.
  vector<SearchResult*> searchResultCache;
  CriticalSection searchCS;
};

}
#endif
