#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "source_section.hpp"

source_section::source_section(package_name const &name) : name(name), cross_compiling(false) { }

source_section::attribute
source_section::operator[](attribute_selector_type const &key)
{
	if(key == "Section")
		return attribute(&source_section::section, *this);
	if(key == "Priority")
		return attribute(&source_section::priority, *this);
	if(key == "Maintainer")
		return attribute(&source_section::maintainer, *this);
	if(key == "Build-Depends")
		return attribute(&source_section::build_depends, *this);
	if(key == "Build-Depends-Indep")
		return attribute(&source_section::build_depends_indep, *this);
	if(key == "Build-Depends-Tools")
		return attribute(&source_section::build_depends_tools, *this);
	if(key == "Standards-Version")
		return attribute(&source_section::standards_version, *this);
	if(key == "Cross-Compiling")
		return attribute(&source_section::cross_compiling, *this);
	throw attribute::unknown_attribute(key);
}

bool source_section::operator==(source_section const &rhs) const
{
	if(name != rhs.name)
		return false;
	if(section != rhs.section)
		return false;
	if(maintainer != rhs.maintainer)
		return false;
	if(build_depends != rhs.build_depends)
		return false;
	if(build_depends_indep != rhs.build_depends_indep)
		return false;
	if(build_depends_tools != rhs.build_depends_tools)
		return false;
	if(standards_version != rhs.standards_version)
		return false;
	if(cross_compiling != rhs.cross_compiling)
		return false;
	return true;
}

control_file_ostream &operator<<(control_file_ostream &stream, source_section const &source)
{
	stream << std::make_pair("Source", source.name);
	if(!source.section.empty())
		stream << std::make_pair("Section", source.section);
	if(!source.priority.empty())
		stream << std::make_pair("Priority", source.priority);
	if(!source.maintainer.empty())
		stream << std::make_pair("Maintainer", source.maintainer);
	if(!source.build_depends.empty())
		stream << std::make_pair("Build-Depends", source.build_depends);
	if(source.cross_compiling)
		stream << std::make_pair("Cross-Compiling", source.cross_compiling);
	if(!source.build_depends_indep.empty())
		stream << std::make_pair("Build-Depends-Indep", source.build_depends_indep);
	if(!source.build_depends_tools.empty())
		stream << std::make_pair("Build-Depends-Tools", source.build_depends_tools);
	if(!source.standards_version.empty())
		stream << std::make_pair("Standards-Version", source.standards_version);
	return stream;
}
