# Authors:
#     Fraser Tweedale <ftweedal@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2016 Red Hat, Inc.
# All rights reserved.

from __future__ import absolute_import
import os.path
import pki.server.upgrade


class AllowEncodedSlash(pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(AllowEncodedSlash, self).__init__()
        self.message = 'Enable Tomcat ALLOW_ENCODED_SLASH parameter'

    def upgrade_instance(self, instance):
        path = os.path.join(instance.base_dir, 'conf', 'catalina.properties')
        if os.path.isfile(path):
            with open(path, 'a+') as f:
                data = f.read()
                if 'ALLOW_ENCODED_SLASH=' not in data:
                    f.write('\norg.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH=true\n')
