//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QPIXMAP_C_H
#define QPIXMAP_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT QPixmapH QPixmap_create();
C_EXPORT void QPixmap_destroy(QPixmapH handle);
C_EXPORT QPixmapH QPixmap_create2(int w, int h);
C_EXPORT QPixmapH QPixmap_create3(const QSizeH AnonParam1);
C_EXPORT QPixmapH QPixmap_create4(PWideString fileName, const char* format, unsigned int flags);
C_EXPORT QPixmapH QPixmap_create5(const char* const xpm);
C_EXPORT QPixmapH QPixmap_create6(const QPixmapH AnonParam1);
C_EXPORT bool QPixmap_isNull(QPixmapH handle);
C_EXPORT int QPixmap_devType(QPixmapH handle);
C_EXPORT int QPixmap_width(QPixmapH handle);
C_EXPORT int QPixmap_height(QPixmapH handle);
C_EXPORT void QPixmap_size(QPixmapH handle, PSize retval);
C_EXPORT void QPixmap_rect(QPixmapH handle, PRect retval);
C_EXPORT int QPixmap_depth(QPixmapH handle);
C_EXPORT int QPixmap_defaultDepth();
C_EXPORT void QPixmap_fill(QPixmapH handle, const QColorH fillColor);
C_EXPORT void QPixmap_fill2(QPixmapH handle, const QWidgetH widget, const QPointH ofs);
C_EXPORT void QPixmap_fill3(QPixmapH handle, const QWidgetH widget, int xofs, int yofs);
C_EXPORT void QPixmap_mask(QPixmapH handle, QBitmapH retval);
C_EXPORT void QPixmap_setMask(QPixmapH handle, const QBitmapH AnonParam1);
C_EXPORT void QPixmap_alphaChannel(QPixmapH handle, QPixmapH retval);
C_EXPORT void QPixmap_setAlphaChannel(QPixmapH handle, const QPixmapH AnonParam1);
C_EXPORT bool QPixmap_hasAlpha(QPixmapH handle);
C_EXPORT bool QPixmap_hasAlphaChannel(QPixmapH handle);
C_EXPORT void QPixmap_createHeuristicMask(QPixmapH handle, QBitmapH retval, bool clipTight);
C_EXPORT void QPixmap_createMaskFromColor(QPixmapH handle, QBitmapH retval, const QColorH maskColor);
C_EXPORT void QPixmap_createMaskFromColor2(QPixmapH handle, QBitmapH retval, const QColorH maskColor, Qt::MaskMode mode);
C_EXPORT void QPixmap_grabWindow(QPixmapH retval, unsigned int AnonParam1, int x, int y, int w, int h);
C_EXPORT void QPixmap_grabWidget(QPixmapH retval, QWidgetH widget, PRect rect);
C_EXPORT void QPixmap_grabWidget2(QPixmapH retval, QWidgetH widget, int x, int y, int w, int h);
C_EXPORT void QPixmap_scaled(QPixmapH handle, QPixmapH retval, int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode);
C_EXPORT void QPixmap_scaled2(QPixmapH handle, QPixmapH retval, const QSizeH s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode);
C_EXPORT void QPixmap_scaledToWidth(QPixmapH handle, QPixmapH retval, int w, Qt::TransformationMode mode);
C_EXPORT void QPixmap_scaledToHeight(QPixmapH handle, QPixmapH retval, int h, Qt::TransformationMode mode);
C_EXPORT void QPixmap_transformed(QPixmapH handle, QPixmapH retval, const QMatrixH AnonParam1, Qt::TransformationMode mode);
C_EXPORT void QPixmap_trueMatrix(QMatrixH retval, const QMatrixH m, int w, int h);
C_EXPORT void QPixmap_transformed2(QPixmapH handle, QPixmapH retval, const QTransformH AnonParam1, Qt::TransformationMode mode);
C_EXPORT void QPixmap_trueMatrix2(QTransformH retval, const QTransformH m, int w, int h);
C_EXPORT void QPixmap_toImage(QPixmapH handle, QImageH retval);
C_EXPORT void QPixmap_fromImage(QPixmapH retval, const QImageH image, unsigned int flags);
C_EXPORT bool QPixmap_load(QPixmapH handle, PWideString fileName, const char* format, unsigned int flags);
C_EXPORT bool QPixmap_loadFromData(QPixmapH handle, const uchar* buf, uint len, const char* format, unsigned int flags);
C_EXPORT bool QPixmap_loadFromData2(QPixmapH handle, const QByteArrayH data, const char* format, unsigned int flags);
C_EXPORT bool QPixmap_save(QPixmapH handle, PWideString fileName, const char* format, int quality);
C_EXPORT bool QPixmap_save2(QPixmapH handle, QIODeviceH device, const char* format, int quality);
C_EXPORT void QPixmap_copy(QPixmapH handle, QPixmapH retval, int x, int y, int width, int height);
C_EXPORT void QPixmap_copy2(QPixmapH handle, QPixmapH retval, PRect rect);
C_EXPORT int QPixmap_serialNumber(QPixmapH handle);
C_EXPORT qint64 QPixmap_cacheKey(QPixmapH handle);
C_EXPORT bool QPixmap_isDetached(QPixmapH handle);
C_EXPORT void QPixmap_detach(QPixmapH handle);
C_EXPORT bool QPixmap_isQBitmap(QPixmapH handle);
#if defined BINUX
C_EXPORT void QPixmap_fromX11Pixmap(QPixmapH retval, Qt::HANDLE pixmap, QPixmap::ShareMode mode);
C_EXPORT int QPixmap_x11SetDefaultScreen(int screen);
C_EXPORT void QPixmap_x11SetScreen(QPixmapH handle, int screen);
C_EXPORT const QX11InfoH QPixmap_x11Info(QPixmapH handle);
C_EXPORT Qt::HANDLE QPixmap_x11PictureHandle(QPixmapH handle);
#endif
#if defined BINUX || QTOPIA
C_EXPORT Qt::HANDLE QPixmap_handle(QPixmapH handle);
#endif
C_EXPORT QPaintEngineH QPixmap_paintEngine(QPixmapH handle);
#if defined MSWINDOWS
C_EXPORT HBITMAP QPixmap_toWinHBITMAP(QPixmapH handle, QPixmap::HBitmapFormat format);
C_EXPORT void QPixmap_fromWinHBITMAP(QPixmapH retval, HBITMAP hbitmap, QPixmap::HBitmapFormat format);
#endif
#if defined DARWIN
C_EXPORT CGImageRef QPixmap_toMacCGImageRef(QPixmapH handle);
C_EXPORT void QPixmap_fromMacCGImageRef(QPixmapH retval, CGImageRef image);
C_EXPORT Qt::HANDLE QPixmap_macQDHandle(QPixmapH handle);
C_EXPORT Qt::HANDLE QPixmap_macQDAlphaHandle(QPixmapH handle);
C_EXPORT Qt::HANDLE QPixmap_macCGHandle(QPixmapH handle);
#endif
#if defined QTOPIA
C_EXPORT const uchar* QPixmap_qwsBits(QPixmapH handle);
C_EXPORT int QPixmap_qwsBytesPerLine(QPixmapH handle);
C_EXPORT QRgb * QPixmap_clut(QPixmapH handle);
C_EXPORT int QPixmap_numCols(QPixmapH handle);
#endif

#endif
