.TH "ZIP_FILE_SET_EXTERNAL_ATTRIBUTES" "3" "September 19, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_set_external_attributes\fP
\- set external attributes for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
const char *
zip_file_set_external_attributes zip_t *archive zip_uint64_t index zip_flags_t flags zip_uint8_t opsys zip_uint32_t attributes
.SH "DESCRIPTION"
The
zip_file_set_external_attributes
function sets the operating system and external attributes for the
file at position
\fIindex\fP
in the zip archive.
Currently, no
\fIflags\fP
are supported.
.PP
For a list of known
\fIopsys\fP
values, see
zip_file_get_external_attributes(3).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_file_set_external_attributes
fails if:
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.TP 17n
[\fRZIP_ER_RDONLY\fP]
The
\fIarchive\fP
was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_file_get_external_attributes(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
