// license:GPL-2.0+
// copyright-holders:Ryan Holtz
/*
 * nld_7442.h
 *
 *  SN7442: 4-Line BCD to 10-Line Decimal Decoder
 *
 *          +--------------+
 *        0 |1     ++    16| VCC
 *        1 |2           15| A
 *        2 |3           14| B
 *        3 |4           13| C
 *        4 |5    7442   12| D
 *        5 |6           11| 9
 *        6 |7           10| 8
 *      GND |8            9| 7
 *          +--------------+
 *
 *          Truth Table
 *
 *          +------++---+---+---+---++---+---+---+---+---+---+---+---+---+---+
 *          | Num. || D | C | B | A || 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 |
 *          +======++===+===+===+===++===+===+===+===+===+===+===+===+===+===+
 *          |   0  || 0 | 0 | 0 | 0 || 0 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   1  || 0 | 0 | 0 | 1 || 1 | 0 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   2  || 0 | 0 | 1 | 0 || 1 | 1 | 0 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   3  || 0 | 0 | 1 | 1 || 1 | 1 | 1 | 0 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   4  || 0 | 1 | 0 | 0 || 1 | 1 | 1 | 1 | 0 | 1 | 1 | 1 | 1 | 1 |
 *          |   5  || 0 | 1 | 0 | 1 || 1 | 1 | 1 | 1 | 1 | 0 | 1 | 1 | 1 | 1 |
 *          |   6  || 0 | 1 | 1 | 0 || 1 | 1 | 1 | 1 | 1 | 1 | 0 | 1 | 1 | 1 |
 *          |   7  || 0 | 1 | 1 | 1 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 0 | 1 | 1 |
 *          |   8  || 1 | 0 | 0 | 0 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 0 | 1 |
 *          |   9  || 1 | 0 | 0 | 1 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 0 |
 *          |   -  || 1 | 0 | 1 | 0 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   -  || 1 | 0 | 1 | 1 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   -  || 1 | 1 | 0 | 0 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   -  || 1 | 1 | 0 | 1 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   -  || 1 | 1 | 1 | 0 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          |   -  || 1 | 1 | 1 | 1 || 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
 *          +------++---+---+---+---++---+---+---+---+---+---+---+---+---+---+
 *
 *  Naming conventions follow Texas Instruments datasheet
 *
 */

#ifndef NLD_7442_H_
#define NLD_7442_H_

#include "netlist/nl_setup.h"

#define TTL_7442(name, cA, cB, cC, cD)                          \
		NET_REGISTER_DEV(TTL_7442, name)                        \
		NET_CONNECT(name, GND, GND)                             \
		NET_CONNECT(name, VCC, VCC)                             \
		NET_CONNECT(name, A, cA)                                \
		NET_CONNECT(name, B, cB)                                \
		NET_CONNECT(name, C, cC)                                \
		NET_CONNECT(name, D, cD)

#define TTL_7442_DIP(name)                                      \
		NET_REGISTER_DEV(TTL_7442_DIP, name)

#endif /* NLD_7442_H_ */
