C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5HQ (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5HQ                                          C       PARAMETER (ISET=5) 
        DATA  DrI, FlI, AlI /   2.,   5.,  .2260 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .167097E+01, .222659E+01, .309171E+01,
     +  .450000E+01, .754288E+01, .138228E+02, .281243E+02, .646894E+02,
     +  .171811E+03, .540159E+03, .206963E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                 
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .234059E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .117451E+06, .895519E+05,
     +  .671915E+05, .503699E+05, .377355E+05, .282423E+05,
     +  .211226E+05, .157812E+05, .117816E+05, .878584E+04,
     +  .654646E+04, .487203E+04, .362267E+04, .269023E+04,
     +  .199587E+04, .147869E+04, .109439E+04, .808762E+03,
     +  .597011E+03, .439999E+03, .323897E+03, .238028E+03,
     +  .174699E+03, .127992E+03, .936410E+02, .683906E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .498962E+02, .361693E+02, .263051E+02, .190962E+02,
     +  .138498E+02, .100291E+02, .725724E+01, .525086E+01,
     +  .379663E+01, .274449E+01, .198629E+01, .143847E+01,
     +  .104413E+01, .759140E+00, .554077E+00, .405514E+00,
     +  .298033E+00, .219814E+00, .162932E+00, .121217E+00,
     +  .907422E-01, .680229E-01, .513528E-01, .388026E-01,
     +  .294684E-01, .224246E-01, .171201E-01, .130869E-01,
     +  .100264E-01, .768093E-02, .588823E-02, .450835E-02,
     +  .345149E-02, .263499E-02, .200834E-02, .152416E-02,
     +  .115242E-02, .867526E-03, .647820E-03, .479083E-03,
     +  .350817E-03, .253349E-03, .180179E-03, .125337E-03,
     +  .849339E-04, .553291E-04, .340971E-04, .191196E-04,
     +  .906066E-05, .239696E-05, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .272089E+06, .206804E+06, .154596E+06,
     +  .115465E+06, .861781E+05, .642554E+05, .478732E+05,
     +  .356298E+05, .264958E+05, .196809E+05, .146059E+05,
     +  .108264E+05, .801711E+04, .592903E+04, .438025E+04,
     +  .323147E+04, .238130E+04, .175213E+04, .128763E+04,
     +  .944722E+03, .692243E+03, .506359E+03, .369872E+03,
     +  .269679E+03, .196330E+03, .142669E+03, .103551E+03,
     +  .746651E+02, .540102E+02, .389954E+02, .281226E+02,
     +  .202483E+02, .145655E+02, .104757E+02, .752738E+01,
     +  .540713E+01, .388781E+01, .279702E+01, .201644E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .145603E+01, .105522E+01, .766806E+00, .559470E+00,
     +  .409637E+00, .301377E+00, .222549E+00, .165341E+00,
     +  .123012E+00, .921520E-01, .690989E-01, .520700E-01,
     +  .393200E-01, .297851E-01, .225925E-01, .171736E-01,
     +  .130546E-01, .993060E-02, .754637E-02, .573445E-02,
     +  .434707E-02, .329109E-02, .248260E-02, .186728E-02,
     +  .139991E-02, .104280E-02, .771129E-03, .566455E-03,
     +  .412252E-03, .297352E-03, .211781E-03, .148986E-03,
     +  .103006E-03, .698541E-04, .461866E-04, .298503E-04,
     +  .185053E-04, .109490E-04, .603558E-05, .299672E-05,
     +  .120439E-05, .249737E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .471921E+06, .357527E+06, .266254E+06, .198104E+06,
     +  .147286E+06, .109393E+06, .811821E+05, .601813E+05,
     +  .445738E+05, .329757E+05, .243722E+05, .179909E+05,
     +  .132668E+05, .977003E+04, .718690E+04, .527910E+04,
     +  .387307E+04, .283710E+04, .207551E+04, .151583E+04,
     +  .110553E+04, .804856E+03, .585074E+03, .424504E+03,
     +  .307502E+03, .222319E+03, .160521E+03, .115124E+03,
     +  .828253E+02, .594720E+02, .426469E+02, .305296E+02,
     +  .218311E+02, .156071E+02, .111449E+02, .795529E+01,
     +  .568274E+01, .406150E+01, .290821E+01, .208565E+01,
     +  .150093E+01, .108301E+01, .784491E+00, .570267E+00,
     +  .416475E+00, .305290E+00, .225127E+00, .166257E+00,
     +  .123609E+00, .919941E-01, .687978E-01, .515633E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .387625E-01, .291806E-01, .220114E-01, .166053E-01,
     +  .125352E-01, .945408E-02, .712956E-02, .536474E-02,
     +  .403164E-02, .301982E-02, .225580E-02, .168036E-02,
     +  .124433E-02, .915630E-03, .670052E-03, .486645E-03,
     +  .351042E-03, .250859E-03, .177805E-03, .124618E-03,
     +  .863890E-04, .591214E-04, .401876E-04, .268919E-04,
     +  .178220E-04, .116834E-04, .761286E-05, .492806E-05,
     +  .319212E-05, .206504E-05, .133259E-05, .850435E-06,
     +  .528225E-06, .309154E-06, .162806E-06, .704801E-07,
     +  .202852E-07, .181444E-08, .000000E+00, .726047E+06,
     +  .548228E+06, .406680E+06, .301403E+06, .223199E+06,
     +  .165115E+06, .122041E+06, .901040E+05, .664623E+05,
     +  .489657E+05, .360386E+05, .264907E+05, .194510E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .142625E+05, .104456E+05, .763893E+04, .557922E+04,
     +  .406839E+04, .296257E+04, .215362E+04, .156325E+04,
     +  .113263E+04, .819318E+03, .591519E+03, .426323E+03,
     +  .306638E+03, .220238E+03, .157099E+03, .112408E+03,
     +  .802676E+02, .572319E+02, .407345E+02, .289554E+02,
     +  .205760E+02, .146019E+02, .103574E+02, .735067E+01,
     +  .521920E+01, .371203E+01, .264409E+01, .188961E+01,
     +  .135395E+01, .973767E+00, .702823E+00, .509566E+00,
     +  .370830E+00, .271458E+00, .199012E+00, .146867E+00,
     +  .108501E+00, .805390E-01, .599200E-01, .447088E-01,
     +  .334083E-01, .250111E-01, .187280E-01, .140315E-01,
     +  .105044E-01, .786225E-02, .587272E-02, .438093E-02,
     +  .325811E-02, .241671E-02, .178812E-02, .131562E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .962527E-03, .700835E-03, .507041E-03, .364839E-03,
     +  .260613E-03, .185100E-03, .130462E-03, .913622E-04,
     +  .635488E-04, .441918E-04, .305295E-04, .210854E-04,
     +  .145559E-04, .100723E-04, .697034E-05, .482498E-05,
     +  .331655E-05, .224153E-05, .147123E-05, .918915E-06,
     +  .529797E-06, .269192E-06, .110443E-06, .299577E-07,
     +  .277736E-08, .000000E+00, .104424E+07, .785837E+06,
     +  .580621E+06, .428599E+06, .316111E+06, .232900E+06,
     +  .171436E+06, .126050E+06, .925879E+05, .679267E+05,
     +  .497809E+05, .364351E+05, .266364E+05, .194457E+05,
     +  .141784E+05, .103223E+05, .750478E+04, .544741E+04,
     +  .394826E+04, .285666E+04, .206362E+04, .148793E+04,
     +  .107102E+04, .769380E+03, .551692E+03, .394754E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .282027E+03, .200082E+03, .142379E+03, .101106E+03,
     +  .716796E+02, .507232E+02, .358420E+02, .253169E+02,
     +  .178551E+02, .125856E+02, .887449E+01, .626016E+01,
     +  .442271E+01, .312913E+01, .222088E+01, .158032E+01,
     +  .112859E+01, .808845E+00, .582250E+00, .420701E+00,
     +  .305750E+00, .222544E+00, .163039E+00, .119576E+00,
     +  .881129E-01, .650818E-01, .482052E-01, .357596E-01,
     +  .265742E-01, .197535E-01, .146911E-01, .109184E-01,
     +  .811223E-02, .601588E-02, .445538E-02, .329033E-02,
     +  .242372E-02, .178140E-02, .130231E-02, .947292E-03,
     +  .686193E-03, .494396E-03, .354675E-03, .253035E-03,
     +  .179843E-03, .127196E-03, .896773E-04, .630544E-04,
     +  .444933E-04, .313392E-04, .221507E-04, .156964E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .111560E-04, .792056E-05, .559861E-05, .390583E-05,
     +  .265706E-05, .174084E-05, .107561E-05, .608355E-06,
     +  .300445E-06, .118623E-06, .308302E-07, .291437E-08,
     +  .000000E+00, .143674E+07, .107753E+07, .792933E+06,
     +  .582954E+06, .428198E+06, .314185E+06, .230308E+06,
     +  .168628E+06, .123340E+06, .901024E+05, .657482E+05,
     +  .479130E+05, .348736E+05, .253465E+05, .183980E+05,
     +  .133337E+05, .964970E+04, .697190E+04, .502946E+04,
     +  .362167E+04, .260364E+04, .186815E+04, .133804E+04,
     +  .956373E+03, .682277E+03, .485651E+03, .345130E+03,
     +  .243519E+03, .172341E+03, .121704E+03, .857925E+02,
     +  .603606E+02, .424000E+02, .297702E+02, .208668E+02,
     +  .146168E+02, .102409E+02, .717744E+01, .503729E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .354024E+01, .249561E+01, .176369E+01, .125082E+01,
     +  .890220E+00, .636323E+00, .456538E+00, .329448E+00,
     +  .238096E+00, .173187E+00, .126116E+00, .922662E-01,
     +  .676661E-01, .497601E-01, .366502E-01, .270398E-01,
     +  .199561E-01, .147352E-01, .108736E-01, .802116E-02,
     +  .590665E-02, .434385E-02, .318620E-02, .233129E-02,
     +  .170250E-02, .123700E-02, .894824E-03, .645021E-03,
     +  .462920E-03, .331165E-03, .235984E-03, .167822E-03,
     +  .119045E-03, .844065E-04, .598639E-04, .427147E-04,
     +  .305064E-04, .218942E-04, .157612E-04, .113636E-04,
     +  .816356E-05, .581240E-05, .406487E-05, .275601E-05,
     +  .178985E-05, .108980E-05, .603936E-06, .290263E-06,
     +  .110658E-06, .276841E-07, .265871E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .191396E+07, .143053E+07, .104843E+07, .767649E+06,
     +  .561541E+06, .410319E+06, .299519E+06, .218381E+06,
     +  .159050E+06, .115692E+06, .840551E+05, .609866E+05,
     +  .441931E+05, .319771E+05, .231062E+05, .166698E+05,
     +  .120085E+05, .863579E+04, .620042E+04, .444361E+04,
     +  .317911E+04, .226990E+04, .161773E+04, .115047E+04,
     +  .816556E+03, .578208E+03, .408736E+03, .286832E+03,
     +  .201887E+03, .141782E+03, .993809E+02, .695203E+02,
     +  .485478E+02, .338844E+02, .236058E+02, .164333E+02,
     +  .114408E+02, .796715E+01, .555508E+01, .387846E+01,
     +  .271573E+01, .190631E+01, .134273E+01, .949101E+00,
     +  .673717E+00, .480019E+00, .343983E+00, .246870E+00,
     +  .178310E+00, .128938E+00, .936686E-01, .682162E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .498122E-01, .364324E-01, .266897E-01, .195602E-01,
     +  .143418E-01, .105100E-01, .769910E-02, .563090E-02,
     +  .411302E-02, .299716E-02, .217890E-02, .158152E-02,
     +  .114248E-02, .822211E-03, .590043E-03, .422007E-03,
     +  .301199E-03, .214471E-03, .152663E-03, .108623E-03,
     +  .774265E-04, .553299E-04, .398419E-04, .287572E-04,
     +  .208610E-04, .151673E-04, .110204E-04, .795555E-05,
     +  .566897E-05, .395212E-05, .265919E-05, .170667E-05,
     +  .102229E-05, .554723E-06, .259559E-06, .956923E-07,
     +  .231085E-07, .225127E-08, .000000E+00, .248618E+07,
     +  .185188E+07, .135170E+07, .985665E+06, .718047E+06,
     +  .522500E+06, .379808E+06, .275752E+06, .199978E+06,
     +  .144838E+06, .104774E+06, .756871E+05, .546031E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .393334E+05, .282935E+05, .203193E+05, .145700E+05,
     +  .104292E+05, .745279E+04, .531573E+04, .378470E+04,
     +  .268912E+04, .190701E+04, .134940E+04, .952873E+03,
     +  .671237E+03, .472002E+03, .329441E+03, .230621E+03,
     +  .161072E+03, .112269E+03, .780896E+02, .542150E+02,
     +  .376173E+02, .260483E+02, .180229E+02, .124691E+02,
     +  .862840E+01, .597744E+01, .414625E+01, .288408E+01,
     +  .201104E+01, .140698E+01, .987813E+00, .696425E+00,
     +  .492816E+00, .350742E+00, .249996E+00, .179325E+00,
     +  .128782E+00, .929110E-01, .672020E-01, .487341E-01,
     +  .354001E-01, .257548E-01, .187463E-01, .136513E-01,
     +  .993658E-02, .722998E-02, .525297E-02, .381198E-02,
     +  .276038E-02, .199453E-02, .143940E-02, .103426E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .740854E-03, .529574E-03, .377672E-03, .269094E-03,
     +  .191578E-03, .136559E-03, .974861E-04, .698474E-04,
     +  .502529E-04, .364635E-04, .265338E-04, .193919E-04,
     +  .141837E-04, .103419E-04, .747034E-05, .530755E-05,
     +  .367684E-05, .244927E-05, .155085E-05, .912987E-06,
     +  .484889E-06, .220924E-06, .788457E-07, .184187E-07,
     +  .181868E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .599462E+05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .277126E+05, .216201E+05, .166572E+05, .128238E+05,
     +  .987035E+04, .759088E+04, .583629E+04, .448333E+04,
     +  .344297E+04, .264154E+04, .202596E+04, .155226E+04,
     +  .118885E+04, .909527E+03, .695526E+03, .531245E+03,
     +  .405569E+03, .309225E+03, .235638E+03, .179316E+03,
     +  .136378E+03, .103573E+03, .786087E+02, .595712E+02,
     +  .451131E+02, .341163E+02, .257896E+02, .193887E+02,
     +  .146287E+02, .110213E+02, .830341E+01, .624871E+01,
     +  .470407E+01, .354196E+01, .266842E+01, .201066E+01,
     +  .151856E+01, .114803E+01, .870850E+00, .661825E+00,
     +  .505372E+00, .386969E+00, .297782E+00, .229903E+00,
     +  .178488E+00, .139022E+00, .108977E+00, .855130E-01,
     +  .675807E-01, .534320E-01, .424608E-01, .337855E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .269758E-01, .215536E-01, .172652E-01, .138216E-01,
     +  .110756E-01, .886173E-02, .709404E-02, .566280E-02,
     +  .451669E-02, .358895E-02, .284468E-02, .224795E-02,
     +  .176580E-02, .137670E-02, .106623E-02, .818022E-03,
     +  .621913E-03, .466579E-03, .345388E-03, .250803E-03,
     +  .178380E-03, .122675E-03, .818834E-04, .514812E-04,
     +  .298259E-04, .148092E-04, .492519E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .674922E+05,
     +  .524307E+05, .401998E+05, .307994E+05, .235895E+05,
     +  .180530E+05, .138109E+05, .105566E+05, .806588E+04,
     +  .615716E+04, .469801E+04, .358112E+04, .272840E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .207652E+04, .157952E+04, .120009E+04, .911256E+03,
     +  .691072E+03, .523742E+03, .396397E+03, .299808E+03,
     +  .226435E+03, .170889E+03, .128778E+03, .969643E+02,
     +  .729083E+02, .547915E+02, .409478E+02, .307091E+02,
     +  .229975E+02, .172188E+02, .128777E+02, .963203E+01,
     +  .720603E+01, .539244E+01, .403601E+01, .302685E+01,
     +  .227229E+01, .171106E+01, .129089E+01, .978252E+00,
     +  .743404E+00, .567589E+00, .434823E+00, .334884E+00,
     +  .258787E+00, .201224E+00, .156654E+00, .122801E+00,
     +  .963237E-01, .759298E-01, .599453E-01, .474836E-01,
     +  .376475E-01, .299216E-01, .237732E-01, .189067E-01,
     +  .150191E-01, .119375E-01, .946576E-02, .750184E-02,
     +  .592657E-02, .467338E-02, .367691E-02, .287880E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .224063E-02, .173573E-02, .133545E-02, .102148E-02,
     +  .774487E-03, .582796E-03, .433810E-03, .319610E-03,
     +  .231742E-03, .166658E-03, .117374E-03, .812648E-04,
     +  .549769E-04, .363292E-04, .232791E-04, .144460E-04,
     +  .861722E-05, .488758E-05, .261847E-05, .131123E-05,
     +  .598808E-06, .245834E-06, .864294E-07, .210998E-07,
     +  .178153E-10, .000000E+00, .121774E+06, .942226E+05,
     +  .719134E+05, .548465E+05, .418134E+05, .318520E+05,
     +  .242532E+05, .184515E+05, .140310E+05, .106598E+05,
     +  .809426E+04, .614020E+04, .465517E+04, .352558E+04,
     +  .266840E+04, .201731E+04, .152404E+04, .114995E+04,
     +  .867029E+03, .652848E+03, .491185E+03, .369036E+03,
     +  .277023E+03, .207645E+03, .155497E+03, .116281E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .868994E+02, .645745E+02, .481497E+02, .358514E+02,
     +  .266836E+02, .198377E+02, .147465E+02, .109644E+02,
     +  .815235E+01, .606247E+01, .451623E+01, .336769E+01,
     +  .251829E+01, .188671E+01, .141950E+01, .107101E+01,
     +  .811685E+00, .617291E+00, .471852E+00, .361942E+00,
     +  .279316E+00, .215846E+00, .167924E+00, .130745E+00,
     +  .102291E+00, .801688E-01, .630324E-01, .496143E-01,
     +  .391421E-01, .308761E-01, .243782E-01, .192299E-01,
     +  .151756E-01, .119511E-01, .940653E-02, .738250E-02,
     +  .578379E-02, .452224E-02, .351943E-02, .272445E-02,
     +  .210022E-02, .160937E-02, .122707E-02, .928694E-03,
     +  .698604E-03, .521007E-03, .385514E-03, .281901E-03,
     +  .205184E-03, .147174E-03, .104523E-03, .732323E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .507098E-04, .345653E-04, .232439E-04, .153468E-04,
     +  .990042E-05, .620736E-05, .374204E-05, .211608E-05,
     +  .108584E-05, .469572E-06, .139568E-06, .110627E-07,
     +  .000000E+00, .192332E+06, .149198E+06, .113375E+06,
     +  .860898E+05, .653416E+05, .495543E+05, .375626E+05,
     +  .284486E+05, .215342E+05, .162855E+05, .123087E+05,
     +  .929394E+04, .701299E+04, .528626E+04, .398184E+04,
     +  .299587E+04, .225230E+04, .169119E+04, .126879E+04,
     +  .950631E+03, .711620E+03, .531952E+03, .397262E+03,
     +  .296235E+03, .220671E+03, .164144E+03, .122006E+03,
     +  .901624E+02, .668550E+02, .495011E+02, .366310E+02,
     +  .270757E+02, .200068E+02, .147867E+02, .109261E+02,
     +  .807456E+01, .597632E+01, .442763E+01, .328874E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .244746E+01, .182870E+01, .137027E+01, .103117E+01,
     +  .778738E+00, .591011E+00, .450150E+00, .344901E+00,
     +  .264652E+00, .204417E+00, .158039E+00, .122764E+00,
     +  .955460E-01, .745928E-01, .583085E-01, .456779E-01,
     +  .357843E-01, .280576E-01, .219827E-01, .172287E-01,
     +  .134774E-01, .105362E-01, .821499E-02, .639380E-02,
     +  .496707E-02, .384100E-02, .295550E-02, .226515E-02,
     +  .172652E-02, .130989E-02, .987206E-03, .739995E-03,
     +  .550541E-03, .406843E-03, .297718E-03, .217155E-03,
     +  .156519E-03, .111988E-03, .793144E-04, .556938E-04,
     +  .386412E-04, .265235E-04, .179157E-04, .118354E-04,
     +  .759144E-05, .466309E-05, .267188E-05, .137607E-05,
     +  .589198E-06, .171284E-06, .144541E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .306367E+06, .235133E+06, .177788E+06, .134333E+06,
     +  .101444E+06, .765470E+05, .577265E+05, .434968E+05,
     +  .327538E+05, .246419E+05, .185262E+05, .139148E+05,
     +  .104434E+05, .782978E+04, .586548E+04, .438900E+04,
     +  .328128E+04, .245012E+04, .182773E+04, .136165E+04,
     +  .101339E+04, .753149E+03, .559119E+03, .414460E+03,
     +  .306868E+03, .226869E+03, .167578E+03, .123052E+03,
     +  .906559E+02, .666920E+02, .490241E+02, .359947E+02,
     +  .264140E+02, .193877E+02, .142233E+02, .104358E+02,
     +  .766652E+01, .563766E+01, .415533E+01, .306870E+01,
     +  .227478E+01, .169116E+01, .126241E+01, .945807E+00,
     +  .711971E+00, .537947E+00, .408825E+00, .311201E+00,
     +  .238420E+00, .182862E+00, .140900E+00, .108800E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .842601E-01, .653494E-01, .507822E-01, .394700E-01,
     +  .306984E-01, .238609E-01, .185469E-01, .143904E-01,
     +  .111542E-01, .862249E-02, .665035E-02, .511823E-02,
     +  .391823E-02, .298335E-02, .226047E-02, .170184E-02,
     +  .127352E-02, .945334E-03, .696429E-03, .508016E-03,
     +  .366910E-03, .261512E-03, .184943E-03, .128548E-03,
     +  .881176E-04, .593611E-04, .393219E-04, .255169E-04,
     +  .162397E-04, .100985E-04, .611099E-05, .358695E-05,
     +  .202640E-05, .107811E-05, .524766E-06, .216406E-06,
     +  .615407E-07, .473814E-08, .000000E+00, .456467E+06,
     +  .348854E+06, .262482E+06, .197351E+06, .148294E+06,
     +  .111341E+06, .835423E+05, .626303E+05, .469201E+05,
     +  .351183E+05, .262651E+05, .196243E+05, .146505E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .109256E+05, .814053E+04, .605842E+04, .450449E+04,
     +  .334495E+04, .248130E+04, .183816E+04, .136022E+04,
     +  .100510E+04, .741803E+03, .546648E+03, .402320E+03,
     +  .295640E+03, .217032E+03, .158364E+03, .115932E+03,
     +  .847429E+02, .618858E+02, .451387E+02, .329000E+02,
     +  .239842E+02, .174719E+02, .127289E+02, .928315E+01,
     +  .677667E+01, .495745E+01, .363361E+01, .267287E+01,
     +  .197188E+01, .146046E+01, .108570E+01, .810829E+00,
     +  .607853E+00, .458306E+00, .346142E+00, .263091E+00,
     +  .200209E+00, .153051E+00, .117271E+00, .901091E-01,
     +  .693469E-01, .534664E-01, .412361E-01, .318223E-01,
     +  .245450E-01, .189299E-01, .145752E-01, .112097E-01,
     +  .859955E-02, .658159E-02, .502682E-02, .381883E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .288621E-02, .217099E-02, .162318E-02, .120658E-02,
     +  .890232E-03, .652232E-03, .473630E-03, .340881E-03,
     +  .242591E-03, .171589E-03, .119639E-03, .825234E-04,
     +  .561913E-04, .378012E-04, .250645E-04, .163924E-04,
     +  .105384E-04, .662056E-05, .404219E-05, .236603E-05,
     +  .129367E-05, .635579E-06, .257624E-06, .700513E-07,
     +  .592435E-08, .000000E+00, .651858E+06, .496124E+06,
     +  .371491E+06, .277961E+06, .207845E+06, .155286E+06,
     +  .115938E+06, .864831E+05, .644631E+05, .480040E+05,
     +  .357183E+05, .265497E+05, .197172E+05, .146270E+05,
     +  .108405E+05, .802469E+04, .593413E+04, .438256E+04,
     +  .323306E+04, .238176E+04, .175253E+04, .128763E+04,
     +  .944839E+03, .692219E+03, .506447E+03, .369928E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .269916E+03, .195725E+03, .142387E+03, .103424E+03,
     +  .750408E+02, .543772E+02, .393693E+02, .285075E+02,
     +  .206236E+02, .149203E+02, .108037E+02, .782997E+01,
     +  .568593E+01, .413682E+01, .302017E+01, .221133E+01,
     +  .162530E+01, .119906E+01, .888595E+00, .661051E+00,
     +  .494582E+00, .370683E+00, .279571E+00, .211125E+00,
     +  .160158E+00, .121788E+00, .928662E-01, .709294E-01,
     +  .542690E-01, .415397E-01, .318135E-01, .243542E-01,
     +  .186403E-01, .142449E-01, .108730E-01, .827935E-02,
     +  .628910E-02, .476788E-02, .359530E-02, .269782E-02,
     +  .201505E-02, .149655E-02, .110535E-02, .810825E-03,
     +  .590956E-03, .427303E-03, .306559E-03, .217858E-03,
     +  .154120E-03, .107754E-03, .747276E-04, .513348E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .349574E-04, .235524E-04, .156955E-04, .103050E-04,
     +  .661342E-05, .411857E-05, .244721E-05, .134966E-05,
     +  .661871E-06, .264386E-06, .701600E-07, .620750E-08,
     +  .000000E+00, .901634E+06, .683444E+06, .509324E+06,
     +  .379273E+06, .282235E+06, .209843E+06, .155903E+06,
     +  .115722E+06, .858281E+05, .635937E+05, .470786E+05,
     +  .348155E+05, .257226E+05, .189830E+05, .139950E+05,
     +  .103050E+05, .757959E+04, .556760E+04, .408483E+04,
     +  .299268E+04, .218977E+04, .159982E+04, .116722E+04,
     +  .850208E+03, .618399E+03, .449020E+03, .325653E+03,
     +  .234684E+03, .169673E+03, .122474E+03, .882958E+02,
     +  .635697E+02, .457216E+02, .328872E+02, .236302E+02,
     +  .169778E+02, .122071E+02, .878444E+01, .633302E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .457418E+01, .331485E+01, .240915E+01, .175746E+01,
     +  .128688E+01, .946486E+00, .698831E+00, .518913E+00,
     +  .386001E+00, .288929E+00, .216559E+00, .163048E+00,
     +  .123067E+00, .931413E-01, .706133E-01, .536243E-01,
     +  .407433E-01, .309725E-01, .235366E-01, .178812E-01,
     +  .135650E-01, .102781E-01, .776973E-02, .585910E-02,
     +  .441004E-02, .330174E-02, .246047E-02, .182546E-02,
     +  .134714E-02, .989026E-03, .721584E-03, .523403E-03,
     +  .377010E-03, .269750E-03, .191493E-03, .135524E-03,
     +  .950022E-04, .661990E-04, .458087E-04, .314889E-04,
     +  .214590E-04, .144751E-04, .961931E-05, .623721E-05,
     +  .391228E-05, .232947E-05, .127971E-05, .619873E-06,
     +  .242145E-06, .624788E-07, .568653E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .121556E+07, .917738E+06, .680724E+06, .504521E+06,
     +  .373654E+06, .276484E+06, .204423E+06, .150998E+06,
     +  .111441E+06, .821629E+05, .605211E+05, .445310E+05,
     +  .327332E+05, .240326E+05, .176258E+05, .129106E+05,
     +  .944580E+04, .690138E+04, .503604E+04, .366945E+04,
     +  .267014E+04, .193989E+04, .140733E+04, .101926E+04,
     +  .737064E+03, .532037E+03, .383562E+03, .274729E+03,
     +  .197410E+03, .141613E+03, .101451E+03, .725752E+02,
     +  .518594E+02, .370572E+02, .264477E+02, .188731E+02,
     +  .134759E+02, .962985E+01, .689327E+01, .494328E+01,
     +  .355640E+01, .256591E+01, .185808E+01, .135059E+01,
     +  .986006E+00, .722643E+00, .532639E+00, .393293E+00,
     +  .292215E+00, .217413E+00, .162489E+00, .121754E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .914746E-01, .688469E-01, .519014E-01, .391493E-01,
     +  .295453E-01, .222909E-01, .168127E-01, .126635E-01,
     +  .952646E-02, .715090E-02, .535449E-02, .400230E-02,
     +  .297594E-02, .220307E-02, .162411E-02, .119140E-02,
     +  .869820E-03, .631491E-03, .456111E-03, .327469E-03,
     +  .233815E-03, .165889E-03, .117500E-03, .825933E-04,
     +  .578086E-04, .402522E-04, .278750E-04, .191524E-04,
     +  .130190E-04, .870755E-05, .566742E-05, .355573E-05,
     +  .210738E-05, .114604E-05, .545527E-06, .207621E-06,
     +  .519754E-07, .483497E-08, .000000E+00, .160388E+07,
     +  .120618E+07, .890543E+06, .656967E+06, .484278E+06,
     +  .356649E+06, .262437E+06, .192920E+06, .141691E+06,
     +  .103955E+06, .761949E+05, .557847E+05, .407990E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .298027E+05, .217455E+05, .158458E+05, .115327E+05,
     +  .838161E+04, .608352E+04, .440879E+04, .319061E+04,
     +  .230524E+04, .166304E+04, .119764E+04, .861106E+03,
     +  .617959E+03, .442883E+03, .315302E+03, .225195E+03,
     +  .160558E+03, .114307E+03, .812576E+02, .576911E+02,
     +  .409575E+02, .290379E+02, .205828E+02, .145967E+02,
     +  .103591E+02, .736354E+01, .524343E+01, .374551E+01,
     +  .268306E+01, .192893E+01, .139199E+01, .100887E+01,
     +  .734049E+00, .537136E+00, .393746E+00, .290436E+00,
     +  .214533E+00, .159183E+00, .118426E+00, .883379E-01,
     +  .660133E-01, .494100E-01, .370062E-01, .277304E-01,
     +  .207748E-01, .155588E-01, .116376E-01, .869394E-02,
     +  .648144E-02, .482016E-02, .357887E-02, .264365E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .194482E-02, .142516E-02, .103965E-02, .755170E-03,
     +  .545844E-03, .392809E-03, .281277E-03, .200544E-03,
     +  .142279E-03, .100904E-03, .711299E-04, .499917E-04,
     +  .349929E-04, .243716E-04, .168394E-04, .114965E-04,
     +  .770809E-05, .501417E-05, .313292E-05, .184079E-05,
     +  .987447E-06, .460620E-06, .170496E-06, .413924E-07,
     +  .392268E-08, .000000E+00, .207699E+07, .155599E+07,
     +  .114359E+07, .839790E+06, .616187E+06, .451684E+06,
     +  .330807E+06, .242029E+06, .176909E+06, .129168E+06,
     +  .942142E+05, .686385E+05, .499508E+05, .363051E+05,
     +  .263560E+05, .191074E+05, .138346E+05, .100022E+05,
     +  .722149E+04, .520561E+04, .374696E+04, .269245E+04,
     +  .193167E+04, .138334E+04, .988997E+03, .705661E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .502799E+03, .355824E+03, .252623E+03, .179027E+03,
     +  .126675E+03, .894902E+02, .631347E+02, .445361E+02,
     +  .313694E+02, .220890E+02, .155599E+02, .109680E+02,
     +  .774299E+01, .547557E+01, .388403E+01, .276276E+01,
     +  .197220E+01, .141315E+01, .101693E+01, .734660E+00,
     +  .533774E+00, .388505E+00, .284538E+00, .208691E+00,
     +  .153756E+00, .113589E+00, .841357E-01, .624348E-01,
     +  .464050E-01, .345148E-01, .256845E-01, .191101E-01,
     +  .142139E-01, .105597E-01, .783546E-02, .580279E-02,
     +  .428711E-02, .316272E-02, .232166E-02, .169783E-02,
     +  .123722E-02, .897928E-03, .649242E-03, .467472E-03,
     +  .335382E-03, .239672E-03, .170739E-03, .121190E-03,
     +  .860847E-04, .608580E-04, .429323E-04, .301805E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .211067E-04, .146328E-04, .100064E-04, .670501E-05,
     +  .434569E-05, .269593E-05, .156622E-05, .826848E-06,
     +  .377344E-06, .135729E-06, .319694E-07, .308048E-08,
     +  .000000E+00, .264518E+07, .197421E+07, .144447E+07,
     +  .105597E+07, .771286E+06, .562789E+06, .410272E+06,
     +  .298770E+06, .217354E+06, .157945E+06, .114652E+06,
     +  .831237E+05, .601963E+05, .435360E+05, .314476E+05,
     +  .226839E+05, .163405E+05, .117532E+05, .844159E+04,
     +  .605317E+04, .433386E+04, .309745E+04, .221014E+04,
     +  .157406E+04, .111908E+04, .793952E+03, .562469E+03,
     +  .395714E+03, .279294E+03, .196753E+03, .138376E+03,
     +  .971594E+02, .681192E+02, .477505E+02, .334183E+02,
     +  .233793E+02, .163604E+02, .114557E+02, .803289E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .564205E+01, .397470E+01, .280779E+01, .199045E+01,
     +  .141634E+01, .101212E+01, .726087E+00, .523881E+00,
     +  .378647E+00, .275391E+00, .200581E+00, .146760E+00,
     +  .107676E+00, .792086E-01, .583770E-01, .430922E-01,
     +  .318335E-01, .235291E-01, .173891E-01, .128474E-01,
     +  .948155E-02, .698950E-02, .514317E-02, .377576E-02,
     +  .276843E-02, .202019E-02, .146915E-02, .106503E-02,
     +  .769357E-03, .554014E-03, .397590E-03, .284543E-03,
     +  .203051E-03, .144611E-03, .102732E-03, .731054E-04,
     +  .518236E-04, .366757E-04, .258658E-04, .181362E-04,
     +  .125909E-04, .860466E-05, .574847E-05, .370335E-05,
     +  .227614E-05, .130503E-05, .676993E-06, .301938E-06,
     +  .105508E-06, .241299E-07, .236100E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .494607E+05, .171440E+05, .134505E+05, .105527E+05,
     +  .827931E+04, .649573E+04, .509644E+04, .399864E+04,
     +  .313737E+04, .246166E+04, .193154E+04, .151562E+04,
     +  .118932E+04, .933311E+03, .732456E+03, .574870E+03,
     +  .451231E+03, .354224E+03, .278111E+03, .218391E+03,
     +  .171532E+03, .134762E+03, .105908E+03, .832641E+02,
     +  .654929E+02, .515444E+02, .405949E+02, .318906E+02,
     +  .251657E+02, .198828E+02, .157313E+02, .124675E+02,
     +  .990011E+01, .788445E+01, .629187E+01, .503591E+01,
     +  .404376E+01, .325830E+01, .263481E+01, .213805E+01,
     +  .174130E+01, .142250E+01, .116520E+01, .956471E+00,
     +  .786287E+00, .646866E+00, .532547E+00, .437548E+00,
     +  .359355E+00, .294092E+00, .240128E+00, .195342E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .158224E+00, .127528E+00, .102221E+00, .814386E-01,
     +  .644512E-01, .506412E-01, .394829E-01, .305280E-01,
     +  .233942E-01, .177565E-01, .133396E-01, .992495E-02,
     +  .728412E-02, .527785E-02, .377149E-02, .265480E-02,
     +  .183839E-02, .125046E-02, .834033E-03, .544392E-03,
     +  .346837E-03, .214980E-03, .129854E-03, .755904E-04,
     +  .423603E-04, .227230E-04, .115862E-04, .556600E-05,
     +  .249085E-05, .102463E-05, .377292E-06, .121918E-06,
     +  .330313E-07, .703635E-08, .105816E-08, .917877E-10,
     +  .291742E-11, .796019E-14, .000000E+00, .486410E+05,
     +  .325895E+05, .254947E+05, .199352E+05, .155902E+05,
     +  .121862E+05, .952669E+04, .744378E+04, .581691E+04,
     +  .454318E+04, .354869E+04, .277035E+04, .216290E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .168768E+04, .131696E+04, .102706E+04, .801036E+03,
     +  .624375E+03, .486711E+03, .379177E+03, .295438E+03,
     +  .230067E+03, .179193E+03, .139503E+03, .108634E+03,
     +  .845732E+02, .658738E+02, .511286E+02, .398573E+02,
     +  .310777E+02, .242623E+02, .189550E+02, .148349E+02,
     +  .116339E+02, .914122E+01, .719783E+01, .568645E+01,
     +  .450472E+01, .358232E+01, .285733E+01, .228866E+01,
     +  .183843E+01, .148189E+01, .119720E+01, .969678E+00,
     +  .786280E+00, .638891E+00, .518330E+00, .421063E+00,
     +  .341072E+00, .276097E+00, .222887E+00, .179477E+00,
     +  .143984E+00, .115105E+00, .915848E-01, .725433E-01,
     +  .571477E-01, .447912E-01, .348885E-01, .270187E-01,
     +  .207829E-01, .158811E-01, .120636E-01, .908099E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .677684E-02, .501418E-02, .367320E-02, .266339E-02,
     +  .190686E-02, .134660E-02, .933527E-03, .633701E-03,
     +  .415854E-03, .263187E-03, .155195E-03, .811363E-04,
     +  .320191E-04, .687145E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .684086E+05, .537902E+05,
     +  .418203E+05, .324990E+05, .252549E+05, .196159E+05,
     +  .152354E+05, .118270E+05, .918066E+04, .712254E+04,
     +  .552540E+04, .428394E+04, .332111E+04, .257312E+04,
     +  .199338E+04, .154329E+04, .119469E+04, .924217E+03,
     +  .714897E+03, .552620E+03, .427147E+03, .329953E+03,
     +  .254866E+03, .196751E+03, .151894E+03, .117216E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .904836E+02, .695780E+02, .537287E+02, .414910E+02,
     +  .320717E+02, .248033E+02, .192102E+02, .149059E+02,
     +  .115849E+02, .902123E+01, .704668E+01, .551859E+01,
     +  .433797E+01, .342002E+01, .270776E+01, .215025E+01,
     +  .171370E+01, .136926E+01, .109723E+01, .880597E+00,
     +  .708571E+00, .569511E+00, .458657E+00, .368515E+00,
     +  .296091E+00, .237403E+00, .189995E+00, .151598E+00,
     +  .120622E+00, .955919E-01, .754688E-01, .593023E-01,
     +  .463995E-01, .361066E-01, .279581E-01, .215203E-01,
     +  .164688E-01, .125392E-01, .946744E-02, .709106E-02,
     +  .526882E-02, .387796E-02, .282611E-02, .203391E-02,
     +  .144369E-02, .100584E-02, .685769E-03, .451809E-03,
     +  .287119E-03, .170103E-03, .900714E-04, .370877E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .540150E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .107700E+06, .842106E+05, .650547E+05,
     +  .502328E+05, .387830E+05, .299280E+05, .230914E+05,
     +  .178072E+05, .137299E+05, .105803E+05, .815164E+04,
     +  .627677E+04, .483213E+04, .371766E+04, .285959E+04,
     +  .219813E+04, .168927E+04, .129731E+04, .996055E+03,
     +  .764219E+03, .586221E+03, .449372E+03, .344404E+03,
     +  .263784E+03, .202011E+03, .154628E+03, .118380E+03,
     +  .902553E+02, .690980E+02, .528951E+02, .405221E+02,
     +  .310547E+02, .238280E+02, .183149E+02, .140967E+02,
     +  .108695E+02, .840543E+01, .651614E+01, .506960E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .395578E+01, .309970E+01, .243637E+01, .192206E+01,
     +  .152052E+01, .120663E+01, .959312E+00, .764946E+00,
     +  .609482E+00, .486820E+00, .388090E+00, .309530E+00,
     +  .246481E+00, .196005E+00, .155482E+00, .123051E+00,
     +  .970473E-01, .762863E-01, .597192E-01, .465746E-01,
     +  .361470E-01, .279317E-01, .214695E-01, .164169E-01,
     +  .124987E-01, .944283E-02, .708306E-02, .527577E-02,
     +  .389727E-02, .285475E-02, .206905E-02, .148286E-02,
     +  .104728E-02, .727622E-03, .493248E-03, .327223E-03,
     +  .208221E-03, .125993E-03, .703588E-04, .366567E-04,
     +  .232791E-04, .144460E-04, .861722E-05, .488758E-05,
     +  .261847E-05, .131123E-05, .598808E-06, .245834E-06,
     +  .864294E-07, .210998E-07, .178153E-10, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .161520E+06, .125633E+06, .964771E+05, .740510E+05,
     +  .568262E+05, .435850E+05, .334216E+05, .256139E+05,
     +  .196253E+05, .150280E+05, .115045E+05, .880172E+04,
     +  .673190E+04, .514545E+04, .393163E+04, .300207E+04,
     +  .229153E+04, .174789E+04, .133276E+04, .101546E+04,
     +  .773463E+03, .588699E+03, .447933E+03, .340584E+03,
     +  .258894E+03, .196685E+03, .149434E+03, .113040E+03,
     +  .858598E+02, .652018E+02, .495421E+02, .376528E+02,
     +  .286452E+02, .218284E+02, .166529E+02, .127259E+02,
     +  .975129E+01, .748997E+01, .577286E+01, .446239E+01,
     +  .346383E+01, .269717E+01, .210803E+01, .165244E+01,
     +  .129956E+01, .102419E+01, .809791E+00, .639943E+00,
     +  .507161E+00, .401282E+00, .317773E+00, .251346E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .198603E+00, .156606E+00, .123248E+00, .966990E-01,
     +  .756456E-01, .589566E-01, .457935E-01, .354117E-01,
     +  .272743E-01, .209048E-01, .159457E-01, .121151E-01,
     +  .913780E-02, .684621E-02, .509599E-02, .376441E-02,
     +  .275940E-02, .200339E-02, .144011E-02, .102214E-02,
     +  .715454E-03, .490874E-03, .331550E-03, .217202E-03,
     +  .137932E-03, .839936E-04, .509380E-04, .345654E-04,
     +  .232439E-04, .153468E-04, .990042E-05, .620736E-05,
     +  .374204E-05, .211608E-05, .108584E-05, .469572E-06,
     +  .139568E-06, .110627E-07, .000000E+00, .181591E+06,
     +  .180255E+06, .137660E+06, .105075E+06, .801815E+05,
     +  .611512E+05, .466236E+05, .355264E+05, .270618E+05,
     +  .206012E+05, .156775E+05, .119227E+05, .906385E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .688572E+04, .522893E+04, .396789E+04, .300970E+04,
     +  .228115E+04, .172820E+04, .130825E+04, .989926E+03,
     +  .748467E+03, .565667E+03, .427183E+03, .322479E+03,
     +  .243280E+03, .183524E+03, .137815E+03, .103909E+03,
     +  .783217E+02, .590588E+02, .445397E+02, .336173E+02,
     +  .254129E+02, .192290E+02, .145728E+02, .110721E+02,
     +  .843202E+01, .644273E+01, .493699E+01, .379879E+01,
     +  .293233E+01, .227198E+01, .176579E+01, .137704E+01,
     +  .107635E+01, .844241E+00, .661993E+00, .520716E+00,
     +  .409038E+00, .321675E+00, .252758E+00, .198461E+00,
     +  .155561E+00, .121728E+00, .949941E-01, .739333E-01,
     +  .573474E-01, .443425E-01, .341458E-01, .261957E-01,
     +  .200051E-01, .152077E-01, .115183E-01, .866240E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .647329E-02, .480745E-02, .354463E-02, .259451E-02,
     +  .188212E-02, .135280E-02, .961217E-03, .674537E-03,
     +  .465276E-03, .316951E-03, .210700E-03, .137029E-03,
     +  .869189E-04, .558545E-04, .386413E-04, .265235E-04,
     +  .179157E-04, .118354E-04, .759144E-05, .466309E-05,
     +  .267188E-05, .137607E-05, .589198E-06, .171284E-06,
     +  .144541E-07, .000000E+00, .345161E+06, .265786E+06,
     +  .201754E+06, .153067E+06, .116086E+06, .879883E+05,
     +  .666648E+05, .504779E+05, .382051E+05, .288975E+05,
     +  .218474E+05, .165061E+05, .124646E+05, .940587E+04,
     +  .709409E+04, .534641E+04, .402712E+04, .303093E+04,
     +  .227989E+04, .171353E+04, .128714E+04, .966046E+03,
     +  .724645E+03, .543118E+03, .406848E+03, .304543E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .227924E+03, .169766E+03, .126952E+03, .949000E+02,
     +  .709537E+02, .530521E+02, .396903E+02, .297381E+02,
     +  .222968E+02, .167425E+02, .126012E+02, .950573E+01,
     +  .719328E+01, .545910E+01, .415976E+01, .318002E+01,
     +  .244011E+01, .187847E+01, .145113E+01, .112386E+01,
     +  .873586E+00, .679013E+00, .529574E+00, .412587E+00,
     +  .321893E+00, .251014E+00, .195648E+00, .152285E+00,
     +  .118359E+00, .917707E-01, .709799E-01, .547298E-01,
     +  .420737E-01, .322193E-01, .245831E-01, .186743E-01,
     +  .141204E-01, .106376E-01, .795557E-02, .591091E-02,
     +  .436272E-02, .319527E-02, .232128E-02, .166968E-02,
     +  .118824E-02, .834487E-03, .577360E-03, .391515E-03,
     +  .261089E-03, .168983E-03, .106188E-03, .645761E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .394318E-04, .255170E-04, .162397E-04, .100985E-04,
     +  .611099E-05, .358695E-05, .202640E-05, .107811E-05,
     +  .524766E-06, .216406E-06, .615407E-07, .473814E-08,
     +  .000000E+00, .494762E+06, .379109E+06, .286135E+06,
     +  .215839E+06, .162741E+06, .122629E+06, .923597E+05,
     +  .695162E+05, .522962E+05, .393145E+05, .295395E+05,
     +  .221786E+05, .166425E+05, .124786E+05, .935090E+04,
     +  .700141E+04, .523891E+04, .391673E+04, .292629E+04,
     +  .218436E+04, .162946E+04, .121442E+04, .904478E+03,
     +  .673035E+03, .500486E+03, .371862E+03, .276213E+03,
     +  .204143E+03, .151474E+03, .112340E+03, .833185E+02,
     +  .617902E+02, .458429E+02, .340592E+02, .253167E+02,
     +  .188445E+02, .140572E+02, .105091E+02, .788029E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .592595E+01, .447400E+01, .338892E+01, .257656E+01,
     +  .196555E+01, .150475E+01, .115510E+01, .890096E+00,
     +  .685977E+00, .530580E+00, .410043E+00, .317403E+00,
     +  .245645E+00, .190055E+00, .146885E+00, .113375E+00,
     +  .873223E-01, .671034E-01, .514194E-01, .392890E-01,
     +  .299111E-01, .226915E-01, .171424E-01, .128917E-01,
     +  .966052E-02, .718698E-02, .531283E-02, .390189E-02,
     +  .284423E-02, .205684E-02, .147329E-02, .104455E-02,
     +  .731405E-03, .505064E-03, .342568E-03, .229084E-03,
     +  .149424E-03, .953382E-04, .596715E-04, .378744E-04,
     +  .250646E-04, .163924E-04, .105384E-04, .662056E-05,
     +  .404219E-05, .236603E-05, .129367E-05, .635579E-06,
     +  .257624E-06, .700513E-07, .592435E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .689659E+06, .525986E+06, .394835E+06, .296205E+06,
     +  .222101E+06, .166423E+06, .124636E+06, .932748E+05,
     +  .697648E+05, .521416E+05, .389464E+05, .290675E+05,
     +  .216804E+05, .161572E+05, .120328E+05, .895341E+04,
     +  .665725E+04, .494540E+04, .367095E+04, .272233E+04,
     +  .201730E+04, .149339E+04, .110468E+04, .816348E+03,
     +  .602809E+03, .444705E+03, .327937E+03, .240573E+03,
     +  .177177E+03, .130411E+03, .959769E+02, .706228E+02,
     +  .519785E+02, .383069E+02, .282395E+02, .208449E+02,
     +  .154175E+02, .114274E+02, .849448E+01, .633213E+01,
     +  .473865E+01, .355789E+01, .268127E+01, .202763E+01,
     +  .153885E+01, .117121E+01, .894949E+00, .684031E+00,
     +  .524808E+00, .402383E+00, .309076E+00, .237415E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .182348E+00, .139931E+00, .107259E+00, .820573E-01,
     +  .626439E-01, .476968E-01, .362170E-01, .274053E-01,
     +  .206666E-01, .155222E-01, .116062E-01, .864823E-02,
     +  .639794E-02, .470387E-02, .343630E-02, .249203E-02,
     +  .179326E-02, .127866E-02, .902839E-03, .630090E-03,
     +  .434141E-03, .294407E-03, .197322E-03, .129574E-03,
     +  .837615E-04, .536470E-04, .350059E-04, .235525E-04,
     +  .156955E-04, .103050E-04, .661342E-05, .411857E-05,
     +  .244721E-05, .134966E-05, .661871E-06, .264386E-06,
     +  .701600E-07, .620750E-08, .000000E+00, .938947E+06,
     +  .712918E+06, .532362E+06, .397276E+06, .296301E+06,
     +  .220830E+06, .164483E+06, .122421E+06, .910563E+05,
     +  .676734E+05, .502609E+05, .372972E+05, .276572E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .204906E+05, .151694E+05, .112196E+05, .829151E+04,
     +  .612155E+04, .451569E+04, .332766E+04, .245009E+04,
     +  .180205E+04, .132424E+04, .972089E+03, .712962E+03,
     +  .522356E+03, .382515E+03, .278602E+03, .203711E+03,
     +  .148851E+03, .108735E+03, .794087E+02, .579968E+02,
     +  .424107E+02, .310171E+02, .227115E+02, .166610E+02,
     +  .122475E+02, .902814E+01, .667350E+01, .495193E+01,
     +  .368662E+01, .275478E+01, .206573E+01, .155465E+01,
     +  .117347E+01, .889379E+00, .674313E+00, .513278E+00,
     +  .390498E+00, .297677E+00, .226974E+00, .173068E+00,
     +  .131874E+00, .100383E+00, .762795E-01, .578484E-01,
     +  .437618E-01, .330183E-01, .248303E-01, .186106E-01,
     +  .138946E-01, .103277E-01, .765081E-02, .562742E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .411416E-02, .298903E-02, .215625E-02, .154381E-02,
     +  .109569E-02, .770456E-03, .535927E-03, .368480E-03,
     +  .249839E-03, .167825E-03, .110898E-03, .725314E-04,
     +  .473405E-04, .315210E-04, .214590E-04, .144751E-04,
     +  .961931E-05, .623721E-05, .391228E-05, .232947E-05,
     +  .127971E-05, .619873E-06, .242145E-06, .624788E-07,
     +  .568653E-08, .000000E+00, .125239E+07, .946828E+06,
     +  .703459E+06, .522286E+06, .387532E+06, .287323E+06,
     +  .212885E+06, .157604E+06, .116597E+06, .861850E+05,
     +  .636580E+05, .469768E+05, .346394E+05, .255178E+05,
     +  .187825E+05, .138111E+05, .101466E+05, .744650E+04,
     +  .545989E+04, .399887E+04, .292604E+04, .213860E+04,
     +  .156155E+04, .113890E+04, .829834E+03, .603934E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .439267E+03, .317716E+03, .230694E+03, .167379E+03,
     +  .121392E+03, .880069E+02, .637999E+02, .463044E+02,
     +  .336055E+02, .244162E+02, .177705E+02, .129592E+02,
     +  .947591E+01, .694778E+01, .511341E+01, .377575E+01,
     +  .279831E+01, .208130E+01, .155368E+01, .116332E+01,
     +  .874710E+00, .657991E+00, .496996E+00, .375242E+00,
     +  .283919E+00, .214908E+00, .162696E+00, .123102E+00,
     +  .930613E-01, .702394E-01, .529154E-01, .397708E-01,
     +  .298154E-01, .222815E-01, .165972E-01, .123165E-01,
     +  .909979E-02, .670138E-02, .490034E-02, .356229E-02,
     +  .257383E-02, .184694E-02, .131576E-02, .929603E-03,
     +  .651083E-03, .451510E-03, .309892E-03, .210154E-03,
     +  .141528E-03, .941087E-04, .622225E-04, .412639E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .278961E-04, .191524E-04, .130190E-04, .870755E-05,
     +  .566742E-05, .355573E-05, .210738E-05, .114604E-05,
     +  .545527E-06, .207621E-06, .519754E-07, .483497E-08,
     +  .000000E+00, .164023E+07, .123489E+07, .912978E+06,
     +  .674495E+06, .497969E+06, .367341E+06, .270784E+06,
     +  .199435E+06, .146774E+06, .107920E+06, .792867E+05,
     +  .581948E+05, .426771E+05, .312656E+05, .228846E+05,
     +  .167324E+05, .122224E+05, .891796E+04, .650041E+04,
     +  .473267E+04, .344211E+04, .250043E+04, .181446E+04,
     +  .131505E+04, .952082E+03, .688416E+03, .497429E+03,
     +  .357357E+03, .257726E+03, .185712E+03, .133749E+03,
     +  .962810E+02, .692963E+02, .499279E+02, .359666E+02,
     +  .259355E+02, .187324E+02, .135556E+02, .983480E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .715440E+01, .522391E+01, .382683E+01, .281368E+01,
     +  .207620E+01, .153767E+01, .114233E+01, .852304E+00,
     +  .636223E+00, .476930E+00, .357410E+00, .268448E+00,
     +  .201740E+00, .151647E+00, .113947E+00, .855509E-01,
     +  .641380E-01, .480002E-01, .358431E-01, .266992E-01,
     +  .198277E-01, .146780E-01, .108262E-01, .795054E-02,
     +  .582044E-02, .423138E-02, .305866E-02, .219792E-02,
     +  .156905E-02, .111240E-02, .782550E-03, .546097E-03,
     +  .377705E-03, .258912E-03, .175703E-03, .118686E-03,
     +  .794256E-04, .530518E-04, .356592E-04, .243855E-04,
     +  .168394E-04, .114965E-04, .770809E-05, .501417E-05,
     +  .313292E-05, .184079E-05, .987447E-06, .460620E-06,
     +  .170496E-06, .413924E-07, .392268E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .211287E+07, .158433E+07, .116573E+07, .857083E+06,
     +  .629693E+06, .462230E+06, .339039E+06, .248453E+06,
     +  .181920E+06, .133076E+06, .972612E+05, .710132E+05,
     +  .518008E+05, .377459E+05, .274775E+05, .199800E+05,
     +  .145133E+05, .105298E+05, .763143E+04, .552397E+04,
     +  .399406E+04, .288415E+04, .208029E+04, .149850E+04,
     +  .107818E+04, .774679E+03, .556186E+03, .396946E+03,
     +  .284398E+03, .203567E+03, .145616E+03, .104104E+03,
     +  .744038E+02, .532295E+02, .380692E+02, .272517E+02,
     +  .195376E+02, .140327E+02, .101041E+02, .729446E+01,
     +  .528539E+01, .384212E+01, .280317E+01, .205257E+01,
     +  .150852E+01, .111213E+01, .823520E+00, .610127E+00,
     +  .453990E+00, .337730E+00, .251842E+00, .187922E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .140275E+00, .104678E+00, .780596E-01, .581323E-01,
     +  .432205E-01, .320660E-01, .237337E-01, .175153E-01,
     +  .128863E-01, .944711E-02, .689623E-02, .501902E-02,
     +  .362779E-02, .260784E-02, .186403E-02, .132408E-02,
     +  .934439E-03, .654745E-03, .455439E-03, .314329E-03,
     +  .215325E-03, .146308E-03, .991776E-04, .668014E-04,
     +  .450428E-04, .306179E-04, .211158E-04, .146329E-04,
     +  .100064E-04, .670501E-05, .434569E-05, .269593E-05,
     +  .156622E-05, .826848E-06, .377344E-06, .135729E-06,
     +  .319694E-07, .308048E-08, .000000E+00, .268058E+07,
     +  .200217E+07, .146632E+07, .107303E+07, .784608E+06,
     +  .573189E+06, .418389E+06, .305103E+06, .222294E+06,
     +  .161797E+06, .117654E+06, .854633E+05, .620185E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .449547E+05, .325517E+05, .235427E+05, .170083E+05,
     +  .122721E+05, .884461E+04, .636603E+04, .457658E+04,
     +  .328565E+04, .235597E+04, .168699E+04, .120647E+04,
     +  .861529E+03, .614695E+03, .435901E+03, .310312E+03,
     +  .220677E+03, .156816E+03, .111363E+03, .790520E+02,
     +  .561670E+02, .398894E+02, .283527E+02, .201811E+02,
     +  .143899E+02, .102854E+02, .737047E+01, .530074E+01,
     +  .382450E+01, .276942E+01, .201269E+01, .146816E+01,
     +  .107432E+01, .789668E+00, .580752E+00, .429003E+00,
     +  .316850E+00, .234601E+00, .173837E+00, .128868E+00,
     +  .955132E-01, .707481E-01, .523400E-01, .386612E-01,
     +  .285000E-01, .209611E-01, .153732E-01, .112411E-01,
     +  .819165E-02, .594437E-02, .430131E-02, .309153E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .221038E-02, .157187E-02, .111127E-02, .780924E-03,
     +  .545220E-03, .378215E-03, .260620E-03, .178522E-03,
     +  .121521E-03, .826969E-04, .560591E-04, .381241E-04,
     +  .261521E-04, .181421E-04, .125909E-04, .860466E-05,
     +  .574847E-05, .370335E-05, .227614E-05, .130503E-05,
     +  .676993E-06, .301938E-06, .105508E-06, .241299E-07,
     +  .236100E-08, .000000E+00, .402800E+05, .429082E+05,
     +  .336689E+05, .264197E+05, .207318E+05, .162690E+05,
     +  .127673E+05, .100197E+05, .786373E+04, .617202E+04,
     +  .484454E+04, .380284E+04, .298538E+04, .234387E+04,
     +  .184042E+04, .144530E+04, .113519E+04, .891775E+03,
     +  .700709E+03, .550720E+03, .432967E+03, .340514E+03,
     +  .267917E+03, .210904E+03, .166123E+03, .130943E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .103301E+03, .813033E+02, .642882E+02, .509049E+02,
     +  .403738E+02, .320826E+02, .255507E+02, .204143E+02,
     +  .163493E+02, .131383E+02, .105976E+02, .858318E+01,
     +  .698193E+01, .570468E+01, .468371E+01, .386286E+01,
     +  .320017E+01, .266245E+01, .222374E+01, .186369E+01,
     +  .156725E+01, .131889E+01, .111155E+01, .934577E+00,
     +  .783496E+00, .652816E+00, .539124E+00, .440154E+00,
     +  .354508E+00, .281279E+00, .219705E+00, .168922E+00,
     +  .127873E+00, .953357E-01, .700161E-01, .506483E-01,
     +  .360710E-01, .253123E-01, .174127E-01, .117463E-01,
     +  .775142E-02, .498776E-02, .311603E-02, .187881E-02,
     +  .108392E-02, .590296E-03, .296242E-03, .130264E-03,
     +  .440263E-04, .345107E-05, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=3901,3952) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .395960E+05, .579447E+05, .453923E+05,
     +  .355508E+05, .278455E+05, .218050E+05, .170763E+05,
     +  .133699E+05, .104688E+05, .819522E+04, .641594E+04,
     +  .502174E+04, .393085E+04, .307621E+04, .240763E+04,
     +  .188394E+04, .147435E+04, .115358E+04, .902748E+03,
     +  .706353E+03, .552817E+03, .432626E+03, .338681E+03,
     +  .265151E+03, .207685E+03, .162717E+03, .127579E+03,
     +  .997421E+02, .783356E+02, .615781E+02, .484784E+02,
     +  .382192E+02, .301933E+02, .239180E+02, .189895E+02,
     +  .151202E+02, .120832E+02, .969099E+01, .780565E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .631232E+01, .512936E+01, .418541E+01, .343043E+01,
     +  .282266E+01, .233161E+01, .193185E+01, .160598E+01,
     +  .133528E+01, .111182E+01, .923105E+00, .764212E+00,
     +  .628793E+00, .513083E+00, .414209E+00, .330320E+00,
     +  .259889E+00, .201676E+00, .154358E+00, .116594E+00,
     +  .869430E-01, .640457E-01, .466159E-01, .335275E-01,
     +  .238674E-01, .167503E-01, .116060E-01, .793711E-02,
     +  .535307E-02, .355912E-02, .232924E-02, .149929E-02,
     +  .945578E-03, .582815E-03, .345949E-03, .196521E-03,
     +  .101061E-03, .415348E-04, .537309E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .216840E-18,
     +  .000000E+00, .000000E+00, .542101E-19, .135525E-19,
     +  .000000E+00, .000000E+00, .211758E-21, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .100036E+06, .788592E+05, .614934E+05, .479388E+05,
     +  .373723E+05, .291266E+05, .227003E+05, .176868E+05,
     +  .137805E+05, .107338E+05, .836065E+04, .651024E+04,
     +  .506938E+04, .394623E+04, .307196E+04, .239068E+04,
     +  .186055E+04, .144757E+04, .112633E+04, .876179E+03,
     +  .681676E+03, .530266E+03, .412578E+03, .320994E+03,
     +  .249829E+03, .194470E+03, .151476E+03, .117621E+03,
     +  .917455E+02, .716158E+02, .559795E+02, .438124E+02,
     +  .343553E+02, .270098E+02, .212792E+02, .168105E+02,
     +  .133271E+02, .106020E+02, .846947E+01, .679227E+01,
     +  .547325E+01, .442838E+01, .359878E+01, .293588E+01,
     +  .240431E+01, .197476E+01, .162727E+01, .134083E+01,
     +  .110636E+01, .910109E+00, .746523E+00, .608662E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .492314E+00, .394192E+00, .312031E+00, .243918E+00,
     +  .188265E+00, .143489E+00, .108063E+00, .804459E-01,
     +  .592399E-01, .431673E-01, .311298E-01, .222598E-01,
     +  .157225E-01, .109880E-01, .759836E-02, .519653E-02,
     +  .351447E-02, .234735E-02, .154730E-02, .100299E-02,
     +  .637523E-03, .392076E-03, .232399E-03, .126981E-03,
     +  .593049E-04, .185358E-04, .492553E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .138993E+06,
     +  .109014E+06, .845196E+05, .655094E+05, .507724E+05,
     +  .393385E+05, .304777E+05, .236053E+05, .182814E+05,
     +  .141536E+05, .109572E+05, .847981E+04, .656216E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .507647E+04, .392694E+04, .303671E+04, .234821E+04,
     +  .181523E+04, .140322E+04, .108441E+04, .838097E+03,
     +  .647591E+03, .500461E+03, .386714E+03, .298901E+03,
     +  .231047E+03, .178703E+03, .137761E+03, .106679E+03,
     +  .826637E+02, .641367E+02, .498203E+02, .387688E+02,
     +  .302456E+02, .236425E+02, .185302E+02, .145733E+02,
     +  .115000E+02, .911224E+01, .724805E+01, .579263E+01,
     +  .464826E+01, .374627E+01, .303094E+01, .246154E+01,
     +  .200486E+01, .163819E+01, .133825E+01, .109474E+01,
     +  .892682E+00, .725850E+00, .586728E+00, .470637E+00,
     +  .373895E+00, .293848E+00, .228248E+00, .175209E+00,
     +  .132941E+00, .997709E-01, .740925E-01, .544877E-01,
     +  .396979E-01, .286579E-01, .205429E-01, .145688E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .102420E-01, .713994E-02, .493554E-02, .338444E-02,
     +  .230076E-02, .155097E-02, .103486E-02, .682816E-03,
     +  .442263E-03, .282215E-03, .173813E-03, .102099E-03,
     +  .575401E-04, .363297E-04, .232791E-04, .144460E-04,
     +  .861722E-05, .488758E-05, .261847E-05, .131123E-05,
     +  .598808E-06, .245834E-06, .864294E-07, .210998E-07,
     +  .178153E-10, .000000E+00, .192496E+06, .150186E+06,
     +  .115746E+06, .891737E+05, .686950E+05, .529009E+05,
     +  .407337E+05, .313539E+05, .241312E+05, .185657E+05,
     +  .142821E+05, .109828E+05, .844471E+04, .649075E+04,
     +  .498838E+04, .383233E+04, .294393E+04, .226067E+04,
     +  .173587E+04, .133247E+04, .102283E+04, .784934E+03,
     +  .602417E+03, .462265E+03, .354789E+03, .272308E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .209117E+03, .160029E+03, .123021E+03, .946265E+02,
     +  .728726E+02, .561816E+02, .433868E+02, .335897E+02,
     +  .260533E+02, .202604E+02, .158085E+02, .123760E+02,
     +  .972821E+01, .767619E+01, .608572E+01, .484438E+01,
     +  .387303E+01, .310839E+01, .250416E+01, .202312E+01,
     +  .163973E+01, .132848E+01, .107779E+01, .871534E+00,
     +  .702775E+00, .563442E+00, .448395E+00, .353575E+00,
     +  .275970E+00, .213040E+00, .162652E+00, .122848E+00,
     +  .918511E-01, .680129E-01, .499140E-01, .363236E-01,
     +  .262151E-01, .188055E-01, .133606E-01, .942075E-02,
     +  .659604E-02, .458640E-02, .316889E-02, .217483E-02,
     +  .148340E-02, .100433E-02, .674704E-03, .447485E-03,
     +  .294507E-03, .189648E-03, .119424E-03, .750191E-04 /
        DATA (UPDI(I),I=4265,4316) /
     +  .507103E-04, .345653E-04, .232439E-04, .153468E-04,
     +  .990042E-05, .620736E-05, .374204E-05, .211608E-05,
     +  .108584E-05, .469572E-06, .139568E-06, .110627E-07,
     +  .000000E+00, .172883E+06, .204569E+06, .156741E+06,
     +  .120051E+06, .919350E+05, .703767E+05, .538649E+05,
     +  .412109E+05, .315242E+05, .241047E+05, .184283E+05,
     +  .140828E+05, .107602E+05, .821811E+04, .627555E+04,
     +  .479019E+04, .365585E+04, .278901E+04, .212744E+04,
     +  .162220E+04, .123688E+04, .942794E+03, .718639E+03,
     +  .547661E+03, .417414E+03, .318132E+03, .242587E+03,
     +  .184302E+03, .140661E+03, .107410E+03, .821108E+02,
     +  .628357E+02, .481624E+02, .370068E+02, .284852E+02,
     +  .219820E+02, .170196E+02, .132210E+02, .103115E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .807312E+01, .635054E+01, .501585E+01, .397888E+01,
     +  .316852E+01, .253273E+01, .203021E+01, .163259E+01,
     +  .131220E+01, .105612E+01, .847158E+00, .677676E+00,
     +  .539067E+00, .425750E+00, .333313E+00, .258426E+00,
     +  .198293E+00, .150580E+00, .113202E+00, .843030E-01,
     +  .622203E-01, .455455E-01, .330827E-01, .238478E-01,
     +  .170994E-01, .121521E-01, .857830E-02, .601834E-02,
     +  .419724E-02, .291162E-02, .200852E-02, .137865E-02,
     +  .940730E-03, .638029E-03, .428471E-03, .286484E-03,
     +  .188612E-03, .122738E-03, .805726E-04, .556943E-04,
     +  .386412E-04, .265235E-04, .179157E-04, .118354E-04,
     +  .759144E-05, .466309E-05, .267188E-05, .137607E-05,
     +  .589198E-06, .171284E-06, .144541E-07, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .375491E+06, .289827E+06, .220622E+06, .167875E+06,
     +  .127708E+06, .971109E+05, .738254E+05, .560991E+05,
     +  .426179E+05, .323621E+05, .245678E+05, .186423E+05,
     +  .141422E+05, .107235E+05, .812914E+04, .615963E+04,
     +  .466613E+04, .353317E+04, .267471E+04, .202399E+04,
     +  .153133E+04, .115818E+04, .875877E+03, .662209E+03,
     +  .500672E+03, .378503E+03, .286265E+03, .215669E+03,
     +  .163226E+03, .123594E+03, .936781E+02, .710735E+02,
     +  .540031E+02, .411335E+02, .313821E+02, .240031E+02,
     +  .184182E+02, .141795E+02, .109595E+02, .850338E+01,
     +  .662882E+01, .518872E+01, .407907E+01, .321928E+01,
     +  .255024E+01, .202592E+01, .161450E+01, .128587E+01,
     +  .102553E+01, .815114E+00, .646142E+00, .509430E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .398895E+00, .309758E+00, .238346E+00, .181624E+00,
     +  .137064E+00, .102473E+00, .759433E-01, .558153E-01,
     +  .407093E-01, .294796E-01, .211950E-01, .151639E-01,
     +  .107559E-01, .757990E-02, .530895E-02, .369557E-02,
     +  .255730E-02, .175806E-02, .120065E-02, .813314E-03,
     +  .545843E-03, .361332E-03, .236886E-03, .151917E-03,
     +  .956288E-04, .602214E-04, .393223E-04, .255169E-04,
     +  .162397E-04, .100985E-04, .611099E-05, .358695E-05,
     +  .202640E-05, .107811E-05, .524766E-06, .216406E-06,
     +  .615407E-07, .473814E-08, .000000E+00, .524753E+06,
     +  .402882E+06, .304792E+06, .230483E+06, .174235E+06,
     +  .131650E+06, .994410E+05, .750752E+05, .566603E+05,
     +  .427410E+05, .322298E+05, .242913E+05, .183016E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .137818E+05, .103746E+05, .780567E+04, .587088E+04,
     +  .441342E+04, .331673E+04, .249137E+04, .187091E+04,
     +  .140438E+04, .105398E+04, .790746E+03, .593204E+03,
     +  .444930E+03, .333832E+03, .249459E+03, .187266E+03,
     +  .140636E+03, .105710E+03, .795323E+02, .599188E+02,
     +  .452519E+02, .342270E+02, .259529E+02, .197409E+02,
     +  .150652E+02, .115420E+02, .887691E+01, .685932E+01,
     +  .532220E+01, .414734E+01, .324458E+01, .254777E+01,
     +  .200618E+01, .158469E+01, .125090E+01, .988751E+00,
     +  .778836E+00, .611891E+00, .478216E+00, .371279E+00,
     +  .285985E+00, .218382E+00, .165243E+00, .123901E+00,
     +  .920950E-01, .678955E-01, .496687E-01, .360768E-01,
     +  .260309E-01, .186563E-01, .133114E-01, .942039E-02 /
        DATA (UPDI(I),I=4525,4576) /
     +  .662669E-02, .463498E-02, .322354E-02, .222965E-02,
     +  .153294E-02, .104759E-02, .710679E-03, .478169E-03,
     +  .318025E-03, .210027E-03, .136387E-03, .876529E-04,
     +  .567631E-04, .378016E-04, .250645E-04, .163924E-04,
     +  .105384E-04, .662056E-05, .404219E-05, .236603E-05,
     +  .129367E-05, .635579E-06, .257624E-06, .700513E-07,
     +  .592435E-08, .000000E+00, .719318E+06, .549496E+06,
     +  .413286E+06, .310687E+06, .233467E+06, .175345E+06,
     +  .131639E+06, .987727E+05, .740810E+05, .555304E+05,
     +  .416072E+05, .311570E+05, .233214E+05, .174461E+05,
     +  .130453E+05, .974884E+04, .728227E+04, .543661E+04,
     +  .405707E+04, .302591E+04, .225604E+04, .168120E+04,
     +  .125247E+04, .932682E+03, .694420E+03, .516878E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .384828E+03, .285297E+03, .212480E+03, .158302E+03,
     +  .118031E+03, .880798E+02, .658124E+02, .492921E+02,
     +  .369708E+02, .277976E+02, .209647E+02, .158632E+02,
     +  .120497E+02, .918825E+01, .703920E+01, .541514E+01,
     +  .418369E+01, .324506E+01, .252630E+01, .197216E+01,
     +  .154438E+01, .120843E+01, .946834E+00, .739260E+00,
     +  .575731E+00, .446099E+00, .343458E+00, .262446E+00,
     +  .198897E+00, .149443E+00, .111327E+00, .822572E-01,
     +  .603130E-01, .439036E-01, .317459E-01, .228128E-01,
     +  .162892E-01, .115836E-01, .817296E-02, .573408E-02,
     +  .400155E-02, .277776E-02, .191841E-02, .131760E-02,
     +  .899976E-03, .610724E-03, .411490E-03, .274613E-03,
     +  .182422E-03, .119692E-03, .782160E-04, .517132E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .349577E-04, .235524E-04, .156955E-04, .103050E-04,
     +  .661342E-05, .411857E-05, .244721E-05, .134966E-05,
     +  .661871E-06, .264386E-06, .701600E-07, .620750E-08,
     +  .000000E+00, .968277E+06, .736168E+06, .550609E+06,
     +  .411598E+06, .307542E+06, .229653E+06, .171410E+06,
     +  .127858E+06, .953251E+05, .710250E+05, .528926E+05,
     +  .393638E+05, .292802E+05, .217653E+05, .161708E+05,
     +  .120062E+05, .890964E+04, .660732E+04, .489751E+04,
     +  .362784E+04, .268613E+04, .198770E+04, .147031E+04,
     +  .108704E+04, .803462E+03, .593628E+03, .438674E+03,
     +  .322726E+03, .238520E+03, .176330E+03, .130444E+03,
     +  .965746E+02, .715829E+02, .531834E+02, .395649E+02,
     +  .295046E+02, .220687E+02, .165605E+02, .124749E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .943339E+01, .716681E+01, .546739E+01, .418879E+01,
     +  .322189E+01, .248722E+01, .192527E+01, .149490E+01,
     +  .115969E+01, .900848E+00, .697282E+00, .538387E+00,
     +  .413649E+00, .315861E+00, .239459E+00, .180120E+00,
     +  .134386E+00, .994572E-01, .730429E-01, .532570E-01,
     +  .385672E-01, .277540E-01, .198562E-01, .141199E-01,
     +  .100029E-01, .703289E-02, .491854E-02, .342264E-02,
     +  .236997E-02, .163330E-02, .111994E-02, .764143E-03,
     +  .518421E-03, .349631E-03, .234003E-03, .156258E-03,
     +  .103467E-03, .685637E-04, .460584E-04, .314892E-04,
     +  .214590E-04, .144751E-04, .961931E-05, .623721E-05,
     +  .391228E-05, .232947E-05, .127971E-05, .619873E-06,
     +  .242145E-06, .624788E-07, .568653E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .128140E+07, .969821E+06, .721505E+06, .536450E+06,
     +  .398649E+06, .296050E+06, .219736E+06, .162982E+06,
     +  .120819E+06, .894999E+05, .662609E+05, .490208E+05,
     +  .362446E+05, .267786E+05, .197729E+05, .145891E+05,
     +  .107579E+05, .792688E+04, .583744E+04, .429566E+04,
     +  .315939E+04, .232211E+04, .170590E+04, .125247E+04,
     +  .919215E+03, .674297E+03, .494683E+03, .361231E+03,
     +  .265000E+03, .194439E+03, .142749E+03, .104875E+03,
     +  .771322E+02, .568592E+02, .419652E+02, .310459E+02,
     +  .230355E+02, .171471E+02, .128124E+02, .961019E+01,
     +  .724189E+01, .547979E+01, .416407E+01, .317672E+01,
     +  .243220E+01, .186712E+01, .143771E+01, .110593E+01,
     +  .851847E+00, .653759E+00, .500531E+00, .381378E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .288866E+00, .217292E+00, .162235E+00, .120197E+00,
     +  .883739E-01, .645066E-01, .467644E-01, .336851E-01,
     +  .241200E-01, .171760E-01, .121604E-01, .857934E-02,
     +  .600886E-02, .418755E-02, .290464E-02, .200557E-02,
     +  .137879E-02, .943610E-03, .643007E-03, .436081E-03,
     +  .294375E-03, .197582E-03, .132611E-03, .885642E-04,
     +  .594063E-04, .404165E-04, .278752E-04, .191524E-04,
     +  .130190E-04, .870755E-05, .566742E-05, .355573E-05,
     +  .210738E-05, .114604E-05, .545527E-06, .207621E-06,
     +  .519754E-07, .483497E-08, .000000E+00, .166892E+07,
     +  .125763E+07, .930825E+06, .688503E+06, .508964E+06,
     +  .375972E+06, .277559E+06, .204754E+06, .150950E+06,
     +  .111198E+06, .818611E+05, .602164E+05, .442647E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .325125E+05, .238640E+05, .175018E+05, .128269E+05,
     +  .939297E+04, .687370E+04, .502608E+04, .367276E+04,
     +  .268179E+04, .195707E+04, .142722E+04, .104034E+04,
     +  .757862E+03, .552094E+03, .400255E+03, .291519E+03,
     +  .212343E+03, .154746E+03, .112844E+03, .823686E+02,
     +  .602596E+02, .441338E+02, .323981E+02, .238518E+02,
     +  .176160E+02, .130594E+02, .971832E+01, .726549E+01,
     +  .545407E+01, .411154E+01, .311159E+01, .236318E+01,
     +  .179941E+01, .137428E+01, .104839E+01, .800836E+00,
     +  .609482E+00, .462769E+00, .349729E+00, .262787E+00,
     +  .196157E+00, .145381E+00, .106962E+00, .781283E-01,
     +  .566773E-01, .408508E-01, .292655E-01, .208481E-01,
     +  .147745E-01, .104123E-01, .731438E-02, .510218E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .354244E-02, .244884E-02, .168578E-02, .115599E-02,
     +  .789585E-03, .537391E-03, .364377E-03, .246262E-03,
     +  .165797E-03, .111861E-03, .753204E-04, .510674E-04,
     +  .351007E-04, .243718E-04, .168394E-04, .114965E-04,
     +  .770809E-05, .501417E-05, .313292E-05, .184079E-05,
     +  .987447E-06, .460620E-06, .170496E-06, .413924E-07,
     +  .392268E-08, .000000E+00, .214124E+07, .160681E+07,
     +  .118338E+07, .870937E+06, .640567E+06, .470766E+06,
     +  .345740E+06, .253714E+06, .186050E+06, .136319E+06,
     +  .998074E+05, .730126E+05, .533710E+05, .389791E+05,
     +  .284461E+05, .207409E+05, .151111E+05, .109995E+05,
     +  .800048E+04, .581401E+04, .422202E+04, .306334E+04,
     +  .222117E+04, .160928E+04, .116530E+04, .843194E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .610087E+03, .439215E+03, .317668E+03, .229761E+03,
     +  .166244E+03, .120355E+03, .872098E+02, .633327E+02,
     +  .460393E+02, .335437E+02, .245086E+02, .179637E+02,
     +  .132155E+02, .975909E+01, .723980E+01, .539277E+01,
     +  .403373E+01, .302884E+01, .228220E+01, .172391E+01,
     +  .130608E+01, .988261E+00, .748750E+00, .565164E+00,
     +  .425623E+00, .319075E+00, .237873E+00, .176215E+00,
     +  .129653E+00, .947323E-01, .687438E-01, .495621E-01,
     +  .355143E-01, .253024E-01, .179310E-01, .126446E-01,
     +  .886951E-02, .620307E-02, .430904E-02, .298035E-02,
     +  .205318E-02, .140916E-02, .963895E-03, .657178E-03,
     +  .446829E-03, .303005E-03, .205107E-03, .138560E-03,
     +  .939888E-04, .637845E-04, .436541E-04, .302510E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .211068E-04, .146328E-04, .100064E-04, .670501E-05,
     +  .434569E-05, .269593E-05, .156622E-05, .826848E-06,
     +  .377344E-06, .135729E-06, .319694E-07, .308048E-08,
     +  .000000E+00, .270864E+07, .202441E+07, .148377E+07,
     +  .108673E+07, .795363E+06, .581631E+06, .425017E+06,
     +  .310306E+06, .226379E+06, .165004E+06, .120172E+06,
     +  .874406E+05, .635714E+05, .461742E+05, .335095E+05,
     +  .242951E+05, .175993E+05, .127364E+05, .920942E+04,
     +  .665268E+04, .480184E+04, .346267E+04, .249510E+04,
     +  .179634E+04, .129243E+04, .929101E+03, .667820E+03,
     +  .477529E+03, .343048E+03, .246424E+03, .177067E+03,
     +  .127294E+03, .915853E+02, .660363E+02, .476582E+02,
     +  .344707E+02, .250012E+02, .181896E+02, .132823E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .973531E+01, .716798E+01, .529900E+01, .393347E+01,
     +  .293096E+01, .219138E+01, .164237E+01, .123452E+01,
     +  .926635E+00, .696430E+00, .521425E+00, .389536E+00,
     +  .289714E+00, .214315E+00, .157576E+00, .115107E+00,
     +  .835285E-01, .602200E-01, .431495E-01, .307387E-01,
     +  .217788E-01, .153529E-01, .107726E-01, .752062E-02,
     +  .523625E-02, .362227E-02, .249581E-02, .171354E-02,
     +  .117263E-02, .800247E-03, .544748E-03, .370141E-03,
     +  .251134E-03, .170336E-03, .115501E-03, .787790E-04,
     +  .538578E-04, .371585E-04, .259117E-04, .181363E-04,
     +  .125909E-04, .860466E-05, .574847E-05, .370335E-05,
     +  .227614E-05, .130503E-05, .676993E-06, .301938E-06,
     +  .105508E-06, .241299E-07, .236100E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .402977E+05, .427969E+05, .335715E+05, .263346E+05,
     +  .206574E+05, .162039E+05, .127104E+05, .997001E+04,
     +  .782035E+04, .613412E+04, .481144E+04, .377394E+04,
     +  .296015E+04, .232185E+04, .182121E+04, .142854E+04,
     +  .112057E+04, .879032E+03, .689603E+03, .541043E+03,
     +  .424539E+03, .333175E+03, .261528E+03, .205343E+03,
     +  .161284E+03, .126733E+03, .996378E+02, .781218E+02,
     +  .615180E+02, .484913E+02, .382687E+02, .302438E+02,
     +  .239411E+02, .190010E+02, .151045E+02, .120368E+02,
     +  .961760E+01, .770547E+01, .618981E+01, .498368E+01,
     +  .402126E+01, .324836E+01, .262478E+01, .211906E+01,
     +  .170700E+01, .137007E+01, .109502E+01, .868462E+00,
     +  .684910E+00, .535621E+00, .416931E+00, .323723E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .251858E+00, .197375E+00, .156508E+00, .125842E+00,
     +  .102494E+00, .842395E-01, .695068E-01, .572771E-01,
     +  .469342E-01, .381187E-01, .306151E-01, .243037E-01,
     +  .190015E-01, .146383E-01, .111027E-01, .828390E-02,
     +  .607427E-02, .437239E-02, .308551E-02, .213118E-02,
     +  .143764E-02, .944447E-03, .605129E-03, .374434E-03,
     +  .223505E-03, .128032E-03, .699271E-04, .361144E-04,
     +  .174499E-04, .778902E-05, .313262E-05, .111344E-05,
     +  .334810E-06, .800439E-07, .137005E-07, .137750E-08,
     +  .520100E-10, .174554E-12, .000000E+00, .396122E+05,
     +  .578229E+05, .452858E+05, .354577E+05, .277641E+05,
     +  .217339E+05, .170142E+05, .133157E+05, .104214E+05,
     +  .815385E+04, .637981E+04, .499021E+04, .390334E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .305222E+04, .238671E+04, .186570E+04, .145845E+04,
     +  .113973E+04, .890682E+03, .695848E+03, .543673E+03,
     +  .424670E+03, .331761E+03, .259133E+03, .202453E+03,
     +  .158168E+03, .123624E+03, .963098E+02, .753495E+02,
     +  .589786E+02, .462128E+02, .362419E+02, .284641E+02,
     +  .224012E+02, .176548E+02, .139407E+02, .110356E+02,
     +  .875475E+01, .696309E+01, .554833E+01, .443084E+01,
     +  .354158E+01, .283234E+01, .226337E+01, .180597E+01,
     +  .143658E+01, .113949E+01, .898005E+00, .705324E+00,
     +  .550501E+00, .428842E+00, .333942E+00, .261020E+00,
     +  .205504E+00, .163492E+00, .131471E+00, .106731E+00,
     +  .871434E-01, .712928E-01, .581772E-01, .472183E-01,
     +  .380072E-01, .302933E-01, .239027E-01, .186072E-01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .142952E-01, .108338E-01, .809103E-02, .595068E-02,
     +  .430304E-02, .305567E-02, .212485E-02, .144366E-02,
     +  .951452E-03, .608215E-03, .369643E-03, .209567E-03,
     +  .105774E-03, .410227E-04, .348076E-05, .346945E-17,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .998880E+05, .787294E+05,
     +  .613800E+05, .478397E+05, .372857E+05, .290510E+05,
     +  .226342E+05, .176290E+05, .137301E+05, .106898E+05,
     +  .832226E+04, .647675E+04, .504017E+04, .392076E+04,
     +  .304976E+04, .237133E+04, .184369E+04, .143290E+04,
     +  .111356E+04, .865064E+03, .672007E+03, .521859E+03,
     +  .405270E+03, .314643E+03, .244310E+03, .189676E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .147311E+03, .114009E+03, .886050E+02, .688839E+02,
     +  .536003E+02, .417377E+02, .325423E+02, .254210E+02,
     +  .198827E+02, .155780E+02, .122340E+02, .962707E+01,
     +  .759418E+01, .600106E+01, .475264E+01, .376742E+01,
     +  .298842E+01, .236921E+01, .187621E+01, .148201E+01,
     +  .116822E+01, .915726E+00, .716310E+00, .557509E+00,
     +  .433674E+00, .337592E+00, .263938E+00, .207808E+00,
     +  .165152E+00, .132440E+00, .107017E+00, .868308E-01,
     +  .705185E-01, .570956E-01, .459785E-01, .367328E-01,
     +  .290740E-01, .227980E-01, .176481E-01, .134917E-01,
     +  .101816E-01, .757677E-02, .555603E-02, .400782E-02,
     +  .284015E-02, .197135E-02, .133676E-02, .878595E-03,
     +  .559520E-03, .337707E-03, .189114E-03, .930800E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .336746E-04, .128439E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .138836E+06, .108877E+06, .843994E+05,
     +  .654044E+05, .506807E+05, .392583E+05, .304078E+05,
     +  .235442E+05, .182281E+05, .141071E+05, .109166E+05,
     +  .844441E+04, .653130E+04, .504957E+04, .390351E+04,
     +  .301630E+04, .233044E+04, .179976E+04, .138976E+04,
     +  .107271E+04, .827925E+03, .638752E+03, .492782E+03,
     +  .380046E+03, .293111E+03, .226020E+03, .174339E+03,
     +  .133978E+03, .103393E+03, .798078E+02, .616515E+02,
     +  .476550E+02, .368785E+02, .285907E+02, .221896E+02,
     +  .172498E+02, .134395E+02, .104909E+02, .820858E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .643376E+01, .505391E+01, .397391E+01, .312715E+01,
     +  .246008E+01, .193380E+01, .151695E+01, .118829E+01,
     +  .926317E+00, .721333E+00, .559462E+00, .434122E+00,
     +  .337382E+00, .263428E+00, .207083E+00, .164170E+00,
     +  .131159E+00, .105436E+00, .850114E-01, .685557E-01,
     +  .550989E-01, .440471E-01, .349447E-01, .274793E-01,
     +  .214220E-01, .164970E-01, .125561E-01, .944210E-02,
     +  .700879E-02, .513280E-02, .370309E-02, .262951E-02,
     +  .183359E-02, .125332E-02, .834872E-03, .543181E-03,
     +  .339702E-03, .202570E-03, .112889E-03, .563511E-04,
     +  .249237E-04, .144463E-04, .861721E-05, .488757E-05,
     +  .261847E-05, .131123E-05, .598807E-06, .245833E-06,
     +  .864292E-07, .210998E-07, .178117E-10, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .192330E+06, .150041E+06, .115619E+06, .890628E+05,
     +  .685981E+05, .528163E+05, .406599E+05, .312895E+05,
     +  .240750E+05, .185167E+05, .142393E+05, .109455E+05,
     +  .841222E+04, .646245E+04, .496373E+04, .381088E+04,
     +  .292526E+04, .224443E+04, .172175E+04, .132020E+04,
     +  .101217E+04, .775675E+03, .594379E+03, .455289E+03,
     +  .348736E+03, .267056E+03, .204561E+03, .156084E+03,
     +  .119596E+03, .916524E+02, .702869E+02, .539309E+02,
     +  .414238E+02, .318733E+02, .245482E+02, .189360E+02,
     +  .146380E+02, .113364E+02, .879976E+01, .684229E+01,
     +  .533220E+01, .415983E+01, .324813E+01, .253608E+01,
     +  .197919E+01, .154205E+01, .120046E+01, .930615E+00,
     +  .721272E+00, .557251E+00, .431083E+00, .334196E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .260350E+00, .204144E+00, .161305E+00, .128310E+00,
     +  .102586E+00, .821949E-01, .658305E-01, .525353E-01,
     +  .417028E-01, .328614E-01, .256757E-01, .198976E-01,
     +  .152397E-01, .115427E-01, .864324E-02, .639321E-02,
     +  .466929E-02, .336286E-02, .238668E-02, .166613E-02,
     +  .114251E-02, .766024E-03, .503871E-03, .321002E-03,
     +  .197551E-03, .116385E-03, .648332E-04, .357059E-04,
     +  .232443E-04, .153468E-04, .990042E-05, .620736E-05,
     +  .374204E-05, .211608E-05, .108584E-05, .469571E-06,
     +  .139568E-06, .110627E-07, .000000E+00, .172893E+06,
     +  .204416E+06, .156607E+06, .119934E+06, .918330E+05,
     +  .702877E+05, .537873E+05, .411431E+05, .314651E+05,
     +  .240532E+05, .183833E+05, .140437E+05, .107261E+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .818841E+04, .624970E+04, .476770E+04, .363629E+04,
     +  .277200E+04, .211266E+04, .160937E+04, .122574E+04,
     +  .933122E+03, .710248E+03, .540384E+03, .411104E+03,
     +  .312662E+03, .237844E+03, .180200E+03, .137102E+03,
     +  .104322E+03, .794287E+02, .605035E+02, .461306E+02,
     +  .352323E+02, .269315E+02, .206171E+02, .158156E+02,
     +  .121541E+02, .936139E+01, .722261E+01, .558513E+01,
     +  .432386E+01, .335081E+01, .259713E+01, .201260E+01,
     +  .155766E+01, .120519E+01, .929091E+00, .716610E+00,
     +  .551362E+00, .425043E+00, .328521E+00, .255184E+00,
     +  .199456E+00, .156992E+00, .124293E+00, .988217E-01,
     +  .786853E-01, .625987E-01, .496150E-01, .391170E-01,
     +  .306211E-01, .237745E-01, .183151E-01, .139496E-01 /
        DATA (UPDI(I),I=5617,5668) /
     +  .105115E-01, .783453E-02, .577125E-02, .420024E-02,
     +  .301659E-02, .213678E-02, .149049E-02, .102275E-02,
     +  .687736E-03, .455001E-03, .292962E-03, .183633E-03,
     +  .111607E-03, .657522E-04, .394405E-04, .265238E-04,
     +  .179157E-04, .118354E-04, .759143E-05, .466309E-05,
     +  .267188E-05, .137607E-05, .589198E-06, .171284E-06,
     +  .144541E-07, .000000E+00, .375305E+06, .289664E+06,
     +  .220480E+06, .167752E+06, .127600E+06, .970166E+05,
     +  .737431E+05, .560273E+05, .425553E+05, .323076E+05,
     +  .245202E+05, .186009E+05, .141062E+05, .106922E+05,
     +  .810185E+04, .613591E+04, .464551E+04, .351526E+04,
     +  .265915E+04, .201049E+04, .151962E+04, .114803E+04,
     +  .867073E+03, .654580E+03, .494063E+03, .372778E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .281307E+03, .211384E+03, .159514E+03, .120376E+03,
     +  .908863E+02, .686490E+02, .518941E+02, .392945E+02,
     +  .297748E+02, .225941E+02, .171784E+02, .130841E+02,
     +  .998741E+01, .763684E+01, .585285E+01, .449129E+01,
     +  .345038E+01, .265183E+01, .203831E+01, .156546E+01,
     +  .120258E+01, .921039E+00, .706288E+00, .540662E+00,
     +  .414935E+00, .319414E+00, .247113E+00, .192311E+00,
     +  .150605E+00, .118537E+00, .936128E-01, .739917E-01,
     +  .584069E-01, .459261E-01, .359209E-01, .279003E-01,
     +  .214963E-01, .164373E-01, .124276E-01, .929748E-02,
     +  .688019E-02, .503181E-02, .363489E-02, .259016E-02,
     +  .181909E-02, .125679E-02, .852796E-03, .565842E-03,
     +  .368182E-03, .232027E-03, .141356E-03, .826477E-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .462681E-04, .260610E-04, .162400E-04, .100985E-04,
     +  .611098E-05, .358695E-05, .202640E-05, .107811E-05,
     +  .524766E-06, .216406E-06, .615407E-07, .473814E-08,
     +  .000000E+00, .524556E+06, .402710E+06, .304642E+06,
     +  .230352E+06, .174120E+06, .131551E+06, .993539E+05,
     +  .749993E+05, .565941E+05, .426833E+05, .321796E+05,
     +  .242476E+05, .182636E+05, .137487E+05, .103458E+05,
     +  .778069E+04, .584918E+04, .439459E+04, .330039E+04,
     +  .247719E+04, .185862E+04, .139374E+04, .104476E+04,
     +  .782763E+03, .586295E+03, .438951E+03, .328659E+03,
     +  .244993E+03, .183401E+03, .137290E+03, .102812E+03,
     +  .770184E+02, .577354E+02, .433514E+02, .325694E+02,
     +  .245031E+02, .184686E+02, .139447E+02, .105514E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .799774E+01, .607611E+01, .462250E+01, .352101E+01,
     +  .268375E+01, .204634E+01, .155965E+01, .118958E+01,
     +  .905059E+00, .689886E+00, .525266E+00, .401156E+00,
     +  .307406E+00, .236741E+00, .183347E+00, .142801E+00,
     +  .111706E+00, .876160E-01, .687447E-01, .538480E-01,
     +  .420119E-01, .326038E-01, .251314E-01, .192189E-01,
     +  .145906E-01, .109548E-01, .814132E-02, .598650E-02,
     +  .435207E-02, .312619E-02, .221620E-02, .154927E-02,
     +  .106626E-02, .721444E-03, .478142E-03, .311453E-03,
     +  .197265E-03, .121559E-03, .726940E-04, .424777E-04,
     +  .254242E-04, .163926E-04, .105384E-04, .662055E-05,
     +  .404219E-05, .236602E-05, .129367E-05, .635579E-06,
     +  .257624E-06, .700513E-07, .592435E-08, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .719109E+06, .549314E+06, .413126E+06, .310548E+06,
     +  .233346E+06, .175239E+06, .131547E+06, .986925E+05,
     +  .740111E+05, .554696E+05, .415543E+05, .311110E+05,
     +  .232813E+05, .174113E+05, .130150E+05, .972257E+04,
     +  .725947E+04, .541683E+04, .403992E+04, .301105E+04,
     +  .224317E+04, .167006E+04, .124283E+04, .924343E+03,
     +  .687209E+03, .510644E+03, .379441E+03, .280651E+03,
     +  .208465E+03, .154831E+03, .115027E+03, .854794E+02,
     +  .635577E+02, .473334E+02, .352661E+02, .263104E+02,
     +  .196635E+02, .147211E+02, .110439E+02, .829980E+01,
     +  .625201E+01, .471627E+01, .356257E+01, .269339E+01,
     +  .203752E+01, .154124E+01, .116720E+01, .882156E+00,
     +  .668350E+00, .506040E+00, .384491E+00, .293200E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .224691E+00, .173110E+00, .134056E+00, .104203E+00,
     +  .811684E-01, .632209E-01, .491450E-01, .380485E-01,
     +  .293015E-01, .224161E-01, .170158E-01, .128256E-01,
     +  .956243E-02, .705892E-02, .515719E-02, .372623E-02,
     +  .266113E-02, .187642E-02, .130541E-02, .894766E-03,
     +  .603564E-03, .399474E-03, .260432E-03, .165720E-03,
     +  .103200E-03, .629650E-04, .380922E-04, .237890E-04,
     +  .156957E-04, .103050E-04, .661342E-05, .411856E-05,
     +  .244721E-05, .134966E-05, .661871E-06, .264386E-06,
     +  .701599E-07, .620750E-08, .000000E+00, .968056E+06,
     +  .735975E+06, .550440E+06, .411451E+06, .307414E+06,
     +  .229542E+06, .171312E+06, .127773E+06, .952515E+05,
     +  .709609E+05, .528368E+05, .393153E+05, .292380E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .217287E+05, .161390E+05, .119787E+05, .888571E+04,
     +  .658658E+04, .487954E+04, .361228E+04, .267267E+04,
     +  .197606E+04, .146024E+04, .107835E+04, .795949E+03,
     +  .587141E+03, .433073E+03, .317903E+03, .234356E+03,
     +  .172736E+03, .127339E+03, .938907E+02, .692603E+02,
     +  .511698E+02, .378167E+02, .279836E+02, .207421E+02,
     +  .154003E+02, .114575E+02, .853904E+01, .637884E+01,
     +  .477233E+01, .357558E+01, .268171E+01, .201300E+01,
     +  .151138E+01, .113655E+01, .853311E+00, .642543E+00,
     +  .483738E+00, .365592E+00, .277362E+00, .211453E+00,
     +  .162022E+00, .124727E+00, .963290E-01, .745163E-01,
     +  .576183E-01, .444537E-01, .341560E-01, .261051E-01,
     +  .198224E-01, .149369E-01, .111785E-01, .827646E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .606868E-02, .440512E-02, .316325E-02, .224591E-02,
     +  .157512E-02, .109050E-02, .744432E-03, .500677E-03,
     +  .330965E-03, .215985E-03, .138083E-03, .868590E-04,
     +  .539618E-04, .335840E-04, .216142E-04, .144752E-04,
     +  .961930E-05, .623721E-05, .391228E-05, .232947E-05,
     +  .127971E-05, .619873E-06, .242145E-06, .624788E-07,
     +  .568653E-08, .000000E+00, .128117E+07, .969617E+06,
     +  .721327E+06, .536295E+06, .398514E+06, .295932E+06,
     +  .219633E+06, .162893E+06, .120741E+06, .894324E+05,
     +  .662022E+05, .489698E+05, .362003E+05, .267401E+05,
     +  .197395E+05, .145602E+05, .107328E+05, .790516E+04,
     +  .581864E+04, .427940E+04, .314533E+04, .230995E+04,
     +  .169540E+04, .124341E+04, .911399E+03, .667556E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .488871E+03, .356232E+03, .260691E+03, .190725E+03,
     +  .139545E+03, .102111E+03, .747452E+02, .547945E+02,
     +  .401772E+02, .294948E+02, .216871E+02, .159724E+02,
     +  .117868E+02, .871329E+01, .645629E+01, .479139E+01,
     +  .356129E+01, .265016E+01, .197421E+01, .147141E+01,
     +  .109881E+01, .819550E+00, .613337E+00, .459092E+00,
     +  .345076E+00, .260411E+00, .197463E+00, .150451E+00,
     +  .115118E+00, .883307E-01, .678572E-01, .520911E-01,
     +  .398916E-01, .304220E-01, .230782E-01, .173955E-01,
     +  .130133E-01, .967036E-02, .711048E-02, .517904E-02,
     +  .373528E-02, .266588E-02, .188188E-02, .131284E-02,
     +  .904656E-03, .615197E-03, .412671E-03, .272553E-03,
     +  .178125E-03, .114457E-03, .727208E-04, .459377E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .292708E-04, .192539E-04, .130191E-04, .870754E-05,
     +  .566742E-05, .355573E-05, .210738E-05, .114604E-05,
     +  .545527E-06, .207621E-06, .519754E-07, .483497E-08,
     +  .000000E+00, .166867E+07, .125741E+07, .930637E+06,
     +  .688340E+06, .508822E+06, .375848E+06, .277451E+06,
     +  .204660E+06, .150868E+06, .111127E+06, .817994E+05,
     +  .601628E+05, .442182E+05, .324721E+05, .238290E+05,
     +  .174715E+05, .128006E+05, .937024E+04, .685405E+04,
     +  .500909E+04, .365809E+04, .266912E+04, .194615E+04,
     +  .141780E+04, .103222E+04, .750868E+03, .546072E+03,
     +  .395082E+03, .287067E+03, .208512E+03, .151448E+03,
     +  .110004E+03, .799211E+02, .581477E+02, .423099E+02,
     +  .308209E+02, .224855E+02, .164306E+02, .120293E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .882219E+01, .648529E+01, .477508E+01, .352153E+01,
     +  .260055E+01, .192281E+01, .142279E+01, .105522E+01,
     +  .781903E+00, .581579E+00, .432796E+00, .323510E+00,
     +  .242813E+00, .183104E+00, .138706E+00, .105480E+00,
     +  .804074E-01, .613450E-01, .467556E-01, .355437E-01,
     +  .269069E-01, .202620E-01, .151624E-01, .112618E-01,
     +  .831065E-02, .606914E-02, .439156E-02, .314736E-02,
     +  .223284E-02, .156736E-02, .108787E-02, .746317E-03,
     +  .505754E-03, .338524E-03, .223511E-03, .146378E-03,
     +  .945818E-04, .606985E-04, .389374E-04, .252986E-04,
     +  .169056E-04, .114966E-04, .770809E-05, .501417E-05,
     +  .313291E-05, .184079E-05, .987447E-06, .460620E-06,
     +  .170496E-06, .413923E-07, .392268E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .214098E+07, .160659E+07, .118318E+07, .870765E+06,
     +  .640417E+06, .470635E+06, .345626E+06, .253615E+06,
     +  .185964E+06, .136244E+06, .997425E+05, .729563E+05,
     +  .533221E+05, .389368E+05, .284095E+05, .207092E+05,
     +  .150836E+05, .109757E+05, .797996E+04, .579629E+04,
     +  .420673E+04, .305016E+04, .220981E+04, .159949E+04,
     +  .115688E+04, .835949E+03, .603858E+03, .433873E+03,
     +  .313077E+03, .225817E+03, .162856E+03, .117443E+03,
     +  .847060E+02, .611778E+02, .441838E+02, .319443E+02,
     +  .231284E+02, .167713E+02, .121843E+02, .886699E+01,
     +  .646794E+01, .472572E+01, .345861E+01, .253498E+01,
     +  .186063E+01, .136704E+01, .100703E+01, .741367E+00,
     +  .548066E+00, .405484E+00, .301400E+00, .224971E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .168697E+00, .127046E+00, .960143E-01, .727131E-01,
     +  .550948E-01, .416948E-01, .314677E-01, .236489E-01,
     +  .176800E-01, .131361E-01, .968834E-02, .710058E-02,
     +  .515080E-02, .370307E-02, .263759E-02, .186032E-02,
     +  .129884E-02, .897162E-03, .612987E-03, .414144E-03,
     +  .276764E-03, .182793E-03, .120040E-03, .780349E-04,
     +  .505797E-04, .329036E-04, .217204E-04, .146759E-04,
     +  .100064E-04, .670501E-05, .434569E-05, .269593E-05,
     +  .156622E-05, .826848E-06, .377344E-06, .135729E-06,
     +  .319694E-07, .308048E-08, .000000E+00, .270836E+07,
     +  .202417E+07, .148356E+07, .108655E+07, .795204E+06,
     +  .581494E+06, .424897E+06, .310202E+06, .226289E+06,
     +  .164926E+06, .120104E+06, .873816E+05, .635202E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .461299E+05, .334712E+05, .242619E+05, .175706E+05,
     +  .127117E+05, .918803E+04, .663422E+04, .478593E+04,
     +  .344897E+04, .248331E+04, .178620E+04, .128371E+04,
     +  .921608E+03, .661386E+03, .472020E+03, .338322E+03,
     +  .242372E+03, .173592E+03, .124315E+03, .890298E+02,
     +  .638430E+02, .457754E+02, .328534E+02, .236111E+02,
     +  .169940E+02, .122537E+02, .885041E+01, .640726E+01,
     +  .464627E+01, .337516E+01, .245570E+01, .178953E+01,
     +  .130566E+01, .955419E+00, .698879E+00, .513527E+00,
     +  .377721E+00, .279184E+00, .207227E+00, .154509E+00,
     +  .115673E+00, .868758E-01, .653627E-01, .491883E-01,
     +  .369644E-01, .276990E-01, .206681E-01, .153419E-01,
     +  .113191E-01, .829067E-02, .603546E-02, .434951E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .310737E-02, .220007E-02, .154306E-02, .107183E-02,
     +  .737052E-03, .501761E-03, .338151E-03, .225760E-03,
     +  .149254E-03, .983462E-04, .643442E-04, .421103E-04,
     +  .277367E-04, .185412E-04, .126188E-04, .860470E-05,
     +  .574847E-05, .370335E-05, .227614E-05, .130503E-05,
     +  .676992E-06, .301938E-06, .105508E-06, .241299E-07,
     +  .236100E-08, .000000E+00, .157009E+05, .133690E+05,
     +  .113439E+05, .962557E+04, .816753E+04, .693036E+04,
     +  .588061E+04, .498987E+04, .423408E+04, .359278E+04,
     +  .304863E+04, .258692E+04, .219516E+04, .186275E+04,
     +  .158070E+04, .134139E+04, .113834E+04, .966057E+03,
     +  .819882E+03, .695861E+03, .590637E+03, .501364E+03,
     +  .425626E+03, .361372E+03, .306863E+03, .260624E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .221400E+03, .187696E+03, .159555E+03, .135686E+03,
     +  .115442E+03, .982746E+02, .837168E+02, .714071E+02,
     +  .609433E+02, .520757E+02, .445603E+02, .381898E+02,
     +  .327876E+02, .282018E+02, .243113E+02, .210012E+02,
     +  .181817E+02, .157755E+02, .137173E+02, .119525E+02,
     +  .104405E+02, .912841E+01, .800042E+01, .701584E+01,
     +  .616247E+01, .541780E+01, .476627E+01, .419476E+01,
     +  .369226E+01, .324952E+01, .285871E+01, .251322E+01,
     +  .220741E+01, .193647E+01, .169624E+01, .148316E+01,
     +  .129412E+01, .112715E+01, .978167E+00, .846199E+00,
     +  .729419E+00, .626221E+00, .535186E+00, .455055E+00,
     +  .384708E+00, .323143E+00, .269431E+00, .222729E+00,
     +  .182696E+00, .148075E+00, .118562E+00, .935996E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .726814E-01, .553460E-01, .411705E-01, .297836E-01,
     +  .207631E-01, .138580E-01, .871893E-02, .506000E-02,
     +  .261193E-02, .112010E-02, .342376E-03, .456957E-04,
     +  .000000E+00, .497002E+06, .393228E+06, .307914E+06,
     +  .241060E+06, .188776E+06, .147804E+06, .115761E+06,
     +  .906494E+05, .710096E+05, .556167E+05, .435771E+05,
     +  .341397E+05, .267574E+05, .209696E+05, .164416E+05,
     +  .128907E+05, .101122E+05, .793262E+04, .622668E+04,
     +  .488797E+04, .383976E+04, .301682E+04, .237219E+04,
     +  .186586E+04, .146900E+04, .115708E+04, .912413E+03,
     +  .717648E+03, .567169E+03, .448664E+03, .355556E+03,
     +  .282142E+03, .224394E+03, .178907E+03, .142974E+03,
     +  .114554E+03, .921173E+02, .743201E+02, .602198E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .489828E+02, .400421E+02, .328730E+02, .271224E+02,
     +  .224770E+02, .187172E+02, .156517E+02, .131542E+02,
     +  .110844E+02, .938408E+01, .796079E+01, .677694E+01,
     +  .578233E+01, .494387E+01, .423336E+01, .362944E+01,
     +  .311400E+01, .267296E+01, .229442E+01, .196884E+01,
     +  .168829E+01, .144618E+01, .123707E+01, .105616E+01,
     +  .900370E+00, .764762E+00, .647588E+00, .546373E+00,
     +  .459094E+00, .383927E+00, .319364E+00, .264030E+00,
     +  .216801E+00, .176625E+00, .142563E+00, .114107E+00,
     +  .901560E-01, .702876E-01, .539653E-01, .406859E-01,
     +  .300303E-01, .215964E-01, .150683E-01, .100906E-01,
     +  .644296E-02, .385345E-02, .210927E-02, .101422E-02,
     +  .398129E-03, .109866E-03, .148022E-04, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .116351E+07, .913238E+06, .708582E+06, .549543E+06,
     +  .426230E+06, .330438E+06, .256193E+06, .198540E+06,
     +  .153872E+06, .119199E+06, .923470E+05, .715110E+05,
     +  .553813E+05, .428702E+05, .331891E+05, .256828E+05,
     +  .198770E+05, .153771E+05, .118981E+05, .920255E+04,
     +  .711932E+04, .550582E+04, .425935E+04, .329429E+04,
     +  .254897E+04, .197204E+04, .152660E+04, .117779E+04,
     +  .912775E+03, .707683E+03, .549356E+03, .426808E+03,
     +  .332184E+03, .259090E+03, .202461E+03, .158579E+03,
     +  .124631E+03, .982669E+02, .778117E+02, .618586E+02,
     +  .494327E+02, .396834E+02, .320279E+02, .259760E+02,
     +  .211799E+02, .173511E+02, .142953E+02, .118140E+02,
     +  .981577E+01, .817583E+01, .683754E+01, .573425E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .482100E+01, .406102E+01, .342628E+01, .289390E+01,
     +  .244599E+01, .206797E+01, .174813E+01, .147699E+01,
     +  .124673E+01, .105103E+01, .884337E+00, .743043E+00,
     +  .621966E+00, .518994E+00, .431439E+00, .357138E+00,
     +  .294166E+00, .240953E+00, .196090E+00, .158444E+00,
     +  .126971E+00, .100748E+00, .792362E-01, .614666E-01,
     +  .470106E-01, .353752E-01, .261091E-01, .188408E-01,
     +  .132237E-01, .898827E-02, .584773E-02, .361682E-02,
     +  .208653E-02, .109575E-02, .501534E-03, .185684E-03,
     +  .482535E-04, .653559E-05, .000000E+00, .219614E+07,
     +  .171208E+07, .131810E+07, .101419E+07, .780286E+06,
     +  .599972E+06, .461282E+06, .354435E+06, .272308E+06,
     +  .209078E+06, .160512E+06, .123147E+06, .944682E+05 /
        DATA (UPDI(I),I=6657,6708) /
     +  .724202E+05, .555107E+05, .425209E+05, .325665E+05,
     +  .249258E+05, .190756E+05, .145888E+05, .111563E+05,
     +  .852603E+04, .651571E+04, .497660E+04, .380127E+04,
     +  .290207E+04, .221610E+04, .168561E+04, .128763E+04,
     +  .983664E+03, .752071E+03, .575291E+03, .440656E+03,
     +  .338162E+03, .259893E+03, .200158E+03, .154636E+03,
     +  .119836E+03, .932506E+02, .728490E+02, .572073E+02,
     +  .451344E+02, .358039E+02, .285481E+02, .228889E+02,
     +  .184436E+02, .149513E+02, .121603E+02, .994725E+01,
     +  .815918E+01, .672191E+01, .555494E+01, .460312E+01,
     +  .382274E+01, .318030E+01, .264925E+01, .220875E+01,
     +  .184224E+01, .153646E+01, .128088E+01, .106683E+01,
     +  .887443E+00, .736739E+00, .610781E+00, .504350E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .415116E+00, .340322E+00, .277768E+00, .225526E+00,
     +  .182040E+00, .145936E+00, .116114E+00, .915832E-01,
     +  .714797E-01, .552683E-01, .421148E-01, .316120E-01,
     +  .233229E-01, .168568E-01, .118950E-01, .814929E-02,
     +  .539609E-02, .341030E-02, .204239E-02, .113577E-02,
     +  .571616E-03, .248663E-03, .866776E-04, .211894E-04,
     +  .288387E-05, .000000E+00, .368385E+07, .285467E+07,
     +  .218260E+07, .166764E+07, .127390E+07, .972455E+06,
     +  .742167E+06, .566007E+06, .431549E+06, .328786E+06,
     +  .250423E+06, .190589E+06, .145007E+06, .110237E+06,
     +  .837777E+05, .636162E+05, .482903E+05, .366255E+05,
     +  .277690E+05, .210359E+05, .159301E+05, .120533E+05,
     +  .911727E+04, .689093E+04, .520702E+04, .393153E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .296837E+04, .223134E+04, .168427E+04, .127105E+04,
     +  .959666E+03, .724738E+03, .547866E+03, .414850E+03,
     +  .314486E+03, .238853E+03, .181932E+03, .138984E+03,
     +  .106594E+03, .820698E+02, .635125E+02, .493831E+02,
     +  .386071E+02, .303413E+02, .239796E+02, .190501E+02,
     +  .152284E+02, .122148E+02, .985656E+01, .797640E+01,
     +  .648456E+01, .528907E+01, .432638E+01, .354723E+01,
     +  .291387E+01, .239697E+01, .197356E+01, .162571E+01,
     +  .133913E+01, .110261E+01, .907005E+00, .745155E+00,
     +  .610887E+00, .500104E+00, .407699E+00, .331239E+00,
     +  .268000E+00, .215824E+00, .172848E+00, .137577E+00,
     +  .108714E+00, .852267E-01, .662014E-01, .508534E-01,
     +  .386788E-01, .289682E-01, .213527E-01, .154548E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .109451E-01, .755726E-02, .505726E-02, .326454E-02,
     +  .200586E-02, .116431E-02, .624897E-03, .301899E-03,
     +  .125160E-03, .412865E-04, .958174E-05, .130781E-05,
     +  .000000E+00, .572556E+07, .441260E+07, .335246E+07,
     +  .254513E+07, .193159E+07, .146483E+07, .111046E+07,
     +  .841149E+06, .636901E+06, .481845E+06, .364383E+06,
     +  .275314E+06, .207921E+06, .156881E+06, .118312E+06,
     +  .891405E+05, .671267E+05, .504995E+05, .379705E+05,
     +  .285210E+05, .214115E+05, .160579E+05, .120365E+05,
     +  .901339E+04, .674631E+04, .504434E+04, .377076E+04,
     +  .280531E+04, .209546E+04, .156454E+04, .116836E+04,
     +  .872518E+03, .652041E+03, .488005E+03, .365541E+03,
     +  .274277E+03, .206343E+03, .155673E+03, .117890E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .896159E+02, .684674E+02, .525564E+02, .405622E+02,
     +  .314723E+02, .245579E+02, .192639E+02, .152076E+02,
     +  .120467E+02, .960207E+01, .767594E+01, .616525E+01,
     +  .496879E+01, .401635E+01, .325444E+01, .264216E+01,
     +  .214824E+01, .174826E+01, .142347E+01, .115896E+01,
     +  .943188E+00, .766822E+00, .622602E+00, .504366E+00,
     +  .407978E+00, .328552E+00, .263642E+00, .210629E+00,
     +  .167450E+00, .132348E+00, .103925E+00, .809866E-01,
     +  .625848E-01, .478974E-01, .362276E-01, .271165E-01,
     +  .199689E-01, .144603E-01, .102718E-01, .713087E-02,
     +  .481973E-02, .315185E-02, .198438E-02, .118605E-02,
     +  .667677E-03, .346143E-03, .160718E-03, .636330E-04,
     +  .199424E-04, .442107E-05, .603784E-06, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .880414E+07, .674580E+07, .509055E+07, .383839E+07,
     +  .289290E+07, .217851E+07, .163971E+07, .123310E+07,
     +  .926823E+06, .695978E+06, .522327E+06, .391624E+06,
     +  .293444E+06, .219654E+06, .164309E+06, .122779E+06,
     +  .916801E+05, .683824E+05, .509673E+05, .379435E+05,
     +  .282261E+05, .209727E+05, .155715E+05, .115478E+05,
     +  .855757E+04, .633379E+04, .468559E+04, .344850E+04,
     +  .254794E+04, .188133E+04, .138897E+04, .102528E+04,
     +  .757104E+03, .559817E+03, .414152E+03, .306857E+03,
     +  .227905E+03, .169719E+03, .126842E+03, .951488E+02,
     +  .717270E+02, .543240E+02, .413645E+02, .316657E+02,
     +  .243786E+02, .188689E+02, .146990E+02, .114900E+02,
     +  .903887E+01, .713154E+01, .565396E+01, .449823E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .358948E+01, .287154E+01, .230167E+01, .184767E+01,
     +  .148457E+01, .119341E+01, .959249E+00, .770661E+00,
     +  .618472E+00, .495624E+00, .396212E+00, .316236E+00,
     +  .251216E+00, .198804E+00, .156595E+00, .122704E+00,
     +  .955544E-01, .738986E-01, .566913E-01, .431058E-01,
     +  .324413E-01, .241116E-01, .177236E-01, .128051E-01,
     +  .908854E-02, .632063E-02, .429026E-02, .283088E-02,
     +  .180390E-02, .110435E-02, .640045E-03, .348285E-03,
     +  .173832E-03, .773284E-04, .291756E-04, .868443E-05,
     +  .184300E-05, .250861E-06, .000000E+00, .129900E+08,
     +  .989742E+07, .742010E+07, .555807E+07, .416094E+07,
     +  .311222E+07, .232639E+07, .173734E+07, .129658E+07,
     +  .966682E+06, .720204E+06, .536007E+06, .398613E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .296107E+06, .219781E+06, .162938E+06, .120690E+06,
     +  .892873E+05, .659944E+05, .487154E+05, .359262E+05,
     +  .264595E+05, .194687E+05, .143058E+05, .105021E+05,
     +  .769856E+04, .563957E+04, .410864E+04, .300471E+04,
     +  .219553E+04, .160367E+04, .117092E+04, .855042E+03,
     +  .625109E+03, .457115E+03, .334722E+03, .245633E+03,
     +  .180714E+03, .133406E+03, .988382E+02, .735813E+02,
     +  .550326E+02, .413781E+02, .312790E+02, .237787E+02,
     +  .181741E+02, .139817E+02, .107930E+02, .838565E+01,
     +  .653439E+01, .511689E+01, .402115E+01, .316960E+01,
     +  .250475E+01, .198320E+01, .157260E+01, .124809E+01,
     +  .990990E+00, .786706E+00, .624177E+00, .494623E+00,
     +  .391344E+00, .308814E+00, .243266E+00, .190670E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .148836E+00, .115605E+00, .892926E-01, .685164E-01,
     +  .521881E-01, .394114E-01, .294823E-01, .218157E-01,
     +  .159290E-01, .114947E-01, .814418E-02, .566234E-02,
     +  .385253E-02, .255448E-02, .164364E-02, .101914E-02,
     +  .605623E-03, .339594E-03, .178122E-03, .852799E-04,
     +  .361756E-04, .129282E-04, .362695E-05, .730633E-06,
     +  .985327E-07, .000000E+00, .184872E+08, .140109E+08,
     +  .104383E+08, .776956E+07, .577925E+07, .429468E+07,
     +  .318916E+07, .236583E+07, .175368E+07, .129854E+07,
     +  .960713E+06, .709969E+06, .524197E+06, .386569E+06,
     +  .284800E+06, .209556E+06, .154034E+06, .113070E+06,
     +  .829104E+05, .607098E+05, .444036E+05, .324298E+05,
     +  .236577E+05, .172328E+05, .125382E+05, .910758E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .660992E+04, .476940E+04, .345421E+04, .249912E+04,
     +  .180701E+04, .130585E+04, .943545E+03, .682460E+03,
     +  .493606E+03, .357439E+03, .259347E+03, .188627E+03,
     +  .137637E+03, .100783E+03, .741465E+02, .548001E+02,
     +  .407136E+02, .304110E+02, .228437E+02, .172519E+02,
     +  .131153E+02, .100040E+02, .768120E+01, .591487E+01,
     +  .457742E+01, .355513E+01, .276950E+01, .216300E+01,
     +  .169257E+01, .132641E+01, .104031E+01, .816233E+00,
     +  .640249E+00, .501871E+00, .392871E+00, .307016E+00,
     +  .239240E+00, .186075E+00, .143952E+00, .110879E+00,
     +  .849544E-01, .647048E-01, .489383E-01, .367247E-01,
     +  .273095E-01, .201049E-01, .146311E-01, .104979E-01,
     +  .743880E-02, .516971E-02, .352161E-02, .234450E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .151880E-02, .953052E-03, .575062E-03, .331716E-03,
     +  .179961E-03, .909827E-04, .417860E-04, .169061E-04,
     +  .572645E-05, .151582E-05, .289861E-06, .383120E-07,
     +  .000000E+00, .255018E+08, .192288E+08, .142399E+08,
     +  .105351E+08, .778818E+07, .575164E+07, .424414E+07,
     +  .312838E+07, .230391E+07, .169478E+07, .124551E+07,
     +  .914230E+06, .670376E+06, .490930E+06, .359125E+06,
     +  .262347E+06, .191426E+06, .139475E+06, .101497E+06,
     +  .737479E+05, .535162E+05, .387730E+05, .280543E+05,
     +  .202657E+05, .146197E+05, .105275E+05, .757290E+04,
     +  .541429E+04, .388514E+04, .278452E+04, .199404E+04,
     +  .142692E+04, .102071E+04, .730784E+03, .523069E+03,
     +  .374783E+03, .269014E+03, .193534E+03, .139664E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .101132E+03, .735702E+02, .537624E+02, .394907E+02,
     +  .291635E+02, .216582E+02, .161711E+02, .121549E+02,
     +  .916624E+01, .695888E+01, .529821E+01, .405419E+01,
     +  .311348E+01, .239828E+01, .185210E+01, .143302E+01,
     +  .111037E+01, .861020E+00, .667878E+00, .517876E+00,
     +  .401251E+00, .310430E+00, .239717E+00, .184547E+00,
     +  .141783E+00, .108314E+00, .823608E-01, .622763E-01,
     +  .467933E-01, .349004E-01, .258150E-01, .189120E-01,
     +  .137081E-01, .981562E-02, .692395E-02, .482005E-02,
     +  .328727E-02, .219505E-02, .143060E-02, .905885E-03,
     +  .554641E-03, .325834E-03, .182537E-03, .958631E-04,
     +  .467425E-04, .206082E-04, .795976E-05, .255869E-05,
     +  .639736E-06, .115867E-06, .147474E-07, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .342279E+08, .256831E+08, .189100E+08, .139088E+08,
     +  .102215E+08, .750359E+07, .550335E+07, .403170E+07,
     +  .295068E+07, .215689E+07, .157497E+07, .114857E+07,
     +  .836655E+06, .608609E+06, .442182E+06, .320795E+06,
     +  .232430E+06, .168143E+06, .121471E+06, .876092E+05,
     +  .630962E+05, .453638E+05, .325666E+05, .233381E+05,
     +  .166992E+05, .119249E+05, .850561E+04, .602792E+04,
     +  .428734E+04, .304518E+04, .216068E+04, .153171E+04,
     +  .108519E+04, .769408E+03, .545250E+03, .386739E+03,
     +  .274751E+03, .195611E+03, .139678E+03, .100070E+03,
     +  .720187E+02, .520626E+02, .378286E+02, .276336E+02,
     +  .202996E+02, .149923E+02, .111473E+02, .831525E+01,
     +  .624497E+01, .470338E+01, .356039E+01, .270496E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .206128E+01, .157479E+01, .120538E+01, .923929E+00,
     +  .708696E+00, .543743E+00, .416999E+00, .319516E+00,
     +  .244430E+00, .186612E+00, .142008E+00, .107828E+00,
     +  .813871E-01, .611285E-01, .456422E-01, .338529E-01,
     +  .249139E-01, .181757E-01, .131264E-01, .937405E-02,
     +  .660904E-02, .458671E-02, .313924E-02, .210268E-02,
     +  .137746E-02, .879634E-03, .544967E-03, .325889E-03,
     +  .186603E-03, .101647E-03, .517454E-04, .243713E-04,
     +  .103336E-04, .381851E-05, .116768E-05, .276133E-06,
     +  .471357E-07, .561747E-08, .000000E+00, .448377E+08,
     +  .334874E+08, .245193E+08, .179333E+08, .131040E+08,
     +  .956436E+07, .697381E+07, .507879E+07, .369472E+07,
     +  .268438E+07, .194806E+07, .141178E+07, .102186E+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .738553E+06, .533081E+06, .384175E+06, .276469E+06,
     +  .198631E+06, .142493E+06, .102041E+06, .729581E+05,
     +  .520680E+05, .370987E+05, .263825E+05, .187300E+05,
     +  .132684E+05, .938696E+04, .659662E+04, .465212E+04,
     +  .327578E+04, .230382E+04, .161853E+04, .113618E+04,
     +  .798062E+03, .560174E+03, .393486E+03, .276799E+03,
     +  .195109E+03, .137917E+03, .978033E+02, .696665E+02,
     +  .498435E+02, .358414E+02, .259107E+02, .188365E+02,
     +  .137674E+02, .101310E+02, .747879E+01, .555909E+01,
     +  .414367E+01, .310456E+01, .233453E+01, .176083E+01,
     +  .133151E+01, .100874E+01, .765280E+00, .580965E+00,
     +  .441131E+00, .334782E+00, .253824E+00, .192114E+00,
     +  .145095E+00, .109209E+00, .820064E-01, .611963E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .454317E-01, .335203E-01, .245598E-01, .178487E-01,
     +  .128532E-01, .915845E-02, .644957E-02, .448146E-02,
     +  .306298E-02, .206326E-02, .135883E-02, .874390E-03,
     +  .547847E-03, .332566E-03, .194554E-03, .108779E-03,
     +  .577333E-04, .285567E-04, .130273E-04, .532949E-05,
     +  .189126E-05, .552411E-06, .123865E-06, .197936E-07,
     +  .211641E-08, .000000E+00, .574721E+08, .427312E+08,
     +  .311196E+08, .226373E+08, .164503E+08, .119400E+08,
     +  .865692E+07, .626859E+07, .453387E+07, .327476E+07,
     +  .236236E+07, .170171E+07, .122417E+07, .879280E+06,
     +  .630648E+06, .451578E+06, .322857E+06, .230424E+06,
     +  .164186E+06, .116771E+06, .829072E+05, .587485E+05,
     +  .415556E+05, .293341E+05, .206687E+05, .145291E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .101985E+05, .710893E+04, .497259E+04, .347239E+04,
     +  .242138E+04, .168644E+04, .117341E+04, .816840E+03,
     +  .568113E+03, .395358E+03, .275493E+03, .192334E+03,
     +  .134642E+03, .945500E+02, .666877E+02, .472414E+02,
     +  .336336E+02, .240734E+02, .173272E+02, .125387E+02,
     +  .913593E+01, .667752E+01, .491489E+01, .362753E+01,
     +  .269135E+01, .200414E+01, .149696E+01, .112101E+01,
     +  .841038E+00, .631860E+00, .475013E+00, .357158E+00,
     +  .268391E+00, .201474E+00, .150969E+00, .112870E+00,
     +  .840836E-01, .624862E-01, .461358E-01, .338810E-01,
     +  .247222E-01, .179087E-01, .128639E-01, .915265E-02,
     +  .644107E-02, .447780E-02, .306996E-02, .206901E-02,
     +  .137353E-02, .890736E-03, .563919E-03, .347269E-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .206959E-03, .118703E-03, .649683E-04, .336920E-04,
     +  .162464E-04, .720666E-05, .285788E-05, .979244E-06,
     +  .274822E-06, .586878E-07, .872768E-08, .787930E-09,
     +  .000000E+00, .722327E+08, .534740E+08, .387409E+08,
     +  .280334E+08, .202631E+08, .146283E+08, .105481E+08,
     +  .759589E+07, .546308E+07, .392355E+07, .281409E+07,
     +  .201530E+07, .144116E+07, .102893E+07, .733474E+06,
     +  .521955E+06, .370823E+06, .262965E+06, .186152E+06,
     +  .131518E+06, .927481E+05, .652713E+05, .458468E+05,
     +  .321329E+05, .224763E+05, .156825E+05, .109250E+05,
     +  .755592E+04, .524375E+04, .363246E+04, .251232E+04,
     +  .173523E+04, .119710E+04, .826156E+03, .569538E+03,
     +  .392812E+03, .271238E+03, .187627E+03, .130128E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .905251E+02, .632478E+02, .443809E+02, .312974E+02,
     +  .221888E+02, .158193E+02, .113392E+02, .818439E+01,
     +  .592568E+01, .432091E+01, .315941E+01, .232237E+01,
     +  .171345E+01, .126810E+01, .940939E+00, .699495E+00,
     +  .520724E+00, .387888E+00, .288979E+00, .215161E+00,
     +  .160023E+00, .118793E+00, .879798E-01, .649186E-01,
     +  .477813E-01, .349335E-01, .253987E-01, .183449E-01,
     +  .131511E-01, .934609E-02, .657714E-02, .457656E-02,
     +  .314461E-02, .212999E-02, .141750E-02, .928815E-03,
     +  .594102E-03, .370726E-03, .224842E-03, .131849E-03,
     +  .743321E-04, .399405E-04, .203060E-04, .958284E-05,
     +  .415224E-05, .160478E-05, .534297E-06, .145092E-06,
     +  .296998E-07, .410471E-08, .289278E-09, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .402977E+05, .431026E+05, .338457E+05, .265803E+05,
     +  .208778E+05, .164016E+05, .128876E+05, .101289E+05,
     +  .796285E+04, .626193E+04, .492608E+04, .387679E+04,
     +  .305243E+04, .240466E+04, .189553E+04, .149527E+04,
     +  .118049E+04, .932864E+03, .737983E+03, .584545E+03,
     +  .463678E+03, .368414E+03, .293281E+03, .233984E+03,
     +  .187147E+03, .150119E+03, .120818E+03, .973122E+02,
     +  .789676E+02, .643961E+02, .528048E+02, .435694E+02,
     +  .361981E+02, .303188E+02, .255937E+02, .217982E+02,
     +  .187399E+02, .162661E+02, .142557E+02, .126118E+02,
     +  .112597E+02, .101363E+02, .919386E+01, .839400E+01,
     +  .770665E+01, .710833E+01, .658268E+01, .611069E+01,
     +  .568753E+01, .529991E+01, .494548E+01, .461778E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .431258E+01, .402614E+01, .375516E+01, .349682E+01,
     +  .324900E+01, .301024E+01, .277981E+01, .255749E+01,
     +  .234342E+01, .213797E+01, .194154E+01, .175539E+01,
     +  .157793E+01, .141060E+01, .125361E+01, .110708E+01,
     +  .971026E+00, .845423E+00, .730164E+00, .625079E+00,
     +  .529885E+00, .444229E+00, .368511E+00, .301222E+00,
     +  .242490E+00, .191823E+00, .148700E+00, .112566E+00,
     +  .828427E-01, .589603E-01, .401616E-01, .259760E-01,
     +  .156693E-01, .859483E-02, .410848E-02, .158039E-02,
     +  .409031E-03, .401808E-04, .000000E+00, .396122E+05,
     +  .581777E+05, .456039E+05, .357430E+05, .280199E+05,
     +  .219634E+05, .172200E+05, .135002E+05, .105869E+05,
     +  .830232E+04, .651301E+04, .510971E+04, .401058E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .314846E+04, .247311E+04, .194327E+04, .152812E+04,
     +  .120232E+04, .946945E+03, .746439E+03, .589193E+03,
     +  .465651E+03, .368686E+03, .292431E+03, .232513E+03,
     +  .185339E+03, .148216E+03, .118573E+03, .955712E+02,
     +  .773818E+02, .630021E+02, .515958E+02, .425469E+02,
     +  .353589E+02, .296151E+02, .250165E+02, .213291E+02,
     +  .183530E+02, .159436E+02, .139754E+02, .123614E+02,
     +  .110211E+02, .989968E+01, .894904E+01, .813531E+01,
     +  .742933E+01, .681276E+01, .626238E+01, .577290E+01,
     +  .532784E+01, .492457E+01, .455473E+01, .421352E+01,
     +  .389624E+01, .359933E+01, .331955E+01, .305472E+01,
     +  .280315E+01, .256397E+01, .233663E+01, .212100E+01,
     +  .191708E+01, .172482E+01, .154512E+01, .137606E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .121873E+01, .107298E+01, .938644E+00, .815449E+00,
     +  .703114E+00, .601273E+00, .509568E+00, .427540E+00,
     +  .354627E+00, .290996E+00, .235175E+00, .187093E+00,
     +  .146186E+00, .111858E+00, .835249E-01, .605881E-01,
     +  .424652E-01, .284424E-01, .180620E-01, .106741E-01,
     +  .572117E-02, .266208E-02, .992266E-03, .248859E-03,
     +  .247093E-04, .000000E+00, .100326E+06, .791230E+05,
     +  .617329E+05, .481561E+05, .375695E+05, .293054E+05,
     +  .228624E+05, .178337E+05, .139137E+05, .108545E+05,
     +  .847000E+04, .660929E+04, .515911E+04, .402749E+04,
     +  .314557E+04, .245735E+04, .192094E+04, .150229E+04,
     +  .117592E+04, .921130E+03, .722443E+03, .567252E+03,
     +  .446157E+03, .351498E+03, .277565E+03, .219717E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .174481E+03, .138581E+03, .110899E+03, .891452E+02,
     +  .720546E+02, .585808E+02, .479559E+02, .395650E+02,
     +  .328976E+02, .275877E+02, .233510E+02, .199469E+02,
     +  .172026E+02, .149693E+02, .131445E+02, .116340E+02,
     +  .103746E+02, .931069E+01, .840354E+01, .761989E+01,
     +  .693881E+01, .633408E+01, .579936E+01, .531604E+01,
     +  .488080E+01, .448412E+01, .412051E+01, .378468E+01,
     +  .347273E+01, .318117E+01, .290760E+01, .265017E+01,
     +  .240778E+01, .217966E+01, .196540E+01, .176473E+01,
     +  .157730E+01, .140373E+01, .124188E+01, .109261E+01,
     +  .955511E+00, .830239E+00, .716339E+00, .613365E+00,
     +  .520804E+00, .438175E+00, .364917E+00, .300364E+00,
     +  .244533E+00, .196005E+00, .154598E+00, .119716E+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .907399E-01, .670831E-01, .481439E-01, .333595E-01,
     +  .220642E-01, .138200E-01, .804180E-02, .423511E-02,
     +  .193029E-02, .702070E-03, .171670E-03, .171960E-04,
     +  .000000E+00, .139318E+06, .109309E+06, .847875E+05,
     +  .657523E+05, .509927E+05, .395381E+05, .306587E+05,
     +  .237692E+05, .184299E+05, .142881E+05, .110790E+05,
     +  .859005E+04, .666198E+04, .516682E+04, .400875E+04,
     +  .311076E+04, .241526E+04, .187594E+04, .145821E+04,
     +  .113423E+04, .883245E+03, .688520E+03, .537589E+03,
     +  .420412E+03, .329512E+03, .258879E+03, .204031E+03,
     +  .160804E+03, .127701E+03, .101868E+03, .817100E+02,
     +  .659262E+02, .535611E+02, .438594E+02, .361980E+02,
     +  .301327E+02, .253204E+02, .214743E+02, .183886E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .158890E+02, .138554E+02, .121790E+02, .107867E+02,
     +  .961540E+01, .862089E+01, .776570E+01, .702600E+01,
     +  .637261E+01, .579798E+01, .528146E+01, .481894E+01,
     +  .439983E+01, .401792E+01, .366741E+01, .334400E+01,
     +  .304395E+01, .276461E+01, .250395E+01, .226063E+01,
     +  .203364E+01, .182229E+01, .162606E+01, .144429E+01,
     +  .127738E+01, .112300E+01, .981761E+00, .853086E+00,
     +  .736447E+00, .631235E+00, .536875E+00, .452732E+00,
     +  .378229E+00, .312725E+00, .255479E+00, .206392E+00,
     +  .164100E+00, .128341E+00, .985027E-01, .739601E-01,
     +  .541333E-01, .384267E-01, .263143E-01, .171786E-01,
     +  .106055E-01, .607056E-02, .313676E-02, .139748E-02,
     +  .494353E-03, .117312E-03, .118742E-04, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .192857E+06, .150514E+06, .116043E+06, .894430E+05,
     +  .689390E+05, .531220E+05, .409340E+05, .315352E+05,
     +  .242954E+05, .187143E+05, .144166E+05, .111045E+05,
     +  .855484E+04, .659040E+04, .507854E+04, .391391E+04,
     +  .301776E+04, .232747E+04, .179634E+04, .138721E+04,
     +  .107240E+04, .829838E+03, .643117E+03, .499169E+03,
     +  .388276E+03, .302721E+03, .236757E+03, .185138E+03,
     +  .145890E+03, .115478E+03, .919134E+02, .735912E+02,
     +  .593343E+02, .482238E+02, .395057E+02, .326474E+02,
     +  .272376E+02, .229384E+02, .195071E+02, .167415E+02,
     +  .145016E+02, .126636E+02, .111436E+02, .987041E+01,
     +  .879405E+01, .787276E+01, .707963E+01, .638254E+01,
     +  .577257E+01, .522719E+01, .474139E+01, .430358E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .390684E+01, .354489E+01, .321302E+01, .290722E+01,
     +  .262460E+01, .236291E+01, .212053E+01, .189623E+01,
     +  .168905E+01, .149822E+01, .132283E+01, .116300E+01,
     +  .101629E+01, .883090E+00, .762645E+00, .654283E+00,
     +  .557270E+00, .470917E+00, .394496E+00, .327353E+00,
     +  .268786E+00, .218003E+00, .174814E+00, .137915E+00,
     +  .106987E+00, .814128E-01, .605764E-01, .439121E-01,
     +  .308472E-01, .208874E-01, .134669E-01, .820007E-02,
     +  .462074E-02, .234482E-02, .102237E-02, .352386E-03,
     +  .813700E-04, .831815E-05, .000000E+00, .172893E+06,
     +  .204931E+06, .157068E+06, .120347E+06, .922037E+05,
     +  .706200E+05, .540852E+05, .414102E+05, .317046E+05,
     +  .242679E+05, .185759E+05, .142163E+05, .108810E+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .832731E+04, .637431E+04, .487949E+04, .373662E+04,
     +  .286204E+04, .219351E+04, .168196E+04, .129096E+04,
     +  .991740E+03, .762960E+03, .587808E+03, .453804E+03,
     +  .351142E+03, .272546E+03, .211476E+03, .165369E+03,
     +  .129896E+03, .102600E+03, .815263E+02, .652387E+02,
     +  .526319E+02, .428034E+02, .351208E+02, .290967E+02,
     +  .243372E+02, .205586E+02, .175290E+02, .150868E+02,
     +  .130923E+02, .114499E+02, .100804E+02, .892758E+01,
     +  .794540E+01, .710367E+01, .636744E+01, .572632E+01,
     +  .515597E+01, .465045E+01, .419726E+01, .378875E+01,
     +  .341817E+01, .308043E+01, .277122E+01, .248741E+01,
     +  .222649E+01, .198661E+01, .176627E+01, .156426E+01,
     +  .137958E+01, .121107E+01, .105862E+01, .919691E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .794457E+00, .682024E+00, .581593E+00, .492322E+00,
     +  .413433E+00, .344125E+00, .283683E+00, .231361E+00,
     +  .186337E+00, .148345E+00, .116151E+00, .893922E-01,
     +  .674597E-01, .497539E-01, .357300E-01, .248461E-01,
     +  .166408E-01, .106000E-01, .636858E-02, .353469E-02,
     +  .176265E-02, .752809E-03, .253181E-03, .570220E-04,
     +  .588380E-05, .000000E+00, .375936E+06, .290230E+06,
     +  .220987E+06, .168206E+06, .128008E+06, .973819E+05,
     +  .740706E+05, .563209E+05, .428185E+05, .325435E+05,
     +  .247317E+05, .187905E+05, .142761E+05, .108446E+05,
     +  .823851E+04, .625846E+04, .475543E+04, .361387E+04,
     +  .274764E+04, .208990E+04, .159092E+04, .121206E+04,
     +  .924601E+03, .706288E+03, .540571E+03, .414640E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .319006E+03, .245310E+03, .190121E+03, .148014E+03,
     +  .115874E+03, .912638E+02, .723928E+02, .579038E+02,
     +  .466927E+02, .379963E+02, .312248E+02, .259123E+02,
     +  .217213E+02, .183822E+02, .157058E+02, .135324E+02,
     +  .117520E+02, .102753E+02, .903867E+01, .799069E+01,
     +  .709730E+01, .632019E+01, .564718E+01, .505190E+01,
     +  .452728E+01, .405977E+01, .364091E+01, .326342E+01,
     +  .292171E+01, .261118E+01, .232834E+01, .207040E+01,
     +  .183520E+01, .162096E+01, .142618E+01, .124958E+01,
     +  .108975E+01, .946322E+00, .816677E+00, .700751E+00,
     +  .597512E+00, .506035E+00, .425382E+00, .354689E+00,
     +  .293092E+00, .239825E+00, .194108E+00, .155104E+00,
     +  .122485E+00, .950943E-01, .725440E-01, .542417E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .396180E-01, .281592E-01, .193661E-01, .128177E-01,
     +  .805961E-02, .477408E-02, .260810E-02, .127752E-02,
     +  .534516E-03, .175636E-03, .387103E-04, .402832E-05,
     +  .000000E+00, .525249E+06, .403331E+06, .305199E+06,
     +  .230851E+06, .174567E+06, .131951E+06, .997131E+05,
     +  .753211E+05, .568826E+05, .429418E+05, .324112E+05,
     +  .244551E+05, .184496E+05, .139154E+05, .104952E+05,
     +  .791463E+04, .596925E+04, .450223E+04, .339692E+04,
     +  .256376E+04, .193629E+04, .146342E+04, .110731E+04,
     +  .838922E+03, .636746E+03, .484303E+03, .369441E+03,
     +  .281632E+03, .216395E+03, .167022E+03, .129631E+03,
     +  .101229E+03, .796187E+02, .631562E+02, .505124E+02,
     +  .407775E+02, .332498E+02, .273845E+02, .227864E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .191457E+02, .162437E+02, .139003E+02, .119904E+02,
     +  .104147E+02, .910159E+01, .799459E+01, .705567E+01,
     +  .624329E+01, .554342E+01, .492782E+01, .438827E+01,
     +  .391024E+01, .348448E+01, .310319E+01, .276034E+01,
     +  .245099E+01, .217129E+01, .191819E+01, .168922E+01,
     +  .148232E+01, .129570E+01, .112786E+01, .977141E+00,
     +  .842963E+00, .722631E+00, .615881E+00, .521566E+00,
     +  .438659E+00, .366145E+00, .303099E+00, .248616E+00,
     +  .201893E+00, .162136E+00, .128510E+00, .100639E+00,
     +  .774514E-01, .585450E-01, .433537E-01, .313433E-01,
     +  .220362E-01, .149777E-01, .978785E-02, .606869E-02,
     +  .353933E-02, .189990E-02, .912041E-03, .372695E-03,
     +  .119151E-03, .255771E-04, .268959E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .719868E+06, .549994E+06, .413736E+06, .311094E+06,
     +  .233835E+06, .175678E+06, .131940E+06, .990444E+05,
     +  .743264E+05, .557520E+05, .418073E+05, .313376E+05,
     +  .234844E+05, .175932E+05, .131780E+05, .986854E+04,
     +  .739025E+04, .553399E+04, .414491E+04, .310513E+04,
     +  .232749E+04, .174565E+04, .131060E+04, .985126E+03,
     +  .741743E+03, .559598E+03, .423393E+03, .320067E+03,
     +  .243891E+03, .186685E+03, .143692E+03, .111289E+03,
     +  .868183E+02, .683181E+02, .542118E+02, .434293E+02,
     +  .351478E+02, .287382E+02, .237441E+02, .198135E+02,
     +  .166976E+02, .141950E+02, .121655E+02, .104996E+02,
     +  .911799E+01, .795903E+01, .698086E+01, .613883E+01,
     +  .541712E+01, .478571E+01, .423526E+01, .375035E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .332096E+01, .293883E+01, .259744E+01, .229155E+01,
     +  .201698E+01, .177038E+01, .154898E+01, .135047E+01,
     +  .117281E+01, .101426E+01, .872982E+00, .748174E+00,
     +  .637109E+00, .539343E+00, .453636E+00, .378886E+00,
     +  .314023E+00, .258079E+00, .210126E+00, .169343E+00,
     +  .134936E+00, .106084E+00, .823825E-01, .628458E-01,
     +  .470688E-01, .345187E-01, .247007E-01, .171765E-01,
     +  .115371E-01, .744352E-02, .455037E-02, .261259E-02,
     +  .137782E-02, .648103E-03, .258622E-03, .804433E-04,
     +  .168237E-04, .178798E-05, .000000E+00, .968886E+06,
     +  .736720E+06, .551107E+06, .412048E+06, .307949E+06,
     +  .230021E+06, .171741E+06, .128158E+06, .955955E+05,
     +  .712689E+05, .531126E+05, .395622E+05, .294592E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .219267E+05, .163162E+05, .121373E+05, .902778E+04,
     +  .671378E+04, .499342E+04, .371424E+04, .276397E+04,
     +  .205781E+04, .153346E+04, .114393E+04, .854707E+03,
     +  .639807E+03, .480277E+03, .360156E+03, .272254E+03,
     +  .206737E+03, .157860E+03, .121297E+03, .938865E+02,
     +  .733149E+02, .577391E+02, .459163E+02, .368953E+02,
     +  .299580E+02, .245850E+02, .203805E+02, .170651E+02,
     +  .144160E+02, .122780E+02, .105316E+02, .908998E+01,
     +  .788641E+01, .687541E+01, .600939E+01, .527081E+01,
     +  .462800E+01, .407057E+01, .358225E+01, .315233E+01,
     +  .277207E+01, .243453E+01, .213415E+01, .186643E+01,
     +  .162774E+01, .141503E+01, .122575E+01, .105764E+01,
     +  .908739E+00, .777056E+00, .661606E+00, .559648E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .470583E+00, .393105E+00, .326053E+00, .268326E+00,
     +  .218930E+00, .176932E+00, .141508E+00, .111874E+00,
     +  .872375E-01, .671788E-01, .507966E-01, .376937E-01,
     +  .273750E-01, .193875E-01, .133338E-01, .885005E-02,
     +  .563679E-02, .339727E-02, .192007E-02, .994774E-03,
     +  .458491E-03, .178682E-03, .540979E-04, .110351E-04,
     +  .118511E-05, .000000E+00, .128207E+07, .970430E+06,
     +  .722054E+06, .536946E+06, .399098E+06, .296454E+06,
     +  .220101E+06, .163312E+06, .121116E+06, .897677E+05,
     +  .665023E+05, .492383E+05, .364406E+05, .269552E+05,
     +  .199319E+05, .147323E+05, .108868E+05, .804291E+04,
     +  .594186E+04, .438961E+04, .324391E+04, .239814E+04,
     +  .177428E+04, .131396E+04, .974519E+03, .724040E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .539407E+03, .401379E+03, .301097E+03, .226892E+03,
     +  .171927E+03, .131107E+03, .100721E+03, .780758E+02,
     +  .610464E+02, .482068E+02, .384719E+02, .310318E+02,
     +  .253021E+02, .208433E+02, .173451E+02, .145639E+02,
     +  .123296E+02, .105129E+02, .902006E+01, .777940E+01,
     +  .674204E+01, .585765E+01, .510707E+01, .445715E+01,
     +  .389649E+01, .340804E+01, .298046E+01, .260456E+01,
     +  .227302E+01, .197995E+01, .172056E+01, .149095E+01,
     +  .128783E+01, .110841E+01, .950240E+00, .811188E+00,
     +  .689122E+00, .582898E+00, .489792E+00, .409073E+00,
     +  .339388E+00, .279544E+00, .228422E+00, .185023E+00,
     +  .148420E+00, .117799E+00, .923982E-01, .714614E-01,
     +  .545666E-01, .408949E-01, .300650E-01, .216215E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .151545E-01, .103075E-01, .675992E-02, .425011E-02,
     +  .252519E-02, .140479E-02, .714950E-03, .322870E-03,
     +  .122902E-03, .362359E-04, .721784E-05, .783157E-06,
     +  .000000E+00, .166966E+07, .125830E+07, .931430E+06,
     +  .689050E+06, .509457E+06, .376416E+06, .277960E+06,
     +  .205115E+06, .151275E+06, .111492E+06, .821253E+05,
     +  .604543E+05, .444789E+05, .327053E+05, .240375E+05,
     +  .176578E+05, .129672E+05, .951909E+04, .698707E+04,
     +  .512795E+04, .376429E+04, .276399E+04, .203090E+04,
     +  .149350E+04, .109983E+04, .811271E+03, .600013E+03,
     +  .443172E+03, .330011E+03, .246858E+03, .185689E+03,
     +  .140577E+03, .107223E+03, .825359E+02, .640913E+02,
     +  .502740E+02, .398613E+02, .319501E+02, .258909E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .212004E+02, .175382E+02, .146402E+02, .123224E+02,
     +  .104463E+02, .891110E+01, .764091E+01, .658359E+01,
     +  .568636E+01, .492850E+01, .427557E+01, .371522E+01,
     +  .322970E+01, .280710E+01, .243782E+01, .211418E+01,
     +  .182998E+01, .158016E+01, .136059E+01, .116773E+01,
     +  .998614E+00, .850611E+00, .721452E+00, .608896E+00,
     +  .511668E+00, .427079E+00, .354290E+00, .291927E+00,
     +  .238777E+00, .193725E+00, .155778E+00, .124029E+00,
     +  .976865E-01, .760183E-01, .583103E-01, .441477E-01,
     +  .327923E-01, .238836E-01, .170075E-01, .117965E-01,
     +  .793441E-02, .514127E-02, .319057E-02, .186863E-02,
     +  .102314E-02, .511482E-03, .226318E-03, .841574E-04,
     +  .241745E-04, .470740E-05, .515938E-06, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .214205E+07, .160755E+07, .118405E+07, .871537E+06,
     +  .641108E+06, .471254E+06, .346179E+06, .254109E+06,
     +  .186406E+06, .136640E+06, .100096E+06, .732722E+05,
     +  .536045E+05, .391890E+05, .286348E+05, .209104E+05,
     +  .152634E+05, .111362E+05, .812325E+04, .592418E+04,
     +  .432086E+04, .315198E+04, .230064E+04, .168050E+04,
     +  .122911E+04, .900365E+03, .661269E+03, .484945E+03,
     +  .358579E+03, .266345E+03, .198947E+03, .149573E+03,
     +  .113307E+03, .866383E+02, .668381E+02, .520965E+02,
     +  .410517E+02, .327072E+02, .263493E+02, .214521E+02,
     +  .176461E+02, .146477E+02, .122596E+02, .103348E+02,
     +  .876628E+01, .747402E+01, .640302E+01, .549828E+01,
     +  .473768E+01, .408561E+01, .352888E+01, .304912E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .263390E+01, .227324E+01, .195913E+01, .168512E+01,
     +  .144589E+01, .123708E+01, .105497E+01, .896420E+00,
     +  .758663E+00, .639313E+00, .536054E+00, .447506E+00,
     +  .371036E+00, .305720E+00, .250179E+00, .203201E+00,
     +  .163687E+00, .130664E+00, .103256E+00, .807000E-01,
     +  .623019E-01, .473948E-01, .355781E-01, .261908E-01,
     +  .188968E-01, .133236E-01, .914467E-02, .608200E-02,
     +  .389349E-02, .238476E-02, .137665E-02, .741818E-03,
     +  .364250E-03, .157915E-03, .573720E-04, .160642E-04,
     +  .306126E-05, .338849E-06, .000000E+00, .270953E+07,
     +  .202522E+07, .148450E+07, .108739E+07, .795955E+06,
     +  .582165E+06, .425497E+06, .310738E+06, .226768E+06,
     +  .165354E+06, .120487E+06, .877233E+05, .638254E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .464023E+05, .337144E+05, .244789E+05, .177642E+05,
     +  .128844E+05, .934205E+04, .677153E+04, .490830E+04,
     +  .355800E+04, .258042E+04, .187267E+04, .136068E+04,
     +  .990119E+03, .722323E+03, .526108E+03, .386395E+03,
     +  .285078E+03, .211517E+03, .157975E+03, .118895E+03,
     +  .903354E+02, .692588E+02, .536586E+02, .420352E+02,
     +  .333003E+02, .266777E+02, .216004E+02, .176716E+02,
     +  .145895E+02, .121447E+02, .101820E+02, .858898E+01,
     +  .728196E+01, .620333E+01, .529618E+01, .453710E+01,
     +  .388954E+01, .333948E+01, .286804E+01, .246232E+01,
     +  .211204E+01, .180886E+01, .154612E+01, .131826E+01,
     +  .112074E+01, .949682E+00, .801804E+00, .674233E+00,
     +  .564497E+00, .470234E+00, .389984E+00, .321185E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .262853E+00, .213621E+00, .172293E+00, .137797E+00,
     +  .109193E+00, .856416E-01, .664164E-01, .508665E-01,
     +  .383749E-01, .285608E-01, .208361E-01, .148919E-01,
     +  .103956E-01, .705997E-02, .464271E-02, .293610E-02,
     +  .177480E-02, .100977E-02, .535461E-03, .258235E-03,
     +  .109692E-03, .389431E-04, .106339E-04, .198516E-05,
     +  .221872E-06, .000000E+00, .402800E+05, .430635E+05,
     +  .338083E+05, .265447E+05, .208440E+05, .163697E+05,
     +  .128577E+05, .101008E+05, .793661E+04, .623748E+04,
     +  .490336E+04, .385571E+04, .303293E+04, .238664E+04,
     +  .187892E+04, .147997E+04, .116643E+04, .919960E+03,
     +  .726153E+03, .573714E+03, .453770E+03, .359359E+03,
     +  .285012E+03, .226438E+03, .180263E+03, .143840E+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .115090E+03, .920920E+02, .741993E+02, .600348E+02,
     +  .488083E+02, .398979E+02, .328144E+02, .271873E+02,
     +  .226828E+02, .190777E+02, .161821E+02, .138462E+02,
     +  .119514E+02, .104036E+02, .913102E+01, .807334E+01,
     +  .718549E+01, .643166E+01, .578387E+01, .522032E+01,
     +  .472575E+01, .428215E+01, .388466E+01, .352043E+01,
     +  .318713E+01, .287901E+01, .259317E+01, .232787E+01,
     +  .208222E+01, .185578E+01, .164820E+01, .145897E+01,
     +  .128731E+01, .113218E+01, .992400E+00, .866724E+00,
     +  .753942E+00, .653361E+00, .562907E+00, .482297E+00,
     +  .410686E+00, .347313E+00, .291485E+00, .242567E+00,
     +  .199967E+00, .163132E+00, .131518E+00, .104611E+00,
     +  .821521E-01, .633508E-01, .479529E-01, .355168E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .256502E-01, .179844E-01, .121737E-01, .790347E-02,
     +  .485759E-02, .279874E-02, .147803E-02, .693142E-03,
     +  .273720E-03, .823858E-04, .151098E-04, .825324E-06,
     +  .000000E+00, .395960E+05, .581262E+05, .455551E+05,
     +  .356970E+05, .279767E+05, .219229E+05, .171822E+05,
     +  .134650E+05, .105542E+05, .827199E+04, .648495E+04,
     +  .508380E+04, .398669E+04, .312647E+04, .245289E+04,
     +  .192472E+04, .151111E+04, .118674E+04, .932694E+03,
     +  .733414E+03, .577298E+03, .454796E+03, .358784E+03,
     +  .283404E+03, .224284E+03, .177837E+03, .141375E+03,
     +  .112339E+03, .898772E+02, .721744E+02, .582302E+02,
     +  .472134E+02, .385098E+02, .316266E+02, .261507E+02,
     +  .217864E+02, .183018E+02, .155013E+02, .132424E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .114038E+02, .990085E+01, .865666E+01, .761888E+01,
     +  .674230E+01, .599487E+01, .534931E+01, .478819E+01,
     +  .428971E+01, .384841E+01, .344894E+01, .308863E+01,
     +  .276041E+01, .246079E+01, .218705E+01, .193756E+01,
     +  .171092E+01, .150598E+01, .132147E+01, .115600E+01,
     +  .100806E+01, .876106E+00, .758664E+00, .654269E+00,
     +  .562097E+00, .480011E+00, .407601E+00, .343926E+00,
     +  .288170E+00, .239570E+00, .197448E+00, .161166E+00,
     +  .130149E+00, .103842E+00, .817064E-01, .634556E-01,
     +  .483664E-01, .361565E-01, .264337E-01, .188455E-01,
     +  .130385E-01, .870030E-02, .556375E-02, .336328E-02,
     +  .190345E-02, .985376E-03, .452027E-03, .174017E-03,
     +  .509311E-04, .911439E-05, .508151E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .100261E+06, .790613E+05, .616749E+05, .481017E+05,
     +  .375186E+05, .292580E+05, .228183E+05, .177928E+05,
     +  .138758E+05, .108194E+05, .843768E+04, .657952E+04,
     +  .513172E+04, .400235E+04, .312250E+04, .243621E+04,
     +  .190160E+04, .148460E+04, .115976E+04, .906380E+03,
     +  .708988E+03, .554985E+03, .434979E+03, .341315E+03,
     +  .268289E+03, .211265E+03, .166778E+03, .131566E+03,
     +  .104495E+03, .832911E+02, .666935E+02, .536612E+02,
     +  .434283E+02, .353846E+02, .290238E+02, .239836E+02,
     +  .199824E+02, .167842E+02, .142187E+02, .121416E+02,
     +  .104529E+02, .906241E+01, .790918E+01, .694079E+01,
     +  .612029E+01, .541636E+01, .480895E+01, .427351E+01,
     +  .380354E+01, .338196E+01, .300540E+01, .266588E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .235923E+01, .208203E+01, .183199E+01, .160709E+01,
     +  .140555E+01, .122565E+01, .106557E+01, .923518E+00,
     +  .797718E+00, .686551E+00, .588404E+00, .502361E+00,
     +  .426268E+00, .359630E+00, .301458E+00, .250901E+00,
     +  .207167E+00, .169557E+00, .137413E+00, .110157E+00,
     +  .872342E-01, .681054E-01, .524709E-01, .396604E-01,
     +  .293899E-01, .212925E-01, .150334E-01, .102954E-01,
     +  .679714E-02, .429782E-02, .256589E-02, .143266E-02,
     +  .730493E-03, .329461E-03, .124356E-03, .355959E-04,
     +  .624249E-05, .354015E-06, .000000E+00, .139241E+06,
     +  .109237E+06, .847200E+05, .656893E+05, .509340E+05,
     +  .394836E+05, .306081E+05, .237224E+05, .183867E+05,
     +  .142483E+05, .110423E+05, .855636E+04, .663105E+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .513847E+04, .398278E+04, .308700E+04, .239355E+04,
     +  .185612E+04, .144012E+04, .111774E+04, .868216E+03,
     +  .674834E+03, .525128E+03, .409070E+03, .319188E+03,
     +  .249479E+03, .195470E+03, .153012E+03, .120593E+03,
     +  .953756E+02, .757698E+02, .604807E+02, .485557E+02,
     +  .392448E+02, .319296E+02, .261706E+02, .216272E+02,
     +  .180179E+02, .151399E+02, .128236E+02, .109512E+02,
     +  .941874E+01, .815512E+01, .710056E+01, .621266E+01,
     +  .545596E+01, .480755E+01, .424018E+01, .374610E+01,
     +  .330657E+01, .291744E+01, .256982E+01, .225879E+01,
     +  .198030E+01, .173139E+01, .150946E+01, .131222E+01,
     +  .113750E+01, .983156E+00, .847130E+00, .727469E+00,
     +  .622431E+00, .530287E+00, .450043E+00, .379548E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .318234E+00, .265078E+00, .219210E+00, .179816E+00,
     +  .146187E+00, .117661E+00, .936594E-01, .736344E-01,
     +  .570569E-01, .436205E-01, .327057E-01, .240329E-01,
     +  .172600E-01, .120734E-01, .818648E-02, .534506E-02,
     +  .333970E-02, .196778E-02, .108292E-02, .543199E-03,
     +  .240474E-03, .888052E-04, .247900E-04, .424893E-05,
     +  .244789E-06, .000000E+00, .192768E+06, .150431E+06,
     +  .115965E+06, .893711E+05, .688722E+05, .530601E+05,
     +  .408768E+05, .314824E+05, .242468E+05, .186695E+05,
     +  .143755E+05, .110668E+05, .852026E+04, .655875E+04,
     +  .504960E+04, .388747E+04, .299362E+04, .230546E+04,
     +  .177628E+04, .136894E+04, .105577E+04, .814707E+03,
     +  .629353E+03, .486651E+03, .376891E+03, .292363E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .227331E+03, .176567E+03, .138077E+03, .108348E+03,
     +  .853965E+02, .676242E+02, .538571E+02, .431826E+02,
     +  .348519E+02, .283376E+02, .232313E+02, .192009E+02,
     +  .160069E+02, .134521E+02, .113994E+02, .972946E+01,
     +  .836066E+01, .722538E+01, .627543E+01, .547112E+01,
     +  .478649E+01, .419166E+01, .367749E+01, .322366E+01,
     +  .282513E+01, .247213E+01, .215900E+01, .188105E+01,
     +  .163469E+01, .141679E+01, .122459E+01, .105554E+01,
     +  .907206E+00, .777326E+00, .663791E+00, .564755E+00,
     +  .478408E+00, .403686E+00, .338459E+00, .282096E+00,
     +  .233555E+00, .191951E+00, .156466E+00, .126386E+00,
     +  .101053E+00, .798952E-01, .623773E-01, .479856E-01,
     +  .364138E-01, .270910E-01, .197466E-01, .140626E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .974912E-02, .654807E-02, .423203E-02, .261580E-02,
     +  .152315E-02, .827613E-03, .409357E-03, .178484E-03,
     +  .648414E-04, .178255E-04, .304273E-05, .182515E-06,
     +  .000000E+00, .172883E+06, .204836E+06, .156980E+06,
     +  .120266E+06, .921285E+05, .705505E+05, .540210E+05,
     +  .413511E+05, .316503E+05, .242180E+05, .185301E+05,
     +  .141744E+05, .108426E+05, .829224E+04, .634228E+04,
     +  .485027E+04, .370998E+04, .283778E+04, .217142E+04,
     +  .166187E+04, .127268E+04, .975126E+03, .747861E+03,
     +  .574089E+03, .441337E+03, .339808E+03, .262240E+03,
     +  .202114E+03, .156843E+03, .122124E+03, .955051E+02,
     +  .750383E+02, .592925E+02, .471687E+02, .377704E+02,
     +  .304709E+02, .247862E+02, .203286E+02, .168179E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .140275E+02, .117988E+02, .999671E+01, .852832E+01,
     +  .731791E+01, .631122E+01, .546424E+01, .474792E+01,
     +  .412977E+01, .359916E+01, .313428E+01, .272915E+01,
     +  .237315E+01, .205986E+01, .178400E+01, .154137E+01,
     +  .132837E+01, .114180E+01, .978812E+00, .836702E+00,
     +  .713037E+00, .605587E+00, .512423E+00, .431677E+00,
     +  .362224E+00, .301969E+00, .250229E+00, .205954E+00,
     +  .168254E+00, .136311E+00, .109418E+00, .869257E-01,
     +  .682741E-01, .529448E-01, .404439E-01, .304699E-01,
     +  .224983E-01, .162704E-01, .114923E-01, .789815E-02,
     +  .525610E-02, .336360E-02, .205723E-02, .118424E-02,
     +  .635521E-03, .310090E-03, .133211E-03, .476265E-04,
     +  .128941E-04, .218660E-05, .135736E-06, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .375819E+06, .290122E+06, .220887E+06, .168113E+06,
     +  .127922E+06, .973028E+05, .739977E+05, .562539E+05,
     +  .427570E+05, .324871E+05, .246801E+05, .187433E+05,
     +  .142330E+05, .108052E+05, .820266E+04, .622579E+04,
     +  .472569E+04, .358681E+04, .272304E+04, .206754E+04,
     +  .157061E+04, .119362E+04, .907862E+03, .691094E+03,
     +  .526778E+03, .402116E+03, .307632E+03, .234990E+03,
     +  .180735E+03, .139470E+03, .108086E+03, .841547E+02,
     +  .658902E+02, .519428E+02, .412154E+02, .329507E+02,
     +  .265633E+02, .215935E+02, .177080E+02, .146428E+02,
     +  .122118E+02, .102605E+02, .868134E+01, .738902E+01,
     +  .632169E+01, .543029E+01, .468191E+01, .404108E+01,
     +  .349535E+01, .302122E+01, .261152E+01, .225470E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .194346E+01, .167181E+01, .143493E+01, .122868E+01,
     +  .104945E+01, .894026E+00, .759485E+00, .643224E+00,
     +  .542900E+00, .456509E+00, .382140E+00, .318613E+00,
     +  .263886E+00, .217230E+00, .177596E+00, .144098E+00,
     +  .115929E+00, .923961E-01, .728684E-01, .568059E-01,
     +  .437141E-01, .331272E-01, .247537E-01, .181214E-01,
     +  .129885E-01, .908860E-02, .618436E-02, .407223E-02,
     +  .257644E-02, .155656E-02, .883962E-03, .467311E-03,
     +  .224165E-03, .944173E-04, .329688E-04, .867030E-05,
     +  .142167E-05, .879685E-07, .000000E+00, .525115E+06,
     +  .403207E+06, .305084E+06, .230745E+06, .174470E+06,
     +  .131862E+06, .996308E+05, .752456E+05, .568134E+05,
     +  .428785E+05, .323534E+05, .244024E+05, .184015E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .138716E+05, .104553E+05, .787827E+04, .593619E+04,
     +  .447219E+04, .336964E+04, .253900E+04, .191382E+04,
     +  .144304E+04, .108883E+04, .822174E+03, .621561E+03,
     +  .470531E+03, .356949E+03, .270313E+03, .206115E+03,
     +  .157679E+03, .121129E+03, .934842E+02, .725500E+02,
     +  .566919E+02, .445889E+02, .353377E+02, .282414E+02,
     +  .227621E+02, .185091E+02, .151785E+02, .125553E+02,
     +  .104644E+02, .878377E+01, .741796E+01, .629757E+01,
     +  .536844E+01, .459391E+01, .393559E+01, .337919E+01,
     +  .289965E+01, .248863E+01, .213366E+01, .182661E+01,
     +  .156086E+01, .133100E+01, .113244E+01, .961175E+00,
     +  .813742E+00, .687003E+00, .578233E+00, .485007E+00,
     +  .405271E+00, .337091E+00, .279251E+00, .229771E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .187888E+00, .152568E+00, .122937E+00, .982079E-01,
     +  .777078E-01, .608313E-01, .470622E-01, .359335E-01,
     +  .270101E-01, .200146E-01, .145243E-01, .103156E-01,
     +  .714964E-02, .481596E-02, .313725E-02, .196217E-02,
     +  .117095E-02, .656132E-03, .341865E-03, .161399E-03,
     +  .668072E-04, .228955E-04, .591150E-05, .959297E-06,
     +  .615126E-07, .000000E+00, .719715E+06, .549853E+06,
     +  .413606E+06, .310975E+06, .233725E+06, .175577E+06,
     +  .131848E+06, .989598E+05, .742490E+05, .556813E+05,
     +  .417427E+05, .312788E+05, .234307E+05, .175444E+05,
     +  .131336E+05, .982822E+04, .735364E+04, .550077E+04,
     +  .411478E+04, .307782E+04, .230274E+04, .172323E+04,
     +  .129030E+04, .966740E+03, .725094E+03, .544518E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .409733E+03, .307708E+03, .232685E+03, .176519E+03,
     +  .134459E+03, .102894E+03, .791742E+02, .613455E+02,
     +  .478409E+02, .375973E+02, .297973E+02, .238192E+02,
     +  .192118E+02, .156292E+02, .128265E+02, .106078E+02,
     +  .883608E+01, .740592E+01, .624045E+01, .528049E+01,
     +  .448573E+01, .381504E+01, .325231E+01, .277101E+01,
     +  .236170E+01, .201103E+01, .171013E+01, .145178E+01,
     +  .123005E+01, .103996E+01, .877191E+00, .738055E+00,
     +  .619264E+00, .517999E+00, .431785E+00, .358538E+00,
     +  .296326E+00, .243906E+00, .199375E+00, .161949E+00,
     +  .130615E+00, .104520E+00, .829075E-01, .651279E-01,
     +  .506062E-01, .388539E-01, .294344E-01, .219453E-01,
     +  .161257E-01, .115999E-01, .816365E-02, .560411E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .373676E-02, .240812E-02, .148888E-02, .877630E-03,
     +  .485242E-03, .249193E-03, .115806E-03, .471221E-04,
     +  .158612E-04, .402655E-05, .648548E-06, .431651E-07,
     +  .000000E+00, .968713E+06, .736560E+06, .550961E+06,
     +  .411914E+06, .307825E+06, .229908E+06, .171638E+06,
     +  .128063E+06, .955091E+05, .711901E+05, .530408E+05,
     +  .394969E+05, .293997E+05, .218727E+05, .162672E+05,
     +  .120928E+05, .898739E+04, .667717E+04, .496026E+04,
     +  .368422E+04, .273679E+04, .203323E+04, .151122E+04,
     +  .112382E+04, .836522E+03, .623357E+03, .465401E+03,
     +  .346717E+03, .260090E+03, .195721E+03, .147875E+03,
     +  .112240E+03, .856594E+02, .658306E+02, .509213E+02,
     +  .396957E+02, .312090E+02, .247511E+02, .198080E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .159907E+02, .130240E+02, .106908E+02, .883953E+01,
     +  .735480E+01, .615255E+01, .516877E+01, .435968E+01,
     +  .368158E+01, .311664E+01, .263702E+01, .223219E+01,
     +  .188803E+01, .159498E+01, .134530E+01, .113261E+01,
     +  .951600E+00, .797701E+00, .667048E+00, .556245E+00,
     +  .462416E+00, .383060E+00, .316086E+00, .259579E+00,
     +  .212289E+00, .172394E+00, .139100E+00, .111426E+00,
     +  .885493E-01, .697431E-01, .543905E-01, .419496E-01,
     +  .319624E-01, .240240E-01, .177657E-01, .129452E-01,
     +  .923045E-02, .643679E-02, .437636E-02, .288856E-02,
     +  .184151E-02, .112549E-02, .655309E-03, .357516E-03,
     +  .180972E-03, .827963E-04, .331266E-04, .109562E-04,
     +  .273635E-05, .437573E-06, .301834E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .128188E+07, .970251E+06, .721890E+06, .536795E+06,
     +  .398959E+06, .296328E+06, .219985E+06, .163206E+06,
     +  .121020E+06, .896802E+05, .664227E+05, .491660E+05,
     +  .363749E+05, .268955E+05, .198778E+05, .146833E+05,
     +  .108424E+05, .800269E+04, .590548E+04, .435671E+04,
     +  .321417E+04, .237126E+04, .175001E+04, .129204E+04,
     +  .954724E+03, .706162E+03, .523264E+03, .386821E+03,
     +  .287944E+03, .215004E+03, .161176E+03, .121377E+03,
     +  .919047E+02, .700785E+02, .537838E+02, .416029E+02,
     +  .324577E+02, .255468E+02, .202921E+02, .162609E+02,
     +  .131476E+02, .107148E+02, .879617E+01, .726703E+01,
     +  .603644E+01, .503581E+01, .421814E+01, .353740E+01,
     +  .297414E+01, .249934E+01, .210149E+01, .176577E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .148203E+01, .124207E+01, .103914E+01, .867661E+00,
     +  .722864E+00, .600764E+00, .497897E+00, .411359E+00,
     +  .338650E+00, .277688E+00, .226594E+00, .184122E+00,
     +  .148540E+00, .119053E+00, .947205E-01, .747519E-01,
     +  .584594E-01, .452604E-01, .346485E-01, .261979E-01,
     +  .195366E-01, .143293E-01, .103535E-01, .731768E-02,
     +  .505621E-02, .340467E-02, .222440E-02, .140282E-02,
     +  .847533E-03, .487428E-03, .262405E-03, .130934E-03,
     +  .589814E-04, .232091E-04, .754574E-05, .185502E-05,
     +  .294524E-06, .210223E-07, .000000E+00, .166944E+07,
     +  .125810E+07, .931246E+06, .688881E+06, .509303E+06,
     +  .376275E+06, .277832E+06, .204998E+06, .151169E+06,
     +  .111395E+06, .820373E+05, .603744E+05, .444064E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .326396E+05, .239780E+05, .176039E+05, .129184E+05,
     +  .947504E+04, .694726E+04, .509200E+04, .373184E+04,
     +  .273471E+04, .200448E+04, .146968E+04, .107836E+04,
     +  .791904E+03, .582555E+03, .427456E+03, .315840E+03,
     +  .234076E+03, .174156E+03, .130165E+03, .978153E+02,
     +  .740262E+02, .563884E+02, .432942E+02, .335290E+02,
     +  .261988E+02, .206608E+02, .164392E+02, .131988E+02,
     +  .106818E+02, .870871E+01, .714551E+01, .589497E+01,
     +  .488431E+01, .406358E+01, .338469E+01, .282668E+01,
     +  .235956E+01, .197090E+01, .164529E+01, .137208E+01,
     +  .114267E+01, .950029E+00, .788366E+00, .652779E+00,
     +  .539198E+00, .444134E+00, .364678E+00, .298354E+00,
     +  .243110E+00, .197114E+00, .159137E+00, .127539E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .101538E+00, .802352E-01, .628807E-01, .488268E-01,
     +  .375280E-01, .285150E-01, .213952E-01, .158294E-01,
     +  .115152E-01, .825015E-02, .577967E-02, .395683E-02,
     +  .263870E-02, .170641E-02, .106455E-02, .635767E-03,
     +  .361162E-03, .191863E-03, .943765E-04, .418650E-04,
     +  .162062E-04, .518159E-05, .125446E-05, .197766E-06,
     +  .145853E-07, .000000E+00, .214181E+07, .160733E+07,
     +  .118384E+07, .871349E+06, .640937E+06, .471097E+06,
     +  .346036E+06, .253980E+06, .186289E+06, .136533E+06,
     +  .999989E+05, .731843E+05, .535248E+05, .391169E+05,
     +  .285696E+05, .208514E+05, .152100E+05, .110881E+05,
     +  .807982E+04, .588501E+04, .428555E+04, .312016E+04,
     +  .227198E+04, .165469E+04, .120588E+04, .879450E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .642450E+03, .468037E+03, .343364E+03, .252652E+03,
     +  .186620E+03, .138473E+03, .103306E+03, .776195E+02,
     +  .587015E+02, .447502E+02, .344128E+02, .267026E+02,
     +  .209134E+02, .165271E+02, .131799E+02, .105952E+02,
     +  .858046E+01, .699347E+01, .573119E+01, .471704E+01,
     +  .389845E+01, .322556E+01, .267606E+01, .221916E+01,
     +  .184160E+01, .152750E+01, .126578E+01, .104756E+01,
     +  .865567E+00, .713871E+00, .587484E+00, .482301E+00,
     +  .394833E+00, .322197E+00, .261959E+00, .212111E+00,
     +  .170882E+00, .137068E+00, .109129E+00, .862987E-01,
     +  .677281E-01, .527093E-01, .406375E-01, .310062E-01,
     +  .233836E-01, .174103E-01, .127793E-01, .922002E-02,
     +  .654998E-02, .454805E-02, .308496E-02, .203738E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .130411E-02, .804776E-03, .475101E-03, .266590E-03,
     +  .139757E-03, .677758E-04, .296109E-04, .112792E-04,
     +  .354793E-05, .846264E-06, .132486E-06, .100817E-07,
     +  .000000E+00, .270926E+07, .202497E+07, .148427E+07,
     +  .108718E+07, .795765E+06, .581992E+06, .425340E+06,
     +  .310595E+06, .226638E+06, .165236E+06, .120380E+06,
     +  .876267E+05, .637380E+05, .463233E+05, .336430E+05,
     +  .244144E+05, .177061E+05, .128319E+05, .929478E+04,
     +  .672895E+04, .486998E+04, .352352E+04, .254941E+04,
     +  .184479E+04, .133563E+04, .967601E+03, .702099E+03,
     +  .507975E+03, .370112E+03, .270458E+03, .198388E+03,
     +  .146184E+03, .108302E+03, .808135E+02, .606974E+02,
     +  .459573E+02, .351032E+02, .270572E+02, .210515E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .165277E+02, .130948E+02, .104587E+02, .841516E+01,
     +  .681439E+01, .554824E+01, .453677E+01, .372516E+01,
     +  .306205E+01, .252396E+01, .207948E+01, .171463E+01,
     +  .141317E+01, .116370E+01, .957104E+00, .785963E+00,
     +  .644256E+00, .526962E+00, .429974E+00, .349837E+00,
     +  .283716E+00, .229235E+00, .184444E+00, .147641E+00,
     +  .117661E+00, .930587E-01, .730962E-01, .569742E-01,
     +  .440306E-01, .337044E-01, .255284E-01, .191082E-01,
     +  .141175E-01, .102802E-01, .735587E-02, .518141E-02,
     +  .356589E-02, .239641E-02, .156730E-02, .992954E-03,
     +  .606132E-03, .353716E-03, .196053E-03, .101429E-03,
     +  .484985E-04, .208721E-04, .782531E-05, .242261E-05,
     +  .569546E-06, .885543E-07, .694377E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
