/*
 * Copyright 2015 MiLaboratory.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.milaboratory.core.io.sequence;

/**
 * Common class for sequence writers.
 *
 * @param <R> type of reads
 */
public interface SequenceWriter<R extends SequenceRead> extends AutoCloseable {
    /**
     * Writes corresponding subtype of {@link com.milaboratory.core.io.sequence.SequenceRead}
     *
     * @param read read
     */
    void write(R read);

    /**
     * Writes all buffers to the underlying stream
     */
    void flush();

    /**
     * Closes this writer
     */
    @Override
    void close();
}
