/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import org.apache.hadoop.util.DataChecksum;

public class ChecksumUtil {
    public static void updateChunkChecksum(byte[] buf, int checksumOff, int dataOff, int dataLen, DataChecksum checksum) throws IOException {
        int bytesPerChecksum = checksum.getBytesPerChecksum();
        int checksumSize = checksum.getChecksumSize();
        int curChecksumOff = checksumOff;
        int curDataOff = dataOff;
        int numChunks = (dataLen + bytesPerChecksum - 1) / bytesPerChecksum;
        int dataLeft = dataLen;
        for (int i = 0; i < numChunks; ++i) {
            int len = Math.min(dataLeft, bytesPerChecksum);
            checksum.reset();
            checksum.update(buf, curDataOff, len);
            checksum.writeValue(buf, curChecksumOff, false);
            curDataOff += len;
            curChecksumOff += checksumSize;
            dataLeft -= len;
        }
    }
}

