% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.degradation.matrix.R
\name{read.degradation.matrix}
\alias{read.degradation.matrix}
\title{A function for reading in coverage data from degradation-susceptible regions}
\usage{
read.degradation.matrix(
  covFiles,
  sampleNames,
  totalMapped,
  readLength = 100,
  normFactor = 8e+07,
  type = c("bwtool", "region_matrix_single", "region_matrix_all"),
  BPPARAM = bpparam()
)
}
\arguments{
\item{covFiles}{coverage file(s) for degradation regions}

\item{sampleNames}{sample names; creates column names of degradation matrix}

\item{totalMapped}{how many reads per sample (library size normalization)}

\item{readLength}{read length in base pairs (read length normalization)}

\item{normFactor}{common library size to normalize to; 80M reads as default}

\item{type}{whether input are individual `bwtool` output, `region_matrix` run on individual samples, or `region_matrix` run on all samples together}

\item{BPPARAM}{(Optional) BiocParallelParam for parallel operation}
}
\value{
the normalized degradation matrix, region by sample
}
\description{
This function reads in degradation regions to form 
a library-size- and read-length-normalized 
degradation matrix for subsequent RNA quality correction
}
\examples{
# bwtool
bwPath = system.file('extdata', 'bwtool', package = 'sva')
degCovAdj = read.degradation.matrix(
 covFiles = list.files(bwPath,full.names=TRUE),
 sampleNames = list.files(bwPath), readLength = 76, 
 totalMapped = rep(100e6,5),type="bwtool")
 head(degCovAdj)
 
# region_matrix: each sample
r1Path = system.file('extdata', 'region_matrix_one', package = 'sva')
degCovAdj1 = read.degradation.matrix(
 covFiles = list.files(r1Path,full.names=TRUE),
 sampleNames = list.files(r1Path), readLength = 76, 
 totalMapped = rep(100e6,5),type="region_matrix_single")
 head(degCovAdj1)
 
r2Path = system.file('extdata', 'region_matrix_all', package = 'sva')
degCovAdj2 = read.degradation.matrix(
 covFiles = list.files(r2Path,full.names=TRUE),
 sampleNames = list.files(r1Path), readLength = 76, 
 totalMapped = rep(100e6,5),type="region_matrix_all")
head(degCovAdj2)

}
