% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdata-methods.R
\docType{methods}
\name{tdata}
\alias{tdata}
\alias{tdata,phylo4d-method}
\alias{tdata<-}
\alias{tdata<-}
\alias{tdata<-,phylo4d-method}
\alias{tdata<-,phylo4d,ANY-method}
\alias{tipData}
\alias{tipData-method}
\alias{tipData}
\alias{tipData,phylo4d-method}
\alias{tipData<-}
\alias{tipData<-}
\alias{tipData<-,phylo4d-method}
\alias{tipData<-,phylo4d,ANY-method}
\alias{nodeData}
\alias{nodeData-method}
\alias{nodeData}
\alias{nodeData,phylo4d-method}
\alias{nodeData<-}
\alias{nodeData<-}
\alias{nodeData<-,phylo4d-method}
\alias{nodeData<-,phylo4d,ANY-method}
\title{Retrieving or updating tip and node data in phylo4d objects}
\usage{
tdata(x, ...)

\S4method{tdata}{phylo4d}(x, type = c("all", "tip", "internal"),
  label.type = c("row.names", "column"), empty.columns = TRUE)

tdata(x, ...) <- value

\S4method{tdata}{phylo4d}(x, type = c("all", "tip", "internal"),
  merge.data = TRUE, clear.all = FALSE, ...) <- value

tipData(x, ...)

\S4method{tipData}{phylo4d}(x, ...)

tipData(x, ...) <- value

\S4method{tipData}{phylo4d}(x, ...) <- value

nodeData(x, ...)

\S4method{nodeData}{phylo4d}(x, ...)

nodeData(x, ...) <- value

\S4method{nodeData}{phylo4d}(x, ...) <- value
}
\arguments{
\item{x}{A \code{phylo4d} object}

\item{\dots}{For the \code{tipData} and \code{nodeData} accessors,
further arguments to be used by \code{tdata}. For the replacement
forms, further arguments to be used to control matching between
tree and data (see Details section of \code{\link{phylo4d-methods}}).}

\item{type}{The type of data to retrieve or update: \dQuote{\code{all}}
(default) for data associated with both tip and internal nodes,
\dQuote{\code{tip}} for data associated with tips only,
\dQuote{\code{internal}} for data associated with internal nodes only.}

\item{label.type}{How should the tip/node labels from the tree be returned?
\dQuote{\code{row.names}} returns them as row names of the data frame,
\dQuote{\code{column}} returns them in the first column of the data frame.
This options is useful in the case of missing (\code{NA}) or non-unique
labels.}

\item{empty.columns}{Should columns filled with \code{NA} be returned?}

\item{value}{a data frame (or object to be coerced to one) to replace the
values associated with the nodes specified by the argument \code{type}}

\item{merge.data}{if tip or internal node data are provided and data already
exists for the other type, this determines whether columns with common names
will be merged together (default TRUE). If FALSE, columns with common names
will be preserved separately, with \dQuote{.tip} and \dQuote{.node} appended
to the names. This argument has no effect if tip and node data have no
column names in common, or if type=\dQuote{all}.}

\item{clear.all}{If only tip or internal node data are to be replaced,
should data of the other type be dropped?}
}
\value{
\code{tdata} returns a data frame
}
\description{
Methods to retrieve or update tip, node or all data associated with a
phylogenetic tree stored as a phylo4d object
}
\section{Methods}{
 \describe{
\item{tdata}{\code{signature(object="phylo4d")}: retrieve or update data
associated with a tree in a \code{phylo4d} object} }
}

\examples{
   data(geospiza)
   tdata(geospiza)
   tipData(geospiza) <- 1:nTips(geospiza)
   tdata(geospiza)
}
\seealso{
\code{\link{phylo4d-methods}}, \code{\linkS4class{phylo4d}}
}
\author{
Ben Bolker, Thibaut Jombart, Francois Michonneau
}
\keyword{methods}
