\name{Dual-tree Filter Banks}
\alias{afb}
\alias{afb2D}
\alias{afb2D.A}
\alias{sfb}
\alias{sfb2D}
\alias{sfb2D.A}
\title{Filter Banks for Dual-Tree Wavelet Transforms}
\description{
  Analysis and synthesis filter banks used in dual-tree wavelet
  algorithms.
}
\usage{
afb(x, af)
afb2D(x, af1, af2 = NULL)
afb2D.A(x, af, d)
sfb(lo, hi, sf)
sfb2D(lo, hi, sf1, sf2 = NULL)
sfb2D.A(lo, hi, sf, d)
}
\arguments{
  \item{x}{vector or matrix of observations}
  \item{af}{analysis filters.  First element of the list is the low-pass
    filter, second element is the high-pass filter.}
  \item{af1,af2}{analysis filters for the first and second dimension of
    a 2D array.}
  \item{sf}{synthesis filters.  First element of the list is the
    low-pass filter, second element is the high-pass filter.}
  \item{sf1,sf2}{synthesis filters for the first and second dimension of
    a 2D array.}
  \item{d}{dimension of filtering (d = 1 or 2)}
  \item{lo}{low-frequecy coefficients}
  \item{hi}{high-frequency coefficients}
}
\details{
  The functions \code{afb2D.A} and \code{sfb2D.A} implement the
  convolutions, either for analysis or synthesis, in one dimension
  only.  Thus, they are the workhorses of \code{afb2D} and
  \code{sfb2D}.  The output for the analysis filter bank along one
  dimension (\code{afb2D.A}) is a list with two elements
  \describe{
    \item{lo}{low-pass subband}
    \item{hi}{high-pass subband}
  }
  where the dimension of analysis will be half its original length.  The
  output for the synthesis filter bank along one dimension
  (\code{sfb2D.A}) will be the output array, where the dimension of
  synthesis will be twice its original length.
}
\value{
  In one dimension the output for the analysis filter bank (\code{afb})
  is a list with two elements
  \item{lo}{Low frequecy output}
  \item{hi}{High frequency output}
  and the output for the synthesis filter bank (\code{sfb}) is the
  output signal.
  
  In two dimensions the output for the analysis filter bank
  (\code{afb2D}) is a list with four elements
  \item{lo}{low-pass subband}
  \item{hi[[1]]}{'lohi' subband}
  \item{hi[[2]]}{'hilo' subband}
  \item{hi[[3]]}{'hihi' subband}
  and the output for the synthesis filter bank (\code{sfb2D}) is the
  output array.

}
\references{
  WAVELET SOFTWARE AT POLYTECHNIC UNIVERSITY, BROOKLYN, NY\cr
  \url{http://taco.poly.edu/WaveletSoftware/}
}
%\seealso{}
\examples{
## EXAMPLE: afb, sfb
af = farras()$af
sf = farras()$sf
x = rnorm(64)
x.afb = afb(x, af)
lo = x.afb$lo
hi = x.afb$hi
y = sfb(lo, hi, sf)
err = x - y
max(abs(err))

## EXAMPLE: afb2D, sfb2D
x = matrix(rnorm(32*64), 32, 64)
af = farras()$af
sf = farras()$sf
x.afb2D = afb2D(x, af, af)
lo = x.afb2D$lo
hi = x.afb2D$hi
y = sfb2D(lo, hi, sf, sf)
err = x - y
max(abs(err))

## Example: afb2D.A, sfb2D.A
x = matrix(rnorm(32*64), 32, 64)
af = farras()$af
sf = farras()$sf
x.afb2D.A = afb2D.A(x, af, 1)
lo = x.afb2D.A$lo
hi = x.afb2D.A$hi
y = sfb2D.A(lo, hi, sf, 1)
err = x - y
max(abs(err))
}
\author{Matlab: S. Cai, K. Li and I. Selesnick; R port: B. Whitcher}
\keyword{ts}
