#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "harten.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float err_expected = (argc > 1) ? atof(argv[1]) : 1;
  branch even("t","u");
  Float t=0; field uh;
  Float err_linf_l1 = 0;
  dout << "# t err_l1(t)" << endl;
  while (din >> even(t,uh)) {
    const geo& omega = uh.get_geo();
    quadrature_option_type qopt;
    qopt.set_order (2*uh.get_space().degree()+1);
    Float err_l1 = integrate (omega, fabs(uh - harten(t)), qopt);
    err_linf_l1 = max(err_linf_l1, err_l1);
    dout << t << " " << err_l1 << endl;
  }
  dout << "# err_linf_l1 = " << err_linf_l1 << endl;
  return (err_linf_l1 <= err_expected) ? 0 : 1;
}
