/*
*  Rubrica
*  file: prefererences.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_PREFERENCES_H
#define __RUBRICA_PREFERENCES_H

#include <gtk/gtk.h>

#include "types.h"

void rubrica_preferences_setup_search_on   (GtkTreeView* view);
void rubrica_preferences_set_search_on     (GtkWidget* button, gpointer col);
void rubrica_preferences_setup_radio_group (GSList* group);

enum {
  RUB_ICONS = 0,
  RUB_TEXT,
  RUB_BOTH,
  RUB_GNOME
};


enum {  
  RUB_EPIPHANY = 0,
  RUB_FIREFOX,
  RUB_GALEON,
  RUB_KONQUEROR,
  RUB_MOZILLA,
  RUB_SEAMONKEY,
  RUB_OPERA,
  RUB_OTHER_BROWSER
};

enum {
  RUB_BALSA = 0,
  RUB_EVOLUTION,
  RUB_MOZILLA_MAIL,
  RUB_SEAMONKEY_MAIL,
  RUB_THUNDERBIRD,
  RUB_OTHER_EMAILER
};

enum {
  RUB_PIDGIN = 0,
  RUB_GAIM,
  RUB_GABBER,
  RUB_GAJIM,
  RUB_GADU,
  RUB_GOSSIP,
  RUB_OTHER_IRC
};


#define KEY_MISC                          "/apps/rubrica2"
#define RUBRICA_GCONF_FILE_FORMAT         KEY_MISC"/file_format"
#define RUBRICA_GCONF_WIDTH               KEY_MISC"/width" 
#define RUBRICA_GCONF_HEIGHT              KEY_MISC"/heigth" 
#define RUBRICA_GCONF_PANED_POSITION      KEY_MISC"/paned"
#define RUBRICA_GCONF_CRYPT               KEY_MISC"/crypt" 
#define RUBRICA_GCONF_COPYRIGHT           KEY_MISC"/copyright" 


/* file managment */
#define KEY_FILE                          "/apps/rubrica2/file"
#define RUBRICA_GCONF_FOLDER              KEY_FILE"/folder"
#define RUBRICA_GCONF_LOAD_FILES          KEY_FILE"/load_files"
#define RUBRICA_GCONF_FILES               KEY_FILE"/files"
#define RUBRICA_GCONF_RATE                KEY_FILE"/compression_rate"
#define RUBRICA_GCONF_AUTOSAVE            KEY_FILE"/autosave"
#define RUBRICA_GCONF_BACKUP              KEY_FILE"/make_backup"


/* columns to display */
#define KEY_DISPLAY                       "/apps/rubrica2/display"
#define RUBRICA_GCONF_CARD                KEY_DISPLAY"/card"
#define RUBRICA_GCONF_FIRST_NAME          KEY_DISPLAY"/first_name"
#define RUBRICA_GCONF_LAST_NAME           KEY_DISPLAY"/last_name"
#define RUBRICA_GCONF_PROFESSION          KEY_DISPLAY"/profession"
#define RUBRICA_GCONF_CITY                KEY_DISPLAY"/city"
#define RUBRICA_GCONF_COUNTRY             KEY_DISPLAY"/country"
#define RUBRICA_GCONF_WEB                 KEY_DISPLAY"/web"
#define RUBRICA_GCONF_EMAIL               KEY_DISPLAY"/email"
#define RUBRICA_GCONF_TELEPHONE           KEY_DISPLAY"/telephone"
#define RUBRICA_GCONF_COMPANY             KEY_DISPLAY"/company"
#define RUBRICA_GCONF_ASSIGNMENT          KEY_DISPLAY"/assignment"


/* search rules */    
#define KEY_SEARCH                        "/apps/rubrica2/search"
#define RUBRICA_GCONF_SEARCH_ON           KEY_SEARCH"/performed_on"


/* appearance rules */
#define KEY_APPEARANCE                    "/apps/rubrica2/appearance"  
#define RUBRICA_GCONF_TOOLBAR             KEY_APPEARANCE"/toolbar_style"
#define RUBRICA_GCONF_FONT                KEY_APPEARANCE"/font"
#define RUBRICA_GCONF_CONFIRM_EXIT        KEY_APPEARANCE"/confirm_exit"


/* urls management */
#define KEY_URLS                          "/apps/rubrica2/urls_manager"
#define RUBRICA_GCONF_BROWSER             KEY_URLS"/browser"
#define RUBRICA_GCONF_EMAILS              KEY_URLS"/emailer"
#define RUBRICA_GCONF_IRC                 KEY_URLS"/irc"
#define RUBRICA_GCONF_BROWSER_UD          KEY_URLS"/browser_user_defined"
#define RUBRICA_GCONF_EMAILS_UD           KEY_URLS"/emailer_user_defined"
#define RUBRICA_GCONF_IRC_UD              KEY_URLS"/irc_user_defined"
#define RUBRICA_GCONF_EKIGA               KEY_URLS"/ekiga"


void rubrica_preferences_setup_colum      (GtkTreeViewColumn* column, 
					   gchar* key);
void rubrica_preferences_setup_menu_check (GtkWidget* item, gchar* key);
void rubrica_preferences_run_gui          (GtkWidget* button, gpointer data);

#endif
