require 'spec_helper'

describe Elasticsearch::DSL::Search::Aggregations::CumulativeSum do

  let(:search) do
    described_class.new
  end

  describe '#to_hash' do

    it 'can be converted to a hash' do
      expect(search.to_hash).to eq(cumulative_sum: {})
    end
  end

  context 'when options methods are called' do

    let(:search) do
      described_class.new(:foo)
    end

    describe '#buckets_path' do

      before do
        search.buckets_path('bar')
      end

      it 'applies the option' do
        expect(search.to_hash[:cumulative_sum][:foo][:buckets_path]).to eq('bar')
      end
    end

    describe '#script' do

      before do
        search.format('bar')
      end

      it 'applies the option' do
        expect(search.to_hash[:cumulative_sum][:foo][:format]).to eq('bar')
      end
    end
  end

  describe '#initialize' do

    context 'when a block is provided' do

      let(:search) do
        described_class.new(:foo) do
          format 'bar'
        end
      end

      it 'executes the block' do
        expect(search.to_hash).to eq({ cumulative_sum: { foo: { format: 'bar' } } })
      end
    end
  end
end
