'''
exploitResult.py

Copyright 2007 Andres Riancho

This file is part of w3af, w3af.sourceforge.net .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'''

from core.controllers.misc.commonAttackMethods import commonAttackMethods
from core.controllers.w3afException import w3afException

class exploitResult(commonAttackMethods):
    '''
    This class represents the output of an attack plugin.
    
    @author: Andres Riancho ( andres.riancho@gmail.com )
    '''

    def __init__(self):
        self._id = None
    
    def setExploitResultId( self, id ):
        '''
        Each exploitResult is identified by an unique number.
        @parameter id: The integer that identifies the exploitResult
        '''
        self._id = id

    def getExploitResultId( self ):
        return self._id

    def __repr__( self ):
        raise w3afException('You have to implement a __repr__ method if you inherit from exploitResult.')
        
    __str__ = __repr__
