/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.EditorPane;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

public class DraggableMolecule
extends JLabel
implements MouseListener,
MouseMotionListener {
    EditorPane src;
    TransferMoleculeSource trans;

    public DraggableMolecule(EditorPane src) {
        this.src = src;
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/SmallIcon.png")));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.trans = new TransferMoleculeSource(src);
        this.setTransferHandler(this.trans);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.src.molData().numAtoms() > 0) {
            this.trans.exportAsDrag(this, e, 1);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    class TransferMoleculeSource
    extends TransferHandler {
        EditorPane src;

        public TransferMoleculeSource(EditorPane src) {
            this.src = src;
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            return false;
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        public void exportAsDrag(JComponent source, InputEvent e, int action) {
            super.exportAsDrag(source, e, action);
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
        }

        protected Transferable createTransferable(JComponent c) {
            Molecule mol = this.src.selectedSubgraph();
            try {
                StringWriter sw = new StringWriter();
                BufferedWriter bw = new BufferedWriter(sw);
                MoleculeStream.writeMDLMOL(bw, mol);
                MoleculeStream.writeNative(bw, mol);
                return new StringSelection(sw.toString());
            }
            catch (IOException ex) {
                return null;
            }
        }
    }
}

