// Copyright 2024 Google LLC
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

#ifndef XNN_UKERNEL_WITH_PARAMS
#define XNN_UKERNEL_WITH_PARAMS(arch_flags, ukernel, channel_tile, channel_scaled_tile, primary_tile, incremental_tile, qmin, qmax, params_type, init_params) \
    XNN_UKERNEL(arch_flags, ukernel, channel_tile, channel_scaled_tile, primary_tile, incremental_tile, qmin, qmax)
#define XNN_DEFINED_UKERNEL_WITH_PARAMS
#endif

#ifndef XNN_UKERNEL
#define XNN_UKERNEL(arch_flags, ukernel, channel_tile, channel_scaled_tile, primary_tile, incremental_tile, qmin, qmax) \
    XNN_UKERNEL_WITH_PARAMS(arch_flags, ukernel, channel_tile, channel_scaled_tile, primary_tile, incremental_tile, qmin, qmax, void, /*init_params=*/nullptr)
#define XNN_DEFINED_UKERNEL
#endif

// arch_flags, ukernel, channel_tile, channel_scaled_tile, primary_tile, incremental_tile, qmin, qmax, params_type, init_params

#if XNN_ARCH_ARM || XNN_ARCH_ARM64
XNN_UKERNEL_WITH_PARAMS(xnn_arch_arm_neon, xnn_s8_maxpool_minmax_ukernel_2p2x__neon_c16, 16, 16, 2, 2, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
XNN_UKERNEL_WITH_PARAMS(xnn_arch_arm_neon, xnn_s8_maxpool_minmax_ukernel_4p3x__neon_c16, 16, 16, 4, 3, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
XNN_UKERNEL_WITH_PARAMS(xnn_arch_arm_neon, xnn_s8_maxpool_minmax_ukernel_9p8x__neon_c16, 16, 16, 9, 8, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64

#if XNN_ARCH_X86 || XNN_ARCH_X86_64
XNN_UKERNEL_WITH_PARAMS(0, xnn_s8_maxpool_minmax_ukernel_9p8x__sse2_c16, 16, 16, 9, 8, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
XNN_UKERNEL_WITH_PARAMS(xnn_arch_x86_sse4_1, xnn_s8_maxpool_minmax_ukernel_9p8x__sse41_c16, 16, 16, 9, 8, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64

#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
XNN_UKERNEL_WITH_PARAMS(0, xnn_s8_maxpool_minmax_ukernel_9p8x__wasmsimd_c16, 16, 16, 9, 8, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD

XNN_UKERNEL_WITH_PARAMS(0, xnn_s8_maxpool_minmax_ukernel_9p8x__scalar_c1, 1, 1, 9, 8, -64, 64, xnn_init_s8_minmax_params_fn, xnn_init_s8_minmax_scalar_params)


#ifdef XNN_DEFINED_UKERNEL_WITH_PARAMS
#undef XNN_DEFINED_UKERNEL_WITH_PARAMS
#undef XNN_UKERNEL_WITH_PARAMS
#endif

#ifdef XNN_DEFINED_UKERNEL
#undef XNN_DEFINED_UKERNEL
#undef XNN_UKERNEL
#endif

