/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _FORMULA_H
#define _FORMULA_H

typedef struct {
	const char *token;
	float value;
} FormulaToken;

/* Loosely based on the FICS sources. */
typedef enum {
	OP_BAD = -1,

	OP_NONE,

	/* Grouping */
	OP_ENDGROUP,

	/* Boolean */
	OP_OR, OP_AND, /* unary OP_NOT, */

	/* Comparison */
	OP_EQ, OP_NEQ,
	OP_GT, OP_GE,
	OP_LT, OP_LE,

	/* Mathematical */
	OP_ADD, OP_SUB,
	OP_MULT, OP_DIV
} Operator;

typedef struct {
	const char *token;
	Operator op;
} OperatorDef;

typedef struct {
	const char *name;
	float (*func)(float);
} FunctionDef;

extern int checkFormula(Table *);
extern bool validateFormula(Variable *, void *);

#endif
