<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_expires - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_expires</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_expires.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_expires.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_expires.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_expires.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Gnration des en-ttes HTTP <code>Expires</code> et
<code>Cache-Control</code> en fonction de critres spcifis par
l'utilisateur</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>expires_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_expires.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet de contrler la dfinition de l'en-tte HTTP
    <code>Expires</code> et la directive <code>max-age</code> de
    l'en-tte HTTP <code>Cache-Control</code> dans les rponses du
    serveur. La date d'expiration peut tre dfinie soit par rapport 
    la date de dernire modification du fichier source, soit
    par rapport  l'heure d'accs du client.</p>

    <p>Ces en-ttes HTTP permettent d'informer le client quant  la
    validit et  la persistence du document. S'il est prsent dans le
    cache, et tant qu'il n'est pas arriv  expiration, le document sera
    servi  partir de ce dernier, plutt qu' partir du document source.
    Aprs expiration, la copie du document dans le cache sera considre
    comme "expire" et donc invalide, et une nouvelle copie devra tre
    obtenue  partir du document source.</p>

    <p>Pour modifier les directives de contrle du cache autres
    que <code>max-age</code> (voir la <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">RFC
    2616 section 14.9</a>), vous pouvez utiliser la directive <code class="directive"><a href="../mod/mod_headers.html#header">Header</a></code>.</p>

    <p>Lorsque l'en-tte <code>Expires</code> est dj prsent dans la
    rponse gnre par le serveur, par exemple s'il a t cr par un
    script CGI ou un serveur original via un serveur mandataire, ce
    module n'ajoute aucun en-tte <code>Expires</code> ou
    <code>Cache-Control</code>.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#AltSyn">Autre syntaxe de dfinition de
l'intervalle</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#expiresactive">ExpiresActive</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#expiresbytype">ExpiresByType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#expiresdefault">ExpiresDefault</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_expires">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_expires">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="AltSyn" id="AltSyn">Autre syntaxe de dfinition de
l'intervalle</a></h2>
    <p>Pour une syntaxe plus lisible, on peut aussi utiliser les
    directives <code class="directive"><a href="#expiresdefault">ExpiresDefault</a></code> et <code class="directive"><a href="#expiresbytype">ExpiresByType</a></code> comme suit :</p>

    <pre class="prettyprint lang-config">ExpiresDefault "<var>base</var>  [plus <var>num</var> <var>type</var>] [<var>num</var> <var>type</var>] ..."
ExpiresByType type/encoding "<var>base</var>  [plus <var>num</var> <var>type</var>] [<var>num</var> <var>type</var>] ..."</pre>


    <p>o <var>base</var> peut tre :</p>

    <ul>
      <li><code>access</code></li>

      <li><code>now</code> (quivalent 
      '<code>access</code>')</li>

      <li><code>modification</code></li>
    </ul>

    <p>Le mot-cl <code>plus</code> est optionnel. <var>num</var> doit
    correspondre  une valeur entire [compatible avec
    <code>atoi()</code>], et <var>type</var> peut tre choisi parmi :</p>

    <ul>
      <li><code>years</code></li>
      <li><code>months</code></li>
      <li><code>weeks</code></li>
      <li><code>days</code></li>
      <li><code>hours</code></li>
      <li><code>minutes</code></li>
      <li><code>seconds</code></li>
    </ul>

    <p>Par exemple, pour faire expirer par dfaut les documents 1 mois
    aprs leur accs, on peut utiliser une des directives suivantes :</p>
    <pre class="prettyprint lang-config">ExpiresDefault "access plus 1 month"
ExpiresDefault "access plus 4 weeks"
ExpiresDefault "access plus 30 days"</pre>



    <p>La date d'expiration peut tre dfinie plus prcisment en
    ajoutant plusieurs clauses '<var>num</var> <var>type</var>' :</p>

    <pre class="prettyprint lang-config">ExpiresByType text/html "access plus 1 month 15 days 2 hours"
ExpiresByType image/gif "modification plus 5 hours 3 minutes"</pre>


    <p>Notez que si vous utilisez une configuration base sur la date de
    modification, l'en-tte Expires ne sera pas ajout  un contenu qui
    ne provient pas directement d'un fichier sur disque ; et ceci tout
    simplement parce que ce type de contenu ne possde pas de date de
    modification.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="expiresactive" id="expiresactive">Directive</a> <a name="ExpiresActive" id="ExpiresActive">ExpiresActive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la gnration d'en-ttes
<code>Expires</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExpiresActive On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ExpiresActive Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_expires</td></tr>
</table>
    <p>Cette directive permet d'activer ou de dsactiver la gnration
    des en-ttes <code>Expires</code> et <code>Cache-Control</code> pour
    les documents concerns ; en d'autres termes, si cette directive se
    trouve dans un fichier <code>.htaccess</code>, par exemple, elle ne
    s'applique qu'aux documents gnrs  partir du rpertoire
    considr. Si elle est dfinie  <code>Off</code>, les en-ttes ne
    seront gnrs pour aucun document du domaine considr (sauf
    surcharge de la configuration  un niveau infrieur, comme un
    fichier <code>.htaccess</code> qui l'emporterait sur le fichier de
    configuration du serveur). Si elle est dfinie  <code>On</code>,
    les en-ttes seront ajouts aux documents servis en fonction des
    critres dfinis par les directives <code class="directive"><a href="#expiresbytype">ExpiresByType</a></code> et <code class="directive"><a href="#expiresdefault">ExpiresDefault</a></code> (<em>voir plus
    loin</em>).</p>

    <p>Notez que cette directive ne permet pas de garantir qu'un en-tte
    <code>Expires</code> ou <code>Cache-Control</code> sera gnr. Si
    les critres ne sont pas respects, aucun en-tte ne sera gnr, et
    la directive produira le mme effet que si elle n'avait pas t
    dfinie.</p>
 
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="expiresbytype" id="expiresbytype">Directive</a> <a name="ExpiresByType" id="ExpiresByType">ExpiresByType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinition de la valeur de l'en-tte <code>Expires</code>
en fonction du type MIME</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExpiresByType <var>type MIME</var>
<var>&lt;code&gt;secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_expires</td></tr>
</table>
    <p>Cette directive permet de dfinir la valeur de l'en-tte
    <code>Expires</code> et de la directive <code>max-age</code> de
    l'en-tte <code>Cache-Control</code> gnrs pour les documents du
    type MIME spcifi (par exemple, <code>text/html</code>). Le second
    argument dfinit le nombre de secondes qui seront ajoutes  un
    temps de base pour calculer la date d'expiration.
    <code>Cache-Control: max-age</code> se calcule en soustrayant la
    date de la requte de la date d'expiration et s'exprime en
    secondes.</p>

    <p>Le champ <code><var>&lt;code&gt;</var></code> permet de spcifier
    quel temps doit tre utilis comme temps de base; <code>M</code>
    signifie que c'est la date
    de dernire modification du fichier qui doit tre utilise comme
    temps de base, alors que <code>A</code> signifie que c'est le moment
    o le client a accd au document qui doit tre utilis comme temps
    de base.</p>

    <p>La diffrence d'effet est subtile. Si on utilise <code>M</code>,
    toutes les copies existantes du document dans tous les caches
    expireront au mme moment, ce qui peut convenir par exemple pour une
    notice hebdomadaire qui correspond toujours  la mme URL. Si on
    utilise <code>A</code>, la date d'expiration sera diffrente pour
    chaque client, ce qui peut convenir pour des fichiers d'images qui
    ne changent pas trs souvent, et en particulier pour un ensemble de
    documents en relation qui se rfrent tous aux mmes images (ces
    images sont alors accdes de manire rptitive dans un intervalle
    de temps assez court).</p>

    <div class="example"><h3>Exemple :</h3><pre class="prettyprint lang-config"># active la gnration des en-ttes Expires
ExpiresActive On
# les images GIF expirent au bout d'un mois dans le cache du
# client
ExpiresByType image/gif A2592000
# les documents HTML restent valables une semaine aprs leur date
# de dernire modification
ExpiresByType text/html M604800</pre>
</div>

    <p>Notez que cette directive ne produit d'effet que si
    <code>ExpiresActive On</code> a t spcifi. Elle l'emporte, mais
    <em>seulement</em> pour le type MIME spcifi, sur toute date
    d'expiration dfinie par la directive <code class="directive"><a href="#expiresdefault">ExpiresDefault</a></code>.</p>

    <p>Vous pouvez aussi dfinir le mode de calcul de la date
    d'expiration en utilisant une <a href="#AltSyn">syntaxe
    alternative</a>, comme dcrit plus haut dans ce document.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="expiresdefault" id="expiresdefault">Directive</a> <a name="ExpiresDefault" id="ExpiresDefault">ExpiresDefault</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Mode de calcul par dfaut de la date
d'expiration</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExpiresDefault <var>&lt;code&gt;secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_expires</td></tr>
</table>
    <p>Cette directive permet de dfinir le mode de calcul par dfaut de
    la date d'expiration pour tous les documents du domaine considr.
    Elle peut tre annule pour certains types de documents par la
    directive <code class="directive"><a href="#expiresbytype">ExpiresByType</a></code>. Voir la description
    de cette dernire directive pour plus de dtails  propos de la
    syntaxe de l'argument, ainsi que la description de la <a href="#AltSyn">syntaxe alternative</a>.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_expires.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_expires.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_expires.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_expires.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_expires.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>