// Copyright 2010-2015, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "base/japanese_util_rule.h"

namespace mozc {
namespace japanese_util_rule {

const char hiragana_to_katakana_table[] = "\xE3\x83\xB4\x00\x00\xE3\x83\xB4\x00\x00\xE3\x82\xA2\x00\x00\xE3\x82\xA4\x00\x00\xE3\x82\xA6\x00\x00\xE3\x82\xA8\x00\x00\xE3\x82\xAA\x00\x00\xE3\x82\xA1\x00\x00\xE3\x82\xA3\x00\x00\xE3\x82\xA5\x00\x00\xE3\x82\xA7\x00\x00\xE3\x82\xA9\x00\x00\xE3\x82\xAB\x00\x00\xE3\x82\xAD\x00\x00\xE3\x82\xAF\x00\x00\xE3\x82\xB1\x00\x00\xE3\x82\xB3\x00\x00\xE3\x82\xAC\x00\x00\xE3\x82\xAE\x00\x00\xE3\x82\xB0\x00\x00\xE3\x82\xB2\x00\x00\xE3\x82\xB4\x00\x00\xE3\x82\xB5\x00\x00\xE3\x82\xB7\x00\x00\xE3\x82\xB9\x00\x00\xE3\x82\xBB\x00\x00\xE3\x82\xBD\x00\x00\xE3\x82\xB6\x00\x00\xE3\x82\xB8\x00\x00\xE3\x82\xBA\x00\x00\xE3\x82\xBC\x00\x00\xE3\x82\xBE\x00\x00\xE3\x82\xBF\x00\x00\xE3\x83\x81\x00\x00\xE3\x83\x84\x00\x00\xE3\x83\x86\x00\x00\xE3\x83\x88\x00\x00\xE3\x83\x80\x00\x00\xE3\x83\x82\x00\x00\xE3\x83\x85\x00\x00\xE3\x83\x87\x00\x00\xE3\x83\x89\x00\x00\xE3\x83\x83\x00\x00\xE3\x83\x8A\x00\x00\xE3\x83\x8B\x00\x00\xE3\x83\x8C\x00\x00\xE3\x83\x8D\x00\x00\xE3\x83\x8E\x00\x00\xE3\x83\x8F\x00\x00\xE3\x83\x92\x00\x00\xE3\x83\x95\x00\x00\xE3\x83\x98\x00\x00\xE3\x83\x9B\x00\x00\xE3\x83\x90\x00\x00\xE3\x83\x93\x00\x00\xE3\x83\x96\x00\x00\xE3\x83\x99\x00\x00\xE3\x83\x9C\x00\x00\xE3\x83\x91\x00\x00\xE3\x83\x94\x00\x00\xE3\x83\x97\x00\x00\xE3\x83\x9A\x00\x00\xE3\x83\x9D\x00\x00\xE3\x83\x9E\x00\x00\xE3\x83\x9F\x00\x00\xE3\x83\xA0\x00\x00\xE3\x83\xA1\x00\x00\xE3\x83\xA2\x00\x00\xE3\x83\xA3\x00\x00\xE3\x83\xA4\x00\x00\xE3\x83\xA5\x00\x00\xE3\x83\xA6\x00\x00\xE3\x83\xA7\x00\x00\xE3\x83\xA8\x00\x00\xE3\x83\xA9\x00\x00\xE3\x83\xAA\x00\x00\xE3\x83\xAB\x00\x00\xE3\x83\xAC\x00\x00\xE3\x83\xAD\x00\x00\xE3\x83\xAE\x00\x00\xE3\x83\xAF\x00\x00\xE3\x83\xB0\x00\x00\xE3\x83\xB1\x00\x00\xE3\x83\xB2\x00\x00\xE3\x83\xB3\x00\x00";
const mozc::TextConverter::DoubleArray hiragana_to_katakana_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{100,1},{102,100},{232,100},{295,102},{296,102},{297,102},{298,102},{299,102},{300,102},{304,102},{305,102},{306,102},{307,102},{308,102},{309,102},{310,102},{311,102},{312,102},{313,102},{314,102},{315,102},{316,102},{317,102},{318,102},{319,102},{320,102},{321,102},{322,102},{323,102},{324,102},{325,102},{326,102},{327,102},{328,102},{329,102},{330,102},{331,102},{332,102},{333,102},{334,102},{335,102},{336,102},{337,102},{338,102},{339,102},{340,102},{341,102},{342,102},{343,102},{344,102},{345,102},{346,102},{347,102},{348,102},{349,102},{350,102},{351,102},{352,102},{353,102},{354,102},{355,102},{356,102},{357,102},{358,102},{359,102},{360,102},{-36,295},{-11,296},{-41,297},{-16,298},{-46,299},{-21,300},{146,170},{303,146},{-1,303},{-51,304},{-26,305},{-56,306},{-31,307},{-61,308},{-86,309},{-66,310},{-91,311},{-71,312},{-96,313},{-76,314},{-101,315},{-81,316},{-106,317},{-111,318},{-136,319},{-116,320},{-141,321},{-121,322},{-146,323},{-126,324},{-151,325},{-131,326},{-156,327},{-161,328},{-186,329},{-166,330},{-191,331},{-211,332},{-171,333},{-196,334},{-176,335},{-201,336},{-181,337},{-206,338},{-216,339},{-221,340},{-226,341},{-231,342},{-236,343},{-241,344},{-266,345},{-291,346},{-246,347},{-271,348},{-296,349},{-251,350},{-276,351},{-301,352},{-256,353},{-281,354},{-306,355},{-261,356},{-286,357},{-311,358},{-316,359},{-321,360},{382,232},{383,232},{384,232},{385,232},{386,232},{387,232},{388,232},{389,232},{390,232},{391,232},{392,232},{393,232},{394,232},{395,232},{396,232},{397,232},{398,232},{399,232},{400,232},{401,232},{402,232},{-326,382},{-331,383},{-336,384},{-341,385},{-346,386},{-351,387},{-356,388},{-361,389},{-366,390},{-371,391},{-376,392},{-381,393},{-386,394},{-391,395},{-396,396},{-401,397},{-406,398},{-411,399},{-416,400},{-421,401},{-6,402},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{170,300},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char hiragana_to_romanji_table[] = "\x76\x61\x00\x00\x76\x69\x00\x00\x76\x75\x00\x00\x76\x65\x00\x00\x76\x6F\x00\x00\x76\x79\x61\x00\x00\x76\x79\x75\x00\x00\x76\x79\x6F\x00\x00\x76\x00\x03\x76\x61\x00\x00\x76\x69\x00\x00\x76\x75\x00\x00\x76\x65\x00\x00\x76\x6F\x00\x00\x76\x79\x61\x00\x00\x76\x79\x75\x00\x00\x76\x79\x6F\x00\x00\x76\x00\x03\x77\x77\x68\x61\x00\x00\x77\x77\x69\x00\x00\x77\x77\x75\x00\x00\x77\x77\x65\x00\x00\x77\x77\x68\x6F\x00\x00\x78\x78\x61\x00\x00\x78\x78\x69\x00\x00\x78\x78\x75\x00\x00\x78\x78\x65\x00\x00\x78\x78\x6F\x00\x00\x6B\x6B\x61\x00\x00\x6B\x00\x03\x6B\x6B\x75\x00\x00\x6B\x6B\x65\x00\x00\x6B\x6B\x6F\x00\x00\x67\x67\x61\x00\x00\x67\x00\x03\x67\x67\x75\x00\x00\x67\x67\x65\x00\x00\x67\x67\x6F\x00\x00\x73\x73\x61\x00\x00\x73\x00\x03\x73\x73\x75\x00\x00\x73\x73\x65\x00\x00\x73\x73\x6F\x00\x00\x7A\x7A\x61\x00\x00\x7A\x00\x03\x7A\x7A\x75\x00\x00\x7A\x7A\x65\x00\x00\x7A\x7A\x6F\x00\x00\x74\x74\x61\x00\x00\x74\x00\x03\x74\x74\x75\x00\x00\x74\x74\x65\x00\x00\x74\x74\x6F\x00\x00\x64\x64\x61\x00\x00\x64\x00\x03\x64\x64\x75\x00\x00\x64\x64\x65\x00\x00\x64\x64\x6F\x00\x00\x74\x00\x03\x68\x68\x61\x00\x00\x68\x00\x03\x68\x68\x75\x00\x00\x68\x68\x65\x00\x00\x68\x68\x6F\x00\x00\x62\x62\x61\x00\x00\x62\x00\x03\x62\x62\x75\x00\x00\x62\x62\x65\x00\x00\x62\x62\x6F\x00\x00\x70\x70\x61\x00\x00\x70\x00\x03\x70\x70\x75\x00\x00\x70\x70\x65\x00\x00\x70\x70\x6F\x00\x00\x6D\x6D\x61\x00\x00\x6D\x00\x03\x6D\x6D\x75\x00\x00\x6D\x6D\x65\x00\x00\x6D\x6D\x6F\x00\x00\x79\x79\x61\x00\x00\x79\x79\x75\x00\x00\x79\x79\x6F\x00\x00\x78\x78\x79\x61\x00\x00\x78\x78\x79\x75\x00\x00\x78\x78\x79\x6F\x00\x00\x72\x72\x61\x00\x00\x72\x00\x03\x72\x72\x75\x00\x00\x72\x72\x65\x00\x00\x72\x72\x6F\x00\x00\x78\x78\x77\x61\x00\x00\x77\x77\x61\x00\x00\x77\x77\x79\x69\x00\x00\x77\x77\x79\x65\x00\x00\x77\x77\x6F\x00\x00\x79\x65\x00\x00\x77\x68\x61\x00\x00\x6B\x79\x61\x00\x00\x6B\x79\x69\x00\x00\x6B\x79\x75\x00\x00\x6B\x79\x65\x00\x00\x6B\x79\x6F\x00\x00\x67\x79\x61\x00\x00\x67\x79\x69\x00\x00\x67\x79\x75\x00\x00\x67\x79\x65\x00\x00\x67\x79\x6F\x00\x00\x71\x61\x00\x00\x71\x69\x00\x00\x71\x65\x00\x00\x71\x6F\x00\x00\x73\x79\x61\x00\x00\x73\x79\x69\x00\x00\x73\x79\x75\x00\x00\x73\x79\x65\x00\x00\x73\x79\x6F\x00\x00\x7A\x79\x61\x00\x00\x7A\x79\x69\x00\x00\x7A\x79\x75\x00\x00\x7A\x79\x65\x00\x00\x7A\x79\x6F\x00\x00\x74\x79\x61\x00\x00\x74\x79\x69\x00\x00\x74\x79\x75\x00\x00\x74\x79\x65\x00\x00\x74\x79\x6F\x00\x00\x64\x79\x61\x00\x00\x64\x79\x69\x00\x00\x64\x79\x75\x00\x00\x64\x79\x65\x00\x00\x64\x79\x6F\x00\x00\x74\x73\x61\x00\x00\x74\x73\x69\x00\x00\x74\x73\x65\x00\x00\x74\x73\x6F\x00\x00\x74\x68\x61\x00\x00\x74\x68\x69\x00\x00\x74\x68\x75\x00\x00\x74\x68\x65\x00\x00\x74\x68\x6F\x00\x00\x64\x68\x61\x00\x00\x64\x68\x69\x00\x00\x64\x68\x75\x00\x00\x64\x68\x65\x00\x00\x64\x68\x6F\x00\x00\x74\x77\x61\x00\x00\x74\x77\x69\x00\x00\x74\x77\x75\x00\x00\x74\x77\x65\x00\x00\x74\x77\x6F\x00\x00\x64\x77\x61\x00\x00\x64\x77\x69\x00\x00\x64\x77\x75\x00\x00\x64\x77\x65\x00\x00\x64\x77\x6F\x00\x00\x6E\x79\x61\x00\x00\x6E\x79\x69\x00\x00\x6E\x79\x75\x00\x00\x6E\x79\x65\x00\x00\x6E\x79\x6F\x00\x00\x68\x79\x61\x00\x00\x68\x79\x69\x00\x00\x68\x79\x75\x00\x00\x68\x79\x65\x00\x00\x68\x79\x6F\x00\x00\x62\x79\x61\x00\x00\x62\x79\x69\x00\x00\x62\x79\x75\x00\x00\x62\x79\x65\x00\x00\x62\x79\x6F\x00\x00\x70\x79\x61\x00\x00\x70\x79\x69\x00\x00\x70\x79\x75\x00\x00\x70\x79\x65\x00\x00\x70\x79\x6F\x00\x00\x66\x79\x61\x00\x00\x66\x79\x75\x00\x00\x66\x79\x6F\x00\x00\x6D\x79\x61\x00\x00\x6D\x79\x69\x00\x00\x6D\x79\x75\x00\x00\x6D\x79\x65\x00\x00\x6D\x79\x6F\x00\x00\x72\x79\x61\x00\x00\x72\x79\x69\x00\x00\x72\x79\x75\x00\x00\x72\x79\x65\x00\x00\x72\x79\x6F\x00\x00\x6E\x27\x61\x00\x00\x6E\x27\x69\x00\x00\x6E\x27\x75\x00\x00\x6E\x27\x65\x00\x00\x6E\x27\x6F\x00\x00\x61\x00\x00\x69\x00\x00\x75\x00\x00\x65\x00\x00\x6F\x00\x00\x78\x61\x00\x00\x78\x69\x00\x00\x78\x75\x00\x00\x78\x65\x00\x00\x78\x6F\x00\x00\x6B\x61\x00\x00\x6B\x69\x00\x00\x6B\x75\x00\x00\x6B\x65\x00\x00\x6B\x6F\x00\x00\x78\x6B\x61\x00\x00\x78\x6B\x65\x00\x00\x67\x61\x00\x00\x67\x69\x00\x00\x67\x75\x00\x00\x67\x65\x00\x00\x67\x6F\x00\x00\x73\x61\x00\x00\x73\x69\x00\x00\x73\x75\x00\x00\x73\x65\x00\x00\x73\x6F\x00\x00\x7A\x61\x00\x00\x7A\x69\x00\x00\x7A\x75\x00\x00\x7A\x65\x00\x00\x7A\x6F\x00\x00\x74\x61\x00\x00\x74\x69\x00\x00\x74\x75\x00\x00\x74\x65\x00\x00\x74\x6F\x00\x00\x64\x61\x00\x00\x64\x69\x00\x00\x64\x75\x00\x00\x64\x65\x00\x00\x64\x6F\x00\x00\x78\x74\x75\x00\x00\x6E\x61\x00\x00\x6E\x69\x00\x00\x6E\x75\x00\x00\x6E\x65\x00\x00\x6E\x6F\x00\x00\x68\x61\x00\x00\x68\x69\x00\x00\x68\x75\x00\x00\x68\x65\x00\x00\x68\x6F\x00\x00\x62\x61\x00\x00\x62\x69\x00\x00\x62\x75\x00\x00\x62\x65\x00\x00\x62\x6F\x00\x00\x70\x61\x00\x00\x70\x69\x00\x00\x70\x75\x00\x00\x70\x65\x00\x00\x70\x6F\x00\x00\x6D\x61\x00\x00\x6D\x69\x00\x00\x6D\x75\x00\x00\x6D\x65\x00\x00\x6D\x6F\x00\x00\x78\x79\x61\x00\x00\x79\x61\x00\x00\x78\x79\x75\x00\x00\x79\x75\x00\x00\x78\x79\x6F\x00\x00\x79\x6F\x00\x00\x72\x61\x00\x00\x72\x69\x00\x00\x72\x75\x00\x00\x72\x65\x00\x00\x72\x6F\x00\x00\x78\x77\x61\x00\x00\x77\x61\x00\x00\x77\x79\x69\x00\x00\x77\x79\x65\x00\x00\x77\x6F\x00\x00\x6E\x00\x00\x2D\x00\x00\x7E\x00\x00";
const mozc::TextConverter::DoubleArray hiragana_to_romanji_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{108,1},{101,2},{68,101},{5,68},{104,5},{71,104},{236,71},{-267,236},{84,108},{113,108},{657,108},{674,108},{242,84},{-1277,242},{306,113},{307,113},{308,113},{309,113},{313,113},{314,113},{337,113},{338,113},{339,113},{340,113},{341,113},{342,113},{343,113},{357,113},{371,113},{379,113},{381,113},{383,113},{384,113},{385,113},{386,113},{387,113},{388,113},{402,113},{416,113},{417,113},{418,113},{419,113},{420,113},{421,113},{422,113},{423,113},{424,113},{438,113},{449,113},{600,113},{609,113},{611,113},{626,113},{662,113},{671,113},{683,113},{684,113},{690,113},{691,113},{693,113},{694,113},{695,113},{696,113},{697,113},{704,113},{710,113},{718,113},{725,113},{726,113},{727,113},{728,113},{731,113},{732,113},{739,113},{742,113},{743,113},{746,113},{-946,306},{-931,307},{-950,308},{-934,309},{175,180},{312,175},{-446,312},{-954,313},{-937,314},{187,185},{163,185},{318,187},{-450,318},{320,163},{-9,320},{193,191},{198,191},{324,193},{-1,324},{326,193},{-5,326},{-13,327},{-17,328},{327,193},{333,198},{328,193},{335,198},{-21,333},{336,198},{-26,335},{-31,336},{-958,337},{-940,338},{-962,339},{-943,340},{-966,341},{-996,342},{-970,343},{215,214},{218,214},{0,0},{348,215},{-460,348},{-470,349},{353,218},{349,215},{355,218},{-455,353},{356,218},{-465,355},{-475,356},{-1000,357},{229,228},{232,228},{0,0},{362,229},{-485,362},{-495,363},{367,232},{363,229},{369,232},{-480,367},{370,232},{-490,369},{-500,370},{-974,371},{-505,372},{244,243},{372,244},{-509,375},{375,244},{-513,377},{-517,378},{-1004,379},{377,244},{-978,381},{378,244},{-1008,383},{-982,384},{-1012,385},{-1016,386},{-1036,387},{-1020,388},{260,259},{263,259},{0,0},{393,260},{-526,393},{-536,394},{398,263},{394,260},{400,263},{-521,398},{401,263},{-531,400},{-541,401},{-1040,402},{274,273},{277,273},{0,0},{407,274},{-551,407},{-561,408},{412,277},{408,274},{414,277},{-546,412},{415,277},{-556,414},{-566,415},{-1024,416},{-1044,417},{-1028,418},{-1048,419},{-1032,420},{-1052,421},{-1056,422},{-1076,423},{-1060,424},{296,295},{299,295},{0,0},{429,296},{-576,429},{-586,430},{434,299},{430,296},{436,299},{-571,434},{437,299},{-581,436},{-591,437},{-1080,438},{-601,439},{311,310},{316,310},{-611,442},{439,311},{-596,444},{-606,445},{-616,446},{442,311},{444,316},{-1096,449},{445,316},{0,0},{446,316},{325,323},{502,323},{456,325},{-104,456},{458,325},{-109,458},{462,325},{464,325},{523,325},{-114,462},{524,325},{-88,464},{526,325},{528,325},{529,325},{530,325},{531,325},{532,325},{533,325},{534,325},{535,325},{536,325},{538,325},{539,325},{540,325},{541,325},{543,325},{544,325},{545,325},{546,325},{547,325},{549,325},{550,325},{551,325},{552,325},{553,325},{0,0},{554,325},{555,325},{556,325},{557,325},{558,325},{559,325},{389,366},{364,366},{-77,498},{-83,499},{-93,500},{560,325},{561,325},{562,325},{563,325},{564,325},{565,325},{566,325},{567,325},{568,325},{569,325},{570,325},{572,325},{573,325},{574,325},{575,325},{576,325},{577,325},{-98,518},{498,389},{522,364},{499,389},{-36,522},{-119,523},{-124,524},{500,389},{-129,526},{518,389},{-152,528},{-134,529},{-157,530},{-137,531},{-160,532},{-142,533},{-165,534},{-147,535},{-170,536},{180,309},{-175,538},{-198,539},{-180,540},{-203,541},{185,314},{-183,543},{-206,544},{-188,545},{-211,546},{-193,547},{191,320},{-216,549},{-221,550},{-244,551},{-226,552},{-249,553},{-229,554},{-252,555},{-234,556},{-257,557},{-239,558},{-262,559},{-270,560},{-293,561},{-316,562},{-275,563},{-298,564},{-321,565},{-278,566},{-301,567},{-324,568},{-283,569},{-306,570},{214,343},{-329,572},{-288,573},{-311,574},{-334,575},{-339,576},{-344,577},{-347,578},{-352,579},{-357,580},{-377,581},{-362,582},{-383,583},{-367,584},{228,357},{-389,586},{-372,587},{-395,588},{-400,589},{-403,590},{-408,591},{-413,592},{-418,593},{-424,594},{-429,595},{-435,596},{-441,597},{-74,598},{243,371},{-1064,600},{472,471},{603,472},{-621,603},{605,472},{-626,605},{-631,606},{-636,607},{606,472},{-1084,609},{607,472},{-1068,611},{483,482},{488,482},{0,0},{617,483},{259,388},{-646,617},{-656,618},{618,483},{621,488},{-641,621},{623,488},{-651,623},{625,488},{-661,625},{-1088,626},{521,497},{527,497},{0,0},{273,402},{578,502},{579,502},{580,502},{581,502},{582,502},{583,502},{584,502},{586,502},{587,502},{588,502},{589,502},{590,502},{591,502},{592,502},{593,502},{594,502},{595,502},{596,502},{597,502},{0,0},{598,502},{295,424},{654,521},{-671,654},{-681,655},{-666,656},{655,521},{-676,658},{656,527},{-686,660},{658,527},{-1072,662},{660,527},{-691,664},{-696,665},{310,438},{542,537},{-701,668},{-706,669},{-711,670},{-1092,671},{664,542},{-716,673},{665,542},{-721,675},{668,542},{323,449},{669,542},{-726,679},{670,542},{-731,681},{-736,682},{-1101,683},{-1105,684},{-746,685},{-756,686},{-741,687},{-751,688},{-761,689},{-1109,690},{-1113,691},{366,464},{-1117,693},{-1121,694},{-1141,695},{-1161,696},{-1125,697},{-771,698},{-781,699},{-766,700},{585,571},{-776,702},{-786,703},{-1145,704},{-796,705},{-806,706},{-791,707},{-801,708},{-811,709},{-1165,710},{-821,711},{-831,712},{-816,713},{-826,714},{673,585},{-836,716},{675,585},{-1129,718},{679,585},{-841,720},{681,585},{-846,722},{682,585},{-851,724},{-1149,725},{-1169,726},{-1133,727},{-1153,728},{601,599},{602,599},{-1173,731},{-1137,732},{685,601},{687,602},{636,604},{688,602},{686,601},{689,602},{-1157,739},{612,610},{613,610},{-1177,742},{-1181,743},{698,612},{700,613},{-1185,746},{702,613},{699,612},{703,613},{622,620},{627,620},{0,0},{0,0},{705,622},{0,0},{711,624},{0,0},{706,622},{707,627},{712,624},{708,627},{0,0},{709,627},{624,634},{635,634},{0,0},{713,635},{720,636},{714,635},{722,636},{716,635},{724,636},{644,643},{647,643},{0,0},{777,644},{-861,777},{-871,778},{782,647},{778,644},{784,647},{-856,782},{785,647},{-866,784},{-876,785},{807,657},{808,657},{809,657},{810,657},{811,657},{812,657},{813,657},{814,657},{815,657},{816,657},{817,657},{825,657},{826,657},{827,657},{829,657},{830,657},{831,657},{832,657},{834,657},{835,657},{843,657},{-1189,807},{-1193,808},{-1197,809},{-1201,810},{-1206,811},{-1210,812},{-1215,813},{-1219,814},{-1224,815},{-1228,816},{-1232,817},{-886,818},{-896,819},{-881,820},{-891,821},{701,692},{715,692},{-901,824},{-1236,825},{-1240,826},{-1244,827},{471,600},{-1248,829},{-1253,830},{-1257,831},{-1262,832},{818,701},{-1267,834},{-1271,835},{-906,836},{819,701},{-911,838},{482,611},{-916,840},{-921,841},{-926,842},{-47,843},{-39,844},{-43,845},{-51,846},{820,715},{-55,848},{821,715},{-59,850},{824,715},{-64,852},{729,723},{497,626},{-69,855},{858,674},{859,674},{-986,858},{-991,859},{836,729},{-1274,861},{838,729},{861,674},{840,729},{0,0},{841,729},{844,737},{842,729},{845,737},{737,740},{744,740},{0,0},{846,737},{0,0},{848,737},{850,744},{0,0},{852,744},{0,0},{855,744},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{537,662},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{571,671},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{599,684},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{610,697},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{620,704},{0,0},{0,0},{0,0},{0,0},{0,0},{634,710},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{604,718},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{643,746},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{692,817},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{723,835},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{740,843},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char katakana_to_hiragana_table[] = "\xE3\x82\x94\x00\x00\xE3\x81\x82\x00\x00\xE3\x81\x84\x00\x00\xE3\x81\x86\x00\x00\xE3\x81\x88\x00\x00\xE3\x81\x8A\x00\x00\xE3\x81\x81\x00\x00\xE3\x81\x83\x00\x00\xE3\x81\x85\x00\x00\xE3\x81\x87\x00\x00\xE3\x81\x89\x00\x00\xE3\x81\x8B\x00\x00\xE3\x81\x8D\x00\x00\xE3\x81\x8F\x00\x00\xE3\x81\x91\x00\x00\xE3\x81\x93\x00\x00\xE3\x81\x8C\x00\x00\xE3\x81\x8E\x00\x00\xE3\x81\x90\x00\x00\xE3\x81\x92\x00\x00\xE3\x81\x94\x00\x00\xE3\x81\x95\x00\x00\xE3\x81\x97\x00\x00\xE3\x81\x99\x00\x00\xE3\x81\x9B\x00\x00\xE3\x81\x9D\x00\x00\xE3\x81\x96\x00\x00\xE3\x81\x98\x00\x00\xE3\x81\x9A\x00\x00\xE3\x81\x9C\x00\x00\xE3\x81\x9E\x00\x00\xE3\x81\x9F\x00\x00\xE3\x81\xA1\x00\x00\xE3\x81\xA4\x00\x00\xE3\x81\xA6\x00\x00\xE3\x81\xA8\x00\x00\xE3\x81\xA0\x00\x00\xE3\x81\xA2\x00\x00\xE3\x81\xA5\x00\x00\xE3\x81\xA7\x00\x00\xE3\x81\xA9\x00\x00\xE3\x81\xA3\x00\x00\xE3\x81\xAA\x00\x00\xE3\x81\xAB\x00\x00\xE3\x81\xAC\x00\x00\xE3\x81\xAD\x00\x00\xE3\x81\xAE\x00\x00\xE3\x81\xAF\x00\x00\xE3\x81\xB2\x00\x00\xE3\x81\xB5\x00\x00\xE3\x81\xB8\x00\x00\xE3\x81\xBB\x00\x00\xE3\x81\xB0\x00\x00\xE3\x81\xB3\x00\x00\xE3\x81\xB6\x00\x00\xE3\x81\xB9\x00\x00\xE3\x81\xBC\x00\x00\xE3\x81\xB1\x00\x00\xE3\x81\xB4\x00\x00\xE3\x81\xB7\x00\x00\xE3\x81\xBA\x00\x00\xE3\x81\xBD\x00\x00\xE3\x81\xBE\x00\x00\xE3\x81\xBF\x00\x00\xE3\x82\x80\x00\x00\xE3\x82\x81\x00\x00\xE3\x82\x82\x00\x00\xE3\x82\x83\x00\x00\xE3\x82\x84\x00\x00\xE3\x82\x85\x00\x00\xE3\x82\x86\x00\x00\xE3\x82\x87\x00\x00\xE3\x82\x88\x00\x00\xE3\x82\x89\x00\x00\xE3\x82\x8A\x00\x00\xE3\x82\x8B\x00\x00\xE3\x82\x8C\x00\x00\xE3\x82\x8D\x00\x00\xE3\x82\x8E\x00\x00\xE3\x82\x8F\x00\x00\xE3\x82\x90\x00\x00\xE3\x82\x91\x00\x00\xE3\x82\x92\x00\x00\xE3\x82\x93\x00\x00";
const mozc::TextConverter::DoubleArray katakana_to_hiragana_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{99,1},{70,99},{165,99},{263,70},{264,70},{265,70},{266,70},{267,70},{268,70},{269,70},{270,70},{271,70},{272,70},{273,70},{274,70},{275,70},{276,70},{277,70},{278,70},{279,70},{280,70},{281,70},{282,70},{283,70},{284,70},{285,70},{286,70},{287,70},{288,70},{289,70},{290,70},{291,70},{292,70},{293,70},{-31,263},{-6,264},{-36,265},{-11,266},{-41,267},{-16,268},{-46,269},{-21,270},{-51,271},{-26,272},{-56,273},{-81,274},{-61,275},{-86,276},{-66,277},{-91,278},{-71,279},{-96,280},{-76,281},{-101,282},{-106,283},{-131,284},{-111,285},{-136,286},{-116,287},{-141,288},{-121,289},{-146,290},{-126,291},{-151,292},{-156,293},{347,165},{348,165},{349,165},{350,165},{351,165},{352,165},{353,165},{354,165},{355,165},{356,165},{357,165},{358,165},{359,165},{360,165},{361,165},{362,165},{363,165},{364,165},{365,165},{366,165},{367,165},{368,165},{369,165},{370,165},{371,165},{372,165},{373,165},{374,165},{375,165},{376,165},{377,165},{378,165},{379,165},{380,165},{381,165},{382,165},{383,165},{384,165},{385,165},{386,165},{387,165},{388,165},{389,165},{390,165},{391,165},{392,165},{393,165},{394,165},{395,165},{396,165},{397,165},{398,165},{399,165},{-181,347},{-161,348},{-186,349},{-206,350},{-166,351},{-191,352},{-171,353},{-196,354},{-176,355},{-201,356},{-211,357},{-216,358},{-221,359},{-226,360},{-231,361},{-236,362},{-261,363},{-286,364},{-241,365},{-266,366},{-291,367},{-246,368},{-271,369},{-296,370},{-251,371},{-276,372},{-301,373},{-256,374},{-281,375},{-306,376},{-311,377},{-316,378},{-321,379},{-326,380},{-331,381},{-336,382},{-341,383},{-346,384},{-351,385},{-356,386},{-361,387},{-366,388},{-371,389},{-376,390},{-381,391},{-386,392},{-391,393},{-396,394},{-401,395},{-406,396},{-411,397},{-416,398},{-1,399},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char romanji_to_hiragana_table[] = "\xE3\x83\xBC\x00\x00\xE3\x80\x9C\x00\x00\xE3\x80\x82\x00\x00\xE3\x80\x81\x00\x00\xE3\x83\xBB\x00\x00\xE2\x80\xA6\x00\x00\xE2\x80\xA5\x00\x00\xE2\x86\x90\x00\x00\xE2\x86\x93\x00\x00\xE2\x86\x91\x00\x00\xE2\x86\x92\x00\x00\xE3\x80\x9C\x00\x00\xE3\x80\x8E\x00\x00\xE3\x80\x8F\x00\x00\xE3\x80\x8C\x00\x00\xE3\x80\x8D\x00\x00\xE3\x82\x94\xE3\x81\x81\x00\x00\xE3\x82\x94\xE3\x81\x83\x00\x00\xE3\x82\x94\x00\x00\xE3\x82\x94\xE3\x81\x87\x00\x00\xE3\x82\x94\xE3\x81\x89\x00\x00\xE3\x82\x94\xE3\x82\x83\x00\x00\xE3\x82\x94\xE3\x81\x83\x00\x00\xE3\x82\x94\xE3\x82\x85\x00\x00\xE3\x82\x94\xE3\x81\x87\x00\x00\xE3\x82\x94\xE3\x82\x87\x00\x00\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\xE3\x81\xA3\x00\x01\x77\x00\x02\xE3\x81\xA3\x00\x01\xE3\x81\x8D\xE3\x82\x83\x00\x00\xE3\x81\x8D\xE3\x81\x83\x00\x00\xE3\x81\x8D\xE3\x82\x85\x00\x00\xE3\x81\x8D\xE3\x81\x87\x00\x00\xE3\x81\x8D\xE3\x82\x87\x00\x00\xE3\x81\x8E\xE3\x82\x83\x00\x00\xE3\x81\x8E\xE3\x81\x83\x00\x00\xE3\x81\x8E\xE3\x82\x85\x00\x00\xE3\x81\x8E\xE3\x81\x87\x00\x00\xE3\x81\x8E\xE3\x82\x87\x00\x00\xE3\x81\x97\xE3\x82\x83\x00\x00\xE3\x81\x97\xE3\x81\x83\x00\x00\xE3\x81\x97\xE3\x82\x85\x00\x00\xE3\x81\x97\xE3\x81\x87\x00\x00\xE3\x81\x97\xE3\x82\x87\x00\x00\xE3\x81\x97\xE3\x82\x83\x00\x00\xE3\x81\x97\x00\x00\xE3\x81\x97\xE3\x82\x85\x00\x00\xE3\x81\x97\xE3\x81\x87\x00\x00\xE3\x81\x97\xE3\x82\x87\x00\x00\xE3\x81\x98\xE3\x82\x83\x00\x00\xE3\x81\x98\xE3\x81\x83\x00\x00\xE3\x81\x98\xE3\x82\x85\x00\x00\xE3\x81\x98\xE3\x81\x87\x00\x00\xE3\x81\x98\xE3\x82\x87\x00\x00\xE3\x81\xA1\xE3\x82\x83\x00\x00\xE3\x81\xA1\xE3\x81\x83\x00\x00\xE3\x81\xA1\xE3\x82\x85\x00\x00\xE3\x81\xA1\xE3\x81\x87\x00\x00\xE3\x81\xA1\xE3\x82\x87\x00\x00\xE3\x81\xA1\xE3\x82\x83\x00\x00\xE3\x81\xA1\x00\x00\xE3\x81\xA1\xE3\x82\x85\x00\x00\xE3\x81\xA1\xE3\x81\x87\x00\x00\xE3\x81\xA1\xE3\x82\x87\x00\x00\xE3\x81\xA1\xE3\x82\x83\x00\x00\xE3\x81\xA1\xE3\x81\x83\x00\x00\xE3\x81\xA1\xE3\x82\x85\x00\x00\xE3\x81\xA1\xE3\x81\x87\x00\x00\xE3\x81\xA1\xE3\x82\x87\x00\x00\xE3\x81\xA2\xE3\x82\x83\x00\x00\xE3\x81\xA2\xE3\x81\x83\x00\x00\xE3\x81\xA2\xE3\x82\x85\x00\x00\xE3\x81\xA2\xE3\x81\x87\x00\x00\xE3\x81\xA2\xE3\x82\x87\x00\x00\xE3\x81\xA4\xE3\x81\x81\x00\x00\xE3\x81\xA4\xE3\x81\x83\x00\x00\xE3\x81\xA4\xE3\x81\x87\x00\x00\xE3\x81\xA4\xE3\x81\x89\x00\x00\xE3\x81\xA6\xE3\x82\x83\x00\x00\xE3\x81\xA6\xE3\x81\x83\x00\x00\xE3\x81\xA6\xE3\x81\x83\x00\x00\xE3\x81\xA6\xE3\x82\x85\x00\x00\xE3\x81\xA6\xE3\x81\x87\x00\x00\xE3\x81\xA6\xE3\x82\x87\x00\x00\xE3\x81\xA6\xE3\x82\x85\x00\x00\xE3\x81\xA7\xE3\x82\x83\x00\x00\xE3\x81\xA7\xE3\x81\x83\x00\x00\xE3\x81\xA7\xE3\x81\x83\x00\x00\xE3\x81\xA7\xE3\x82\x85\x00\x00\xE3\x81\xA7\xE3\x81\x87\x00\x00\xE3\x81\xA7\xE3\x82\x87\x00\x00\xE3\x81\xA7\xE3\x82\x85\x00\x00\xE3\x81\xA8\xE3\x81\x81\x00\x00\xE3\x81\xA8\xE3\x81\x83\x00\x00\xE3\x81\xA8\xE3\x81\x85\x00\x00\xE3\x81\xA8\xE3\x81\x87\x00\x00\xE3\x81\xA8\xE3\x81\x89\x00\x00\xE3\x81\xA8\xE3\x81\x85\x00\x00\xE3\x81\xA9\xE3\x81\x81\x00\x00\xE3\x81\xA9\xE3\x81\x83\x00\x00\xE3\x81\xA9\xE3\x81\x85\x00\x00\xE3\x81\xA9\xE3\x81\x87\x00\x00\xE3\x81\xA9\xE3\x81\x89\x00\x00\xE3\x81\xA9\xE3\x81\x85\x00\x00\xE3\x81\xAB\xE3\x82\x83\x00\x00\xE3\x81\xAB\xE3\x81\x83\x00\x00\xE3\x81\xAB\xE3\x82\x85\x00\x00\xE3\x81\xAB\xE3\x81\x87\x00\x00\xE3\x81\xAB\xE3\x82\x87\x00\x00\xE3\x81\xB2\xE3\x82\x83\x00\x00\xE3\x81\xB2\xE3\x81\x83\x00\x00\xE3\x81\xB2\xE3\x82\x85\x00\x00\xE3\x81\xB2\xE3\x81\x87\x00\x00\xE3\x81\xB2\xE3\x82\x87\x00\x00\xE3\x81\xB3\xE3\x82\x83\x00\x00\xE3\x81\xB3\xE3\x81\x83\x00\x00\xE3\x81\xB3\xE3\x82\x85\x00\x00\xE3\x81\xB3\xE3\x81\x87\x00\x00\xE3\x81\xB3\xE3\x82\x87\x00\x00\xE3\x81\xB4\xE3\x82\x83\x00\x00\xE3\x81\xB4\xE3\x81\x83\x00\x00\xE3\x81\xB4\xE3\x82\x85\x00\x00\xE3\x81\xB4\xE3\x81\x87\x00\x00\xE3\x81\xB4\xE3\x82\x87\x00\x00\xE3\x81\xB5\xE3\x81\x81\x00\x00\xE3\x81\xB5\xE3\x81\x83\x00\x00\xE3\x81\xB5\x00\x00\xE3\x81\xB5\xE3\x81\x87\x00\x00\xE3\x81\xB5\xE3\x81\x89\x00\x00\xE3\x81\xB5\xE3\x82\x83\x00\x00\xE3\x81\xB5\xE3\x82\x85\x00\x00\xE3\x81\xB5\xE3\x82\x87\x00\x00\xE3\x81\xB5\xE3\x81\x81\x00\x00\xE3\x81\xB5\xE3\x81\x83\x00\x00\xE3\x81\xB5\xE3\x81\x87\x00\x00\xE3\x81\xB5\xE3\x81\x89\x00\x00\xE3\x81\xB5\xE3\x82\x85\x00\x00\xE3\x81\xBF\xE3\x82\x83\x00\x00\xE3\x81\xBF\xE3\x81\x83\x00\x00\xE3\x81\xBF\xE3\x82\x85\x00\x00\xE3\x81\xBF\xE3\x81\x87\x00\x00\xE3\x81\xBF\xE3\x82\x87\x00\x00\xE3\x82\x8A\xE3\x82\x83\x00\x00\xE3\x82\x8A\xE3\x81\x83\x00\x00\xE3\x82\x8A\xE3\x82\x85\x00\x00\xE3\x82\x8A\xE3\x81\x87\x00\x00\xE3\x82\x8A\xE3\x82\x87\x00\x00\xE3\x82\x93\x00\x00\xE3\x82\x93\x00\x00\xE3\x82\x93\x00\x00\xE3\x82\x93\x00\x00\xE3\x81\x82\x00\x00\xE3\x81\x84\x00\x00\xE3\x81\x86\x00\x00\xE3\x81\x86\x00\x00\xE3\x81\x88\x00\x00\xE3\x81\x8A\x00\x00\xE3\x81\x81\x00\x00\xE3\x81\x83\x00\x00\xE3\x81\x85\x00\x00\xE3\x81\x87\x00\x00\xE3\x81\x89\x00\x00\xE3\x81\x81\x00\x00\xE3\x81\x83\x00\x00\xE3\x81\x85\x00\x00\xE3\x81\x87\x00\x00\xE3\x81\x89\x00\x00\xE3\x81\x83\x00\x00\xE3\x81\x83\x00\x00\xE3\x81\x87\x00\x00\xE3\x81\x87\x00\x00\xE3\x81\x84\xE3\x81\x87\x00\x00\xE3\x81\x8B\x00\x00\xE3\x81\x8D\x00\x00\xE3\x81\x8F\x00\x00\xE3\x81\x91\x00\x00\xE3\x81\x93\x00\x00\xE3\x83\xB5\x00\x00\xE3\x83\xB6\x00\x00\xE3\x83\xB5\x00\x00\xE3\x83\xB6\x00\x00\xE3\x81\x8C\x00\x00\xE3\x81\x8E\x00\x00\xE3\x81\x90\x00\x00\xE3\x81\x92\x00\x00\xE3\x81\x94\x00\x00\xE3\x81\x95\x00\x00\xE3\x81\x97\x00\x00\xE3\x81\x99\x00\x00\xE3\x81\x9B\x00\x00\xE3\x81\x9D\x00\x00\xE3\x81\x8B\x00\x00\xE3\x81\x97\x00\x00\xE3\x81\x8F\x00\x00\xE3\x81\x9B\x00\x00\xE3\x81\x93\x00\x00\xE3\x81\x8F\xE3\x81\x81\x00\x00\xE3\x81\x8F\xE3\x81\x83\x00\x00\xE3\x81\x8F\x00\x00\xE3\x81\x8F\xE3\x81\x87\x00\x00\xE3\x81\x8F\xE3\x81\x89\x00\x00\xE3\x81\x8F\xE3\x81\x81\x00\x00\xE3\x81\x8F\xE3\x81\x83\x00\x00\xE3\x81\x8F\xE3\x81\x85\x00\x00\xE3\x81\x8F\xE3\x81\x87\x00\x00\xE3\x81\x8F\xE3\x81\x89\x00\x00\xE3\x81\x90\xE3\x81\x81\x00\x00\xE3\x81\x90\xE3\x81\x83\x00\x00\xE3\x81\x90\xE3\x81\x85\x00\x00\xE3\x81\x90\xE3\x81\x87\x00\x00\xE3\x81\x90\xE3\x81\x89\x00\x00\xE3\x81\x96\x00\x00\xE3\x81\x98\x00\x00\xE3\x81\x9A\x00\x00\xE3\x81\x9C\x00\x00\xE3\x81\x9E\x00\x00\xE3\x81\x98\xE3\x82\x83\x00\x00\xE3\x81\x98\x00\x00\xE3\x81\x98\xE3\x82\x85\x00\x00\xE3\x81\x98\xE3\x81\x87\x00\x00\xE3\x81\x98\xE3\x82\x87\x00\x00\xE3\x81\x98\xE3\x82\x83\x00\x00\xE3\x81\x98\xE3\x81\x83\x00\x00\xE3\x81\x98\xE3\x82\x85\x00\x00\xE3\x81\x98\xE3\x81\x87\x00\x00\xE3\x81\x98\xE3\x82\x87\x00\x00\xE3\x81\x9F\x00\x00\xE3\x81\xA1\x00\x00\xE3\x81\xA4\x00\x00\xE3\x81\xA4\x00\x00\xE3\x81\xA6\x00\x00\xE3\x81\xA8\x00\x00\xE3\x81\xA0\x00\x00\xE3\x81\xA2\x00\x00\xE3\x81\xA5\x00\x00\xE3\x81\xA7\x00\x00\xE3\x81\xA9\x00\x00\xE3\x81\xA3\x00\x00\xE3\x81\xA3\x00\x00\xE3\x81\xA3\x00\x00\xE3\x81\xA3\x00\x00\xE3\x81\xAA\x00\x00\xE3\x81\xAB\x00\x00\xE3\x81\xAC\x00\x00\xE3\x81\xAD\x00\x00\xE3\x81\xAE\x00\x00\xE3\x81\xAF\x00\x00\xE3\x81\xB2\x00\x00\xE3\x81\xB5\x00\x00\xE3\x81\xB5\x00\x00\xE3\x81\xB8\x00\x00\xE3\x81\xBB\x00\x00\xE3\x81\xB0\x00\x00\xE3\x81\xB3\x00\x00\xE3\x81\xB6\x00\x00\xE3\x81\xB9\x00\x00\xE3\x81\xBC\x00\x00\xE3\x81\xB1\x00\x00\xE3\x81\xB4\x00\x00\xE3\x81\xB7\x00\x00\xE3\x81\xBA\x00\x00\xE3\x81\xBD\x00\x00\xE3\x81\xBE\x00\x00\xE3\x81\xBF\x00\x00\xE3\x82\x80\x00\x00\xE3\x82\x81\x00\x00\xE3\x82\x82\x00\x00\xE3\x82\x83\x00\x00\xE3\x82\x83\x00\x00\xE3\x82\x84\x00\x00\xE3\x82\x90\x00\x00\xE3\x82\x85\x00\x00\xE3\x82\x85\x00\x00\xE3\x82\x86\x00\x00\xE3\x82\x91\x00\x00\xE3\x82\x87\x00\x00\xE3\x82\x87\x00\x00\xE3\x82\x88\x00\x00\xE3\x82\x89\x00\x00\xE3\x82\x8A\x00\x00\xE3\x82\x8B\x00\x00\xE3\x82\x8C\x00\x00\xE3\x82\x8D\x00\x00\xE3\x82\x8E\x00\x00\xE3\x82\x8E\x00\x00\xE3\x82\x8F\x00\x00\xE3\x81\x86\xE3\x81\x83\x00\x00\xE3\x81\x86\xE3\x81\x87\x00\x00\xE3\x82\x92\x00\x00\xE3\x81\x86\xE3\x81\x81\x00\x00\xE3\x81\x86\xE3\x81\x83\x00\x00\xE3\x81\x86\x00\x00\xE3\x81\x86\xE3\x81\x87\x00\x00\xE3\x81\x86\xE3\x81\x89\x00\x00";
const mozc::TextConverter::DoubleArray romanji_to_hiragana_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{49,1},{50,1},{51,1},{-16,49},{-1,50},{-11,51},{-71,52},{-76,53},{-1216,54},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{52,1},{0,0},{53,1},{0,0},{0,0},{0,0},{54,1},{27,1},{55,1},{144,1},{225,1},{145,1},{167,1},{207,1},{328,1},{245,1},{266,1},{298,1},{341,1},{450,1},{471,1},{379,1},{397,1},{414,1},{453,1},{514,1},{627,1},{551,1},{570,1},{596,1},{632,1},{711,1},{127,27},{130,27},{-1793,127},{770,1},{131,27},{-223,130},{-1808,131},{-1798,132},{132,27},{-1813,134},{-1803,135},{137,38},{-935,137},{-959,138},{134,27},{138,38},{-943,141},{-967,142},{-951,143},{141,38},{135,27},{-1419,146},{-256,147},{-1434,148},{38,27},{142,38},{0,0},{0,0},{146,55},{159,56},{147,55},{143,38},{148,55},{163,56},{-498,159},{56,55},{169,55},{164,56},{-519,163},{-506,164},{-527,165},{-511,166},{170,55},{165,56},{-1424,169},{-1439,170},{-1429,171},{175,74},{171,55},{166,56},{-535,175},{178,74},{74,55},{-559,178},{-543,179},{179,74},{-567,181},{-551,182},{185,77},{77,144},{-719,185},{181,74},{-847,187},{189,70},{-751,189},{-1693,190},{-208,191},{182,74},{-1708,193},{196,96},{187,77},{-703,196},{-735,197},{197,96},{70,77},{-711,200},{-743,201},{200,96},{-727,203},{-1698,204},{-1713,205},{-1703,206},{209,109},{201,96},{-807,209},{-831,210},{210,109},{-815,212},{-839,213},{203,96},{212,109},{-823,216},{-575,217},{217,120},{-599,219},{-583,220},{213,109},{219,120},{-607,223},{-591,224},{-1236,225},{220,120},{216,109},{-1015,228},{-1036,229},{-218,230},{-1023,231},{223,120},{-1044,233},{-1031,234},{-1052,235},{-1068,236},{-1060,237},{224,120},{-1369,239},{-1384,240},{-183,241},{190,144},{228,145},{-1374,244},{191,144},{193,144},{229,145},{230,145},{96,144},{204,144},{231,145},{-1389,252},{-1379,253},{235,156},{-1521,255},{205,144},{233,145},{-1545,258},{-1529,259},{-1553,260},{-1537,261},{206,144},{234,145},{109,144},{239,167},{120,144},{156,145},{236,156},{240,167},{0,0},{241,167},{255,174},{244,167},{237,156},{0,0},{258,174},{0,0},{0,0},{252,167},{259,174},{0,0},{0,0},{0,0},{0,0},{253,167},{260,174},{174,167},{0,0},{192,167},{291,192},{-301,291},{261,174},{-325,293},{293,192},{-309,295},{-333,296},{-317,297},{295,192},{-1763,299},{-1783,300},{-213,301},{-1768,302},{-1788,303},{296,192},{299,207},{-1773,306},{-1076,307},{-1092,308},{300,207},{297,192},{-1084,311},{301,207},{302,207},{-1100,314},{-1108,315},{307,218},{315,199},{-895,318},{303,207},{308,218},{-919,321},{-903,322},{-927,323},{311,218},{306,207},{-911,326},{218,207},{-1221,328},{243,207},{314,218},{-1586,331},{-1607,332},{-1594,333},{-198,334},{-1615,335},{-1599,336},{-1623,337},{-1647,338},{-1631,339},{199,218},{318,243},{-1655,342},{331,245},{-1639,344},{321,243},{337,248},{332,245},{-1324,348},{322,243},{338,248},{333,245},{334,245},{-1339,353},{339,248},{323,243},{-1329,356},{335,245},{-178,358},{-1344,359},{342,248},{326,243},{-1334,362},{336,245},{348,266},{370,267},{344,248},{248,245},{353,266},{371,267},{-1481,370},{-1505,371},{356,266},{375,267},{358,266},{-1489,375},{-1513,376},{-1497,377},{359,266},{376,267},{-261,380},{-285,381},{-269,382},{380,285},{362,266},{377,267},{267,266},{381,285},{285,266},{-293,389},{-277,390},{382,285},{-1271,392},{-1286,393},{-1276,394},{-1359,395},{392,298},{389,285},{-1364,398},{-168,399},{393,298},{-1291,401},{405,284},{390,285},{394,298},{-1733,405},{310,298},{399,298},{395,310},{-1728,409},{401,298},{-1281,411},{398,310},{0,0},{417,316},{305,298},{411,298},{-1953,417},{316,298},{0,0},{324,298},{284,305},{424,324},{409,305},{-1873,424},{-1306,425},{425,324},{-1296,427},{-1913,428},{-1893,429},{427,324},{-1843,431},{-1858,432},{-1848,433},{-233,434},{-1863,435},{428,324},{-1853,437},{-1116,438},{431,341},{-1140,440},{438,343},{429,324},{432,341},{-1124,444},{440,343},{-1148,446},{433,341},{-1132,448},{444,343},{-1206,450},{434,341},{-1196,452},{435,341},{-1738,454},{446,343},{-1753,456},{-1743,457},{-1201,458},{437,341},{-1758,460},{448,343},{-1748,462},{343,341},{465,366},{-855,465},{-879,466},{-863,467},{466,366},{-887,469},{-871,470},{-1241,471},{467,366},{-1818,473},{-1833,474},{-1823,475},{-1838,476},{473,379},{469,366},{-228,479},{-1828,480},{474,379},{-975,482},{-999,483},{470,366},{475,379},{-983,486},{-1007,487},{-991,488},{-1444,489},{452,450},{476,379},{479,379},{-1465,493},{482,396},{489,397},{-1452,496},{480,379},{483,396},{493,397},{-1473,500},{396,379},{486,396},{496,397},{-158,504},{-1460,505},{-1923,506},{-1938,507},{487,396},{500,397},{-1928,510},{504,397},{506,414},{-1943,513},{488,396},{505,397},{507,414},{-243,517},{-1933,518},{521,421},{510,414},{-1156,521},{-1180,522},{522,421},{-1164,524},{-1188,525},{513,414},{524,421},{-1172,528},{517,414},{-1394,530},{-1409,531},{518,414},{525,421},{-381,534},{-402,535},{421,414},{-389,537},{-410,538},{528,421},{-394,540},{-1399,541},{-1414,542},{-188,543},{-1404,544},{-341,545},{-365,546},{-349,547},{454,450},{-373,549},{-357,550},{530,453},{456,450},{0,0},{472,514},{531,453},{457,450},{-663,557},{468,453},{541,453},{-799,560},{458,450},{460,450},{564,445},{-695,564},{542,453},{534,468},{-1663,567},{462,450},{543,453},{535,468},{544,453},{366,450},{-1683,573},{537,468},{481,453},{-647,576},{-679,577},{557,472},{545,481},{538,468},{-655,581},{-687,582},{546,481},{-671,584},{-1668,585},{540,468},{547,481},{576,490},{-1688,589},{560,472},{-615,591},{577,490},{549,481},{445,472},{-631,595},{581,490},{591,499},{-623,598},{550,481},{-639,600},{595,499},{582,490},{-1678,603},{-203,604},{598,499},{-1673,606},{-759,607},{584,490},{-783,609},{-767,610},{600,499},{567,514},{-791,613},{-775,614},{-458,615},{573,514},{603,499},{-482,618},{490,514},{585,514},{607,523},{-466,622},{-490,623},{-474,624},{609,523},{589,514},{-1226,627},{-81,628},{610,523},{499,514},{604,514},{606,514},{-102,633},{523,514},{613,523},{548,514},{-89,637},{-110,638},{-97,639},{-163,640},{614,523},{-118,642},{-142,643},{-126,644},{-150,645},{615,548},{-134,647},{-1958,648},{628,551},{618,548},{642,553},{-1971,652},{633,551},{622,548},{643,553},{-1984,656},{637,551},{-2005,658},{644,553},{623,548},{-1992,661},{-2013,662},{638,551},{-2000,664},{645,553},{624,548},{-1963,667},{648,570},{639,551},{640,551},{647,553},{652,570},{553,551},{-1979,674},{579,570},{667,570},{656,579},{-1231,678},{-248,679},{-253,680},{658,579},{674,570},{-1903,683},{-1883,684},{661,579},{-1246,686},{-1261,687},{678,570},{683,587},{679,570},{662,579},{587,570},{684,587},{686,596},{-1251,695},{-1349,696},{664,579},{687,596},{696,601},{-1354,700},{-1211,701},{695,596},{700,601},{601,596},{-1266,705},{710,588},{701,596},{705,596},{588,593},{-1723,710},{712,593},{-1718,712},{593,596},{715,596},{-1256,715},{621,596},{721,596},{625,596},{720,621},{-1948,720},{-173,721},{-1868,722},{722,625},{-1311,724},{-1301,725},{-1908,726},{724,625},{-1888,728},{-1878,729},{729,632},{725,625},{-1316,732},{-1918,733},{732,632},{-1898,735},{-238,736},{726,625},{-31,738},{-56,739},{-26,740},{-21,741},{-61,742},{728,625},{733,632},{-66,745},{-1561,746},{-1576,747},{-36,748},{-1566,749},{735,632},{-41,751},{-46,752},{-51,753},{736,632},{-1581,755},{738,711},{739,711},{740,711},{741,711},{-1571,760},{762,663},{-418,762},{-442,763},{-426,764},{763,663},{-450,766},{-434,767},{-193,768},{764,663},{-6,770},{0,0},{0,0},{0,0},{0,0},{766,663},{0,0},{0,0},{0,0},{0,0},{0,0},{767,663},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{680,679},{0,0},{0,0},{0,0},{742,711},{0,0},{745,711},{0,0},{0,0},{0,0},{746,711},{0,0},{0,0},{0,0},{747,711},{0,0},{0,0},{748,711},{749,711},{751,711},{752,711},{753,711},{0,0},{0,0},{755,711},{0,0},{0,0},{0,0},{0,0},{0,0},{760,711},{0,0},{0,0},{0,0},{663,711},{768,711},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char fullwidthkatakana_to_halfwidthkatakana_table[] = "\xEF\xBD\xA1\x00\x00\xEF\xBD\xA2\x00\x00\xEF\xBD\xA3\x00\x00\xEF\xBD\xA4\x00\x00\xEF\xBD\xA5\x00\x00\xEF\xBD\xA6\x00\x00\xEF\xBD\xA6\xEF\xBE\x9E\x00\x00\xEF\xBD\xA7\x00\x00\xEF\xBD\xA8\x00\x00\xEF\xBD\xA9\x00\x00\xEF\xBD\xAA\x00\x00\xEF\xBD\xAB\x00\x00\xEF\xBD\xAC\x00\x00\xEF\xBD\xAD\x00\x00\xEF\xBD\xAE\x00\x00\xEF\xBD\xAF\x00\x00\xEF\xBD\xB0\x00\x00\xEF\xBD\xB1\x00\x00\xEF\xBD\xB2\x00\x00\xEF\xBD\xB3\x00\x00\xEF\xBD\xB3\xEF\xBE\x9E\x00\x00\xEF\xBD\xB4\x00\x00\xEF\xBD\xB5\x00\x00\xEF\xBD\xB6\x00\x00\xEF\xBD\xB7\x00\x00\xEF\xBD\xB8\x00\x00\xEF\xBD\xB9\x00\x00\xEF\xBD\xBA\x00\x00\xEF\xBD\xB6\xEF\xBE\x9E\x00\x00\xEF\xBD\xB7\xEF\xBE\x9E\x00\x00\xEF\xBD\xB8\xEF\xBE\x9E\x00\x00\xEF\xBD\xB9\xEF\xBE\x9E\x00\x00\xEF\xBD\xBA\xEF\xBE\x9E\x00\x00\xEF\xBD\xBB\x00\x00\xEF\xBD\xBC\x00\x00\xEF\xBD\xBD\x00\x00\xEF\xBD\xBE\x00\x00\xEF\xBD\xBF\x00\x00\xEF\xBD\xBB\xEF\xBE\x9E\x00\x00\xEF\xBD\xBC\xEF\xBE\x9E\x00\x00\xEF\xBD\xBD\xEF\xBE\x9E\x00\x00\xEF\xBD\xBE\xEF\xBE\x9E\x00\x00\xEF\xBD\xBF\xEF\xBE\x9E\x00\x00\xEF\xBE\x80\x00\x00\xEF\xBE\x81\x00\x00\xEF\xBE\x82\x00\x00\xEF\xBE\x83\x00\x00\xEF\xBE\x84\x00\x00\xEF\xBE\x80\xEF\xBE\x9E\x00\x00\xEF\xBE\x81\xEF\xBE\x9E\x00\x00\xEF\xBE\x82\xEF\xBE\x9E\x00\x00\xEF\xBE\x83\xEF\xBE\x9E\x00\x00\xEF\xBE\x84\xEF\xBE\x9E\x00\x00\xEF\xBE\x85\x00\x00\xEF\xBE\x86\x00\x00\xEF\xBE\x87\x00\x00\xEF\xBE\x88\x00\x00\xEF\xBE\x89\x00\x00\xEF\xBE\x8A\x00\x00\xEF\xBE\x8B\x00\x00\xEF\xBE\x8C\x00\x00\xEF\xBE\x8D\x00\x00\xEF\xBE\x8E\x00\x00\xEF\xBE\x8A\xEF\xBE\x9E\x00\x00\xEF\xBE\x8B\xEF\xBE\x9E\x00\x00\xEF\xBE\x8C\xEF\xBE\x9E\x00\x00\xEF\xBE\x8D\xEF\xBE\x9E\x00\x00\xEF\xBE\x8E\xEF\xBE\x9E\x00\x00\xEF\xBE\x8A\xEF\xBE\x9F\x00\x00\xEF\xBE\x8B\xEF\xBE\x9F\x00\x00\xEF\xBE\x8C\xEF\xBE\x9F\x00\x00\xEF\xBE\x8D\xEF\xBE\x9F\x00\x00\xEF\xBE\x8E\xEF\xBE\x9F\x00\x00\xEF\xBE\x8F\x00\x00\xEF\xBE\x90\x00\x00\xEF\xBE\x91\x00\x00\xEF\xBE\x92\x00\x00\xEF\xBE\x93\x00\x00\xEF\xBE\x94\x00\x00\xEF\xBE\x95\x00\x00\xEF\xBE\x96\x00\x00\xEF\xBE\x97\x00\x00\xEF\xBE\x98\x00\x00\xEF\xBE\x99\x00\x00\xEF\xBE\x9A\x00\x00\xEF\xBE\x9B\x00\x00\xEF\xBE\x9C\x00\x00\xEF\xBE\x9C\xEF\xBE\x9E\x00\x00\xEF\xBE\x9D\x00\x00\xEF\xBE\x9E\x00\x00\xEF\xBE\x9F\x00\x00";
const mozc::TextConverter::DoubleArray fullwidthkatakana_to_halfwidthkatakana_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{101,1},{104,101},{-16,231},{85,101},{178,101},{231,104},{236,104},{-1,236},{-6,237},{-11,238},{-530,239},{-535,240},{239,85},{240,85},{-39,243},{-89,244},{237,104},{238,104},{243,85},{244,85},{278,85},{279,85},{280,85},{281,85},{282,85},{283,85},{284,85},{285,85},{286,85},{287,85},{288,85},{289,85},{290,85},{291,85},{292,85},{293,85},{294,85},{295,85},{296,85},{297,85},{298,85},{299,85},{300,85},{301,85},{302,85},{303,85},{304,85},{305,85},{306,85},{-44,278},{-94,279},{-49,280},{-99,281},{-54,282},{-112,283},{-59,284},{-117,285},{-122,286},{-147,287},{-127,288},{-155,289},{-132,290},{-163,291},{-137,292},{-171,293},{-142,294},{-179,295},{-187,296},{-212,297},{-192,298},{-220,299},{-197,300},{-228,301},{-202,302},{-236,303},{-207,304},{-244,305},{-252,306},{353,178},{355,178},{356,178},{360,178},{361,178},{362,178},{363,178},{364,178},{365,178},{368,178},{369,178},{370,178},{371,178},{372,178},{373,178},{374,178},{375,178},{376,178},{377,178},{378,178},{379,178},{380,178},{381,178},{382,178},{383,178},{384,178},{385,178},{386,178},{387,178},{388,178},{389,178},{390,178},{391,178},{392,178},{393,178},{394,178},{395,178},{396,178},{397,178},{398,178},{399,178},{400,178},{401,178},{402,178},{403,178},{404,178},{-277,353},{405,178},{-257,355},{-285,356},{409,178},{412,178},{413,178},{-79,360},{-262,361},{-293,362},{-267,363},{-301,364},{-272,365},{414,178},{415,178},{-309,368},{-317,369},{-322,370},{-327,371},{-332,372},{-337,373},{-342,374},{-367,375},{-407,376},{-347,377},{-375,378},{-415,379},{-352,380},{-383,381},{-423,382},{-357,383},{-391,384},{-431,385},{-362,386},{-399,387},{-439,388},{-447,389},{-452,390},{-457,391},{-462,392},{-467,393},{-64,394},{-472,395},{-69,396},{-477,397},{-74,398},{-482,399},{-487,400},{-492,401},{-497,402},{-502,403},{-507,404},{-512,405},{251,275},{408,251},{-517,408},{-26,409},{411,254},{-31,411},{-525,412},{-104,413},{-21,414},{-84,415},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{254,307},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{275,405},{0,0},{0,0},{0,0},{307,409},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char halfwidthkatakana_to_fullwidthkatakana_table[] = "\xE3\x80\x82\x00\x00\xE3\x80\x8C\x00\x00\xE3\x80\x8D\x00\x00\xE3\x80\x81\x00\x00\xE3\x83\xBB\x00\x00\xE3\x83\xB2\x00\x00\xE3\x83\xB2\xE3\x82\x9B\x00\x00\xE3\x82\xA1\x00\x00\xE3\x82\xA3\x00\x00\xE3\x82\xA5\x00\x00\xE3\x82\xA7\x00\x00\xE3\x82\xA9\x00\x00\xE3\x83\xA3\x00\x00\xE3\x83\xA5\x00\x00\xE3\x83\xA7\x00\x00\xE3\x83\x83\x00\x00\xE3\x83\xBC\x00\x00\xE3\x82\xA2\x00\x00\xE3\x82\xA4\x00\x00\xE3\x82\xA6\x00\x00\xE3\x83\xB4\x00\x00\xE3\x82\xA8\x00\x00\xE3\x82\xAA\x00\x00\xE3\x82\xAB\x00\x00\xE3\x82\xAD\x00\x00\xE3\x82\xAF\x00\x00\xE3\x82\xB1\x00\x00\xE3\x82\xB3\x00\x00\xE3\x82\xAC\x00\x00\xE3\x82\xAE\x00\x00\xE3\x82\xB0\x00\x00\xE3\x82\xB2\x00\x00\xE3\x82\xB4\x00\x00\xE3\x82\xB5\x00\x00\xE3\x82\xB7\x00\x00\xE3\x82\xB9\x00\x00\xE3\x82\xBB\x00\x00\xE3\x82\xBD\x00\x00\xE3\x82\xB6\x00\x00\xE3\x82\xB8\x00\x00\xE3\x82\xBA\x00\x00\xE3\x82\xBC\x00\x00\xE3\x82\xBE\x00\x00\xE3\x82\xBF\x00\x00\xE3\x83\x81\x00\x00\xE3\x83\x84\x00\x00\xE3\x83\x86\x00\x00\xE3\x83\x88\x00\x00\xE3\x83\x80\x00\x00\xE3\x83\x82\x00\x00\xE3\x83\x85\x00\x00\xE3\x83\x87\x00\x00\xE3\x83\x89\x00\x00\xE3\x83\x8A\x00\x00\xE3\x83\x8B\x00\x00\xE3\x83\x8C\x00\x00\xE3\x83\x8D\x00\x00\xE3\x83\x8E\x00\x00\xE3\x83\x8F\x00\x00\xE3\x83\x92\x00\x00\xE3\x83\x95\x00\x00\xE3\x83\x98\x00\x00\xE3\x83\x9B\x00\x00\xE3\x83\x90\x00\x00\xE3\x83\x93\x00\x00\xE3\x83\x96\x00\x00\xE3\x83\x99\x00\x00\xE3\x83\x9C\x00\x00\xE3\x83\x91\x00\x00\xE3\x83\x94\x00\x00\xE3\x83\x97\x00\x00\xE3\x83\x9A\x00\x00\xE3\x83\x9D\x00\x00\xE3\x83\x9E\x00\x00\xE3\x83\x9F\x00\x00\xE3\x83\xA0\x00\x00\xE3\x83\xA1\x00\x00\xE3\x83\xA2\x00\x00\xE3\x83\xA4\x00\x00\xE3\x83\xA6\x00\x00\xE3\x83\xA8\x00\x00\xE3\x83\xA9\x00\x00\xE3\x83\xAA\x00\x00\xE3\x83\xAB\x00\x00\xE3\x83\xAC\x00\x00\xE3\x83\xAD\x00\x00\xE3\x83\xAF\x00\x00\xE3\x83\xAF\xE3\x82\x9B\x00\x00\xE3\x83\xB3\x00\x00\xE3\x82\x9B\x00\x00\xE3\x82\x9C\x00\x00";
const mozc::TextConverter::DoubleArray halfwidthkatakana_to_fullwidthkatakana_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{52,1},{82,52},{213,52},{275,82},{276,82},{277,82},{278,82},{279,82},{280,82},{284,82},{285,82},{286,82},{287,82},{288,82},{289,82},{290,82},{291,82},{292,82},{293,82},{294,82},{295,82},{296,82},{300,82},{301,82},{302,82},{306,82},{310,82},{314,82},{318,82},{322,82},{326,82},{330,82},{334,82},{338,82},{-1,275},{-6,276},{-11,277},{-16,278},{-21,279},{-26,280},{123,90},{283,123},{-31,283},{-39,284},{-44,285},{-49,286},{-54,287},{-59,288},{-64,289},{-69,290},{-74,291},{-79,292},{-84,293},{-89,294},{-94,295},{-99,296},{139,106},{299,139},{-104,299},{-109,300},{-114,301},{-119,302},{145,112},{305,145},{-144,305},{-124,306},{149,116},{309,149},{-149,309},{-129,310},{153,120},{313,153},{-154,313},{-134,314},{157,124},{317,157},{-159,317},{-139,318},{161,128},{321,161},{-164,321},{-169,322},{165,132},{325,165},{-194,325},{-174,326},{169,136},{329,169},{-199,329},{-179,330},{173,140},{333,173},{-204,333},{-184,334},{177,144},{337,177},{-209,337},{-189,338},{181,148},{341,181},{-214,341},{374,213},{378,213},{382,213},{386,213},{390,213},{394,213},{395,213},{396,213},{397,213},{398,213},{399,213},{405,213},{411,213},{417,213},{423,213},{429,213},{430,213},{431,213},{432,213},{433,213},{434,213},{435,213},{436,213},{437,213},{438,213},{439,213},{440,213},{441,213},{442,213},{445,213},{446,213},{447,213},{-219,374},{217,184},{377,217},{-244,377},{-224,378},{221,188},{381,221},{-249,381},{-229,382},{225,192},{385,225},{-254,385},{-234,386},{229,196},{389,229},{-259,389},{-239,390},{233,200},{393,233},{-264,393},{-269,394},{-274,395},{-279,396},{-284,397},{-289,398},{-294,399},{242,209},{403,242},{404,242},{-319,403},{-344,404},{-299,405},{248,215},{409,248},{410,248},{-324,409},{-349,410},{-304,411},{-329,412},{255,222},{412,255},{416,255},{-354,416},{-309,417},{260,227},{421,260},{422,260},{-334,421},{-359,422},{-314,423},{-339,424},{267,234},{424,267},{428,267},{-364,428},{-369,429},{-374,430},{-379,431},{-384,432},{-389,433},{-394,434},{-399,435},{-404,436},{-409,437},{-414,438},{-419,439},{-424,440},{-429,441},{-434,442},{297,252},{-439,444},{-447,445},{-452,446},{-457,447},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{444,297},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{90,280},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{106,296},{0,0},{0,0},{0,0},{0,0},{0,0},{112,302},{0,0},{0,0},{0,0},{116,306},{0,0},{0,0},{0,0},{120,310},{0,0},{0,0},{0,0},{124,314},{0,0},{0,0},{0,0},{128,318},{0,0},{0,0},{0,0},{132,322},{0,0},{0,0},{0,0},{136,326},{0,0},{0,0},{0,0},{140,330},{0,0},{0,0},{0,0},{144,334},{0,0},{0,0},{0,0},{148,338},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{184,374},{0,0},{0,0},{0,0},{188,378},{0,0},{0,0},{0,0},{192,382},{0,0},{0,0},{0,0},{196,386},{0,0},{0,0},{0,0},{200,390},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{209,399},{0,0},{0,0},{0,0},{0,0},{0,0},{215,405},{0,0},{0,0},{0,0},{0,0},{0,0},{222,411},{0,0},{0,0},{0,0},{0,0},{0,0},{227,417},{0,0},{0,0},{0,0},{0,0},{0,0},{234,423},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{252,442},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char halfwidthascii_to_fullwidthascii_table[] = "\xE3\x80\x80\x00\x00\xEF\xBC\x81\x00\x00\xE2\x80\x9D\x00\x00\xEF\xBC\x83\x00\x00\xEF\xBC\x84\x00\x00\xEF\xBC\x85\x00\x00\xEF\xBC\x86\x00\x00\xE2\x80\x99\x00\x00\xEF\xBC\x88\x00\x00\xEF\xBC\x89\x00\x00\xEF\xBC\x8A\x00\x00\xEF\xBC\x8B\x00\x00\xEF\xBC\x8C\x00\x00\xE2\x88\x92\x00\x00\xEF\xBC\x8E\x00\x00\xEF\xBC\x8F\x00\x00\xEF\xBC\x90\x00\x00\xEF\xBC\x91\x00\x00\xEF\xBC\x92\x00\x00\xEF\xBC\x93\x00\x00\xEF\xBC\x94\x00\x00\xEF\xBC\x95\x00\x00\xEF\xBC\x96\x00\x00\xEF\xBC\x97\x00\x00\xEF\xBC\x98\x00\x00\xEF\xBC\x99\x00\x00\xEF\xBC\x9A\x00\x00\xEF\xBC\x9B\x00\x00\xEF\xBC\x9C\x00\x00\xEF\xBC\x9D\x00\x00\xEF\xBC\x9E\x00\x00\xEF\xBC\x9F\x00\x00\xEF\xBC\xA0\x00\x00\xEF\xBC\xA1\x00\x00\xEF\xBC\xA2\x00\x00\xEF\xBC\xA3\x00\x00\xEF\xBC\xA4\x00\x00\xEF\xBC\xA5\x00\x00\xEF\xBC\xA6\x00\x00\xEF\xBC\xA7\x00\x00\xEF\xBC\xA8\x00\x00\xEF\xBC\xA9\x00\x00\xEF\xBC\xAA\x00\x00\xEF\xBC\xAB\x00\x00\xEF\xBC\xAC\x00\x00\xEF\xBC\xAD\x00\x00\xEF\xBC\xAE\x00\x00\xEF\xBC\xAF\x00\x00\xEF\xBC\xB0\x00\x00\xEF\xBC\xB1\x00\x00\xEF\xBC\xB2\x00\x00\xEF\xBC\xB3\x00\x00\xEF\xBC\xB4\x00\x00\xEF\xBC\xB5\x00\x00\xEF\xBC\xB6\x00\x00\xEF\xBC\xB7\x00\x00\xEF\xBC\xB8\x00\x00\xEF\xBC\xB9\x00\x00\xEF\xBC\xBA\x00\x00\xEF\xBC\xBB\x00\x00\xEF\xBF\xA5\x00\x00\xEF\xBC\xBD\x00\x00\xEF\xBC\xBE\x00\x00\xEF\xBC\xBF\x00\x00\xEF\xBD\x80\x00\x00\xEF\xBD\x81\x00\x00\xEF\xBD\x82\x00\x00\xEF\xBD\x83\x00\x00\xEF\xBD\x84\x00\x00\xEF\xBD\x85\x00\x00\xEF\xBD\x86\x00\x00\xEF\xBD\x87\x00\x00\xEF\xBD\x88\x00\x00\xEF\xBD\x89\x00\x00\xEF\xBD\x8A\x00\x00\xEF\xBD\x8B\x00\x00\xEF\xBD\x8C\x00\x00\xEF\xBD\x8D\x00\x00\xEF\xBD\x8E\x00\x00\xEF\xBD\x8F\x00\x00\xEF\xBD\x90\x00\x00\xEF\xBD\x91\x00\x00\xEF\xBD\x92\x00\x00\xEF\xBD\x93\x00\x00\xEF\xBD\x94\x00\x00\xEF\xBD\x95\x00\x00\xEF\xBD\x96\x00\x00\xEF\xBD\x97\x00\x00\xEF\xBD\x98\x00\x00\xEF\xBD\x99\x00\x00\xEF\xBD\x9A\x00\x00\xEF\xBD\x9B\x00\x00\xEF\xBD\x9C\x00\x00\xEF\xBD\x9D\x00\x00\xE3\x80\x9C\x00\x00";
const mozc::TextConverter::DoubleArray halfwidthascii_to_fullwidthascii_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{129,1},{130,1},{131,1},{132,1},{133,1},{134,1},{135,1},{136,1},{137,1},{138,1},{139,1},{140,1},{141,1},{142,1},{143,1},{144,1},{145,1},{146,1},{147,1},{148,1},{149,1},{150,1},{151,1},{152,1},{153,1},{154,1},{155,1},{156,1},{157,1},{158,1},{159,1},{160,1},{161,1},{162,1},{163,1},{164,1},{165,1},{166,1},{167,1},{168,1},{169,1},{170,1},{171,1},{172,1},{173,1},{174,1},{175,1},{176,1},{177,1},{178,1},{179,1},{180,1},{181,1},{182,1},{183,1},{184,1},{185,1},{186,1},{187,1},{188,1},{189,1},{190,1},{191,1},{192,1},{193,1},{194,1},{195,1},{196,1},{197,1},{198,1},{199,1},{200,1},{201,1},{202,1},{203,1},{204,1},{205,1},{206,1},{207,1},{208,1},{209,1},{210,1},{211,1},{212,1},{213,1},{214,1},{215,1},{216,1},{217,1},{218,1},{219,1},{220,1},{221,1},{222,1},{223,1},{-1,129},{-6,130},{-11,131},{-16,132},{-21,133},{-26,134},{-31,135},{-36,136},{-41,137},{-46,138},{-51,139},{-56,140},{-61,141},{-66,142},{-71,143},{-76,144},{-81,145},{-86,146},{-91,147},{-96,148},{-101,149},{-106,150},{-111,151},{-116,152},{-121,153},{-126,154},{-131,155},{-136,156},{-141,157},{-146,158},{-151,159},{-156,160},{-161,161},{-166,162},{-171,163},{-176,164},{-181,165},{-186,166},{-191,167},{-196,168},{-201,169},{-206,170},{-211,171},{-216,172},{-221,173},{-226,174},{-231,175},{-236,176},{-241,177},{-246,178},{-251,179},{-256,180},{-261,181},{-266,182},{-271,183},{-276,184},{-281,185},{-286,186},{-291,187},{-296,188},{-301,189},{-306,190},{-311,191},{-316,192},{-321,193},{-326,194},{-331,195},{-336,196},{-341,197},{-346,198},{-351,199},{-356,200},{-361,201},{-366,202},{-371,203},{-376,204},{-381,205},{-386,206},{-391,207},{-396,208},{-401,209},{-406,210},{-411,211},{-416,212},{-421,213},{-426,214},{-431,215},{-436,216},{-441,217},{-446,218},{-451,219},{-456,220},{-461,221},{-466,222},{-471,223},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char fullwidthascii_to_halfwidthascii_table[] = "\x20\x00\x00\x21\x00\x00\x22\x00\x00\x23\x00\x00\x24\x00\x00\x25\x00\x00\x26\x00\x00\x27\x00\x00\x28\x00\x00\x29\x00\x00\x2A\x00\x00\x2B\x00\x00\x2C\x00\x00\x2D\x00\x00\x2E\x00\x00\x2F\x00\x00\x30\x00\x00\x31\x00\x00\x32\x00\x00\x33\x00\x00\x34\x00\x00\x35\x00\x00\x36\x00\x00\x37\x00\x00\x38\x00\x00\x39\x00\x00\x3A\x00\x00\x3B\x00\x00\x3C\x00\x00\x3D\x00\x00\x3E\x00\x00\x3F\x00\x00\x40\x00\x00\x41\x00\x00\x42\x00\x00\x43\x00\x00\x44\x00\x00\x45\x00\x00\x46\x00\x00\x47\x00\x00\x48\x00\x00\x49\x00\x00\x4A\x00\x00\x4B\x00\x00\x4C\x00\x00\x4D\x00\x00\x4E\x00\x00\x4F\x00\x00\x50\x00\x00\x51\x00\x00\x52\x00\x00\x53\x00\x00\x54\x00\x00\x55\x00\x00\x56\x00\x00\x57\x00\x00\x58\x00\x00\x59\x00\x00\x5A\x00\x00\x5B\x00\x00\x5C\x00\x00\x5D\x00\x00\x5E\x00\x00\x5F\x00\x00\x60\x00\x00\x61\x00\x00\x62\x00\x00\x63\x00\x00\x64\x00\x00\x65\x00\x00\x66\x00\x00\x67\x00\x00\x68\x00\x00\x69\x00\x00\x6A\x00\x00\x6B\x00\x00\x6C\x00\x00\x6D\x00\x00\x6E\x00\x00\x6F\x00\x00\x70\x00\x00\x71\x00\x00\x72\x00\x00\x73\x00\x00\x74\x00\x00\x75\x00\x00\x76\x00\x00\x77\x00\x00\x78\x00\x00\x79\x00\x00\x7A\x00\x00\x7B\x00\x00\x7C\x00\x00\x7D\x00\x00\x7E\x00\x00";
const mozc::TextConverter::DoubleArray fullwidthascii_to_halfwidthascii_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{101,1},{108,1},{77,101},{232,77},{-22,232},{-7,233},{236,87},{233,77},{-40,236},{110,108},{87,101},{240,110},{-1,240},{54,1},{-283,242},{125,54},{237,54},{-4,245},{259,54},{-10,247},{-13,248},{-16,249},{-19,250},{-25,251},{-28,252},{-31,253},{-34,254},{245,125},{-37,256},{247,125},{248,125},{249,125},{250,125},{-43,261},{251,125},{252,125},{253,125},{254,125},{256,125},{242,110},{261,125},{314,125},{318,125},{319,125},{320,125},{321,125},{322,125},{323,125},{324,125},{325,125},{326,125},{327,125},{328,125},{329,125},{330,125},{331,125},{332,125},{333,125},{334,125},{335,125},{336,125},{337,125},{338,125},{339,125},{340,125},{341,125},{342,125},{343,125},{344,125},{345,125},{346,125},{347,125},{348,125},{349,125},{350,125},{351,125},{352,125},{353,125},{354,125},{355,125},{356,125},{357,125},{358,125},{359,125},{360,125},{361,125},{-46,314},{362,125},{363,125},{364,125},{-49,318},{-52,319},{-55,320},{-58,321},{-61,322},{-64,323},{-67,324},{-70,325},{-73,326},{-76,327},{-79,328},{-82,329},{-85,330},{-88,331},{-91,332},{-94,333},{-97,334},{-100,335},{-103,336},{-106,337},{-109,338},{-112,339},{-115,340},{-118,341},{-121,342},{-124,343},{-127,344},{-130,345},{-133,346},{-136,347},{-139,348},{-142,349},{-145,350},{-148,351},{-151,352},{-154,353},{-157,354},{-160,355},{-163,356},{-166,357},{-169,358},{-172,359},{-175,360},{-178,361},{-184,362},{-187,363},{-190,364},{-193,365},{365,237},{396,237},{397,237},{398,237},{399,237},{400,237},{401,237},{402,237},{403,237},{404,237},{405,237},{406,237},{407,237},{408,237},{409,237},{410,237},{411,237},{412,237},{413,237},{414,237},{415,237},{416,237},{417,237},{418,237},{419,237},{420,237},{421,237},{422,237},{423,237},{424,237},{-196,396},{-199,397},{-202,398},{-205,399},{-208,400},{-211,401},{-214,402},{-217,403},{-220,404},{-223,405},{-226,406},{-229,407},{-232,408},{-235,409},{-238,410},{-241,411},{-244,412},{-247,413},{-250,414},{-253,415},{-256,416},{-259,417},{-262,418},{-265,419},{-268,420},{-271,421},{-274,422},{-277,423},{-280,424},{426,259},{-181,426},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char normalize_voiced_sound_table[] = "\xE3\x82\x94\x00\x00";
const mozc::TextConverter::DoubleArray normalize_voiced_sound_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{100,1},{96,100},{4,96},{102,4},{78,102},{235,78},{-1,235},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};
const char kanjinumber_to_arabicnumber_table[] = "\x30\x00\x00\x31\x00\x00\x32\x00\x00\x33\x00\x00\x34\x00\x00\x35\x00\x00\x36\x00\x00\x37\x00\x00\x38\x00\x00\x39\x00\x00\x31\x30\x00\x00\x31\x30\x30\x00\x00\x31\x30\x30\x30\x00\x00\x31\x30\x30\x30\x30\x00\x00\x31\x30\x30\x30\x30\x30\x30\x30\x30\x00\x00\x31\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x00\x00\x31\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x00\x00\x30\x00\x00\x31\x00\x00\x32\x00\x00\x33\x00\x00\x34\x00\x00\x35\x00\x00\x36\x00\x00\x37\x00\x00\x38\x00\x00\x39\x00\x00\x30\x00\x00\x31\x00\x00\x32\x00\x00\x33\x00\x00\x34\x00\x00\x35\x00\x00\x36\x00\x00\x37\x00\x00\x38\x00\x00\x39\x00\x00\x31\x00\x00\x32\x00\x00\x33\x00\x00\x31\x30\x00\x00\x32\x30\x00\x00\x33\x30\x00\x00\x34\x30\x00\x00";
const mozc::TextConverter::DoubleArray kanjinumber_to_arabicnumber_da[] = {{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{60,1},{61,1},{62,1},{63,1},{64,1},{65,1},{66,1},{67,1},{68,1},{69,1},{-98,60},{-101,61},{-104,62},{-107,63},{-110,64},{-113,65},{-116,66},{-119,67},{-122,68},{-125,69},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{-4,186},{70,2},{35,2},{54,2},{-22,190},{-46,191},{-10,192},{194,35},{-28,194},{196,54},{-7,196},{-16,197},{-79,198},{186,70},{-53,200},{-64,201},{190,70},{197,54},{200,71},{-25,205},{191,70},{201,72},{192,70},{-19,209},{-31,210},{71,78},{72,78},{210,83},{-40,214},{214,83},{-175,216},{216,83},{-179,218},{221,88},{83,78},{-164,221},{88,78},{-13,223},{218,83},{226,47},{-158,226},{198,54},{236,36},{223,73},{2,1},{78,1},{99,1},{91,1},{73,78},{93,1},{-171,236},{238,92},{-161,238},{49,99},{243,49},{75,1},{47,78},{-167,243},{205,72},{56,91},{209,72},{248,56},{-35,248},{74,93},{-1,250},{-128,251},{-131,252},{-134,253},{-137,254},{-140,255},{-143,256},{250,74},{-146,258},{-149,259},{-152,260},{-155,261},{0,0},{0,0},{123,75},{0,0},{36,78},{92,78},{251,123},{252,123},{253,123},{254,123},{255,123},{256,123},{258,123},{259,123},{260,123},{261,123},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}};

}  // namespace japanese_util_rule
}  // namespace mozc
