// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 20.2.2.23
description: >
  Math.log2.name is "log2".
info: |
  Math.log2 ( x )

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(Math.log2.name, "log2");

verifyNotEnumerable(Math.log2, "name");
verifyNotWritable(Math.log2, "name");
verifyConfigurable(Math.log2, "name");

reportCompare(0, 0);
