/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[50] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	ValaCodeContext* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	ValaReport* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp22_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = 0;
		return result;
	}
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_report_get_errors (_tmp13_);
	if (_tmp14_ == 0) {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp16_ = vala_compiler_fatal_warnings;
		if (!_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			ValaCodeContext* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			ValaReport* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			_tmp17_ = self->priv->context;
			_tmp18_ = vala_code_context_get_report (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_report_get_warnings (_tmp19_);
			_tmp15_ = _tmp20_ == 0;
		}
		_tmp21_ = _tmp15_;
		_tmp10_ = _tmp21_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		gboolean _tmp23_ = FALSE;
		_tmp23_ = vala_compiler_quiet_mode;
		if (!_tmp23_) {
			FILE* _tmp24_ = NULL;
			ValaCodeContext* _tmp25_ = NULL;
			ValaReport* _tmp26_ = NULL;
			ValaReport* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			_tmp24_ = stdout;
			_tmp25_ = self->priv->context;
			_tmp26_ = vala_code_context_get_report (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_report_get_warnings (_tmp27_);
			fprintf (_tmp24_, "Compilation succeeded - %d warning(s)\n", _tmp28_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp29_ = FALSE;
		_tmp29_ = vala_compiler_quiet_mode;
		if (!_tmp29_) {
			FILE* _tmp30_ = NULL;
			ValaCodeContext* _tmp31_ = NULL;
			ValaReport* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			ValaCodeContext* _tmp35_ = NULL;
			ValaReport* _tmp36_ = NULL;
			ValaReport* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			_tmp30_ = stdout;
			_tmp31_ = self->priv->context;
			_tmp32_ = vala_code_context_get_report (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_report_get_errors (_tmp33_);
			_tmp35_ = self->priv->context;
			_tmp36_ = vala_code_context_get_report (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_report_get_warnings (_tmp37_);
			fprintf (_tmp30_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp34_, _tmp38_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaCodeContext* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	ValaCodeContext* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	ValaCodeContext* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	ValaCodeContext* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	ValaCodeContext* _tmp33_ = NULL;
	ValaReport* _tmp34_ = NULL;
	ValaReport* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	ValaCodeContext* _tmp37_ = NULL;
	ValaReport* _tmp38_ = NULL;
	ValaReport* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	ValaCodeContext* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	ValaCodeContext* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_ = NULL;
	gboolean _tmp54_ = FALSE;
	ValaCodeContext* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	ValaCodeContext* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	ValaCodeContext* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	ValaCodeContext* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	ValaCodeContext* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	const gchar* _tmp73_ = NULL;
	ValaCodeContext* _tmp82_ = NULL;
	gchar** _tmp83_ = NULL;
	gint _tmp83__length1 = 0;
	gchar** _tmp84_ = NULL;
	gint _tmp84__length1 = 0;
	ValaCodeContext* _tmp85_ = NULL;
	gchar** _tmp86_ = NULL;
	gint _tmp86__length1 = 0;
	gchar** _tmp87_ = NULL;
	gint _tmp87__length1 = 0;
	ValaCodeContext* _tmp88_ = NULL;
	gchar** _tmp89_ = NULL;
	gint _tmp89__length1 = 0;
	gchar** _tmp90_ = NULL;
	gint _tmp90__length1 = 0;
	ValaCodeContext* _tmp91_ = NULL;
	gboolean _tmp92_ = FALSE;
	ValaCodeContext* _tmp93_ = NULL;
	gboolean _tmp94_ = FALSE;
	ValaCodeContext* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	ValaCodeContext* _tmp97_ = NULL;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	const gchar* _tmp101_ = NULL;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp111_ = FALSE;
	const gchar* _tmp112_ = NULL;
	ValaCodeContext* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
	ValaCodeContext* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	ValaCodeContext* _tmp117_ = NULL;
	gboolean _tmp118_ = FALSE;
	gchar** _tmp119_ = NULL;
	gint _tmp119__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp132_ = FALSE;
	const gchar* _tmp133_ = NULL;
	gboolean _tmp136_ = FALSE;
	ValaCodeContext* _tmp137_ = NULL;
	gint _tmp138_ = 0;
	ValaCodeContext* _tmp139_ = NULL;
	gint _tmp140_ = 0;
	ValaCodeContext* _tmp141_ = NULL;
	gint _tmp142_ = 0;
	gint _tmp143_ = 0;
	gboolean _tmp153_ = FALSE;
	gchar** _tmp156_ = NULL;
	gint _tmp156__length1 = 0;
	gchar** _tmp161_ = NULL;
	gint _tmp161__length1 = 0;
	ValaCodeContext* _tmp172_ = NULL;
	gchar** _tmp173_ = NULL;
	gint _tmp173__length1 = 0;
	gchar** _tmp174_ = NULL;
	gint _tmp174__length1 = 0;
	gboolean _tmp175_ = FALSE;
	ValaCodeContext* _tmp176_ = NULL;
	ValaReport* _tmp177_ = NULL;
	ValaReport* _tmp178_ = NULL;
	gint _tmp179_ = 0;
	gboolean _tmp187_ = FALSE;
	ValaCodeContext* _tmp189_ = NULL;
	ValaGDBusServerModule* _tmp190_ = NULL;
	ValaGDBusServerModule* _tmp191_ = NULL;
	gboolean has_c_files = FALSE;
	gchar** _tmp192_ = NULL;
	gint _tmp192__length1 = 0;
	gboolean _tmp200_ = FALSE;
	ValaCodeContext* _tmp201_ = NULL;
	ValaReport* _tmp202_ = NULL;
	ValaReport* _tmp203_ = NULL;
	gint _tmp204_ = 0;
	gboolean _tmp212_ = FALSE;
	ValaParser* parser = NULL;
	ValaParser* _tmp214_ = NULL;
	ValaParser* _tmp215_ = NULL;
	ValaCodeContext* _tmp216_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp217_ = NULL;
	ValaGenieParser* _tmp218_ = NULL;
	ValaCodeContext* _tmp219_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp220_ = NULL;
	ValaGirParser* _tmp221_ = NULL;
	ValaCodeContext* _tmp222_ = NULL;
	gboolean _tmp223_ = FALSE;
	ValaCodeContext* _tmp224_ = NULL;
	ValaReport* _tmp225_ = NULL;
	ValaReport* _tmp226_ = NULL;
	gint _tmp227_ = 0;
	gboolean _tmp235_ = FALSE;
	const gchar* _tmp237_ = NULL;
	ValaCodeContext* _tmp243_ = NULL;
	gboolean _tmp244_ = FALSE;
	ValaCodeContext* _tmp245_ = NULL;
	ValaReport* _tmp246_ = NULL;
	ValaReport* _tmp247_ = NULL;
	gint _tmp248_ = 0;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp258_ = FALSE;
	gboolean _tmp259_ = FALSE;
	gboolean _tmp260_ = FALSE;
	gboolean _tmp262_ = FALSE;
	gboolean _tmp264_ = FALSE;
	const gchar* _tmp271_ = NULL;
	gboolean _tmp276_ = FALSE;
	ValaCodeContext* _tmp277_ = NULL;
	ValaReport* _tmp278_ = NULL;
	ValaReport* _tmp279_ = NULL;
	gint _tmp280_ = 0;
	gboolean _tmp288_ = FALSE;
	ValaCodeContext* _tmp290_ = NULL;
	ValaCodeGenerator* _tmp291_ = NULL;
	ValaCodeGenerator* _tmp292_ = NULL;
	ValaCodeContext* _tmp293_ = NULL;
	gboolean _tmp294_ = FALSE;
	ValaCodeContext* _tmp295_ = NULL;
	ValaReport* _tmp296_ = NULL;
	ValaReport* _tmp297_ = NULL;
	gint _tmp298_ = 0;
	gboolean _tmp306_ = FALSE;
	gboolean _tmp308_ = FALSE;
	const gchar* _tmp309_ = NULL;
	gboolean _tmp311_ = FALSE;
	const gchar* _tmp314_ = NULL;
	const gchar* _tmp367_ = NULL;
	const gchar* _tmp382_ = NULL;
	const gchar* _tmp407_ = NULL;
	gboolean _tmp410_ = FALSE;
	gint _tmp428_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = vala_compiler_output;
		_tmp2_ = _tmp7_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp9_ = vala_compiler_sources;
		_tmp9__length1 = _vala_array_length (vala_compiler_sources);
		_tmp10_ = _tmp9_[0];
		_tmp11_ = string_last_index_of_char (_tmp10_, (gunichar) '.', 0);
		if (_tmp11_ != (-1)) {
			gint dot = 0;
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp12_ = vala_compiler_sources;
			_tmp12__length1 = _vala_array_length (vala_compiler_sources);
			_tmp13_ = _tmp12_[0];
			_tmp14_ = string_last_index_of_char (_tmp13_, (gunichar) '.', 0);
			dot = _tmp14_;
			_tmp15_ = vala_compiler_sources;
			_tmp15__length1 = _vala_array_length (vala_compiler_sources);
			_tmp16_ = _tmp15_[0];
			_tmp17_ = dot;
			_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_path_get_basename (_tmp19_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp20_;
			_g_free0 (_tmp19_);
		}
	}
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp21_, !_tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_code_context_get_report (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp39_, !_tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp43_, !_tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp49_, _tmp50_);
	_tmp52_ = vala_compiler_header_filename;
	if (_tmp52_ == NULL) {
		gboolean _tmp53_ = FALSE;
		_tmp53_ = vala_compiler_use_header;
		_tmp51_ = _tmp53_;
	} else {
		_tmp51_ = FALSE;
	}
	_tmp54_ = _tmp51_;
	if (_tmp54_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->context;
	_tmp62_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp61_, _tmp62_);
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_output;
	vala_code_context_set_output (_tmp63_, _tmp64_);
	_tmp65_ = vala_compiler_basedir;
	if (_tmp65_ == NULL) {
		ValaCodeContext* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_code_context_realpath (".");
		_tmp68_ = _tmp67_;
		vala_code_context_set_basedir (_tmp66_, _tmp68_);
		_g_free0 (_tmp68_);
	} else {
		ValaCodeContext* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		_tmp69_ = self->priv->context;
		_tmp70_ = vala_compiler_basedir;
		_tmp71_ = vala_code_context_realpath (_tmp70_);
		_tmp72_ = _tmp71_;
		vala_code_context_set_basedir (_tmp69_, _tmp72_);
		_g_free0 (_tmp72_);
	}
	_tmp73_ = vala_compiler_directory;
	if (_tmp73_ != NULL) {
		ValaCodeContext* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		_tmp74_ = self->priv->context;
		_tmp75_ = vala_compiler_directory;
		_tmp76_ = vala_code_context_realpath (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_code_context_set_directory (_tmp74_, _tmp77_);
		_g_free0 (_tmp77_);
	} else {
		ValaCodeContext* _tmp78_ = NULL;
		ValaCodeContext* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
		_tmp78_ = self->priv->context;
		_tmp79_ = self->priv->context;
		_tmp80_ = vala_code_context_get_basedir (_tmp79_);
		_tmp81_ = _tmp80_;
		vala_code_context_set_directory (_tmp78_, _tmp81_);
	}
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_vapi_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp84_ = (_tmp83_ != NULL) ? _vala_array_dup1 (_tmp83_, _tmp83__length1) : ((gpointer) _tmp83_);
	_tmp84__length1 = _tmp83__length1;
	_tmp82_->vapi_directories = (_vala_array_free (_tmp82_->vapi_directories, _tmp82_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp82_->vapi_directories = _tmp84_;
	_tmp82_->vapi_directories_length1 = _tmp84__length1;
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_compiler_gir_directories;
	_tmp86__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp87_ = (_tmp86_ != NULL) ? _vala_array_dup2 (_tmp86_, _tmp86__length1) : ((gpointer) _tmp86_);
	_tmp87__length1 = _tmp86__length1;
	_tmp85_->gir_directories = (_vala_array_free (_tmp85_->gir_directories, _tmp85_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp85_->gir_directories = _tmp87_;
	_tmp85_->gir_directories_length1 = _tmp87__length1;
	_tmp88_ = self->priv->context;
	_tmp89_ = vala_compiler_metadata_directories;
	_tmp89__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp90_ = (_tmp89_ != NULL) ? _vala_array_dup3 (_tmp89_, _tmp89__length1) : ((gpointer) _tmp89_);
	_tmp90__length1 = _tmp89__length1;
	_tmp88_->metadata_directories = (_vala_array_free (_tmp88_->metadata_directories, _tmp88_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp88_->metadata_directories = _tmp90_;
	_tmp88_->metadata_directories_length1 = _tmp90__length1;
	_tmp91_ = self->priv->context;
	_tmp92_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp91_, _tmp92_);
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->context;
	_tmp96_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp95_, _tmp96_);
	_tmp97_ = self->priv->context;
	_tmp98_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp97_, _tmp98_);
	_tmp101_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp101_, "gobject-2.0") == 0) {
		_tmp100_ = TRUE;
	} else {
		const gchar* _tmp102_ = NULL;
		_tmp102_ = vala_compiler_profile;
		_tmp100_ = g_strcmp0 (_tmp102_, "gobject") == 0;
	}
	_tmp103_ = _tmp100_;
	if (_tmp103_) {
		_tmp99_ = TRUE;
	} else {
		const gchar* _tmp104_ = NULL;
		_tmp104_ = vala_compiler_profile;
		_tmp99_ = _tmp104_ == NULL;
	}
	_tmp105_ = _tmp99_;
	if (_tmp105_) {
		ValaCodeContext* _tmp106_ = NULL;
		ValaCodeContext* _tmp107_ = NULL;
		_tmp106_ = self->priv->context;
		vala_code_context_set_profile (_tmp106_, VALA_PROFILE_GOBJECT);
		_tmp107_ = self->priv->context;
		vala_code_context_add_define (_tmp107_, "GOBJECT");
	} else {
		const gchar* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		_tmp108_ = vala_compiler_profile;
		_tmp109_ = g_strdup_printf ("Unknown profile %s", _tmp108_);
		_tmp110_ = _tmp109_;
		vala_report_error (NULL, _tmp110_);
		_g_free0 (_tmp110_);
	}
	_tmp111_ = vala_compiler_nostdpkg;
	_tmp112_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp111_ | (_tmp112_ != NULL);
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp113_, _tmp114_);
	_tmp115_ = self->priv->context;
	_tmp116_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp115_, _tmp116_);
	_tmp117_ = self->priv->context;
	_tmp118_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp117_, _tmp118_);
	_tmp119_ = vala_compiler_defines;
	_tmp119__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp119_ != NULL) {
		gchar** _tmp120_ = NULL;
		gint _tmp120__length1 = 0;
		_tmp120_ = vala_compiler_defines;
		_tmp120__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp120_;
			define_collection_length1 = _tmp120__length1;
			for (define_it = 0; define_it < _tmp120__length1; define_it = define_it + 1) {
				gchar* _tmp121_ = NULL;
				gchar* define = NULL;
				_tmp121_ = g_strdup (define_collection[define_it]);
				define = _tmp121_;
				{
					ValaCodeContext* _tmp122_ = NULL;
					const gchar* _tmp123_ = NULL;
					_tmp122_ = self->priv->context;
					_tmp123_ = define;
					vala_code_context_add_define (_tmp122_, _tmp123_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp124_ = FALSE;
			_tmp124_ = TRUE;
			while (TRUE) {
				gboolean _tmp125_ = FALSE;
				gint _tmp127_ = 0;
				ValaCodeContext* _tmp128_ = NULL;
				gint _tmp129_ = 0;
				gchar* _tmp130_ = NULL;
				gchar* _tmp131_ = NULL;
				_tmp125_ = _tmp124_;
				if (!_tmp125_) {
					gint _tmp126_ = 0;
					_tmp126_ = i;
					i = _tmp126_ + 2;
				}
				_tmp124_ = FALSE;
				_tmp127_ = i;
				if (!(_tmp127_ <= 22)) {
					break;
				}
				_tmp128_ = self->priv->context;
				_tmp129_ = i;
				_tmp130_ = g_strdup_printf ("VALA_0_%d", _tmp129_);
				_tmp131_ = _tmp130_;
				vala_code_context_add_define (_tmp128_, _tmp131_);
				_g_free0 (_tmp131_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 18;
	_tmp133_ = vala_compiler_target_glib;
	if (_tmp133_ != NULL) {
		const gchar* _tmp134_ = NULL;
		gint _tmp135_ = 0;
		_tmp134_ = vala_compiler_target_glib;
		_tmp135_ = sscanf (_tmp134_, "%d.%d", &glib_major, &glib_minor);
		_tmp132_ = _tmp135_ != 2;
	} else {
		_tmp132_ = FALSE;
	}
	_tmp136_ = _tmp132_;
	if (_tmp136_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp137_ = self->priv->context;
	_tmp138_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp137_, _tmp138_);
	_tmp139_ = self->priv->context;
	_tmp140_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp139_, _tmp140_);
	_tmp141_ = self->priv->context;
	_tmp142_ = vala_code_context_get_target_glib_major (_tmp141_);
	_tmp143_ = _tmp142_;
	if (_tmp143_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp144_ = FALSE;
			_tmp144_ = TRUE;
			while (TRUE) {
				gboolean _tmp145_ = FALSE;
				gint _tmp147_ = 0;
				gint _tmp148_ = 0;
				ValaCodeContext* _tmp149_ = NULL;
				gint _tmp150_ = 0;
				gchar* _tmp151_ = NULL;
				gchar* _tmp152_ = NULL;
				_tmp145_ = _tmp144_;
				if (!_tmp145_) {
					gint _tmp146_ = 0;
					_tmp146_ = i;
					i = _tmp146_ + 2;
				}
				_tmp144_ = FALSE;
				_tmp147_ = i;
				_tmp148_ = glib_minor;
				if (!(_tmp147_ <= _tmp148_)) {
					break;
				}
				_tmp149_ = self->priv->context;
				_tmp150_ = i;
				_tmp151_ = g_strdup_printf ("GLIB_2_%d", _tmp150_);
				_tmp152_ = _tmp151_;
				vala_code_context_add_define (_tmp149_, _tmp152_);
				_g_free0 (_tmp152_);
			}
		}
	}
	_tmp153_ = vala_compiler_nostdpkg;
	if (!_tmp153_) {
		ValaCodeContext* _tmp154_ = NULL;
		ValaCodeContext* _tmp155_ = NULL;
		_tmp154_ = self->priv->context;
		vala_code_context_add_external_package (_tmp154_, "glib-2.0");
		_tmp155_ = self->priv->context;
		vala_code_context_add_external_package (_tmp155_, "gobject-2.0");
	}
	_tmp156_ = vala_compiler_packages;
	_tmp156__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp156_ != NULL) {
		gchar** _tmp157_ = NULL;
		gint _tmp157__length1 = 0;
		_tmp157_ = vala_compiler_packages;
		_tmp157__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp157_;
			package_collection_length1 = _tmp157__length1;
			for (package_it = 0; package_it < _tmp157__length1; package_it = package_it + 1) {
				gchar* _tmp158_ = NULL;
				gchar* package = NULL;
				_tmp158_ = g_strdup (package_collection[package_it]);
				package = _tmp158_;
				{
					ValaCodeContext* _tmp159_ = NULL;
					const gchar* _tmp160_ = NULL;
					_tmp159_ = self->priv->context;
					_tmp160_ = package;
					vala_code_context_add_external_package (_tmp159_, _tmp160_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp161_ = vala_compiler_fast_vapis;
	_tmp161__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp161_ != NULL) {
		gchar** _tmp162_ = NULL;
		gint _tmp162__length1 = 0;
		ValaCodeContext* _tmp171_ = NULL;
		_tmp162_ = vala_compiler_fast_vapis;
		_tmp162__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp162_;
			vapi_collection_length1 = _tmp162__length1;
			for (vapi_it = 0; vapi_it < _tmp162__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp163_ = NULL;
				gchar* vapi = NULL;
				_tmp163_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp163_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp164_ = NULL;
					gchar* _tmp165_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp166_ = NULL;
					const gchar* _tmp167_ = NULL;
					ValaSourceFile* _tmp168_ = NULL;
					ValaCodeContext* _tmp169_ = NULL;
					ValaSourceFile* _tmp170_ = NULL;
					_tmp164_ = vapi;
					_tmp165_ = vala_code_context_realpath (_tmp164_);
					rpath = _tmp165_;
					_tmp166_ = self->priv->context;
					_tmp167_ = rpath;
					_tmp168_ = vala_source_file_new (_tmp166_, VALA_SOURCE_FILE_TYPE_FAST, _tmp167_, NULL, FALSE);
					source_file = _tmp168_;
					_tmp169_ = self->priv->context;
					_tmp170_ = source_file;
					vala_code_context_add_source_file (_tmp169_, _tmp170_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp171_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp171_, TRUE);
	}
	_tmp172_ = self->priv->context;
	_tmp173_ = vala_compiler_gresources;
	_tmp173__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp174_ = (_tmp173_ != NULL) ? _vala_array_dup4 (_tmp173_, _tmp173__length1) : ((gpointer) _tmp173_);
	_tmp174__length1 = _tmp173__length1;
	_tmp172_->gresources = (_vala_array_free (_tmp172_->gresources, _tmp172_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp172_->gresources = _tmp174_;
	_tmp172_->gresources_length1 = _tmp174__length1;
	_tmp176_ = self->priv->context;
	_tmp177_ = vala_code_context_get_report (_tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = vala_report_get_errors (_tmp178_);
	if (_tmp179_ > 0) {
		_tmp175_ = TRUE;
	} else {
		gboolean _tmp180_ = FALSE;
		gboolean _tmp181_ = FALSE;
		gboolean _tmp186_ = FALSE;
		_tmp181_ = vala_compiler_fatal_warnings;
		if (_tmp181_) {
			ValaCodeContext* _tmp182_ = NULL;
			ValaReport* _tmp183_ = NULL;
			ValaReport* _tmp184_ = NULL;
			gint _tmp185_ = 0;
			_tmp182_ = self->priv->context;
			_tmp183_ = vala_code_context_get_report (_tmp182_);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_report_get_warnings (_tmp184_);
			_tmp180_ = _tmp185_ > 0;
		} else {
			_tmp180_ = FALSE;
		}
		_tmp186_ = _tmp180_;
		_tmp175_ = _tmp186_;
	}
	_tmp187_ = _tmp175_;
	if (_tmp187_) {
		gint _tmp188_ = 0;
		_tmp188_ = vala_compiler_quit (self);
		result = _tmp188_;
		return result;
	}
	_tmp189_ = self->priv->context;
	_tmp190_ = vala_gd_bus_server_module_new ();
	_tmp191_ = _tmp190_;
	vala_code_context_set_codegen (_tmp189_, (ValaCodeGenerator*) _tmp191_);
	_vala_code_visitor_unref0 (_tmp191_);
	has_c_files = FALSE;
	_tmp192_ = vala_compiler_sources;
	_tmp192__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp192_;
		source_collection_length1 = _tmp192__length1;
		for (source_it = 0; source_it < _tmp192__length1; source_it = source_it + 1) {
			gchar* _tmp193_ = NULL;
			gchar* source = NULL;
			_tmp193_ = g_strdup (source_collection[source_it]);
			source = _tmp193_;
			{
				ValaCodeContext* _tmp194_ = NULL;
				const gchar* _tmp195_ = NULL;
				gboolean _tmp196_ = FALSE;
				gboolean _tmp197_ = FALSE;
				_tmp194_ = self->priv->context;
				_tmp195_ = source;
				_tmp196_ = vala_compiler_run_output;
				_tmp197_ = vala_code_context_add_source_filename (_tmp194_, _tmp195_, _tmp196_, TRUE);
				if (_tmp197_) {
					const gchar* _tmp198_ = NULL;
					gboolean _tmp199_ = FALSE;
					_tmp198_ = source;
					_tmp199_ = g_str_has_suffix (_tmp198_, ".c");
					if (_tmp199_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp201_ = self->priv->context;
	_tmp202_ = vala_code_context_get_report (_tmp201_);
	_tmp203_ = _tmp202_;
	_tmp204_ = vala_report_get_errors (_tmp203_);
	if (_tmp204_ > 0) {
		_tmp200_ = TRUE;
	} else {
		gboolean _tmp205_ = FALSE;
		gboolean _tmp206_ = FALSE;
		gboolean _tmp211_ = FALSE;
		_tmp206_ = vala_compiler_fatal_warnings;
		if (_tmp206_) {
			ValaCodeContext* _tmp207_ = NULL;
			ValaReport* _tmp208_ = NULL;
			ValaReport* _tmp209_ = NULL;
			gint _tmp210_ = 0;
			_tmp207_ = self->priv->context;
			_tmp208_ = vala_code_context_get_report (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_report_get_warnings (_tmp209_);
			_tmp205_ = _tmp210_ > 0;
		} else {
			_tmp205_ = FALSE;
		}
		_tmp211_ = _tmp205_;
		_tmp200_ = _tmp211_;
	}
	_tmp212_ = _tmp200_;
	if (_tmp212_) {
		gint _tmp213_ = 0;
		_tmp213_ = vala_compiler_quit (self);
		result = _tmp213_;
		return result;
	}
	_tmp214_ = vala_parser_new ();
	parser = _tmp214_;
	_tmp215_ = parser;
	_tmp216_ = self->priv->context;
	vala_parser_parse (_tmp215_, _tmp216_);
	_tmp217_ = vala_genie_parser_new ();
	genie_parser = _tmp217_;
	_tmp218_ = genie_parser;
	_tmp219_ = self->priv->context;
	vala_genie_parser_parse (_tmp218_, _tmp219_);
	_tmp220_ = vala_gir_parser_new ();
	gir_parser = _tmp220_;
	_tmp221_ = gir_parser;
	_tmp222_ = self->priv->context;
	vala_gir_parser_parse (_tmp221_, _tmp222_);
	_tmp224_ = self->priv->context;
	_tmp225_ = vala_code_context_get_report (_tmp224_);
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_report_get_errors (_tmp226_);
	if (_tmp227_ > 0) {
		_tmp223_ = TRUE;
	} else {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_ = FALSE;
		gboolean _tmp234_ = FALSE;
		_tmp229_ = vala_compiler_fatal_warnings;
		if (_tmp229_) {
			ValaCodeContext* _tmp230_ = NULL;
			ValaReport* _tmp231_ = NULL;
			ValaReport* _tmp232_ = NULL;
			gint _tmp233_ = 0;
			_tmp230_ = self->priv->context;
			_tmp231_ = vala_code_context_get_report (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_report_get_warnings (_tmp232_);
			_tmp228_ = _tmp233_ > 0;
		} else {
			_tmp228_ = FALSE;
		}
		_tmp234_ = _tmp228_;
		_tmp223_ = _tmp234_;
	}
	_tmp235_ = _tmp223_;
	if (_tmp235_) {
		gint _tmp236_ = 0;
		_tmp236_ = vala_compiler_quit (self);
		result = _tmp236_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp237_ = vala_compiler_fast_vapi_filename;
	if (_tmp237_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp238_ = NULL;
		ValaCodeWriter* _tmp239_ = NULL;
		ValaCodeContext* _tmp240_ = NULL;
		const gchar* _tmp241_ = NULL;
		gint _tmp242_ = 0;
		_tmp238_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp238_;
		_tmp239_ = interface_writer;
		_tmp240_ = self->priv->context;
		_tmp241_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp239_, _tmp240_, _tmp241_);
		_tmp242_ = vala_compiler_quit (self);
		result = _tmp242_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp243_ = self->priv->context;
	vala_code_context_check (_tmp243_);
	_tmp245_ = self->priv->context;
	_tmp246_ = vala_code_context_get_report (_tmp245_);
	_tmp247_ = _tmp246_;
	_tmp248_ = vala_report_get_errors (_tmp247_);
	if (_tmp248_ > 0) {
		_tmp244_ = TRUE;
	} else {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_ = FALSE;
		gboolean _tmp255_ = FALSE;
		_tmp250_ = vala_compiler_fatal_warnings;
		if (_tmp250_) {
			ValaCodeContext* _tmp251_ = NULL;
			ValaReport* _tmp252_ = NULL;
			ValaReport* _tmp253_ = NULL;
			gint _tmp254_ = 0;
			_tmp251_ = self->priv->context;
			_tmp252_ = vala_code_context_get_report (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_report_get_warnings (_tmp253_);
			_tmp249_ = _tmp254_ > 0;
		} else {
			_tmp249_ = FALSE;
		}
		_tmp255_ = _tmp249_;
		_tmp244_ = _tmp255_;
	}
	_tmp256_ = _tmp244_;
	if (_tmp256_) {
		gint _tmp257_ = 0;
		_tmp257_ = vala_compiler_quit (self);
		result = _tmp257_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp260_ = vala_compiler_ccode_only;
	if (!_tmp260_) {
		gboolean _tmp261_ = FALSE;
		_tmp261_ = vala_compiler_compile_only;
		_tmp259_ = !_tmp261_;
	} else {
		_tmp259_ = FALSE;
	}
	_tmp262_ = _tmp259_;
	if (_tmp262_) {
		const gchar* _tmp263_ = NULL;
		_tmp263_ = vala_compiler_library;
		_tmp258_ = _tmp263_ == NULL;
	} else {
		_tmp258_ = FALSE;
	}
	_tmp264_ = _tmp258_;
	if (_tmp264_) {
		gboolean _tmp265_ = FALSE;
		gboolean _tmp266_ = FALSE;
		gboolean _tmp270_ = FALSE;
		_tmp266_ = has_c_files;
		if (!_tmp266_) {
			ValaCodeContext* _tmp267_ = NULL;
			ValaMethod* _tmp268_ = NULL;
			ValaMethod* _tmp269_ = NULL;
			_tmp267_ = self->priv->context;
			_tmp268_ = vala_code_context_get_entry_point (_tmp267_);
			_tmp269_ = _tmp268_;
			_tmp265_ = _tmp269_ == NULL;
		} else {
			_tmp265_ = FALSE;
		}
		_tmp270_ = _tmp265_;
		if (_tmp270_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp271_ = vala_compiler_dump_tree;
	if (_tmp271_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp272_ = NULL;
		ValaCodeWriter* _tmp273_ = NULL;
		ValaCodeContext* _tmp274_ = NULL;
		const gchar* _tmp275_ = NULL;
		_tmp272_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp272_;
		_tmp273_ = code_writer;
		_tmp274_ = self->priv->context;
		_tmp275_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp273_, _tmp274_, _tmp275_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp277_ = self->priv->context;
	_tmp278_ = vala_code_context_get_report (_tmp277_);
	_tmp279_ = _tmp278_;
	_tmp280_ = vala_report_get_errors (_tmp279_);
	if (_tmp280_ > 0) {
		_tmp276_ = TRUE;
	} else {
		gboolean _tmp281_ = FALSE;
		gboolean _tmp282_ = FALSE;
		gboolean _tmp287_ = FALSE;
		_tmp282_ = vala_compiler_fatal_warnings;
		if (_tmp282_) {
			ValaCodeContext* _tmp283_ = NULL;
			ValaReport* _tmp284_ = NULL;
			ValaReport* _tmp285_ = NULL;
			gint _tmp286_ = 0;
			_tmp283_ = self->priv->context;
			_tmp284_ = vala_code_context_get_report (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_report_get_warnings (_tmp285_);
			_tmp281_ = _tmp286_ > 0;
		} else {
			_tmp281_ = FALSE;
		}
		_tmp287_ = _tmp281_;
		_tmp276_ = _tmp287_;
	}
	_tmp288_ = _tmp276_;
	if (_tmp288_) {
		gint _tmp289_ = 0;
		_tmp289_ = vala_compiler_quit (self);
		result = _tmp289_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp290_ = self->priv->context;
	_tmp291_ = vala_code_context_get_codegen (_tmp290_);
	_tmp292_ = _tmp291_;
	_tmp293_ = self->priv->context;
	vala_code_generator_emit (_tmp292_, _tmp293_);
	_tmp295_ = self->priv->context;
	_tmp296_ = vala_code_context_get_report (_tmp295_);
	_tmp297_ = _tmp296_;
	_tmp298_ = vala_report_get_errors (_tmp297_);
	if (_tmp298_ > 0) {
		_tmp294_ = TRUE;
	} else {
		gboolean _tmp299_ = FALSE;
		gboolean _tmp300_ = FALSE;
		gboolean _tmp305_ = FALSE;
		_tmp300_ = vala_compiler_fatal_warnings;
		if (_tmp300_) {
			ValaCodeContext* _tmp301_ = NULL;
			ValaReport* _tmp302_ = NULL;
			ValaReport* _tmp303_ = NULL;
			gint _tmp304_ = 0;
			_tmp301_ = self->priv->context;
			_tmp302_ = vala_code_context_get_report (_tmp301_);
			_tmp303_ = _tmp302_;
			_tmp304_ = vala_report_get_warnings (_tmp303_);
			_tmp299_ = _tmp304_ > 0;
		} else {
			_tmp299_ = FALSE;
		}
		_tmp305_ = _tmp299_;
		_tmp294_ = _tmp305_;
	}
	_tmp306_ = _tmp294_;
	if (_tmp306_) {
		gint _tmp307_ = 0;
		_tmp307_ = vala_compiler_quit (self);
		result = _tmp307_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp309_ = vala_compiler_vapi_filename;
	if (_tmp309_ == NULL) {
		const gchar* _tmp310_ = NULL;
		_tmp310_ = vala_compiler_library;
		_tmp308_ = _tmp310_ != NULL;
	} else {
		_tmp308_ = FALSE;
	}
	_tmp311_ = _tmp308_;
	if (_tmp311_) {
		const gchar* _tmp312_ = NULL;
		gchar* _tmp313_ = NULL;
		_tmp312_ = vala_compiler_library;
		_tmp313_ = g_strdup_printf ("%s.vapi", _tmp312_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp313_;
	}
	_tmp314_ = vala_compiler_library;
	if (_tmp314_ != NULL) {
		const gchar* _tmp315_ = NULL;
		_tmp315_ = vala_compiler_gir;
		if (_tmp315_ != NULL) {
			glong gir_len = 0L;
			const gchar* _tmp316_ = NULL;
			gint _tmp317_ = 0;
			gint _tmp318_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp319_ = NULL;
			gint _tmp320_ = 0;
			gboolean _tmp321_ = FALSE;
			gint _tmp322_ = 0;
			gboolean _tmp325_ = FALSE;
			_tmp316_ = vala_compiler_gir;
			_tmp317_ = strlen (_tmp316_);
			_tmp318_ = _tmp317_;
			gir_len = (glong) _tmp318_;
			_tmp319_ = vala_compiler_gir;
			_tmp320_ = string_last_index_of_char (_tmp319_, (gunichar) '-', 0);
			last_hyphen = _tmp320_;
			_tmp322_ = last_hyphen;
			if (_tmp322_ == (-1)) {
				_tmp321_ = TRUE;
			} else {
				const gchar* _tmp323_ = NULL;
				gboolean _tmp324_ = FALSE;
				_tmp323_ = vala_compiler_gir;
				_tmp324_ = g_str_has_suffix (_tmp323_, ".gir");
				_tmp321_ = !_tmp324_;
			}
			_tmp325_ = _tmp321_;
			if (_tmp325_) {
				const gchar* _tmp326_ = NULL;
				gchar* _tmp327_ = NULL;
				gchar* _tmp328_ = NULL;
				_tmp326_ = vala_compiler_gir;
				_tmp327_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp326_);
				_tmp328_ = _tmp327_;
				vala_report_error (NULL, _tmp328_);
				_g_free0 (_tmp328_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp329_ = NULL;
				gint _tmp330_ = 0;
				gchar* _tmp331_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp332_ = NULL;
				gint _tmp333_ = 0;
				glong _tmp334_ = 0L;
				gint _tmp335_ = 0;
				gchar* _tmp336_ = NULL;
				const gchar* _tmp337_ = NULL;
				gboolean _tmp338_ = FALSE;
				gboolean _tmp339_ = FALSE;
				gboolean _tmp340_ = FALSE;
				const gchar* _tmp341_ = NULL;
				gboolean _tmp343_ = FALSE;
				gboolean _tmp347_ = FALSE;
				gboolean _tmp350_ = FALSE;
				_tmp329_ = vala_compiler_gir;
				_tmp330_ = last_hyphen;
				_tmp331_ = string_substring (_tmp329_, (glong) 0, (glong) _tmp330_);
				gir_namespace = _tmp331_;
				_tmp332_ = vala_compiler_gir;
				_tmp333_ = last_hyphen;
				_tmp334_ = gir_len;
				_tmp335_ = last_hyphen;
				_tmp336_ = string_substring (_tmp332_, (glong) (_tmp333_ + 1), (_tmp334_ - _tmp335_) - 5);
				gir_version = _tmp336_;
				_tmp337_ = gir_version;
				g_strcanon (_tmp337_, "0123456789.", '?');
				_tmp341_ = gir_namespace;
				if (g_strcmp0 (_tmp341_, "") == 0) {
					_tmp340_ = TRUE;
				} else {
					const gchar* _tmp342_ = NULL;
					_tmp342_ = gir_version;
					_tmp340_ = g_strcmp0 (_tmp342_, "") == 0;
				}
				_tmp343_ = _tmp340_;
				if (_tmp343_) {
					_tmp339_ = TRUE;
				} else {
					const gchar* _tmp344_ = NULL;
					gchar _tmp345_ = '\0';
					gboolean _tmp346_ = FALSE;
					_tmp344_ = gir_version;
					_tmp345_ = string_get (_tmp344_, (glong) 0);
					_tmp346_ = g_ascii_isdigit (_tmp345_);
					_tmp339_ = !_tmp346_;
				}
				_tmp347_ = _tmp339_;
				if (_tmp347_) {
					_tmp338_ = TRUE;
				} else {
					const gchar* _tmp348_ = NULL;
					gboolean _tmp349_ = FALSE;
					_tmp348_ = gir_version;
					_tmp349_ = string_contains (_tmp348_, "?");
					_tmp338_ = _tmp349_;
				}
				_tmp350_ = _tmp338_;
				if (_tmp350_) {
					const gchar* _tmp351_ = NULL;
					gchar* _tmp352_ = NULL;
					gchar* _tmp353_ = NULL;
					_tmp351_ = vala_compiler_gir;
					_tmp352_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp351_);
					_tmp353_ = _tmp352_;
					vala_report_error (NULL, _tmp353_);
					_g_free0 (_tmp353_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp354_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp355_ = NULL;
					const gchar* _tmp356_ = NULL;
					ValaGIRWriter* _tmp361_ = NULL;
					ValaCodeContext* _tmp362_ = NULL;
					const gchar* _tmp363_ = NULL;
					const gchar* _tmp364_ = NULL;
					const gchar* _tmp365_ = NULL;
					const gchar* _tmp366_ = NULL;
					_tmp354_ = vala_gir_writer_new ();
					gir_writer = _tmp354_;
					_tmp355_ = g_strdup (".");
					gir_directory = _tmp355_;
					_tmp356_ = vala_compiler_directory;
					if (_tmp356_ != NULL) {
						ValaCodeContext* _tmp357_ = NULL;
						const gchar* _tmp358_ = NULL;
						const gchar* _tmp359_ = NULL;
						gchar* _tmp360_ = NULL;
						_tmp357_ = self->priv->context;
						_tmp358_ = vala_code_context_get_directory (_tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = g_strdup (_tmp359_);
						_g_free0 (gir_directory);
						gir_directory = _tmp360_;
					}
					_tmp361_ = gir_writer;
					_tmp362_ = self->priv->context;
					_tmp363_ = gir_directory;
					_tmp364_ = gir_namespace;
					_tmp365_ = gir_version;
					_tmp366_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp361_, _tmp362_, _tmp363_, _tmp364_, _tmp365_, _tmp366_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp367_ = vala_compiler_vapi_filename;
	if (_tmp367_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp368_ = NULL;
		gboolean _tmp369_ = FALSE;
		const gchar* _tmp370_ = NULL;
		gboolean _tmp373_ = FALSE;
		ValaCodeWriter* _tmp379_ = NULL;
		ValaCodeContext* _tmp380_ = NULL;
		const gchar* _tmp381_ = NULL;
		_tmp368_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp368_;
		_tmp370_ = vala_compiler_directory;
		if (_tmp370_ != NULL) {
			const gchar* _tmp371_ = NULL;
			gboolean _tmp372_ = FALSE;
			_tmp371_ = vala_compiler_vapi_filename;
			_tmp372_ = g_path_is_absolute (_tmp371_);
			_tmp369_ = !_tmp372_;
		} else {
			_tmp369_ = FALSE;
		}
		_tmp373_ = _tmp369_;
		if (_tmp373_) {
			ValaCodeContext* _tmp374_ = NULL;
			const gchar* _tmp375_ = NULL;
			const gchar* _tmp376_ = NULL;
			const gchar* _tmp377_ = NULL;
			gchar* _tmp378_ = NULL;
			_tmp374_ = self->priv->context;
			_tmp375_ = vala_code_context_get_directory (_tmp374_);
			_tmp376_ = _tmp375_;
			_tmp377_ = vala_compiler_vapi_filename;
			_tmp378_ = g_strdup_printf ("%s%c%s", _tmp376_, (gint) G_DIR_SEPARATOR, _tmp377_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp378_;
		}
		_tmp379_ = interface_writer;
		_tmp380_ = self->priv->context;
		_tmp381_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp379_, _tmp380_, _tmp381_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp382_ = vala_compiler_internal_vapi_filename;
	if (_tmp382_ != NULL) {
		gboolean _tmp383_ = FALSE;
		const gchar* _tmp384_ = NULL;
		gboolean _tmp386_ = FALSE;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp388_ = NULL;
		ValaCodeWriter* _tmp389_ = NULL;
		const gchar* _tmp390_ = NULL;
		const gchar* _tmp391_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp392_ = NULL;
		gchar* _tmp393_ = NULL;
		gboolean _tmp394_ = FALSE;
		const gchar* _tmp395_ = NULL;
		gboolean _tmp398_ = FALSE;
		ValaCodeWriter* _tmp404_ = NULL;
		ValaCodeContext* _tmp405_ = NULL;
		const gchar* _tmp406_ = NULL;
		_tmp384_ = vala_compiler_internal_header_filename;
		if (_tmp384_ == NULL) {
			_tmp383_ = TRUE;
		} else {
			const gchar* _tmp385_ = NULL;
			_tmp385_ = vala_compiler_header_filename;
			_tmp383_ = _tmp385_ == NULL;
		}
		_tmp386_ = _tmp383_;
		if (_tmp386_) {
			gint _tmp387_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp387_ = vala_compiler_quit (self);
			result = _tmp387_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp388_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp388_;
		_tmp389_ = interface_writer;
		_tmp390_ = vala_compiler_header_filename;
		_tmp391_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp389_, _tmp390_, _tmp391_);
		_tmp392_ = vala_compiler_internal_vapi_filename;
		_tmp393_ = g_strdup (_tmp392_);
		vapi_filename = _tmp393_;
		_tmp395_ = vala_compiler_directory;
		if (_tmp395_ != NULL) {
			const gchar* _tmp396_ = NULL;
			gboolean _tmp397_ = FALSE;
			_tmp396_ = vapi_filename;
			_tmp397_ = g_path_is_absolute (_tmp396_);
			_tmp394_ = !_tmp397_;
		} else {
			_tmp394_ = FALSE;
		}
		_tmp398_ = _tmp394_;
		if (_tmp398_) {
			ValaCodeContext* _tmp399_ = NULL;
			const gchar* _tmp400_ = NULL;
			const gchar* _tmp401_ = NULL;
			const gchar* _tmp402_ = NULL;
			gchar* _tmp403_ = NULL;
			_tmp399_ = self->priv->context;
			_tmp400_ = vala_code_context_get_directory (_tmp399_);
			_tmp401_ = _tmp400_;
			_tmp402_ = vapi_filename;
			_tmp403_ = g_strdup_printf ("%s%c%s", _tmp401_, (gint) G_DIR_SEPARATOR, _tmp402_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp403_;
		}
		_tmp404_ = interface_writer;
		_tmp405_ = self->priv->context;
		_tmp406_ = vapi_filename;
		vala_code_writer_write_file (_tmp404_, _tmp405_, _tmp406_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp407_ = vala_compiler_dependencies;
	if (_tmp407_ != NULL) {
		ValaCodeContext* _tmp408_ = NULL;
		const gchar* _tmp409_ = NULL;
		_tmp408_ = self->priv->context;
		_tmp409_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp408_, _tmp409_);
	}
	_tmp410_ = vala_compiler_ccode_only;
	if (!_tmp410_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp411_ = NULL;
		gboolean _tmp412_ = FALSE;
		const gchar* _tmp413_ = NULL;
		gboolean _tmp415_ = FALSE;
		gchar** _tmp418_ = NULL;
		gint _tmp418__length1 = 0;
		_tmp411_ = vala_ccode_compiler_new ();
		ccompiler = _tmp411_;
		_tmp413_ = vala_compiler_cc_command;
		if (_tmp413_ == NULL) {
			const gchar* _tmp414_ = NULL;
			_tmp414_ = g_getenv ("CC");
			_tmp412_ = _tmp414_ != NULL;
		} else {
			_tmp412_ = FALSE;
		}
		_tmp415_ = _tmp412_;
		if (_tmp415_) {
			const gchar* _tmp416_ = NULL;
			gchar* _tmp417_ = NULL;
			_tmp416_ = g_getenv ("CC");
			_tmp417_ = g_strdup (_tmp416_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp417_;
		}
		_tmp418_ = vala_compiler_cc_options;
		_tmp418__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp418_ == NULL) {
			ValaCCodeCompiler* _tmp419_ = NULL;
			ValaCodeContext* _tmp420_ = NULL;
			const gchar* _tmp421_ = NULL;
			gchar** _tmp422_ = NULL;
			gchar** _tmp423_ = NULL;
			gint _tmp423__length1 = 0;
			_tmp419_ = ccompiler;
			_tmp420_ = self->priv->context;
			_tmp421_ = vala_compiler_cc_command;
			_tmp422_ = g_new0 (gchar*, 0 + 1);
			_tmp423_ = _tmp422_;
			_tmp423__length1 = 0;
			vala_ccode_compiler_compile (_tmp419_, _tmp420_, _tmp421_, _tmp423_, 0);
			_tmp423_ = (_vala_array_free (_tmp423_, _tmp423__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp424_ = NULL;
			ValaCodeContext* _tmp425_ = NULL;
			const gchar* _tmp426_ = NULL;
			gchar** _tmp427_ = NULL;
			gint _tmp427__length1 = 0;
			_tmp424_ = ccompiler;
			_tmp425_ = self->priv->context;
			_tmp426_ = vala_compiler_cc_command;
			_tmp427_ = vala_compiler_cc_options;
			_tmp427__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp424_, _tmp425_, _tmp426_, _tmp427_, _tmp427__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp428_ = vala_compiler_quit (self);
	result = _tmp428_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda2_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint _tmp37_ = 0;
	const gchar* _tmp38_ = NULL;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	gint _tmp41_ = 0;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar** _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	gint _tmp46__length1 = 0;
	gint _tmp47_ = 0;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp55_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar** _tmp65_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		gint _tmp29_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar** _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			GOptionContext* _tmp17_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp19_ = NULL;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = g_strconcat ("valac ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			g_shell_parse_argv (_tmp12_, &_tmp14_, &_tmp13_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp13_;
			compile_args_length1 = _tmp14_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp12_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp20_ = NULL;
			GError* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			fprintf (_tmp20_, "%s\n", _tmp22_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp23_ = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			FILE* _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			const gchar* _tmp28_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = stdout;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			fprintf (_tmp23_, "%s\n", _tmp25_);
			_tmp26_ = stdout;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = _tmp27_[0];
			fprintf (_tmp26_, "Run '%s --help' to see a full list of available command line options.\n", _tmp28_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp29_ = i;
		i = _tmp29_ + 1;
	}
	_tmp30_ = vala_compiler_version;
	if (_tmp30_) {
		FILE* _tmp31_ = NULL;
		_tmp31_ = stdout;
		fprintf (_tmp31_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp32_ = FALSE;
		_tmp32_ = vala_compiler_api_version;
		if (_tmp32_) {
			FILE* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp33_ = stdout;
			_tmp34_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp35_ = _tmp34_;
			fprintf (_tmp33_, "%s\n", _tmp35_);
			_g_free0 (_tmp35_);
			result = 0;
			return result;
		}
	}
	_tmp36_ = args;
	_tmp36__length1 = args_length1;
	_tmp37_ = i;
	_tmp38_ = _tmp36_[_tmp37_];
	if (_tmp38_ == NULL) {
		FILE* _tmp39_ = NULL;
		_tmp39_ = stderr;
		fprintf (_tmp39_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_strdup (_tmp42_);
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp44_;
	_tmp45_ = g_get_tmp_dir ();
	_tmp46_ = args;
	_tmp46__length1 = args_length1;
	_tmp47_ = i;
	_tmp48_ = _tmp46_[_tmp47_];
	_tmp49_ = g_path_get_basename (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp45_, _tmp50_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp51_;
	_g_free0 (_tmp50_);
	_tmp52_ = vala_compiler_output;
	_tmp53_ = g_mkstemp (_tmp52_);
	outputfd = _tmp53_;
	_tmp54_ = outputfd;
	if (_tmp54_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp55_ = vala_compiler_new ();
	compiler = _tmp55_;
	_tmp56_ = compiler;
	_tmp57_ = vala_compiler_run (_tmp56_);
	ret = _tmp57_;
	_tmp58_ = ret;
	if (_tmp58_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp59_ = outputfd;
	close (_tmp59_);
	_tmp60_ = vala_compiler_output;
	_tmp61_ = g_chmod (_tmp60_, 0700);
	if (_tmp61_ != 0) {
		const gchar* _tmp62_ = NULL;
		_tmp62_ = vala_compiler_output;
		g_unlink (_tmp62_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp63_ = vala_compiler_output;
	_tmp64_ = g_strdup (_tmp63_);
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	target_args = _tmp65_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp66_ = 0;
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gchar** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		gint _tmp70_ = 0;
		const gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		_tmp66_ = i;
		_tmp67_ = args;
		_tmp67__length1 = args_length1;
		if (!(_tmp66_ < _tmp67__length1)) {
			break;
		}
		_tmp68_ = target_args;
		_tmp68__length1 = target_args_length1;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		_tmp70_ = i;
		_tmp71_ = _tmp69_[_tmp70_];
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp72_);
		_tmp73_ = i;
		i = _tmp73_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp74_ = NULL;
		gchar** _tmp75_ = NULL;
		gint _tmp75__length1 = 0;
		GPid _tmp76_ = 0;
		const gchar* _tmp77_ = NULL;
		GPid _tmp78_ = 0;
		GMainLoop* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp74_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp74_;
		_data1_->child_status = 0;
		_tmp75_ = target_args;
		_tmp75__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp75_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp76_, &_inner_error_);
		pid = _tmp76_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp77_ = vala_compiler_output;
		g_unlink (_tmp77_);
		_tmp78_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp78_, ____lambda2__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp79_ = _data1_->loop;
		g_main_loop_run (_tmp79_);
		_tmp80_ = _data1_->child_status;
		result = _tmp80_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp81_ = NULL;
		GError* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp81_ = stdout;
		_tmp82_ = e;
		_tmp83_ = _tmp82_->message;
		fprintf (_tmp81_, "%s\n", _tmp83_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	gboolean _tmp32_ = FALSE;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp34_ = NULL;
	ValaCompiler* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp12_ = 0;
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = vala_compiler_run_source (_tmp11_, _tmp11__length1);
		result = _tmp12_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		GOptionContext* _tmp16_ = NULL;
		_tmp13_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp13_;
		_tmp14_ = opt_context;
		g_option_context_set_help_enabled (_tmp14_, TRUE);
		_tmp15_ = opt_context;
		g_option_context_add_main_entries (_tmp15_, VALA_COMPILER_options, NULL);
		_tmp16_ = opt_context;
		g_option_context_parse (_tmp16_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp23_ = vala_compiler_version;
	if (_tmp23_) {
		FILE* _tmp24_ = NULL;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp25_ = FALSE;
		_tmp25_ = vala_compiler_api_version;
		if (_tmp25_) {
			FILE* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp26_ = stdout;
			_tmp27_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp28_ = _tmp27_;
			fprintf (_tmp26_, "%s\n", _tmp28_);
			_g_free0 (_tmp28_);
			result = 0;
			return result;
		}
	}
	_tmp30_ = vala_compiler_sources;
	_tmp30__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp30_ == NULL) {
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		_tmp31_ = vala_compiler_fast_vapis;
		_tmp31__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp29_ = _tmp31_ == NULL;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp32_ = _tmp29_;
	if (_tmp32_) {
		FILE* _tmp33_ = NULL;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = vala_compiler_new ();
	compiler = _tmp34_;
	_tmp35_ = compiler;
	_tmp36_ = vala_compiler_run (_tmp35_);
	result = _tmp36_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



