/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.FileDiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vhd.DynamicVHD;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.StreamOptimizedVMDK;
import java.io.File;

public class ImageChecker {
    protected final DiskImage blockDevice;
    protected static final String FORMAT_VMDK = "VMDK";
    protected static final String FORMAT_VHD = "VHD";
    protected static final String FORMAT_RAW = "RAW";
    protected static final String INFO_WRAPPER_OPEN = "{";
    protected static final String INFO_WRAPPER_CLOSE = "}";
    protected static final String INFO_MBR = "M";
    protected static final String INFO_BOOTABLE = "B";
    protected static final String INFO_PARTITION_TYPE = "T";
    protected static final int MBR_SIZE_BYTES = 512;
    protected static final int MBR_OFFSET = 0;
    protected static final int MBR_SIGNATURE_OFFSET1 = 510;
    protected static final int MBR_SIGNATURE_OFFSET2 = 511;
    protected static final byte MBR_SIGNATURE_OFFSET1_EXPECTED_VAL = 85;
    protected static final byte MBR_SIGNATURE_OFFSET2_EXPECTED_VAL = -86;
    protected static final int[] MBR_PARTITION_OFFSETS = new int[]{446, 462, 478, 494};
    protected static final int PARTITION_TYPE_OFFSET = 4;
    protected static final byte PARTITION_BOOTABLE = -128;

    public ImageChecker(DiskImage blockDevice) {
        this.blockDevice = blockDevice;
    }

    public ImageChecker(File imageFile, String format, long expectedImageFileSize) throws ImageVerificationException {
        FileDiskImage image = new FileDiskImage(imageFile);
        if (expectedImageFileSize != image.size()) {
            throw new ImageVerificationException("The file size is " + image.size() + ". The expected file size for this task is " + expectedImageFileSize);
        }
        this.blockDevice = this.getBlockDeviceOfFormat(image, format);
    }

    public ImageChecker(File imageFile, String format) throws ImageVerificationException {
        FileDiskImage image = new FileDiskImage(imageFile);
        this.blockDevice = this.getBlockDeviceOfFormat(image, format);
    }

    protected DiskImage getBlockDeviceOfFormat(FileDiskImage image, String format) throws ImageVerificationException {
        if (FORMAT_VMDK.equals(format = format.toUpperCase())) {
            return new StreamOptimizedVMDK(image);
        }
        if (FORMAT_VHD.equals(format)) {
            return new DynamicVHD(image);
        }
        if (FORMAT_RAW.equals(format)) {
            return image;
        }
        throw new ImageVerificationException(format + " is unsupported format.");
    }

    public long getBlockDeviceSize() {
        return this.blockDevice.size();
    }

    public String getImageInfoString() throws ImageVerificationException {
        String imageInfo = "";
        byte[] mbr = this.readMBR();
        if (this.checkMBRSignature(mbr)) {
            int bootableCount = this.countBootablePartition(mbr);
            int bootableType = this.getBootablePartitionType(mbr);
            imageInfo = imageInfo + this.formImageInfo(INFO_BOOTABLE, bootableCount);
            imageInfo = imageInfo + this.formImageInfo(INFO_PARTITION_TYPE, bootableType);
        } else {
            imageInfo = imageInfo + this.formImageInfo(INFO_MBR, 0);
        }
        return INFO_WRAPPER_OPEN + imageInfo + INFO_WRAPPER_CLOSE;
    }

    protected String formImageInfo(String key, int value) {
        String val_hex = Integer.toHexString(value).toUpperCase();
        return key + INFO_WRAPPER_OPEN + val_hex + INFO_WRAPPER_CLOSE;
    }

    protected byte[] readMBR() throws ImageVerificationException {
        byte[] mbr = this.blockDevice.read(0L, 512);
        return mbr;
    }

    protected boolean checkMBRSignature(byte[] mbr) {
        return mbr[510] == 85 && mbr[511] == -86;
    }

    protected int countBootablePartition(byte[] mbr) {
        int bootableCount = 0;
        for (int partition : MBR_PARTITION_OFFSETS) {
            if (mbr[partition] != -128) continue;
            ++bootableCount;
        }
        return bootableCount;
    }

    protected int getBootablePartitionType(byte[] mbr) {
        for (int partition : MBR_PARTITION_OFFSETS) {
            if (mbr[partition] != -128) continue;
            return DiskImage.getUnsignedByte(mbr[partition + 4]);
        }
        return 0;
    }
}

