/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GPSInfoIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GeoTiffStrings;
import edu.harvard.hul.ois.jhove.module.tiff.GlobalParametersIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.InteroperabilityIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TiffIFD
extends IFD {
    public static final int NEWSUBFILETYPE = 254;
    public static final int SUBFILETYPE = 255;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELLWIDTH = 264;
    public static final int CELLLENGTH = 265;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int MINSAMPLEVALUE = 280;
    public static final int MAXSAMPLEVALUE = 281;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int PAGENAME = 285;
    public static final int XPOSITION = 286;
    public static final int YPOSITION = 287;
    public static final int FREEOFFSETS = 288;
    public static final int FREEBYTECOUNTS = 289;
    public static final int GRAYRESPONSEUNIT = 290;
    public static final int GRAYRESPONSECURVE = 291;
    public static final int T4OPTIONS = 292;
    public static final int T6OPTIONS = 293;
    public static final int RESOLUTIONUNIT = 296;
    public static final int PAGENUMBER = 297;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int HOSTCOMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int COLORMAP = 320;
    public static final int HALFTONEHINTS = 321;
    public static final int TILEWIDTH = 322;
    public static final int TILELENGTH = 323;
    public static final int TILEOFFSETS = 324;
    public static final int TILEBYTECOUNTS = 325;
    public static final int INKSET = 332;
    public static final int INKNAMES = 333;
    public static final int NUMBEROFINKS = 334;
    public static final int DOTRANGE = 336;
    public static final int TARGETPRINTER = 337;
    public static final int EXTRASAMPLES = 338;
    public static final int SAMPLEFORMAT = 339;
    public static final int SMINSAMPLEVALUE = 340;
    public static final int SMAXSAMPLEVALUE = 341;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int JPEGRESTARTINTERVAL = 515;
    public static final int JPEGLOSSLESSPREDICTORS = 517;
    public static final int JPEGPOINTTRANSFORMS = 518;
    public static final int JPEGQTABLES = 519;
    public static final int JPEGDCTABLES = 520;
    public static final int JPEGACTABLES = 521;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int COPYRIGHT = 33432;
    private static final String[] FILLORDER_L = new String[]{"", "high-order", "low-order"};
    private static final String[] INDEXED_L = new String[]{"not indexed", "indexed"};
    private static final String[] INKSET_L = new String[]{"", "CMYK", "not CMYK"};
    private static final String[] JPEGLOSSLESSPREDICTORS_L = new String[]{"", "A", "B", "C", "A+B+C", "A+((B-C)/2)", "B+((A-C)/2)", "(A+B)/2"};
    private static final String[] JPEGPROC_L = new String[]{"baseline sequential process", "lossless process with Huffman coding"};
    private static final int[] JPEGPROC_INDEX = new int[]{1, 14};
    private static final String[] NEWSUBFILETYPE_L = new String[]{"reduced-resolution image of another image in this file", "single page of multi-page image", "transparency mask for another image in this file"};
    private static final String[] OPIPROXY_L = new String[]{"no higher-resolution version exists", "higher-resolution version exists"};
    private static final String[] PREDICTOR_L = new String[]{"", "no prediction scheme", "horizontal differencing"};
    private static final String[] SAMPLEFORMAT_L = new String[]{"", "unsigned integer", "signed integer", "IEEE floating point", "undefined"};
    private static final String[] SUBFILETYPE_L = new String[]{"", "full-resolution image", "reduced-resolution image", "single page of multi-page image"};
    private static final String[] THRESHHOLDING_L = new String[]{"", "no dithering or halftoning", "ordered dithering or halftoning", "randomized process"};
    private static final String[] YCBCRPOSITIONING_L = new String[]{"", "centered", "cosited"};
    private static final String[] YCBCRSUBSAMPLING_HORZ = new String[]{"", "width of chroma image is equal to width of associated luma image", "width of chroma image is 1/2 the width of associated luma image", "", "width of chroma image is 1/4 the width of associated luma image"};
    private static final String[] YCBCRSUBSAMPLING_VERT = new String[]{"", "length of chroma image is equal to length of associated luma image", "length of chroma image is 1/2 the length of associated luma image", "", "length of chroma image is 1/4 the length of associated luma image"};
    private static final int SITE = 34016;
    private static final int COLORSEQUENCE = 34017;
    private static final int IT8HEADER = 34018;
    private static final int RASTERPADDING = 34019;
    private static final int BITSPERRUNLENGTH = 34020;
    private static final int BITSPEREXTENDEDRUNLENGTH = 34021;
    private static final int COLORTABLE = 34022;
    private static final int IMAGECOLORINDICATOR = 34023;
    private static final int BACKGROUNDCOLORINDICATOR = 34024;
    private static final int IMAGECOLORVALUE = 34025;
    private static final int BACKGROUNDCOLORVALUE = 34026;
    private static final int PIXELINTENSITYRANGE = 34027;
    private static final int TRANSPARENCYINDICATOR = 34028;
    private static final int COLORCHARACTERIZATION = 34029;
    private static final int HCUSAGE = 34030;
    public static final String[] BACKGROUNDCOLORINDICATOR_L = new String[]{"background not defined", "Background color defined", "full transparency, background color not defined"};
    public static final String[] HCUSAGE_L = new String[]{"high resolution CT contone information", "line art (line work) information", "trapping information"};
    public static final String[] IMAGECOLORINDICATOR_L = new String[]{"image not defined", "image color defined", "full transparency, image color not defined"};
    private static final String[] RASTERPADDING_L = new String[]{"1 byte", "2 bytes", "4 bytes", "512 bytes", "1024 bytes"};
    private static final int[] RASTERPADDING_INDEX = new int[]{0, 1, 2, 9, 10};
    public static final String[] TRANSPARENCYINDICATOR_L = new String[]{"no transparency", "transparency used"};
    private static final int CFAREPEATPATTERNDIM = 33421;
    private static final int CFAPATTERN = 33422;
    private static final int BATTERYLEVEL = 33423;
    private static final int EXPOSURETIME = 33434;
    private static final int FNUMBER = 33437;
    private static final int IPTCNAA = 33723;
    private static final int ICC_PROFILE = 34675;
    private static final int EXPOSUREPROGRAM = 34850;
    private static final int SPECTRALSENSITIVITY = 34852;
    private static final int ISOSPEEDRATINGS = 34855;
    private static final int OECF = 34856;
    private static final int INTERLACE = 34857;
    private static final int TIMEZONEOFFSET = 34858;
    private static final int SELFTIMERMODE = 34859;
    private static final int DATETIMEORIGINAL = 36867;
    private static final int COMPRESSEDBITSPERPIXEL = 37122;
    private static final int SHUTTERSPEEDVALUE = 37377;
    private static final int APERTUREVALUE = 37378;
    private static final int BRIGHTNESSVALUE = 37379;
    private static final int EXPOSUREBIASVALUE = 37380;
    private static final int MAXAPERTUREVALUE = 37381;
    private static final int SUBJECTDISTANCE = 37382;
    private static final int METERINGMODE = 37383;
    private static final int LIGHTSOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCALLENGTH = 37386;
    private static final int FLASHENERGY = 37387;
    private static final int SPATIALFREQUENCYRESPONSE = 37388;
    private static final int NOISE = 37389;
    private static final int FOCALPLANEXRESOLUTION = 37390;
    private static final int FOCALPLANEYRESOLUTION = 37391;
    private static final int FOCALPLANERESOLUTIONUNIT = 37392;
    private static final int IMAGENUMBER = 37393;
    private static final int SECURITYCLASSIFICATION = 37394;
    private static final int IMAGEHISTORY = 37395;
    private static final int SUBJECTLOCATION = 37396;
    private static final int EXPOSUREINDEX = 37397;
    private static final int TIFFEPSTANDARDID = 37398;
    private static final int SENSINGMETHOD = 37399;
    private static final String[] EXPOSUREPROGRAM_L = new String[]{"unidentified", "manual", "program normal", "aperature priority", "shutter priority", "program creative", "program action", "portrait mode", "landscape mode"};
    private static final String[] FLASH_L = new String[]{"did not fire", "fired", "fired, return not sensed", "fired, return sensed", "fired, fill flash mode, camera has no flash return sensing capability", "fired, fill flash mode, return not sensed", "fired, fill flash mode, return sensed", "did not fire, flash 'off' mode", "did not fire, 'auto' mode", "fired, 'auto' mode, camera has no flash return sensing capability", "fired, 'auto' mode, return not sensed", "fired, 'auto' mode, return sensed", "camera does not have a flash unit"};
    private static final int[] FLASH_INDEX = new int[]{0, 1, 5, 7, 9, 13, 15, 16, 24, 25, 29, 31, 32};
    private static final String[] FOCALPLANERESOLUTIONUNIT_L = new String[]{"", "inch", "metre", "centimetre", "millimetre", "micrometre"};
    private static final int EXIFIFD = 34665;
    private static final int GPSINFOIFD = 34853;
    private static final int INTEROPERABILITYIFD = 40965;
    private static final int GEOKEYDIRECTORYTAG = 34735;
    private static final int GEODOUBLEPARAMSTAG = 34736;
    private static final int GEOASCIIPARAMSTAG = 34737;
    private static final int MODELTIEPOINTTAG = 33922;
    private static final int MODELPIXELSCALETAG = 33550;
    private static final int MODELTRANSFORMATIONTAG = 34264;
    public static final int GTMODELTYPEGEOKEY = 1024;
    public static final int GTRASTERTYPEGEOKEY = 1025;
    public static final int GTCITATIONGEOKEY = 1026;
    public static final int GEOGRAPHICTYPEGEOKEY = 2048;
    public static final int GEOGCITATIONGEOKEY = 2049;
    public static final int GEOGGEODETICDATUMGEOKEY = 2050;
    public static final int GEOGPRIMEMERIDIANGEOKEY = 2051;
    public static final int GEOGLINEARUNITSGEOKEY = 2052;
    public static final int GEOGLINEARUNITSIZEGEOKEY = 2053;
    public static final int GEOGANGULARUNITSGEOKEY = 2054;
    public static final int GEOGANGULARUNITSIZEGEOKEY = 2055;
    public static final int GEOGELLIPSOIDGEOKEY = 2056;
    public static final int GEOGSEMIMAJORAXISGEOKEY = 2057;
    public static final int GEOGSEMIMINORAXISGEOKEY = 2058;
    public static final int GEOGINVFLATTENINGGEOKEY = 2059;
    public static final int GEOGAZIMUTHUNITSGEOKEY = 2060;
    public static final int GEOGPRIMEMERIDIANLONGGEOKEY = 2061;
    public static final int PROJECTEDCSTYPEGEOKEY = 3072;
    public static final int PCSCITATIONGEOKEY = 3073;
    public static final int PROJECTIONGEOKEY = 3074;
    public static final int PROJCOORDTRANSGEOKEY = 3075;
    public static final int PROJLINEARUNITSGEOKEY = 3076;
    public static final int PROJLINEARUNITSIZEGEOKEY = 3077;
    public static final int PROJSTDPARALLEL1GEOKEY = 3078;
    public static final int PROJSTDPARALLEL2GEOKEY = 3079;
    public static final int PROJNATORIGINLONGGEOKEY = 3080;
    public static final int PROJNATORIGINLATGEOKEY = 3081;
    public static final int PROJFALSEEASTINGGEOKEY = 3082;
    public static final int PROJFALSENORTHINGGEOKEY = 3083;
    public static final int PROJFALSEORIGINLONGGEOKEY = 3084;
    public static final int PROJFALSEORIGINLATGEOKEY = 3085;
    public static final int PROJFALSEORIGINEASTINGGEOKEY = 3086;
    public static final int PROJFALSEORIGINNORTHINGGEOKEY = 3087;
    public static final int PROJCENTERLONGGEOKEY = 3088;
    public static final int PROJCENTERLATGEOKEY = 3089;
    public static final int PROJCENTEREASTINGGEOKEY = 3090;
    public static final int PROJFALSEORIGINNORTHINGGEOKEY_2 = 3091;
    public static final int PROJSCALEATNATORIGINGEOKEY = 3092;
    public static final int PROJSCALEATCENTERGEOKEY = 3093;
    public static final int PROJAZIMUTHANGLEGEOKEY = 3094;
    public static final int PROJSTRAIGHTVERTPOLELONGEOKEY = 3095;
    public static final int VERTICALCSTYPEGEOKEY = 4096;
    public static final int VERTICALCITATIONGEOKEY = 4097;
    public static final int VERTICALDATUMGEOKEY = 4098;
    public static final int VERTICALUNITSGEOKEY = 4099;
    private static final int SUBIFDS = 330;
    private static final int CLIPPATH = 343;
    private static final int XCLIPPATHUNITS = 344;
    private static final int YCLIPPATHUNITS = 345;
    private static final int INDEXED = 346;
    private static final int OPIPROXY = 351;
    private static final int IMAGEID = 32781;
    private static final int JPEGTABLES = 347;
    private static final int IMAGESOURCEDATA = 37724;
    private static final int PHOTOSHOPPROPS = 34377;
    private static final int ANNOTATIONS = 50255;
    private static final int BADFAXLINES = 326;
    private static final int CLEANFAXDATA = 327;
    private static final int CONSECUTIVEBADFAXLINES = 328;
    private static final int XMP = 700;
    private static final int GLOBALPARAMETERSIFD = 400;
    private static final int STRIPROWCOUNTS = 559;
    private static final int IMAGELAYER = 34732;
    public static final String[] IMAGELAYER_L = new String[]{"", "Background", "Mask", "Foreground"};
    private static final int DNGVERSION = 50706;
    private static final int DNGBACKWARDVERSION = 50707;
    private static final int UNIQUECAMERAMODEL = 50708;
    private static final int LOCALIZEDCAMERAMODEL = 50709;
    private static final int CFAPLANECOLOR = 50710;
    private static final int CFALAYOUT = 50711;
    private static final int LINEARIZATIONTABLE = 50712;
    private static final int BLACKLEVELREPEATDIM = 50713;
    private static final int BLACKLEVEL = 50714;
    private static final int BLACKLEVELDELTAH = 50715;
    private static final int BLACKLEVELDELTAV = 50716;
    private static final int WHITELEVEL = 50717;
    private static final int DEFAULTSCALE = 50718;
    private static final int DEFAULTCROPORIGIN = 50719;
    private static final int DEFAULTCROPSIZE = 50720;
    private static final int COLORMATRIX1 = 50721;
    private static final int COLORMATRIX2 = 50722;
    private static final int CAMERACALIBRATION1 = 50723;
    private static final int CAMERACALIBRATION2 = 50724;
    private static final int REDUCTIONMATRIX1 = 50725;
    private static final int REDUCTIONMATRIX2 = 50726;
    private static final int ANALOGBALANCE = 50727;
    private static final int ASSHOTNEUTRAL = 50728;
    private static final int ASSHOTWHITEXY = 50729;
    private static final int BASELINEEXPOSURE = 50730;
    private static final int BASELINENOISE = 50731;
    private static final int BASELINESHARPNESS = 50732;
    private static final int BAYERGREENSPLIT = 50733;
    private static final int LINEARRESPONSELIMIT = 50734;
    private static final int CAMERASERIALNUMBER = 50735;
    private static final int LENSINFO = 50736;
    private static final int CHROMABLURRADIUS = 50737;
    private static final int ANTIALIASSTRENGTH = 50738;
    private static final int SHADOWSCALE = 50739;
    private static final int DNGPRIVATEDATA = 50740;
    private static final int MAKERNOTESAFETY = 50741;
    private static final int CALIBRATIONILLUMINANT1 = 50778;
    private static final int CALIBRATIONILLUMINANT2 = 50779;
    private static final int BESTQUALITYSCALE = 50780;
    public static final String[] CFALAYOUT_L = new String[]{"", "Rectangular", "Staggered Layout A", "Staggered Layout B", "Staggered Layout C", "Staggered Layout D"};
    public static final String[] MAKERNOTESAFETY_L = new String[]{"Unsafe", "Safe"};
    private NisoImageMetadata _niso = new NisoImageMetadata();
    private long _newSubfileType;
    private int _subfileType;
    private int _photometricInterpretation;
    private int _threshholding;
    private int _cellWidth;
    private int _cellLength;
    private int _fillOrder;
    private String _documentName;
    private String _imageDescription;
    private int[] _minSampleValue;
    private int[] _maxSampleValue;
    private String _pageName;
    private Rational _xPosition;
    private Rational _yPosition;
    private long[] _freeOffsets;
    private long[] _freeByteCounts;
    private long _t4Options;
    private long _t6Options;
    private int[] _pageNumber;
    private boolean _transferFunction;
    private String _dateTime;
    private int _predictor;
    private int[] _halftoneHints;
    private long _badFaxLines;
    private short _cleanFaxData;
    private long _consecutiveBadFaxLines;
    private int _inkSet;
    private String[] _inkNames;
    private long[] _subIFDs;
    private int _numberOfInks;
    private int[] _dotRange;
    private String _targetPrinter;
    private int[] _sampleFormat;
    private int[] _transferRange;
    private int[] _clipPath;
    private long _xClipPathUnits;
    private long _yClipPathUnits;
    private int _indexed;
    private int[] _jpegTables;
    private int _opiProxy;
    private int _jpegProc;
    private long _jpegInterchangeFormat;
    private long _jpegInterchangeFormatLength;
    private int _jpegRestartInterval;
    private int[] _jpegLosslessPredictors;
    private int[] _jpegPointTransforms;
    private long[] _jpegQTables;
    private long[] _jpegDCTables;
    private long[] _jpegACTables;
    private String _copyright;
    private long _exifIFD;
    private long _gpsInfoIFD;
    private long _globalParametersIFD;
    private int[] _photoshopProperties;
    private int[] _imageSourceData;
    private long _interoperabilityIFD;
    private int[] _annotations;
    private int _backgroundColorIndicator;
    private int _backgroundColorValue;
    private int _bitsPerExtendedRunLength;
    private int _bitsPerRunLength;
    private String _colorCharacterization;
    private String _colorSequence;
    private int[] _colorTable;
    private long _hcUsage;
    private int _imageColorIndicator;
    private int _imageColorValue;
    private String _it8Header;
    private int[] _pixelIntensityRange;
    private int _rasterPadding;
    private String _site;
    private int _transparencyIndicator;
    private Rational _aperatureValue;
    private String _batteryLevel;
    private int[] _cfaRepeatPatternDim;
    private int[] _cfaPattern;
    private Rational _compressedBitsPerPixel;
    private int _exposureProgram;
    private int _flash;
    private int _focalPlaneResolutionUnit;
    private Rational _focalPlaneXResolution;
    private Rational _focalPlaneYResolution;
    private int[] _interColourProfile;
    private String _imageHistory;
    private long _imageNumber;
    private int _interlace;
    private long[] _iptc;
    private int[] _isoSpeedRatings;
    private Rational _maxAperatureValue;
    private int[] _noise;
    private int[] _oecf;
    private String _securityClassification;
    private int _selfTimerMode;
    private Rational _shutterSpeedValue;
    private int[] _spatialFrequencyResponse;
    private String _spectralSensitivity;
    private int[] _subjectLocation;
    private String _tiffEPStandardID;
    private int[] _timeZoneOffset;
    private String _geoAsciiParamsTag;
    private double[] _geoDoubleParamsTag;
    private int[] _geoKeyDirectoryTag;
    private double[] _modelPixelScaleTag;
    private double[] _modelTiepointTag;
    private double[] _modelTransformationTag;
    private Property _xmpProp;
    private long[] _stripRowCounts;
    private int[] _imageLayer;
    private ExifIFD _theExifIFD;
    private GPSInfoIFD _theGPSInfoIFD;
    private InteroperabilityIFD _theInteroperabilityIFD;
    private GlobalParametersIFD _theGlobalParametersIFD;
    private int[] _dngVersion;
    private int[] _dngBackwardVersion;
    private String _uniqueCameraModel;
    private String _localizedCameraModel;
    private int[] _cfaPlaneColor;
    private int _cfaLayout;
    private int[] _linearizationTable;
    private int[] _blackLevelRepeatDim;
    private Rational[] _blackLevel;
    private Rational[] _blackLevelDeltaH;
    private Rational[] _blackLevelDeltaV;
    private long[] _whiteLevel;
    private Rational[] _defaultScale;
    private Rational _bestQualityScale;
    private Rational[] _defaultCropOrigin;
    private Rational[] _defaultCropSize;
    private int _calibrationIlluminant1;
    private int _calibrationIlluminant2;
    private Rational[] _colorMatrix1;
    private Rational[] _colorMatrix2;
    private Rational[] _cameraCalibration1;
    private Rational[] _cameraCalibration2;
    private Rational[] _reductionMatrix1;
    private Rational[] _reductionMatrix2;
    private Rational[] _analogBalance;
    private Rational[] _asShotNeutral;
    private Rational[] _asShotWhiteXY;
    private Rational _baselineExposure;
    private Rational _baselineNoise;
    private Rational _baselineSharpness;
    private int _bayerGreenSplit;
    private Rational _linearResponseLimit;
    private String _cameraSerialNumber;
    private Rational[] _lensInfo;
    private Rational _chromaBlurRadius;
    private Rational _antiAliasStrength;
    private int[] _dngPrivateData;
    private int _makerNoteSafety;

    public TiffIFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        super(l, repInfo, randomAccessFile, bl);
        this._niso.setMimeType("image/tiff");
        this._niso.setCompressionScheme(1);
        this._niso.setOrientation(1);
        this._niso.setPlanarConfiguration(1);
        this._niso.setRowsPerStrip(0xFFFFFFFFL);
        this._niso.setSamplesPerPixel(1);
        this._niso.setByteOrder(bl ? "big-endian" : "little-endian");
        this._photometricInterpretation = -1;
        this._cellLength = -1;
        this._cellWidth = -1;
        this._fillOrder = -1;
        this._indexed = 0;
        this._inkSet = -1;
        this._jpegInterchangeFormat = -1L;
        this._jpegInterchangeFormatLength = -1L;
        this._jpegProc = -1;
        this._jpegRestartInterval = -1;
        this._newSubfileType = 0L;
        this._numberOfInks = -1;
        this._opiProxy = -1;
        this._predictor = -1;
        this._subfileType = -1;
        this._t4Options = -1L;
        this._t6Options = -1L;
        this._threshholding = 1;
        this._xClipPathUnits = -1L;
        this._yClipPathUnits = -1L;
        this._backgroundColorIndicator = 0;
        this._backgroundColorValue = -1;
        this._bitsPerExtendedRunLength = 16;
        this._bitsPerRunLength = 8;
        this._hcUsage = -1L;
        this._imageColorIndicator = 0;
        this._imageColorValue = -1;
        this._rasterPadding = 0;
        this._transparencyIndicator = 0;
        this._exposureProgram = -1;
        this._flash = -1;
        this._focalPlaneResolutionUnit = -1;
        this._gpsInfoIFD = -1L;
        this._imageNumber = -1L;
        this._selfTimerMode = -1;
        this._exifIFD = -1L;
        this._focalPlaneResolutionUnit = -1;
        this._imageNumber = -1L;
        this._interlace = -1;
        this._interoperabilityIFD = -1L;
        this._globalParametersIFD = -1L;
        this._badFaxLines = -1L;
        this._cleanFaxData = (short)-1;
        this._consecutiveBadFaxLines = -1L;
        this._xmpProp = null;
        this._stripRowCounts = null;
        this._imageLayer = null;
        this._dngVersion = null;
        this._dngBackwardVersion = null;
        this._uniqueCameraModel = null;
        this._localizedCameraModel = null;
        this._cfaPlaneColor = null;
        this._cfaLayout = -1;
        this._linearizationTable = null;
        this._blackLevelRepeatDim = null;
        this._blackLevel = null;
        this._blackLevelDeltaH = null;
        this._blackLevelDeltaV = null;
        this._whiteLevel = null;
        this._defaultScale = null;
        this._bestQualityScale = null;
        this._defaultCropOrigin = null;
        this._defaultCropSize = null;
        this._calibrationIlluminant1 = -1;
        this._calibrationIlluminant2 = -1;
        this._colorMatrix1 = null;
        this._colorMatrix2 = null;
        this._cameraCalibration1 = null;
        this._cameraCalibration2 = null;
        this._reductionMatrix1 = null;
        this._reductionMatrix2 = null;
        this._analogBalance = null;
        this._asShotNeutral = null;
        this._asShotWhiteXY = null;
        this._baselineExposure = null;
        this._baselineNoise = null;
        this._baselineSharpness = null;
        this._bayerGreenSplit = -1;
        this._linearResponseLimit = null;
        this._cameraSerialNumber = null;
        this._lensInfo = null;
        this._chromaBlurRadius = null;
        this._antiAliasStrength = null;
        this._dngPrivateData = null;
        this._makerNoteSafety = -1;
    }

    public Rational getAperatureValue() {
        return this._aperatureValue;
    }

    public int getBackgroundColorIndicator() {
        return this._backgroundColorIndicator;
    }

    public int getBackgroundColorValue() {
        return this._backgroundColorValue;
    }

    public String getBatteryLevel() {
        return this._batteryLevel;
    }

    public int getBitsPerExtendedRunLength() {
        return this._bitsPerExtendedRunLength;
    }

    public int getBitsPerRunLength() {
        return this._bitsPerRunLength;
    }

    public int getCellLength() {
        return this._cellLength;
    }

    public int getCellWidth() {
        return this._cellWidth;
    }

    public int[] getCFAPattern() {
        return this._cfaPattern;
    }

    public int[] getCFARepeatPatternDim() {
        return this._cfaRepeatPatternDim;
    }

    public int[] getClipPath() {
        return this._clipPath;
    }

    public String getColorSequence() {
        return this._colorSequence;
    }

    public int[] getColorTable() {
        return this._colorTable;
    }

    public Rational getCompressedBitsPerPixel() {
        return this._compressedBitsPerPixel;
    }

    public String getCopyright() {
        return this._copyright;
    }

    public String getDateTime() {
        return this._dateTime;
    }

    public String getDocumentName() {
        return this._documentName;
    }

    public int[] getDotRange() {
        return this._dotRange;
    }

    public long getExifIFD() {
        return this._exifIFD;
    }

    public long getGlobalParametersIFD() {
        return this._globalParametersIFD;
    }

    public int getExposureProgram() {
        return this._exposureProgram;
    }

    public int getFillOrder() {
        return this._fillOrder;
    }

    public int getFocalPlaneResolutionUnit() {
        return this._focalPlaneResolutionUnit;
    }

    public Rational getFocalPlaneXResolution() {
        return this._focalPlaneXResolution;
    }

    public Rational getFocalPlaneYResolution() {
        return this._focalPlaneYResolution;
    }

    public int[] getGeoKeyDirectoryTag() {
        return this._geoKeyDirectoryTag;
    }

    public long getGPSInfoIFD() {
        return this._gpsInfoIFD;
    }

    public int getImageColorIndicator() {
        return this._imageColorIndicator;
    }

    public int getImageColorValue() {
        return this._imageColorValue;
    }

    public String getImageDescription() {
        return this._imageDescription;
    }

    public String getImageHistory() {
        return this._imageHistory;
    }

    public int[] getImageLayer() {
        return this._imageLayer;
    }

    public long getImageNumber() {
        return this._imageNumber;
    }

    public int[] getImageSourceData() {
        return this._imageSourceData;
    }

    public int[] getPhotoshopProperties() {
        return this._photoshopProperties;
    }

    public int[] getAnnotations() {
        return this._annotations;
    }

    public String[] getInkNames() {
        return this._inkNames;
    }

    public int getInkSet() {
        return this._inkSet;
    }

    public int getInterlace() {
        return this._interlace;
    }

    public long getInteroperabilityIFD() {
        return this._interoperabilityIFD;
    }

    public int[] getInterColourProfile() {
        return this._interColourProfile;
    }

    public int getIndexed() {
        return this._indexed;
    }

    public long getJpegInterchangeFormat() {
        return this._jpegInterchangeFormat;
    }

    public long[] getIPTCNAA() {
        return this._iptc;
    }

    public int[] getISOSpeedRatings() {
        return this._isoSpeedRatings;
    }

    public String getIT8Header() {
        return this._it8Header;
    }

    public int getJPEGProc() {
        return this._jpegProc;
    }

    public Rational getMaxAperatureValue() {
        return this._maxAperatureValue;
    }

    public double[] getModelTiepointTag() {
        return this._modelTiepointTag;
    }

    public double[] getModelTransformationTag() {
        return this._modelTransformationTag;
    }

    public long getNewSubfileType() {
        return this._newSubfileType;
    }

    public NisoImageMetadata getNisoImageMetadata() {
        return this._niso;
    }

    public int[] getNoise() {
        return this._noise;
    }

    public int getNumberOfInks() {
        return this._numberOfInks;
    }

    public int[] getOECF() {
        return this._oecf;
    }

    public String getPageName() {
        return this._pageName;
    }

    public int[] getPageNumber() {
        return this._pageNumber;
    }

    public int[] getPixelIntensityRange() {
        return this._pixelIntensityRange;
    }

    public int getRasterPadding() {
        return this._rasterPadding;
    }

    public String getSecurityClasssification() {
        return this._securityClassification;
    }

    public int getSelfTimerMode() {
        return this._selfTimerMode;
    }

    public Rational getShutterSpeedValue() {
        return this._shutterSpeedValue;
    }

    public String getSite() {
        return this._site;
    }

    public int[] getSpatialFrequencyResponse() {
        return this._spatialFrequencyResponse;
    }

    public String getSpectralSensitivity() {
        return this._spectralSensitivity;
    }

    public long[] getStripRowCounts() {
        return this._stripRowCounts;
    }

    public long[] getSubIFDs() {
        return this._subIFDs;
    }

    public int[] getSubjectLocation() {
        return this._subjectLocation;
    }

    public long getT4Options() {
        return this._t4Options;
    }

    public long getT6Options() {
        return this._t6Options;
    }

    public ExifIFD getTheExifIFD() {
        return this._theExifIFD;
    }

    public GPSInfoIFD getTheGPSInfoIFD() {
        return this._theGPSInfoIFD;
    }

    public InteroperabilityIFD getTheInteroperabilityIFD() {
        return this._theInteroperabilityIFD;
    }

    public GlobalParametersIFD getTheGlobalParametersIFD() {
        return this._theGlobalParametersIFD;
    }

    public int getThreshholding() {
        return this._threshholding;
    }

    public String getTIFFEPStandardID() {
        return this._tiffEPStandardID;
    }

    public int[] getTimeZoneOffset() {
        return this._timeZoneOffset;
    }

    public int getTransparencyIndicator() {
        return this._transparencyIndicator;
    }

    public long getXClipPathUnits() {
        return this._xClipPathUnits;
    }

    public Rational getXPosition() {
        return this._xPosition;
    }

    public Rational getYPosition() {
        return this._yPosition;
    }

    public int[] getDNGVersion() {
        return this._dngVersion;
    }

    public String getUniqueCameraModel() {
        return this._uniqueCameraModel;
    }

    public int[] getCFAPlaneColor() {
        return this._cfaPlaneColor;
    }

    public Rational[] getAsShotNeutral() {
        return this._asShotNeutral;
    }

    public Rational[] getAsShotWhiteXY() {
        return this._asShotWhiteXY;
    }

    @Override
    public Property getProperty(boolean bl) throws TiffException {
        LinkedList linkedList = new LinkedList();
        this.addNisoProperties(linkedList, bl);
        this.addMiscProperties(linkedList, bl);
        this.addTiffITProperties(linkedList, bl);
        this.addTiffEPProperties(linkedList, bl);
        this.addGeoTiffProperties(linkedList, bl);
        this.addTiffFXProperties(linkedList, bl);
        this.addDNGProperties(linkedList, bl);
        return this.propertyHeader("TIFF", linkedList);
    }

    private void addNisoProperties(List list, boolean bl) {
        list.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, this._niso));
    }

    private void addMiscProperties(List list, boolean bl) {
        if (this._imageDescription != null) {
            list.add(new Property("ImageDescription", PropertyType.STRING, this._imageDescription));
        }
        if (this._dateTime != null) {
            list.add(new Property("DateTime", PropertyType.STRING, this._dateTime));
        }
        if (this._newSubfileType != 0L || bl) {
            list.add(this.addBitmaskProperty("NewSubfileType", this._newSubfileType, NEWSUBFILETYPE_L, bl));
        } else {
            list.add(new Property("NewSubfileType", PropertyType.LONG, new Long(this._newSubfileType)));
        }
        if (this._subfileType != -1 && (this._subfileType != 0 || bl)) {
            list.add(this.addIntegerProperty("SubfileType", this._subfileType - 1, SUBFILETYPE_L, bl));
        } else if (this._subfileType != -1) {
            list.add(new Property("SubfileType", PropertyType.LONG, new Long(this._subfileType)));
        }
        if (this._documentName != null) {
            list.add(new Property("DocmentName", PropertyType.STRING, this._documentName));
        }
        if (this._pageName != null) {
            list.add(new Property("PageName", PropertyType.STRING, this._pageName));
        }
        if (this._pageNumber != null) {
            list.add(new Property("PageNumber", PropertyType.INTEGER, PropertyArity.ARRAY, this._pageNumber));
        }
        if (this._xPosition != null) {
            list.add(this.addRationalProperty("XPosition", this._xPosition, bl));
        }
        if (this._yPosition != null) {
            list.add(this.addRationalProperty("YPosition", this._yPosition, bl));
        }
        if (this._copyright != null) {
            list.add(new Property("Copyright", PropertyType.STRING, this._copyright));
        }
        if (this._fillOrder != -1) {
            list.add(this.addIntegerProperty("FillOrder", this._fillOrder, FILLORDER_L, bl));
        }
        list.add(new Property("SampleFormat", PropertyType.INTEGER, PropertyArity.ARRAY, this._sampleFormat));
        if (this._minSampleValue != null) {
            list.add(new Property("MinSampleValue", PropertyType.INTEGER, PropertyArity.ARRAY, this._minSampleValue));
        }
        if (this._maxSampleValue != null) {
            list.add(new Property("MaxSampleValue", PropertyType.INTEGER, PropertyArity.ARRAY, this._maxSampleValue));
        }
        if (this._inkSet != -1) {
            list.add(this.addIntegerProperty("InkSet", this._inkSet, INKSET_L, bl));
        }
        if (this._numberOfInks != -1) {
            list.add(new Property("NumberOfInks", PropertyType.INTEGER, new Integer(this._numberOfInks)));
        }
        if (this._inkNames != null) {
            list.add(new Property("InkNames", PropertyType.STRING, PropertyArity.ARRAY, this._inkNames));
        }
        if (this._dotRange != null) {
            list.add(new Property("DotRange", PropertyType.INTEGER, PropertyArity.ARRAY, this._dotRange));
        }
        if (this._targetPrinter != null) {
            list.add(new Property("TargetPrinter", PropertyType.STRING, this._targetPrinter));
        }
        if (this._halftoneHints != null) {
            list.add(new Property("HalftoneHints", PropertyType.INTEGER, PropertyArity.ARRAY, this._halftoneHints));
        }
        if (this._cellLength != -1) {
            list.add(new Property("CellLength", PropertyType.INTEGER, new Integer(this._cellLength)));
        }
        if (this._cellWidth != -1) {
            list.add(new Property("CellWidth", PropertyType.INTEGER, new Integer(this._cellWidth)));
        }
        if (this._transferFunction) {
            list.add(new Property("TransferFunction", PropertyType.BOOLEAN, new Boolean(true)));
        }
        if (this._transferRange != null) {
            list.add(new Property("TransferRange", PropertyType.INTEGER, PropertyArity.ARRAY, this._transferRange));
        }
        list.add(new Property("Threshholding", PropertyType.INTEGER, new Integer(this._threshholding)));
        if (this._predictor != -1) {
            list.add(this.addIntegerProperty("Predictor", this._predictor, PREDICTOR_L, bl));
        }
        if (this._t4Options != -1L) {
            list.add(new Property("T4Options", PropertyType.LONG, new Long(this._t4Options)));
        }
        if (this._t6Options != -1L) {
            list.add(new Property("T6Options", PropertyType.LONG, new Long(this._t6Options)));
        }
        if (this._jpegProc != -1) {
            list.add(this.addIntegerProperty("JPEGProc", this._jpegProc, JPEGPROC_L, JPEGPROC_INDEX, bl));
        }
        if (this._jpegInterchangeFormat != -1L) {
            list.add(new Property("JPEGInterchangeFormat", PropertyType.LONG, new Long(this._jpegInterchangeFormat)));
        }
        if (this._jpegInterchangeFormatLength != -1L) {
            list.add(new Property("JPEGInterchangeFormatLength", PropertyType.LONG, new Long(this._jpegInterchangeFormatLength)));
        }
        if (this._jpegRestartInterval != -1) {
            list.add(new Property("JPEGRestartInterval", PropertyType.INTEGER, new Integer(this._jpegRestartInterval)));
        }
        if (this._jpegLosslessPredictors != null) {
            list.add(this.addIntegerArrayProperty("JPEGLosslessPredictors", this._jpegLosslessPredictors, JPEGLOSSLESSPREDICTORS_L, bl));
        }
        if (this._jpegPointTransforms != null) {
            list.add(new Property("JPEGPointTransforms", PropertyType.INTEGER, PropertyArity.ARRAY, this._jpegPointTransforms));
        }
        if (this._jpegQTables != null) {
            list.add(new Property("JPEGQTables", PropertyType.LONG, PropertyArity.ARRAY, this._jpegQTables));
        }
        if (this._jpegDCTables != null) {
            list.add(new Property("JPEGDCTables", PropertyType.LONG, PropertyArity.ARRAY, this._jpegDCTables));
        }
        if (this._jpegACTables != null) {
            list.add(new Property("JPEGACTables", PropertyType.LONG, PropertyArity.ARRAY, this._jpegACTables));
        }
        if (this._jpegTables != null) {
            list.add(new Property("JPEGTables", PropertyType.INTEGER, PropertyArity.ARRAY, this._jpegTables));
        }
        if (this._imageSourceData != null) {
            list.add(new Property("ImageSourceData", PropertyType.INTEGER, PropertyArity.ARRAY, this._imageSourceData));
        }
        if (this._photoshopProperties != null) {
            list.add(new Property("PhotoshopProperties", PropertyType.INTEGER, PropertyArity.ARRAY, this._photoshopProperties));
        }
        if (this._annotations != null) {
            list.add(new Property("Annotations", PropertyType.INTEGER, PropertyArity.ARRAY, this._annotations));
        }
        if (this._clipPath != null) {
            list.add(new Property("ClipPath", PropertyType.INTEGER, PropertyArity.ARRAY, this._clipPath));
        }
        if (this._xClipPathUnits != -1L) {
            list.add(new Property("XClipPathUnits", PropertyType.LONG, new Long(this._xClipPathUnits)));
        }
        if (this._yClipPathUnits != -1L) {
            list.add(new Property("YClipPathUnits", PropertyType.LONG, new Long(this._yClipPathUnits)));
        }
        if (this._cleanFaxData != -1) {
            list.add(new Property("CleanFaxData", PropertyType.LONG, new Long(this._cleanFaxData)));
        }
        if (this._badFaxLines != -1L) {
            list.add(new Property("BadFaxLines", PropertyType.LONG, new Long(this._badFaxLines)));
        }
        if (this._consecutiveBadFaxLines != -1L) {
            list.add(new Property("ConsecutiveBadFaxLines", PropertyType.LONG, new Long(this._consecutiveBadFaxLines)));
        }
        if (this._freeByteCounts != null) {
            list.add(new Property("FreeByteCounts", PropertyType.LONG, PropertyArity.ARRAY, this._freeByteCounts));
        }
        if (this._freeOffsets != null) {
            list.add(new Property("FreeOffsets", PropertyType.LONG, PropertyArity.ARRAY, this._freeOffsets));
        }
    }

    private void addTiffITProperties(List list, boolean bl) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (this._site != null) {
            linkedList.add(new Property("Site", PropertyType.STRING, this._site));
        }
        if (this._colorTable != null) {
            linkedList.add(new Property("ColorTable", PropertyType.INTEGER, PropertyArity.ARRAY, this._colorTable));
        }
        linkedList.add(this.addIntegerProperty("BackgroundColorIndicator", this._backgroundColorIndicator, BACKGROUNDCOLORINDICATOR_L, bl));
        if (this._backgroundColorValue != -1) {
            linkedList.add(new Property("BackgroundColorValue", PropertyType.INTEGER, new Integer(this._backgroundColorValue)));
        }
        linkedList.add(this.addIntegerProperty("ImageColorIndicator", this._imageColorIndicator, IMAGECOLORINDICATOR_L, bl));
        linkedList.add(this.addIntegerProperty("TransparencyIndicator", this._transparencyIndicator, TRANSPARENCYINDICATOR_L, bl));
        if (this._imageColorValue != -1) {
            linkedList.add(new Property("ImageColorValue", PropertyType.INTEGER, new Integer(this._imageColorValue)));
        }
        if (this._colorCharacterization != null) {
            linkedList.add(new Property("ColorCharacterization", PropertyType.STRING, this._colorCharacterization));
        }
        if (this._colorSequence != null) {
            linkedList.add(new Property("ColorSequence", PropertyType.STRING, this._colorSequence));
        }
        if (this._hcUsage != -1L) {
            linkedList.add(this.addBitmaskProperty("HCUsage", this._hcUsage, HCUSAGE_L, bl));
        }
        if (this._it8Header != null) {
            linkedList.add(new Property("IT8Header", PropertyType.STRING, this._it8Header));
        }
        if (this._pixelIntensityRange != null) {
            linkedList.add(new Property("PixelIntensityRange", PropertyType.INTEGER, PropertyArity.ARRAY, this._pixelIntensityRange));
        }
        linkedList.add(this.addIntegerProperty("RasterPadding", this._rasterPadding, RASTERPADDING_L, bl));
        linkedList.add(new Property("BitsPerRunLength", PropertyType.INTEGER, new Integer(this._bitsPerRunLength)));
        linkedList.add(new Property("BitsPerExtendedRunLength", PropertyType.INTEGER, new Integer(this._bitsPerExtendedRunLength)));
        list.add(new Property("TIFFITProperties", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
    }

    private void addTiffEPProperties(List list, boolean bl) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (this._cfaRepeatPatternDim != null) {
            linkedList.add(new Property("CFARepeatPatternDim", PropertyType.INTEGER, PropertyArity.ARRAY, this._cfaRepeatPatternDim));
        }
        if (this._cfaPattern != null) {
            linkedList.add(new Property("CFAPattern", PropertyType.INTEGER, PropertyArity.ARRAY, this._cfaPattern));
        }
        if (this._batteryLevel != null) {
            linkedList.add(new Property("BatteryLevel", PropertyType.STRING, this._batteryLevel));
        }
        if (this._iptc != null) {
            linkedList.add(new Property("IPTCNAA", PropertyType.LONG, PropertyArity.ARRAY, this._iptc));
        }
        if (this._interColourProfile != null) {
            linkedList.add(new Property("InterColourProfile", PropertyType.BOOLEAN, Boolean.TRUE));
        }
        if (this._exposureProgram != -1) {
            linkedList.add(this.addIntegerProperty("ExposureProgram", this._exposureProgram, EXPOSUREPROGRAM_L, bl));
        }
        if (this._spectralSensitivity != null) {
            linkedList.add(new Property("SpectralSensitivity", PropertyType.STRING, this._spectralSensitivity));
        }
        if (this._isoSpeedRatings != null) {
            linkedList.add(new Property("ISOSpeedRatings", PropertyType.INTEGER, PropertyArity.ARRAY, this._isoSpeedRatings));
        }
        if (this._oecf != null) {
            linkedList.add(new Property("OECF", PropertyType.INTEGER, PropertyArity.ARRAY, this._oecf));
        }
        if (this._interlace != -1) {
            linkedList.add(new Property("Interlace", PropertyType.INTEGER, new Integer(this._interlace)));
        }
        if (this._timeZoneOffset != null) {
            linkedList.add(new Property("TimeZoneOffset", PropertyType.INTEGER, PropertyArity.ARRAY, this._timeZoneOffset));
        }
        if (this._selfTimerMode != -1) {
            linkedList.add(new Property("SelfTimerMode", PropertyType.INTEGER, new Integer(this._selfTimerMode)));
        }
        if (this._compressedBitsPerPixel != null) {
            linkedList.add(this.addRationalProperty("CompressedBitsPerPixel", this._compressedBitsPerPixel, bl));
        }
        if (this._shutterSpeedValue != null) {
            linkedList.add(this.addRationalProperty("ShutterSpeedValue", this._shutterSpeedValue, bl));
        }
        if (this._aperatureValue != null) {
            linkedList.add(this.addRationalProperty("AperatureValue", this._aperatureValue, bl));
        }
        if (this._maxAperatureValue != null) {
            linkedList.add(this.addRationalProperty("MaxAperatureValue", this._maxAperatureValue, bl));
        }
        if (this._flash != -1) {
            linkedList.add(this.addIntegerProperty("FLASH", this._flash, FLASH_L, FLASH_INDEX, bl));
        }
        if (this._spatialFrequencyResponse != null) {
            linkedList.add(new Property("SpatialFrequencyResponse", PropertyType.INTEGER, PropertyArity.ARRAY, this._spatialFrequencyResponse));
        }
        if (this._noise != null) {
            linkedList.add(new Property("Noise", PropertyType.INTEGER, PropertyArity.ARRAY, this._noise));
        }
        if (this._focalPlaneXResolution != null) {
            linkedList.add(this.addRationalProperty("FocalPlaneXResolution", this._focalPlaneXResolution, bl));
        }
        if (this._focalPlaneYResolution != null) {
            linkedList.add(this.addRationalProperty("FocalPlaneYResolution", this._focalPlaneYResolution, bl));
        }
        if (this._focalPlaneResolutionUnit != -1) {
            linkedList.add(this.addIntegerProperty("FocalPlaneResolutionUnit", this._focalPlaneResolutionUnit, FOCALPLANERESOLUTIONUNIT_L, bl));
        }
        if (this._imageNumber != -1L) {
            linkedList.add(new Property("ImageNumber", PropertyType.LONG, new Long(this._imageNumber)));
        }
        if (this._securityClassification != null) {
            linkedList.add(new Property("SecurityClassification", PropertyType.STRING, this._securityClassification));
        }
        if (this._imageHistory != null) {
            linkedList.add(new Property("ImageHistory", PropertyType.STRING, this._imageHistory));
        }
        if (this._subjectLocation != null) {
            linkedList.add(new Property("SubjectLocation", PropertyType.INTEGER, PropertyArity.ARRAY, this._subjectLocation));
        }
        if (this._tiffEPStandardID != null) {
            linkedList.add(new Property("TIFFEPSStandardID", PropertyType.STRING, this._tiffEPStandardID));
        }
        if (linkedList.size() > 0) {
            list.add(new Property("TIFFEPProperties", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
        if (this._xmpProp != null) {
            list.add(this._xmpProp);
        }
    }

    private void addGeoTiffProperties(List list, boolean bl) throws TiffException {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (this._geoKeyDirectoryTag != null) {
            linkedList.add(new Property("Version", PropertyType.INTEGER, new Integer(this._geoKeyDirectoryTag[0])));
            linkedList.add(new Property("Revision", PropertyType.STRING, Integer.toString(this._geoKeyDirectoryTag[1]) + "." + Integer.toString(this._geoKeyDirectoryTag[2])));
            linkedList.add(new Property("NumberOfKeys", PropertyType.INTEGER, new Integer(this._geoKeyDirectoryTag[3])));
            for (int i = 0; i < this._geoKeyDirectoryTag[3]; ++i) {
                int n = i * 4 + 4;
                int n2 = this._geoKeyDirectoryTag[n];
                int n3 = this._geoKeyDirectoryTag[n + 1];
                int n4 = this._geoKeyDirectoryTag[n + 2];
                int n5 = this._geoKeyDirectoryTag[n + 3];
                int n6 = 0;
                double d = 0.0;
                String string = "NULL";
                if (n3 == 0) {
                    n6 = n5;
                } else if (n3 == 34736) {
                    d = this._geoDoubleParamsTag[n5];
                } else if (n3 == 34737) {
                    try {
                        string = this._geoAsciiParamsTag.substring(n5, n5 + n4 - 1);
                    }
                    catch (Exception exception) {
                        throw new TiffException("Invalid GeoKeyDirectory tag");
                    }
                }
                if (n2 == 1024) {
                    linkedList.add(this.addIntegerProperty("GTModelType", n6, GeoTiffStrings.MODELTYPE, GeoTiffStrings.MODELTYPE_INDEX, bl));
                    continue;
                }
                if (n2 == 1025) {
                    linkedList.add(this.addIntegerProperty("GTRasterType", n6, GeoTiffStrings.RASTERTYPE, GeoTiffStrings.RASTERTYPE_INDEX, bl));
                    continue;
                }
                if (n2 == 1026) {
                    linkedList.add(new Property("GTCitation", PropertyType.STRING, string));
                    continue;
                }
                if (n2 == 2048) {
                    linkedList.add(this.addIntegerProperty("GeographicType", n6, GeoTiffStrings.GEOGRAPHICS, GeoTiffStrings.GEOGRAPHICS_INDEX, bl));
                    continue;
                }
                if (n2 == 2049) {
                    linkedList.add(new Property("GeogCitation", PropertyType.STRING, string));
                    continue;
                }
                if (n2 == 2050) {
                    linkedList.add(this.addIntegerProperty("GeogGeodeticDatum", n6, GeoTiffStrings.GEODETICDATUM, GeoTiffStrings.GEODETICDATUM_INDEX, bl));
                    continue;
                }
                if (n2 == 2051) {
                    linkedList.add(this.addIntegerProperty("GeogPrimeMeridian", n6, GeoTiffStrings.PRIMEMERIDIAN, GeoTiffStrings.PRIMEMERIDIAN_INDEX, bl));
                    continue;
                }
                if (n2 == 2061) {
                    linkedList.add(new Property("GeogPrimeMeridianLong", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2052) {
                    linkedList.add(this.addIntegerProperty("GeogLinearUnits", n6, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, bl));
                    continue;
                }
                if (n2 == 2053) {
                    linkedList.add(new Property("GeogLinearUnitSize", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2054) {
                    linkedList.add(this.addIntegerProperty("GeogAngularUnits", n6, GeoTiffStrings.ANGULARUNITS, GeoTiffStrings.ANGULARUNITS_INDEX, bl));
                    continue;
                }
                if (n2 == 2055) {
                    linkedList.add(new Property("GeogAngularUnitSize", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2056) {
                    linkedList.add(this.addIntegerProperty("GeogEllipsoid", n6, GeoTiffStrings.ELLIPSOID, GeoTiffStrings.ELLIPSOID_INDEX, bl));
                    continue;
                }
                if (n2 == 2057) {
                    linkedList.add(new Property("GeogSemiMajorAxis", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2058) {
                    linkedList.add(new Property("GeogSemiMinorAxis", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2059) {
                    linkedList.add(new Property("GeogInvFlattening", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 2060) {
                    linkedList.add(this.addIntegerProperty("GeogAzimuthUnits", n6, GeoTiffStrings.ANGULARUNITS, GeoTiffStrings.ANGULARUNITS_INDEX, bl));
                    continue;
                }
                if (n2 == 3072) {
                    linkedList.add(this.addIntegerProperty("ProjectedCSType", n6, GeoTiffStrings.PROJECTEDCSTYPE, GeoTiffStrings.PROJECTEDCSTYPE_INDEX, bl));
                    continue;
                }
                if (n2 == 3073) {
                    linkedList.add(new Property("PCSCitation", PropertyType.STRING, string));
                    continue;
                }
                if (n2 == 3074) {
                    linkedList.add(this.addIntegerProperty("Projection", n6, GeoTiffStrings.PROJECTION, GeoTiffStrings.PROJECTION_INDEX, bl));
                    continue;
                }
                if (n2 == 3075) {
                    linkedList.add(this.addIntegerProperty("ProjCoordTrans", n6, GeoTiffStrings.COORDINATETRANSFORMATION, GeoTiffStrings.COORDINATETRANSFORMATION_INDEX, bl));
                    continue;
                }
                if (n2 == 3076) {
                    linkedList.add(this.addIntegerProperty("ProjLinearUnits", n6, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, bl));
                    continue;
                }
                if (n2 == 3077) {
                    linkedList.add(new Property("ProjLinearUnitSize", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3078) {
                    linkedList.add(new Property("ProjStdParallel1", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3079) {
                    linkedList.add(new Property("ProjStdParallel2", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3080) {
                    linkedList.add(new Property("ProjNatOriginLong", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3081) {
                    linkedList.add(new Property("ProjNatOriginLat", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3082) {
                    linkedList.add(new Property("ProjFalseEasting", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3083) {
                    linkedList.add(new Property("ProjFalseNorthing", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3084) {
                    linkedList.add(new Property("ProjFalseOriginLong", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3085) {
                    linkedList.add(new Property("ProjFalseOriginLat", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3086) {
                    linkedList.add(new Property("ProjFalseOriginEasting", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3087 || n2 == 3091) {
                    linkedList.add(new Property("ProjFalseOriginNorthing", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3088) {
                    linkedList.add(new Property("ProjCenterLong", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3089) {
                    linkedList.add(new Property("ProjCenterLat", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3090) {
                    linkedList.add(new Property("ProjCenterEasting", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3092) {
                    linkedList.add(new Property("ProjScaleAtNatOrigin", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3093) {
                    linkedList.add(new Property("ProjScaleAtCenter", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3094) {
                    linkedList.add(new Property("ProjAzimuthAngle", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 3095) {
                    linkedList.add(new Property("ProjStraightVertPoleLong", PropertyType.DOUBLE, new Double(d)));
                    continue;
                }
                if (n2 == 4096) {
                    linkedList.add(this.addIntegerProperty("VerticalCSType", n6, GeoTiffStrings.VERTICALCSTYPE, GeoTiffStrings.VERTICALCSTYPE_INDEX, bl));
                    continue;
                }
                if (n2 == 4097) {
                    linkedList.add(new Property("VerticalCitation", PropertyType.STRING, string));
                    continue;
                }
                if (n2 == 4098) {
                    linkedList.add(this.addIntegerProperty("VerticalDatum", n6, GeoTiffStrings.VERTICALCSDATUM, GeoTiffStrings.VERTICALCSDATUM_INDEX, bl));
                    continue;
                }
                if (n2 != 4099) continue;
                linkedList.add(this.addIntegerProperty("VerticalUnits", n6, GeoTiffStrings.LINEARUNITS, GeoTiffStrings.LINEARUNITS_INDEX, bl));
            }
        }
        LinkedList<Property> linkedList2 = new LinkedList<Property>();
        if (linkedList.size() > 0) {
            linkedList2.add(new Property("GeoKeyDirectory", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
        if (this._modelTiepointTag != null) {
            linkedList2.add(new Property("ModelTiepointTag", PropertyType.DOUBLE, PropertyArity.ARRAY, this._modelTiepointTag));
        }
        if (this._modelPixelScaleTag != null) {
            linkedList2.add(new Property("ModelPixelScaleTag", PropertyType.DOUBLE, PropertyArity.ARRAY, this._modelPixelScaleTag));
        }
        if (this._modelTransformationTag != null) {
            linkedList2.add(new Property("ModelTransformationTag", PropertyType.DOUBLE, PropertyArity.ARRAY, this._modelTransformationTag));
        }
        if (linkedList2.size() > 0) {
            list.add(new Property("GeoTIFFProperties", PropertyType.PROPERTY, PropertyArity.LIST, linkedList2));
        }
    }

    private void addTiffFXProperties(List list, boolean bl) {
        if (this._stripRowCounts != null) {
            list.add(new Property("StripRowCounts", PropertyType.LONG, PropertyArity.ARRAY, this._stripRowCounts));
        }
        if (this._imageLayer != null) {
            Property[] propertyArray = new Property[2];
            try {
                propertyArray[0] = this.addIntegerProperty("LayerType", this._imageLayer[0], IMAGELAYER_L, bl);
                propertyArray[1] = new Property("OrdinalNumber", PropertyType.INTEGER, new Integer(this._imageLayer[1]));
                list.add(new Property("ImageLayer", PropertyType.PROPERTY, PropertyArity.ARRAY, propertyArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addDNGProperties(List list, boolean bl) {
        this.setDNGDefaults();
        LinkedList<Property> linkedList = new LinkedList<Property>();
        if (this._dngVersion != null) {
            linkedList.add(new Property("DNGVersion", PropertyType.INTEGER, PropertyArity.ARRAY, this._dngVersion));
        }
        if (this._dngBackwardVersion != null) {
            linkedList.add(new Property("DNGBackwardVersion", PropertyType.INTEGER, PropertyArity.ARRAY, this._dngBackwardVersion));
        }
        if (this._uniqueCameraModel != null) {
            linkedList.add(new Property("UniqueCameraModel", PropertyType.STRING, this._uniqueCameraModel));
        }
        if (this._localizedCameraModel != null) {
            linkedList.add(new Property("LocalizedCameraModel", PropertyType.STRING, this._localizedCameraModel));
        }
        if (this._cfaPlaneColor != null) {
            linkedList.add(new Property("CFAPlaneColor", PropertyType.INTEGER, PropertyArity.ARRAY, this._cfaPlaneColor));
        }
        if (this._cfaLayout != -1) {
            linkedList.add(this.addIntegerProperty("CFALayout", this._cfaLayout, CFALAYOUT_L, bl));
        }
        if (this._linearizationTable != null) {
            linkedList.add(new Property("LinearizationTable", PropertyType.INTEGER, PropertyArity.ARRAY, this._linearizationTable));
        }
        if (this._blackLevelRepeatDim != null) {
            linkedList.add(new Property("BlackLevelRepeatDim", PropertyType.INTEGER, PropertyArity.ARRAY, this._blackLevelRepeatDim));
        }
        if (this._blackLevel != null) {
            linkedList.add(new Property("BlackLevel", PropertyType.RATIONAL, PropertyArity.ARRAY, this._blackLevel));
        }
        if (this._blackLevelDeltaH != null) {
            linkedList.add(new Property("BlackLevelDeltaH", PropertyType.RATIONAL, PropertyArity.ARRAY, this._blackLevelDeltaH));
        }
        if (this._blackLevelDeltaV != null) {
            linkedList.add(new Property("BlackLevelDeltaV", PropertyType.RATIONAL, PropertyArity.ARRAY, this._blackLevelDeltaV));
        }
        if (this._whiteLevel != null) {
            linkedList.add(new Property("WhiteLevel", PropertyType.LONG, PropertyArity.ARRAY, this._whiteLevel));
        }
        if (this._defaultScale != null) {
            linkedList.add(new Property("DefaultScale", PropertyType.RATIONAL, PropertyArity.ARRAY, this._defaultScale));
        }
        if (this._bestQualityScale != null) {
            linkedList.add(new Property("BestQualityScale", PropertyType.RATIONAL, this._bestQualityScale));
        }
        if (this._defaultCropOrigin != null) {
            linkedList.add(new Property("DefaultCropOrigin", PropertyType.RATIONAL, PropertyArity.ARRAY, this._defaultCropOrigin));
        }
        if (this._defaultCropSize != null) {
            linkedList.add(new Property("DefaultCropSize", PropertyType.RATIONAL, PropertyArity.ARRAY, this._defaultCropSize));
        }
        if (this._calibrationIlluminant1 != -1) {
            linkedList.add(new Property("CalibrationIlluminant1", PropertyType.INTEGER, new Integer(this._calibrationIlluminant1)));
        }
        if (this._calibrationIlluminant2 != -1) {
            linkedList.add(new Property("CalibrationIlluminant2", PropertyType.INTEGER, new Integer(this._calibrationIlluminant2)));
        }
        if (this._colorMatrix1 != null) {
            linkedList.add(new Property("ColorMatrix1", PropertyType.RATIONAL, PropertyArity.ARRAY, this._colorMatrix1));
        }
        if (this._colorMatrix2 != null) {
            linkedList.add(new Property("ColorMatrix2", PropertyType.RATIONAL, PropertyArity.ARRAY, this._colorMatrix2));
        }
        if (this._cameraCalibration1 != null) {
            linkedList.add(new Property("CameraCalibration1", PropertyType.RATIONAL, PropertyArity.ARRAY, this._cameraCalibration1));
        }
        if (this._cameraCalibration2 != null) {
            linkedList.add(new Property("CameraCalibration2", PropertyType.RATIONAL, PropertyArity.ARRAY, this._cameraCalibration2));
        }
        if (this._reductionMatrix1 != null) {
            linkedList.add(new Property("ReductionMatrix1", PropertyType.RATIONAL, PropertyArity.ARRAY, this._reductionMatrix1));
        }
        if (this._reductionMatrix2 != null) {
            linkedList.add(new Property("ReductionMatrix2", PropertyType.RATIONAL, PropertyArity.ARRAY, this._reductionMatrix2));
        }
        if (this._analogBalance != null) {
            linkedList.add(new Property("AnalogBalance", PropertyType.RATIONAL, PropertyArity.ARRAY, this._analogBalance));
        }
        if (this._asShotNeutral != null) {
            linkedList.add(new Property("AsShotNeutral", PropertyType.RATIONAL, PropertyArity.ARRAY, this._asShotNeutral));
        }
        if (this._asShotWhiteXY != null) {
            linkedList.add(new Property("AsShotWhiteXY", PropertyType.RATIONAL, PropertyArity.ARRAY, this._asShotWhiteXY));
        }
        if (this._baselineExposure != null) {
            linkedList.add(new Property("BaselineExposure", PropertyType.RATIONAL, this._baselineExposure));
        }
        if (this._baselineNoise != null) {
            linkedList.add(new Property("BaselineNoise", PropertyType.RATIONAL, this._baselineNoise));
        }
        if (this._baselineNoise != null) {
            linkedList.add(new Property("BaselineSharpness", PropertyType.RATIONAL, this._baselineSharpness));
        }
        if (this._bayerGreenSplit != -1) {
            linkedList.add(new Property("BayerGreenSplit", PropertyType.INTEGER, new Integer(this._bayerGreenSplit)));
        }
        if (this._linearResponseLimit != null) {
            linkedList.add(new Property("LinearResponseLimit", PropertyType.RATIONAL, this._linearResponseLimit));
        }
        if (this._cameraSerialNumber != null) {
            linkedList.add(new Property("CameraSerialNumber", PropertyType.STRING, this._cameraSerialNumber));
        }
        if (this._lensInfo != null) {
            linkedList.add(new Property("LensInfo", PropertyType.RATIONAL, PropertyArity.ARRAY, this._lensInfo));
        }
        if (this._chromaBlurRadius != null) {
            linkedList.add(new Property("ChromaBlurRadius", PropertyType.RATIONAL, this._chromaBlurRadius));
        }
        if (this._antiAliasStrength != null) {
            linkedList.add(new Property("AntiAliasStrength", PropertyType.RATIONAL, this._antiAliasStrength));
        }
        if (this._dngPrivateData != null) {
            linkedList.add(new Property("DNGPrivateData", PropertyType.INTEGER, this._dngPrivateData));
        }
        if (this._makerNoteSafety != -1) {
            linkedList.add(this.addIntegerProperty("MakerNoteSafety", this._makerNoteSafety, MAKERNOTESAFETY_L, bl));
        }
        if (linkedList.size() > 0) {
            list.add(new Property("DNGProperties", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
    }

    private int calcColorPlanes() {
        if (this._photometricInterpretation == 32803) {
            int n = 0;
            if (this._cfaPattern == null) {
                return 1;
            }
            int[] nArray = new int[this._cfaPattern.length];
            for (int i = 0; i < this._cfaPattern.length; ++i) {
                boolean bl = true;
                int n2 = this._cfaPattern[i];
                for (int j = 0; j < n; ++j) {
                    if (n2 != nArray[j]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                nArray[n++] = n2;
            }
            return n;
        }
        return this._niso.getSamplesPerPixel();
    }

    private void setDNGDefaults() {
        if (this._dngVersion != null) {
            if (this._dngBackwardVersion == null) {
                this._dngBackwardVersion = new int[4];
                this._dngBackwardVersion[0] = this._dngVersion[0];
                this._dngBackwardVersion[1] = this._dngVersion[1];
                this._dngBackwardVersion[2] = 0;
                this._dngBackwardVersion[3] = 0;
            }
            if (this._uniqueCameraModel != null && this._localizedCameraModel == null) {
                this._localizedCameraModel = this._uniqueCameraModel;
            }
            if (this._calibrationIlluminant1 == -1) {
                this._calibrationIlluminant1 = 0;
            }
            if (this._baselineExposure == null) {
                this._baselineExposure = new Rational(0, 1);
            }
            if (this._baselineNoise == null) {
                this._baselineNoise = new Rational(1, 1);
            }
            if (this._baselineSharpness == null) {
                this._baselineSharpness = new Rational(1, 1);
            }
            if (this._linearResponseLimit == null) {
                this._linearResponseLimit = new Rational(1, 1);
            }
            if (this._makerNoteSafety == -1) {
                this._makerNoteSafety = 0;
            }
        }
        if (this._photometricInterpretation == 32803 || this._photometricInterpretation == 34892) {
            int n;
            if (this._cfaPlaneColor == null) {
                this._cfaPlaneColor = new int[]{0, 1, 2};
            }
            if (this._cfaLayout == -1) {
                this._cfaLayout = 1;
            }
            if (this._blackLevelRepeatDim == null) {
                this._blackLevelRepeatDim = new int[]{1, 1};
            }
            Rational rational = new Rational(0, 1);
            if (this._blackLevel == null) {
                this._blackLevel = new Rational[this._blackLevelRepeatDim[0] * this._blackLevelRepeatDim[1] * this._niso.getSamplesPerPixel()];
                for (n = 0; n < this._blackLevel.length; ++n) {
                    this._blackLevel[n] = rational;
                }
            }
            if (this._blackLevelDeltaH == null) {
                this._blackLevelDeltaH = new Rational[(int)this._niso.getImageWidth()];
                for (n = 0; n < this._blackLevelDeltaH.length; ++n) {
                    this._blackLevelDeltaH[n] = rational;
                }
            }
            if (this._blackLevelDeltaV == null) {
                this._blackLevelDeltaV = new Rational[(int)this._niso.getImageLength()];
                for (n = 0; n < this._blackLevelDeltaV.length; ++n) {
                    this._blackLevelDeltaV[n] = rational;
                }
            }
            if (this._whiteLevel == null) {
                this._whiteLevel = new long[this._niso.getSamplesPerPixel()];
                long l = 1L << this._niso.getBitsPerSample()[0] - 1;
                for (int i = 0; i < this._whiteLevel.length; ++i) {
                    this._whiteLevel[i] = l;
                }
            }
            Rational rational2 = new Rational(1, 1);
            if (this._defaultScale == null) {
                this._defaultScale = new Rational[]{rational2, rational2};
            }
            if (this._bestQualityScale == null) {
                this._bestQualityScale = rational2;
            }
            if (this._defaultCropOrigin == null) {
                this._defaultCropOrigin = new Rational[]{rational, rational};
            }
            if (this._defaultCropSize == null) {
                this._defaultCropSize = new Rational[2];
                this._defaultCropSize[0] = new Rational(this._niso.getImageWidth(), 1L);
                this._defaultCropSize[1] = new Rational(this._niso.getImageLength(), 1L);
            }
            int n2 = this.calcColorPlanes();
            if (this._cameraCalibration1 == null) {
                this._cameraCalibration1 = this.identityMatrix(n2);
            }
            if (this._cameraCalibration2 == null) {
                this._cameraCalibration2 = this.identityMatrix(n2);
            }
            if (this._bayerGreenSplit == -1 && this._photometricInterpretation == 32803) {
                this._bayerGreenSplit = 0;
            }
            if (this._antiAliasStrength == null) {
                this._antiAliasStrength = new Rational(1, 1);
            }
        }
    }

    private Rational[] identityMatrix(int n) {
        int n2;
        Rational[] rationalArray = new Rational[n * n];
        for (n2 = 0; n2 < n * n; ++n2) {
            rationalArray[n2] = new Rational(0, 1);
        }
        for (n2 = 0; n2 < n; ++n2) {
            rationalArray[n * n2 + n2] = new Rational(1, 1);
        }
        return rationalArray;
    }

    @Override
    public void lookupTag(int n, int n2, long l, long l2) throws TiffException {
        try {
            if (n == 37378) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._aperatureValue = this.readRational(l, l2);
            } else if (n == 315) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setImageProducer(this.readASCII(l, l2));
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 34024) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 1);
                this._backgroundColorIndicator = this.readByte(n2, l, l2);
            } else if (n == 34026) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 1);
                this._backgroundColorValue = this.readByte(n2, l, l2);
            } else if (n == 326) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._badFaxLines = this.readLong(n2, l, l2);
            } else if (n == 33423) {
                TiffIFD.checkType(n, n2, 5, 2);
                if (n2 == 5) {
                    Rational rational = this.readRational(l, l2);
                    this._batteryLevel = Double.toString(rational.toDouble());
                } else {
                    this._batteryLevel = this.readASCII(l, l2);
                }
            } else if (n == 34021) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._bitsPerExtendedRunLength = this.readShort(n2, l, l2);
            } else if (n == 34020) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._bitsPerRunLength = this.readShort(n2, l, l2);
            } else if (n == 258) {
                TiffIFD.checkType(n, n2, 3);
                this._niso.setBitsPerSample(this.readShortArray(n2, l, l2));
            } else if (n == 37379) {
                TiffIFD.checkType(n, n2, 10);
                if (l == 1L) {
                    this._niso.setBrightness(this.readSignedRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readSignedRationalArray(l, l2);
                    this._niso.setBrightness(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 265) {
                TiffIFD.checkType(n, n2, 3);
                this._cellLength = this.readShort(n2, l, l2);
            } else if (n == 264) {
                TiffIFD.checkType(n, n2, 3);
                this._cellWidth = this.readShort(n2, l, l2);
            } else if (n == 33422) {
                TiffIFD.checkType(n, n2, 1);
                this._cfaPattern = this.readByteArray(n2, l, l2);
            } else if (n == 33421) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 2);
                this._cfaRepeatPatternDim = this.readShortArray(n2, l, l2);
            } else if (n == 327) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._badFaxLines = this.readShort(n2, l, l2);
            } else if (n == 343) {
                TiffIFD.checkType(n, n2, 1);
                this._clipPath = this.readByteArray(n2, l, l2);
            } else if (n == 34029) {
                TiffIFD.checkType(n, n2, 2);
                this._colorCharacterization = this.readASCII(l, l2);
            } else if (n == 34017) {
                TiffIFD.checkType(n, n2, 2);
                this._colorSequence = this.readASCII(l, l2);
            } else if (n == 320) {
                TiffIFD.checkType(n, n2, 3);
                int[] nArray = this.readShortArray(n2, l, l2);
                int[] nArray2 = new int[nArray.length];
                int[] nArray3 = new int[nArray.length];
                int[] nArray4 = new int[nArray.length];
                int[] nArray5 = new int[nArray.length];
                int n3 = nArray.length / 3;
                int n4 = 2 * n3;
                for (int i = 0; i < n3; ++i) {
                    nArray2[i] = i;
                    nArray3[i] = nArray[i];
                    nArray4[i] = nArray[i + n3];
                    nArray5[i] = nArray[i + n4];
                }
                this._niso.setColormapBitCodeValue(nArray2);
                this._niso.setColormapRedValue(nArray3);
                this._niso.setColormapGreenValue(nArray4);
                this._niso.setColormapBlueValue(nArray5);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 34022) {
                TiffIFD.checkType(n, n2, 1);
                this._colorTable = this.readByteArray(n2, l, l2);
            } else if (n == 37122) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._compressedBitsPerPixel = this.readRational(l, l2);
            } else if (n == 259) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                int n5 = this.readShort(n2, l, l2);
                this._niso.setCompressionScheme(n5);
                if (n5 == 5) {
                    if (this._predictor == -1) {
                        this._predictor = 1;
                    }
                    if (this._version < 5) {
                        this._version = 5;
                    }
                }
                if (n5 == 6 && this._version < 6) {
                    this._version = 6;
                }
                if (n5 == 3 && this._t4Options == -1L) {
                    this._t4Options = 0L;
                }
                if (n5 == 4 && this._t6Options == -1L) {
                    this._t6Options = 0L;
                }
            } else if (n == 328) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._consecutiveBadFaxLines = this.readLong(n2, l, l2);
            } else if (n == 33432) {
                TiffIFD.checkType(n, n2, 2);
                this._copyright = this.readASCII(l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 306) {
                TiffIFD.checkType(n, n2, 2);
                TiffIFD.checkCount(n, l, 20);
                this._dateTime = this.readASCII(l, l2);
                this._niso.setDateTimeCreated(this._dateTime);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 36867) {
                TiffIFD.checkType(n, n2, 2);
                TiffIFD.checkCount(n, l, 20);
                this._niso.setDateTimeCreated(this.readASCII(l, l2));
            } else if (n == 269) {
                TiffIFD.checkType(n, n2, 2);
                this._documentName = this.readASCII(l, l2);
            } else if (n == 336) {
                TiffIFD.checkType(n, n2, 1, 3);
                TiffIFD.checkCount(n, l, 2);
                this._dotRange = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34665) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._exifIFD = this.readLong(n2, l, l2);
            } else if (n == 37380) {
                TiffIFD.checkType(n, n2, 10);
                if (l == 1L) {
                    this._niso.setExposureBias(this.readSignedRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readSignedRationalArray(l, l2);
                    this._niso.setExposureBias(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 34850) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._exposureProgram = this.readShort(n2, l, l2);
            } else if (n == 33434) {
                TiffIFD.checkType(n, n2, 5);
                if (l == 1L) {
                    this._niso.setExposureTime(this.readRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readRationalArray(l, l2);
                    this._niso.setExposureTime(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 338) {
                TiffIFD.checkType(n, n2, 3);
                this._niso.setExtraSamples(this.readShortArray(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 266) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._fillOrder = this.readShort(n2, l, l2);
            } else if (n == 37385) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._flash = this.readShort(n2, l, l2);
                this._niso.setFlash(this._flash);
                this._niso.setFlashReturn((this._flash & 6) != 0 ? 1 : 0);
            } else if (n == 37387) {
                TiffIFD.checkType(n, n2, 5);
                if (l == 1L) {
                    this._niso.setFlashEnergy(this.readRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readRationalArray(l, l2);
                    this._niso.setFlashEnergy(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 33437) {
                TiffIFD.checkType(n, n2, 5);
                if (l == 1L) {
                    this._niso.setFNumber(this.readRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readRationalArray(l, l2);
                    this._niso.setFNumber(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 37386) {
                TiffIFD.checkType(n, n2, 5);
                if (l == 1L) {
                    this._niso.setFocalLength(this.readRational(l, l2).toDouble());
                } else {
                    Rational[] rationalArray = this.readRationalArray(l, l2);
                    this._niso.setFocalLength(TiffIFD.average(rationalArray[0], rationalArray[1]).toDouble());
                }
            } else if (n == 37392) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._focalPlaneResolutionUnit = this.readShort(n2, l, l2);
                if (this._niso.getSamplingFrequencyUnit() != -1) {
                    this._niso.setSamplingFrequencyUnit(this._focalPlaneResolutionUnit);
                }
            } else if (n == 37390) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._focalPlaneXResolution = this.readRational(l, l2);
            } else if (n == 37391) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._focalPlaneYResolution = this.readRational(l, l2);
            } else if (n == 289) {
                TiffIFD.checkType(n, n2, 4);
                this._freeByteCounts = this.readLongArray(n2, l, l2);
            } else if (n == 288) {
                TiffIFD.checkType(n, n2, 4);
                this._freeOffsets = this.readLongArray(n2, l, l2);
            } else if (n == 34737) {
                TiffIFD.checkType(n, n2, 2);
                this._geoAsciiParamsTag = this.readASCII(l, l2);
            } else if (n == 34736) {
                TiffIFD.checkType(n, n2, 12);
                this._geoDoubleParamsTag = this.readDoubleArray(l, l2);
            } else if (n == 34735) {
                TiffIFD.checkType(n, n2, 3);
                this._geoKeyDirectoryTag = this.readShortArray(n2, l, l2);
                int n6 = this._geoKeyDirectoryTag[3];
                int n7 = -1;
                for (int i = 0; i < n6; ++i) {
                    int n8 = i * 4 + 4;
                    int n9 = this._geoKeyDirectoryTag[n8];
                    if (n7 > n9) {
                        throw new TiffException("GeoKey " + n9 + " out of sequence");
                    }
                    n7 = n9;
                }
            } else if (n == 400) {
                TiffIFD.checkType(n, n2, 4, 13);
                TiffIFD.checkCount(n, l, 1);
                this._globalParametersIFD = this.readLong(n2, l, l2);
            } else if (n == 34853) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._gpsInfoIFD = this.readLong(n2, l, l2);
            } else if (n == 291) {
                TiffIFD.checkType(n, n2, 3);
                this._niso.setGrayResponseCurve(this.readShortArray(n2, l, l2));
            } else if (n == 290) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setGrayResponseUnit(this.readShort(n2, l, l2));
            } else if (n == 321) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 2);
                this._halftoneHints = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34030) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._hcUsage = this.readLong(n2, l, l2);
            } else if (n == 316) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setHostComputer(this.readASCII(l, l2));
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 270) {
                TiffIFD.checkType(n, n2, 2);
                this._imageDescription = this.readASCII(l, l2);
            } else if (n == 32781) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setImageIdentifier(this.readASCII(l, l2));
            } else if (n == 34023) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 1);
                this._imageColorIndicator = this.readByte(n2, l, l2);
            } else if (n == 34025) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 1);
                this._imageColorValue = this.readByte(n2, l, l2);
            } else if (n == 37395) {
                TiffIFD.checkType(n, n2, 2);
                this._imageHistory = this.readASCII(l, l2);
            } else if (n == 34732) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 2);
                this._imageLayer = this.readShortArray(n2, l, l2);
            } else if (n == 257) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setImageLength(this.readLong(n2, l, l2));
            } else if (n == 37393) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._imageNumber = this.readLong(n2, l, l2);
            } else if (n == 37724) {
                TiffIFD.checkType(n, n2, 7);
                this._imageSourceData = new int[]{1};
            } else if (n == 34377) {
                this._photoshopProperties = this.readByteArray(n2, l, l2);
            } else if (n == 50255) {
                this._annotations = this.readByteArray(n2, l, l2);
            } else if (n == 256) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setImageWidth(this.readLong(n2, l, l2));
            } else if (n == 346) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._indexed = this.readShort(n2, l, l2);
            } else if (n == 333) {
                TiffIFD.checkType(n, n2, 2);
                this._inkNames = this.readASCIIArray(l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 332) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._inkSet = this.readShort(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34675) {
                TiffIFD.checkType(n, n2, 7);
                this._interColourProfile = this.readByteArray(n2, l, l2);
            } else if (n == 34857) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._interlace = this.readShort(n2, l, l2);
            } else if (n == 40965) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._interoperabilityIFD = this.readLong(n2, l, l2);
            } else if (n == 33723) {
                if (n2 == 2) {
                    String string = this.readASCII(l, l2);
                    long[] lArray = new long[string.length()];
                    for (int i = 0; i < string.length(); ++i) {
                        lArray[i] = string.charAt(i);
                    }
                    this._iptc = lArray;
                } else if (n2 == 4) {
                    this._iptc = this.readLongArray(n2, l, l2);
                } else {
                    TiffIFD.checkType(n, n2, 1, 7);
                    int[] nArray = this.readByteArray(n2, l, l2);
                    long[] lArray = new long[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        lArray[i] = nArray[i];
                        this._iptc = lArray;
                    }
                }
            } else if (n == 34855) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._isoSpeedRatings = this.readShortArray(n, l, l2);
            } else if (n == 34018) {
                TiffIFD.checkType(n, n2, 2);
                this._it8Header = this.readASCII(l, l2);
            } else if (n == 521) {
                TiffIFD.checkType(n, n2, 4);
                this._jpegACTables = this.readLongArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 520) {
                TiffIFD.checkType(n, n2, 4);
                this._jpegDCTables = this.readLongArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 513) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._jpegInterchangeFormat = this.readLong(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 514) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._jpegInterchangeFormatLength = this.readLong(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 517) {
                TiffIFD.checkType(n, n2, 3);
                this._jpegLosslessPredictors = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 518) {
                TiffIFD.checkType(n, n2, 3);
                this._jpegPointTransforms = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 512) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._jpegProc = this.readShort(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 519) {
                TiffIFD.checkType(n, n2, 4);
                this._jpegQTables = this.readLongArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 515) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._jpegRestartInterval = this.readShort(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 347) {
                TiffIFD.checkType(n, n2, 7);
                this._jpegTables = this.readByteArray(n2, l, l2);
            } else if (n == 37384) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setSceneIlluminant(this.readShort(n2, l, l2));
            } else if (n == 271) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setScannerManufacturer(this.readASCII(l, l2));
            } else if (n == 37381) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._maxAperatureValue = this.readRational(l, l2);
            } else if (n == 281) {
                TiffIFD.checkType(n, n2, 3);
                this._maxSampleValue = this.readShortArray(n2, l, l2);
            } else if (n == 37383) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setMeteringMode(this.readShort(n2, l, l2));
            } else if (n == 280) {
                TiffIFD.checkType(n, n2, 3);
                this._minSampleValue = this.readShortArray(n2, l, l2);
            } else if (n == 272) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setScannerModelName(this.readASCII(l, l2));
            } else if (n == 33550) {
                TiffIFD.checkType(n, n2, 12);
                TiffIFD.checkCount(n, l, 3);
                this._modelPixelScaleTag = this.readDoubleArray(l, l2);
            } else if (n == 33922) {
                TiffIFD.checkType(n, n2, 12);
                this._modelTiepointTag = this.readDoubleArray(l, l2);
            } else if (n == 34264) {
                TiffIFD.checkType(n, n2, 12);
                TiffIFD.checkCount(n, l, 16);
                this._modelTransformationTag = this.readDoubleArray(l, l2);
            } else if (n == 254) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._newSubfileType = this.readLong(n2, l, l2);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 37389) {
                TiffIFD.checkType(n, n2, 7);
                this._noise = this.readByteArray(n2, l, l2);
            } else if (n == 334) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._numberOfInks = this.readShort(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34856) {
                TiffIFD.checkType(n, n2, 7);
                this._oecf = this.readByteArray(n, l, l2);
            } else if (n == 351) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._opiProxy = this.readShort(n2, l, l2);
            } else if (n == 274) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setOrientation(this.readShort(n2, l, l2));
            } else if (n == 285) {
                TiffIFD.checkType(n, n2, 2);
                this._pageName = this.readASCII(l, l2);
            } else if (n == 297) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 2);
                this._pageNumber = this.readShortArray(n2, l, l2);
            } else if (n == 262) {
                int n10;
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._photometricInterpretation = this.readShort(n2, l, l2);
                this._niso.setColorSpace(this._photometricInterpretation);
                if (this._photometricInterpretation == 5) {
                    if (this._inkSet == -1) {
                        this._inkSet = 1;
                    }
                    if (this._numberOfInks == -1) {
                        this._numberOfInks = 4;
                    }
                } else if (this._photometricInterpretation == 6) {
                    if (this._niso.getYCbCrCoefficients() == null) {
                        this._niso.setYCbCrCoefficients(new Rational[]{new Rational(299, 1000), new Rational(587, 1000), new Rational(114, 1000)});
                    }
                    if (this._niso.getYCbCrPositioning() == -1) {
                        this._niso.setYCbCrPositioning(1);
                    }
                    if (this._niso.getYCbCrSubSampling() == null) {
                        this._niso.setYCbCrSubSampling(new int[]{2, 2});
                    }
                }
                if ((n10 = this._niso.getColorSpace()) == 3 || n10 == 4) {
                    if (this._version < 5) {
                        this._version = 5;
                    }
                } else if ((n10 == 5 || n10 == 6 || n10 == 8) && this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34027) {
                TiffIFD.checkType(n, n2, 1);
                this._pixelIntensityRange = this.readShortArray(n2, l, l2);
            } else if (n == 284) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setPlanarConfiguration(this.readShort(n2, l, l2));
            } else if (n == 317) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._predictor = this.readShort(n2, l, l2);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 319) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 6);
                Rational[] rationalArray = this.readRationalArray(l, l2);
                this._niso.setPrimaryChromaticitiesRedX(rationalArray[0]);
                this._niso.setPrimaryChromaticitiesRedY(rationalArray[1]);
                this._niso.setPrimaryChromaticitiesGreenX(rationalArray[2]);
                this._niso.setPrimaryChromaticitiesGreenY(rationalArray[3]);
                this._niso.setPrimaryChromaticitiesBlueX(rationalArray[4]);
                this._niso.setPrimaryChromaticitiesBlueY(rationalArray[5]);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 34019) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._rasterPadding = this.readShort(n2, l, l2);
            } else if (n == 532) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 6);
                this._niso.setReferenceBlackWhite(this.readRationalArray(l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 296) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setSamplingFrequencyUnit(this.readShort(n2, l, l2));
            } else if (n == 278) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setRowsPerStrip(this.readLong(n2, l, l2));
            } else if (n == 339) {
                TiffIFD.checkType(n, n2, 3);
                this._sampleFormat = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 277) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setSamplesPerPixel(this.readShort(n2, l, l2));
            } else if (n == 37394) {
                TiffIFD.checkType(n, n2, 2);
                this._securityClassification = this.readASCII(l, l2);
            } else if (n == 34859) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._selfTimerMode = this.readShort(n2, l, l2);
            } else if (n == 37399) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setSensor(this.readShort(n2, l, l2));
            } else if (n == 34016) {
                TiffIFD.checkType(n, n2, 2);
                this._site = this.readASCII(l, l2);
            } else if (n == 559) {
                TiffIFD.checkType(n, n2, 4);
                this._stripRowCounts = this.readLongArray(n2, l, l2);
            } else if (n == 37382) {
                TiffIFD.checkType(n, n2, 5, 10);
                double[] dArray = new double[2];
                if (l == 1L) {
                    dArray[0] = this.readRational(l, l2).toDouble();
                    dArray[1] = dArray[0];
                } else {
                    Rational[] rationalArray = n2 == 5 ? this.readRationalArray(l, l2) : this.readSignedRationalArray(l, l2);
                    dArray[0] = rationalArray[0].toDouble();
                    dArray[1] = rationalArray.length > 1 ? rationalArray[1].toDouble() : dArray[0];
                }
                this._niso.setSubjectDistance(dArray);
            } else if (n == 305) {
                TiffIFD.checkType(n, n2, 2);
                this._niso.setScanningSoftware(this.readASCII(l, l2));
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 37388) {
                TiffIFD.checkType(n, n2, 7);
                this._spatialFrequencyResponse = this.readByteArray(n2, l, l2);
            } else if (n == 34852) {
                TiffIFD.checkType(n, n2, 2);
                this._spectralSensitivity = this.readASCII(l, l2);
            } else if (n == 279) {
                TiffIFD.checkType(n, n2, 3, 4);
                this._niso.setStripByteCounts(this.readLongArray(n2, l, l2));
            } else if (n == 273) {
                TiffIFD.checkType(n, n2, 3, 4);
                this._niso.setStripOffsets(this.readLongArray(n2, l, l2));
            } else if (n == 255) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._subfileType = this.readShort(n2, l, l2);
            } else if (n == 330) {
                TiffIFD.checkType(n, n2, 4, 13);
                this._subIFDs = this.readLongArray(n2, l, l2);
            } else if (n == 37396) {
                TiffIFD.checkType(n, n2, 3);
                this._subjectLocation = this.readShortArray(n2, l, l2);
            } else if (n == 292) {
                TiffIFD.checkType(n, n2, 4);
                this._t4Options = this.readShort(n2, l, l2);
            } else if (n == 293) {
                TiffIFD.checkType(n, n2, 4);
                this._t6Options = this.readShort(n2, l, l2);
            } else if (n == 337) {
                TiffIFD.checkType(n, n2, 2);
                this._targetPrinter = this.readASCII(l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 263) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._threshholding = this.readShort(n2, l, l2);
            } else if (n == 37398) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 4);
                int[] nArray = this.readShortArray(n2, l, l2);
                this._tiffEPStandardID = Integer.toString(nArray[0]) + "." + Integer.toString(nArray[1]) + "." + Integer.toString(nArray[2]) + "." + Integer.toString(nArray[3]);
            } else if (n == 325) {
                TiffIFD.checkType(n, n2, 3, 4);
                this._niso.setTileByteCounts(this.readLongArray(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 323) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setTileLength(this.readLong(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 324) {
                TiffIFD.checkType(n, n2, 3, 4);
                this._niso.setTileOffsets(this.readLongArray(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 322) {
                TiffIFD.checkType(n, n2, 3, 4);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setTileWidth(this.readLong(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34858) {
                TiffIFD.checkType(n, n2, 8);
                this._timeZoneOffset = this.readSShortArray(n2, l, l2);
            } else if (n == 301) {
                TiffIFD.checkType(n, n2, 3);
                this._transferFunction = true;
            } else if (n == 342) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 6);
                this._transferRange = this.readShortArray(n2, l, l2);
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 34028) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 1);
                this._transparencyIndicator = this.readByte(n2, l, l2);
            } else if (n == 318) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 2);
                Rational[] rationalArray = this.readRationalArray(l, l2);
                this._niso.setWhitePointXValue(rationalArray[0]);
                this._niso.setWhitePointYValue(rationalArray[0]);
                if (this._version < 5) {
                    this._version = 5;
                }
            } else if (n == 344) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._xClipPathUnits = this.readLong(n2, l, l2);
            } else if (n == 286) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._xPosition = this.readRational(l, l2);
            } else if (n == 282) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setXSamplingFrequency(this.readRational(l, l2));
            } else if (n == 529) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 3);
                this._niso.setYCbCrCoefficients(this.readRationalArray(l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 531) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setYCbCrPositioning(this.readShort(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 530) {
                TiffIFD.checkType(n, n2, 3);
                TiffIFD.checkCount(n, l, 2);
                this._niso.setYCbCrSubSampling(this.readShortArray(n2, l, l2));
                if (this._version < 6) {
                    this._version = 6;
                }
            } else if (n == 345) {
                TiffIFD.checkType(n, n2, 4);
                TiffIFD.checkCount(n, l, 1);
                this._yClipPathUnits = this.readLong(n2, l, l2);
            } else if (n == 287) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._yPosition = this.readRational(l, l2);
            } else if (n == 283) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._niso.setYSamplingFrequency(this.readRational(l, l2));
            } else if (n == 700) {
                TiffIFD.checkType(n, n2, 1);
                this._xmpProp = this.readXMP(l, l2);
            } else if (n == 50706) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 4);
                this._dngVersion = this.readByteArray(n2, l, l2);
            } else if (n == 50707) {
                TiffIFD.checkType(n, n2, 1);
                TiffIFD.checkCount(n, l, 4);
                this._dngBackwardVersion = this.readByteArray(n2, l, l2);
            } else if (n == 50708) {
                TiffIFD.checkType(n, n2, 2);
                this._uniqueCameraModel = this.readASCII(l, l2);
            } else if (n == 50709) {
                int n11;
                TiffIFD.checkType(n, n2, 2, 1);
                byte[] byArray = this.readTrueByteArray(n2, l, l2);
                for (n11 = byArray.length; n11 > 0 && byArray[n11 - 1] == 0; --n11) {
                }
                this._localizedCameraModel = new String(byArray, 0, n11);
            } else if (n == 50710) {
                TiffIFD.checkType(n, n2, 1);
                this._cfaPlaneColor = this.readByteArray(n2, l, l2);
            } else if (n == 50711) {
                TiffIFD.checkType(n, n2, 3);
                this._cfaLayout = this.readShort(n2, l, l2);
            } else if (n == 50712) {
                TiffIFD.checkType(n, n2, 3);
                this._linearizationTable = this.readShortArray(n2, l, l2);
            } else if (n == 50713) {
                TiffIFD.checkType(n, n2, 3);
                this._blackLevelRepeatDim = this.readShortArray(n2, l, l2);
            } else if (n == 50714) {
                if (n2 == 5) {
                    this._blackLevel = this.readRationalArray(l, l2);
                } else {
                    TiffIFD.checkType(n, n2, 3, 4);
                    long[] lArray = this.readLongArray(n2, l, l2);
                    this._blackLevel = new Rational[(int)l];
                    int n12 = 0;
                    while ((long)n12 < l) {
                        this._blackLevel[n12] = new Rational(lArray[n12], 1L);
                        ++n12;
                    }
                }
            } else if (n == 50715) {
                TiffIFD.checkType(n, n2, 10);
                this._blackLevelDeltaH = this.readSignedRationalArray(l, l2);
            } else if (n == 50716) {
                TiffIFD.checkType(n, n2, 10);
                this._blackLevelDeltaV = this.readSignedRationalArray(l, l2);
            } else if (n == 50717) {
                TiffIFD.checkType(n, n2, 3, 4);
                this._whiteLevel = this.readLongArray(n2, l, l2);
            } else if (n == 50718) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 2);
                this._defaultScale = this.readRationalArray(l, l2);
            } else if (n == 50780) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 1);
                this._bestQualityScale = this.readRational(l, l2);
            } else if (n == 50719) {
                TiffIFD.checkCount(n, l, 2);
                if (n2 == 5) {
                    this._defaultCropOrigin = this.readRationalArray(l, l2);
                } else {
                    TiffIFD.checkType(n, n2, 3, 4);
                    long[] lArray = this.readLongArray(n2, l, l2);
                    this._defaultCropOrigin = new Rational[(int)l];
                    int n13 = 0;
                    while ((long)n13 < l) {
                        this._defaultCropOrigin[n13] = new Rational(lArray[n13], 1L);
                        ++n13;
                    }
                }
            } else if (n == 50720) {
                TiffIFD.checkCount(n, l, 2);
                if (n2 == 5) {
                    this._defaultCropSize = this.readRationalArray(l, l2);
                } else {
                    TiffIFD.checkType(n, n2, 3, 4);
                    long[] lArray = this.readLongArray(n2, l, l2);
                    this._defaultCropSize = new Rational[(int)l];
                    int n14 = 0;
                    while ((long)n14 < l) {
                        this._defaultCropSize[n14] = new Rational(lArray[n14], 1L);
                        ++n14;
                    }
                }
            } else if (n == 50778) {
                TiffIFD.checkCount(n, l, 1);
                TiffIFD.checkType(n, n2, 3);
                this._calibrationIlluminant1 = this.readShort(n2, l, l2);
            } else if (n == 50779) {
                TiffIFD.checkCount(n, l, 1);
                TiffIFD.checkType(n, n2, 3);
                this._calibrationIlluminant2 = this.readShort(n2, l, l2);
            } else if (n == 50721) {
                TiffIFD.checkType(n, n2, 10);
                this._colorMatrix1 = this.readSignedRationalArray(l, l2);
            } else if (n == 50722) {
                TiffIFD.checkType(n, n2, 10);
                this._colorMatrix2 = this.readSignedRationalArray(l, l2);
            } else if (n == 50723) {
                TiffIFD.checkType(n, n2, 10);
                this._colorMatrix1 = this.readSignedRationalArray(l, l2);
            } else if (n == 50724) {
                TiffIFD.checkType(n, n2, 10);
                this._colorMatrix2 = this.readSignedRationalArray(l, l2);
            } else if (n == 50725) {
                TiffIFD.checkType(n, n2, 10);
                this._reductionMatrix1 = this.readSignedRationalArray(l, l2);
            } else if (n == 50726) {
                TiffIFD.checkType(n, n2, 10);
                this._reductionMatrix2 = this.readSignedRationalArray(l, l2);
            } else if (n == 50727) {
                TiffIFD.checkType(n, n2, 5);
                this._analogBalance = this.readRationalArray(l, l2);
            } else if (n == 50728) {
                TiffIFD.checkType(n, n2, 3, 5);
                if (n2 == 3) {
                    int[] nArray = this.readShortArray(n2, l, l2);
                    this._asShotNeutral = new Rational[(int)l];
                    int n15 = 0;
                    while ((long)n15 < l) {
                        this._asShotNeutral[n15] = new Rational(nArray[n15], 1);
                        ++n15;
                    }
                } else {
                    this._asShotNeutral = this.readRationalArray(l, l2);
                }
            } else if (n == 50729) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 2);
                this._asShotWhiteXY = this.readRationalArray(l, l2);
            } else if (n == 50730) {
                TiffIFD.checkType(n, n2, 10);
                this._baselineExposure = this.readSignedRational(l, l2);
            } else if (n == 50731) {
                TiffIFD.checkType(n, n2, 5);
                this._baselineNoise = this.readRational(l, l2);
            } else if (n == 50732) {
                TiffIFD.checkType(n, n2, 5);
                this._baselineSharpness = this.readRational(l, l2);
            } else if (n == 50733) {
                TiffIFD.checkType(n, n2, 4);
                this._bayerGreenSplit = (int)this.readLong(n2, l, l2);
            } else if (n == 50734) {
                TiffIFD.checkType(n, n2, 5);
                this._linearResponseLimit = this.readRational(l, l2);
            } else if (n == 50735) {
                TiffIFD.checkType(n, n2, 2);
                this._cameraSerialNumber = this.readASCII(l, l2);
            } else if (n == 50736) {
                TiffIFD.checkType(n, n2, 5);
                TiffIFD.checkCount(n, l, 4);
                this._lensInfo = this.readRationalArray(l, l2);
            } else if (n == 50737) {
                TiffIFD.checkType(n, n2, 5);
                this._chromaBlurRadius = this.readRational(l, l2);
            } else if (n == 50738) {
                TiffIFD.checkType(n, n2, 5);
                this._antiAliasStrength = this.readRational(l, l2);
            } else if (n == 50739) {
                this._info.setMessage(new InfoMessage("Undocumented TIFF tag ", "ShadowScale (50739)"));
            } else if (n == 50740) {
                TiffIFD.checkType(n, n2, 1);
                this._dngPrivateData = this.readByteArray(n2, l, l2);
            } else if (n == 50741) {
                TiffIFD.checkType(n, n2, 3);
                this._makerNoteSafety = this.readShort(n2, l, l2);
            } else {
                this._info.setMessage(new InfoMessage("Unknown TIFF IFD tag: " + n, l2));
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error for tag " + n, l2);
        }
    }

    @Override
    protected void postParseInitialization() {
        int n;
        int n2;
        int n3 = this._niso.getSamplesPerPixel();
        int[] nArray = this._niso.getBitsPerSample();
        if (nArray == null) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = 1;
            }
            this._niso.setBitsPerSample(nArray);
        }
        n2 = (1 << nArray[0]) - 1;
        if (this._maxSampleValue == null) {
            this._maxSampleValue = new int[n3];
            for (n = 0; n < n3; ++n) {
                this._maxSampleValue[n] = n2;
            }
        }
        if (this._minSampleValue == null) {
            this._minSampleValue = new int[n3];
            for (n = 0; n < n3; ++n) {
                this._minSampleValue[n] = 0;
            }
        }
        if (this._sampleFormat == null) {
            this._sampleFormat = new int[n3];
            for (n = 0; n < n3; ++n) {
                this._sampleFormat[n] = 1;
            }
        }
        if (this._photometricInterpretation == 5 && this._dotRange == null) {
            this._dotRange = new int[2];
            this._dotRange[0] = 0;
            this._dotRange[1] = n2;
        }
        if (this._photometricInterpretation == 2 || this._photometricInterpretation == 6) {
            if (this._transferRange == null) {
                this._transferRange = new int[6];
                this._transferRange[4] = 0;
                this._transferRange[2] = 0;
                this._transferRange[0] = 0;
                this._transferRange[3] = this._transferRange[5] = n2;
                this._transferRange[1] = this._transferRange[5];
            }
            if (this._niso.getReferenceBlackWhite() == null) {
                Rational[] rationalArray = new Rational[6];
                rationalArray[2] = rationalArray[4] = new Rational(0, 1);
                rationalArray[0] = rationalArray[4];
                rationalArray[3] = rationalArray[5] = new Rational(n2, 1);
                rationalArray[1] = rationalArray[5];
                this._niso.setReferenceBlackWhite(rationalArray);
            }
        }
        if (this._pixelIntensityRange == null) {
            this._pixelIntensityRange = new int[2];
            this._pixelIntensityRange[0] = 0;
            this._pixelIntensityRange[1] = n2;
        }
    }

    public void setTheExifIFD(ExifIFD exifIFD) {
        this._theExifIFD = exifIFD;
    }

    public void setTheGPSInfoIFD(GPSInfoIFD gPSInfoIFD) {
        this._theGPSInfoIFD = gPSInfoIFD;
    }

    public void setTheInteroperabilityIFD(InteroperabilityIFD interoperabilityIFD) {
        this._theInteroperabilityIFD = interoperabilityIFD;
    }

    public void setTheGlobalParametersIFD(GlobalParametersIFD globalParametersIFD) {
        this._theGlobalParametersIFD = globalParametersIFD;
    }

    private Property readXMP(long l, long l2) throws TiffException {
        Property property = null;
        try {
            byte[] byArray = this.readTrueByteArray(1, l, l2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayXMPSource byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            XMPHandler xMPHandler = new XMPHandler();
            xMLReader.setContentHandler(xMPHandler);
            try {
                xMLReader.parse(byteArrayXMPSource);
                property = byteArrayXMPSource.makeProperty();
                return property;
            }
            catch (SAXException sAXException) {
                String string = sAXException.getMessage();
                if (string != null && string.startsWith("ENC=")) {
                    String string2 = string.substring(5);
                    try {
                        byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream, string2);
                        xMLReader.parse(byteArrayXMPSource);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new TiffException("Invalid or ill-formed XMP metadata");
                    }
                }
                property = byteArrayXMPSource.makeProperty();
                return property;
            }
        }
        catch (TiffException tiffException) {
            throw tiffException;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

