/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREINSTALLATIONSERVICECAPABILITIES_H_
#define OPENDRIM_SOFTWAREINSTALLATIONSERVICECAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_SoftwareInstallationServiceCapabilities_classnames[] = {"OpenDRIM_SoftwareInstallationServiceCapabilities"};
static string OpenDRIM_SoftwareInstallationServiceCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_SoftwareInstallationServiceCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	vector<unsigned short> SupportedAsynchronousActions;
	bool SupportedAsynchronousActions_isNULL;
	
	vector<unsigned short> SupportedSynchronousActions;
	bool SupportedSynchronousActions_isNULL;
	
	vector<string> SupportedTargetTypes;
	bool SupportedTargetTypes_isNULL;
	
	vector<unsigned short> SupportedExtendedResourceTypes;
	bool SupportedExtendedResourceTypes_isNULL;
	
	bool CanAddToCollection;
	bool CanAddToCollection_isNULL;
	
	vector<unsigned short> SupportedInstallOptions;
	bool SupportedInstallOptions_isNULL;
	
	vector<string> OtherSupportedExtendedResourceTypeDescriptions;
	bool OtherSupportedExtendedResourceTypeDescriptions_isNULL;
	
	vector<unsigned short> SupportedExtendedResourceTypesMajorVersions;
	bool SupportedExtendedResourceTypesMajorVersions_isNULL;
	
	vector<unsigned short> SupportedExtendedResourceTypesMinorVersions;
	bool SupportedExtendedResourceTypesMinorVersions_isNULL;
	
	vector<unsigned short> SupportedExtendedResourceTypesRevisionNumbers;
	bool SupportedExtendedResourceTypesRevisionNumbers_isNULL;
	
	vector<unsigned short> SupportedExtendedResourceTypesBuildNumbers;
	bool SupportedExtendedResourceTypesBuildNumbers_isNULL;
	
	vector<unsigned short> SupportedURISchemes;
	bool SupportedURISchemes_isNULL;
	
	OpenDRIM_SoftwareInstallationServiceCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		SupportedAsynchronousActions_isNULL = true;
		SupportedSynchronousActions_isNULL = true;
		SupportedTargetTypes_isNULL = true;
		SupportedExtendedResourceTypes_isNULL = true;
		CanAddToCollection_isNULL = true;
		SupportedInstallOptions_isNULL = true;
		OtherSupportedExtendedResourceTypeDescriptions_isNULL = true;
		SupportedExtendedResourceTypesMajorVersions_isNULL = true;
		SupportedExtendedResourceTypesMinorVersions_isNULL = true;
		SupportedExtendedResourceTypesRevisionNumbers_isNULL = true;
		SupportedExtendedResourceTypesBuildNumbers_isNULL = true;
		SupportedURISchemes_isNULL = true;
	}
	
	~OpenDRIM_SoftwareInstallationServiceCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getSupportedAsynchronousActions(vector<unsigned short>& value) const {
		if (SupportedAsynchronousActions_isNULL==true)
			return NOT_FOUND;
		value = SupportedAsynchronousActions;
		return OK;
	}
	
	int setSupportedAsynchronousActions(const vector<unsigned short>& newValue) {
		SupportedAsynchronousActions = newValue;
		SupportedAsynchronousActions_isNULL = false;
		return OK;
	}

	int getSupportedSynchronousActions(vector<unsigned short>& value) const {
		if (SupportedSynchronousActions_isNULL==true)
			return NOT_FOUND;
		value = SupportedSynchronousActions;
		return OK;
	}
	
	int setSupportedSynchronousActions(const vector<unsigned short>& newValue) {
		SupportedSynchronousActions = newValue;
		SupportedSynchronousActions_isNULL = false;
		return OK;
	}

	int getSupportedTargetTypes(vector<string>& value) const {
		if (SupportedTargetTypes_isNULL==true)
			return NOT_FOUND;
		value = SupportedTargetTypes;
		return OK;
	}
	
	int setSupportedTargetTypes(const vector<string>& newValue) {
		SupportedTargetTypes = newValue;
		SupportedTargetTypes_isNULL = false;
		return OK;
	}

	int getSupportedExtendedResourceTypes(vector<unsigned short>& value) const {
		if (SupportedExtendedResourceTypes_isNULL==true)
			return NOT_FOUND;
		value = SupportedExtendedResourceTypes;
		return OK;
	}
	
	int setSupportedExtendedResourceTypes(const vector<unsigned short>& newValue) {
		SupportedExtendedResourceTypes = newValue;
		SupportedExtendedResourceTypes_isNULL = false;
		return OK;
	}

	int getCanAddToCollection(bool& value) const {
		if (CanAddToCollection_isNULL==true)
			return NOT_FOUND;
		value = CanAddToCollection;
		return OK;
	}
	
	int setCanAddToCollection(const bool& newValue) {
		CanAddToCollection = newValue;
		CanAddToCollection_isNULL = false;
		return OK;
	}

	int getSupportedInstallOptions(vector<unsigned short>& value) const {
		if (SupportedInstallOptions_isNULL==true)
			return NOT_FOUND;
		value = SupportedInstallOptions;
		return OK;
	}
	
	int setSupportedInstallOptions(const vector<unsigned short>& newValue) {
		SupportedInstallOptions = newValue;
		SupportedInstallOptions_isNULL = false;
		return OK;
	}

	int getOtherSupportedExtendedResourceTypeDescriptions(vector<string>& value) const {
		if (OtherSupportedExtendedResourceTypeDescriptions_isNULL==true)
			return NOT_FOUND;
		value = OtherSupportedExtendedResourceTypeDescriptions;
		return OK;
	}
	
	int setOtherSupportedExtendedResourceTypeDescriptions(const vector<string>& newValue) {
		OtherSupportedExtendedResourceTypeDescriptions = newValue;
		OtherSupportedExtendedResourceTypeDescriptions_isNULL = false;
		return OK;
	}

	int getSupportedExtendedResourceTypesMajorVersions(vector<unsigned short>& value) const {
		if (SupportedExtendedResourceTypesMajorVersions_isNULL==true)
			return NOT_FOUND;
		value = SupportedExtendedResourceTypesMajorVersions;
		return OK;
	}
	
	int setSupportedExtendedResourceTypesMajorVersions(const vector<unsigned short>& newValue) {
		SupportedExtendedResourceTypesMajorVersions = newValue;
		SupportedExtendedResourceTypesMajorVersions_isNULL = false;
		return OK;
	}

	int getSupportedExtendedResourceTypesMinorVersions(vector<unsigned short>& value) const {
		if (SupportedExtendedResourceTypesMinorVersions_isNULL==true)
			return NOT_FOUND;
		value = SupportedExtendedResourceTypesMinorVersions;
		return OK;
	}
	
	int setSupportedExtendedResourceTypesMinorVersions(const vector<unsigned short>& newValue) {
		SupportedExtendedResourceTypesMinorVersions = newValue;
		SupportedExtendedResourceTypesMinorVersions_isNULL = false;
		return OK;
	}

	int getSupportedExtendedResourceTypesRevisionNumbers(vector<unsigned short>& value) const {
		if (SupportedExtendedResourceTypesRevisionNumbers_isNULL==true)
			return NOT_FOUND;
		value = SupportedExtendedResourceTypesRevisionNumbers;
		return OK;
	}
	
	int setSupportedExtendedResourceTypesRevisionNumbers(const vector<unsigned short>& newValue) {
		SupportedExtendedResourceTypesRevisionNumbers = newValue;
		SupportedExtendedResourceTypesRevisionNumbers_isNULL = false;
		return OK;
	}

	int getSupportedExtendedResourceTypesBuildNumbers(vector<unsigned short>& value) const {
		if (SupportedExtendedResourceTypesBuildNumbers_isNULL==true)
			return NOT_FOUND;
		value = SupportedExtendedResourceTypesBuildNumbers;
		return OK;
	}
	
	int setSupportedExtendedResourceTypesBuildNumbers(const vector<unsigned short>& newValue) {
		SupportedExtendedResourceTypesBuildNumbers = newValue;
		SupportedExtendedResourceTypesBuildNumbers_isNULL = false;
		return OK;
	}

	int getSupportedURISchemes(vector<unsigned short>& value) const {
		if (SupportedURISchemes_isNULL==true)
			return NOT_FOUND;
		value = SupportedURISchemes;
		return OK;
	}
	
	int setSupportedURISchemes(const vector<unsigned short>& newValue) {
		SupportedURISchemes = newValue;
		SupportedURISchemes_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SOFTWAREINSTALLATIONSERVICECAPABILITIES_H_*/
