/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "cmpiOpenDRIM_SSHSessionSettingData.h"

CMPIObjectPath* SSH_OpenDRIM_SSHSessionSettingData_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_SSHSessionSettingData& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_SSHSessionSettingData_classnames[0], OpenDRIM_SSHSessionSettingData_NAMESPACE);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	if (!instance.SettingData_isNULL)
		op.addKey("SettingData", instance.SettingData);

	_L_;
	return op.getHdl();
}

CMPIInstance* SSH_OpenDRIM_SSHSessionSettingData_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_SSHSessionSettingData& instance) {
	_E_;
	Objectpath op(broker, SSH_OpenDRIM_SSHSessionSettingData_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.IsDefault_isNULL)
		ci.setProperty("IsDefault", instance.IsDefault);

	if (!instance.IsCurrent_isNULL)
		ci.setProperty("IsCurrent", instance.IsCurrent);

	if (!instance.IsNext_isNULL)
		ci.setProperty("IsNext", instance.IsNext);

	if (!instance.IsMinimum_isNULL)
		ci.setProperty("IsMinimum", instance.IsMinimum);

	if (!instance.IsMaximum_isNULL)
		ci.setProperty("IsMaximum", instance.IsMaximum);

	if (!instance.IsPending_isNULL)
		ci.setProperty("IsPending", instance.IsPending);

	_L_;
	return ci.getHdl();
}

void SSH_OpenDRIM_SSHSessionSettingData_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_SSHSessionSettingData& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_SSHSessionSettingData_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_SSHSessionSettingData& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	if (inst.getProperty("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (inst.getProperty("IsDefault", instance.IsDefault) == OK)
		instance.IsDefault_isNULL = false;

	if (inst.getProperty("IsCurrent", instance.IsCurrent) == OK)
		instance.IsCurrent_isNULL = false;

	if (inst.getProperty("IsNext", instance.IsNext) == OK)
		instance.IsNext_isNULL = false;

	if (inst.getProperty("IsMinimum", instance.IsMinimum) == OK)
		instance.IsMinimum_isNULL = false;

	if (inst.getProperty("IsMaximum", instance.IsMaximum) == OK)
		instance.IsMaximum_isNULL = false;

	if (inst.getProperty("IsPending", instance.IsPending) == OK)
		instance.IsPending_isNULL = false;

	_L_;
}

