#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Good Snowman is Hard to Build
# send your bug reports to contact@dotslashplay.it
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='a-good-snowman-is-hard-to-build'
GAME_NAME='A Good Snowman is Hard to Build'

## This installer used to be sold from humblebundle.com,
## but they now sell Steam keys only.
ARCHIVE_BASE_0_NAME='snowman-linux-1.0.8.tar.gz'
ARCHIVE_BASE_0_MD5='4461dfdcaba9e8793e3044b458b0e301'
ARCHIVE_BASE_0_SIZE='120000'
ARCHIVE_BASE_0_VERSION='1.0.8-humble160421'

CONTENT_PATH_DEFAULT='snowman'
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/bin32"
CONTENT_LIBS_BIN32_FILES='
lime-legacy.ndll
regexp.dso
std.dso
zlib.dso'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/bin64"
CONTENT_LIBS_BIN64_FILES='
lime-legacy.ndll
regexp.dso
std.dso
zlib.dso'
CONTENT_GAME_BIN32_FILES='
bin32/Snowman'
CONTENT_GAME_BIN64_FILES='
bin64/Snowman'
CONTENT_GAME_DATA_FILES='
atlases
crashdumper
fonts
libraries
manifest
music
resources
sounds
spritesheets
strings'

APP_MAIN_EXE_BIN32='bin32/Snowman'
APP_MAIN_EXE_BIN64='bin64/Snowman'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN64_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# The game engine is looking for lime-legacy.ndll in a hardcoded path

libraries_source=$(path_libraries)
for libraries_destination in \
	"$(package_path 'PKG_BIN32')$(path_game_data)" \
	"$(package_path 'PKG_BIN64')$(path_game_data)"
do
	mkdir --parents "$libraries_destination"
	ln --symbolic \
		"${libraries_source}/lime-legacy.ndll" \
		"$libraries_destination"
done

# Check for the presence of optional extra archives

ARCHIVE_OPTIONAL_ICONS_0_NAME='a-good-snowman-is-hard-to-build_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_0_MD5='8d595a7758ae8cd6dbc441ab79579fb4'
ARCHIVE_OPTIONAL_ICONS_0_URL='https://downloads.dotslashplay.it/games/a-good-snowman-is-hard-to-build/'
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS_0'

# Extract game data

archive_extraction_default
if archive_is_available 'ARCHIVE_ICONS'; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

if archive_is_available 'ARCHIVE_ICONS'; then
	CONTENT_ICONS_DATA_PATH='.'
	CONTENT_ICONS_DATA_FILES='
	16x16
	24x24
	32x32
	40x40
	48x48
	64x64
	96x96
	128x128
	256x256
	512x512
	768x768'
	content_inclusion 'ICONS_DATA' 'PKG_DATA' "$(path_icons)"
fi
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN32'
launchers_write
set_current_package 'PKG_BIN64'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
