#include "SDL_opengl.h"
#include "weapon.h"


#include <iostream>

namespace models {

static GLuint weapon_dl=0;

void weapon::draw() {
	dldraw();
}
void weapon::dldraw() {
	if (weapon_dl==0) { sdraw(); return; }
	glCallList(weapon_dl);
}

void weapon::gen_dl() {
	weapon_dl=glGenLists(1);
	glNewList(weapon_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded weapon " << weapon_dl << std::endl;
}
namespace mtl_weapon {
typedef enum MTL {
m_core,
m_display,
m_hull,
m_stripe,
m_last
};
} //namespace
void weapon::material (int id) {
	switch (id) {
		case mtl_weapon::m_core:
static const GLfloat m_core_diffuse[] = {1.00000,0.113333,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_core_diffuse);
static const GLfloat m_core_ambient[] = {1.00000,0.126667,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_core_ambient);
static const GLfloat m_core_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_core_emissive);
			break;
		case mtl_weapon::m_display:
static const GLfloat m_display_diffuse[] = {1.00000,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_display_diffuse);
static const GLfloat m_display_ambient[] = {1.00000,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_display_ambient);
static const GLfloat m_display_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_display_emissive);
			break;
		case mtl_weapon::m_hull:
static const GLfloat m_hull_diffuse[] = {0.926740,0.926740,0.926740};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_hull_diffuse);
static const GLfloat m_hull_ambient[] = {0.940060,0.940060,0.940060};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_hull_ambient);
static const GLfloat m_hull_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_hull_emissive);
			break;
		case mtl_weapon::m_stripe:
static const GLfloat m_stripe_diffuse[] = {1.00000,0.580000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_stripe_diffuse);
static const GLfloat m_stripe_ambient[] = {1.00000,0.820000,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_stripe_ambient);
static const GLfloat m_stripe_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_stripe_emissive);
			break;
	}
}
void weapon::sdraw() {
const float vertices[148][3]={
	{9.7502650e-2,4.5588738e-2,0.26070391},
	{7.6708854e-2,7.6708854e-2,0.26070391},
	{4.5224029e-2,9.6936003e-2,0.25790117},
	{-4.5224029e-2,9.6936003e-2,0.25790117},
	{-7.6708854e-2,7.6708854e-2,0.26070391},
	{-9.7502650e-2,4.5588738e-2,0.26070391},
	{-9.7502650e-2,-4.5588738e-2,0.26070391},
	{-7.6708854e-2,-7.6708854e-2,0.26070391},
	{-4.5588738e-2,-9.7502650e-2,0.26070391},
	{4.5588738e-2,-9.7502650e-2,0.26070391},
	{7.6708854e-2,-7.6708854e-2,0.26070391},
	{9.7502650e-2,-4.5588738e-2,0.26070391},
	{4.2214927e-2,2.3239949e-2,-0.16097364},
	{3.2309906e-2,3.7084078e-2,-0.15567379},
	{1.7485995e-2,4.8582854e-2,-0.13288343},
	{-1.7485995e-2,4.8582854e-2,-0.13288343},
	{-3.2309906e-2,3.7084078e-2,-0.15567379},
	{-4.2214927e-2,2.3239949e-2,-0.16097364},
	{-0.10328973,-4.2784008e-2,-9.0861901e-2},
	{-7.9054538e-2,-7.9054538e-2,-9.0861901e-2},
	{-4.2784008e-2,-0.10328973,-9.0861901e-2},
	{4.2784008e-2,-0.10328973,-9.0861901e-2},
	{7.9054538e-2,-7.9054538e-2,-9.0861901e-2},
	{0.10328973,-4.2784008e-2,-9.0861901e-2},
	{7.5347002e-2,3.6411569e-2,0.26070391},
	{7.5347002e-2,-3.6411569e-2,0.26070391},
	{5.9751655e-2,-5.9751655e-2,0.26070391},
	{3.6411569e-2,-7.5347002e-2,0.26070391},
	{-3.6411569e-2,-7.5347002e-2,0.26070391},
	{-5.9751655e-2,-5.9751655e-2,0.26070391},
	{-7.5347002e-2,-3.6411569e-2,0.26070391},
	{-7.5347002e-2,3.6411569e-2,0.26070391},
	{-5.9751655e-2,5.9751655e-2,0.26070391},
	{-3.6120276e-2,7.5313954e-2,0.26111931},
	{3.6120276e-2,7.5313954e-2,0.26111931},
	{5.9751655e-2,5.9751655e-2,0.26070391},
	{6.2347002e-2,3.6411569e-2,0.18084846},
	{6.2347002e-2,-3.6411569e-2,0.18084846},
	{4.6751655e-2,-5.9751655e-2,0.18084846},
	{3.6411569e-2,-7.5347002e-2,0.18084846},
	{-3.6411569e-2,-7.5347002e-2,0.18084846},
	{-4.6751655e-2,-5.9751655e-2,0.18084846},
	{-6.2347002e-2,-3.6411569e-2,0.18084846},
	{-6.2347002e-2,3.6411569e-2,0.18084846},
	{-4.6751655e-2,5.9751655e-2,0.18084846},
	{-3.6411569e-2,7.5347002e-2,0.18084846},
	{3.6411569e-2,7.5347002e-2,0.18084846},
	{4.6751655e-2,5.9751655e-2,0.18084846},
	{-1.3156082e-2,-6.7084917e-2,0.36455348},
	{1.3156082e-2,-6.7084917e-2,0.36455348},
	{1.7541443e-2,-7.7672114e-2,0.36455348},
	{-1.7541443e-2,-7.7672114e-2,0.36455348},
	{6.5084917e-2,-1.3156082e-2,0.36455348},
	{6.5084917e-2,1.3156082e-2,0.36455348},
	{7.5672114e-2,1.7541443e-2,0.36455348},
	{7.5672114e-2,-1.7541443e-2,0.36455348},
	{-6.5084917e-2,1.3156082e-2,0.36455348},
	{-6.5084917e-2,-1.3156082e-2,0.36455348},
	{-7.5672114e-2,-1.7541443e-2,0.36455348},
	{-7.5672114e-2,1.7541443e-2,0.36455348},
	{1.3050834e-2,6.7117965e-2,0.36413808},
	{-1.3050834e-2,6.7117965e-2,0.36413808},
	{-1.7541443e-2,7.7672114e-2,0.36455348},
	{1.7541443e-2,7.7672114e-2,0.36455348},
	{-5.8980598e-17,-0.14293888,0.38219193},
	{-5.0140021e-17,-3.2515057e-2,-0.18231795},
	{4.2214927e-2,6.9096857e-3,-0.16722524},
	{9.7502650e-2,1.4384327e-17,0.38219193},
	{-4.2214927e-2,6.9096857e-3,-0.16722524},
	{-9.7502650e-2,8.0505047e-17,0.38219193},
	{-3.7378229e-17,4.8582854e-2,-0.13288343},
	{-3.1305368e-17,0.14200875,0.37841729},
	{-5.8980598e-17,-7.7672114e-2,0.36455348},
	{7.5672114e-2,4.5102810e-17,0.36455348},
	{-7.5672114e-2,8.6736174e-17,0.36455348},
	{-3.4694470e-17,7.7672114e-2,0.36455348},
	{5.6359558e-2,-3.0651790e-2,0.18084846},
	{4.6062470e-2,-4.6062470e-2,0.18084846},
	{3.0651790e-2,-5.6359558e-2,0.18084846},
	{-3.0651790e-2,-5.6359558e-2,0.18084846},
	{-4.6062470e-2,-4.6062470e-2,0.18084846},
	{-5.6359558e-2,-3.0651790e-2,0.18084846},
	{-5.6359558e-2,3.0651790e-2,0.18084846},
	{-4.6062470e-2,4.6062470e-2,0.18084846},
	{-3.0651790e-2,5.6359558e-2,0.18084846},
	{3.0651790e-2,5.6359558e-2,0.18084846},
	{4.6062470e-2,4.6062470e-2,0.18084846},
	{5.6359558e-2,3.0651790e-2,0.18084846},
	{5.6359558e-2,-3.0651790e-2,0.46956530},
	{4.6062470e-2,-4.6062470e-2,0.46956530},
	{3.0651790e-2,-5.6359558e-2,0.46956530},
	{-3.0651790e-2,-5.6359558e-2,0.46956530},
	{-4.6062470e-2,-4.6062470e-2,0.46956530},
	{-5.6359558e-2,-3.0651790e-2,0.46956530},
	{-5.6359558e-2,3.0651790e-2,0.46956530},
	{-4.6062470e-2,4.6062470e-2,0.46956530},
	{-3.0651790e-2,5.6359558e-2,0.46956530},
	{3.0651790e-2,5.6359558e-2,0.46956530},
	{4.6062470e-2,4.6062470e-2,0.46956530},
	{5.6359558e-2,3.0651790e-2,0.46956530},
	{2.9983285e-2,-2.2650636e-2,0.46956530},
	{2.7046237e-2,-2.7046237e-2,0.46956530},
	{2.2650636e-2,-2.9983285e-2,0.46956530},
	{-2.2650636e-2,-2.9983285e-2,0.46956530},
	{-2.7046237e-2,-2.7046237e-2,0.46956530},
	{-2.9983285e-2,-2.2650636e-2,0.46956530},
	{-2.9983285e-2,2.2650636e-2,0.46956530},
	{-2.7046237e-2,2.7046237e-2,0.46956530},
	{-2.2650636e-2,2.9983285e-2,0.46956530},
	{2.2650636e-2,2.9983285e-2,0.46956530},
	{2.7046237e-2,2.7046237e-2,0.46956530},
	{2.9983285e-2,2.2650636e-2,0.46956530},
	{2.9983285e-2,-2.2650636e-2,0.39101642},
	{2.7046237e-2,-2.7046237e-2,0.39101642},
	{2.2650636e-2,-2.9983285e-2,0.39101642},
	{-2.2650636e-2,-2.9983285e-2,0.39101642},
	{-2.7046237e-2,-2.7046237e-2,0.39101642},
	{-2.9983285e-2,-2.2650636e-2,0.39101642},
	{-2.9983285e-2,2.2650636e-2,0.39101642},
	{-2.7046237e-2,2.7046237e-2,0.39101642},
	{-2.2650636e-2,2.9983285e-2,0.39101642},
	{2.2650636e-2,2.9983285e-2,0.39101642},
	{2.7046237e-2,2.7046237e-2,0.39101642},
	{2.9983285e-2,2.2650636e-2,0.39101642},
	{1.0553732e-2,-2.2658872e-2,-0.17854477},
	{2.1107463e-2,-1.2802686e-2,-0.17477159},
	{3.1661195e-2,-2.9465000e-3,-0.17099842},
	{-3.1661195e-2,-2.9465000e-3,-0.17099842},
	{-2.1107463e-2,-1.2802686e-2,-0.17477159},
	{-1.0553732e-2,-2.2658872e-2,-0.17854477},
	{-4.3905900e-2,-0.11989090,3.3886864e-2},
	{4.3905900e-2,-0.11989090,3.3886864e-2},
	{-6.0715322e-17,-0.11903808,6.9310295e-2},
	{-4.3905900e-2,-0.19222265,3.2352015e-3},
	{4.3905900e-2,-0.19222265,3.2352015e-3},
	{-9.4175642e-17,-0.21028583,3.8658632e-2},
	{-7.7445482e-17,-0.16466196,4.6045684e-2},
	{-5.8980598e-17,-0.11989090,8.0624132e-3},
	{-9.3675068e-17,-0.19222265,-2.2589249e-2},
	{-6.2450045e-17,-0.10328973,-9.0861901e-2},
	{5.4631210e-2,5.7005196e-2,5.3657601e-2},
	{7.1913767e-2,7.2429378e-2,0.21573512},
	{3.1431125e-2,7.2892110e-2,6.3581185e-2},
	{4.2228321e-2,9.1713863e-2,0.21569644},
	{5.2123470e-2,8.5285701e-2,0.21570933},
	{6.2018618e-2,7.8857540e-2,0.21572222},
	{3.9164487e-2,6.7596472e-2,6.0273323e-2},
	{4.6897849e-2,6.2300834e-2,5.6965462e-2},
};
const float normals[148][3]={
	{0.59671563,0.69350758,0.40370496},
	{0.51441140,0.55863203,0.65062368},
	{0.80801836,0.48291616,0.33748823},
	{-0.80386180,0.48892409,0.33876163},
	{-0.50616731,0.56498183,0.65160586},
	{-0.59671563,0.69350758,0.40370496},
	{-0.59943083,-0.61728702,0.50954825},
	{-0.53658716,-0.45278007,0.71208456},
	{-0.82494770,-0.39384293,0.40539984},
	{0.82494770,-0.39384293,0.40539984},
	{0.53658716,-0.45278007,0.71208456},
	{0.59943083,-0.61728702,0.50954825},
	{0.60046951,0.36489718,-0.71153807},
	{0.38362180,0.78466862,-0.48695941},
	{0.29642216,0.91997222,-0.25648589},
	{-0.30398269,0.91733018,-0.25709892},
	{-0.38977340,0.78140996,-0.48731425},
	{-0.60046951,0.36489718,-0.71153807},
	{-0.86649561,-0.22903522,-0.44354056},
	{-0.69908372,-0.60393238,-0.38281541},
	{-0.40855693,-0.78258291,-0.46972889},
	{0.40855693,-0.78258291,-0.46972889},
	{0.69908372,-0.60393238,-0.38281541},
	{0.86649561,-0.22903522,-0.44354056},
	{-0.91432710,0.10351211,0.39152419},
	{-0.91432710,-0.10351211,0.39152419},
	{-0.50944882,0.43510044,0.74239445},
	{6.9690110e-2,0.93554785,0.34625643},
	{-6.9690110e-2,0.93554785,0.34625643},
	{0.50944882,0.43510044,0.74239445},
	{0.91432710,-0.10351211,0.39152419},
	{0.91432710,0.10351211,0.39152419},
	{0.51275298,-0.41566252,0.75120507},
	{-7.5710533e-2,-0.93279047,0.35237742},
	{7.5710533e-2,-0.93279047,0.35237742},
	{-0.51275298,-0.41566252,0.75120507},
	{-0.60878751,-0.18507712,0.77144295},
	{-0.60878751,0.18507712,0.77144295},
	{-0.50944882,0.43510044,0.74239445},
	{-0.24471230,0.62494568,0.74132232},
	{0.24471230,0.62494568,0.74132232},
	{0.50944882,0.43510044,0.74239445},
	{0.60878751,0.18507712,0.77144295},
	{0.60878751,-0.18507712,0.77144295},
	{0.50844674,-0.43659506,0.74220393},
	{0.24335921,-0.62633521,0.74059470},
	{-0.24335921,-0.62633521,0.74059470},
	{-0.50844674,-0.43659506,0.74220393},
	{-0.45996034,0.69447719,0.55329732},
	{0.45996034,0.69447719,0.55329732},
	{0.59967601,0.14980010,0.78609708},
	{-0.59967601,0.14980010,0.78609708},
	{-0.69903210,-0.46396558,0.54414159},
	{-0.69903210,0.46396558,0.54414159},
	{-0.19888500,0.60144469,0.77376291},
	{-0.19888500,-0.60144469,0.77376291},
	{0.69903210,0.46396558,0.54414159},
	{0.69903210,-0.46396558,0.54414159},
	{0.19888500,-0.60144469,0.77376291},
	{0.19888500,0.60144469,0.77376291},
	{0.45604372,-0.70293695,0.54580562},
	{-0.45604372,-0.70293695,0.54580562},
	{-0.60074223,-0.13764910,0.78750334},
	{0.60074223,-0.13764910,0.78750334},
	{-1.6764709e-16,-0.54506830,0.83839165},
	{-4.4954332e-16,-0.42107182,-0.90702730},
	{0.64872520,0.18951951,-0.73704679},
	{0.55877247,0.14074258,0.81729117},
	{-0.64872520,0.18951951,-0.73704679},
	{-0.55877247,0.14074258,0.81729117},
	{5.8732298e-17,0.96324785,-0.26861418},
	{7.7896141e-17,0.63472503,0.77273808},
	{1.4984932e-16,0.17528243,0.98451819},
	{-0.44133393,0.0000000e+0,0.89734294},
	{0.44133393,0.0000000e+0,0.89734294},
	{0.0000000e+0,-0.15405628,0.98806207},
	{0.66160995,-0.20069718,0.72249077},
	{0.49512643,-0.49512643,0.71393252},
	{0.20069718,-0.66160995,0.72249077},
	{-0.20069718,-0.66160995,0.72249077},
	{-0.49512643,-0.49512643,0.71393252},
	{-0.66160995,-0.20069718,0.72249077},
	{-0.66160995,0.20069718,0.72249077},
	{-0.49512643,0.49512643,0.71393252},
	{-0.20069718,0.66160995,0.72249077},
	{0.20069718,0.66160995,0.72249077},
	{0.49512643,0.49512643,0.71393252},
	{0.66160995,0.20069718,0.72249077},
	{0.66160995,-0.20069718,0.72249077},
	{0.49512643,-0.49512643,0.71393252},
	{0.20069718,-0.66160995,0.72249077},
	{-0.20069718,-0.66160995,0.72249077},
	{-0.49512643,-0.49512643,0.71393252},
	{-0.66160995,-0.20069718,0.72249077},
	{-0.66160995,0.20069718,0.72249077},
	{-0.49512643,0.49512643,0.71393252},
	{-0.20069718,0.66160995,0.72249077},
	{0.20069718,0.66160995,0.72249077},
	{0.49512643,0.49512643,0.71393252},
	{0.66160995,0.20069718,0.72249077},
	{-0.66160995,0.20069718,0.72249077},
	{-0.49512643,0.49512643,0.71393252},
	{-0.20069718,0.66160995,0.72249077},
	{0.20069718,0.66160995,0.72249077},
	{0.49512643,0.49512643,0.71393252},
	{0.66160995,0.20069718,0.72249077},
	{0.66160995,-0.20069718,0.72249077},
	{0.49512643,-0.49512643,0.71393252},
	{0.20069718,-0.66160995,0.72249077},
	{-0.20069718,-0.66160995,0.72249077},
	{-0.49512643,-0.49512643,0.71393252},
	{-0.66160995,-0.20069718,0.72249077},
	{-0.84814448,0.25728182,0.46309503},
	{-0.62996790,0.62996790,0.45418155},
	{-0.25728182,0.84814448,0.46309503},
	{0.25728182,0.84814448,0.46309503},
	{0.62996790,0.62996790,0.45418155},
	{0.84814448,0.25728182,0.46309503},
	{0.84814448,-0.25728182,0.46309503},
	{0.62996790,-0.62996790,0.45418155},
	{0.25728182,-0.84814448,0.46309503},
	{-0.25728182,-0.84814448,0.46309503},
	{-0.62996790,-0.62996790,0.45418155},
	{-0.84814448,-0.25728182,0.46309503},
	{0.32051858,-7.8676343e-2,-0.94396921},
	{0.30142479,-6.2140168e-2,-0.95146292},
	{0.33805734,-9.8838314e-3,-0.94107361},
	{-0.33805734,-9.8838314e-3,-0.94107361},
	{-0.30142479,-6.2140168e-2,-0.95146292},
	{-0.32051858,-7.8676343e-2,-0.94396921},
	{-0.69253536,-0.70911913,0.13245693},
	{0.69253536,-0.70911913,0.13245693},
	{-1.5212907e-16,-0.86887814,0.49502603},
	{-0.75687819,-0.61147447,-0.23072575},
	{0.75687819,-0.61147447,-0.23072575},
	{-2.8947852e-16,-0.75806616,0.65217766},
	{-6.8706641e-17,-0.38225544,0.92405670},
	{-1.6839970e-16,-0.55912768,-0.82908156},
	{-8.6662520e-17,-0.14204933,-0.98985958},
	{-2.4307714e-16,-0.95037777,-0.31109822},
	{0.62455374,0.76826451,-0.14036475},
	{0.63791581,0.75720853,-0.14035194},
	{0.46477640,0.87346965,-0.14502990},
	{0.47989036,0.86518168,-0.14548508},
	{0.53407848,0.83389828,-0.13918996},
	{0.53430453,0.83393363,-0.13810633},
	{0.51953524,0.84308496,-0.13889161},
	{0.51976271,0.84312254,-0.13780820},
};
//o cylinder1
material(mtl_weapon::m_core);
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
glEnd();
/*material(mtl_weapon::m_display);
glBegin(GL_POLYGON);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
glEnd();*/
material(mtl_weapon::m_hull);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
material(mtl_weapon::m_stripe);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
}
} //namespace
