{- This module was generated from data in the Kate syntax
   highlighting file pascal.xml, version 1.23, by Unnamed people and Liu Sizhuang(oldherl@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Pascal
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Pascal"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.p;*.pas;*.pp"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Pascal","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Pascal","Normal") -> return ()
      ("Pascal","CharNum") -> (popContext) >> pEndLine
      ("Pascal","HexCharNum") -> (popContext) >> pEndLine
      ("Pascal","Hex") -> (popContext) >> pEndLine
      ("Pascal","String") -> (popContext) >> pEndLine
      ("Pascal","Prep1") -> (popContext) >> pEndLine
      ("Pascal","Prep2") -> (popContext) >> pEndLine
      ("Pascal","Comment1") -> return ()
      ("Pascal","Comment2") -> return ()
      ("Pascal","Comment3") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "and array asm case const div do downto else file for function goto if in label mod nil not of operator or packed procedure program record repeat set then to type unit until uses var while with xor at automated break continue dispinterface dispose exit false finalization initialization library new published resourcestring self true"
list_ISO'2fDelphi_Extended = Set.fromList $ words $ "abstract as bindable constructor destructor except export finally import implementation inherited inline interface is module on only otherwise override private property protected public read qualified raise restricted shl shr threadvar try virtual write"
list_types = Set.fromList $ words $ "integer cardinal shortint smallint longint int64 byte word longword dword qword char ansichar widechar boolean bytebool wordbool longbool single double extended comp currency real real48 string shortstring ansistring widestring pointer variant file text"
list_attention = Set.fromList $ words $ "fixme todo note ###"

regex_'5cb'28begin'7ccase'7crecord'29'28'3f'3d'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29 = compileRegex "\\b(begin|case|record)(?=(\\{[^}]*(\\}|$)|\\(\\*.*(\\*\\)|$))*([\\s]|$|//))"
regex_'5cb'28'28object'7cclass'29'28'3f'3d'28'5c'28'2e'2a'5c'29'29'3f'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'3b'3f'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29'7ctry'28'3f'3d'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29'29 = compileRegex "\\b((object|class)(?=(\\(.*\\))?(\\{[^}]*(\\}|$)|\\(\\*.*(\\*\\)|$))*;?([\\s]|$|//))|try(?=(\\{[^}]*(\\}|$)|\\(\\*.*(\\*\\)|$))*([\\s]|$|//)))"
regex_'5cbend'28'3f'3d'28'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'29'28'5b'2e'3b'5cs'5d'7c'24'29'7c'2f'2f'7c'24'29 = compileRegex "\\bend(?=((\\{[^}]*(\\}|$)|\\(\\*.*(\\*\\)|$))*)([.;\\s]|$)|//|$)"
regex_'5b'5e0'2d9'5d = compileRegex "[^0-9]"
regex_'5b'5ea'2dfA'2dF0'2d9'5d = compileRegex "[^a-fA-F0-9]"

parseRules ("Pascal","Normal") =
  (((pRegExpr regex_'5cb'28begin'7ccase'7crecord'29'28'3f'3d'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28'28object'7cclass'29'28'3f'3d'28'5c'28'2e'2a'5c'29'29'3f'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'3b'3f'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29'7ctry'28'3f'3d'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'28'5b'5cs'5d'7c'24'7c'2f'2f'29'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'28'3f'3d'28'28'5c'7b'5b'5e'7d'5d'2a'28'5c'7d'7c'24'29'7c'5c'28'5c'2a'2e'2a'28'5c'2a'5c'29'7c'24'29'29'2a'29'28'5b'2e'3b'5cs'5d'7c'24'29'7c'2f'2f'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_ISO'2fDelphi_Extended >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute DecValTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute BaseNTok) >>~ pushContext ("Pascal","Hex"))
   <|>
   ((pDetectChar False '#' >>= withAttribute StringTok) >>~ pushContext ("Pascal","CharNum"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Pascal","String"))
   <|>
   ((pString False "(*$" >>= withAttribute OtherTok) >>~ pushContext ("Pascal","Prep1"))
   <|>
   ((pDetect2Chars False '{' '$' >>= withAttribute OtherTok) >>~ pushContext ("Pascal","Prep2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute CommentTok) >>~ pushContext ("Pascal","Comment1"))
   <|>
   ((pDetect2Chars False '(' '*' >>= withAttribute CommentTok) >>~ pushContext ("Pascal","Comment2"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Pascal","Comment3"))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Pascal","CharNum") =
  (((pDetectChar False '$' >>= withAttribute BaseNTok) >>~ pushContext ("Pascal","HexCharNum"))
   <|>
   ((pRegExpr regex_'5b'5e0'2d9'5d >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","CharNum")) >> pDefault >>= withAttribute StringTok))

parseRules ("Pascal","HexCharNum") =
  (((pRegExpr regex_'5b'5ea'2dfA'2dF0'2d9'5d >>= withAttribute BaseNTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","HexCharNum")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("Pascal","Hex") =
  (((pRegExpr regex_'5b'5ea'2dfA'2dF0'2d9'5d >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Hex")) >> pDefault >>= withAttribute BaseNTok))

parseRules ("Pascal","String") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Pascal","Prep1") =
  (((pDetect2Chars False '*' ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Prep1")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Pascal","Prep2") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Prep2")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Pascal","Comment1") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attention >>= withAttribute AlertTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Comment1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pascal","Comment2") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attention >>= withAttribute AlertTok))
   <|>
   ((pDetect2Chars False '*' ')' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Comment2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Pascal","Comment3") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attention >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Pascal","Comment3")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("Pascal","Normal") <|> fail ("Unknown context" ++ show x)
