% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlyM.r
\name{plotlyM}
\alias{plotlyM}
\title{plotly Multiple}
\usage{
plotlyM(data, x = ~x, y = ~y, xhi = ~xhi, yhi = ~yhi,
  htext = NULL, multplot = NULL, strata = NULL, fitter = NULL,
  color = NULL, size = NULL, showpts = !length(fitter),
  rotate = FALSE, xlab = NULL, ylab = NULL, ylabpos = c("top",
  "y"), xlim = NULL, ylim = NULL, shareX = TRUE, shareY = FALSE,
  height = NULL, width = NULL, nrows = NULL, ncols = NULL,
  colors = NULL, alphaSegments = 1, alphaCline = 0.3, digits = 4,
  zeroline = TRUE)
}
\arguments{
\item{data}{input data frame}

\item{x}{formula specifying the x-axis variable}

\item{y}{formula for y-axis variable}

\item{xhi}{formula for upper x variable limits (\code{x} taken to be lower value)}

\item{yhi}{formula for upper y variable limit (\code{y} taken to be lower value)}

\item{htext}{formula for hovertext variable}

\item{multplot}{formula specifying a variable in \code{data} that when stratified on produces a separate plot}

\item{strata}{formula specifying an optional stratification variable}

\item{fitter}{a fitting such as \code{loess}}

\item{color}{\code{plotly} formula specifying a color variable or e.g. \code{~ I('black')}.  To keep colors constant over multiple plots you will need to specify an AsIs color when you don't have a variable representing color groups.}

\item{size}{\code{plotly} formula specifying a symbol size variable or AsIs}

\item{showpts}{if \code{fitter} is given, set to \code{TRUE} to show raw data points in addition to smooth fits}

\item{rotate}{set to \code{TRUE} to reverse the roles of \code{x} and \code{y}, for example to get horizontal dot charts with error bars}

\item{xlab}{x-axis label.  May contain html.}

\item{ylab}{a named vector of y-axis labels, possibly containing html (see example below).  The names of the vector must correspond to levels of the \code{multplot} variable.}

\item{ylabpos}{position of y-axis labels.  Default is on top left of plot.  Specify \code{ylabpos='y'} for usual y-axis placement.}

\item{xlim}{2-vector of x-axis limits, optional}

\item{ylim}{2-vector of y-axis limits, optional}

\item{shareX}{specifies whether x-axes should be shared when they align vertically over multiple plots}

\item{shareY}{specifies whether y-axes should be shared when they align horizontally over multiple plots}

\item{height}{height of the combined image in pixels}

\item{width}{width of the combined image in pixels}

\item{nrows}{the number of rows to produce using \code{subplot}}

\item{ncols}{the number of columns to produce using \code{subplot} (specify at most one of \code{nrows,ncols})}

\item{colors}{the color palette.  Leave unspecified to use the default \code{plotly} palette}

\item{alphaSegments}{alpha transparency for line segments (when \code{xhi} or \code{yhi} is not \code{NA})}

\item{alphaCline}{alpha transparency for lines used to connect points}

\item{digits}{number of significant digits to use in constructing hovertext}

\item{zeroline}{set to \code{FALSE} to suppress vertical line at x=0}
}
\value{
\code{plotly} object produced by \code{subplot}
}
\description{
Generates multiple plotly graphics, driven by specs in a data frame
}
\details{
Generates multiple \code{plotly} traces and combines them with \code{plotly::subplot}.  The traces are controlled by specifications in data frame \code{data} plus various arguments.  \code{data} must contain these variables: \code{x}, \code{y}, and \code{tracename} (if \code{color} is not an "AsIs" color such as \code{~ I('black')}), and can contain these optional variables: \code{xhi}, \code{yhi} (rows containing \code{NA} for both \code{xhi} and \code{yhi} represent points, and those with non-\code{NA} \code{xhi} or \code{yhi} represent segments, \code{connect} (set to \code{TRUE} for rows for points, to connect the symbols), \code{legendgroup} (see \code{plotly} documentation), and \code{htext} (hovertext).  If the \code{color} argument is given and it is not an "AsIs" color, the variable named in the \code{color} formula must also be in \code{data}.  Likewise for \code{size}.  If the \code{multplot} is given, the variable given in the formula must be in \code{data}.  If \code{strata} is present, another level of separate plots is generated by levels of \code{strata}, within levels of \code{multplot}.

If \code{fitter} is specified, x,y coordinates for an individual plot are
run through \code{fitter}, and a line plot is made instead of showing data points.
}
\examples{
\dontrun{
set.seed(1)
pts     <- expand.grid(v=c('y1', 'y2', 'y3'), x=1:4, g=c('a', 'b'), yhi=NA,
                       tracename='mean', legendgroup='mean',
                       connect=TRUE, size=4)

pts$y   <- round(runif(nrow(pts)), 2)

segs     <- expand.grid(v=c('y1', 'y2', 'y3'), x=1:4, g=c('a', 'b'),
                        tracename='limits', legendgroup='limits',
                        connect=NA, size=6)
segs$y   <- runif(nrow(pts))
segs$yhi <- segs$y + runif(nrow(pts), .05, .15)

z <- rbind(pts, segs)

xlab <- labelPlotmath('X<sub>12</sub>', 'm/sec<sup>2</sup>', html=TRUE)
ylab <- c(y1=labelPlotmath('Y1', 'cm', html=TRUE),
          y2='Y2',
          y3=labelPlotmath('Y3', 'mm', html=TRUE))

W=plotlyM(z, multplot=~v, color=~g, xlab=xlab, ylab=ylab, ncols=2,
          colors=c('black', 'blue'))

W2=plotlyM(z, multplot=~v, color=~I('black'), xlab=xlab, ylab=ylab,
           colors=c('black', 'blue'))
}
}
\author{
Frank Harrell
}
