///////
   //    Link.cc
   //    Link Class definitions
   //
   //    Class for links
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: Link.cc,v 1.18 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "Link.h"

   // Static variables initialization
      int Link::debug = 0;

///////
   //    Construction
///////

Link::Link()
:
IDUrlSrc(0),
IDUrlDest(0),
TagPosition(0),
AttrPosition(0),
Anchor(),
LinkType(Link_Normal),
LinkResult(Link_NotChecked),
LinkDomain(Link_Unknown)
{
   Reset();
}

///////
   //    Destruction
///////

Link::~Link ()
{
}

///////
   //    Reset the schedule content
///////

void Link::Reset()
{
   IDUrlSrc = 0;
   IDUrlDest = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Anchor.clear();
   LinkType = Link_Normal;
   LinkResult = Link_NotChecked;
   LinkDomain = Link_Unknown;
}


///////
   //    Output Link object
///////

ostream &operator<<( ostream &output, const Link &s)

{
   output << s.IDUrlSrc << " -> " << s.IDUrlDest;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Tag n.: " << s.TagPosition << " - Attribute n. "
      << s.AttrPosition << " - Anchor " << s.Anchor << ")";
   
   return output;
}


///////
   //    Managing the Link Type of the Link
///////

///////
   //    Converts the Link_Type value into the corresponding
   //    std::string value
///////

void Link::RetrieveLinkType(std::string &Type) const
{

   switch(GetLinkType())
   {
      case (Link_Normal):
         Type="Normal";
         break;
      case (Link_Direct):
         Type="Direct";
         break;
      case (Link_Redirection):
         Type="Redirection";
         break;
   }

}

///////
   //    Converts the Type string value
   //    into the corresponding Link_Type value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkType(const std::string& Type)
{

   if (Type == "Normal")
      SetLinkType (Link_Normal);
   else if (Type == "Direct")
      SetLinkType (Link_Direct);
   else if (Type == "Redirection")
      SetLinkType (Link_Redirection);
   else return 0;
   
   return 1;
}

///////
   //    Managing the result of the link
///////

///////
   //    Converts the Link_Result value into the corresponding
   //    std::string value
///////

void Link::RetrieveLinkResult(std::string &Result) const
{

   switch(GetLinkResult())
   {
      case (Link_NotChecked):
         Result="NotChecked";
         break;
      case (Link_NotRetrieved):
         Result="NotRetrieved";
         break;
      case (Link_OK):
         Result="OK";
         break;
      case (Link_Broken):
         Result="Broken";
         break;
      case (Link_Redirected):
         Result="Redirected";
         break;
      case (Link_AnchorNotFound):
         Result="AnchorNotFound";
         break;
      case (Link_NotAuthorized):
         Result="NotAuthorized";
         break;
      case (Link_EMail):
         Result="EMail";
         break;
      case (Link_Javascript):
         Result="Javascript";
         break;
      case (Link_BadEncoded):
         Result="BadEncoded";
         break;
   }

}

///////
   //    Converts the Result string value
   //    into the corresponding Link_Result value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkResult(const std::string& Result)
{

   if (Result == "NotChecked")
      SetLinkResult (Link_NotChecked);
   else if (Result == "NotRetrieved")
      SetLinkResult (Link_NotRetrieved);
   else if (Result == "OK")
      SetLinkResult (Link_OK);
   else if (Result == "Broken")
      SetLinkResult (Link_Broken);
   else if (Result == "Redirected")
      SetLinkResult (Link_Redirected);
   else if (Result == "AnchorNotFound")
      SetLinkResult (Link_AnchorNotFound);
   else if (Result == "NotAuthorized")
      SetLinkResult (Link_NotAuthorized);
   else if (Result == "EMail")
      SetLinkResult (Link_EMail);
   else if (Result == "Javascript")
      SetLinkResult (Link_Javascript);
   else if (Result == "BadEncoded")
      SetLinkResult (Link_BadEncoded);
   else return 0;
   
   return 1;
}

///////
   //    Managing the domain of the link
///////

///////
   //    Converts the Link_Domain value into the corresponding
   //    std::string value
///////

void Link::RetrieveLinkDomain(std::string &Domain) const
{

   switch(GetLinkDomain())
   {
      case (Link_Unknown):
         Domain.clear();
         break;
      case (Link_SameServer):
         Domain="SameServer";
         break;
      case (Link_Internal):
         Domain="Internal";
         break;
      case (Link_External):
         Domain="External";
         break;
   }

}

///////
   //    Converts the Domain string value
   //    into the corresponding Link_Domain value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkDomain(const std::string& Domain)
{

   if (Domain.length() == 0)
      SetLinkDomain (Link_Unknown);
   else if (Domain == "SameServer")
      SetLinkDomain (Link_Unknown);
   else if (Domain == "Internal")
      SetLinkDomain (Link_Internal);
   else if (Domain == "External")
      SetLinkDomain (Link_External);
   else return 0;
   
   return 1;
}
