/*
 * @(#)ITFTestDataUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.autodoc.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestInfo;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;
import net.sourceforge.groboutils.autodoc.v1.testserver.DefaultTestInfo;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestDataUTestI;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the ITFTestData class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:04:45 $
 * @since     March 5, 2002
 */
public class ITFTestDataUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ITFTestDataUTest.class;
    //private static final IJUnitDocumentor LOG = (new JUnitLog(THIS_CLASS)).getDocumentor();
    
    public ITFTestDataUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    

    public void testConstructor1()
    {
        try
        {
            new ITFTestData( null );
            fail("Did not throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    
    public void testSetGetIssues1()
    {
        ITFTestData td = createTestData();
        
        td.addIssueID( "a" );
        String s[] = td.getIssues();
        
        assertNotNull(
            "returned null string array",
            s );
        assertEquals(
            "not right number of issues",
            s.length,
            1 );
        assertEquals(
            "not correct issue ID.",
            s[0],
            "a" );
        
        td.addIssueID( "a" );
        s = td.getIssues();
        
        assertNotNull(
            "returned null string array",
            s );
        assertEquals(
            "not right number of issues",
            s.length,
            1 );
        assertEquals(
            "not correct issue ID.",
            s[0],
            "a" );
        
        td.addIssueID( "b" );
        s = td.getIssues();
        
        assertNotNull(
            "returned null string array",
            s );
        assertEquals(
            "not right number of issues",
            s.length,
            2 );
        assertEquals(
            "not correct issue ID.",
            s[0],
            "a" );
        assertEquals(
            "not correct issue ID.",
            s[1],
            "b" );
    }
    
    
    public void testAddGetErrors1()
    {
        ITFTestData td = createTestData();
        Throwable t1 = new Throwable("ignore");
        td.addError( t1 );
        
        Throwable t[] = td.getErrors();
        
        assertNotNull(
            "returned null errors.",
            t );
        assertEquals(
            "not right amount of errors.",
            t.length,
            1 );
        assertEquals(
            "not right error.",
            t[0],
            t1 );
        
        td.addError( t1 );
        t = td.getErrors();
        assertNotNull(
            "returned null errors.",
            t );
        assertEquals(
            "not right amount of errors.",
            t.length,
            2 );
        assertEquals(
            "not right error.",
            t[0],
            t1 );
        assertEquals(
            "not right error.",
            t[1],
            t1 );
        
        Throwable t2 = new Throwable("ignore again");
        td.addError( t2 );
        t = td.getErrors();
        assertNotNull(
            "returned null errors.",
            t );
        assertEquals(
            "not right amount of errors.",
            t.length,
            3 );
        assertEquals(
            "not right error.",
            t[0],
            t1 );
        assertEquals(
            "not right error.",
            t[1],
            t1 );
        assertEquals(
            "not right error.",
            t[2],
            t2 );
    }
    
    
    public void testAddGetFailures1()
    {
        ITFTestData td = createTestData();
        AssertionFailedError t1 = new AssertionFailedError("ignore");
        td.addFailure( t1 );
        
        AssertionFailedError t[] = td.getFailures();
        
        assertNotNull(
            "returned null failure.",
            t );
        assertEquals(
            "not right amount of failure.",
            t.length,
            1 );
        assertEquals(
            "not right failure.",
            t[0],
            t1 );
        
        td.addFailure( t1 );
        t = td.getFailures();
        assertNotNull(
            "returned null failure.",
            t );
        assertEquals(
            "not right amount of failure.",
            t.length,
            2 );
        assertEquals(
            "not right failure.",
            t[0],
            t1 );
        assertEquals(
            "not right failure.",
            t[1],
            t1 );
        
        AssertionFailedError t2 = new AssertionFailedError("ignore again");
        td.addFailure( t2 );
        t = td.getFailures();
        assertNotNull(
            "returned null failure.",
            t );
        assertEquals(
            "not right amount of failure.",
            t.length,
            3 );
        assertEquals(
            "not right failure.",
            t[0],
            t1 );
        assertEquals(
            "not right failure.",
            t[1],
            t1 );
        assertEquals(
            "not right failure.",
            t[2],
            t2 );
    }
    
    
    public void testAddGetTests1()
    {
        ITFTestData td = createTestData();
        
        assertEquals(
            "Not right number of initial TCs found.",
            td.getTestCount(),
            0 );
        
        td.addTest();
        assertEquals(
            "Not right number of TCs found.",
            td.getTestCount(),
            1 );
        
        td.addTest();
        td.addTest();
        td.addTest();
        assertEquals(
            "Not right number of TCs found.",
            td.getTestCount(),
            4 );
    }
    
    
    public void testTimes1()
    {
        ITFTestData td = createTestData();
        
        assertEquals(
            "Initial runtime is incorrect.",
            td.getRunTime(),
            -1 );
    }
    
    
    public void testTimes2()
    {
        ITFTestData td = createTestData();
        
        td.setStartTime( 0L );

        assertEquals(
            "Initial runtime is incorrect.",
            td.getRunTime(),
            -1 );
    }
    
    
    public void testTimes3()
    {
        ITFTestData td = createTestData();
        
        td.setEndTime( 0L );
        
        assertEquals(
            "Initial runtime is incorrect.",
            td.getRunTime(),
            -1 );
    }
    
    
    public void testTimes4()
    {
        ITFTestData td = createTestData();
        
        td.setStartTime( 0L );
        td.setEndTime( 0L );
        assertEquals(
            "0 runtime is incorrect.",
            td.getRunTime(),
            0 );
    }
    
    
    public void testTimes5()
    {
        ITFTestData td = createTestData();
        
        td.setStartTime( 0L );
        td.setEndTime( 100L );
        assertEquals(
            "runtime is incorrect.",
            td.getRunTime(),
            100L );
    }
    
    
    public void testGetSuccessCount1()
    {
        ITFTestData td = createTestData();
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            0 );
    }
    
    
    public void testGetSuccessCount2()
    {
        ITFTestData td = createTestData();
        
        td.addError( new Throwable() );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            0 );
    }
    
    
    public void testGetSuccessCount3()
    {
        ITFTestData td = createTestData();
        
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            0 );
    }
    
    
    public void testGetSuccessCount4()
    {
        ITFTestData td = createTestData();
        
        td.addError( new Throwable() );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            0 );
    }
    
    
    public void testGetSuccessCount5()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addError( new Throwable() );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            0 );
    }
    
    
    public void testGetSuccessCount6()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            1 );
    }
    
    
    public void testGetSuccessCount6a()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            4 );
    }
    
    
    public void testGetSuccessCount7()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        td.addError( new Throwable() );
        td.addError( new Throwable() );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            2 );
    }
    
    
    public void testGetSuccessCount8()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        td.addFailure( new AssertionFailedError( "ignore" ) );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            2 );
    }
    
    
    public void testGetSuccessCount9()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        td.addError( new Throwable() );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            2 );
    }
    
    
    public void testGetSuccessCount10()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        td.addError( new Throwable() );
        td.addError( new Throwable() );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            1 );
    }
    
    
    public void testGetSuccessCount11()
    {
        ITFTestData td = createTestData();
        
        td.addTest();
        td.addTest();
        td.addTest();
        td.addTest();
        td.addError( new Throwable() );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        td.addFailure( new AssertionFailedError( "ignore" ) );
        
        assertEquals(
            "number of successful TCs incorrect.",
            td.getSuccessCount(),
            1 );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected ITFTestData createTestData()
    {
        ITFTestData td = new ITFTestData( new DefaultTestInfo( "a", "b" ) );
        return td;
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = TestDataUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new ITFTestData( new DefaultTestInfo( "a", "b" ) );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

