/* fixedDepthSearcher2.h
 */
#ifndef _CHECKMATE_FIXED_DEPTH_SERCHER2_H
#define _CHECKMATE_FIXED_DEPTH_SERCHER2_H
#include "osl/checkmate/proofDisproof.h"
#include "osl/state/numEffectState.h"
#include "osl/move.h"
#include "osl/pieceStand.h"
#include "osl/misc/carray.h"
#include "osl/misc/align16New.h"

namespace osl
{
  class PieceStand;
  namespace container
  {
    class MoveVector;
  }
  namespace checkmate
  {
    /**
     * 深さ固定で，その深さまで depth first searchで読む詰将棋.
     * 深さ0で詰み状態かどうか(攻め手の手番の場合)，王手をかける手がないかを判定可能
     * 深さ1で通常の一手詰みを判定(攻め手の手番の場合)
     * 使うのは深さ3位まで?
     * 攻撃側の自殺手はmove generationはしない．
     * NumEffectState専用
     */
    class FixedDepthSearcher2
#if OSL_WORDSIZE == 32
      : public misc::Align16New
#endif
    {
    private:
      static const int MAXDEPTH=16;
      NumEffectState *original_state;
      CArray<NumEffectState,MAXDEPTH> states;
      int count;
    public:
      FixedDepthSearcher2() : original_state(0), count(0)
      {
      }
      explicit FixedDepthSearcher2(NumEffectState& s)
	: original_state(&s), count(0)
      {
      }
      void setState(NumEffectState& s)
      {
	original_state = &s;
      }
    private:
      void addCount()
      {
	count++; 
      }
    public:
      int getCount() const
      {
	return count; 
      }
    public:
      // private: Note: helper の都合
      template <Player P, bool SetPieces, bool HasGuide>
      const ProofDisproof attack(int depth, Move& best_move, PieceStand& proof_pieces);
      template <Player P, bool SetPieces, bool HasGuide>
      const ProofDisproof attackMayUnsafe(int depth, Move& best_move, PieceStand& proof_pieces);
      template <Player P, bool SetPieces>
      const ProofDisproof defense(Move last_move,int depth,
				  PieceStand& proof_pieces);
    private:
      /**
       * move を作らずに ProofDisproof の予測を計算する
       */
      template <Player P, bool SetPieces>
      const ProofDisproof defenseEstimation(int depth,Move last_move, PieceStand& proof_pieces,
					    Piece attacker_piece,
					    Square target_position) const;
    public:      
      /**
       * stateがPから詰む局面かを返す.
       * stateの手番はPと一致しているという前提
       */
      template <Player P>
      const ProofDisproof hasCheckmateMove(int depth, Move& best_move,
					   PieceStand& proof_pieces)
      {
	states[depth].copyFrom(*original_state);
	return attack<P,true,false>(depth, best_move, proof_pieces);
      }
      /**
       * guide を最初に試す．
       * guide.isNormal() である必要はあるが，その局面でvalid でなくても良い
       */
      template <Player P>
      const ProofDisproof hasCheckmateWithGuide(int depth, Move& guide,
						PieceStand& proof_pieces);
      template <Player P>
      const ProofDisproof hasCheckmateMove(int depth,Move& best_move)
      {
	PieceStand proof_pieces;
	states[depth].copyFrom(*original_state);
	return attack<P,false,false>(depth, best_move, proof_pieces);
      }
      template <Player P>
      const ProofDisproof hasCheckmateMove(int depth)
      {
	Move checkmate_move;
	return hasCheckmateMove<P>(depth, checkmate_move);
      }
      
      /**
       * stateがPによって詰んでいる局面かを返す.
       * 王手がかかっていない時には呼ばない
       * stateの手番はalt(P)と一致しているという前提
       * stateはPによって王手がかかっているという前提
       * @param last_move 打ち歩詰めの判定に必要
       */
      template <Player P>
      const ProofDisproof hasEscapeMove(Move last_move,int depth,
					PieceStand& proof_pieces)
      {
	return defense<P,true>(last_move, depth, proof_pieces);
      }
      template <Player P>
      const ProofDisproof hasEscapeMove(Move last_move,int depth)
      {
	PieceStand proof_pieces;
	return defense<P,false>(last_move, depth, proof_pieces);
      }
      /**
       * next_move を指して逃げられるかどうかを調べる
       * @param check_move 詰の場合の攻撃側の指手
       * @param depth next_move を指した後からカウント
       */
      template <Player P>
      const ProofDisproof hasEscapeByMove(Move next_move, int depth,
					  Move& check_move,
					  PieceStand& proof_pieces);
      template <Player P>
      const ProofDisproof hasEscapeByMove(Move next_move, int depth);

      const ProofDisproof hasCheckmateMoveOfTurn(int depth,Move& best_move);
      const ProofDisproof hasCheckmateMoveOfTurn(int depth,Move& best_move,
						 PieceStand& proof_pieces);
      const ProofDisproof hasCheckmateWithGuideOfTurn(int depth, Move& guide,
						      PieceStand& proof_pieces);
      const ProofDisproof hasEscapeMoveOfTurn(Move last_move,int depth);
      const ProofDisproof hasEscapeByMoveOfTurn(Move next_move, int depth,
						Move& check_move,
						PieceStand& proof_pieces);
      const ProofDisproof hasEscapeByMoveOfTurn(Move next_move, int depth);

      /**
       * 無駄合をなるべく生成しない，合駒生成
       */
      template <Player Defense>
      void generateBlockingWhenLiberty0(int depth,Piece defense_king, Square attack_from,
					container::MoveVector& moves) const;
      template <Player Defense>
      int blockEstimation(Square attack_from, Square defense_king) const;
    };
  } // namespace checkmate
} // namespace osl

#endif /* _CHECKMATE_FIXED_DEPTH_SERCHER2_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
