/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */


#define __GLOBAL_H__

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif

/* shared area */
void *shared_area;

/* streaming execution child process pid */
int pid;

/* the command to stream */
char theorur_cmd[1024];

/* file descriptor used by darkice output pipe */
int theorur_output_fd;

/* the user home */
char home[64];
char theorur_cfg[64];
char theorur_temp[64];
char show_detail;
char reconnect_flag;

/* main window Widgets */
GtkWidget *window;
GtkWidget *button_start;
GtkWidget *button_stop;
GtkWidget *button_detail;
GtkWidget *label_status;
GtkWidget *table;

/* About Dialog box */
GtkWidget *dialog_about;
GtkWidget *label_about;
GtkWidget *button_about;

/* theorurcmds not found dialog box */
GtkWidget *dialog_theorurdep;
GtkWidget *label_theorurdep;
GtkWidget *button_theorurdep;

/* "kill streaming?" dialog box */
GtkWidget *dialog_theorurkill;
GtkWidget *label_theorurkill;
GtkWidget *button_yes_theorurkill;
GtkWidget *button_no_theorurkill;
GtkWidget *button_cancel_theorurkill;

/* menu stuff */
GtkWidget *menu_bar;
GtkWidget *menu_file;
GtkWidget *menu_item_file;
GtkWidget *menu_item_open;
GtkWidget *menu_item_save; 
GtkWidget *menu_item_quit_nd;
GtkWidget *menu_item_quit;
GtkWidget *menu_help;
GtkWidget *menu_item_help;
GtkWidget *menu_item_about;
GtkWidget *vbox;

/* open and save file selectors */
GtkWidget *file_open;
GtkWidget *file_save;
GtkWidget *file_localdump_enc;
GtkWidget *file_localdump_raw;

/* checkbuttons */
GtkWidget *checkbutton_adddate;
GtkWidget *checkbutton_reconnect;

/* notebook stuff */
GtkWidget *notebook;
GtkWidget *label_notebook_server;
GtkWidget *table_server;
GtkWidget *label_notebook_av;
GtkWidget *table_av;
GtkWidget *label_notebook_description;
GtkWidget *table_description;

/* button + entry */
GtkWidget *button_localdump_enc;
GtkWidget *button_localdump_raw;
GtkWidget *entry_localdump_enc;
GtkWidget *entry_localdump_raw;

/* theorur configuration stuff - label + entry */
GtkWidget *label_server;
GtkWidget *entry_server;
GtkWidget *label_port;
GtkWidget *entry_port;
GtkWidget *label_mountpoint;
GtkWidget *entry_mountpoint;
GtkWidget *label_pass;
GtkWidget *entry_pass;
GtkWidget *label_streamname;
GtkWidget *entry_streamname;
GtkWidget *label_description;
GtkWidget *entry_description;
GtkWidget *label_url;
GtkWidget *entry_url;
GtkWidget *label_genre;
GtkWidget *entry_genre;

/* theorur configuration stuff - label + combo box */
GtkWidget *label_input;
GtkWidget *combo_input;
GList *glist_input;
GtkWidget *label_asamplerate;
GtkWidget *combo_asamplerate;
GList *glist_asamplerate;
GtkWidget *label_achannel;
GtkWidget *combo_achannel;
GList *glist_achannel;
GtkWidget *label_vfps;
GtkWidget *combo_vfps;
GList *glist_vfps;
GtkWidget *label_v4ldevice;
GtkWidget *combo_v4ldevice;
GList *glist_v4ldevice;
GtkWidget *label_adevice;
GtkWidget *combo_adevice;
GList *glist_adevice;
GtkWidget *label_vsize;
GtkWidget *combo_vsize;
GList *glist_vsize;
GtkWidget *label_public;
GtkWidget *combo_public;
GList *glist_public;
GtkWidget *label_aquality;
GtkWidget *combo_aquality;
GList *glist_aquality;
GtkWidget *label_vquality;
GtkWidget *combo_vquality;
GList *glist_vquality;


/* text view stuff */
GtkWidget *text;
GtkTextBuffer *buffer;
GtkTextTagTable *tag_table;
GtkTextTag *tag;

/* text view has to scroll */
GtkWidget *scroll_text;

/* The GTK ToolTips */
GtkTooltips *tooltip;
