int
TheseusLite(Cds *cds, int num, int len, double prec)
{
    int            i, outrnd, inrnd;
    Cds          **cdsa = NULL;
    Cds           *avecds = NULL;

    /* setup cdsA */
    CdsSetup(cdsa);
    CdsCpy(avecds, cdsa->cds[0]);

    /* The CEM algorithm */
    /* The outer loop:
       (1) First calculates the translations
       (2) Does inner loop -- calc rotations and average till convergence
       (3) Holding the superposition constant, calculates the covariance
           matrices and corresponding weight matrices */
    outrnd = 0;
    while(1)
    {
        ++outrnd;

        /* Estimate Translations: Find weighted center and translate all cds */
        CalcTransIp(cdsa);
        CenCdsIp(cdsa);

        /* Inner loop:
           (1) Calc rotations given weights/weight matrices
           (2) Rotate cds with new rotations
           (3) Recalculate average

           Loop till convergence, holding constant the variances, covariances, and translations */
        inrnd = 0;
        do
        {
            ++inrnd;

            /* find the optimal rotation matrices */
            CalcRots(cdsa);
            if (CheckOutConv(cdsa, inrnd, outrnd, prec) == 1)
                return(outrnd);

            /* rotate the scratch cds with new rotation matrix */
            RotCdsIp(cdsa);

            /* find global rmsd and average cds (both held in structure) */
            AveCds(cdsa, avecds);
        }
        while(CheckInConv(cdsa, outrnd, inrnd, prec) == 0);

        /* Holding the superposition constant, calculate the covariance
           matrix and corresponding weight matrix, looping till convergence. */
        CalcVars(cdsa, vars);
    }

    return(outrnd);
}