/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2014 Martin Brehm
                  2012-2014 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef FFGEN_H
#define FFGEN_H

#include "xobject.h"
#include "moltools.h"
#include "timestep.h"

class CFFAtomType : public CxObject
{
public:
	CFFAtomType() { }
	~CFFAtomType() { }
	int m_iRealElement;
	char m_sName[3];
	float m_fLJSigma;
	float m_fLJEpsilon;
};


class CFFBondType : public CxObject
{
public:
	CFFBondType() { }
	~CFFBondType() { }
	char m_sRealName[6];
	char m_sName[6];
	float m_fLength;
	float m_fK;
};


class CFFAngleType : public CxObject
{
public:
	CFFAngleType() { }
	~CFFAngleType() { }
	char m_sName[9];
	char m_sRealName[9];
	float m_fAngle;
	float m_fK;
};


class CFFDihedralType : public CxObject
{
public:
	CFFDihedralType() { }
	~CFFDihedralType() { }
	char m_sName[12];
	char m_sRealName[12];
	float m_fK;
	float m_fDih;
	int m_iN;
	int m_iA;
};


class CFFImproperType : public CxObject
{
public:
	CFFImproperType() { }
	~CFFImproperType() { }
	char m_sName[12];
	char m_sRealName[12];
	float m_fK;
	int m_iN;
	float m_fDihedral;
};


class CFFAtom : public CxObject
{
public:
	CFFAtom() { }
	~CFFAtom() { }
	float m_fCharge;
	int m_iOffset;
	int m_iType;
	int m_iLammpsMolecule;
	int m_iMoleculeType;
	int m_iMoleculeIndex;
	int m_iAtomIndex;
};


class CFFBond : public CxObject
{
public:
	CFFBond() { }
	~CFFBond() { }
	int m_iAtoms[2];
	int m_iType;
};


class CFFAngle : public CxObject
{
public:
	CFFAngle() { }
	~CFFAngle() { }
	int m_iAtoms[3];
	int m_iType;
};


class CFFDihedral : public CxObject
{
public:
	CFFDihedral() { }
	~CFFDihedral() { }
	int m_iAtoms[4];
	int m_iType;
};


class CFFImproper : public CxObject
{
public:
	CFFImproper() { }
	~CFFImproper() { }
	int m_iAtoms[4];
	int m_iType;
};


class CFFAtomNode : public CxObject
{
public:
	void RecHeader(int depth);
	CFFAtomNode();
	~CFFAtomNode();
	void REC_Parse(char *s, int depth);
	void REC_DumpTree(int depth, unsigned long bitmask, bool last);

	CxPtrArray m_paLabel;
	CxIntArray m_iaMultiplicity;
	CFFAtomNode *m_pParent;
	CxObArray m_oaChildren;
	char *m_sDefineType;

};


class CFFGen : public CxObject
{
public:
	void AssignParms();

	void InitFFParm();
	void AddAtomParm(const char *s, float sigma, float epsilon);
	void AddBondParm(const char *s1, const char *s2, float length, float k);
	void AddAngleParm(const char *s1, const char *s2, const char *s3, float angle, float k);
	void AddDihedralParm(const char *s1, const char *s2, const char *s3, const char *s4, float dih, int n, float k);
	void AddImproperParm(const char *s1, const char *s2, const char *s3, const char *s4, float dih, int n, float k);

	void RenderStructureFormulas();
	void ScanAtom(CSingleMolecule *sm, int o, int *ba);
	void Parse(CTimeStep *ts);
	CFFGen();
	~CFFGen();

	float m_fImproperTol;

	CDF *m_pImproperDF;

	CxObArray m_oaAtomParm;
	CxObArray m_oaBondParm;
	CxObArray m_oaAngleParm;
	CxObArray m_oaDihedralParm;
	CxObArray m_oaImproperParm;

	CxObArray m_oaAtomTypes;
	CxObArray m_oaBondTypes;
	CxObArray m_oaAngleTypes;
	CxObArray m_oaDihedralTypes;
	CxObArray m_oaImproperTypes;

	CxObArray m_oaAtoms;
	CxObArray m_oaBonds;
	CxObArray m_oaAngles;
	CxObArray m_oaDihedrals;
	CxObArray m_oaImpropers;
};

#endif
