"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import sys
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import tensorflow.core.framework.cost_graph_pb2
import tensorflow.core.framework.graph_pb2
import tensorflow.core.framework.step_stats_pb2
import tensorflow.core.protobuf.cluster_pb2
import tensorflow.core.protobuf.debug_pb2
import tensorflow.core.protobuf.rewriter_config_pb2
import tensorflow.tsl.protobuf.coordination_config_pb2
import tensorflow.tsl.protobuf.rpc_options_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GPUOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Experimental(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class VirtualDevices(google.protobuf.message.Message):
            """Configuration for breaking down a visible GPU into multiple "virtual"
            devices.
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            MEMORY_LIMIT_MB_FIELD_NUMBER: builtins.int
            PRIORITY_FIELD_NUMBER: builtins.int
            DEVICE_ORDINAL_FIELD_NUMBER: builtins.int
            @property
            def memory_limit_mb(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
                """Per "virtual" device memory limit, in MB. The number of elements in
                the list is the number of virtual devices to create on the
                corresponding visible GPU (see "virtual_devices" below).
                If empty, it will create single virtual device taking all available
                memory from the device.

                For the concept of "visible" and "virtual" GPU, see the comments for
                "visible_device_list" above for more information.
                """
            @property
            def priority(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
                """Priority values to use with the virtual devices. Use the cuda function
                cudaDeviceGetStreamPriorityRange to query for valid range of values for
                priority.

                On a P4000 GPU with cuda 10.1, the priority range reported was 0 for
                least priority and -1 for greatest priority.

                If this field is not specified, then the virtual devices will be
                created with the default. If this field has values set, then the size
                of this must match with the above memory_limit_mb.
                """
            @property
            def device_ordinal(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
                """Virtual Device ordinal number determines the device ID of the device.
                A Virtual device with a lower ordinal number always receives the a
                smaller device id. The phyiscal device id and location in the
                virtual device list is used to break ties.
                """
            def __init__(
                self,
                *,
                memory_limit_mb: collections.abc.Iterable[builtins.float] | None = ...,
                priority: collections.abc.Iterable[builtins.int] | None = ...,
                device_ordinal: collections.abc.Iterable[builtins.int] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["device_ordinal", b"device_ordinal", "memory_limit_mb", b"memory_limit_mb", "priority", b"priority"]) -> None: ...

        VIRTUAL_DEVICES_FIELD_NUMBER: builtins.int
        USE_UNIFIED_MEMORY_FIELD_NUMBER: builtins.int
        NUM_DEV_TO_DEV_COPY_STREAMS_FIELD_NUMBER: builtins.int
        COLLECTIVE_RING_ORDER_FIELD_NUMBER: builtins.int
        TIMESTAMPED_ALLOCATOR_FIELD_NUMBER: builtins.int
        KERNEL_TRACKER_MAX_INTERVAL_FIELD_NUMBER: builtins.int
        KERNEL_TRACKER_MAX_BYTES_FIELD_NUMBER: builtins.int
        KERNEL_TRACKER_MAX_PENDING_FIELD_NUMBER: builtins.int
        INTERNAL_FRAGMENTATION_FRACTION_FIELD_NUMBER: builtins.int
        USE_CUDA_MALLOC_ASYNC_FIELD_NUMBER: builtins.int
        DISALLOW_RETRY_ON_ALLOCATION_FAILURE_FIELD_NUMBER: builtins.int
        GPU_HOST_MEM_LIMIT_IN_MB_FIELD_NUMBER: builtins.int
        GPU_HOST_MEM_DISALLOW_GROWTH_FIELD_NUMBER: builtins.int
        @property
        def virtual_devices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GPUOptions.Experimental.VirtualDevices]:
            """The multi virtual device settings. If empty (not set), it will create
            single virtual device on each visible GPU, according to the settings
            in "visible_device_list" above. Otherwise, the number of elements in the
            list must be the same as the number of visible GPUs (after
            "visible_device_list" filtering if it is set), and the string represented
            device names (e.g. /device:GPU:<id>) will refer to the virtual
            devices and have the <id> field assigned sequentially starting from 0,
            according to the order of the virtual devices determined by
            device_ordinal and the location in the virtual device list.

            For example,
              visible_device_list = "1,0"
              virtual_devices { memory_limit: 1GB memory_limit: 2GB }
              virtual_devices { memory_limit: 3GB memory_limit: 4GB }
            will create 4 virtual devices as:
              /device:GPU:0 -> visible GPU 1 with 1GB memory
              /device:GPU:1 -> visible GPU 1 with 2GB memory
              /device:GPU:2 -> visible GPU 0 with 3GB memory
              /device:GPU:3 -> visible GPU 0 with 4GB memory

            but
              visible_device_list = "1,0"
              virtual_devices { memory_limit: 1GB memory_limit: 2GB
                                device_ordinal: 10 device_ordinal: 20}
              virtual_devices { memory_limit: 3GB memory_limit: 4GB
                                device_ordinal: 10 device_ordinal: 20}
            will create 4 virtual devices as:
              /device:GPU:0 -> visible GPU 1 with 1GB memory  (ordinal 10)
              /device:GPU:1 -> visible GPU 0 with 3GB memory  (ordinal 10)
              /device:GPU:2 -> visible GPU 1 with 2GB memory  (ordinal 20)
              /device:GPU:3 -> visible GPU 0 with 4GB memory  (ordinal 20)

            NOTE:
            1. It's invalid to set both this and "per_process_gpu_memory_fraction"
               at the same time.
            2. Currently this setting is per-process, not per-session. Using
               different settings in different sessions within same process will
               result in undefined behavior.
            """
        use_unified_memory: builtins.bool
        """If true, uses CUDA unified memory for memory allocations. If
        per_process_gpu_memory_fraction option is greater than 1.0, then unified
        memory is used regardless of the value for this field. See comments for
        per_process_gpu_memory_fraction field for more details and requirements
        of the unified memory. This option is useful to oversubscribe memory if
        multiple processes are sharing a single GPU while individually using less
        than 1.0 per process memory fraction.
        """
        num_dev_to_dev_copy_streams: builtins.int
        """If > 1, the number of device-to-device copy streams to create
        for each GPUDevice.  Default value is 0, which is automatically
        converted to 1.
        """
        collective_ring_order: builtins.str
        """If non-empty, defines a good GPU ring order on a single worker based on
        device interconnect.  This assumes that all workers have the same GPU
        topology.  Specify as a comma-separated string, e.g. "3,2,1,0,7,6,5,4".
        This ring order is used by the RingReducer implementation of
        CollectiveReduce, and serves as an override to automatic ring order
        generation in OrderTaskDeviceMap() during CollectiveParam resolution.
        """
        timestamped_allocator: builtins.bool
        """If true then extra work is done by GPUDevice and GPUBFCAllocator to
        keep track of when GPU memory is freed and when kernels actually
        complete so that we can know when a nominally free memory chunk
        is really not subject to pending use.
        """
        kernel_tracker_max_interval: builtins.int
        """reserved id: 6

        Parameters for GPUKernelTracker.  By default no kernel tracking is done.
        Note that timestamped_allocator is only effective if some tracking is
        specified.

        If kernel_tracker_max_interval = n > 0, then a tracking event
        is inserted after every n kernels without an event.
        """
        kernel_tracker_max_bytes: builtins.int
        """If kernel_tracker_max_bytes = n > 0, then a tracking event is
        inserted after every series of kernels allocating a sum of
        memory >= n.  If one kernel allocates b * n bytes, then one
        event will be inserted after it, but it will count as b against
        the pending limit.
        """
        kernel_tracker_max_pending: builtins.int
        """If kernel_tracker_max_pending > 0 then no more than this many
        tracking events can be outstanding at a time.  An attempt to
        launch an additional kernel will stall until an event
        completes.
        """
        internal_fragmentation_fraction: builtins.float
        """BFC Allocator can return an allocated chunk of memory upto 2x the
        requested size. For virtual devices with tight memory constraints, and
        proportionately large allocation requests, this can lead to a significant
        reduction in available memory. The threshold below controls when a chunk
        should be split if the chunk size exceeds requested memory size. It is
        expressed as a fraction of total available memory for the tf device. For
        example setting it to 0.05 would imply a chunk needs to be split if its
        size exceeds the requested memory by 5% of the total virtual device/gpu
        memory size.
        """
        use_cuda_malloc_async: builtins.bool
        """When true, use CUDA cudaMallocAsync API instead of TF gpu allocator."""
        disallow_retry_on_allocation_failure: builtins.bool
        """By default, BFCAllocator may sleep when it runs out of memory, in the
        hopes that another thread will free up memory in the meantime.  Setting
        this to true disables the sleep; instead we'll OOM immediately.
        """
        gpu_host_mem_limit_in_mb: builtins.float
        """Memory limit for "GPU host allocator", aka pinned memory allocator.  This
        can also be set via the envvar TF_GPU_HOST_MEM_LIMIT_IN_MB.
        """
        gpu_host_mem_disallow_growth: builtins.bool
        """If true, then the host allocator allocates its max memory all upfront and
        never grows.  This can be useful for latency-sensitive systems, because
        growing the GPU host memory pool can be expensive.

        You probably only want to use this in combination with
        gpu_host_mem_limit_in_mb, because the default GPU host memory limit is
        quite high.
        """
        def __init__(
            self,
            *,
            virtual_devices: collections.abc.Iterable[global___GPUOptions.Experimental.VirtualDevices] | None = ...,
            use_unified_memory: builtins.bool | None = ...,
            num_dev_to_dev_copy_streams: builtins.int | None = ...,
            collective_ring_order: builtins.str | None = ...,
            timestamped_allocator: builtins.bool | None = ...,
            kernel_tracker_max_interval: builtins.int | None = ...,
            kernel_tracker_max_bytes: builtins.int | None = ...,
            kernel_tracker_max_pending: builtins.int | None = ...,
            internal_fragmentation_fraction: builtins.float | None = ...,
            use_cuda_malloc_async: builtins.bool | None = ...,
            disallow_retry_on_allocation_failure: builtins.bool | None = ...,
            gpu_host_mem_limit_in_mb: builtins.float | None = ...,
            gpu_host_mem_disallow_growth: builtins.bool | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["collective_ring_order", b"collective_ring_order", "disallow_retry_on_allocation_failure", b"disallow_retry_on_allocation_failure", "gpu_host_mem_disallow_growth", b"gpu_host_mem_disallow_growth", "gpu_host_mem_limit_in_mb", b"gpu_host_mem_limit_in_mb", "internal_fragmentation_fraction", b"internal_fragmentation_fraction", "kernel_tracker_max_bytes", b"kernel_tracker_max_bytes", "kernel_tracker_max_interval", b"kernel_tracker_max_interval", "kernel_tracker_max_pending", b"kernel_tracker_max_pending", "num_dev_to_dev_copy_streams", b"num_dev_to_dev_copy_streams", "timestamped_allocator", b"timestamped_allocator", "use_cuda_malloc_async", b"use_cuda_malloc_async", "use_unified_memory", b"use_unified_memory", "virtual_devices", b"virtual_devices"]) -> None: ...

    PER_PROCESS_GPU_MEMORY_FRACTION_FIELD_NUMBER: builtins.int
    ALLOW_GROWTH_FIELD_NUMBER: builtins.int
    ALLOCATOR_TYPE_FIELD_NUMBER: builtins.int
    DEFERRED_DELETION_BYTES_FIELD_NUMBER: builtins.int
    VISIBLE_DEVICE_LIST_FIELD_NUMBER: builtins.int
    POLLING_ACTIVE_DELAY_USECS_FIELD_NUMBER: builtins.int
    POLLING_INACTIVE_DELAY_MSECS_FIELD_NUMBER: builtins.int
    FORCE_GPU_COMPATIBLE_FIELD_NUMBER: builtins.int
    EXPERIMENTAL_FIELD_NUMBER: builtins.int
    per_process_gpu_memory_fraction: builtins.float
    """Fraction of the total GPU memory to allocate for each process.
    1 means to allocate all of the GPU memory, 0.5 means the process
    allocates up to ~50% of the total GPU memory.

    GPU memory is pre-allocated unless the allow_growth option is enabled.

    If greater than 1.0, uses CUDA unified memory to potentially oversubscribe
    the amount of memory available on the GPU device by using host memory as a
    swap space. Accessing memory not available on the device will be
    significantly slower as that would require memory transfer between the host
    and the device. Options to reduce the memory requirement should be
    considered before enabling this option as this may come with a negative
    performance impact. Oversubscription using the unified memory requires
    Pascal class or newer GPUs and it is currently only supported on the Linux
    operating system. See
    https://docs.nvidia.com/cuda/cuda-c-programming-guide/index.html#um-requirements
    for the detailed requirements.
    """
    allow_growth: builtins.bool
    """If true, the allocator does not pre-allocate the entire specified
    GPU memory region, instead starting small and growing as needed.
    """
    allocator_type: builtins.str
    """The type of GPU allocation strategy to use.

    Allowed values:
    "": The empty string (default) uses a system-chosen default
        which may change over time.

    "BFC": A "Best-fit with coalescing" algorithm, simplified from a
           version of dlmalloc.
    """
    deferred_deletion_bytes: builtins.int
    """Delay deletion of up to this many bytes to reduce the number of
    interactions with gpu driver code.  If 0, the system chooses
    a reasonable default (several MBs).
    """
    visible_device_list: builtins.str
    """A comma-separated list of GPU ids that determines the 'visible'
    to 'virtual' mapping of GPU devices.  For example, if TensorFlow
    can see 8 GPU devices in the process, and one wanted to map
    visible GPU devices 5 and 3 as "/device:GPU:0", and "/device:GPU:1",
    then one would specify this field as "5,3".  This field is similar in
    spirit to the CUDA_VISIBLE_DEVICES environment variable, except
    it applies to the visible GPU devices in the process.

    NOTE:
    1. The GPU driver provides the process with the visible GPUs
       in an order which is not guaranteed to have any correlation to
       the *physical* GPU id in the machine.  This field is used for
       remapping "visible" to "virtual", which means this operates only
       after the process starts.  Users are required to use vendor
       specific mechanisms (e.g., CUDA_VISIBLE_DEVICES) to control the
       physical to visible device mapping prior to invoking TensorFlow.
    2. In the code, the ids in this list are also called "platform GPU id"s,
       and the 'virtual' ids of GPU devices (i.e. the ids in the device
       name "/device:GPU:<id>") are also called "TF GPU id"s. Please
       refer to third_party/tensorflow/core/common_runtime/gpu/gpu_id.h
       for more information.
    """
    polling_active_delay_usecs: builtins.int
    """In the event polling loop sleep this many microseconds between
    PollEvents calls, when the queue is not empty.  If value is not
    set or set to 0, gets set to a non-zero default.
    """
    polling_inactive_delay_msecs: builtins.int
    """This field is deprecated and ignored."""
    force_gpu_compatible: builtins.bool
    """Force all tensors to be gpu_compatible. On a GPU-enabled TensorFlow,
    enabling this option forces all CPU tensors to be allocated with Cuda
    pinned memory. Normally, TensorFlow will infer which tensors should be
    allocated as the pinned memory. But in case where the inference is
    incomplete, this option can significantly speed up the cross-device memory
    copy performance as long as it fits the memory.
    Note that this option is not something that should be
    enabled by default for unknown or very large models, since all Cuda pinned
    memory is unpageable, having too much pinned memory might negatively impact
    the overall host system performance.
    """
    @property
    def experimental(self) -> global___GPUOptions.Experimental:
        """Everything inside experimental is subject to change and is not subject
        to API stability guarantees in
        https://www.tensorflow.org/guide/version_compat.
        """
    def __init__(
        self,
        *,
        per_process_gpu_memory_fraction: builtins.float | None = ...,
        allow_growth: builtins.bool | None = ...,
        allocator_type: builtins.str | None = ...,
        deferred_deletion_bytes: builtins.int | None = ...,
        visible_device_list: builtins.str | None = ...,
        polling_active_delay_usecs: builtins.int | None = ...,
        polling_inactive_delay_msecs: builtins.int | None = ...,
        force_gpu_compatible: builtins.bool | None = ...,
        experimental: global___GPUOptions.Experimental | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["experimental", b"experimental"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["allocator_type", b"allocator_type", "allow_growth", b"allow_growth", "deferred_deletion_bytes", b"deferred_deletion_bytes", "experimental", b"experimental", "force_gpu_compatible", b"force_gpu_compatible", "per_process_gpu_memory_fraction", b"per_process_gpu_memory_fraction", "polling_active_delay_usecs", b"polling_active_delay_usecs", "polling_inactive_delay_msecs", b"polling_inactive_delay_msecs", "visible_device_list", b"visible_device_list"]) -> None: ...

global___GPUOptions = GPUOptions

@typing_extensions.final
class OptimizerOptions(google.protobuf.message.Message):
    """Options passed to the graph optimizer"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Level:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OptimizerOptions._Level.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        L1: OptimizerOptions._Level.ValueType  # 0
        """L1 is the default level.
        Optimization performed at L1 :
        1. Common subexpression elimination
        2. Constant folding
        """
        L0: OptimizerOptions._Level.ValueType  # -1
        """No optimizations"""

    class Level(_Level, metaclass=_LevelEnumTypeWrapper):
        """Optimization level"""

    L1: OptimizerOptions.Level.ValueType  # 0
    """L1 is the default level.
    Optimization performed at L1 :
    1. Common subexpression elimination
    2. Constant folding
    """
    L0: OptimizerOptions.Level.ValueType  # -1
    """No optimizations"""

    class _GlobalJitLevel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _GlobalJitLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[OptimizerOptions._GlobalJitLevel.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DEFAULT: OptimizerOptions._GlobalJitLevel.ValueType  # 0
        """Default setting ("off" now, but later expected to be "on")"""
        OFF: OptimizerOptions._GlobalJitLevel.ValueType  # -1
        ON_1: OptimizerOptions._GlobalJitLevel.ValueType  # 1
        """The following settings turn on compilation, with higher values being
        more aggressive.  Higher values may reduce opportunities for parallelism
        and may use more memory.  (At present, there is no distinction, but this
        is expected to change.)
        """
        ON_2: OptimizerOptions._GlobalJitLevel.ValueType  # 2

    class GlobalJitLevel(_GlobalJitLevel, metaclass=_GlobalJitLevelEnumTypeWrapper):
        """Control the use of the compiler/jit.  Experimental."""

    DEFAULT: OptimizerOptions.GlobalJitLevel.ValueType  # 0
    """Default setting ("off" now, but later expected to be "on")"""
    OFF: OptimizerOptions.GlobalJitLevel.ValueType  # -1
    ON_1: OptimizerOptions.GlobalJitLevel.ValueType  # 1
    """The following settings turn on compilation, with higher values being
    more aggressive.  Higher values may reduce opportunities for parallelism
    and may use more memory.  (At present, there is no distinction, but this
    is expected to change.)
    """
    ON_2: OptimizerOptions.GlobalJitLevel.ValueType  # 2

    DO_COMMON_SUBEXPRESSION_ELIMINATION_FIELD_NUMBER: builtins.int
    DO_CONSTANT_FOLDING_FIELD_NUMBER: builtins.int
    MAX_FOLDED_CONSTANT_IN_BYTES_FIELD_NUMBER: builtins.int
    DO_FUNCTION_INLINING_FIELD_NUMBER: builtins.int
    OPT_LEVEL_FIELD_NUMBER: builtins.int
    GLOBAL_JIT_LEVEL_FIELD_NUMBER: builtins.int
    CPU_GLOBAL_JIT_FIELD_NUMBER: builtins.int
    do_common_subexpression_elimination: builtins.bool
    """If true, optimize the graph using common subexpression elimination.
    Note: the optimization Level L1 will override this setting to true. So in
    order to disable common subexpression elimination the opt_level has to be
    set to L0.
    """
    do_constant_folding: builtins.bool
    """If true, perform constant folding optimization on the graph.
    Note: the optimization Level L1 will override this setting to true. So in
    order to disable constant folding the opt_level has to be set to L0.
    """
    max_folded_constant_in_bytes: builtins.int
    """Constant folding optimization replaces tensors whose values can be
    predetermined, with constant nodes. To avoid inserting too large constants,
    the size of each constant created can be limited. If this value is zero, a
    default limit of 10 MiB will be applied. If constant folding optimization
    is disabled, this value is ignored.
    """
    do_function_inlining: builtins.bool
    """If true, perform function inlining on the graph."""
    opt_level: global___OptimizerOptions.Level.ValueType
    """Overall optimization level. The actual optimizations applied will be the
    logical OR of the flags that this level implies and any flags already set.
    """
    global_jit_level: global___OptimizerOptions.GlobalJitLevel.ValueType
    cpu_global_jit: builtins.bool
    """CPU code will be autoclustered only if global_jit_level >= ON_1 and either:
     - this flag is true, or
     - TF_XLA_FLAGS contains --tf_xla_cpu_global_jit=true.
    """
    def __init__(
        self,
        *,
        do_common_subexpression_elimination: builtins.bool | None = ...,
        do_constant_folding: builtins.bool | None = ...,
        max_folded_constant_in_bytes: builtins.int | None = ...,
        do_function_inlining: builtins.bool | None = ...,
        opt_level: global___OptimizerOptions.Level.ValueType | None = ...,
        global_jit_level: global___OptimizerOptions.GlobalJitLevel.ValueType | None = ...,
        cpu_global_jit: builtins.bool | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu_global_jit", b"cpu_global_jit", "do_common_subexpression_elimination", b"do_common_subexpression_elimination", "do_constant_folding", b"do_constant_folding", "do_function_inlining", b"do_function_inlining", "global_jit_level", b"global_jit_level", "max_folded_constant_in_bytes", b"max_folded_constant_in_bytes", "opt_level", b"opt_level"]) -> None: ...

global___OptimizerOptions = OptimizerOptions

@typing_extensions.final
class GraphOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_RECV_SCHEDULING_FIELD_NUMBER: builtins.int
    OPTIMIZER_OPTIONS_FIELD_NUMBER: builtins.int
    BUILD_COST_MODEL_FIELD_NUMBER: builtins.int
    BUILD_COST_MODEL_AFTER_FIELD_NUMBER: builtins.int
    INFER_SHAPES_FIELD_NUMBER: builtins.int
    PLACE_PRUNED_GRAPH_FIELD_NUMBER: builtins.int
    ENABLE_BFLOAT16_SENDRECV_FIELD_NUMBER: builtins.int
    TIMELINE_STEP_FIELD_NUMBER: builtins.int
    REWRITE_OPTIONS_FIELD_NUMBER: builtins.int
    enable_recv_scheduling: builtins.bool
    """If true, use control flow to schedule the activation of Recv nodes.
    (Currently ignored.)
    """
    @property
    def optimizer_options(self) -> global___OptimizerOptions:
        """Options controlling how graph is optimized."""
    build_cost_model: builtins.int
    """The number of steps to run before returning a cost model detailing
    the memory usage and performance of each node of the graph. 0 means
    no cost model.
    """
    build_cost_model_after: builtins.int
    """The number of steps to skip before collecting statistics for the
    cost model.
    """
    infer_shapes: builtins.bool
    """Annotate each Node with Op output shape data, to the extent it can
    be statically inferred.
    """
    place_pruned_graph: builtins.bool
    """Only place the subgraphs that are run, rather than the entire graph.

    This is useful for interactive graph building, where one might
    produce graphs that cannot be placed during the debugging
    process.  In particular, it allows the client to continue work in
    a session after adding a node to a graph whose placement
    constraints are unsatisfiable.
    """
    enable_bfloat16_sendrecv: builtins.bool
    """If true, transfer float values between processes as bfloat16."""
    timeline_step: builtins.int
    """If > 0, record a timeline every this many steps.
    EXPERIMENTAL: This currently has no effect in MasterSession.
    """
    @property
    def rewrite_options(self) -> tensorflow.core.protobuf.rewriter_config_pb2.RewriterConfig:
        """Options that control the type and amount of graph rewriting.
        Not currently configurable via the public Python API (i.e. there is no API
        stability guarantee if you import RewriterConfig explicitly).
        """
    def __init__(
        self,
        *,
        enable_recv_scheduling: builtins.bool | None = ...,
        optimizer_options: global___OptimizerOptions | None = ...,
        build_cost_model: builtins.int | None = ...,
        build_cost_model_after: builtins.int | None = ...,
        infer_shapes: builtins.bool | None = ...,
        place_pruned_graph: builtins.bool | None = ...,
        enable_bfloat16_sendrecv: builtins.bool | None = ...,
        timeline_step: builtins.int | None = ...,
        rewrite_options: tensorflow.core.protobuf.rewriter_config_pb2.RewriterConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["optimizer_options", b"optimizer_options", "rewrite_options", b"rewrite_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_cost_model", b"build_cost_model", "build_cost_model_after", b"build_cost_model_after", "enable_bfloat16_sendrecv", b"enable_bfloat16_sendrecv", "enable_recv_scheduling", b"enable_recv_scheduling", "infer_shapes", b"infer_shapes", "optimizer_options", b"optimizer_options", "place_pruned_graph", b"place_pruned_graph", "rewrite_options", b"rewrite_options", "timeline_step", b"timeline_step"]) -> None: ...

global___GraphOptions = GraphOptions

@typing_extensions.final
class ThreadPoolOptionProto(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_THREADS_FIELD_NUMBER: builtins.int
    GLOBAL_NAME_FIELD_NUMBER: builtins.int
    num_threads: builtins.int
    """The number of threads in the pool.

    0 means the system picks a value based on where this option proto is used
    (see the declaration of the specific field for more info).
    """
    global_name: builtins.str
    """The global name of the threadpool.

    If empty, then the threadpool is made and used according to the scope it's
    in - e.g., for a session threadpool, it is used by that session only.

    If non-empty, then:
    - a global threadpool associated with this name is looked
      up or created. This allows, for example, sharing one threadpool across
      many sessions (e.g., like the default behavior, if
      inter_op_parallelism_threads is not configured), but still partitioning
      into a large and small pool.
    - if the threadpool for this global_name already exists, then it is an
      error if the existing pool was created using a different num_threads
      value as is specified on this call.
    - threadpools created this way are never garbage collected.
    """
    def __init__(
        self,
        *,
        num_threads: builtins.int | None = ...,
        global_name: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["global_name", b"global_name", "num_threads", b"num_threads"]) -> None: ...

global___ThreadPoolOptionProto = ThreadPoolOptionProto

@typing_extensions.final
class SessionMetadata(google.protobuf.message.Message):
    """Metadata about the session.

    This can be used by the runtime and the Ops for debugging, monitoring, etc.

    The (name, version) tuple is expected to be a unique identifier for
    sessions within the same process.

    NOTE: This is currently used and propagated only by the direct session.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    version: builtins.int
    """The version is optional. If set, needs to be >= 0."""
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        version: builtins.int | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___SessionMetadata = SessionMetadata

@typing_extensions.final
class ConfigProto(google.protobuf.message.Message):
    """Session configuration parameters.
    The system picks appropriate values for fields that are not set.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class DeviceCountEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class Experimental(google.protobuf.message.Message):
        """Everything inside Experimental is subject to change and is not subject
        to API stability guarantees in
        https://www.tensorflow.org/guide/version_compat.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _MlirBridgeRollout:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _MlirBridgeRolloutEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ConfigProto.Experimental._MlirBridgeRollout.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MLIR_BRIDGE_ROLLOUT_UNSPECIFIED: ConfigProto.Experimental._MlirBridgeRollout.ValueType  # 0
            """If this field is left unspecified, the MLIR bridge may be selectively
            enabled on a per graph basis.
            """
            MLIR_BRIDGE_ROLLOUT_ENABLED: ConfigProto.Experimental._MlirBridgeRollout.ValueType  # 1
            """Enabling the MLIR bridge enables it for all graphs in this session."""
            MLIR_BRIDGE_ROLLOUT_DISABLED: ConfigProto.Experimental._MlirBridgeRollout.ValueType  # 2
            """Disabling the MLIR bridge disables it for all graphs in this session."""

        class MlirBridgeRollout(_MlirBridgeRollout, metaclass=_MlirBridgeRolloutEnumTypeWrapper):
            """An enum that describes the state of the MLIR bridge rollout."""

        MLIR_BRIDGE_ROLLOUT_UNSPECIFIED: ConfigProto.Experimental.MlirBridgeRollout.ValueType  # 0
        """If this field is left unspecified, the MLIR bridge may be selectively
        enabled on a per graph basis.
        """
        MLIR_BRIDGE_ROLLOUT_ENABLED: ConfigProto.Experimental.MlirBridgeRollout.ValueType  # 1
        """Enabling the MLIR bridge enables it for all graphs in this session."""
        MLIR_BRIDGE_ROLLOUT_DISABLED: ConfigProto.Experimental.MlirBridgeRollout.ValueType  # 2
        """Disabling the MLIR bridge disables it for all graphs in this session."""

        COLLECTIVE_GROUP_LEADER_FIELD_NUMBER: builtins.int
        EXECUTOR_TYPE_FIELD_NUMBER: builtins.int
        RECV_BUF_MAX_CHUNK_FIELD_NUMBER: builtins.int
        USE_NUMA_AFFINITY_FIELD_NUMBER: builtins.int
        COLLECTIVE_DETERMINISTIC_SEQUENTIAL_EXECUTION_FIELD_NUMBER: builtins.int
        COLLECTIVE_NCCL_FIELD_NUMBER: builtins.int
        SHARE_SESSION_STATE_IN_CLUSTERSPEC_PROPAGATION_FIELD_NUMBER: builtins.int
        DISABLE_THREAD_SPINNING_FIELD_NUMBER: builtins.int
        SHARE_CLUSTER_DEVICES_IN_SESSION_FIELD_NUMBER: builtins.int
        SESSION_METADATA_FIELD_NUMBER: builtins.int
        OPTIMIZE_FOR_STATIC_GRAPH_FIELD_NUMBER: builtins.int
        ENABLE_MLIR_BRIDGE_FIELD_NUMBER: builtins.int
        MLIR_BRIDGE_ROLLOUT_FIELD_NUMBER: builtins.int
        ENABLE_MLIR_GRAPH_OPTIMIZATION_FIELD_NUMBER: builtins.int
        DISABLE_OUTPUT_PARTITION_GRAPHS_FIELD_NUMBER: builtins.int
        XLA_FUSION_AUTOTUNER_THRESH_FIELD_NUMBER: builtins.int
        USE_TFRT_FIELD_NUMBER: builtins.int
        DISABLE_FUNCTIONAL_OPS_LOWERING_FIELD_NUMBER: builtins.int
        XLA_PREFER_SINGLE_GRAPH_CLUSTER_FIELD_NUMBER: builtins.int
        COORDINATION_CONFIG_FIELD_NUMBER: builtins.int
        DISABLE_OPTIMIZE_FOR_STATIC_GRAPH_FIELD_NUMBER: builtins.int
        collective_group_leader: builtins.str
        """Task name for group resolution."""
        executor_type: builtins.str
        """Which executor to use, the default executor will be used
        if it is an empty string or "DEFAULT"
        """
        recv_buf_max_chunk: builtins.int
        """Guidance to formatting of large RecvBuf fields for transfer.
        Any positive value sets the max chunk size.  0 defaults to 4096.
        Any negative value indicates no max, i.e. one chunk only.
        """
        use_numa_affinity: builtins.bool
        """If true, and supported by the platform, the runtime will attempt to
        use NUMA affinity where applicable.  One consequence will be the
        existence of as many CPU devices as there are available NUMA nodes.
        """
        collective_deterministic_sequential_execution: builtins.bool
        """If true, make collective op execution order sequential and deterministic
        for potentially concurrent collective instances.
        """
        collective_nccl: builtins.bool
        """If true, use NCCL for CollectiveOps.  This feature is highly
        experimental.
        """
        share_session_state_in_clusterspec_propagation: builtins.bool
        """In the following, session state means the value of a variable, elements
        in a hash table, or any other resource, accessible by worker sessions
        held by a TF server.

        When ClusterSpec propagation is enabled, the value of
        isolate_session_state is ignored when deciding whether to share session
        states in a TF server (for backwards compatibility reasons).
        - If share_session_state_in_clusterspec_propagation is true, the session
        states are shared.
        - If share_session_state_in_clusterspec_propagation is false, session
        states are isolated.

        When clusterspec propagation is not used, the value of
        share_session_state_in_clusterspec_propagation is ignored when deciding
        whether to share session states in a TF server.
        - If isolate_session_state is true, session states are isolated.
        - If isolate_session_state is false, session states are shared.

        TODO(b/129330037): Add a single API that consistently treats
        isolate_session_state and ClusterSpec propagation.
        """
        disable_thread_spinning: builtins.bool
        """If using a direct session, disable spinning while waiting for work in
        the thread pool. This may result in higher latency for completing ops,
        but in the case where there is a lot of spinning may result in lower
        CPU usage.
        """
        share_cluster_devices_in_session: builtins.bool
        """This was promoted to a non-experimental API. Please use
        ConfigProto.share_cluster_devices_in_session instead.
        """
        @property
        def session_metadata(self) -> global___SessionMetadata:
            """Metadata about the session.

            If set, this can be used by the runtime and the Ops for debugging,
            monitoring, etc.

            NOTE: This is currently used and propagated only by the direct session
            and EagerContext.
            """
        optimize_for_static_graph: builtins.bool
        """If true, the session may treat the graph as being static for optimization
        purposes.

        If this option is set to true when a session is created, the full
        GraphDef must be passed in a single call to Session::Create(), and
        Session::Extend() may not be supported.
        """
        enable_mlir_bridge: builtins.bool
        """Whether to enable the MLIR-based TF->XLA bridge. This is only used if set
        to true. Default value or false is ignored. Use mlir_bridge_rollout for
        finer control.

        If this option is set to true when a session is created, MLIR is used to
        perform the set of graph transformations to put the graph in a form that
        can be executed with delegation of some computations to an accelerator.
        This builds on the model of XLA where a subset of the graph is
        encapsulated and attached to a "compile" operation, whose result is fed
        to an "execute" operation. The kernel for these operations is responsible
        to lower the encapsulated graph to a particular device.
        """
        mlir_bridge_rollout: global___ConfigProto.Experimental.MlirBridgeRollout.ValueType
        """Whether to enable the MLIR-based TF->XLA bridge."""
        enable_mlir_graph_optimization: builtins.bool
        """Whether to enable the MLIR-based Graph optimizations.

        This will become a part of standard Tensorflow graph optimization
        pipeline, currently this is only used for gradual migration and testing
        new passes that are replacing existing optimizations in Grappler.
        """
        disable_output_partition_graphs: builtins.bool
        """If true, the session will not store an additional copy of the graph for
        each subgraph.

        If this option is set to true when a session is created, the
        `RunOptions.output_partition_graphs` options must not be set.
        """
        xla_fusion_autotuner_thresh: builtins.int
        """Minimum number of batches run through the XLA graph before XLA fusion
        autotuner is enabled. Default value of zero disables the autotuner.

        The XLA fusion autotuner can improve performance by executing a heuristic
        search on the compiler parameters.
        """
        use_tfrt: builtins.bool
        """Whether runtime execution uses TFRT."""
        disable_functional_ops_lowering: builtins.bool
        """Whether functional control flow op lowering should be disabled. This is
        useful when executing within a portable runtime where control flow op
        kernels may not be loaded due to selective registration.
        """
        xla_prefer_single_graph_cluster: builtins.bool
        """Provides a hint to XLA auto clustering to prefer forming a single large
        cluster that encompases most of the graph.
        """
        @property
        def coordination_config(self) -> tensorflow.tsl.protobuf.coordination_config_pb2.CoordinationServiceConfig:
            """Distributed coordination service configurations."""
        disable_optimize_for_static_graph: builtins.bool
        """If true, the session will treat the graph as being non-static for
        optimization purposes.

        If this option is set to true when a session is created, the full
        GraphDef will be retained to enable calls to Session::Extend().
        Calling Extend() without setting this flag will result in errors.

        This option is meant to replace `optimize_for_static_graph` and it
        aims to negate its value.
        """
        def __init__(
            self,
            *,
            collective_group_leader: builtins.str | None = ...,
            executor_type: builtins.str | None = ...,
            recv_buf_max_chunk: builtins.int | None = ...,
            use_numa_affinity: builtins.bool | None = ...,
            collective_deterministic_sequential_execution: builtins.bool | None = ...,
            collective_nccl: builtins.bool | None = ...,
            share_session_state_in_clusterspec_propagation: builtins.bool | None = ...,
            disable_thread_spinning: builtins.bool | None = ...,
            share_cluster_devices_in_session: builtins.bool | None = ...,
            session_metadata: global___SessionMetadata | None = ...,
            optimize_for_static_graph: builtins.bool | None = ...,
            enable_mlir_bridge: builtins.bool | None = ...,
            mlir_bridge_rollout: global___ConfigProto.Experimental.MlirBridgeRollout.ValueType | None = ...,
            enable_mlir_graph_optimization: builtins.bool | None = ...,
            disable_output_partition_graphs: builtins.bool | None = ...,
            xla_fusion_autotuner_thresh: builtins.int | None = ...,
            use_tfrt: builtins.bool | None = ...,
            disable_functional_ops_lowering: builtins.bool | None = ...,
            xla_prefer_single_graph_cluster: builtins.bool | None = ...,
            coordination_config: tensorflow.tsl.protobuf.coordination_config_pb2.CoordinationServiceConfig | None = ...,
            disable_optimize_for_static_graph: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["coordination_config", b"coordination_config", "session_metadata", b"session_metadata"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["collective_deterministic_sequential_execution", b"collective_deterministic_sequential_execution", "collective_group_leader", b"collective_group_leader", "collective_nccl", b"collective_nccl", "coordination_config", b"coordination_config", "disable_functional_ops_lowering", b"disable_functional_ops_lowering", "disable_optimize_for_static_graph", b"disable_optimize_for_static_graph", "disable_output_partition_graphs", b"disable_output_partition_graphs", "disable_thread_spinning", b"disable_thread_spinning", "enable_mlir_bridge", b"enable_mlir_bridge", "enable_mlir_graph_optimization", b"enable_mlir_graph_optimization", "executor_type", b"executor_type", "mlir_bridge_rollout", b"mlir_bridge_rollout", "optimize_for_static_graph", b"optimize_for_static_graph", "recv_buf_max_chunk", b"recv_buf_max_chunk", "session_metadata", b"session_metadata", "share_cluster_devices_in_session", b"share_cluster_devices_in_session", "share_session_state_in_clusterspec_propagation", b"share_session_state_in_clusterspec_propagation", "use_numa_affinity", b"use_numa_affinity", "use_tfrt", b"use_tfrt", "xla_fusion_autotuner_thresh", b"xla_fusion_autotuner_thresh", "xla_prefer_single_graph_cluster", b"xla_prefer_single_graph_cluster"]) -> None: ...

    DEVICE_COUNT_FIELD_NUMBER: builtins.int
    INTRA_OP_PARALLELISM_THREADS_FIELD_NUMBER: builtins.int
    INTER_OP_PARALLELISM_THREADS_FIELD_NUMBER: builtins.int
    USE_PER_SESSION_THREADS_FIELD_NUMBER: builtins.int
    SESSION_INTER_OP_THREAD_POOL_FIELD_NUMBER: builtins.int
    PLACEMENT_PERIOD_FIELD_NUMBER: builtins.int
    DEVICE_FILTERS_FIELD_NUMBER: builtins.int
    GPU_OPTIONS_FIELD_NUMBER: builtins.int
    ALLOW_SOFT_PLACEMENT_FIELD_NUMBER: builtins.int
    LOG_DEVICE_PLACEMENT_FIELD_NUMBER: builtins.int
    GRAPH_OPTIONS_FIELD_NUMBER: builtins.int
    OPERATION_TIMEOUT_IN_MS_FIELD_NUMBER: builtins.int
    RPC_OPTIONS_FIELD_NUMBER: builtins.int
    CLUSTER_DEF_FIELD_NUMBER: builtins.int
    ISOLATE_SESSION_STATE_FIELD_NUMBER: builtins.int
    SHARE_CLUSTER_DEVICES_IN_SESSION_FIELD_NUMBER: builtins.int
    EXPERIMENTAL_FIELD_NUMBER: builtins.int
    @property
    def device_count(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """Map from device type name (e.g., "CPU" or "GPU" ) to maximum
        number of devices of that type to use.  If a particular device
        type is not found in the map, the system picks an appropriate
        number.
        """
    intra_op_parallelism_threads: builtins.int
    """The execution of an individual op (for some op types) can be
    parallelized on a pool of intra_op_parallelism_threads.
    0 means the system picks an appropriate number.

    If you create an ordinary session, e.g., from Python or C++,
    then there is exactly one intra op thread pool per process.
    The first session created determines the number of threads in this pool.
    All subsequent sessions reuse/share this one global pool.

    There are notable exceptions to the default behavior described above:
    1. There is an environment variable  for overriding this thread pool,
       named TF_OVERRIDE_GLOBAL_THREADPOOL.
    2. When connecting to a server, such as a remote `tf.train.Server`
       instance, then this option will be ignored altogether.
    """
    inter_op_parallelism_threads: builtins.int
    """Nodes that perform blocking operations are enqueued on a pool of
    inter_op_parallelism_threads available in each process.

    0 means the system picks an appropriate number.
    Negative means all operations are performed in caller's thread.

    Note that the first Session created in the process sets the
    number of threads for all future sessions unless use_per_session_threads is
    true or session_inter_op_thread_pool is configured.
    """
    use_per_session_threads: builtins.bool
    """If true, use a new set of threads for this session rather than the global
    pool of threads. Only supported by direct sessions.

    If false, use the global threads created by the first session, or the
    per-session thread pools configured by session_inter_op_thread_pool.

    This option is deprecated. The same effect can be achieved by setting
    session_inter_op_thread_pool to have one element, whose num_threads equals
    inter_op_parallelism_threads.
    """
    @property
    def session_inter_op_thread_pool(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ThreadPoolOptionProto]:
        """This option is experimental - it may be replaced with a different mechanism
        in the future.

        Configures session thread pools. If this is configured, then RunOptions for
        a Run call can select the thread pool to use.

        The intended use is for when some session invocations need to run in a
        background pool limited to a small number of threads:
        - For example, a session may be configured to have one large pool (for
        regular compute) and one small pool (for periodic, low priority work);
        using the small pool is currently the mechanism for limiting the inter-op
        parallelism of the low priority work.  Note that it does not limit the
        parallelism of work spawned by a single op kernel implementation.
        - Using this setting is normally not needed in training, but may help some
        serving use cases.
        - It is also generally recommended to set the global_name field of this
        proto, to avoid creating multiple large pools. It is typically better to
        run the non-low-priority work, even across sessions, in a single large
        pool.
        """
    placement_period: builtins.int
    """Assignment of Nodes to Devices is recomputed every placement_period
    steps until the system warms up (at which point the recomputation
    typically slows down automatically).
    """
    @property
    def device_filters(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """When any filters are present sessions will ignore all devices which do not
        match the filters. Each filter can be partially specified, e.g. "/job:ps"
        "/job:worker/replica:3", etc.
        """
    @property
    def gpu_options(self) -> global___GPUOptions:
        """Options that apply to all GPUs."""
    allow_soft_placement: builtins.bool
    """Whether soft placement is allowed. If allow_soft_placement is true,
    an op will be placed on CPU if
      1. there's no GPU implementation for the OP
    or
      2. no GPU devices are known or registered
    or
      3. need to co-locate with reftype input(s) which are from CPU.
    """
    log_device_placement: builtins.bool
    """Whether device placements should be logged."""
    @property
    def graph_options(self) -> global___GraphOptions:
        """Options that apply to all graphs."""
    operation_timeout_in_ms: builtins.int
    """Global timeout for all blocking operations in this session.  If non-zero,
    and not overridden on a per-operation basis, this value will be used as the
    deadline for all blocking operations.
    """
    @property
    def rpc_options(self) -> tensorflow.tsl.protobuf.rpc_options_pb2.RPCOptions:
        """Options that apply when this session uses the distributed runtime."""
    @property
    def cluster_def(self) -> tensorflow.core.protobuf.cluster_pb2.ClusterDef:
        """Optional list of all workers to use in this session."""
    isolate_session_state: builtins.bool
    """If true, any resources such as Variables used in the session will not be
    shared with other sessions. However, when clusterspec propagation is
    enabled, this field is ignored and sessions are always isolated.
    """
    share_cluster_devices_in_session: builtins.bool
    """When true, WorkerSessions are created with device attributes from the
    full cluster.
    This is helpful when a worker wants to partition a graph
    (for example during a PartitionedCallOp).
    """
    @property
    def experimental(self) -> global___ConfigProto.Experimental: ...
    def __init__(
        self,
        *,
        device_count: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        intra_op_parallelism_threads: builtins.int | None = ...,
        inter_op_parallelism_threads: builtins.int | None = ...,
        use_per_session_threads: builtins.bool | None = ...,
        session_inter_op_thread_pool: collections.abc.Iterable[global___ThreadPoolOptionProto] | None = ...,
        placement_period: builtins.int | None = ...,
        device_filters: collections.abc.Iterable[builtins.str] | None = ...,
        gpu_options: global___GPUOptions | None = ...,
        allow_soft_placement: builtins.bool | None = ...,
        log_device_placement: builtins.bool | None = ...,
        graph_options: global___GraphOptions | None = ...,
        operation_timeout_in_ms: builtins.int | None = ...,
        rpc_options: tensorflow.tsl.protobuf.rpc_options_pb2.RPCOptions | None = ...,
        cluster_def: tensorflow.core.protobuf.cluster_pb2.ClusterDef | None = ...,
        isolate_session_state: builtins.bool | None = ...,
        share_cluster_devices_in_session: builtins.bool | None = ...,
        experimental: global___ConfigProto.Experimental | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cluster_def", b"cluster_def", "experimental", b"experimental", "gpu_options", b"gpu_options", "graph_options", b"graph_options", "rpc_options", b"rpc_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["allow_soft_placement", b"allow_soft_placement", "cluster_def", b"cluster_def", "device_count", b"device_count", "device_filters", b"device_filters", "experimental", b"experimental", "gpu_options", b"gpu_options", "graph_options", b"graph_options", "inter_op_parallelism_threads", b"inter_op_parallelism_threads", "intra_op_parallelism_threads", b"intra_op_parallelism_threads", "isolate_session_state", b"isolate_session_state", "log_device_placement", b"log_device_placement", "operation_timeout_in_ms", b"operation_timeout_in_ms", "placement_period", b"placement_period", "rpc_options", b"rpc_options", "session_inter_op_thread_pool", b"session_inter_op_thread_pool", "share_cluster_devices_in_session", b"share_cluster_devices_in_session", "use_per_session_threads", b"use_per_session_threads"]) -> None: ...

global___ConfigProto = ConfigProto

@typing_extensions.final
class RunOptions(google.protobuf.message.Message):
    """Options for a single Run() call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TraceLevel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TraceLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RunOptions._TraceLevel.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_TRACE: RunOptions._TraceLevel.ValueType  # 0
        SOFTWARE_TRACE: RunOptions._TraceLevel.ValueType  # 1
        HARDWARE_TRACE: RunOptions._TraceLevel.ValueType  # 2
        FULL_TRACE: RunOptions._TraceLevel.ValueType  # 3

    class TraceLevel(_TraceLevel, metaclass=_TraceLevelEnumTypeWrapper):
        """TODO(pbar) Turn this into a TraceOptions proto which allows
        tracing to be controlled in a more orthogonal manner?
        """

    NO_TRACE: RunOptions.TraceLevel.ValueType  # 0
    SOFTWARE_TRACE: RunOptions.TraceLevel.ValueType  # 1
    HARDWARE_TRACE: RunOptions.TraceLevel.ValueType  # 2
    FULL_TRACE: RunOptions.TraceLevel.ValueType  # 3

    @typing_extensions.final
    class Experimental(google.protobuf.message.Message):
        """Everything inside Experimental is subject to change and is not subject
        to API stability guarantees in
        https://www.tensorflow.org/guide/version_compat.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class RunHandlerPoolOptions(google.protobuf.message.Message):
            """Options for run handler thread pool."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            PRIORITY_FIELD_NUMBER: builtins.int
            priority: builtins.int
            """Priority of the request. The run handler thread pool will schedule ops
            based on the priority number. The larger number means higher priority.
            """
            def __init__(
                self,
                *,
                priority: builtins.int | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["priority", b"priority"]) -> None: ...

        COLLECTIVE_GRAPH_KEY_FIELD_NUMBER: builtins.int
        USE_RUN_HANDLER_POOL_FIELD_NUMBER: builtins.int
        RUN_HANDLER_POOL_OPTIONS_FIELD_NUMBER: builtins.int
        collective_graph_key: builtins.int
        """If non-zero, declares that this graph is going to use collective
        ops and must synchronize step_ids with any other graph with this
        same group_key value (in a distributed computation where tasks
        run disjoint graphs).
        """
        use_run_handler_pool: builtins.bool
        """If true, then operations (using the inter-op pool) across all
        session::run() calls will be centrally scheduled, optimizing for (median
        and tail) latency.
        Consider using this option for CPU-bound workloads like inference.
        """
        @property
        def run_handler_pool_options(self) -> global___RunOptions.Experimental.RunHandlerPoolOptions: ...
        def __init__(
            self,
            *,
            collective_graph_key: builtins.int | None = ...,
            use_run_handler_pool: builtins.bool | None = ...,
            run_handler_pool_options: global___RunOptions.Experimental.RunHandlerPoolOptions | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["run_handler_pool_options", b"run_handler_pool_options"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["collective_graph_key", b"collective_graph_key", "run_handler_pool_options", b"run_handler_pool_options", "use_run_handler_pool", b"use_run_handler_pool"]) -> None: ...

    TRACE_LEVEL_FIELD_NUMBER: builtins.int
    TIMEOUT_IN_MS_FIELD_NUMBER: builtins.int
    INTER_OP_THREAD_POOL_FIELD_NUMBER: builtins.int
    OUTPUT_PARTITION_GRAPHS_FIELD_NUMBER: builtins.int
    DEBUG_OPTIONS_FIELD_NUMBER: builtins.int
    REPORT_TENSOR_ALLOCATIONS_UPON_OOM_FIELD_NUMBER: builtins.int
    EXPERIMENTAL_FIELD_NUMBER: builtins.int
    trace_level: global___RunOptions.TraceLevel.ValueType
    timeout_in_ms: builtins.int
    """Time to wait for operation to complete in milliseconds."""
    inter_op_thread_pool: builtins.int
    """The thread pool to use, if session_inter_op_thread_pool is configured.
    To use the caller thread set this to -1 - this uses the caller thread
    to execute Session::Run() and thus avoids a context switch. Using the
    caller thread to execute Session::Run() should be done ONLY for simple
    graphs, where the overhead of an additional context switch is
    comparable with the overhead of Session::Run().
    """
    output_partition_graphs: builtins.bool
    """Whether the partition graph(s) executed by the executor(s) should be
    outputted via RunMetadata.
    """
    @property
    def debug_options(self) -> tensorflow.core.protobuf.debug_pb2.DebugOptions:
        """EXPERIMENTAL.  Options used to initialize DebuggerState, if enabled."""
    report_tensor_allocations_upon_oom: builtins.bool
    """When enabled, causes tensor allocation information to be included in
    the error message when the Run() call fails because the allocator ran
    out of memory (OOM).

    Enabling this option can slow down the Run() call.
    """
    @property
    def experimental(self) -> global___RunOptions.Experimental: ...
    def __init__(
        self,
        *,
        trace_level: global___RunOptions.TraceLevel.ValueType | None = ...,
        timeout_in_ms: builtins.int | None = ...,
        inter_op_thread_pool: builtins.int | None = ...,
        output_partition_graphs: builtins.bool | None = ...,
        debug_options: tensorflow.core.protobuf.debug_pb2.DebugOptions | None = ...,
        report_tensor_allocations_upon_oom: builtins.bool | None = ...,
        experimental: global___RunOptions.Experimental | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["debug_options", b"debug_options", "experimental", b"experimental"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["debug_options", b"debug_options", "experimental", b"experimental", "inter_op_thread_pool", b"inter_op_thread_pool", "output_partition_graphs", b"output_partition_graphs", "report_tensor_allocations_upon_oom", b"report_tensor_allocations_upon_oom", "timeout_in_ms", b"timeout_in_ms", "trace_level", b"trace_level"]) -> None: ...

global___RunOptions = RunOptions

@typing_extensions.final
class RunMetadata(google.protobuf.message.Message):
    """Metadata output (i.e., non-Tensor) for a single Run() call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class FunctionGraphs(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PARTITION_GRAPHS_FIELD_NUMBER: builtins.int
        PRE_OPTIMIZATION_GRAPH_FIELD_NUMBER: builtins.int
        POST_OPTIMIZATION_GRAPH_FIELD_NUMBER: builtins.int
        @property
        def partition_graphs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tensorflow.core.framework.graph_pb2.GraphDef]:
            """TODO(nareshmodi): Include some sort of function/cache-key identifier?"""
        @property
        def pre_optimization_graph(self) -> tensorflow.core.framework.graph_pb2.GraphDef: ...
        @property
        def post_optimization_graph(self) -> tensorflow.core.framework.graph_pb2.GraphDef: ...
        def __init__(
            self,
            *,
            partition_graphs: collections.abc.Iterable[tensorflow.core.framework.graph_pb2.GraphDef] | None = ...,
            pre_optimization_graph: tensorflow.core.framework.graph_pb2.GraphDef | None = ...,
            post_optimization_graph: tensorflow.core.framework.graph_pb2.GraphDef | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["post_optimization_graph", b"post_optimization_graph", "pre_optimization_graph", b"pre_optimization_graph"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["partition_graphs", b"partition_graphs", "post_optimization_graph", b"post_optimization_graph", "pre_optimization_graph", b"pre_optimization_graph"]) -> None: ...

    STEP_STATS_FIELD_NUMBER: builtins.int
    COST_GRAPH_FIELD_NUMBER: builtins.int
    PARTITION_GRAPHS_FIELD_NUMBER: builtins.int
    FUNCTION_GRAPHS_FIELD_NUMBER: builtins.int
    SESSION_METADATA_FIELD_NUMBER: builtins.int
    @property
    def step_stats(self) -> tensorflow.core.framework.step_stats_pb2.StepStats:
        """Statistics traced for this step. Populated if tracing is turned on via the
        "RunOptions" proto.
        EXPERIMENTAL: The format and set of events may change in future versions.
        """
    @property
    def cost_graph(self) -> tensorflow.core.framework.cost_graph_pb2.CostGraphDef:
        """The cost graph for the computation defined by the run call."""
    @property
    def partition_graphs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[tensorflow.core.framework.graph_pb2.GraphDef]:
        """Graphs of the partitions executed by executors."""
    @property
    def function_graphs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RunMetadata.FunctionGraphs]:
        """This is only populated for graphs that are run as functions in TensorFlow
        V2. There will be an entry below for each function that is traced.
        The main use cases of the post_optimization_graph and the partition_graphs
        is to give the caller insight into the graphs that were actually run by the
        runtime. Additional information (such as those in step_stats) will match
        these graphs.
        We also include the pre_optimization_graph since it is usually easier to
        read, and is helpful in situations where the caller wants to get a high
        level idea of what the built graph looks like (since the various graph
        optimization passes might change the structure of the graph significantly).
        """
    @property
    def session_metadata(self) -> global___SessionMetadata:
        """Metadata about the session."""
    def __init__(
        self,
        *,
        step_stats: tensorflow.core.framework.step_stats_pb2.StepStats | None = ...,
        cost_graph: tensorflow.core.framework.cost_graph_pb2.CostGraphDef | None = ...,
        partition_graphs: collections.abc.Iterable[tensorflow.core.framework.graph_pb2.GraphDef] | None = ...,
        function_graphs: collections.abc.Iterable[global___RunMetadata.FunctionGraphs] | None = ...,
        session_metadata: global___SessionMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cost_graph", b"cost_graph", "session_metadata", b"session_metadata", "step_stats", b"step_stats"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cost_graph", b"cost_graph", "function_graphs", b"function_graphs", "partition_graphs", b"partition_graphs", "session_metadata", b"session_metadata", "step_stats", b"step_stats"]) -> None: ...

global___RunMetadata = RunMetadata

@typing_extensions.final
class TensorConnection(google.protobuf.message.Message):
    """Defines a connection between two tensors in a `GraphDef`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_TENSOR_FIELD_NUMBER: builtins.int
    TO_TENSOR_FIELD_NUMBER: builtins.int
    from_tensor: builtins.str
    """A tensor name. The value of this tensor will be substituted for
    the tensor named in `to_tensor`.
    """
    to_tensor: builtins.str
    """A tensor name. The value of this tensor will be bound to the
    value of the tensor named in `from_tensor`.
    """
    def __init__(
        self,
        *,
        from_tensor: builtins.str | None = ...,
        to_tensor: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["from_tensor", b"from_tensor", "to_tensor", b"to_tensor"]) -> None: ...

global___TensorConnection = TensorConnection

@typing_extensions.final
class CallableOptions(google.protobuf.message.Message):
    """Defines a subgraph in another `GraphDef` as a set of feed points and nodes
    to be fetched or executed.

    Compare with the arguments to `Session::Run()`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class FeedDevicesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class FetchDevicesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    FEED_FIELD_NUMBER: builtins.int
    FETCH_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    RUN_OPTIONS_FIELD_NUMBER: builtins.int
    TENSOR_CONNECTION_FIELD_NUMBER: builtins.int
    FEED_DEVICES_FIELD_NUMBER: builtins.int
    FETCH_DEVICES_FIELD_NUMBER: builtins.int
    FETCH_SKIP_SYNC_FIELD_NUMBER: builtins.int
    @property
    def feed(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tensors to be fed in the callable. Each feed is the name of a tensor."""
    @property
    def fetch(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Fetches. A list of tensor names. The caller of the callable expects a
        tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
        order of specified fetches does not change the execution order.
        """
    @property
    def target(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Target Nodes. A list of node names. The named nodes will be run by the
        callable but their outputs will not be returned.
        """
    @property
    def run_options(self) -> global___RunOptions:
        """Options that will be applied to each run."""
    @property
    def tensor_connection(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TensorConnection]:
        """Tensors to be connected in the callable. Each TensorConnection denotes
        a pair of tensors in the graph, between which an edge will be created
        in the callable.
        """
    @property
    def feed_devices(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The Tensor objects fed in the callable and fetched from the callable
        are expected to be backed by host (CPU) memory by default.

        The options below allow changing that - feeding tensors backed by
        device memory, or returning tensors that are backed by device memory.

        The maps below map the name of a feed/fetch tensor (which appears in
        'feed' or 'fetch' fields above), to the fully qualified name of the device
        owning the memory backing the contents of the tensor.

        For example, creating a callable with the following options:

        CallableOptions {
          feed: "a:0"
          feed: "b:0"

          fetch: "x:0"
          fetch: "y:0"

          feed_devices: {
            "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
          }

          fetch_devices: {
            "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
         }
        }

        means that the Callable expects:
        - The first argument ("a:0") is a Tensor backed by GPU memory.
        - The second argument ("b:0") is a Tensor backed by host memory.
        and of its return values:
        - The first output ("x:0") will be backed by host memory.
        - The second output ("y:0") will be backed by GPU memory.

        FEEDS:
        It is the responsibility of the caller to ensure that the memory of the fed
        tensors will be correctly initialized and synchronized before it is
        accessed by operations executed during the call to Session::RunCallable().

        This is typically ensured by using the TensorFlow memory allocators
        (Device::GetAllocator()) to create the Tensor to be fed.

        Alternatively, for CUDA-enabled GPU devices, this typically means that the
        operation that produced the contents of the tensor has completed, i.e., the
        CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
        cuStreamSynchronize()).
        """
    @property
    def fetch_devices(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    fetch_skip_sync: builtins.bool
    """By default, RunCallable() will synchronize the GPU stream before returning
    fetched tensors on a GPU device, to ensure that the values in those tensors
    have been produced. This simplifies interacting with the tensors, but
    potentially incurs a performance hit.

    If this options is set to true, the caller is responsible for ensuring
    that the values in the fetched tensors have been produced before they are
    used. The caller can do this by invoking `Device::Sync()` on the underlying
    device(s), or by feeding the tensors back to the same Session using
    `feed_devices` with the same corresponding device name.
    """
    def __init__(
        self,
        *,
        feed: collections.abc.Iterable[builtins.str] | None = ...,
        fetch: collections.abc.Iterable[builtins.str] | None = ...,
        target: collections.abc.Iterable[builtins.str] | None = ...,
        run_options: global___RunOptions | None = ...,
        tensor_connection: collections.abc.Iterable[global___TensorConnection] | None = ...,
        feed_devices: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        fetch_devices: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        fetch_skip_sync: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["run_options", b"run_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["feed", b"feed", "feed_devices", b"feed_devices", "fetch", b"fetch", "fetch_devices", b"fetch_devices", "fetch_skip_sync", b"fetch_skip_sync", "run_options", b"run_options", "target", b"target", "tensor_connection", b"tensor_connection"]) -> None: ...

global___CallableOptions = CallableOptions
